
(* ---------------------------------------------------------------
Title         Q&D L1 cache ON/OFF
Author        PhG
Overview      self-explanatory !
Usage         L1 <on|off>
Notes         
Bugs          
Wish List

--------------------------------------------------------------- *)

MODULE L1;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096, unfixDirectory;

IMPORT Lib;
IMPORT Str;
IMPORT IO;
IMPORT SYSTEM;

FROM IO IMPORT WrStr, WrLn;

(* ------------------------------------------------------------ *)

CONST
    DEBUG = FALSE;
CONST
    ProgEXEname   = "L1";
    ProgTitle     = "Q&D L1 cache ON/OFF";
    ProgVersion   = "v1.1a";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errTooManyParms = 3;
    errBadParm      = 4;
    errCPU          = 5;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
(*
       00000000011111111112222222222333333333344444444445555555555666666666677777777778
       1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
WrLn;
WrStr(Banner);WrLn;
WrLn;
WrStr("Syntax : "+ProgEXEname+" <on|off> [-override]");WrLn;
WrLn;
WrStr("Note crash is almost guaranteed when disabling L1 cache with EMM386 !");WrLn;
    | errOption :
        Str.Concat(S,"Option ",str128(einfo));
        Str.Append(S," is illegal !");
    | errTooManyParms :
        S := "Too many parameters in command line !";
    | errBadParm :
        Str.Concat(S,"Parameter ",str128(einfo));
        Str.Append(S," is illegal !");
    | errCPU :
        S := "CPU must be a 486 or better !";
    ELSE
        S := "This is illogical, Captain !"; (* "How Can Such A Thing B(i)e(rce) ???" *)
    END;
    IF (e <> errNone) AND (e <> errHelp) THEN
        WrLn;
        WrStr(ProgEXEname+" : ");
        WrStr(S);
        WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

TYPE code60 = ARRAY [1..60] OF BYTE;

(*# save *)
(*# call(inline_max=>66) *)

INLINE PROCEDURE CacheEnable () = code60 (
090H,090H,090H,090H,090H,090H,090H,090H,
090H,090H,090H,090H,090H,090H,090H,090H,
090H,090H,090H,090H,090H,090H,090H,090H,
090H,090H,090H,090H,090H,090H,090H,090H,
053H,066H,050H,066H,09CH,0FAH,0BBH,037H,
001H,00FH,020H,0C0H,066H,025H,0FFH,0FFH,
0FFH,09FH,00FH,022H,0C0H,00FH,009H,066H,
09DH,066H,058H,05BH
);

INLINE PROCEDURE CacheDisable () = code60 (
090H,090H,090H,090H,090H,090H,090H,090H,
090H,090H,090H,090H,090H,090H,090H,090H,
090H,090H,090H,090H,090H,090H,090H,090H,
090H,090H,090H,090H,090H,090H,090H,090H,
053H,066H,050H,066H,09CH,0FAH,0BBH,037H,
001H,00FH,020H,0C0H,066H,00DH,000H,000H,
000H,060H,00FH,022H,0C0H,00FH,009H,066H,
09DH,066H,058H,05BH
);

(*# call(inline=>off) *)
(*# restore *)

(* ------------------------------------------------------------ *)

VAR
    parmcount : CARDINAL;
    i         : CARDINAL;
    S         : str128;
    R         : str128;
    opt       : CARDINAL;
    cmd       : (enable,disable);
    CPUtype   : Lib.CpuRec;
    force     : BOOLEAN;
BEGIN
    Lib.DisableBreakCheck();

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;
    IF parmcount>2 THEN abort(errTooManyParms,""); END; (* was >1 *)

    force := FALSE;

    FOR i := 1 TO parmcount DO (* for future extension ! *)
        Lib.ParamStr(S,i);
        RtrimBlanks(S); (* prevent JPI bug with last parameter+tab ! *)
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R)=TRUE THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "ON"+delim+"E"+delim+"ENABLE"+delim+
                                 "OFF"+delim+"D"+delim+"DISABLE"+delim+
                                 "O"+delim+"OVERRIDE"+delim+
                                 "F"+delim+"FORCE"
                                 );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5,6 : cmd := enable;
            | 7,8,9 : cmd := disable;
            | 10,11 : force := TRUE;
            | 12,13 : force := TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            Str.Prepend(R,"-"); (* fake option *)
            opt := GetOptIndex(R,"ON"+delim+"E"+delim+"ENABLE"+delim+
                                 "OFF"+delim+"D"+delim+"DISABLE");
            CASE opt OF
            | 1,2,3 : cmd := enable;
            | 4,5,6 : cmd := disable;
            ELSE
                abort(errBadParm,S);
            END;
        END;
    END;
    IF force THEN
        S:="Without checking CPU, internal cache has been ";
    ELSE
        Lib.CpuId(CPUtype);
        IF CPUtype.cpu # Lib.cpu_Unknown THEN abort(errCPU,""); END;
        S := "Internal cache has been ";
    END;

    CASE cmd OF
    | enable :
        CacheEnable;
        Str.Append(S,"enabled !");
    | disable :
        CacheDisable;
        Str.Append(S,"disabled !");
    END;
    WrLn;
    WrStr(S);
    WrLn;
    abort(errNone,"");
END L1.

