MODULE SHADEMO;

IMPORT FIO;
IMPORT Str;
IMPORT Lib;
IMPORT IO;

FROM IO IMPORT WrLn,WrStr;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits;

(* ------------------------------------------------------------ *)

(*
3.13s
3.02s using inline directive
3.17s using inline xor !
3.35s after recompiling !
*)

CONST
    DEBUG = FALSE;

PROCEDURE hexW ( v:LONGCARD ):str16;
VAR
    R:str16;
    ok:BOOLEAN;
    i:CARDINAL;
BEGIN
    Str.CardToStr(v, R, 16, ok);
    FOR i:=Str.Length(R)+1 TO 8 DO Str.Prepend(R,"0");END;
    RETURN R;
END hexW;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* FIPS PUB 180-1 keeping varnames, and without any optimization *)

CONST
    firstdigestndx = 0;
    lastdigestndx  = 19; (* 5 dwords = 20 bytes = 160 bits *)
TYPE
    SHAstr = ARRAY [0..39] OF CHAR; (* 20 bytes = 40 hex digits *)
    statetype = RECORD
        CASE : BOOLEAN OF
        | TRUE : H0,H1,H2,H3,H4 : LONGCARD;
        | FALSE: digest : ARRAY [firstdigestndx..lastdigestndx] OF BYTE;
        END;
    END;
    count64type = RECORD
        lo,hi:LONGCARD;
    END;
    SHAcontextType = RECORD
        state : statetype;   (* H0 H1 H2 H3 H4 *)
        count : count64type; (* bits modulo 2^64 *)
    END;
CONST
    firstround    = 1-1;             (* 0 *)
    lastround     = (20*4)-1;        (* 79 *)
    lastroundbyte = (20*4*4)-1;      (* 319 *)
TYPE
    SHAcombotype = RECORD
        CASE : BOOLEAN OF
        | TRUE : dw : ARRAY [firstround..lastround] OF LONGCARD;
        | FALSE: b  : ARRAY [firstround..lastroundbyte] OF BYTE;
        END;
    END;
    blocktype = RECORD
        CASE : BOOLEAN OF
        | TRUE : dw : ARRAY [0..15] OF LONGCARD;
        | FALSE: b  : ARRAY [0..63] OF BYTE;     (* 512 bits = 64 bytes = 16 dwords *)
        END;
    END;
    ptrToBlockType = POINTER TO blocktype; (* no generic POINTER type ! *)
CONST
    BLOCKSIZE = SIZE (blocktype);

VAR
    K : ARRAY [firstround..lastround] OF LONGCARD;
    W : SHAcombotype;

PROCEDURE SHAinit (VAR ctx:SHAcontextType;bytecount:LONGCARD);
VAR
    t,i,j : CARDINAL;
    V : LONGCARD;
BEGIN
    ctx.state.H0 := 067452301H;
    ctx.state.H1 := 0EFCDAB89H;
    ctx.state.H2 := 098BADCFEH;
    ctx.state.H3 := 010325476H;
    ctx.state.H4 := 0C3D2E1F0H;

    t:=firstround;
    FOR i:=1 TO 4 DO
        CASE i OF
        | 1 : V:=05A827999H; (*  0..19 *)
        | 2 : V:=06ED9EBA1H; (* 20..39 *)
        | 3 : V:=08F1BBCDCH; (* 40..59 *)
        | 4 : V:=0CA62C1D6H; (* 60..79 *)
        END;
        FOR j:=1 TO 20 DO K[t]:=V; INC(t); END;
    END;

(*%T DEBUG  *)
    FOR t:= 0 TO 79 DO
        WrStr("K["); IO.WrCard(t,2);WrStr("] = ");WrStr(hexW(K[t]));WrLn;
    END;
(*%E  *)

    ctx.count.lo:=bytecount << 3;      (* x8 : bytes to bits *)
    ctx.count.hi:=bytecount >> (32-3); (* keep 3 upper bits *)
END SHAinit;

PROCEDURE SHAflip (VAR ctx:SHAcontextType);
VAR
    t,j : CARDINAL;
    b : ARRAY [0..3] OF BYTE;
BEGIN
    FOR t:= firstdigestndx TO lastdigestndx BY 4 DO
        FOR j:=0 TO 3 DO b[j]:=ctx.state.digest[t+j];END;
        ctx.state.digest[t+0] := b[3];
        ctx.state.digest[t+1] := b[2];
        ctx.state.digest[t+2] := b[1];
        ctx.state.digest[t+3] := b[0];
    END;
END SHAflip;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize      = (8 * 512) + FIO.BufferOverhead;
    firstioBufferByte = 1;
    lastioBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstioBufferByte..lastioBufferByte] OF BYTE;
VAR
    sourceBuffer : ioBufferType;

CONST
    firstDataByte = 1-1; (* yes, it's 0 *)
    lastDataByte  = 8*512-1; (* 4Kb *)
    dataBufferSize= lastDataByte - firstDataByte + 1;
TYPE
    dataBufferType = ARRAY [firstDataByte..lastDataByte+BLOCKSIZE] OF BYTE; (* 4Kb+64 *)
VAR
    dataBuffer : dataBufferType; (* globerk *)

(* ------------------------------------------------------------ *)

(*# save *)
(*# call (inline_max => 8192)  *)
(*# call (inline=>on)  *)

PROCEDURE xor (v1,v2 : LONGCARD  ) : LONGCARD;
TYPE
    dBITSET = SET OF [0..31];
BEGIN
    RETURN LONGCARD( dBITSET(v1) / dBITSET(v2) );
END xor;

PROCEDURE ROTATE_LEFT( x, n: LONGCARD):LONGCARD ;
BEGIN
    RETURN  ( (x << n) OR (x >> (32-n)) );
END ROTATE_LEFT;

PROCEDURE F00 (VAR v:LONGCARD; B,C,D:LONGCARD);
BEGIN
    v:= (B AND C)  OR  ((NOT (B)) AND D);
END F00;

PROCEDURE F20 (VAR v:LONGCARD; B,C,D:LONGCARD);
BEGIN
    v:=xor(B,C);
    v:=xor(v,D);
END F20;

PROCEDURE F40 (VAR v:LONGCARD; B,C,D:LONGCARD);
BEGIN
    v:= (B AND C)  OR  (B AND D)  OR  (C AND D);
END F40;

PROCEDURE F60 (VAR v:LONGCARD; B,C,D:LONGCARD);
BEGIN
    v:=xor(B,C);
    v:=xor(v,D);
END F60;

(*# restore *)

(* ------------------------------------------------------------ *)

(* p points to data which are to become W[0]...W[15] *)

PROCEDURE SHAtransform (VAR state:statetype; pBlock:ptrToBlockType);
VAR
    A,B,C,D,E : LONGCARD;
    TEMP, v : LONGCARD;
    t:CARDINAL;
BEGIN
    (* don't forget to reverse bytes of each longcard ! *)
    FOR t:= 0 TO 63 BY 4 DO
        W.b[t+0] := pBlock^.b[t+3];
        W.b[t+1] := pBlock^.b[t+2];
        W.b[t+2] := pBlock^.b[t+1];
        W.b[t+3] := pBlock^.b[t+0];
    END;
(*%T DEBUG  *)
    FOR t:= 0 TO 15 DO
        WrStr("W["); IO.WrCard(t,2);WrStr("] = ");WrStr(hexW(W.dw[t]));WrLn;
    END;
(*%E  *)

    FOR t := 16 TO 79 DO
        v       := xor ( W.dw[t-3] , W.dw[t-8]);
        v       := xor ( v         , W.dw[t-14]);
        v       := xor ( v         , W.dw[t-16]);
        W.dw[t] := ROTATE_LEFT( v, 1);
    END;

    A:= state.H0;
    B:= state.H1;
    C:= state.H2;
    D:= state.H3;
    E:= state.H4;

(*# save *)
(*# call (inline_max => 8192)  *)
(*# call (inline=>on)  *)
    FOR t := 0 TO 79 DO
        TEMP := ROTATE_LEFT(A,5);
        CASE t OF                    (* no speed gain from splitting here *)
        |  0..19 : F00( v, B,C,D);
        | 20..39 : F20( v, B,C,D);
        | 40..59 : F40( v, B,C,D);
        | 60..79 : F60( v, B,C,D);
        END;
        INC( TEMP, v );
        INC( TEMP, E );
        INC( TEMP, W.dw[t] );
        INC( TEMP, K[t] );

        E    := D;
        D    := C;
        C    := ROTATE_LEFT(B,30);
        B    := A;
        A    := TEMP;

(*%T DEBUG *)
        WrStr("t = "); IO.WrCard(t,2);
        WrStr(": ");  WrStr(hexW(A));
        WrStr("    ");WrStr(hexW(B));
        WrStr("    ");WrStr(hexW(C));
        WrStr("    ");WrStr(hexW(D));
        WrStr("    ");WrStr(hexW(E));WrLn;
(*%E  *)
    END;
(*# restore *)

    INC(state.H0,A);
    INC(state.H1,B);
    INC(state.H2,C);
    INC(state.H3,D);
    INC(state.H4,E);
END SHAtransform;

(* ------------------------------------------------------------ *)

PROCEDURE SHAhashbuffer (VAR ctx:SHAcontextType; count:CARDINAL);
VAR
    j,t,ndx:CARDINAL; (* assume less than 64Kb buffer *)
    b : ARRAY [0..3] OF BYTE;
BEGIN
    SHAinit(ctx, LONGCARD(count));
    dataBuffer[count]:=080H; (* always pad with at least a binary 1 *)
    INC(count);
    WHILE (count MOD 64) # 56 DO (* pad to multiple of 512 bits, minus reserved for count thus 448+64 *)
        dataBuffer[count]:=0;
        INC(count);
    END;

    Lib.Move(     ADR(ctx.count.hi), ADR(dataBuffer[count]), 4);
    Lib.Move(     ADR(ctx.count.lo), ADR(dataBuffer[count+4]), 4);

    FOR t:= count TO count+8 BY 4 DO
        FOR j:=0 TO 3 DO b[j]:=dataBuffer[t+j];END;
        dataBuffer[t+0] := b[3];
        dataBuffer[t+1] := b[2];
        dataBuffer[t+2] := b[1];
        dataBuffer[t+3] := b[0];
    END;

    ndx:=0;
    INC(count,8);
    REPEAT
        SHAtransform( ctx.state, ADR( dataBuffer[ndx] ) );
        INC(ndx, BLOCKSIZE);
    UNTIL ndx = count;
    SHAflip(ctx);
END SHAhashbuffer;

(* assume file exists ! *)

PROCEDURE SHAhashfile (VAR ctx:SHAcontextType;S:ARRAY OF CHAR   );
VAR
    hin:FIO.File;
    ndx:CARDINAL; (* assume less than 64Kb buffer *)
    j,t,got:CARDINAL;
    done:BOOLEAN;
    b:ARRAY[0..3] OF BYTE;
BEGIN
    hin:=FIO.OpenRead(S);
    FIO.AssignBuffer(hin,sourceBuffer);
    done:=FALSE;
    SHAinit(ctx, FIO.Size(hin));
    REPEAT
        got:=FIO.RdBin(hin,dataBuffer,dataBufferSize);
        IF got # dataBufferSize THEN
            dataBuffer[got]:= 080H;
            INC(got);
            WHILE (got MOD 64) # 56 DO
                dataBuffer[ got ] := 0;
                INC(got);
            END;

            Lib.Move(     ADR(ctx.count.hi), ADR(dataBuffer[got]), 4);
            Lib.Move(     ADR(ctx.count.lo), ADR(dataBuffer[got+4]), 4);

    FOR t:= got TO got+8 BY 4 DO
        FOR j:=0 TO 3 DO b[j]:=dataBuffer[t+j];END;
        dataBuffer[t+0] := b[3];
        dataBuffer[t+1] := b[2];
        dataBuffer[t+2] := b[1];
        dataBuffer[t+3] := b[0];
    END;

            INC(got,8);
            done:=TRUE;
        END;
        ndx:=0;
        REPEAT
            SHAtransform( ctx.state, ADR( dataBuffer[ndx] ) );
            INC(ndx, BLOCKSIZE);
        UNTIL ndx=got;
    UNTIL done;
    FIO.Close(hin);
    SHAflip(ctx);
END SHAhashfile;

(* ------------------------------------------------------------ *)

CONST
    maphex = "0123456789abcdef"; (* already beautified for readability *)

(* 20 bytes to 40 chars *)

PROCEDURE SHAtoString (VAR R:SHAstr; state:statetype);
VAR
    i,v : CARDINAL;
    lo,hi:CHAR;
BEGIN
    Str.Copy(R,"");
    FOR i:=firstdigestndx TO lastdigestndx DO
        v:=CARDINAL( state.digest[i] );
        lo:=maphex[ v AND 0FH];
        hi:=maphex[ v >> 4 ];
        Str.Append(R,hi);
        Str.Append(R,lo);
    END;
END SHAtoString;

(* ------------------------------------------------------------ *)

PROCEDURE wrquoted (S:ARRAY OF CHAR );
BEGIN
    WrStr('"'); WrStr(S); WrStr('"');
END wrquoted;

PROCEDURE chkSHA(dostring,cr:BOOLEAN; S,expected:ARRAY OF CHAR);
VAR
     count:CARDINAL;
     R:SHAstr;
     ctx : SHAcontextType;
BEGIN
     IF dostring THEN
         count:=Str.Length(S);
         Lib.Move( ADR(S), ADR(dataBuffer), count);
         SHAhashbuffer(ctx,count);
         WrStr("string    : ");wrquoted(S);WrLn;
     ELSE
         IF FIO.Exists(S) THEN
             SHAhashfile(ctx,S);
             WrStr("file      : ");WrStr(S);WrLn;
         END;
     END;
     WrStr("expected  : ");WrStr(expected);WrLn;
     WrStr("computed  : ");
     SHAtoString(R,ctx.state);
     WrStr(R);WrLn;
     IF cr THEN WrLn;END;
END chkSHA;

CONST
    testfile = "TESTSHA.$$$";
    testlen  = 1000000;
VAR
    hnd:FIO.File;
    i:CARDINAL;
    count:LONGCARD;
BEGIN
    WrLn;

    WrStr("SHA-1 test suite");WrLn;

    IF Lib.ParamCount() = 0 THEN

        WrLn;

        chkSHA ( TRUE,TRUE,"abc",
                 "a9993e364706816aba3e25717850c26c9cd0d89d");

        chkSHA ( TRUE,TRUE,"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq",
                 "84983e441c3bd26ebaae4aa1f95129e5e54670f1");
(*
        chkSHA ( TRUE,"The quick brown fox jumps over the lazy dog",
                 "2fd4e1c67a2d28fced849ee1bb76e7391b93eb12");
*)
        hnd:= FIO.Create(testfile);
        FOR count := 1 TO testlen DIV 20 DO
            FIO.WrStr(hnd,"aaaaaaaaaaaaaaaaaaaa"); (* 20 chars *)
        END;
        FIO.Close(hnd);
        chkSHA ( FALSE,FALSE,testfile,
                 "34aa973cd4c4daa4f61eeb2bdbad27316534016f");
        FIO.Erase(testfile);
(*
        chkSHA ( FALSE,"vb30.arj",
                 "81d0f91e989410d1ac6a562e1b5f9b0267f9f2fd");
*)
    END;

HALT;
END SHADEMO.

