
(* ---------------------------------------------------------------
Title         Q&D Sound
Author        PhG
Overview      replace awful BIOS' default ^G bip
Notes
Bugs
Wish List

--------------------------------------------------------------- *)

MODULE Sound;

IMPORT Lib;
IMPORT Str;

FROM IO IMPORT WrStr,WrLn;

TYPE
    str80 = ARRAY [0..79] OF CHAR;

(* ------------------------------------------------------------ *)

PROCEDURE abort (errcode:CARDINAL);
BEGIN
    Lib.SetReturnCode(SHORTCARD(errcode));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE GetVal (S : ARRAY OF CHAR) : CARDINAL;
VAR
    ok : BOOLEAN;
    v  : LONGCARD;
BEGIN
    v := Str.StrToCard(S,10,ok);
    IF ok = FALSE THEN
        WrStr("StrToCard does not like <");
        WrStr(S);
        WrStr("> parameter !");
        abort(2);
    END;
    IF v > MAX(CARDINAL) THEN
        WrStr("Parameter <");
        WrStr(S);
        WrStr("> is not a CARDINAL !");
        abort(3);
    END;
    RETURN CARDINAL(v);
END GetVal;

(* ------------------------------------------------------------ *)

VAR
    S         : str80;
    ok        : BOOLEAN;
    frequency : CARDINAL;
    delay     : CARDINAL;
    pause     : CARDINAL;
    i,n       : CARDINAL;
BEGIN
    WrLn;
    n:=Lib.ParamCount();
    IF (n = 0) OR ((n MOD 3)#0) THEN
        WrStr("Q&D Sound v1.0 by PhG");WrLn;
        WrLn;
        WrStr("Syntax : SOUND [<frequency> <delay> <pause>]...");WrLn;
        WrLn;
        WrStr("Specify frequency in Hertz, and delay and pause in milliseconds.");WrLn;
        abort(1);
    END;
    FOR i:= 1 TO n BY 3 DO
        Lib.ParamStr(S,i);
        frequency := GetVal(S);
        Lib.ParamStr(S,i+1);
        delay := GetVal(S);
        Lib.ParamStr(S,i+2);
        pause := GetVal(S);

        Lib.Sound(frequency);
        Lib.Delay(delay);
        Lib.NoSound();
        Lib.Delay(pause);
    END;
    abort(0);
END Sound.


