(* ---------------------------------------------------------------
Title         Q&D Extended Choice
Author        PhG
Overview      query user for keypress or input
Notes
Bugs
Wish List     are you kidding ? ;-)
              reinvent the wheel (and yet another PSP walker) so that
              user can assign an input string to a master environment var ?
              bah, we'd never use this feature anyway...

--------------------------------------------------------------- *)

MODULE xChoice;

IMPORT Lib;
IMPORT Str;
IMPORT BiosIO;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

(* ------------------------------------------------------------ *)

CONST
    space         = " ";
    tab           = CHR(9);
    esc           = CHR(27);
    doublequote   = '"';
    singlequote   = "'";
    equal         = "=";
    colon         = ":";
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;
    strDefaultKeys= "YN";
    strPauseRange = "[1..900]";
    minpause      = 1;
    maxpause      = 60*15; (* 15 minutes SHOULD do ! *)
CONST
    ProgEXEname   = "XCHOICE";
    ProgTitle     = "Q&D Extended Choice";
    ProgVersion   = "v1.0d";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    errNone               = 128;
    errHelp               = 129;
    errPauseRange         = 130;
    errBadNumber          = 131;
    errBadCombo           = 132;
    errDefaultKeyNotFound = 133;
    errNonsenseInput      = 134;
    errBadAlias           = 135;
    errNonsenseAlias      = 136;
    errAliasKeyNotFound   = 137;
    errOption             = 138;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msgHelp =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" [option]... [message]"+nl+
nl+
'  -c:$    user-defined choice keys (default is "'+strDefaultKeys+'")'+nl+
'  -n      do not display choice keys and "?" after message'+nl+
"  -s      make choice keys selection case-sensitive (accents still ignored)"+nl+
"  -t:?,#  default to specified choice key after # seconds pause ("+strPauseRange+")"+nl+
"  -w:?,#  shortcut for -t:?,# -v"+nl+
"  -tt:?,# shortcut for -t:?,# -v"+nl+
"  -v      show countdown"+nl+
"  -e:?    assume specified choice key if Escape key was pressed"+nl+
"  -r:?    assume specified choice key if Return key was pressed"+nl+
'  -a      alternate prompt format (" ? " instead of M$ default "?")'+nl+
"  -i      input mode (default is keypress mode)"+nl+
"  -q      do not beep on unexpected choice"+nl+
"  -z      do not show selected key after message"+nl+
nl+
"This program emulates CHOICE utility."+nl+
"ERRORLEVEL is set to the 1-based offset of the key pressed by user."+nl+
"Optional message must be specified after options (if any) :"+nl+
"as it will be displayed verbatim, it should best be kept short"+nl+
"so that message and prompt together still fit screen line width."+nl+
"Though it is not an obligation, message should be enclosed with double quotes"+nl+
'(thus allowing it to begin with either "-" or "/" characters).'+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrLn;
        WrStr(msgHelp);
    | errPauseRange :
        S:="Pause must be in the "+strPauseRange+" !";
    | errBadNumber:
        Str.Concat(S,"Illegal number in ",einfo);Str.Append(S," option !");
    | errBadCombo:
        Str.Concat(S,einfo," option does not match expected -t:?,# format !");
    | errDefaultKeyNotFound:
        S:="Key specified with -t:?,# option was not found among choice keys !";
    | errNonsenseInput:
        S:="-i and ~  options are mutually exclusive !";
        Str.Subst(S,"~",einfo);
    | errBadAlias:
        Str.Concat(S,einfo," option should specify a single character !");
    | errNonsenseAlias:
        S:="-i and ~ options are mutually exclusive !";
        Str.Subst(S,"~",einfo);
    | errAliasKeyNotFound:
        S:="Key specified with ~ option was not found among choice keys !";
        Str.Subst(S,"~",einfo);
    | errOption:
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | 0..127 :
        ;
    | errNone, errHelp :
        ;
    ELSE
        WrLn;
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;

    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE getCommandLine (VAR S : ARRAY OF CHAR);
VAR
    i : CARDINAL;
BEGIN
    i := 0;
    LOOP
        S[i] := Lib.CommandLine^[i];
        IF S[i] = CHR(0) THEN EXIT; END; (* $00 is kept *)
        INC(i);
    END;
END getCommandLine;

PROCEDURE strToNum ( VAR n:CARDINAL; S:ARRAY OF CHAR  ):BOOLEAN;
VAR
    lc:LONGCARD;
    ok:BOOLEAN;
BEGIN
    lc:=Str.StrToCard(S,10,ok);
    IF ok THEN
        ok:=(lc <= MAX(CARDINAL));
        IF ok THEN n:=CARDINAL(lc);END;
    END;
    RETURN ok;
END strToNum;

PROCEDURE parseKeyPause (VAR defaultkey:CHAR; VAR pause:CARDINAL;
                        mini,maxi:CARDINAL;R:ARRAY OF CHAR):CARDINAL;
VAR
    Z : str16;
    rc:CARDINAL;
BEGIN
    GetString(R,Z); (* ?,# *)
    IF Str.Match(Z,"?,*") THEN
        defaultkey := Z[0];
        Str.Delete(Z,0,2); (* remove "?," *)
        IF strToNum(pause,Z) THEN
            IF ( (pause < mini) OR (pause > maxi) ) THEN
                rc:=errPauseRange;
            ELSE
                rc:=errNone;
            END;
        ELSE
            rc:=errBadNumber;
        END;
    ELSE
        rc:=errBadCombo;
    END;
    RETURN rc;
END parseKeyPause;

PROCEDURE fmtcard (v : CARDINAL; field:INTEGER ) : str80;
CONST
    pad = " ";
    sep = "";
VAR
    S,R   : str80;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.CardToStr(LONGCARD(v),S,10,ok);
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmtcard;

PROCEDURE sound (freq,duration,pause:CARDINAL);
BEGIN
    Lib.Sound(freq);
    Lib.Delay(duration);
    Lib.NoSound();
    Lib.Delay(pause);
END sound;

PROCEDURE errbip (okbeep:BOOLEAN);
CONST
    freq     = 55;
    duration = 55; (* was 300 *)
    tempo    = 100;
BEGIN
    IF okbeep THEN sound (freq,duration,tempo); END;
END errbip;

(* //v1.0d fix for -?:* -?=* *)

PROCEDURE altGetString (s : ARRAY OF CHAR; VAR r : ARRAY OF CHAR);
VAR
    p:CARDINAL;
BEGIN
    IF CharCount(s,colon) = 0 THEN
        Str.Subst(s,equal,colon); (* command line option xxx= becomes xxx: *)
    END;
    p := Str.CharPos(s,colon); (* exclude MAX(CARDINAL) here! ;-) *)
    Str.Delete(s,0,p+1);
    Str.Copy (r, s);
END altGetString;

(* ------------------------------------------------------------ *)

CONST
    patEnclosedA= doublequote+"*"+doublequote; (* "*" *)
    patEnclosedB= singlequote+"*"+singlequote; (* '*' *)
    wicountdown = 1; (* was -4 *)
    placeholder = CHR(7); (* unlikely key ! *)
    what        = ' : "'+placeholder+'"';
    whatnum     = " : "+placeholder;
    strCLI      = "::: Command line  "+what;
    strOPT      = "::: Option        "+what;
    strRAW      = "::: Raw allowed   "+what;
    strCOOKED   = "::: Cooked allowed"+what;
    strDEBUG    = "::: Raw key       "+what+nl+
                  "::: Cooked key    "+what+nl+
                  "::: ERRORLEVEL    "+whatnum;
VAR
    debug : BOOLEAN;
    showkeys,casesensitive,allowdefault,allowEsc,allowRet,showselected:BOOLEAN;
    okbeep,useinput,showcountdown : BOOLEAN;
    prompt,S,R,RR,cli,allowedkeys : str128;
    i,rc,opt,pause:CARDINAL;
    ch,defaultkey,aliasEsckey,aliasRetkey,gluesep:CHAR;
    orgch:str16; (* we may need a key description here *)
    h,m,s,ss,remaining:CARDINAL;
    start,now,previous : LONGINT;
BEGIN
    Lib.EnableBreakCheck; (* was disable *)

    gluesep          := ""; (* match ugly M$ CHOICE *)
    allowedkeys      := "";
    showkeys         := TRUE;
    casesensitive    := FALSE;
    allowdefault     := FALSE;
    allowEsc         := FALSE;
    allowRet         := FALSE;
    useinput         := FALSE;
    showcountdown    := FALSE;
    okbeep           := TRUE;
    (* safety *)
    defaultkey       := space;
    aliasEsckey      := space;
    aliasRetkey      := space;
    showselected     := TRUE;
    debug            := FALSE;

    getCommandLine(cli);

    LOOP
        LtrimBlanks(cli);
        (*
        IF debug THEN
            RR:=strCLI;
            Str.Subst(RR,placeholder,cli);
            WrStr(RR);WrLn;
        END;
        *)
        IF isOption(cli) THEN (* command line starts with "-" or "/" *)
            isoleItemS(S,cli,space+tab,0); (* original case *)
            IF debug THEN
                RR:=strOPT;
                Str.Subst(RR,placeholder,S);
                WrStr(RR);WrLn;
            END;
            Str.Copy(R,S);
            UpperCase(R);
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+

                                  "C:"+delim+"CHOICES:"+delim+
                                  "N"+delim+"NOREMINDER"+delim+
                                  "S"+delim+"SENSITIVE"+delim+
                                  "T:"+delim+"DEFAULT:"+delim+

                                  "E:"+delim+"ESCAPE:"+delim+
                                  "I"+delim+"INPUT"+delim+
                                  "V"+delim+"SHOWCHRONO"+delim+
                                  "W:"+delim+"WAIT:"+delim+"TT:"+delim+
                                  "A"+delim+"ALTERNATE"+delim+
                                  "Q"+delim+"QUIET"+delim+
                                  "R:"+delim+"RETURN:"+delim+"ENTER:"+delim+
                                  "Z"+delim+"ZAP"+delim+
                                  "DEBUG"
                                  );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5   : altGetString(S,allowedkeys); (* no check *)
            | 6,7   : showkeys      := FALSE;
            | 8,9   : casesensitive := TRUE;
            |10,11  : rc:=parseKeyPause(defaultkey,pause, minpause,maxpause,S);
                      IF rc # errNone THEN abort(rc,R);END;
                      allowdefault  := TRUE;

            |12,13  : GetString(S,RR);
                      IF Str.Length(RR) # 1 THEN abort(errBadAlias,R);END;
                      aliasEsckey   := RR[0];
                      allowEsc      := TRUE;
            |14,15  : useinput      := TRUE;
            |16,17  : showcountdown := TRUE;
            |18,19,20:rc:=parseKeyPause(defaultkey,pause, minpause,maxpause,S);
                      IF rc # errNone THEN abort(rc,R);END;
                      allowdefault  := TRUE;
                      showcountdown := TRUE;
            |21,22  : gluesep       := space;
            |23,24  : okbeep        := FALSE;
            |25,26,27:GetString(S,RR);
                      IF Str.Length(RR) # 1 THEN abort(errBadAlias,R);END;
                      aliasRetkey   := RR[0];
                      allowRet      := TRUE;
            |28,29  : showselected  := FALSE;
            |30     : debug         := TRUE;
            ELSE
                (* EXIT; (* unknown option may be message ! *) *)
                abort(errOption,S);
            END;
        ELSE
            EXIT; (* not an option *)
        END;
        Str.Delete(cli,0,Str.Length(R)); (* remove frontal option *)
    END;

    RtrimBlanks(cli);
    i:=0;
    IF Str.Match(cli,patEnclosedA) THEN INC(i);END;
    IF Str.Match(cli,patEnclosedB) THEN INC(i);END;
    IF i # 0 THEN
        Str.Delete(cli, Str.Length(cli)-1,1);
        Str.Delete(cli, 0, 1);
    END;

    IF same(allowedkeys,"") THEN allowedkeys:=strDefaultKeys;END;

    IF debug THEN
        S:=strRAW;
        Str.Subst(S,placeholder,allowedkeys);
        WrStr(S);WrLn;
    END;

    IF NOT (casesensitive) THEN
        LowerCase(allowedkeys);
        LowerCase(defaultkey);
        LowerCase(aliasEsckey);
        LowerCase(aliasRetkey);
    END;

    IF debug THEN
        S:=strCOOKED;
        Str.Subst(S,placeholder,allowedkeys);
        WrStr(S);WrLn;
    END;

    IF allowdefault THEN
        IF Str.CharPos(allowedkeys,defaultkey)=MAX(CARDINAL) THEN
           abort(errDefaultKeyNotFound,"");
        END;
        IF useinput THEN abort(errNonsenseInput,"-<t|w>:?,#");END;
    END;
    IF allowEsc THEN
        IF Str.CharPos(allowedkeys,aliasEsckey)=MAX(CARDINAL) THEN
           abort(errAliasKeyNotFound,"-e:?");
        END;
        IF useinput THEN abort(errNonsenseAlias,"-e:?");END;
    END;
    IF allowRet THEN
        IF Str.CharPos(allowedkeys,aliasRetkey)=MAX(CARDINAL) THEN
           abort(errAliasKeyNotFound,"-r:?");
        END;
        IF useinput THEN abort(errNonsenseAlias,"-r:?");END;
    END;
    IF showselected = FALSE THEN
        IF useinput THEN abort(errNonsenseInput,"-z");END;
    END;
    (* step 1 : let's build prompt *)

    R:="";
    IF Str.Length(cli) # 0 THEN
        Str.Append(R,cli);
        IF showkeys THEN Str.Append(R,gluesep);END; (* don't glue : it's prettier *)
    END;
    IF showkeys THEN
        Str.Append(R,"[");
        Str.Append(R,allowedkeys[0]);
        FOR i:=2 TO Str.Length(allowedkeys) DO
            Str.Append(R,",");
            Str.Append(R,allowedkeys[i-1]);
        END;
        Str.Append(R,"]");
        Str.Append(R,gluesep);
        Str.Append(R,"?");
        Str.Append(R,gluesep);
    END;

    Str.Copy(prompt,R);

    (* step 2 : let's wait for user input *)

    IF useinput THEN
        LOOP
            WrStr(prompt);
            TerminalReadString(R);
            IF Str.Length(R)=1 THEN
                ch:=R[0];
                Str.Copy(orgch,ch);
                IF NOT(casesensitive) THEN LowerCase(ch);END;
                opt:=Str.CharPos(allowedkeys,ch);
                IF opt # MAX(CARDINAL) THEN EXIT; END;
            END;
            errbip(okbeep);
        END;
    ELSE
        WHILE BiosIO.KeyPressed() DO
            ch := BiosIO.RdKey();
            IF ch = CHR(0) THEN ch:=BiosIO.RdKey();END;
        END;
        WrStr(prompt);
        IF allowdefault THEN
            remaining := pause;
            Lib.GetTime(h,m,s,ss);
            start := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
            previous := start;
            Str.Concat(RR," ",fmtcard(remaining,wicountdown));
            IF showcountdown THEN video(RR,TRUE); END;
        END;
        LOOP
            IF BiosIO.KeyPressed() THEN
                ch := BiosIO.RdKey();
                CASE ch OF
                | CHR(0) :
                    (* we'll ignore function keys *)
                    ch:=BiosIO.RdKey();
                ELSE
                    Str.Copy(orgch,ch);
                    CASE ch OF
                    | esc :
                        IF allowEsc THEN ch:=aliasEsckey;orgch:="ESCAPE";END; (* already cased *)
                    | cr :
                        IF allowRet THEN ch:=aliasRetkey;orgch:="RETURN";END; (* already cased *)
                    ELSE
                        IF NOT(casesensitive) THEN LowerCase(ch);END;
                    END;
                    opt:=Str.CharPos(allowedkeys,ch);
                    IF opt # MAX(CARDINAL) THEN EXIT; END;
                END;
                errbip(okbeep);
            END;
            IF allowdefault THEN
                Lib.GetTime(h,m,s,ss);
                now := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
                IF now > previous THEN
                    IF showcountdown THEN video(RR,FALSE); END;
                    previous := now;
                    DEC(remaining);
                    Str.Concat(RR," ",fmtcard(remaining,wicountdown));
                    IF showcountdown THEN video(RR,TRUE); END;
                END;
                IF ABS(now-start) >= LONGINT(pause) THEN
                    ch:=defaultkey;
                    orgch:="DEFAULT"; (* fake ! *)
                    opt:=Str.CharPos(allowedkeys,defaultkey);
                    EXIT;
                END;
            END;
        END;
        IF allowdefault THEN
            IF showcountdown THEN video(RR,FALSE);END;
        END;
        IF showselected THEN WrStr(ch); END;
        WrLn;
    END;

    INC(opt); (* string is 0-based but we want character position *)

    IF debug THEN
        S:=strDEBUG;
        Str.Subst(S,placeholder, orgch);
        Str.Subst(S,placeholder, ch);
        Str.Subst(S,placeholder, fmtcard(opt,wicountdown) );
        WrStr(S);WrLn;
    END;

    abort( opt, "");
END xChoice.

