(* ---------------------------------------------------------------
Title         Q&D Fletcher
Author        PhG
Overview      self-explanatory !
Notes

              slow basic     : $67A9  $EEA9  Elapsed  : 00:00:50.86
              fast basic+asm : $67A9  $EEA9  Elapsed  : 00:00:02.09
              slow modula    : $67A9  $EEA9  Elapsed  : 00:00:03.02
              medium modula  : $67A9  $EEA9  Elapsed  : 00:00:02.31
              fast modula    : $67A9  $EEA9  Elapsed  : 00:00:01.86

                           cache     NO      YES
              ioBufferSize 32        2.64    2.52
                           16        2.75    2.42
                            8        2.96    2.91

Bugs
Wish List

--------------------------------------------------------------- *)

IMPLEMENTATION MODULE QD_FCS;

IMPORT FIO;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize      = (8 * 512) + FIO.BufferOverhead; (* 8 is enough *)
    firstioBufferByte = 1;
    lastioBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstioBufferByte..lastioBufferByte] OF BYTE;
VAR
    sourceBuffer : ioBufferType;
CONST
    firstDataByte = 0;
    lastDataByte  = 8*512-1; (* was 32 ! *)
    DataBufferSize= lastDataByte - firstDataByte + 1;
TYPE
    dataBufferType = ARRAY [firstDataByte..lastDataByte] OF BYTE;
VAR
    dataBuffer : dataBufferType;

(* ------------------------------------------------------------ *)

CONST
    slow  =FALSE;
    medium=FALSE;
    fast  =TRUE;

(* ------------------------------------------------------------ *)

(* assume S exists *)

(*%T slow *)

CONST
    speed = "Slow";

PROCEDURE ComputeFletcherCheckSum (S:ARRAY OF CHAR;VAR cs,cszero:CARDINAL);
CONST
    initialValue = CARDINAL(0000H);
VAR
    hnd:FIO.File;
    i,got:CARDINAL;
    sum1,sum2:CARDINAL;
    sumzero1,sumzero2:CARDINAL;
BEGIN
    sum1 := initialValue;
    sum2 := initialValue;
    hnd:=FIO.OpenRead(S);
    FIO.AssignBuffer(hnd,sourceBuffer);
    LOOP
        got:=FIO.RdBin(hnd,dataBuffer,DataBufferSize);
        IF got = 0 THEN EXIT; END;
        FOR i:= firstDataByte TO (got-1) DO
            sum1 := ( sum1 + CARDINAL ( dataBuffer[i] ) ) MOD 255;
            sum2 := ( sum2 + sum1 ) MOD 255;
        END;
        IF got # DataBufferSize THEN EXIT; END;
    END;
    FIO.Close(hnd);
    sumzero1 := 255 - ((sum1 + sum2) MOD 255);
    sumzero2 := 255 - ((sum1 + sumzero1) MOD 255);
    cs    := 256 * sum1 + sum2;
    cszero:= 256 * sumzero1 + sumzero2;
END ComputeFletcherCheckSum;

(*%E *)

(* ------------------------------------------------------------ *)

(*%T medium *)

(* about twice as fast as previous method *)

CONST
    speed = "Medium";

PROCEDURE ComputeFletcherCheckSum (S:ARRAY OF CHAR;VAR cs,cszero:CARDINAL);
CONST
    initialValue = CARDINAL(0000H);
VAR
    hnd:FIO.File;
    i,got:CARDINAL;
    sum1,sum2:CARDINAL;
    sumzero1,sumzero2:CARDINAL;
BEGIN
    sum1 := initialValue;
    sum2 := initialValue;
    hnd:=FIO.OpenRead(S);
    FIO.AssignBuffer(hnd,sourceBuffer);
    LOOP
        got:=FIO.RdBin(hnd,dataBuffer,DataBufferSize);
        IF got = 0 THEN EXIT; END;
        FOR i:= firstDataByte TO (got-1) DO
            INC(sum1, CARDINAL ( dataBuffer[i] ) );
            IF sum1 >= 255 THEN DEC(sum1, 255); END;
            INC(sum2, sum1);
            IF sum2 >= 255 THEN DEC(sum2, 255); END;
        END;
        IF got # DataBufferSize THEN EXIT; END;
    END;
    FIO.Close(hnd);
    sumzero1 := 255 - ((sum1 + sum2) MOD 255);
    sumzero2 := 255 - ((sum1 + sumzero1) MOD 255);
    cs    := 256 * sum1 + sum2;
    cszero:= 256 * sumzero1 + sumzero2;
END ComputeFletcherCheckSum;

(*%E *)

(* ------------------------------------------------------------ *)

(*%T fast *)

CONST
    speed = "Fast";

PROCEDURE ComputeFletcherCheckSum (S:ARRAY OF CHAR;VAR cs,cszero:CARDINAL);
CONST
    initialValue = 0000H;
VAR
    hnd:FIO.File;
    i,got:CARDINAL;
    sum1:CARDINAL;
    sum2:LONGCARD;
    sumzero1,sumzero2:CARDINAL;
BEGIN
    sum1 := initialValue;
    sum2 := initialValue;
    hnd:=FIO.OpenRead(S);
    FIO.AssignBuffer(hnd,sourceBuffer);
    LOOP
        got:=FIO.RdBin(hnd,dataBuffer,DataBufferSize);
        IF got = 0 THEN EXIT; END;
        FOR i:= firstDataByte TO (got-1) DO
            INC(sum1, CARDINAL ( dataBuffer[i] ) );
            IF sum1 >= 255 THEN DEC(sum1, 255); END;
            INC(sum2, LONGCARD(sum1) );
        END;
        sum2 := sum2 MOD 255;
        IF got # DataBufferSize THEN EXIT; END;
    END;
    FIO.Close(hnd);
    sumzero1 := 255 - ((sum1 + CARDINAL(sum2) ) MOD 255);
    sumzero2 := 255 - ((sum1 + sumzero1) MOD 255);
    cs    := 256 * sum1 + CARDINAL(sum2);
    cszero:= 256 * sumzero1 + sumzero2;
END ComputeFletcherCheckSum;

(*%E *)

(* ------------------------------------------------------------ *)

(* ------------------------------------------------------------ *)

BEGIN
END QD_FCS.




