@echo off
set qdlist=lire.com

if exist title.exe title

rem This executable is illegal : it was spread by dishonest Patrice Guinard
if exist cura.exe del cura.exe

cls
echo.
echo : ****************************************************************
echo : Quick demonstration of QD AstroTools main programs and features
echo : ****************************************************************
echo.

echo : First, you must specify the correction required to compute
echo : Universal Time (U.T.) from your PC system clock, by defining
echo : the POUR_TU environment variable (very loosely similar to Unix TZ).
echo : To do so, add to your AUTOEXEC.BAT file a line similar to this one :
echo :    SET POUR_TU=-2h
echo : In this example, we specify U.T. to be computed by substracting
echo : 2 hours from system clock. Normal corrections required in the U.S.A.
echo : are likely to be additions, such as :
echo :    SET POUR_TU=+5h
echo : (this is the value we'll use in this quick demo).
echo.
pause

echo on
SET POUR_TU=+5h
@echo off
echo.

echo : To compute a new chart, you must first find the geographical coordinates
echo : (latitude and longitude) of the place of birth :
echo :     ATLAS town
echo : Please note that the ATLAS program has an option to use phonetics.
echo.
pause

echo on
atlas paris
@echo off
echo.

echo : Then, you must find the correction required to compute Universal Time
echo : (U.T.) from legal date and time of birth :
echo :     TU dd/mm/yyyy hh:mm
echo : Please note that the TU program is for French births only !
echo : For other countries, you will have to find required correction yourself.
echo : Remember data is not necessarily right because it is written in a book :
echo : always try to double-check the correction required to compute U. T. !

echo.
pause
echo on
tu 28/12/31 17h
@echo off
echo.

echo : Now, you can compute the natal chart :
echo :     THEME dd/mm/yyyy hh:mm correction latitude longitude chartfile
echo : Chart filename has at most 8 characters, default extension is .THM.
echo : You can specify an optional double-quote delimited string
echo : to save the following comma-separated informations :
echo : "town,country,name,sex,remarks".
echo : Please note that DOS command line is limited to about 126 characters :
echo : the MODIFIER program allows later editing of the informations.
echo.
pause
echo on
theme -o 28/12/31 17:00 0h 48n50 0h9m21e test "Paris,France,Guy-Ernest Debord,H,subversif officiel"
@echo off
echo.

echo : You can generate a DOS text file report :
echo :     RAPPORT chartfile
echo : Report will have .RPT extension.
echo : You can use any file viewer (LIST) or text editor (DOS/Windows) to read it.
echo : After you have read the report, hit ESC to go back to demo.
echo.
pause
echo on
call setmode n
echo on
rapport test /o
%qdlist% test.rpt
@echo off
cls
echo.

echo : You can generate a DOS text file conditionalist report :
echo :     RET chartfile
echo : Report will have .RPT extension.
echo : You can use any file viewer (LIST) or text editor (DOS/Windows) to read it.
echo : After you have read the report, hit ESC to go back to demo.
echo.
pause
echo on
call setmode r
echo on
ret test pl ur ma sa so ve me lu ju ne /o /m
call setmode n
echo on
%qdlist% test.rpt
@echo off
cls
echo.

echo : You can see the graphical natal chart :
echo :     CARTE chartfile
echo : When in program, hit "?" key to see help, TAB to change view,
echo : and ESC to go back to demo.
echo : (now, active parameters are "conditionalist")
echo.
pause
echo on
call setmode r
carte test
@echo off
cls
echo.

echo : Modifying the look of maps is easy, with SETMODE command or,
echo : even better, by modifying parameters in .RSC resource files.
echo : Here is an exemple :
echo :     CARTE chartfile
echo : When in program, hit "?" key to see help, TAB to change view,
echo : and ESC to go back to demo.
echo : (now, active parameters are "traditional")
echo.
pause
echo on
call setmode n
carte test
@echo off
cls
echo.

echo : You can compute a report of transits for any date and time :
echo :     TRANSITS dd/mm/yyyy hh:mm chartfile
echo : Report will have .TXT extension.
echo : If you specify "* *" for date and time, transits will be computed
echo : for current date and time (using system clock and POUR_TU variable).
echo : After you have read the report, hit ESC to go back to demo.
echo.
pause
echo on
transits * * test /o
%qdlist% test.txt
@echo off
cls
echo.

echo : You can also see transits graphically :
echo :     CARTETR dd/mm/yyyy hh:mm charfile
echo : When in program, hit "?" key to see help, TAB to change view,
echo : and ESC to go back to demo.

echo.
pause
echo on
cartetr * * test
@echo off
cls
echo.

echo : The SIGNAUX program allows a clear view of all transits for a long interval :
echo :     SIGNAUX dd/mm/yyyy dd/mm/yyyy hh:mm interval chartfile
echo : Report will have .CSV extension.
echo : After you have read the report, hit ESC to go back to demo.
echo.
pause
echo on
signaux 1/1/1968 31/12/1968 0h 20 test /o 
%qdlist% test.csv
@echo off
cls
echo.

echo : The CHERCHER programs allows you to search for specific criteria
echo : (for exemple, find all charts with the Sun in Aquarius) :
echo :     CHERCHER chartfile criterium...
echo : After you have read the report, hit ESC to go back to demo.
echo.
pause
echo on
chercher * (pluton codominante) et (mercure terre) > test.lst
%qdlist% test.lst

del test.*


@echo off
cls
echo.

echo : The LISTE program displays charts in current directory :
echo :     LISTE *
echo.
pause
echo on
liste * /n
@echo off
echo.

echo : The COMPARER and CARTECO programs are used to compare two charts.
echo : The MODIFIER program allows editing of a chart informations
echo : (town, country, name, sex and remarks).
echo.
echo : Please read at least once the text files LISEZMOI.TXT
echo : (or LISEZMOI.WRI) and SYNTAXE.TXT !
echo : Oops, sorry, this is for French-speaking users ! ;-)
echo.
rem set POUR_TU=
set qdlist=
