
(* ---------------------------------------------------------------
Title         Q&D Make DEF
Author        PhG
Overview
Notes         model must be Compact or more
              general idea is :
              reprer [implementation] module xxx
              crer definition module xxx
              reprer les squences mme sur plusieurs lignes de
              PROCEDURE ( [:;]-- ) [:]-- ;
              prendre garde aux remarques, directives et chanes (bugs)

Bugs          cannot handle things like "PROCEDURE () ; IN lib;" but who cares ?
              still unable to parse itself anyway !
Wish List
--------------------------------------------------------------- *)

MODULE MakeDEF;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;
IMPORT IO;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, cleantabs;

(* ------------------------------------------------------------ *)

CONST
    blank     = " ";
    dash      = "-";
    slash     = "/";
    equal     = "=";
    doubledot = ":";
    comma     = ",";
    cr        = CHR(13);
    lf        = CHR(10);
    tab       = CHR(9);

(* ------------------------------------------------------------ *)

CONST
    debug         = FALSE;
    beta          = CHR(225);
    ProgEXEname   = "MAKEDEF";
    ProgTitle     = "Q&D Make DEF file from MOD file";
    ProgVersion   = "v1.1a"; (* +beta *)
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

    ExtDEF        = ".DEF";
    ExtMOD        = ".MOD";
    ExtBAK        = ".{DE";

CONST
    nada           = "";
    errNone        = 0;
    errHelp        = 1;
    errUnknown     = 2;
    errTooManySpex = 3;
    errTooManyFiles = 4;
    errNoMatchFile  = 5;
    errMissingSpec  = 6;
    errRange        = 7;
    errCPU          = 8;

    errNotCardinal = 254;
    errConversion  = 255;

(* save and optimize _seems_ ok whether in or out of procedure *)

PROCEDURE abort (e : CARDINAL; info : ARRAY OF CHAR);
CONST
    nl = cr+lf;
(*
0        1         2         3         4         5         6         7         8
12345678901234567890123456789012345678901234567890123456789012345678901234567890
*)
    msgHelp = Banner+nl+
nl+
"Syntax : "+ProgEXEname+" <file(s)["+ExtMOD+"]> [option]..."+nl+
nl+
"This very, very, very Q&D program builds .DEF file(s) from .MOD file(s)"+nl+
nl+
"  -r   keep remark just preceding PROCEDURE"+nl+
"  -p   pack lines (no CRLF between headers)"+nl+
"  -f   force program code to be parsed as if it was a module"+nl+
"  -w=# specify IMPORT list width in characters (default is 70)"+nl+
"  -v   verbose PROCEDURE listing while working"+nl;

VAR
    S : str128;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msgHelp);
    | errUnknown :
        Str.Concat(S,"Unknown '",info);
        Str.Append(S,"' option !");
    | errTooManySpex :
        Str.Concat(S,"With '",info);
        Str.Append (S,"', too many file specifications !");
    | errTooManyFiles :
        Str.Concat(S,"Too many files match '",info);
        Str.Append(S,"' specification !");
    | errNoMatchFile :
        Str.Concat(S,"No file matches '",info);
        Str.Append(S,"' specification !");
    | errMissingSpec :
        S := "Missing file specification !";
    | errRange :
        S := "Bad range for width parameter !";
    | errCPU :
        Str.Concat(S,"Sorry, this program requires at least an ",info);
        Str.Append(S," to run !");

    | errNotCardinal :
        Str.Concat(S,"'",info);
        Str.Append(S,"' is not a CARDINAL !");
    | errConversion :
        Str.Concat(S,"'",info);
        Str.Append(S,"' forces a StrToCard error !");
    ELSE
        S := "How did you get THERE ?";
    END;
    CASE e OF
    | errNone, errHelp :
        ;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

(* Str.Subst replaces only first occurrence *)
PROCEDURE Replace (VAR s:ARRAY OF CHAR; target:CHAR; new:CHAR );
(*
VAR
    p : CARDINAL;
BEGIN
    LOOP
        p:=Str.CharPos(s,target);
        IF p = MAX(CARDINAL) THEN EXIT; END;
        s[p] := new;
    END;
*)
BEGIN
    Str.Subst(s,target,new);
END Replace;

PROCEDURE DmpTTX (hnd:FIO.File;
                  VAR s:ARRAY OF CHAR;
                  maxcount:CARDINAL);     (* 79 *)
VAR
    begpos: CARDINAL;
    count : CARDINAL;
    advance:CARDINAL;
    t : str80; (* never more than 80 chars *)
    i : CARDINAL;
BEGIN
    begpos:=0;
    LOOP
       count:=maxcount;
       advance:=maxcount;
       IF (begpos+count) < Str.Length(s) THEN (* not the last line to print *)
            LOOP
                IF s[begpos+count]=blank THEN (* found first space backwards *)
                    advance:=count+1;   (*' position after space *)
                    EXIT;
                END;
                DEC(count);
                IF count= 0 THEN (* no space at all in line to print *)
                    count:=maxcount;
                    EXIT;
                END;
            END;
       END;
       Str.Slice (t,s,begpos,count); (* slice good portion *)
       FIO.WrStr(hnd,t);
       FIO.WrLn(hnd);
       INC(begpos,advance); (* skip space if any *)
       IF begpos >= Str.Length(s) THEN EXIT; END;
    END;
END DmpTTX;

(* ------------------------------------------------------------ *)

PROCEDURE GetCardinal (s : ARRAY OF CHAR) : CARDINAL;
VAR
    p : CARDINAL;
    v : LONGCARD;
    ok : BOOLEAN;
BEGIN
    Replace(s,equal,doubledot); (* command line option xxx= becomes xxx: *)
    p := Str.CharPos(s,doubledot); (* MAX(CARDINAL) already excluded! *)
    Str.Delete(s,0,p+1);
    v:=Str.StrToCard(s,10,ok);
    IF ok = FALSE THEN abort(errConversion,s); END;
    IF v > MAX(CARDINAL) THEN abort(errNotCardinal,s); END;
    RETURN CARDINAL(v);
END GetCardinal;

PROCEDURE Appears (string,what:ARRAY OF CHAR;VAR p : CARDINAL) : BOOLEAN;
BEGIN
    p := Str.Pos(string,what);
    IF p # MAX(CARDINAL) THEN
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END Appears;

(* ------------------------------------------------------------ *)

CONST
    IObufferSize = (8 * 512) + FIO.BufferOverhead; (* 4Kb is enough, 16Kb was oversized and useless *)
    firstIObufferByte = 1;
    lastIObufferByte  = IObufferSize;
VAR
    IObufferIn : ARRAY [firstIObufferByte..lastIObufferByte] OF BYTE; (* for private M2 IO *)
    hndi    : FIO.File;
    IObufferOut: ARRAY [firstIObufferByte..lastIObufferByte] OF BYTE; (* for private M2 IO *)
    hndo   : FIO.File;

(* ------------------------------------------------------------ *)
CONST
    (*
       each word is delimited by any characters except
       a digit, a letter, an underbar or a '.'
       this filter only leaves keywords without attached delimiters
    *)
    Filter = Str.CHARSET{ 0C..CHAR(255) } -
             Str.CHARSET{ 'A'..'Z','a'..'z','_','0'..'9','.' };

    (* this filter keeps keywords with attached delimiters *)
    Filter2 = Str.CHARSET{ cr,lf,tab,blank};

PROCEDURE TokenAppears (VAR line:ARRAY OF CHAR;lookedfor:ARRAY OF CHAR  ): BOOLEAN;
VAR
    wordpos:CARDINAL;
    word : str80; (* should be enough! *)
BEGIN
    wordpos := 0;
    LOOP
        Str.Item(word,line,Filter,wordpos);
        IF (word[0] = 0C) THEN
            RETURN FALSE;
        END; (* Check that there was a word *)
        IF Str.Compare(word,lookedfor)=0 THEN
            RETURN TRUE;
        END;
        INC(wordpos);
    END;
END TokenAppears;

(* ------------------------------------------------------------ *)

CONST
    openREM 	   = "(*";
    closeREM 	   = "*)";
    procedure 	   = "PROCEDURE";
    pragma1         = openREM+"%";
    pragma2         = openREM+"#";
CONST
    firstline = 1;
    lastline  = 32;
VAR
    kept : ARRAY [firstline..lastline] OF str256;
    nextline : CARDINAL;
    state : (waiting,inremark,after);

PROCEDURE InitStack ();
BEGIN
    nextline := firstline;
    state := waiting;
END InitStack;

PROCEDURE Push (VAR s:ARRAY OF CHAR); (* var is faster but do not touch! *)
BEGIN
    IF nextline <= lastline THEN (* could abort but... *)
        Str.Copy(kept[nextline],s);
        INC(nextline);
    ELSE
        nextline := firstline; (* lose every previous stacked lines *)
    END;
END Push;

PROCEDURE IsStackEmpty (  ) : BOOLEAN;
BEGIN
    IF nextline = firstline THEN
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END IsStackEmpty;

PROCEDURE Dump (hndo : FIO.File);
VAR
    i:CARDINAL ;
BEGIN
    IF IsStackEmpty()=FALSE THEN
        FOR i:=firstline TO (nextline-1) DO
            FIO.WrStr(hndo,kept[i]);
            FIO.WrLn(hndo);
        END;
    END;
    InitStack();
END Dump;

PROCEDURE ProcessREM (VAR s : ARRAY OF CHAR); (* var is faster but do not touch! *)
VAR
    pragmahere : BOOLEAN;
    beghere : BOOLEAN;
    endhere : BOOLEAN;
    p : CARDINAL;
BEGIN
    IF Appears(s,procedure,p) THEN
         Push(s);
         state := waiting;
         RETURN;
    END;
    pragmahere :=( Appears(s,pragma1,p) OR Appears(s,pragma2,p) );

    CASE pragmahere OF
    | TRUE :               (* force to false *)
        beghere := FALSE;
        endhere := FALSE;
    | FALSE :
        beghere := Appears(s,openREM,p);
        endhere := Appears(s,closeREM,p);
    END;
    CASE state OF
    | waiting :
         CASE beghere OF
         | TRUE :
             CASE endhere OF
             | TRUE :
                 InitStack();  (*    /* --- */     *)
                 Push(s);
                 state := after;
             | FALSE :         (*    /* ---        *)
                 Push(s);
                 state := inremark;
             END;
         | FALSE :
             CASE endhere OF   (*       --- */     ILLOGICAL! *)
             | TRUE :
             | FALSE :         (*       ---        *)
             END;
         END;
    | inremark :
         CASE beghere OF
         | TRUE :
             CASE endhere OF
             | TRUE :          (*    /* --- */     *)
                 Push(s);
             | FALSE :         (*    /* ---        *)
                 InitStack();
                 Push(s);
             END;
         | FALSE :
             CASE endhere OF
             | TRUE :          (*      --- */      *)
                 Push(s);
                 state := after;
             | FALSE :         (*      ---         *)
                 Push(s);
             END;
         END;
    | after :
         CASE beghere OF
         | TRUE :
             CASE endhere OF
             | TRUE :          (*    /* --- */     *)
                 InitStack();
                 Push(s);
                 state := after; (* keep same state! *)
             | FALSE :         (*    /* ---        *)
                 InitStack();
                 Push(s);
                 state := inremark;
             END;
         | FALSE :
             CASE endhere OF
             | TRUE :          (*       --- */     ILLOGICAL! *)
                 Push(s);
             | FALSE :         (*       ---        *)
                 Push(s);
             END;
         END;
    END;
END ProcessREM;

(* ------------------------------------------------------------ *)

PROCEDURE IsBlank (c : CHAR) : BOOLEAN;
CONST
    Blanks = cr+lf+tab+blank;
BEGIN
    IF Str.CharPos(Blanks,c) = MAX(CARDINAL) THEN
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END IsBlank;

PROCEDURE IsDelimiter (c : CHAR) : BOOLEAN;
CONST
    Delimiters = "(),=+-*<>/\[]^:;_.";
BEGIN
    IF Str.CharPos(Delimiters,c) = MAX(CARDINAL) THEN
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END IsDelimiter;

(* filename is already in upper case *)
(* this is a VERY VERY VERY QUICK & DIRTY procedure *)

PROCEDURE Process (modfile : ARRAY OF CHAR;
                   keepREM,skipCR,verbose,relax : BOOLEAN;
                   listwidth : CARDINAL);
CONST
    sImplementation= "IMPLEMENTATION";
    sModule 	   = "MODULE";
    openparen 	   = "(";
    closeparen 	   = ")";
    semicolon 	   = ";";
    sDefinition    = "DEFINITION";
    enddef         = "END";
    dot 	       = ".";
    DoubleQuote	   = CHR(34);
    SingleQuote	   = "'";
    frommod        = "FROM ";
    importproc     = " IMPORT";
VAR
    unit : str16;
    path : str256;
    f8 : str16;
    e3 : str16;

    deffile : str256;
    bakfile : str256;
    line    : str256;
    procname : str256;
    token : str256;
    wordpos : CARDINAL;
    header : str256;
    p      : CARDINAL;
    flagIN : BOOLEAN;
    liste : str1024; (* should be enough! *)
    msg:str128;
BEGIN
    Str.Concat(msg,"Processing ",modfile);
    video(msg,TRUE);

    Str.Copy(liste,nada);
    Str.Copy(deffile,modfile);
    Str.Copy(bakfile,modfile);
    Lib.SplitAllPath(modfile,unit,path,f8,e3);  (* e3 contains . so length is 4 *)
    Str.Subst(deffile,e3,ExtDEF);
    Str.Subst(bakfile,e3,ExtBAK);
    IF FIO.Exists(deffile) = TRUE THEN
        IF FIO.Exists(bakfile) = TRUE THEN
            FIO.Erase(bakfile);
        END;
        FIO.Rename(deffile,bakfile);
    END;
    hndi := FIO.OpenRead(modfile);
    FIO.AssignBuffer(hndi,IObufferIn);
    hndo:= FIO.Create(deffile);
    FIO.AssignBuffer(hndo,IObufferOut);

(* ------------------------------------------------------------ *)

(*
assume here very, very, very basic code structure!!! ;-)
absolutely no error checking for bad structure!!!
assume source file is relatively correct -- no systematic EOF check
*)

    (* if relax TRUE, do not take implementation into account *)
    LOOP
        FIO.RdStr(hndi,header);
        IF FIO.EOF = TRUE THEN EXIT; END;
        (* find IMPLEMENTATION MODULE line *)
        IF Appears(header,sModule,p) THEN
            CASE relax OF
            | TRUE :
                 (* write DEFINITION MODULE line *)
                 Str.Prepend (header,sDefinition+blank);
                 FIO.WrStr(hndo,header);
                 FIO.WrLn(hndo);
                 FIO.WrLn(hndo);
                 EXIT;
            | FALSE :
                 IF Appears(header,sImplementation,p) THEN
                     (* write DEFINITION MODULE line *)
                     Str.Subst (header,sImplementation,sDefinition);
                     FIO.WrStr(hndo,header);
                     FIO.WrLn(hndo);
                     FIO.WrLn(hndo);
                     EXIT;
                 END;
            END;
        END;
    END;
    IF keepREM = TRUE THEN InitStack(); END;
    LOOP
        FIO.RdStr(hndi,line);
        IF FIO.EOF = TRUE THEN EXIT; END;
        IF keepREM = TRUE THEN ProcessREM(line); END;
        (* find PROCEDURE line *)
        IF Appears(line,procedure,p) THEN
            Str.Copy(procname,line);
            IF keepREM = TRUE THEN
                 IF skipCR = TRUE THEN FIO.WrLn(hndo); END;
                 Dump(hndo); (* includes PROCEDURE line too *)
            ELSE
                 FIO.WrStr(hndo,line);
                 FIO.WrLn(hndo);
            END;
            Str.Subst(line,pragma1,nada); (* avoid confusion! *)
            Str.Subst(line,pragma2,nada);
            Str.Subst(line,openREM,nada); (* q&d hack as not to confuse openREM with ( but not guaranteed! *)
            (* q&d check for procedures with parameters! *)
            IF Appears(line,openparen,p) THEN
                (* find next closeparen... and hope there's no comment in line! *)
                LOOP
                    Str.Subst(line,closeREM,nada); (* q&d hack as not to confuse closeREM with ) but not guaranteed! *)
                    IF Appears(line,closeparen,p) THEN EXIT; END;
                    FIO.RdStr(hndi,line);
                    FIO.WrStr(hndo,line);
                    FIO.WrLn(hndo);
                END;
                (* last closeparen was found at p in line, now find last semicolon *)
                Str.Delete(line,0,p+1); (* 1 is ) len *)
                LOOP
                    IF Appears(line,semicolon,p) THEN EXIT; END;
                    FIO.RdStr(hndi,line);
                    FIO.WrStr(hndo,line);
                    FIO.WrLn(hndo);
                END;
            ELSE
                (* here, PROCEDURE without openparen, therefore find last semicolon *)
                (* assume logical layout!!! *)
                LOOP
                    IF Appears(line,semicolon,p) THEN EXIT; END;
                    FIO.RdStr(hndi,line);
                    FIO.WrStr(hndo,line);
                    FIO.WrLn(hndo);
                END;
            END;
            IF skipCR = FALSE THEN FIO.WrLn(hndo); END;

            (* here we should read till the end of the PROCEDURE *)
            (* but check first for special case of PROCEDURE IN *)

            flagIN := TokenAppears(procname,"IN");

            p:= Str.Pos(procname,procedure);
            Str.Delete(procname,0,p+Str.Length(procedure));
            (* retrieve token right after PROCEDURE *)
            Str.Item(procname,procname,Filter,0);
            (* add it to future import list *)
            Str.Append(liste,blank);
            Str.Append(liste,procname);
            Str.Append(liste,comma);
            IF verbose THEN
                video(msg,FALSE);
                WrStr("    "); WrStr(procname); WrLn;
                video(msg,TRUE);
            END;
            IF flagIN = FALSE THEN
                LOOP
                    FIO.RdStr(hndi,line);
                    IF FIO.EOF THEN EXIT; END;
                    Str.Item(token,line,Filter,0); (* try END *)
                    Str.Item(line,line,Filter,1); (* try procname *)
                    IF Str.Compare(token,enddef)=0 THEN
                       IF Str.Compare(line,procname)=0 THEN EXIT; END; (* end proc *)
                    END;
                END;
            END;
        END;
    END;
    IF skipCR = TRUE THEN FIO.WrLn(hndo); END;
    Str.Subst(header,sDefinition,nada);
    Str.Subst(header,sModule,enddef);
    Str.Subst(header,semicolon,dot);
    Ltrim(header,blank);
    (* write END line *)
    FIO.WrStr(hndo,header);
    FIO.WrLn(hndo);
    FIO.WrLn(hndo);

    (* generate here in a comment the FROM module IMPORT procs *)

    Str.Subst(header,enddef,nada);
    Str.Subst(header,dot,nada);
    Ltrim(header,blank);
    Rtrim(header,blank);
    FIO.WrStr(hndo,openREM);
    FIO.WrLn(hndo);
    IF skipCR=FALSE THEN FIO.WrLn(hndo);END;
    (* reverse order *)
    Str.Prepend(liste,importproc);
    Str.Prepend(liste,header);
    Str.Prepend(liste,frommod);
    p:=Str.RCharPos(liste,comma);
    liste[p] := semicolon;
    DmpTTX(hndo,liste,listwidth);
    IF skipCR=FALSE THEN FIO.WrLn(hndo); END;
    FIO.WrStr(hndo,closeREM);
    FIO.WrLn(hndo);

(* ------------------------------------------------------------ *)

    FIO.Flush(hndo);
    FIO.Close(hndi);
    FIO.Close(hndo);

    video(msg,FALSE);
    WrStr("Created ");WrStr(deffile);WrStr(" from ");WrStr(modfile);WrLn;
END Process;

(* ------------------------------------------------------------ *)

VAR
    parmcount   : CARDINAL;
    i       : CARDINAL;
    S       : str128;
    opt     : CARDINAL;
    flagREM     : BOOLEAN;
    flagPack    : BOOLEAN;
    flagVerbose : BOOLEAN;
    flagForce   : BOOLEAN;
    flagSpec    : BOOLEAN;
    filespec : str256;
    unit     : str128; (* 2 chars *)
    path     : str256;
    f8       : str128; (* 8 chars *)
    e3       : str128; (* 4 chars *)
    tmpunit  : str128; (* 2 chars *)
    tmppath  : str256;
    width    : CARDINAL;
CONST
    firstFile    = 1;
    maxFile      = 500;
    minWidth     = 20;
    maxWidth     = 254;
    defaultwidth = 70;
VAR
    filename  : ARRAY [firstFile..maxFile] OF str16;
    fileCount : CARDINAL;
    found     : BOOLEAN;
    Entry     : FIO.DirEntry;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    WrLn;

    flagREM := FALSE;
    flagPack := FALSE;
    flagVerbose := FALSE;
    flagForce := FALSE;
    width := defaultwidth;
    flagSpec:= FALSE;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort (errHelp,nada); END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        cleantabs(S);
        IF isOption(S) THEN
            UpperCase (S);
            opt := GetOptIndex (S,"?"+delim+"H"+delim+"HELP"+delim+
                                  "R"+delim+"REM"+delim+"REMARK"+delim+
                                  "P"+delim+"PACK"+delim+"NOCR"+delim+
                                  "V"+delim+"VERBOSE"+delim+
                                  "F"+delim+"FORCE"+delim+
                                  "W:"+delim+"WIDTH:");
            CASE opt OF
            | 1,2,3 : abort(errHelp,nada);
            | 4,5,6 : flagREM := TRUE;
            | 7,8,9 : flagPack := TRUE;
            | 10,11 : flagVerbose := TRUE;
            | 12,13 : flagForce := TRUE;
            | 14,15 :
                 width := GetCardinal(S);
                 IF (width < minWidth) OR (width > maxWidth) THEN abort(errRange,nada); END;
            ELSE
                Lib.ParamStr(S,i); (* retrieve org parm *)
                abort(errUnknown,S);
            END;
        ELSE
            IF flagSpec = TRUE THEN abort(errTooManySpex,S); END;
            UpperCase (S);
            opt := GetOptIndex (S,"?"+delim+"H"+delim+"HELP");
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,nada);
            ELSE
                Str.Copy (filespec, S);
                Lib.SplitAllPath(filespec,unit,path,f8,e3);  (* e3 contains . so length is 4 *)
                IF Str.Compare(e3,nada)=0 THEN
                    Str.Append(filespec,ExtMOD);
                END;
                flagSpec := TRUE;
            END;
        END;
    END;
    IF flagSpec = FALSE THEN abort(errMissingSpec,nada); END;

    fileCount := 0;
    found := FIO.ReadFirstEntry(filespec,FIO.FileAttr{},Entry);
    WHILE found DO
        IF fileCount = maxFile THEN abort(errTooManyFiles,filespec); END;
        Lib.SplitAllPath(Entry.Name,tmpunit,tmppath,f8,e3);
        INC (fileCount);
        filename[fileCount]:=str16(Entry.Name);
        found := FIO.ReadNextEntry(Entry);
    END;
    IF fileCount = 0 THEN abort (errNoMatchFile,filespec); END;

    FOR i := firstFile TO fileCount DO
        Str.Concat(S,unit,path);
        Str.Append(S,filename[i]);
        Process(S,flagREM,flagPack,flagVerbose,flagForce,width);
    END;

    abort(errNone,nada);
END MakeDEF.

