(* ---------------------------------------------------------------
Title         Q&D View PCX
Author        PhG
Overview
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
              ugly code (too many globerks) created
              just to check if it would be interesting
              to use PCX format when saving AstroTools pictures

              best for black&white pictures : BW2
              best for color pictures : CO256 (smaller than CO16 !)
Bugs
Wish List

--------------------------------------------------------------- *)

MODULE ViewPCX;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT BiosIO;
IMPORT SYSTEM;
IMPORT Graph;

FROM IO IMPORT WrStr,WrLn,WrShtHex,WrCard,RdKey,KeyPressed;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetString, CharCount, same,
aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode, str16,
getCurrentDirectory,cleantabs;

(* ------------------------------------------------------------ *)

CONST
    useLOOKUP     = TRUE;  (* hopefully faster code *)
CONST
    ProgEXEname   = "VIEWPCX";
    ProgTitle     = "Q&D View PCX file";
    ProgVersion   = "v1.0b";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    extPCX        = ".PCX";
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;
    dot           = ".";
CONST
    errNone             = 0;
    errHelp             = 1;
    errOption           = 2;
    errTooManyParameters= 3;
    errNotFound         = 4;
    errAlready          = 5;
    errIllogical        = 6;
    errSourceNeeded     = 7;
    errNotPCX           = 8;
    errMode             = 9;
    errUnsupportedPCX   = 10;
    errIllogical2       = 11;
    errNoVesa           = 12;
    errNotAvailable     = 13;
    errVesaProblem      = 14;
    err256only          = 15;
    err104F01           = 16;
    err104F05           = 17;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
    00000000011111111112222222222333333333344444444445555555555666666666677777777778
    1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msgHelp =
    Banner+nl+
    nl+
    "Syntax 1 : "+ProgEXEname+" [-vesa] <source["+extPCX+"]> [-infos] [-pause]"+nl+
    "Syntax 2 : "+ProgEXEname+" [-vesa] <source["+extPCX+"]> <target["+extPCX+"]> [-infos] [-overwrite]"+nl+
    nl+
    "This program *slowly* displays a PCX file (2 or 256 colors)."+nl+
    "Use -v to try and set VESA 640x480x256 video mode (default is VGA 320x200x256)."+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msgHelp);
    | errOption :
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errTooManyParameters:
        Str.Concat(S,einfo," is just one parameter too many !");
    | errNotFound:
        Str.Concat(S,"Source file ",einfo);Str.Append(S," does not exist !");
    | errAlready :
        Str.Concat(S,"Target file ",einfo);Str.Append(S," already exists !");
    | errIllogical:
        S:="When merely displaying a PCX file, -o option is a nonsense !";
    | errSourceNeeded:
        S:="<source> required !";
    | errNotPCX:
        Str.Concat(S,"Source file ",einfo);Str.Append(S," is not in PCX format !");
    | errMode:
        Str.Concat(S,"Cannot set required ",einfo);Str.Append(S," mode !");
    | errUnsupportedPCX:
        Str.Concat(S,"Source file ",einfo);Str.Append(S," is in an unsupported PCX format !");
    | errIllogical2:
        S:="When displaying and recreating a PCX file, -p option is a nonsense !";
    | errNoVesa       :
        S:="VESA functions are not available !";
    | errNotAvailable :
        Str.Concat(S,einfo," video mode is not available !");
    | errVesaProblem:
        Str.Concat(S,einfo," video mode would not initialize !");
    | err256only:
        S := "VESA display requires a 256 colors picture here !";
    | err104F01:
        S := "$104F01 VESA function failure !";
    | err104F05:
        S := "$104F05 VESA function failure !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp:
        ;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    v640x480x8 = 0101H;
    v800x600x8 = 0103H;

(*# save *)
(*# data(near_ptr => off)  *)
TYPE
    vpointer = POINTER TO WORD; (* well, glad M2 is case-sensitive ! *)
    pchar   = POINTER TO CHAR;
(*# restore *)

TYPE
    vesamainbuffertype = RECORD
        id             : ARRAY [0..3] OF CHAR;
        majmin         : WORD;
        pOEMname       : LONGWORD;  (* asciiz *)
        capabilities   : LONGWORD;
        pList          : LONGWORD;
        VRAM64KBblocks :WORD;
        OEMmajmin      : WORD;
        pOEM           : LONGWORD;
        pProduct       : LONGWORD;
        pRevision      : LONGWORD;
        VBEAFversion   : WORD;
        pAcceleratedModes:LONGWORD;
        dummy          : ARRAY [1..216] OF BYTE;
        OEMdummy       : ARRAY [1..256] OF BYTE;
    END;

VAR
    Buffer : vesamainbuffertype;

PROCEDURE CheckVesaHere (forceVBE2:BOOLEAN;VAR listPtr : vpointer) : BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    IF forceVBE2 THEN
        Buffer.id[0]:="V";
        Buffer.id[1]:="B";
        Buffer.id[2]:="E";
        Buffer.id[3]:="2";
    END;
    R.AX := 4F00H;
    R.ES := Seg(Buffer); (* buffer segment *)
    R.DI := Ofs(Buffer); (* buffer offset *)
    Lib.Intr(R,10H);
    IF R.AL # 4FH THEN RETURN FALSE; END;
    IF R.AH # 00H THEN RETURN FALSE; END;
    IF Buffer.id[0] # "V" THEN RETURN FALSE; END;
    IF Buffer.id[1] # "E" THEN RETURN FALSE; END;
    IF Buffer.id[2] # "S" THEN RETURN FALSE; END;
    IF Buffer.id[3] # "A" THEN RETURN FALSE; END;
    (* Lib.Move (ADR(Buffer[0EH]),ADR(listPtr),4); (* set pointer to list ADDRESS *) *)
    Lib.Move (ADR(Buffer.pList),ADR(listPtr),SIZE(Buffer.pList));
    RETURN TRUE;
END CheckVesaHere;

(* warning ! a mode may be supposed "available" while not being implemented ! matrox idiosyncrasy ! *)

PROCEDURE ModeAvailable (listPtr : vpointer; mode : CARDINAL) : BOOLEAN;
BEGIN
    LOOP
        IF listPtr^ = WORD(0FFFFH) THEN EXIT; END;
        IF listPtr^ = WORD(mode) THEN RETURN TRUE; END;
        Lib.IncFarAddr(listPtr,SIZE(WORD));
    END;
    RETURN FALSE;
END ModeAvailable;

PROCEDURE SetVesaMode (mode : CARDINAL) : BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AX := 4F02H;
    R.BX := mode;
    Lib.Intr(R,10H);
    IF R.AL # 4FH THEN RETURN FALSE; END;
    IF R.AH # 00H THEN RETURN FALSE; END;
    RETURN TRUE;
END SetVesaMode;

(* ------------------------------------------------------------ *)

(* vesamodeinfobuffertype MUST be 256 bytes *)

TYPE
    vesamodeinfobuffertype = RECORD
        modeattributes      : WORD; (* 79 *)
        wA                  : BYTE; (* 81 *)
        wB                  : BYTE; (* id *)
        wgranularityKB      : WORD;
        wsizeKB             : WORD;
        segmentwA           : WORD; (* 0 if unsupported *)
        segmentwB           : WORD; (* id *)
        wpositioningfunction: LONGWORD;
        bytesperscanline    : WORD;
    (* ---remainder is optional for VESA modes in v1.0/1.1, needed for OEM modes--- *)
        width               : WORD; (* pixels or chars *)
        height              : WORD; (* id *)
        wcell               : BYTE;
        hcell               : BYTE;
        memplanes           : BYTE;
        bpp                 : BYTE;
        banks               : BYTE;
        memorymodeltype     : BYTE; (* 82 *)
        banksizeKB          : BYTE;
        imagepages          : BYTE; (* -1 *)
        reservedflag        : BYTE; (* 1 for VBE 3.0, ELSE 0 *)
    (* ---VBE v1.2+ --- *)
        rmasksize           : BYTE;
        rfield              : BYTE;
        gmasksize           : BYTE;
        gfield              : BYTE;
        bmasksize           : BYTE;
        bfield              : BYTE;
        reservedmasksize    : BYTE;
        reservedmaskposition: BYTE;
        directcolormode     : BYTE; (* bits 0 and 1 *)
    (* ---VBE v2.0+ --- *)
        linearvideobufferaddr: LONGWORD;
        offscreenmemoryaddr : LONGWORD;
        offscreenmemoryKB   : WORD;
    (* ---VBE v3.0 --- *)
        bytesperscanlinelinear:WORD;
        imagesforbankedmodes: BYTE; (* -1 *)
        imagesforlinearmodes: BYTE; (* -1 *)
        rmasklinear         : BYTE;
        rmaskLSBlinear      : BYTE;
        gmasklinear         : BYTE;
        gmaskLSBlinear      : BYTE;
        bmasklinear         : BYTE;
        bmaskLSBlinear      : BYTE;
        reservedmasklinear  : BYTE;
        reservedmaskLSBlinear:BYTE;
        maxclockHz          : LONGWORD;
        unused              : ARRAY [1..190] OF BYTE;
    END;

CONST
    vesaminy = 0;
    vesamaxy = 1024-1; (* 1280x1024 at most *)
VAR
    currbank:CARDINAL; (* a word in fact *)
    binfos : vesamodeinfobuffertype;
(*%T useLOOKUP  *)
VAR
    vesabaseaddr : ARRAY [vesaminy..vesamaxy] OF LONGCARD;

PROCEDURE initVESAlookup (  );
VAR
    y : CARDINAL;
    addr,wi : LONGCARD;
BEGIN
    addr:=0;
    wi:=LONGCARD(binfos.width);
    FOR y:=vesaminy TO vesamaxy DO
        vesabaseaddr[y]  := addr;
        INC (addr, wi);
    END;
END initVESAlookup;
(*%E *)

PROCEDURE getVESAmodeInfos (mode:CARDINAL):BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    Lib.Fill(ADR(binfos),SIZE(binfos),00H);

    R.AX := 4F01H;      (* GET SuperVGA MODE INFORMATION *)
    R.CX := WORD(mode);
    R.ES := Seg(binfos); (* buffer segment *)
    R.DI := Ofs(binfos); (* buffer offset *)
    Lib.Intr(R,10H);

    IF R.AL # 4FH THEN RETURN FALSE; END; (* unsupported function *)
(*%T useLOOKUP  *)
    IF R.AH = 00H THEN initVESAlookup; END; (* ok, init if needed *)
(*%E  *)
    RETURN (R.AH=00H); (* FALSE if function failure *)
END getVESAmodeInfos;

PROCEDURE initVESAbank (  ):BOOLEAN;
VAR
    R:SYSTEM.Registers;
BEGIN
    currbank := 0000H;
    R.AX := 04F05H;
    R.BH := 00H;     (* select video memory window -- dx = window address in granularity units *)
    R.BL := 00H;     (* window A should always work *)
    R.DX := currbank;
    Lib.Intr(R,10H);
    IF R.AL # 4FH THEN RETURN FALSE; END;
    RETURN (R.AH=00H);
END initVESAbank;

PROCEDURE VESAputpixel (x,y,n:CARDINAL);
VAR
    addr:LONGCARD;
    bank,offset:CARDINAL;
    R:SYSTEM.Registers;
BEGIN
(*%F useLOOKUP  *)
    addr  := LONGCARD(x)+LONGCARD(y)*LONGCARD(binfos.width);
(*%E  *)
(*%T useLOOKUP  *)
    addr  := LONGCARD(x)+vesabaseaddr[y];
(*%E  *)
    bank  := CARDINAL (addr >> 16);
    offset:= CARDINAL (addr MOD 65536);
    IF currbank # bank THEN
        currbank := bank;
        R.AX := 04F05H;
        R.BH := 00H;
        R.BL := 00H;
        R.DX := currbank;
        Lib.Intr(R,10H); (* assume ok *)
    END;
    (* ugly hack *)
    Lib.FarFill([binfos.segmentwA:offset],1,BYTE(n));
END VESAputpixel;

PROCEDURE VESAgetpixel (x,y:CARDINAL):BYTE;
VAR
    addr:LONGCARD;
    bank,offset:CARDINAL;
    R:SYSTEM.Registers;
    n:BYTE;
BEGIN
(*%F useLOOKUP  *)
    addr  := LONGCARD(x)+LONGCARD(y)*LONGCARD(binfos.width);
(*%E  *)
(*%T useLOOKUP  *)
    addr  := LONGCARD(x)+vesabaseaddr[y];
(*%E  *)
    bank  := CARDINAL (addr >> 16);
    offset:= CARDINAL (addr MOD 65536);
    IF currbank # bank THEN
        currbank := bank;
        R.AX := 04F05H;
        R.BH := 00H;
        R.BL := 00H;
        R.DX := currbank;
        Lib.Intr(R,10H); (* assume ok *)
    END;
    (* ugly hack *)
    Lib.FarMove([binfos.segmentwA:offset],FarADR(n),1);
    RETURN n;
END VESAgetpixel;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE anykey ();
VAR
    c : CHAR;
BEGIN
    WrStr("Hit any key to continue . . . ");
    c := RdKey();
    IF c = CHR(0) THEN c:=RdKey();END;
    WrLn;
END anykey;

PROCEDURE Hires (mode:CARDINAL) : BOOLEAN;
BEGIN
    RETURN Graph.SetVideoMode(mode);
END Hires;

PROCEDURE waitkeypress ();
BEGIN
    WHILE NOT(KeyPressed()) DO
    END;
END waitkeypress;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
VAR
    ioBuffer : ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    hnd      : FIO.File; (* globerk *)

(* ------------------------------------------------------------ *)

CONST
    ENABLERLE = TRUE; (* if FALSE, each pixel is ugly C1 xx, else we pack *)

TYPE
    PCXrgbType = RECORD
        red,green,blue:BYTE;
    END;

    (* (almost) useless fields are indented again *)

    PCXheaderType = RECORD
     manufacturer    : BYTE; (* constant 10=$0A=ZSoft *)
     version         : BYTE; (* constant 5=PC Paintbrush v3.0+ *)
     encoding        : BYTE; (* constant 1=RLE *)
    bitsPerPixel     : BYTE; (* 1, 2, 4 or 8, i.e. mono, 4, 16 or 256 colors  *)
	                  (* window, i.e. image dimensions : xmin, ymin, xmax, ymax *)
    leftmargin       : WORD;
    uppermargin      : WORD;
    rightmargin      : WORD; (* do not use xmax-xmin ! *)
    lowermargin      : WORD;
     hDPIresolution  : WORD; (* put 300 for instance *)
     vDPIresolution  : WORD; (* idem *)
    colormap         : ARRAY[0..15] OF PCXrgbType;
     reserved1       : BYTE; (* must be 0 *)
    NCP              : BYTE; (* number of color planes, 1 or 4 *)
    NBS              : WORD; (* number of bytes per scanline, always even *)
                            (* from here, fields may contain rubbish *)
     paletteInfo     : WORD; (* 1=color or BW, 2=grayscale *)
     hscreensize     : WORD;
     vscreensize     : WORD;
     reserved2       : ARRAY[0..53] OF BYTE; (* must be 0 *)
    END;

CONST
    palID = BYTE(0CH); (* 12=$0C *)
    palidsize=1;
    palsize = 3 * 256;

PROCEDURE chkPCX (S:ARRAY OF CHAR;VAR h:PCXheaderType):BOOLEAN ;
CONST
    kTen = BYTE(0AH);
    kOne = BYTE(1);
    kZero= BYTE(0);
VAR
    n : CARDINAL;
BEGIN
    hnd:=FIO.OpenRead(S);
    FIO.AssignBuffer(hnd,ioBuffer);
    n:=FIO.RdBin(hnd,h,SIZE(PCXheaderType));
    FIO.Close(hnd);
    IF n < SIZE(PCXheaderType) THEN RETURN FALSE; END;
    IF h.manufacturer # kTen THEN RETURN FALSE; END;
    IF h.encoding # kOne THEN RETURN FALSE;END;
    IF h.reserved1 # kZero THEN RETURN FALSE; END;
    (*
    FOR n:=0 TO 53 DO
        IF h.reserved2[n] # kZero THEN RETURN FALSE; END;
    END;
    *)
    RETURN TRUE;
END chkPCX;

PROCEDURE chkSupportedPCX (h:PCXheaderType;VAR colors:CARDINAL ):BOOLEAN;
CONST
    kFour= BYTE(4);
    kOne = WORD(1);
    kEight=BYTE(8);
BEGIN
    IF h.bitsPerPixel > kEight THEN RETURN FALSE; END;
    IF h.NCP > kFour THEN RETURN FALSE; END;
    IF h.paletteInfo # kOne THEN RETURN FALSE; END;
    CASE CARDINAL(h.NCP) OF
    | 1: CASE CARDINAL(h.bitsPerPixel) OF
         | 1 : colors :=2;
         | 8 : colors :=256;
         ELSE
             RETURN FALSE;
         END;
    | 4: CASE CARDINAL(h.bitsPerPixel) OF
         | 1 : (* colors :=16; *) RETURN FALSE;
         ELSE
             RETURN FALSE;
         END;
    ELSE
        RETURN FALSE;
    END;
    RETURN TRUE;
END chkSupportedPCX;

PROCEDURE findVideo (h:PCXheaderType;
                    VAR vmode,xmin,ymin,xmax,ymax:CARDINAL);
BEGIN
    xmin:=0;ymin:=0;
    CASE CARDINAL(h.NCP) OF
    | 1: CASE CARDINAL(h.bitsPerPixel) OF
         | 1 : vmode:=Graph._VRES16COLOR; xmax:=640;ymax:=480;
         | 8 : vmode:=Graph._MRES256COLOR;xmax:=320;ymax:=200;
         END;
    | 4: CASE CARDINAL(h.bitsPerPixel) OF
         | 1 : vmode:=Graph._VRES16COLOR; xmax:=640;ymax:=480;
         END;
    END;
    DEC (xmax);
    DEC (ymax);
END findVideo;

PROCEDURE getPictureSize(h:PCXheaderType;VAR picwidth,picheight:CARDINAL);
BEGIN
    picwidth := CARDINAL(h.rightmargin-h.leftmargin)+1;
    picheight:= CARDINAL(h.lowermargin-h.uppermargin)+1;
END getPictureSize;

PROCEDURE pr (S:ARRAY OF CHAR;v:CARDINAL);
BEGIN
    WrStr(S);WrStr(" : ");WrCard(v,5);WrLn;
END pr;

PROCEDURE showPCXinfos (S:ARRAY OF CHAR;h:PCXheaderType);
VAR
    p : LONGCARD;
    id: BYTE;
    n,i,j : CARDINAL;
BEGIN
 WrStr("File                           : ");WrStr(S);WrLn;
    pr("Manufacturer                  ",CARDINAL(h.manufacturer));
    pr("Version (5)                   ",CARDINAL(h.version));
    pr("Encoding (1)                  ",CARDINAL(h.encoding));
    pr("BitsPerPixel (1,2,4,8)        ",CARDINAL(h.bitsPerPixel));
    pr("Left Margin (xmin)            ",h.leftmargin);
    pr("Upper Margin (ymin)           ",h.uppermargin);
    pr("Right Margin (xmax)           ",h.rightmargin);
    pr("Lower Margin (ymax)           ",h.lowermargin);
    pr("Horizontal DPI resolution     ",h.hDPIresolution);
    pr("Vertical DPI resolution       ",h.vDPIresolution);
    pr("Number of color planes (1,2,4)",CARDINAL(h.NCP));
    pr("Bytes per scanline            ",h.NBS);            (* show where each plane begins : RGBI *)
    pr("Palette (1=color/BW, 2=gray)  ",h.paletteInfo);
    pr("Horizontal Screen Size        ",h.hscreensize);
    pr("Vertical Screen Size          ",h.vscreensize);
    pr("--> Width                     ",CARDINAL(h.rightmargin-h.leftmargin)+1);
    pr("--> Heigth                    ",CARDINAL(h.lowermargin-h.uppermargin)+1);
    CASE CARDINAL(h.NCP) OF
    | 1: CASE CARDINAL(h.bitsPerPixel) OF
         | 1 : WrStr("--> Monochrome");
         | 8 : WrStr("--> 256 colors");
         ELSE
             WrStr("*** Unsupported bitsPerPixel !");
         END;
    | 4: CASE CARDINAL(h.bitsPerPixel) OF
         | 1 : WrStr("--> 16 colors");
         ELSE
             WrStr("*** Unsupported bitsPerPixel !");
         END;
    ELSE
        WrStr("*** Unsupported number of color planes !");
    END;
    WrLn;
    hnd := FIO.OpenRead(S);
    FIO.AssignBuffer(hnd,ioBuffer);
    p := FIO.Size(hnd);
    IF p < (SIZE(PCXheaderType)+palidsize+palsize) THEN
        WrStr("*** File size does not allow for a 256 colors palette !");WrLn;
    ELSE
        FIO.Seek(hnd,p-1 -palsize-palidsize+1);
        n := FIO.RdBin(hnd,id,1);
        IF id = palID THEN
            WrStr("--> 256 colors palette.");
        ELSE
            WrStr("--> No 256 colors palette.");
        END;
        WrLn;
    END;
    FIO.Close(hnd);
    FOR i:=1 TO 3 DO
        WrStr("Palette 16 ");
        CASE i OF
        | 1 : WrStr("Red  ");
        | 2 : WrStr("Green");
        | 3 : WrStr("Blue ");
        END;
        WrStr(" :");
        FOR j:=0 TO 15 DO
            CASE i OF
            | 1:id:=h.colormap[j].red;
            | 2:id:=h.colormap[j].green;
            | 3:id:=h.colormap[j].blue;
            END;
            WrStr(" ");
            IF id < BYTE(16) THEN
                WrStr("0");
                WrShtHex(id,1);
            ELSE
                WrShtHex(id,2);
            END;
        END;
        WrLn;
    END;
END showPCXinfos;

(* ------------------------------------------------------------ *)

PROCEDURE waitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END waitVGAretrace;

PROCEDURE setDAC(index:CARDINAL;red,green,blue:BYTE);
CONST
    DACWriteIndex  = 03C8H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACWriteIndex,SHORTCARD(index));
    SYSTEM.Out (DACDataRegister, red);
    SYSTEM.Out (DACDataRegister, green);
    SYSTEM.Out (DACDataRegister, blue);
END setDAC;

PROCEDURE resetdac (index:CARDINAL;r,g,b,pcxshift:BYTE);
BEGIN
    r := r >> pcxshift;
    g := g >> pcxshift;
    b := b >> pcxshift;
    setDAC(index,r,g,b);
END resetdac;

PROCEDURE newpalette (h:PCXheaderType;colors:CARDINAL);
CONST
    palsize = 3 * 256;
VAR
    i : CARDINAL;
    r,g,b,id:BYTE;
    p:LONGCARD;
    n:CARDINAL;
BEGIN
    waitVGAretrace;
    CASE colors OF
    | 2:
        FOR i:= 0 TO 1 DO
            r:=h.colormap[i].red;
            g:=h.colormap[i].green;
            b:=h.colormap[i].blue;
            resetdac(i,r,g,b,2);
        END;
    | 16:
        FOR i:= 0 TO 15 DO
            r:=h.colormap[i].red;
            g:=h.colormap[i].green;
            b:=h.colormap[i].blue;
            resetdac(i,r,g,b,2);
        END;
    | 256:
        p := FIO.Size(hnd);
        FIO.Seek(hnd,p-1 -palsize-palidsize+1);
        n := FIO.RdBin(hnd,id,1);
        IF id = palID THEN
            FOR i := 0 TO 255 DO
                n:=FIO.RdBin(hnd,r,1);
                n:=FIO.RdBin(hnd,g,1);
                n:=FIO.RdBin(hnd,b,1);
                resetdac(i,r,g,b,2);
            END;
        ELSE
            FOR i:= 0 TO 15 DO
                r:=h.colormap[i].red;
                g:=h.colormap[i].green;
                b:=h.colormap[i].blue;
                resetdac(i,r,g,b,2);
            END;
        END;
        p := SIZE(PCXheaderType);
        FIO.Seek(hnd,p);
    END;
END newpalette;

PROCEDURE readDAC (index:CARDINAL;VAR r,g,b:BYTE);
CONST
    DACReadIndex   = 03C7H;
    DACDataRegister= 03C9H;
VAR
    rgb : LONGCARD;
BEGIN
    SYSTEM.Out (DACReadIndex,SHORTCARD(index));
    r:=SYSTEM.In (DACDataRegister);
    g:=SYSTEM.In (DACDataRegister);
    b:=SYSTEM.In (DACDataRegister);
END readDAC;

(* ------------------------------------------------------------ *)

TYPE
    masktype = ARRAY [0..7] OF CARDINAL;
CONST
    bitmask = masktype(080H,040H,020H,010H,008H,004H,002H,001H);
CONST
    PCXCOUNTFLAG = BYTE(0C0H); (* 11000000 *)
    PCXCOUNTMASK = BYTE(03FH); (* 00111111 *)
    PCXMAXCOUNT  = 03FH;
CONST
    maxPlanes = 4;
    maxpixels = 1280;
    firstcode = 0;
    (* maxcode   = (1280 DIV 8) * maxPlanes -1; (* in bytes *) *)
    maxcode   = maxpixels * maxPlanes-1;
TYPE
    imgtype = RECORD
        picwidth : CARDINAL ;
        picheight: CARDINAL ;
        decodebuffer : ARRAY [firstcode..maxcode] OF BYTE;
    END;
VAR
    img : imgtype;

PROCEDURE decodeScanline (lastcode:CARDINAL);
VAR
    databyte:BYTE;
    p,count,n : CARDINAL;
BEGIN
    p := firstcode;
    WHILE p <= lastcode DO
        n:=FIO.RdBin(hnd,databyte,1);
        IF (databyte AND PCXCOUNTFLAG) = PCXCOUNTFLAG THEN
            count := CARDINAL(databyte AND PCXCOUNTMASK);
            n := FIO.RdBin(hnd,databyte,1);
            FOR n := 1 TO count DO
                img.decodebuffer[p]:=databyte;
                INC(p);
            END;
        ELSE
            img.decodebuffer[p]:=databyte;
            INC(p);
        END;
    END;
END decodeScanline;

PROCEDURE showPCX (usevesa:BOOLEAN;
                   S:ARRAY OF CHAR; xmin,ymin,xmax,ymax,colors:CARDINAL );
VAR
    h : PCXheaderType;
    n,lastcode:CARDINAL;
    lastx,lasty,x,y:CARDINAL;
    bpp : CARDINAL;
    ndxmask,mask:CARDINAL;
BEGIN
    hnd:=FIO.OpenRead(S);
    FIO.AssignBuffer(hnd,ioBuffer);
    n:=FIO.RdBin(hnd,h,SIZE(PCXheaderType));

    newpalette(h,colors);

    lastx    := CARDINAL (h.rightmargin-h.leftmargin);
    lasty    := CARDINAL (h.lowermargin-h.uppermargin);
    lastcode := CARDINAL(h.NCP) * CARDINAL(h.NBS) -1;
    IF lastcode > maxcode THEN
        FIO.Close(hnd);
        RETURN;
    END;
    (*
    p := firstcode;
    FOR n := 1 TO CARDINAL(h.NCP) DO
        ndxPlane[n]:=p;
        INC(p,lastx+1);
    END;
    *)
    bpp:=CARDINAL(h.bitsPerPixel);
    waitVGAretrace;
    (*
        alternatively, we could directly decode to video screen,
        using Graph.Line for runs of the same color value...
    *)
    FOR y := ymin TO lasty DO
        decodeScanline(lastcode);
        CASE bpp OF
        | 1:
            FOR x := xmin TO lastx DO
                n := CARDINAL(img.decodebuffer[x DIV 8]);
                ndxmask := x MOD 8;
                mask := bitmask[ndxmask];
                IF (n AND mask)=mask THEN
                    n:=1;
                ELSE
                    n:=0;
                END;
                IF ((x <= xmax) AND (y <= ymax)) THEN Graph.Plot(x,y,n);END;
            END;
        | 8:
            FOR x := xmin TO lastx DO
                n := CARDINAL(img.decodebuffer[x]);
                IF ((x <= xmax) AND (y <= ymax)) THEN
                    IF  usevesa THEN (* only 256 colors *)
                        VESAputpixel(x,y,n);
                    ELSE
                        Graph.Plot(x,y,n);
                    END;
                END;
            END;
        | 4:
            (* PCX piece of crap saves planes R, G, B and I
               TopSpeed 16 colors handling uses planes too... but not this way !
               does not work, no time to waste, so feature officially UNSUPPORTED !
            *)
            img.picwidth := lastx+1; (* len  *)
            img.picheight:= 1 ;      (* rows *)
            Graph.PutImage(xmin,y,ADR(img),Graph._GPSET);
        END;
    END;
    FIO.Close(hnd);

END showPCX;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    palette16=ARRAY[1..16] OF LONGCARD;
CONST
    defaultpal16=palette16(
    Graph._BLACK    ,
    Graph._BLUE      ,
    Graph._GREEN     ,
    Graph._CYAN      ,
    Graph._RED       ,
    Graph._MAGENTA   ,
    Graph._BROWN     ,
    Graph._WHITE     ,
    Graph._GRAY     ,
    Graph._LIGHTBLUE ,
    Graph._LIGHTGREEN,
    Graph._LIGHTCYAN ,
    Graph._LIGHTRED  ,
    Graph._LIGHTMAGENTA,
    Graph._LIGHTYELLOW ,
    Graph._BRIGHTWHITE );

(* remember $FC >> 2 = $3F, but $FF >> 2 = $3F too ! *)

PROCEDURE PCXpal (VAR v:BYTE);
VAR
    i : CARDINAL;
BEGIN
    i := CARDINAL(v) << 2;
    IF i >= 0FCH THEN i := 0FFH; END; (* we lose $FC but it's better here ! *)
    v := BYTE(i);
END PCXpal;

(* 2 or 256 colors only *)

PROCEDURE buildPCXheader (xmin,ymin,xmax,ymax,colors:CARDINAL):PCXheaderType;
VAR
    h : PCXheaderType;
    i : CARDINAL;
    r,g,b:BYTE;
    bgr:LONGCARD;
BEGIN
    h.manufacturer   := BYTE(0AH);
    h.version        := BYTE(5);
    h.encoding       := BYTE(1);
    CASE colors OF
    | 2   : i:=1;
    | 256 : i:=8;
    END;
    h.bitsPerPixel   := BYTE(i);
    h.leftmargin     := xmin;
    h.uppermargin    := ymin;
    h.rightmargin    := xmax;
    h.lowermargin    := ymax;
    h.hDPIresolution := 300;    (* reasonable but useless default *)
    h.vDPIresolution := 300;
        FOR i := 0 TO 15 DO
            CASE colors OF
            | 2 :
                IF i > 1 THEN
                    r:=0;g:=0;b:=0; (* 0=black,1=white *)
                ELSE
                    readDAC(i,r,g,b);
                END;
            | 256:
                bgr := defaultpal16[i+1];
                r := BYTE( bgr        MOD 100H);
                g := BYTE((bgr >>  8) MOD 100H);
                b := BYTE((bgr >> 16) MOD 100H);
            END;
            PCXpal(r); PCXpal(g); PCXpal(b);
            h.colormap[i].red   := r;
            h.colormap[i].green := g;
            h.colormap[i].blue  := b;
        END;
    h.reserved1      := BYTE(0);
    h.NCP            := BYTE(1);
    CASE colors OF
    | 2   :  i := (xmax-xmin+1) >> 3; (*  1 bit per pixel, so DIV 8 *)
             IF ((xmax-xmin+1) MOD 8) # 0 THEN INC(i);END;
             (* IF ODD(i) THEN INC(i); END; *)
    | 256 :  i := (xmax-xmin+1) ; (*  8 bits per pixel, so DIV 8 then * 8 *)
    END;
    h.NBS            := i;
    h.paletteInfo    := 1;
    h.hscreensize    := 0; (* xmax-xmin+1 *)
    h.vscreensize    := 0; (* ymax-ymin+1 *)
    FOR i := 0 TO 53 DO
        h.reserved2[i] := BYTE(0);
    END;

    RETURN h;
END buildPCXheader;

PROCEDURE savePCXpal256 ();
VAR
    i : CARDINAL;
    r,g,b:BYTE;
BEGIN
    FIO.WrBin(hnd,palID,palidsize);
        FOR i := 0 TO 255 DO
            readDAC(i,r,g,b);
            PCXpal(r); PCXpal(g); PCXpal(b);
            FIO.WrBin(hnd,r,1);
            FIO.WrBin(hnd,g,1);
            FIO.WrBin(hnd,b,1);
        END;
END savePCXpal256;

PROCEDURE encodeScanlineMono (y,xmin,xmax:CARDINAL):CARDINAL ;
VAR
    pattern : BYTE;
    x,ndxmask,themask,v:CARDINAL;
    p:CARDINAL; (* in img.decodebuffer[] *)
    count,oldmask:CARDINAL;
BEGIN
(*%F ENABLERLE *)
    p := firstcode;
    x := xmin;
    themask:=00H;
    LOOP
        ndxmask := x MOD 8;
        v := Graph.Point(x,y);
        IF v # 0 THEN
            themask := (themask OR bitmask[ndxmask]);
        END;
        IF ndxmask = 7 THEN
            pattern:=BYTE(themask);
            IF (pattern AND PCXCOUNTFLAG) = PCXCOUNTFLAG THEN
                img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(01H));
                INC(p);
            END;
            img.decodebuffer[p]:=pattern;
            INC(p);
            themask:=00H;
        END;
        INC(x);
        IF x > xmax THEN EXIT; END;
    END;
        ndxmask := x MOD 8;
        IF ndxmask # 0 THEN
            pattern:=BYTE(themask);
            IF (pattern AND PCXCOUNTFLAG) = PCXCOUNTFLAG THEN
                img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(01H));
                INC(p);
            END;
            img.decodebuffer[p]:=pattern;
            INC(p);
        END;
    RETURN (p-firstcode); (* p is already +1, so useless to -1 *)
(*%E  *)

(*%T ENABLERLE *)
    p := firstcode;
    x := xmin;
    themask:=00H;
    count := 0;
    LOOP
        ndxmask := x MOD 8;
        v := Graph.Point(x,y);
        IF v # 0 THEN
            themask := (themask OR bitmask[ndxmask]);
        END;
        IF ndxmask = 7 THEN (* we have a full byte *)
            IF count=0 THEN
                oldmask := themask;
                count   :=1;
            ELSE
                IF themask=oldmask THEN
                    IF count = PCXMAXCOUNT THEN (* flush ! *)
                        img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(count));
                        INC(p);
                        img.decodebuffer[p]:= BYTE(oldmask);
                        INC(p);
                        count:=1; (* write 63, write byte, restart at 1 *)
                    ELSE
                        INC(count);
                    END;
                ELSE
                    IF count > 1 THEN
                        img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(count));
                        INC(p);
                        count:=1; (* write count, restart at 1 *)
                    ELSE (* count is 1 here *)
                        IF (BYTE(oldmask) AND PCXCOUNTFLAG) = PCXCOUNTFLAG THEN
                            img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(01H));
                            INC(p); (* write 1 *)
                        END;
                    END;
                    img.decodebuffer[p]:=BYTE(oldmask);
                    INC(p); (* write byte *)
                    oldmask:=themask; (* restart at 1 with new byte *)
                END;
            END;
            themask := 00H; (* eh ! *)
        END;

        INC(x);
        IF x > xmax THEN EXIT; END;
    END;

        ndxmask := x MOD 8;
        IF ndxmask # 0 THEN

                IF themask=oldmask THEN
                    IF count = PCXMAXCOUNT THEN (* flush ! *)
                        img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(count));
                        INC(p);
                        img.decodebuffer[p]:= BYTE(oldmask);
                        INC(p);
                        count:=1; (* write 63, write byte, restart at 1 *)
                    ELSE
                        INC(count);
                    END;
                ELSE
                    IF count > 1 THEN
                        img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(count));
                        INC(p);
                        count:=1; (* write count, restart at 1 *)
                    ELSE (* count is 1 here *)
                        IF (BYTE(oldmask) AND PCXCOUNTFLAG) = PCXCOUNTFLAG THEN
                            img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(01H));
                            INC(p); (* write 1 *)
                        END;
                    END;
                    img.decodebuffer[p]:=BYTE(oldmask);
                    INC(p); (* write byte *)
                    oldmask:=themask; (* restart at 1 with new byte *)
                END;

                IF (BYTE(oldmask) AND PCXCOUNTFLAG) = PCXCOUNTFLAG THEN
                    img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(01H));
                    INC(p); (* write 1 *)
                END;
                img.decodebuffer[p]:=BYTE(oldmask);
                INC(p); (* write byte *)

        ELSE (* flush whatever is pending *)

            img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(count));
            INC(p);
            img.decodebuffer[p]:= BYTE(oldmask);
            INC(p);
        END;
    RETURN (p-firstcode); (* p is already +1, so useless to -1 *)

(*%E  *)
END encodeScanlineMono;

PROCEDURE encodeScanline256 (y,xmin,xmax:CARDINAL;usevesa:BOOLEAN) : CARDINAL ;
VAR
    oldink,ink : BYTE;
    x,count:CARDINAL;
    p:CARDINAL; (* in img.decodebuffer[] *)
BEGIN
(*%F ENABLERLE *)
    p := firstcode;
    x := xmin;
    LOOP
        IF usevesa THEN
            ink:= VESAgetpixel(x,y);
        ELSE
            ink := BYTE(Graph.Point(x,y));
        END;
        IF (ink AND PCXCOUNTFLAG) = PCXCOUNTFLAG THEN
            img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(01H));
            INC(p);
        END;
        img.decodebuffer[p]:=ink;
        INC(p);

        INC(x);
        IF x > xmax THEN EXIT; END;
    END;
    RETURN (p-firstcode); (* p is already +1, so useless to -1 *)
(*%E  *)
(*%T ENABLERLE *)
    IF usevesa THEN
        oldink:=VESAgetpixel(xmin,y);
    ELSE
        oldink:=BYTE(Graph.Point(xmin,y));
    END;
    count := 1;
    p := firstcode;
    x := xmin+1;
    LOOP
        IF usevesa THEN
            ink:= VESAgetpixel(x,y);
        ELSE
            ink := BYTE(Graph.Point(x,y));
        END;
        IF ink=oldink THEN
            IF count = PCXMAXCOUNT THEN (* flush ! *)
                img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(count));
                INC(p);
                img.decodebuffer[p]:=oldink;
                INC(p);
                count:=1; (* write 63, write byte, restart at 1 *)
            ELSE
                INC(count);
            END;
        ELSE
            IF count > 1 THEN
                img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(count));
                INC(p);
                count:=1; (* write count, restart at 1 *)
            ELSE (* count is 1 here *)
                IF (oldink AND PCXCOUNTFLAG) = PCXCOUNTFLAG THEN
                    img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(01H));
                    INC(p); (* write 1 *)
                END;
            END;
            img.decodebuffer[p]:=oldink;
            INC(p); (* write byte *)
            oldink:=ink; (* restart at 1 with new byte *)
        END;

        INC(x);
        IF x > xmax THEN EXIT; END;
    END;

            IF count > 1 THEN
                img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(count));
                INC(p); (* write count *)
            ELSE (* count is 1 here *)
                IF (oldink AND PCXCOUNTFLAG) = PCXCOUNTFLAG THEN
                    img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(01H));
                    INC(p); (* write 1 *)
                END;
            END;
            img.decodebuffer[p]:=oldink;
            INC(p); (* write byte *)
    RETURN (p-firstcode); (* p is already +1, so useless to -1 *)
(*%E *)
END encodeScanline256;

(* must save full screen only ! *)

PROCEDURE savePCX (usevesa:BOOLEAN;
                  target:ARRAY OF CHAR;xmin,ymin,xmax,ymax,colors:CARDINAL);
VAR
    h : PCXheaderType;
    y,count : CARDINAL;
BEGIN
    hnd := FIO.Create(target);
    FIO.AssignBuffer(hnd,ioBuffer);
    h := buildPCXheader(xmin,ymin,xmax,ymax,colors);
    FIO.WrBin(hnd,h,SIZE(PCXheaderType));
    FOR y := ymin TO ymax DO
        CASE colors OF
        | 2   : count:=encodeScanlineMono(y,xmin,xmax);
        | 256 : count:=encodeScanline256(y,xmin,xmax,usevesa);
        END;
        FIO.WrBin(hnd, img.decodebuffer, count);
    END;
    IF colors=256 THEN savePCXpal256();END;
    FIO.Flush(hnd);
    FIO.Close(hnd);
END savePCX;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE handleExt (ext:ARRAY OF CHAR;VAR R:ARRAY OF CHAR);
BEGIN
    IF Str.CharPos(R,dot)=MAX(CARDINAL) THEN
        Str.Append(R,ext);
    END;
END handleExt;

VAR
    parmcount, i, opt    : CARDINAL;
    S, R                 : str128;
    state                : (waiting,gotsource,gottarget);
    overwrite,infos,pause,usevesa: BOOLEAN;
    source,target        : str128;
    picheader            : PCXheaderType;
    lc                   : LONGCARD;
    listPtr              : vpointer;
VAR
    xmin,xmax,ymin,ymax,vmode,colors:CARDINAL;
    picwidth,picheight:CARDINAL;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    WrLn; (* here for pretty output *)

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    overwrite := FALSE;
    infos     := FALSE;
    pause     := FALSE;
    usevesa   := FALSE;

    state     := waiting;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S); cleantabs(R);
        UpperCase(R);
        IF isOption(R)=TRUE THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "O"+delim+"OVERWRITE"+delim+
                                 "I"+delim+"INFOS"+delim+
                                 "P"+delim+"PAUSE"+delim+
                                 "V"+delim+"VESA"
                              );
            CASE opt OF
            | 1,2,3 :  abort(errHelp,"");
            | 4,5:     overwrite := TRUE;
            | 6,7:     infos     :=TRUE;
            | 8,9:     pause     :=TRUE;
            | 10,11:   usevesa   :=TRUE;
            ELSE
                abort(errOption,S);
            END;
        ELSE
            CASE state OF
            | waiting :
                IF same(R,"?") THEN abort(errHelp,""); END;
                Str.Copy(source,R); (* keep upper case here *)
            | gotsource :
                Str.Copy(target,R); (* keep upper case here *)
            ELSE
                abort(errTooManyParameters,S);
            END;
            INC(state);
        END;
    END;
    CASE state OF
    | waiting : abort(errSourceNeeded,"");
    | gotsource: IF overwrite THEN abort(errIllogical,""); END;
    | gottarget: IF pause THEN abort(errIllogical2,"");END;
    END;

    handleExt(extPCX,source);
    IF FIO.Exists(source)=FALSE THEN abort(errNotFound,source);END;

    IF state = gottarget THEN
        handleExt(extPCX,target);
        IF FIO.Exists(target) THEN
            IF overwrite=FALSE THEN abort(errAlready,target);END;
        END;
    END;

    IF chkPCX(source,picheader)=FALSE THEN abort(errNotPCX,source);END;

    IF infos THEN
        showPCXinfos(source,picheader);
        IF state=gotsource THEN
            IF pause THEN WrLn; anykey; END;
            abort(errNone,"");
        ELSE
            WrLn;
            anykey;
        END;
    END;

    IF chkSupportedPCX(picheader,colors)=FALSE THEN abort(errUnsupportedPCX,source);END;

    IF usevesa THEN
        IF colors # 256 THEN abort(err256only,"");END;
        xmin:=0; ymin:=0;
        vmode := v640x480x8; S:="640x480x8"; xmax:=640; ymax:=480;
        (* vmode := v800x600x8; S:="800x600x8"; xmax:=800; ymax:=600; *)
        DEC (xmax); DEC(ymax);
        IF CheckVesaHere(FALSE,listPtr)=FALSE THEN abort(errNoVesa,""); END;
        IF ModeAvailable(listPtr,vmode)=FALSE THEN abort(errNotAvailable,S); END;
        IF SetVesaMode(vmode) = FALSE THEN abort(errVesaProblem,S); END;
        IF getVESAmodeInfos (vmode)=FALSE THEN abort(err104F01,"");END;
        IF initVESAbank()=FALSE THEN abort(err104F05,"");END;
    ELSE
        findVideo(picheader,vmode,xmin,ymin,xmax,ymax);
        IF Hires(vmode)=FALSE THEN abort(errMode,"graphics");END;
        lc:=Graph.SetBkColor(Graph._BLACK);
        Graph.ClearScreen(Graph._GCLEARSCREEN);
    END;

    showPCX(usevesa,source,xmin,ymin,xmax,ymax,colors);

    CASE state OF
    | gotsource:
        waitkeypress; (* IF pause THEN ? *)
    | gottarget:
        IF usevesa THEN
            IF initVESAbank()=FALSE THEN abort(err104F05,"");END;
        END;
        getPictureSize(picheader,picwidth,picheight);
        savePCX(usevesa,target,xmin,ymin,picwidth-1,picheight-1,colors);
        (* savePCX(target,xmin,ymin,xmax,ymax,colors); *)
    END;

    IF Hires(Graph._DEFAULTMODE)=FALSE THEN abort(errMode,"text");END;

    abort(errNone,"");
END ViewPCX.
