(* --------------------------------------------------------------
Title         Q&D O'Clock
Author        PhG
Overview      tsk tsk...
Usage         see help
Notes         Graph library adds about 14 Kb, even if not called !
              flicker but TopSpeed won't let us use two pages on VGA,
              and EGA is ugly... maybe with a BGI VESA driver ?
              argh, there seems to have no way to flip pages...
              model must be LARGE or "better" for BGI
Bugs

Wish List     tsk tsk...

--------------------------------------------------------------- *)

MODULE Oclock;

IMPORT Lib;
IMPORT IO;
IMPORT Str;
IMPORT SYSTEM;
IMPORT MsMouse;
IMPORT BiosIO;

IMPORT MATHLIB;

IMPORT Graph;
IMPORT graphics;


FROM IO IMPORT WrStr,WrLn,WrCard;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim, str16,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    USEBGI     = FALSE; (* TRUE does not remove flicker :-( *)

    (* only valid for BGI driver, but no way to have flipping pages ! *)
    USEEGAVGA  = TRUE; (* no pages available ! *)
    USESVGA16  = FALSE; (* worse *)
    USESVGA256 = FALSE;
CONST
    ProgEXEname   = "OCLOCK";
    ProgTitle     = "Q&D O'Clock";
    ProgVersion   = "v1.0b";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone      = 0;
    errHelp      = 1;
    errOpt       = 2;
    errParm      = 3;
    errRange     = 4;
    errVGA       = 5;
    errCannotSet = 6;

PROCEDURE mak2 (VAR R : ARRAY OF CHAR;S1,S2:ARRAY OF CHAR);
BEGIN
    Str.Concat(R,S1,S2);
END mak2;

PROCEDURE mak3 (VAR R : ARRAY OF CHAR;S1,S2,S3:ARRAY OF CHAR);
BEGIN
    Str.Concat(R,S1,S2); Str.Append(R,S3);
END mak3;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr         = CHR(13);
    lf         = CHR(10);
    nl         = cr+lf;
CONST
(*
00000000011111111112222222222333333333344444444445555555555666666666677777777778
1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" [option]..."+nl+
nl+
"    -k    abort on keyboard only"+nl+
"    -i?:# color of Hours/Minutes/Seconds hand"+nl+
"    -ia:# color of marks"+nl+
"    -p:#  color of paper"+nl+
"    -r:#  outer radius of clock (top of marks)"+nl+
"    -r?:# length of Hours/Minutes/Seconds hand"+nl+
"    -la:# length of marks"+nl+
"    -s:#  shape of hands"+nl+
"    -m:#  shape of marks"+nl+
"    -wh:# width of hands"+nl+
"    -wm:# width of marks"+nl+
"    -nb   no borders"+nl+
"    -ib:# border color"+nl+
"    -f    integer minutes hand"+nl+
"    -t    audio ticks"+nl+
"    -u    draw seconds, then minutes, then hours"+nl+
"    -e    emphasis on hours angles (0h, 3h, 6h and 9h)"+nl+
"    -s    skeleton (only borders)"+nl+
"    -c    force full screen refresh (older method, used if hands overlap marks)"+nl+
nl+
"Color [0..15], length [0..239], shape [0..2] (rectangle,diamond,triangle)"+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errOpt   : mak3(S,"Unknown ",einfo," option !");
    | errParm  : mak3(S,"Useless ",einfo," parameter !");
    | errRange : mak3(S,"Illegal value in ",einfo," option !");
    | errVGA   :    S:="VGA card required !";
    | errCannotSet: S:="Cannot set required 640x480x16 mode !";

    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        (* nada *)
    ELSE
        WrStr(ProgEXEname+" : ");
        WrStr(S);
        WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    origin       = LONGREAL(90);
VAR
    PI      : LONGREAL;
    deg2rad : LONGREAL;

PROCEDURE inittrigo (  );
BEGIN
    PI      := 4.0 * MATHLIB.ATan(1.0);
    deg2rad := PI / 180.0;
END inittrigo;

PROCEDURE DegreesToRadians ( alphadeg : LONGREAL ) : LONGREAL ;
BEGIN
    RETURN (alphadeg * deg2rad);
END DegreesToRadians;

PROCEDURE RadiansToDegrees( alpha : LONGREAL ) : LONGREAL ;
BEGIN
    RETURN (alpha / deg2rad);
END RadiansToDegrees;

PROCEDURE PolarToRectangular (alphadeg:LONGREAL;radius,cx,cy:CARDINAL;VAR x,y : CARDINAL);
VAR
    alpha,dx,dy,co,si : LONGREAL;
BEGIN
    alpha := alphadeg;   (* +origin *)
    alpha := DegreesToRadians(alpha);
    co    := MATHLIB.Cos(alpha);
    si    := MATHLIB.Sin(alpha);
    dx    := LONGREAL(radius) * co;
    dy    := LONGREAL(radius) * si;
    (* x and y always > 0 *)
    x     := cx+VAL(CARDINAL,dx);
    y     := cy-VAL(CARDINAL,dy);
END PolarToRectangular;

(* x and y may be < 0 *)

PROCEDURE RectangularToPolar (x,y:INTEGER;VAR radius:CARDINAL;VAR alphadeg:LONGREAL);
VAR
    xx,yy,numerator,divisor:LONGREAL;
    si,co,r,alpha:LONGREAL;
BEGIN
    xx:=LONGREAL(x);
    yy:=LONGREAL(y);
    numerator := xx;
    divisor   := yy;
    alpha     := MATHLIB.ATan2(numerator,divisor);
    r         := MATHLIB.Sqrt (xx * xx + yy * yy);
    radius    := CARDINAL(r);
    alphadeg  := RadiansToDegrees(alpha);
END RectangularToPolar;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    minshape = 0;
    maxshape = 3;

CONST
    maxsides = 4;
VAR
    pAlpha : ARRAY [0..maxsides-1] OF LONGREAL;
    pR     : ARRAY [0..maxsides-1] OF CARDINAL;
    px     : ARRAY[0..maxsides-1] OF CARDINAL;
    py     : ARRAY[0..maxsides-1] OF CARDINAL;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    xmin         = 0;
    ymin         = 0;
    minrad       = 0;

CONST
    cBLACK	       =0;
    cPALEBLUE 	   =1;
    cPALEGREEN     =2;
    cPALECYAN      =3;
    cPALERED       =4;
    cPALEMAGENTA   =5;
    cBROWN         =6;
    cPALEWHITE     =7; (* was WHITE *)
    cGRAY          =8;
    cBLUE          =9;
    cGREEN         =10;
    cCYAN          =11;
    cRED           =12;
    cMAGENTA       =13;
    cYELLOW        =14;
    cWHITE         =15; (* was BRIGHTWHITE *)

    minink         = cBLACK;
    maxink         = cWHITE; (* was BRIGHTWHITE *)

TYPE
    palette16=ARRAY[0..15] OF LONGCARD;
CONST
    pal16=palette16(
    Graph._BLACK       ,
    Graph._BLUE        ,
    Graph._GREEN       ,
    Graph._CYAN        ,
    Graph._RED         ,
    Graph._MAGENTA     ,
    Graph._BROWN       ,
    Graph._WHITE       ,
    Graph._GRAY        ,
    Graph._LIGHTBLUE   ,
    Graph._LIGHTGREEN  ,
    Graph._LIGHTCYAN   ,
    Graph._LIGHTRED    ,
    Graph._LIGHTMAGENTA,
    Graph._LIGHTYELLOW ,
    Graph._BRIGHTWHITE ); (* crire la palette dans l'ordre original de dfinition des couleurs ! *)

PROCEDURE WaitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END WaitVGAretrace;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(*%F USEBGI *)

CONST                                           (* fastest handling ! *)
    tmode        = Graph._DEFAULTMODE;
    gmode        = Graph._VRES16COLOR;
    screenwidth  = 640;
    screenheight = 480;
    xmax         = screenwidth-1;
    ymax         = screenheight-1;
    cx           = xmax DIV 2;
    cy           = ymax DIV 2;
    maxrad       = cy;

PROCEDURE pset (x,y,ink:CARDINAL  );
BEGIN
    Graph.Plot(x,y,ink);
END pset;

PROCEDURE HiresOn () : BOOLEAN;
BEGIN
    RETURN Graph.SetVideoMode(gmode);
END HiresOn;

PROCEDURE TextOn (  ) : BOOLEAN;
BEGIN
    RETURN Graph.SetVideoMode(tmode);
END TextOn;

PROCEDURE GrLine (x1,y1,x2,y2:INTEGER;ink,pattern:CARDINAL);
BEGIN
    Graph.SetLinestyle(pattern);
    Graph.Line(x1,y1,x2,y2,ink);
END GrLine;

PROCEDURE GrCircle (cx,cy,r,ink:CARDINAL);
BEGIN
    Graph.Circle(cx,cy,r,ink);
END GrCircle;

PROCEDURE GrClearScreen();
BEGIN
    Graph.ClearScreen(Graph._GWINDOW);
END GrClearScreen;

PROCEDURE GrPolygon (sides:CARDINAL;px,py:ARRAY OF CARDINAL;ink:CARDINAL;
                     filled:BOOLEAN);
VAR
    i,x,y,lastx,lasty:CARDINAL;
BEGIN
    IF filled THEN
        Graph.Polygon(sides,px,py,ink);
    ELSE
        i:=1;
        lastx:=px[i-1];lasty:=py[i-1];
        LOOP
            x:=px[i];y:=py[i];
            Graph.Line(lastx,lasty,x,y,ink);
            lastx:=x;lasty:=y;
            INC(i);
            IF i = sides THEN EXIT;END;
        END;
        x:=px[0];y:=py[0];
        Graph.Line(lastx,lasty,x,y,ink);
    END;
END GrPolygon;

PROCEDURE GrSetBkColor (color : LONGCARD) : LONGCARD;
BEGIN
    RETURN Graph.SetBkColor(color);
END GrSetBkColor;

PROCEDURE VGAhere (  ) : BOOLEAN;
VAR
    infovideo : Graph.VideoConfig;
BEGIN
    Graph.GetVideoConfig(infovideo);
    IF infovideo.adapter # Graph._VGA THEN RETURN FALSE; END;
    RETURN TRUE;
END VGAhere;

(* dummy procedures *)

PROCEDURE initHGR ();
BEGIN
END initHGR;

PROCEDURE setviewwork (view,work:INTEGER);
BEGIN
END setviewwork;

PROCEDURE flipviewwork ();
BEGIN
END flipviewwork;

(*%E *)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(*%T USEBGI *)

VAR                                             (* slowest handling ! *)
    screenwidth,screenheight : CARDINAL;
    xmax,ymax                : CARDINAL;
    cx,cy,maxrad             : CARDINAL;

VAR
    polydef : ARRAY [0..maxsides-1] OF graphics.PointType;

VAR
    gmode   : INTEGER;

VAR
    GraphDriver : INTEGER;
    GraphMode   : INTEGER;

PROCEDURE DetectSVGA () : INTEGER;
BEGIN
    RETURN gmode;
END DetectSVGA;

PROCEDURE pset (x,y,ink:CARDINAL  );
BEGIN
    graphics.putpixel( INTEGER(x), INTEGER(y), INTEGER(ink) );
END pset;

PROCEDURE HiresOn () : BOOLEAN;
BEGIN
    GraphMode   := gmode;
    graphics.initgraph(GraphDriver,GraphMode,"");
    RETURN (graphics.graphresult() = graphics.grOk);
END HiresOn;

PROCEDURE TextOn (  ) : BOOLEAN;
VAR
    rc : INTEGER;
BEGIN
    graphics.restorecrtmode;
    rc := graphics.graphresult();
    graphics.closegraph;
    RETURN (rc = graphics.grOk);
END TextOn;

PROCEDURE GrLine (x1,y1,x2,y2:INTEGER;ink,pattern:CARDINAL);
BEGIN
    graphics.setlinestyle(graphics.UserBitLn, pattern, graphics.NormWidth );
    graphics.setcolor( INTEGER(ink) );
    graphics.line(x1,y1,x2,y2);
END GrLine;

PROCEDURE GrCircle (cx,cy,r,ink:CARDINAL);
BEGIN
    graphics.setcolor( INTEGER(ink) );
    graphics.circle( INTEGER(cx), INTEGER(cy), INTEGER(r) );
END GrCircle;

PROCEDURE GrClearScreen();
BEGIN
    graphics.cleardevice;
END GrClearScreen;

PROCEDURE GrPolygon (sides:CARDINAL;px,py:ARRAY OF CARDINAL;ink:CARDINAL;
                     filled:BOOLEAN);
VAR
    i,x,y,lastx,lasty:CARDINAL;
BEGIN
    IF filled THEN
        (*
        graphics.setlinestyle(graphics.SolidLn, graphics.SolidFill, graphics.NormWidth );
        *)
        graphics.setfillstyle(graphics.SolidFill,ink);
        graphics.fillpoly( INTEGER(sides) ,polydef );
    ELSE
        (* probably useless...
        graphics.setlinestyle(graphics.SolidLn, graphics.SolidFill, graphics.NormWidth );
        *)
        graphics.setcolor ( INTEGER(ink) );
        graphics.drawpoly( INTEGER(sides) ,polydef );
        (* now close it because BGI won't ! *)
        x     :=polydef[0].x;       y    :=polydef[0].y;
        lastx :=polydef[sides-1].x; lasty:=polydef[sides-1].y;
        graphics.line(x,y,lastx,lasty);
    END;
END GrPolygon;

PROCEDURE GrSetLinestyle(pattern : CARDINAL);
BEGIN
    graphics.setlinestyle(graphics.UserBitLn, pattern, graphics.NormWidth );
END GrSetLinestyle;

PROCEDURE GrSetBkColor (color : LONGCARD) : LONGCARD;
VAR
    oldink : INTEGER;
BEGIN
    oldink := graphics.getbkcolor();
    graphics.setbkcolor( INTEGER(color) );
    RETURN LONGCARD(oldink);
END GrSetBkColor;

(* ------------------------------------------------------------ *)

(* installuserdriver requires direct constants *)

PROCEDURE VGAhere (  ) : BOOLEAN;
VAR
    rc : INTEGER;
BEGIN

(*%T USEEGAVGA  *)
    (* graphics.VGAHi, "VGA" *)
    rc:=graphics.registerfarbgidriver( ADR(graphics.EGAVGA_driver_far) );
(*%E  *)
(*%T USESVGA16 *)
    (* graphics.SVGA800x600x16 *)
    GraphDriver := graphics.installuserdriver("SVGA16", graphics.driverproc(DetectSVGA) );
    rc:=graphics.registerfarbgidriver( ADR(graphics.Svga16_driver_far) );
(*%E *)
(*%T USESVGA256 *)
    (* graphics.SVGA1024x768x256 *)
    GraphDriver := graphics.installuserdriver("SVGA256", graphics.driverproc(DetectSVGA) );
    rc:=graphics.registerfarbgidriver( ADR(graphics.Svga256_driver_far) );
(*%E *)
    RETURN (graphics.graphresult() = graphics.grOk);
END VGAhere;

(* ------------------------------------------------------------ *)

PROCEDURE initHGR ();
BEGIN
    screenwidth  := 640;
    screenheight := 480;

(*%T USEEGAVGA *)
    gmode        := graphics.VGAHi;
(*%E *)
(*%T USESVGA16  *)
    gmode   := graphics.SVGA640x480x16;
(*%E  *)
(*%T USESVGA256  *)
    gmode   := graphics.SVGA640x480x256;
(*%E  *)
    xmax         := screenwidth-1;
    ymax         := screenheight-1;
    cx           := xmax DIV 2;
    cy           := ymax DIV 2;
    maxrad       := cy;
END initHGR;

VAR
    viewpage,workpage:INTEGER;

PROCEDURE setviewwork (view,work:INTEGER);
BEGIN
    viewpage:=view;
    workpage:=work;
    graphics.setactivepage(workpage);
    graphics.setvisualpage(viewpage);
END setviewwork;

PROCEDURE flipviewwork ();
VAR
    view,work:CARDINAL;
BEGIN
    view:=workpage;
    work:=viewpage;
    setviewwork(view,work);
    (* setviewwork(workpage,viewpage); *)
END flipviewwork;

(*%E *)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

VAR
    DEBUG : BOOLEAN;
    hink,mink,sink,aink,paper          : CARDINAL;
    stopmouse,border                   : BOOLEAN;
    fixedmm,audio,smh,emphasis,skel    : BOOLEAN;
    alternaterefresh                   : BOOLEAN;
    radius,hlen,mlen,slen,marklen      : CARDINAL;
    handshape,markshape                : CARDINAL;
    wmark,whand                        : CARDINAL;
    bink                               : CARDINAL;

PROCEDURE defaults (  );
BEGIN
    hink     := cBLUE;
    mink     := cBLUE;
    sink     := cPALECYAN;

    aink     := cPALECYAN;
    paper    := cBLACK;
    stopmouse:= TRUE;

    radius   := maxrad;
    marklen  := maxrad DIV 10;
    hlen     := marklen * 6;
    mlen     := marklen * 8;
    slen     := marklen * 9;

    handshape:= 2;
    markshape:= 0;

    wmark    := marklen DIV 2;
    whand    := marklen DIV 2;

    border   := TRUE;
    bink     := cYELLOW;

    fixedmm  := FALSE;
    audio    := FALSE;
    smh      := FALSE;
    emphasis := FALSE;
    skel     := FALSE;

    alternaterefresh := TRUE; (* force it *)
END defaults;

CONST
    oldtime = 1;
    newtime = 2;
TYPE
    hmsType = RECORD
        hh,mm,ss,hss,minutes,seconds:CARDINAL;
    END;

(* ------------------------------------------------------------ *)


(*
    each shape is defined this way :

    y
    :
    :   P4      P1
    0...........x  (x is xref)
        P3      P2

    etc.

*)

PROCEDURE buildshape (whatshape,xref,longueur,largeur:CARDINAL;hand:BOOLEAN):CARDINAL;
VAR
    i:CARDINAL;
    ix,ih,iw:INTEGER;
    x,y:INTEGER;
BEGIN
    IF hand THEN INC(whatshape,maxshape+1);END;

    ix :=INTEGER(xref);
    ih :=INTEGER(longueur);
    iw :=INTEGER(largeur);

    (* order of definition is VERY important for it traces contours !!! *)

    i := 0;
    CASE whatshape OF
    (* marks *)
    | 0: (* rectangle *)
        x := ix;    y :=  (iw DIV 2);RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := ix;    y := -(iw DIV 2);RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := ix-ih; y := -(iw DIV 2);RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := ix-ih; y :=  (iw DIV 2);RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
    | 1: (* diamond *)
        x := ix;            y :=  0;         RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := ix-(ih DIV 2); y := -(iw DIV 2);RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := ix-ih;         y := 0;          RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := ix-(ih DIV 2); y := (iw DIV 2); RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
    | 2: (* decreasing triangle *)
        x := ix;     y := 0;           RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := ix-ih;  y := -(iw DIV 2); RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := ix-ih;  y :=  (iw DIV 2); RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
    | 3: (* increasing triangle *)
        x := ix;     y := -(iw DIV 2); RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := ix;     y :=  (iw DIV 2); RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := ix-ih;  y := 0;           RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);

    (* hands *)
    | 4: (* rectangle *)
        x := ix;    y :=  (iw DIV 2);RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := ix;    y := -(iw DIV 2);RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x :=   -ih; y := -(iw DIV 2);RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x :=   -ih; y :=  (iw DIV 2);RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
    | 5: (* diamond *)
        x := ix;            y :=  0;         RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := 0            ; y := -(iw DIV 2);RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x :=   -ih;         y := 0;          RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := 0            ; y := (iw DIV 2); RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
    | 6: (* decreasing triangle *)
        x := ix;   y := 0;           RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := -ih;  y := -(iw DIV 2); RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := -ih;  y :=  (iw DIV 2); RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
    | 7: (* increasing triangle *)
        x := ix;     y := -(iw DIV 2); RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := ix;     y :=  (iw DIV 2); RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
        x := -ih;    y := 0;           RectangularToPolar (x,y,  pR[i], pAlpha[i]);INC(i);
    END;
    RETURN i;
END buildshape;

PROCEDURE rotateshape (sides,cx,cy:CARDINAL;angle:LONGREAL );
VAR
    i  : CARDINAL;
    radius,x,y: CARDINAL;
    alphadeg:LONGREAL;
BEGIN
    FOR i := 1 TO sides DO
        alphadeg := pAlpha[i-1] - angle + origin;
        radius   := pR[i-1];
        PolarToRectangular (alphadeg,radius,cx,cy, x,y);
(*%F USEBGI  *)
        px[i-1]:=x; py[i-1]:=y;
(*%E  *)
(*%T USEBGI  *)
        polydef[i-1].x:= INTEGER(x); polydef[i-1].y:= INTEGER(y);
(*%E  *)
    END;
END rotateshape;

PROCEDURE showmarks (cx,cy:CARDINAL );
VAR
    sides,angle : CARDINAL;
    alphadeg    : LONGREAL;
    rayon,longueur,largeur : CARDINAL;
BEGIN
(*
FOR angle := 0 TO 359 BY 6 DO
    alphadeg:=LONGREAL(angle);
    rotateshape(sides,cx,cy, alphadeg);
    GrPolygon(sides,px,py,cGREEN,TRUE);
END;
*)
    FOR angle := 0 TO 330 BY 30 DO
        rayon    := radius;
        longueur := marklen;
        largeur  := wmark;
        IF emphasis THEN
            CASE angle OF
            | 0,90,180,270 :
            ELSE
                rayon    := radius- marklen DIV 4;
                longueur := marklen-marklen DIV 2;
                largeur  := wmark-wmark DIV 2;
            END;
        END;
        sides:=buildshape(markshape, rayon,longueur,largeur,FALSE);
        alphadeg:=LONGREAL(angle);
        rotateshape(sides,cx,cy, alphadeg);
        IF NOT(skel) THEN GrPolygon(sides,px,py,aink,TRUE); END;
        IF border THEN
            GrPolygon(sides,px,py,bink,FALSE);
        END;
    END;
END showmarks;

PROCEDURE showhand (draw,usefrac:BOOLEAN;
                    cx,cy,len,ink,count,divisions,
                    units,circonf:CARDINAL);
VAR
    sides,portion,basealpha:CARDINAL;
    n,fraction,alphadeg:LONGREAL;
BEGIN
    sides:=buildshape(handshape,len,marklen,whand,TRUE);

    portion   := 360 DIV divisions;
    basealpha := portion * count;
    IF usefrac THEN (* hours only *)
        fraction  := LONGREAL(units) / LONGREAL(circonf);
    ELSE
        fraction := 0.0; (* for minutes and seconds, else they would be always 1 more ! *)
    END;

    alphadeg :=  LONGREAL (basealpha)+fraction*LONGREAL(portion);

    rotateshape(sides,cx,cy, alphadeg);
    IF NOT(draw) THEN ink:=paper;END;
    IF NOT(skel) THEN GrPolygon(sides,px,py,ink,TRUE); END;
    IF border THEN
        IF draw THEN
            ink := bink;
        ELSE
            ink := paper;
        END;
        GrPolygon(sides,px,py,ink,FALSE);
    END;
END showhand;

PROCEDURE showhands (cx,cy:CARDINAL;hms:hmsType;draw:BOOLEAN);
VAR
    ink:CARDINAL;
BEGIN
    IF smh THEN
        showhand(draw,FALSE        ,cx,cy,slen,sink, hms.ss,60, 0,0);
        showhand(draw,NOT(fixedmm) ,cx,cy,mlen,mink, hms.mm,60, hms.ss,60);
        showhand(draw,TRUE         ,cx,cy,hlen,hink, hms.hh,12, hms.mm,60);
    ELSE
        showhand(draw,TRUE         ,cx,cy,hlen,hink, hms.hh,12, hms.mm,60);
        showhand(draw,NOT(fixedmm) ,cx,cy,mlen,mink, hms.mm,60, hms.ss,60);
        showhand(draw,FALSE        ,cx,cy,slen,sink, hms.ss,60, 0,0);
    END;
END showhands;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE now (VAR hms:hmsType);
CONST
    noon = 12;
VAR
    hh,mm,ss,hss:CARDINAL;
BEGIN
    Lib.GetTime(hh,mm,ss,hss);
    IF hh > noon THEN DEC(hh,noon); END;
    hms.hh       := hh;
    hms.mm       := mm;
    hms.ss       := ss;
    hms.hss      := hss;
    hms.minutes  := hh * 60 + mm;
    hms.seconds  := hms.minutes * 60 + ss;
END now;

PROCEDURE value (S:ARRAY OF CHAR;min,max:CARDINAL;VAR r:CARDINAL):BOOLEAN;
VAR
    v : LONGCARD;
BEGIN
    IF GetLongCard(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGCARD(min) THEN RETURN FALSE; END;
    IF v > LONGCARD(max) THEN RETURN FALSE; END;
    r := CARDINAL(v);
    RETURN TRUE;
END value;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    keyEscape  = 01B00H;
    keyCR      = 00D00H;

VAR
    i,opt,parmcount  : CARDINAL;
    S,R              : str128;

    chk              : BOOLEAN;
    keycode          : CARDINAL;
    bgr              : LONGCARD;
    mytime           : ARRAY [oldtime..newtime] OF hmsType;
BEGIN
    Lib.DisableBreakCheck();
    WrLn;                       (* must be here for pretty ulterior display ! *)

    initHGR;  (* must come first for BGI ! important variables defined here *)
    defaults;
    DEBUG := FALSE;

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R)=TRUE THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "IH:"+delim+
                                   "IM:"+delim+
                                   "IS:"+delim+
                                   "IA:"+delim+
                                   "P:"+delim+
                                   "K"+delim+
                                   "R:"+delim+
                                   "RH:"+delim+
                                   "RM:"+delim+
                                   "RS:"+delim+
                                   "LA:"+delim+
                                   "S:"+delim+
                                   "M:"+delim+
                                   "WH:"+delim+
                                   "WM:"+delim+
                                   "NB"+delim+
                                   "IB:"+delim+
                                   "F"+delim+
                                   "T"+delim+
                                   "U"+delim+
                                   "E"+delim+
                                   "S"+delim+
                                   "C"+delim+
                                   "DEBUG"
                               );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4 : IF value(R,minink,maxink,hink)=FALSE THEN abort(errRange,R);END;
            | 5 : IF value(R,minink,maxink,mink)=FALSE THEN abort(errRange,R);END;
            | 6 : IF value(R,minink,maxink,sink)=FALSE THEN abort(errRange,R);END;
            | 7 : IF value(R,minink,maxink,aink)=FALSE THEN abort(errRange,R);END;
            | 8 : IF value(R,minink,maxink,paper)=FALSE THEN abort(errRange,R);END;
            | 9 : stopmouse := FALSE;
            | 10: IF value(R,minrad,maxrad,radius)=FALSE THEN abort(errRange,R);END;
            | 11: IF value(R,minrad,maxrad,hlen)=FALSE THEN abort(errRange,R);END;
            | 12: IF value(R,minrad,maxrad,mlen)=FALSE THEN abort(errRange,R);END;
            | 13: IF value(R,minrad,maxrad,slen)=FALSE THEN abort(errRange,R);END;
            | 14: IF value(R,minrad,maxrad,marklen)=FALSE THEN abort(errRange,R);END;
            | 15: IF value(R,minshape,maxshape-1,handshape)=FALSE THEN abort(errRange,R);END;
            | 16: IF value(R,minshape,maxshape  ,markshape)=FALSE THEN abort(errRange,R);END;
            | 17: IF value(R,minrad,maxrad,whand)=FALSE THEN abort(errRange,R);END;
            | 18: IF value(R,minrad,maxrad,wmark)=FALSE THEN abort(errRange,R);END;
            | 19: border := FALSE;
            | 20: IF value(R,minink,maxink,bink)=FALSE THEN abort(errRange,R);END;
            | 21: fixedmm:=TRUE;
            | 22: audio:=TRUE;
            | 23: smh:=TRUE;
            | 24: emphasis:=TRUE;
            | 25: skel:=TRUE;
            | 26: alternaterefresh:=FALSE;
            | 27: DEBUG := TRUE;
            ELSE
                abort(errOpt,S);
            END;
        ELSE
            abort(errParm,S);
        END;
    END;

    IF alternaterefresh THEN
        i  := radius-marklen;
        opt:= 0;
        IF hlen >= i THEN INC(opt); END;
        IF mlen >= i THEN INC(opt); END;
        IF slen >= i THEN INC(opt); END;
        IF opt # 0 THEN alternaterefresh := FALSE; END;
    END;

    IF skel THEN border:=TRUE; END;

    initHGR;

    IF VGAhere()=FALSE THEN abort(errVGA,"");END;
    IF HiresOn()=FALSE THEN
        chk := TextOn();
        abort(errCannotSet,"");
    END;

    (* setviewwork(0,1); *)

    bgr:=GrSetBkColor ( pal16[paper] );
    GrClearScreen;

    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;

    inittrigo();

    showmarks(cx,cy);
    i:=oldtime;
    now( mytime[i] );
    showhands(cx,cy,mytime[i], TRUE );

    (* flipviewwork; *)

    LOOP
        i := newtime;
        now( mytime[i] );
(*%F USEBGI  *)
        IF mytime[i].ss # mytime[oldtime].ss THEN
            WaitVGAretrace; (* more and/or elsewhere increases flicker ! *)
            IF alternaterefresh THEN
                showhands(cx,cy,mytime[oldtime], FALSE );
            ELSE
                GrClearScreen;
            END;
IF DEBUG THEN
GrLine(0,cy,xmax,cy,cWHITE,0FFFFH);GrLine(cx,0,cx,ymax,cWHITE,0FFFFH);
GrCircle(cx,cy,cy,cWHITE);         GrCircle(cx,cy,cy-marklen,cWHITE);
END;
            showmarks(cx,cy);
            showhands(cx,cy,mytime[i], TRUE );
            IF audio THEN Lib.Sound(111);Lib.Delay(1);Lib.NoSound;END;
            mytime[oldtime]:=mytime[i];
        END;
(*%E  *)

(*%T USEBGI  *)
        IF (mytime[i].ss # mytime[oldtime].ss) THEN
            WaitVGAretrace;
            IF alternaterefresh THEN
                showhands(cx,cy,mytime[oldtime], FALSE );
            ELSE
                GrClearScreen;
            END;
IF DEBUG THEN
GrLine(0,cy,xmax,cy,cWHITE,0FFFFH);GrLine(cx,0,cx,ymax,cWHITE,0FFFFH);
GrCircle(cx,cy,cy,cWHITE);         GrCircle(cx,cy,cy-marklen,cWHITE);
END;
            showmarks(cx,cy);
            showhands(cx,cy,mytime[i], TRUE );
            WaitVGAretrace;
            (* flipviewwork; *)
            IF audio THEN Lib.Sound(111);Lib.Delay(1);Lib.NoSound;END;
            mytime[oldtime]:=mytime[i];
        END;
(*%E *)
        chk:=getKeyboardCode(keycode);
        IF chk THEN
            CASE keycode OF
            | keyEscape     : EXIT;
            | keyCR         : EXIT;
            END;
        END;
        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;
    END;

    chk:=TextOn();
    flushKeyboard();
    abort(errNone,"");
END Oclock.

