
(* ---------------------------------------------------------------
Title         Q&D Pulsar demo
Author        PhG
Overview      tsk tsk...
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
              model should definitely be LARGE
              not very pretty...
Bugs

Wish List     tsk tsk...

--------------------------------------------------------------- *)

MODULE Pulsar;

IMPORT Lib;
IMPORT SYSTEM;
IMPORT IO;
IMPORT Str;
IMPORT BiosIO;
IMPORT MATHLIB;
IMPORT MsMouse;

FROM IO IMPORT WrStr, WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode;

FROM Lib IMPORT FarFill,FarWordMove;
FROM Storage IMPORT ALLOCATE;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    goodalgo   = TRUE;  (* FALSE for a not so bugfree a line algorithm *)

CONST
    ProgEXEname   = "PULSAR";
    ProgTitle     = "Q&D Pulsar demo";
    ProgVersion   = "v1.0a";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone           = 0;
    errHelp           = 1;
    errIllegalParm    = 2;
    errUnknownOpt     = 3;
    errRange          = 4;
    errBothRequired   = 5;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr         = CHR(13);
    lf         = CHR(10);
    nl         = cr+lf;
CONST
    (*
     00000000011111111112222222222333333333344444444445555555555666666666677777777778
     1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
    *)
    helpmsg =
    Banner+nl+
    nl+
    "Syntax : "+ProgEXEname+" [option]..."+nl+
    nl+
    "  -a   show palette until keypress or 10 seconds"+nl+
    "  -z   end on mouseclick too"+nl+
    "  -p:# color palette (0..7=rgbRGB*$)"+nl+
    "  -d   diagonal cross fade (default is normal cross fade)"+nl+
    "  -w:# wait ([0..50], default=0)"+nl+
    "  -i:# RGB ink color (user palette) -- hex prefix is $"+nl+
    "  -f:# RGB ink to fade to color (user palette) -- hex prefix is $"+nl+
    "  -x   double smoothing"+nl+
    nl+
    "[nd]-normal/dithered smooth, [ot]-one/two passes, [Escape|Enter]-end"+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errIllegalParm :
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," parameter !");
    | errUnknownOpt :
        Str.Concat(S,"Unknown ",einfo); Str.Append(S," option !");
    | errRange :
        Str.Concat(S,"Value for ",einfo);
        Str.Append(S," not in legal range !");
    | errBothRequired:
        S := "Both ink and ink to fade to are required for user palette !";

    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        (* nada *)
    ELSE
        WrStr(ProgEXEname+" : ");
        WrStr(S);
        WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    keyEscape  = 01B00H;
    keySpace   = 02000H;
    keyCR      = 00D00H;
    keyStar    = ORD("*") << 8 ;
    keydollar  = ORD("$") << 8 ;
    upperR     = ORD("R") << 8 ;
    lowerR     = ORD("r") << 8 ;
    upperG     = ORD("G") << 8 ;
    lowerG     = ORD("g") << 8 ;
    upperB     = ORD("B") << 8 ;
    lowerB     = ORD("b") << 8 ;
    upperD     = ORD("D") << 8 ;
    lowerD     = ORD("d") << 8 ;
    upperN     = ORD("N") << 8 ;
    lowerN     = ORD("n") << 8 ;
    upperO     = ORD("O") << 8 ;
    lowerO     = ORD("o") << 8 ;
    upperT     = ORD("T") << 8 ;
    lowerT     = ORD("t") << 8 ;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := ORD(c1)*256 + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

PROCEDURE input (maxWait:LONGINT); (* in seconds *)
VAR
    keycode:CARDINAL;
    h,m,s,ss:CARDINAL;
    start : LONGINT;
    now   : LONGINT;
BEGIN
    Lib.GetTime(h,m,s,ss);
    start := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
    LOOP
        IF getKeyboardCode(keycode) THEN EXIT; END;
        Lib.GetTime(h,m,s,ss);
        now := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
        IF ABS(now-start) > maxWait THEN EXIT; END;
    END;
END input;

PROCEDURE getrndrange (lower,upper:CARDINAL):CARDINAL;
VAR
    range : CARDINAL;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN CARDINAL(rnd);
END getrndrange;

PROCEDURE getrndrangeint (lower,upper:INTEGER):INTEGER;
VAR
    range : INTEGER;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN INTEGER(rnd);
END getrndrangeint;

(* ------------------------------------------------------------ *)

PROCEDURE longvalue (S:ARRAY OF CHAR;min,max:LONGCARD;VAR r:LONGCARD):BOOLEAN;
VAR
    R : str128;
    ok: BOOLEAN;
BEGIN
    GetString(S,R);
    IF Str.Length(R)=0 THEN RETURN FALSE; END;
    IF R[0]="$" THEN
        Str.Delete(R,0,1);
        r:=Str.StrToCard(R,16,ok);
        IF ok=FALSE THEN RETURN FALSE; END;
    ELSE
        IF GetLongCard(S,r)=FALSE THEN RETURN FALSE; END;
    END;
    IF r < min THEN RETURN FALSE; END;
    IF r > max THEN RETURN FALSE; END;
    RETURN TRUE;
END longvalue;

PROCEDURE ivalue (S:ARRAY OF CHAR;min,max:INTEGER;VAR r:INTEGER):BOOLEAN;
VAR
    v : LONGINT;
BEGIN
    IF GetLongInt(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGINT(min) THEN RETURN FALSE; END;
    IF v > LONGINT(max) THEN RETURN FALSE; END;
    r := INTEGER(v);
    RETURN TRUE;
END ivalue;

PROCEDURE value (S:ARRAY OF CHAR;min,max:CARDINAL;VAR r:CARDINAL):BOOLEAN;
VAR
    v : LONGCARD;
BEGIN
    IF GetLongCard(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGCARD(min) THEN RETURN FALSE; END;
    IF v > LONGCARD(max) THEN RETURN FALSE; END;
    r := CARDINAL(v);
    RETURN TRUE;
END value;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    minWait          = 0;
    maxWait          = 50;
    maxWaitInSeconds = 10;
TYPE
    palettetype = (redpal,greenpal,bluepal,rpal,gpal,bpal,randompal,
                   userpal,descentpal,systempal);
VAR
    gInk,gInkFadeTo : LONGCARD; (* for user palette *)

CONST
    hires = 13H; (* 320x200x256 *)
    text  = 03H; (* 80x25 *)
    xcount = 320;
    ycount = 200;
    xmin = 0;
    xmax = xcount-1;
    ymin = 0;
    ymax = ycount-1;
    xcenter = xmax DIV 2;
    ycenter = ymax DIV 2;
    screensize = xcount * ycount + xcount; (* added REQUIRED safety *)
    screensizeW=(screensize DIV 2);
TYPE
    screenType = ARRAY [0..screensize-1 +1] OF BYTE;   (* 320x200=64000 with security *)
VAR
    SmoothScreen : POINTER TO screenType;
    Screen       : POINTER TO screenType;
VAR
    videoscreen [0A000H:0000H] : ARRAY [0..screensize-1] OF BYTE;
    Ybase                      : ARRAY [ymin..ymax] OF CARDINAL;

(* ------------------------------------------------------------ *)

PROCEDURE initYbase ();
VAR
    i,p:CARDINAL;
BEGIN
    p := 0;
    FOR i := ymin TO ymax DO
        Ybase[i]:=p;
        INC(p,xcount);
    END;
END initYbase;

PROCEDURE setVideoMode (mode:CARDINAL);
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AH := 00H;
    R.AL := BYTE(mode);
    Lib.Intr(R,10H);
END setVideoMode;

PROCEDURE WaitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END WaitVGAretrace;

(* ------------------------------------------------------------ *)

CONST
    black       = LONGCARD(0000000H);
    white       = LONGCARD(03F3F3FH); (* ega/vga range is $00..$3F *)
    red         = LONGCARD(03F0000H);
    green       = LONGCARD(0003F00H);
    darkgreen   = LONGCARD(0002000H);
    blue        = LONGCARD(000003FH);
    darkblue    = LONGCARD(0000020H);
    cyan        = LONGCARD(0002F3FH);
    yellow      = LONGCARD(03F3F00H);
    darkred     = LONGCARD(0200000H);
    orange      = LONGCARD(02F2F00H);
CONST
    egarange = 40H;
    minColor   = 0000000H;
    maxColor   = 0FFFFFFH;
    mininkindex = 0;
    maxinkindex = 128-1;
    lastinkindex= 256-1;
    ndxblack = mininkindex;
VAR
    mininkline : CARDINAL; (* default is 104 *)

PROCEDURE setDAC(index:CARDINAL;red,green,blue:BYTE);
CONST
    DACWriteIndex  = 03C8H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACWriteIndex,SHORTCARD(index));
    SYSTEM.Out (DACDataRegister, red);
    SYSTEM.Out (DACDataRegister, green);
    SYSTEM.Out (DACDataRegister, blue);
END setDAC;

PROCEDURE readDACrgb (index:CARDINAL):LONGCARD;
CONST
    DACReadIndex   = 03C7H;
    DACDataRegister= 03C9H;
VAR
    r,g,b:SHORTCARD;
    rgb : LONGCARD;
BEGIN
    SYSTEM.Out (DACReadIndex,SHORTCARD(index));
    r:=SYSTEM.In (DACDataRegister);
    g:=SYSTEM.In (DACDataRegister);
    b:=SYSTEM.In (DACDataRegister);
    rgb := (LONGCARD(r) << 16) + (LONGCARD(g) << 8) + LONGCARD(b);
    RETURN rgb;
END readDACrgb;

PROCEDURE resetdac (index,red,green,blue:CARDINAL);
BEGIN
    setDAC(index,BYTE(red),BYTE(green),BYTE(blue));
END resetdac;

PROCEDURE blend (ndx,count:CARDINAL; startink, endink:LONGCARD);
CONST
    rshift = LONGCARD(16);
    gshift = LONGCARD(8);
VAR
    r1,g1,b1:INTEGER;
    r2,g2,b2:INTEGER;
    r,g,b:INTEGER;
    i : CARDINAL;
BEGIN
    r1 := INTEGER (startink >> rshift) MOD egarange;
    g1 := INTEGER (startink >> gshift) MOD egarange;
    b1 := INTEGER (startink          ) MOD egarange;
    r2 := INTEGER (endink   >> rshift) MOD egarange;
    g2 := INTEGER (endink   >> gshift) MOD egarange;
    b2 := INTEGER (endink            ) MOD egarange;

    FOR i := 1 TO count DO
        r := r1 + ((r2 - r1) * INTEGER(i) ) DIV INTEGER(count);
        g := g1 + ((g2 - g1) * INTEGER(i) ) DIV INTEGER(count);
        b := b1 + ((b2 - b1) * INTEGER(i) ) DIV INTEGER(count);
        IF r < 0 THEN r:=0; END;
        IF g < 0 THEN g:=0; END;
        IF b < 0 THEN b:=0; END;
        IF r >= egarange THEN r:=egarange-1; END;
        IF g >= egarange THEN g:=egarange-1; END;
        IF b >= egarange THEN b:=egarange-1; END;
        setDAC(ndx+i-1,BYTE(r),BYTE(g),BYTE(b));
    END;
END blend;

PROCEDURE normalize (VAR lc:LONGCARD);
VAR
    r,g,b:CARDINAL;
BEGIN
    r := CARDINAL(lc MOD 100H);
    g := CARDINAL(lc DIV 100H) MOD 100H;
    b := CARDINAL(lc DIV 10000H);
    r := r >> 2; (* MOD egarange; *)
    g := g >> 2;
    b := b >> 2;
    lc := LONGCARD(b) << 16 + LONGCARD(g) << 8 + LONGCARD(r);
END normalize;

PROCEDURE newPalette (pal:palettetype);
VAR
    ndx : CARDINAL;
    n   : CARDINAL;
    i   : CARDINAL;
    j,r,g,b:CARDINAL ;
BEGIN
    WaitVGAretrace(); (* reduce noise on screen *)
    (* 0..127 *)
    (* we were starting from $1F1F03 !*)
    CASE pal OF
    | redpal:
        ndx := 0;         n := 16;
        blend (ndx,n,0000000H,02F0804H);
        INC(ndx,n);       n := 48;
        blend (ndx,n,02F0804H,03F2F2FH);
        INC(ndx,n);       n := 64;
        blend (ndx,n,03F2F2FH,03F3F3FH);
    | greenpal:
        ndx := 0;         n := 16;
        blend (ndx,n,0000000H,0082F04H);
        INC(ndx,n);       n := 64;
        blend (ndx,n,0082F04H,01F3F1FH);
        INC(ndx,n);       n := 48;
        blend (ndx,n,01F3F1FH,03F3F3FH);
    | bluepal:
        ndx := 0;         n := 16;
        blend (ndx,n,0000000H,004082FH);
        INC(ndx,n);       n := 64;
        blend (ndx,n,004082FH,01F1F3FH);
        INC(ndx,n);       n := 48;
        blend (ndx,n,01F1F3FH,03F3F3FH);
    | rpal:
        ndx := 0;         n := 16;
        blend (ndx,n,0000000H,02F0804H);
        INC(ndx,n);       n := 64;
        blend (ndx,n,02F0804H,yellow);
        INC(ndx,n);       n := 48;
        blend (ndx,n,yellow,white);
    | gpal:
        ndx := 0;         n := 16;
        blend (ndx,n,0000000H,0082F04H);
        INC(ndx,n);       n := 64;
        blend (ndx,n,0082F04H,yellow);
        INC(ndx,n);       n := 48;
        blend (ndx,n,yellow,white);
    | bpal:
        ndx := 0;         n := 16;
        blend (ndx,n,0000000H,004082FH);
        INC(ndx,n);       n := 64;
        blend (ndx,n,004082FH,cyan);
        INC(ndx,n);       n := 48;
        blend (ndx,n,cyan,white);
    | randompal :
        FOR i := mininkindex TO maxinkindex DO
            setDAC(i,BYTE(getrndrange(0,egarange-1)),BYTE(getrndrange(0,egarange-1)),BYTE(getrndrange(0,egarange-1)));
        END;
    | userpal:
        ndx := 0;         n := 128;
        blend (ndx,n,gInkFadeTo,gInk);
    | descentpal:
	    FOR j:=0 TO 64 DO
	        i:= j DIV 2;
		    (* Make 0-63 be red shades *)
		    r:= i ; g:= 0; b:= 0;
            setDAC(i,BYTE(r),BYTE(g),BYTE(b));
		    (* Make 64-127 be green shades *)
		    r:= 0; g:= i; b:= 0;
            setDAC(i+64 DIV 2, BYTE(r),BYTE(g),BYTE(b));
		    (* Make 128-191 be blue shades *)
		    r:= 0; g:= 0; b:= i ;
            setDAC(i+128 DIV 2, BYTE(r),BYTE(g),BYTE(b));
		    (* Make 192-255 be greyscale *)
		    r:= i  ; g:= i ; b:= i ;
            setDAC(i+192 DIV 2,BYTE(r),BYTE(g),BYTE(b));
        END;
    | systempal: (* do nothing *)

    END;
    setDAC(ndxblack,00H,00H,00H);

    ndx:=maxinkindex;       n := lastinkindex-maxinkindex+1;
    blend (ndx,n,readDACrgb(maxinkindex),readDACrgb(maxinkindex));

END newPalette;

PROCEDURE showPalette (  );
VAR
   i    : CARDINAL;
   xpos : CARDINAL;
   ypos : CARDINAL;
   p    : CARDINAL;
BEGIN
   FarFill(FarADR(videoscreen[0]),screensize,ndxblack); (* index of sky, so black *)
   FOR i := 0 TO 255 DO
       FOR ypos := ymin TO ymax DO
           p := Ybase[ypos] + i; (* was ypos * xcount + i *)
           videoscreen[p]:=BYTE(i);
       END;
   END;
   input (maxWaitInSeconds);
END showPalette;

(* ------------------------------------------------------------ *)

(* assume all coordinates are >= 0 *)

(*%F goodalgo *)
PROCEDURE zline (x1,y1,x2,y2:CARDINAL;ink:BYTE);
VAR
    x,y:CARDINAL;
    dx,dy,sx,sy,d:INTEGER;
BEGIN
    (*
        dx, dy = distance, d = deviation,
        sx, sy = sign of distance.
    *)

    dx := x2 - x1;
    dy := y2 - y1;
    IF dx > 0 THEN
        sx := 1
    ELSE
        sx := -1;
    END;
    IF dy > 0 THEN
        sy := 1
    ELSE
        sy := -1;
    END;
    dx := ABS(dx);
    dy := ABS(dy);
    x := x1;
    y := y1;

    IF dx > dy THEN
        d := (dy - dx) DIV 2;       (* X is major axis *)
        WHILE x # x2 DO
            Screen^[Ybase[y]+x]:=ink;  (* Put pixel *)
            IF d >= 0 THEN          (* Minor-axis change? *)
                DEC(d, dx);         (* Decrease by 1 *)
                INC(y, sy);
            END;
            INC(d, dy);             (* Increase by dy/dx *)
            INC(x, sx);
        END;
        Screen^[Ybase[y]+x]:=ink;      (* Put last pixel *)
    ELSE
        d := (dx - dy) DIV 2;       (* Y is major axis *)
        WHILE y # y2 DO
            Screen^[Ybase[y]+x]:=ink;
            IF d >= 0 THEN          (* Minor-axis change? *)
                DEC(d, dy);         (* Decrease by 1 *)
                INC(x, sx);
            END;
            INC(d, dx);             (* Increase by dx/dy *)
            INC(y, sy);
        END;
        Screen^[Ybase[y]+x]:=ink;
    END;
END zline;
(*%E  *)

(*%T goodalgo  *)
PROCEDURE zline(x1, y1, x2, y2 : CARDINAL; ink:BYTE);
VAR
    i, deltax, deltay, numpixels,
    d, dinc1, dinc2,
    x, xinc1, xinc2,
    y, yinc1, yinc2 : INTEGER;
BEGIN
    (* Calculate deltax and deltay for initialisation *)
    deltax := ABS( INTEGER(x2) - INTEGER(x1) );
    deltay := ABS( INTEGER(y2) - INTEGER(y1) );

    (* Initialize all vars based on which is the independent variable *)
    IF deltax >= deltay THEN
        (* x is independent variable *)
        numpixels := deltax + 1;
        d := (2 * deltay) - deltax;
        dinc1 := deltay << 1;
        dinc2 := (deltay - deltax) << 1;
        xinc1 := 1;
        xinc2 := 1;
        yinc1 := 0;
        yinc2 := 1;
    ELSE
        (* y is independent variable *)
        numpixels := deltay + 1;
        d := (2 * deltax) - deltay;
        dinc1 := deltax << 1;
        dinc2 := (deltax - deltay) << 1;
        xinc1 := 0;
        xinc2 := 1;
        yinc1 := 1;
        yinc2 := 1;
    END;

    (* Make sure x and y move in the right directions *)
    IF x1 > x2 THEN
        xinc1 := - xinc1;
        xinc2 := - xinc2;
    END;
    IF y1 > y2 THEN
        yinc1 := - yinc1;
        yinc2 := - yinc2;
    END;

    (* Start drawing at <x1, y1> *)
    x := CARDINAL(x1);
    y := CARDINAL(y1);

    (* Draw the pixels *)
    FOR i := 1 TO numpixels DO
        Screen^[Ybase[y]+CARDINAL(x)]:=ink;
        IF d < 0 THEN
            d := d + dinc1;
            x := x + xinc1;
            y := y + yinc1;
        ELSE
            d := d + dinc2;
            x := x + xinc2;
            y := y + yinc2;
        END;
    END;
END zline;
(*%E *)

PROCEDURE zplot (x,y:CARDINAL;ink:BYTE);
BEGIN
    Screen^[Ybase[y]+CARDINAL(x)]:=ink;
END zplot;

(* ------------------------------------------------------------ *)

PROCEDURE smoothAndRefresh (net:BOOLEAN);
VAR
    x,y:CARDINAL;
    ink,inkl,inkr,inku,inkd:CARDINAL;
    inklu,inkld,inkru,inkrd:CARDINAL;
    p:CARDINAL;
BEGIN
    (*
    (* seems to cure the weird apparition of dots at lower left side ! *)
    zline(xmin,ymax,xmax,ymax,ndxblack);
    *)

    FarFill(FarADR(SmoothScreen^),screensize,ndxblack);
    FOR y := ymin+1 TO ymax-1 DO
        p := Ybase[y]+xcount; (* was xcount * y *)
        FOR x := xmin+1 TO xmax-1 DO
            ink :=CARDINAL(Screen^[p+x])   ;
            IF net THEN
                inklu:=CARDINAL(Screen^[p+x-1-xcount]) ;
                inkru:=CARDINAL(Screen^[p+x+1-xcount]) ;
                inkld:=CARDINAL(Screen^[p+x-1+xcount]) ;
                inkrd:=CARDINAL(Screen^[p+x+1+xcount]) ;
                ink := (ink + inklu+inkru+inkld+inkrd ) DIV 5;
            ELSE
                inkl:=CARDINAL(Screen^[p+x-1]) ;
                inkr:=CARDINAL(Screen^[p+x+1]) ;
                inku:=CARDINAL(Screen^[p+x-xcount]) ;
                inkd:=CARDINAL(Screen^[p+x+xcount]) ;
                ink := (ink + inkl +inkr + inku + inkd ) DIV 5;
            END;

            SmoothScreen^[p+x]:=BYTE(ink);

        END;
    END;
    FarWordMove(FarADR(SmoothScreen^),FarADR(videoscreen[0]),screensizeW);
END smoothAndRefresh;

(* ------------------------------------------------------------ *)

CONST
    angle0   = 0;
    angle360 = 360;
    trigoK   = ymax;
VAR
    Tsinus   : ARRAY [angle0..angle360] OF INTEGER;
    Tcosinus : ARRAY [angle0..angle360] OF INTEGER;

PROCEDURE initTrigo (  );
VAR
    i : CARDINAL;
    v : LONGREAL;
    n : INTEGER;
BEGIN
    (* yes, we know ; in the good old Apple ][, we used more clever code... *)
    FOR i := angle0 TO angle360 DO
        v := MATHLIB.Sin(LONGREAL(i));
        n := INTEGER(v * LONGREAL(trigoK));
        Tsinus [i] := n;
        v := MATHLIB.Cos(LONGREAL(i));
        n := INTEGER(v * LONGREAL(trigoK));
        Tcosinus [i] := n;
    END;
END initTrigo;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

VAR
    parmcount   : CARDINAL;
    i           : CARDINAL;
    opt         : CARDINAL;
    S           : str128;
    R           : str128;
    v           : CARDINAL;

    palette     : palettetype;
    resille     : BOOLEAN;
    stopmouse   : BOOLEAN;
    showpal     : BOOLEAN;
    gWait       : CARDINAL;
    doublepass  : BOOLEAN;

    pause       : BOOLEAN;
    keycode     : CARDINAL;
    gotInk,gotInkFadeTo : BOOLEAN;
    lasteffect          : BOOLEAN;
    x,y:INTEGER;
    xx,yy : CARDINAL;
    ink:BYTE;
BEGIN
    Lib.DisableBreakCheck();
    WrLn;                       (* must be here for pretty ulterior display ! *)

    palette      := rpal;
    resille      := FALSE;
    stopmouse    := FALSE;
    showpal      := FALSE;
    gotInk       := FALSE;
    gotInkFadeTo := FALSE;
    gInk         := 0FFFF00H;
    gInkFadeTo   := 0AF0000H;
    gWait        := 0;
    doublepass   := FALSE;

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R)=TRUE THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "A"+delim+"SHOWPAL"+delim+
                                   "Z"+delim+"MOUSE"+delim+
                                   "P:"+delim+"PALETTE:"+delim+
                                   "D"+delim+"DIAGONAL"+delim+
                                   "W:"+delim+"WAIT:"+delim+
                                   "I:"+delim+"INK:"+delim+
                                   "F:"+delim+"INKFADETO:"+delim+
                                   "X"+delim+"DOUBLEPASS"
                               );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5 :
                showpal := TRUE;
            | 6,7:
                stopmouse:=TRUE;
            | 8,9:
                IF value(R,ORD(redpal),ORD(descentpal),v)=FALSE THEN
                    abort(errRange,"palette");
                END;
                palette:=palettetype(v);
            | 10,11:
                resille := TRUE;
            | 12,13:
                IF value(R,minWait,maxWait,gWait)=FALSE THEN
                    abort(errRange,"wait");
                END;
            | 14,15:
                IF longvalue(R,minColor,maxColor,gInk)=FALSE THEN
                    abort(errRange,"ink");
                END;
                gotInk := TRUE;
            | 16,17:
                IF longvalue(R,minColor,maxColor,gInkFadeTo)=FALSE THEN
                    abort(errRange,"ink to fade to");
                END;
                gotInkFadeTo := TRUE;
            | 18,19 :
                doublepass := TRUE;
            ELSE
                abort(errUnknownOpt,S);
            END;
        ELSE
            abort(errIllegalParm,S);
        END;
    END;

    CASE gotInk OF
    | TRUE:
        CASE gotInkFadeTo OF
        | TRUE:  palette := userpal; normalize(gInk); normalize(gInkFadeTo);
        | FALSE: abort(errBothRequired,"");
        END;
    | FALSE:
        CASE gotInkFadeTo OF
        | TRUE:  abort(errBothRequired,"");
        | FALSE: (* let it be *)
        END;
    END;

    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;

    Lib.RANDOMIZE;

    initTrigo;

    initYbase;
    NEW(Screen);
    NEW(SmoothScreen);

    setVideoMode(hires);
    newPalette(palette);

    FarFill(FarADR(videoscreen[0]),screensize,ndxblack);

    IF showpal THEN
        showPalette;
        FarFill(FarADR(videoscreen[0]),screensize,ndxblack);
    END;

    flushKeyboard;

    pause := FALSE;
    lasteffect := FALSE;

    FarFill(FarADR(Screen^),screensize,ndxblack);
    LOOP
        FOR i := 1 TO gWait DO
            WaitVGAretrace;
        END;
        IF pause=FALSE THEN
            y := 0;
            WHILE y <= 90 DO
                FOR x:=angle0 TO angle360 DO
                    xx := CARDINAL(xcenter + (Tcosinus[x] * y) DIV trigoK);
                    yy := CARDINAL(ycenter + (Tsinus[x] * y) DIV trigoK);
                    v := getrndrange(mininkindex,maxinkindex);
                    v := v + CARDINAL(y << 1) + CARDINAL(x >> 1);
                    ink := BYTE( v MOD maxinkindex );
                    Screen^[Ybase[yy]+xx]:=ink;
                END;
                INC(y);
            END;
            smoothAndRefresh(resille);
            IF doublepass THEN
                FarWordMove(FarADR(videoscreen[0]),FarADR(Screen^),screensizeW);
                smoothAndRefresh(resille);
            END;
        END;

        IF getKeyboardCode(keycode) THEN
            CASE keycode OF
            | upperD,lowerD : resille := TRUE;
            | upperN,lowerN : resille := FALSE;
            | lowerR        : newPalette(rpal);
            | lowerG        : newPalette(gpal);
            | lowerB        : newPalette(bpal);
            | upperR        : newPalette(redpal);
            | upperG        : newPalette(greenpal);
            | upperB        : newPalette(bluepal);
            | keyStar       : newPalette(randompal);
            | keydollar     : newPalette(descentpal);
            | keySpace      : pause:=NOT(pause);
            | keyEscape     : EXIT;
            | keyCR         : lasteffect:=TRUE; EXIT;
            | upperO,lowerO : doublepass:=FALSE;
            | upperT,lowerT : doublepass:=TRUE;
            END;
            IF keycode # keySpace THEN pause := FALSE; END;
        END;
        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;
    END;
    IF lasteffect THEN
        v:=192;
        FOR i:= 0 TO v DO
            FarWordMove(FarADR(videoscreen[0]),FarADR(Screen^),screensizeW);
            smoothAndRefresh(resille);
        END;
    END;

    setVideoMode(text);

    abort(errNone,"");
END Pulsar.

