
(* --------------------------------------------------------------
Title         Q&D Stars
Author        who cares ?
Overview      see help
Usage         see help
Notes         as usual...
              mode should be at last medium, preferably LARGE
              threshold must be set at 16384
Bugs

Wish List     tsk tsk...

--------------------------------------------------------------- *)

MODULE Stars;

IMPORT Lib;
IMPORT IO;
IMPORT Str;
IMPORT SYSTEM;
IMPORT MsMouse;
IMPORT BiosIO;

FROM IO IMPORT WrStr,WrLn,WrCard;

FROM ModeX IMPORT
Mode_320x200,Mode_320x400,Mode_360x200,Mode_360x400,
Mode_320x240,Mode_320x480,Mode_360x240,Mode_360x480,
SET_VGA_MODEX, SET_MODEX, CLEAR_VGA_SCREEN, SET_POINT, READ_POINT,
FILL_BLOCK, DRAW_LINE, SET_DAC_REGISTER, GET_DAC_REGISTER,
LOAD_DAC_REGISTERS, READ_DAC_REGISTERS,
SET_ACTIVE_PAGE, GET_ACTIVE_PAGE, SET_DISPLAY_PAGE, GET_DISPLAY_PAGE,
SET_WINDOW, GET_X_OFFSET, GET_Y_OFFSET, SYNC_DISPLAY,
GPRINTC, TGPRINTC, PRINT_STR, TPRINT_STR,
SET_DISPLAY_FONT, DRAW_BITMAP, TDRAW_BITMAP, COPY_PAGE, COPY_BITMAP,
mxTrue, mxFalse, mxnil,
c_BLACK, c_BLUE, c_GREEN, c_CYAN, c_RED, c_PURPLE, c_BROWN, c_WHITE,
c_GREY, c_bBLUE, c_bGREEN, c_bCYAN, c_bRED, c_bPURPLE, c_YELLOW, c_bWHITE,
c_BRIGHT,
Ky_F1, Ky_F2, Ky_F3, Ky_F4, Ky_F5, Ky_F6, Ky_F7, Ky_F8, Ky_F9, Ky_F10,
Ky_Up, Ky_Left, Ky_Right, Ky_Down,
Ky_SUp, Ky_SLeft, Ky_SRight, Ky_SDown,
Ky_Home, Ky_End, Ky_PgUp, Ky_PgDn,
Ky_SHome, Ky_SEnd, Ky_SPgUp, Ky_SPgDn,
Ky_Ins, Ky_Del, Ky_SIns, Ky_SDel, Ky_Tab, Ky_RvsTab, Ky_STab,
Ky_BS, Ky_CR, Ky_ESC, Ky_Clr, Ky_Plus, Ky_Minus,
Ky_AltA, Ky_AltB, Ky_AltC, Ky_AltD, Ky_AltE, Ky_AltF, Ky_AltG,
Ky_AltH, Ky_AltI, Ky_AltJ, Ky_AltK, Ky_AltL, Ky_AltM, Ky_AltN,
Ky_AltO, Ky_AltP, Ky_AltQ, Ky_AltR, Ky_AltS, Ky_AltT, Ky_AltU,
Ky_AltV, Ky_AltW, Ky_AltX, Ky_AltY, Ky_AltZ,
DOS_PRINT, DOS_PRINTS, SET_VIDEO_MODE,
SCAN_KEYBOARD, RANDOM_INT, INIT_RANDOM, INT_SQR, TIMER_COUNT;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim, str16,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows, cleantabs,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "STARS";
    ProgTitle     = "Q&D Twinkling Stars demo";
    ProgVersion   = "v1.0a";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
    credit        = "(public domain Mode X v1.04 library by Matt Pritchard)";

CONST
    errNone           = 0;
    errHelp           = 1;
    errIllegalParm    = 2;
    errUnknownOpt     = 3;
    errRange          = 4;
    errCannotSetModeX = 5;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr         = CHR(13);
    lf         = CHR(10);
    nl         = cr+lf;
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
Banner+nl+
nl+
credit+nl+
nl+
"Syntax : "+ProgEXEname+" [stars] [option]..."+nl+
nl+
"  -k    end on keypress only"+nl+
"  -s:#  speed ([1..100], default is 10)"+nl+
"  -x    360x240 video mode X (default is 320x240)"+nl+
"  -p    show palette until keypress or 10 seconds"+nl+
"  -v    verbose"+nl+
nl+
"Number of stars belongs to [1..1000] interval, default is 200."+nl+
nl+
"[PgUp|PgDn|*]  [Space]  [Escape|Enter]"+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errIllegalParm :
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," parameter !");
    | errUnknownOpt :
        Str.Concat(S,"Unknown ",einfo); Str.Append(S," option !");
    | errRange :
        Str.Concat(S,"Value for ",einfo);
        Str.Append(S," not in legal range !");
    | errCannotSetModeX:
        Str.Concat(S,"Cannot set required ",einfo);
        Str.Append(S," video mode X !");
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ; (* nada *)
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE doRandomize (  );
BEGIN
    Lib.RANDOMIZE;
END doRandomize;

PROCEDURE getrndrange (lower,upper:CARDINAL):CARDINAL;
VAR
    range : CARDINAL;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN CARDINAL(rnd);
END getrndrange;

PROCEDURE getrndrangeint (lower,upper:INTEGER):INTEGER;
VAR
    range : INTEGER;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN INTEGER(rnd);
END getrndrangeint;

PROCEDURE value (S:ARRAY OF CHAR;min,max:CARDINAL;VAR r:CARDINAL):BOOLEAN;
VAR
    v : LONGCARD;
BEGIN
    IF GetLongCard(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGCARD(min) THEN RETURN FALSE; END;
    IF v > LONGCARD(max) THEN RETURN FALSE; END;
    r := CARDINAL(v);
    RETURN TRUE;
END value;

PROCEDURE ivalue (S:ARRAY OF CHAR;min,max:INTEGER;VAR r:INTEGER):BOOLEAN;
VAR
    v : LONGINT;
BEGIN
    IF GetLongInt(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGINT(min) THEN RETURN FALSE; END;
    IF v > LONGINT(max) THEN RETURN FALSE; END;
    r := INTEGER(v);
    RETURN TRUE;
END ivalue;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

CONST
    keyEscape  = 01B00H;
    keySpace   = 02000H;
    keyCR      = 00D00H;
    keyPageUp  = 00049H;
    keyPageDn  = 00051H;
    keyStar    = ORD("*") << 8 ;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

PROCEDURE input (  );
CONST
    maxWait = 10; (* seconds *)
VAR
    keycode:CARDINAL;
    h,m,s,ss:CARDINAL;
    start : LONGINT;
    now   : LONGINT;
BEGIN
    Lib.GetTime(h,m,s,ss);
    start := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
    LOOP
        IF getKeyboardCode(keycode) THEN EXIT; END;
        Lib.GetTime(h,m,s,ss);
        now := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
        IF ABS(now-start) > maxWait THEN EXIT; END;
    END;
END input;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    xmin         = 0;
    ymin         = 0;
    viewpage     = 0;
    workpage     = 0;
    PagesVirtual = 1;
    zmin         = 0;

VAR
    sMode        : str16;
    hires        : CARDINAL;
    screenwidth  : CARDINAL;
    screenheight : CARDINAL;
    xmax         : CARDINAL;
    ymax         : CARDINAL;
    xMaxVirtual  : CARDINAL;
    yMaxVirtual  : CARDINAL;
    cx,cy        : INTEGER;
    zmax         : CARDINAL;
    (* to avoid casts *)
    iscreenwidth  : INTEGER;
    iscreenheight : INTEGER;
    ixmax         : INTEGER;
    iymax         : INTEGER;

PROCEDURE initHires (lores:BOOLEAN);
BEGIN
    IF lores THEN
        Str.Copy(sMode,"320x240x256");
        hires        := Mode_320x240;
        screenwidth  := 320;
        screenheight := 240;
        zmax         := screenwidth DIV 2; (* was screenheight, higher values are not pretty *)
    ELSE
        Str.Copy(sMode,"360x240x256");
        hires        := Mode_360x240;
        screenwidth  := 360;
        screenheight := 240;
        zmax         := screenwidth DIV 2;
    END;
    xmax        := screenwidth  -1;
    ymax        := screenheight -1;
    xMaxVirtual := screenwidth;
    yMaxVirtual := screenheight;
    cx          := INTEGER(xmax DIV 2);
    cy          := INTEGER(ymax DIV 2);
    (* to avoid casts *)
    iscreenwidth  := INTEGER(screenwidth);
    iscreenheight := INTEGER(screenheight);
    ixmax         := INTEGER(xmax);
    iymax         := INTEGER(ymax);
END initHires;


PROCEDURE HiresON ():BOOLEAN;
BEGIN
    RETURN (SET_VGA_MODEX(hires,xMaxVirtual,yMaxVirtual,PagesVirtual) # 0);
END HiresON;

PROCEDURE HiresOFF ();
CONST
    biostxtmode = 3;
BEGIN
    SET_VIDEO_MODE(biostxtmode);
END HiresOFF;

PROCEDURE ClearPage(paperindex:CARDINAL);
BEGIN
    CLEAR_VGA_SCREEN(paperindex);
END ClearPage;

PROCEDURE setviewwork (view,work:CARDINAL );
BEGIN
    SET_DISPLAY_PAGE(view);
    SET_ACTIVE_PAGE(work);
END setviewwork;

PROCEDURE WaitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END WaitVGAretrace;

(* ------------------------------------------------------------ *)

CONST
    ndxinkmin   = 256-1; (* 255 is reserved as black *)
    ndxinkmax   = 256-1;
    ndxinkblack = ndxinkmin;
    colorrange  = 64;
    colorpals   = 4;
CONST
    black       = LONGCARD(0000000H);
    white       = LONGCARD(03F3F3FH); (* ega/vga range is $00..$3F *)
    blue        = LONGCARD(000003FH);
    darkblue    = LONGCARD(0000020H);
    red         = LONGCARD(03F0000H);
    darkred     = LONGCARD(0200000H);
    green       = LONGCARD(0003F00H);
    darkgreen   = LONGCARD(0002000H);
    yellow      = LONGCARD(03F3F00H);
    orange      = LONGCARD(02F2F00H);
    cyan        = LONGCARD(0002F3FH);
CONST
    countcolors =6;
    countentries=30;
    firstrgb = 0;
    lastrgb  = countcolors*countentries*3-1;
TYPE
    palarraytype = ARRAY [firstrgb..lastrgb] OF BYTE;
CONST
    (* red green blue yellow aqua white *)
    thispal = palarraytype(
000H,000H,000H,006H,000H,000H,00CH,000H,000H,012H,000H,000H,018H,000H,000H,
01EH,000H,000H,024H,000H,000H,02AH,000H,000H,030H,000H,000H,036H,000H,000H,
03CH,000H,000H,03CH,000H,000H,036H,000H,000H,030H,000H,000H,02AH,000H,000H,
024H,000H,000H,01EH,000H,000H,018H,000H,000H,012H,000H,000H,00CH,000H,000H,
006H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,
000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,

000H,000H,000H,000H,006H,000H,000H,00CH,000H,000H,012H,000H,000H,018H,000H,
000H,01EH,000H,000H,024H,000H,000H,02AH,000H,000H,030H,000H,000H,036H,000H,
000H,03CH,000H,000H,03CH,000H,000H,036H,000H,000H,030H,000H,000H,02AH,000H,
000H,024H,000H,000H,01EH,000H,000H,018H,000H,000H,012H,000H,000H,00CH,000H,
000H,006H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,
000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,

000H,000H,000H,000H,000H,006H,000H,000H,00CH,000H,000H,012H,000H,000H,018H,
000H,000H,01EH,000H,000H,024H,000H,000H,02AH,000H,000H,030H,000H,000H,036H,
000H,000H,03CH,000H,000H,03CH,000H,000H,036H,000H,000H,030H,000H,000H,02AH,
000H,000H,024H,000H,000H,01EH,000H,000H,018H,000H,000H,012H,000H,000H,00CH,
000H,000H,006H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,
000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,

000H,000H,000H,006H,006H,000H,00CH,00CH,000H,012H,012H,000H,018H,018H,000H,
01EH,01EH,000H,024H,024H,000H,02AH,02AH,000H,030H,030H,000H,036H,036H,000H,
03CH,03CH,000H,03CH,03CH,000H,036H,036H,000H,030H,030H,000H,02AH,02AH,000H,
024H,024H,000H,01EH,01EH,000H,018H,018H,000H,012H,012H,000H,00CH,00CH,000H,
006H,006H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,
000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,

000H,000H,000H,000H,006H,006H,000H,00CH,00CH,000H,012H,012H,000H,018H,018H,
000H,01EH,01EH,000H,024H,024H,000H,02AH,02AH,000H,030H,030H,000H,036H,036H,
000H,03CH,03CH,000H,03CH,03CH,000H,036H,036H,000H,030H,030H,000H,02AH,02AH,
000H,024H,024H,000H,01EH,01EH,000H,018H,018H,000H,012H,012H,000H,00CH,00CH,
000H,006H,006H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,
000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,

000H,000H,000H,006H,006H,006H,00CH,00CH,00CH,012H,012H,012H,018H,018H,018H,
01EH,01EH,01EH,024H,024H,024H,02AH,02AH,02AH,030H,030H,030H,036H,036H,036H,
03CH,03CH,03CH,03CH,03CH,03CH,036H,036H,036H,030H,030H,030H,02AH,02AH,02AH,
024H,024H,024H,01EH,01EH,01EH,018H,018H,018H,012H,012H,012H,00CH,00CH,00CH,
006H,006H,006H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,
000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
    );

PROCEDURE setDAC(index:CARDINAL;red,green,blue:BYTE);
CONST
    DACWriteIndex  = 03C8H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACWriteIndex,SHORTCARD(index));
    SYSTEM.Out (DACDataRegister, red);
    SYSTEM.Out (DACDataRegister, green);
    SYSTEM.Out (DACDataRegister, blue);
END setDAC;

PROCEDURE MakePalette ();
VAR
    i,ndx:CARDINAL;
    r,g,b:BYTE;
BEGIN
    WaitVGAretrace;
    ndx:=ndxinkmin;
    FOR i:=firstrgb TO lastrgb BY 3 DO
        r:=thispal[i];
        g:=thispal[i+1];
        b:=thispal[i+2];
        setDAC(ndx,r,g,b);
        INC(ndx);
    END;
    setDAC(ndxinkblack, 00H,00H,00H); (* reset black *)
END MakePalette;

PROCEDURE showPalette (  );
VAR
    i,ink,x:CARDINAL;
BEGIN
    ink:=ndxinkmin;
    x:=xmin;
    i:=1;
    LOOP
        DRAW_LINE(x,ymin,x,ymax, ink);
        INC(x);
        INC(ink);
        INC(i); IF i > countcolors*countentries THEN EXIT; END;
    END;
    input;
END showPalette;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(*
	0, 0, 1, 0, 0,
	0, 0, 3, 0, 0,
	1, 3, 6, 3, 1,
	0, 0, 3, 0, 0,
	0, 0, 1, 0, 0,

	0, 0, 6, 0, 0,
	0, 0, 3, 0, 0,
	6, 3, 1, 3, 6,
	0, 0, 3, 0, 0,
	0, 0, 6, 0, 0
*)

CONST
    firststar        = 1;
    maxstar          = 1000; (* more is overcrowded anyway ! *)
    defaultstar      = 200;
    starstep         = 50;

    minspeed         = 1;
    maxspeed         = 100;
    defaultspeed     = 10;
    speedstep        = 1;
    minage           = 0;
    minagemax        = 5;
    maxagemax        = 10;

    wistar = 2; (* -2 -1 0 +1 +2 *)
    diastar= wistar+1+wistar;
TYPE
    shapetype = (dot,smallcross,bigcross);
    startype = RECORD
        x,y:CARDINAL;
        ink,inkmax:CARDINAL;
        agemax,age:CARDINAL;
        shape:shapetype;
    END;
VAR
    star : ARRAY [firststar..maxstar] OF startype;

PROCEDURE create (ndx:CARDINAL; firsttime:BOOLEAN    );
CONST
    maxround = maxstar*10;
VAR
    x,y,i,overlap,round:CARDINAL;
    shape:shapetype;
BEGIN
    round:=0;
    LOOP
        x:=getrndrange(xmin+wistar,xmax-wistar);
        y:=getrndrange(ymin+wistar,ymax-wistar);
        overlap:=0;
        FOR i:=firststar TO ndx-1 DO
            IF ABS(INTEGER(x)-INTEGER(star[i].x)) <= diastar THEN
                IF ABS(INTEGER(y)-INTEGER(star[i].y)) <= diastar THEN
                    INC(overlap);
                END;
            END;
        END;
        INC(round);
        IF round=maxround THEN overlap:=0; END; (* safety *)
        IF overlap=0 THEN EXIT; END;
    END;
    star[ndx].x:=x;
    star[ndx].y:=y;
    star[ndx].ink:=(getrndrange(1,countcolors)-1)*countentries;
    star[ndx].inkmax:=star[ndx].ink+countentries-1;
    star[ndx].agemax:=getrndrange(minagemax,maxagemax);
    IF firsttime THEN
        i:=getrndrange(minage,star[ndx].agemax);
    ELSE
        i:=minage;
    END;
    star[ndx].age:=i;
    CASE getrndrange(1,3) OF
    | 0: shape:=dot;
    | 1: shape:=smallcross;
    | 2: shape:=bigcross;
    END;
    star[ndx].shape:=shape;
END create;

(* ah, this is really ugly ! *)

PROCEDURE drawstar (x,y,ink,inkmax:CARDINAL;shape:shapetype;erase:BOOLEAN);
BEGIN
    IF erase THEN ink:=ndxinkblack;inkmax:=ndxinkblack;END;
    CASE shape OF
    | dot:
        SET_POINT(x,y,ink);
    |smallcross:
        SET_POINT(x,y,ink);
        INC(ink); IF ink > inkmax THEN ink:=inkmax; END;
        SET_POINT(x,y-1,ink);
        SET_POINT(x,y+1,ink);
        SET_POINT(x-1,y,ink);
        SET_POINT(x+1,y,ink);
    |bigcross:
        SET_POINT(x,y,ink);
        INC(ink); IF ink > inkmax THEN ink:=inkmax; END;
        SET_POINT(x,y-1,ink);
        SET_POINT(x,y+1,ink);
        SET_POINT(x-1,y,ink);
        SET_POINT(x+1,y,ink);
        INC(ink); IF ink > inkmax THEN ink:=inkmax; END;
        SET_POINT(x,y-2,ink);
        SET_POINT(x,y+2,ink);
        SET_POINT(x-2,y,ink);
        SET_POINT(x+2,y,ink);
    END;
END drawstar;

PROCEDURE twinkle (ndx:CARDINAL);
BEGIN
    WITH star[ndx] DO
        INC (age);
        IF age>=agemax THEN (* was =, but > is added safety *)
            age:=minage;
            INC(ink);
            IF ink>inkmax THEN
                drawstar(x,y,ink,inkmax,shape,TRUE);
                create(ndx,FALSE );
            ELSE
                drawstar(x,y,ink,inkmax,shape,FALSE);
            END;
        END;
    END;
END twinkle;

PROCEDURE procStars (last:CARDINAL;init:BOOLEAN);
VAR
    i:CARDINAL;
BEGIN
    FOR i:=firststar TO last DO
        IF  init THEN
            create(i,TRUE );
        ELSE
            twinkle(i);
        END;
    END;
END procStars;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

VAR
    parmcount   : CARDINAL;
    i           : CARDINAL;
    opt         : CARDINAL;
    S           : str128;
    R           : str128;
    v           : CARDINAL;
VAR
    stopmouse,lores,showpal,verbose : BOOLEAN;
    speed       : CARDINAL;
    laststar    : CARDINAL;
VAR
    keycode,turn: CARDINAL;
    singlestep  : BOOLEAN;
    chk         : BOOLEAN;
BEGIN
    Lib.DisableBreakCheck();
    WrLn;                       (* must be here for pretty ulterior display ! *)

    stopmouse    := TRUE;
    speed        := defaultspeed;
    laststar     := defaultstar;
    verbose      := FALSE;
    lores        := TRUE;
    showpal      := FALSE;

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R); cleantabs(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "K"+delim+"KEYPRESS"+delim+
                                   "S:"+delim+"SPEED:"+delim+
                                   "V"+delim+"VERBOSE"+delim+
                                   "X"+delim+"360X240"+delim+
                                   "P"+delim+"PALETTE"
                               );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5 :   stopmouse:=FALSE;
            | 6,7:    IF value(R,minspeed,maxspeed,speed)=FALSE THEN
                          abort(errRange,"speed");
                      END;
            | 8,9:    verbose:=TRUE;
            | 10,11:  lores := FALSE;
            | 12,13 : showpal:=TRUE;
            ELSE
                abort(errUnknownOpt,S);
            END;
        ELSE
            Str.Prepend(R,"N:");
            IF value(R,firststar,maxstar,laststar)=FALSE THEN
                abort(errRange,"number of stars");
            END;
            (* abort(errIllegalParm,S); *)
        END;
    END;

    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;

    doRandomize;

    initHires(lores);

    IF HiresON() = FALSE THEN
        HiresOFF;
        abort(errCannotSetModeX,sMode);
    END;
    setviewwork(viewpage,workpage);
    MakePalette();
    ClearPage (ndxinkblack);

    IF showpal THEN showPalette();ClearPage(ndxinkblack);END;

    procStars(laststar,TRUE);

    flushKeyboard();
    singlestep := FALSE;
    turn       := 0;

    LOOP
        (* WaitVGAretrace; *)
        Lib.Delay(speed); (* milliseconds *)

        procStars(laststar,FALSE);

        INC (turn);
        turn := turn MOD 256; (* just in case *)

        (* read and process key *)
        IF singlestep THEN
            WHILE getKeyboardCode(keycode)=FALSE DO
            END;
            chk:=(keycode # keySpace);
            singlestep:=NOT(chk);
        ELSE
            chk:=getKeyboardCode(keycode);
        END;
        IF chk THEN
            CASE keycode OF
            | keyEscape     : EXIT;
            | keyCR         : EXIT;
            | keyPageDn     : FOR i:=1 TO speedstep DO
                                  IF speed < maxspeed THEN INC(speed); END;
                              END;
            | keyPageUp     : FOR i:=1 TO speedstep DO
                                  IF speed > minspeed THEN DEC(speed);END;
                              END;
            | keyStar       : speed:=defaultspeed;
            | keySpace      : singlestep:=NOT (singlestep);
            END;
        END;
        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;
    END;

    HiresOFF;
    IF verbose THEN
        WrStr("Stars : ");IO.WrCard(laststar,5);WrLn;
        WrStr("Speed : ");IO.WrCard(speed,5);WrLn;
    END;
    abort(errNone,"");
END Stars.
