
$CPU 8086 ' XT- and AT- compatible ! ;-)

$LIB ALL OFF
$ERROR ALL OFF
$OPTIMIZE SIZE
$COMPILE UNIT

$CODE SEG "PhG" ' try and avoid 64K pb with this crap compiler

DEFINT A-Z

%False = 0
%True = NOT %False

'--------------------------------------------------------------------

' needed by Upper$, Lower$, argC, argV$

%quote = &H22 ' CHR$(34) is ["]

' needed by argC, argV$

%blank = &H20 ' CHR$(32) is [space]
%empty = 0
%intoken = 1
%instring = 2

' needed by Exist, CanWrite

%faR = 1
%faH = 2
%faS = 4
%faV = 8
%faD = 16
%faA = 32
%faLegal = %faR+%faH+%faS+%faD+%faA ' readonly,hidden,system,subdir,archive

' needed by DosVersion

%FLAGS = 0
%AX    = 1
%BX    = 2
%CX    = 3
%DX    = 4
%SI    = 5
%DI    = 6
%BP    = 7
%DS    = 8
%ES    = 9

%Dos = &h21 ' DOS call
%hi = &h100 ' 256

'--------------------------------------------------------------------
' l$ = Upper$(s$)

FUNCTION Upper$ (BYVAL s$) PUBLIC
table$ = table$ + "                                "
table$ = table$ + " !"
table$ = table$ + CHR$(%quote)
table$ = table$ +    "#$%&'()*+,-./0123456789:;<=>?"
table$ = table$ + "@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_"
table$ = table$ + "`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~"
table$ = table$ + "CUEAAAACEEEIIIAAE  OOOUUYOU     "
table$ = table$ + "AIOUNN                          "
table$ = table$ + "                                "
table$ = table$ + "                                "
new$ = ""
sPos = 1
DO UNTIL sPos > LEN(s$)
    char$ = MID$(s$, sPos, 1)
    code = ASC(char$)
    cap$ = MID$(table$, code+1, 1)
    IF cap$=" " THEN
        new$ = new$ + char$
    ELSE
        new$ = new$ + cap$
    END IF
    INCR sPos
LOOP
Upper$ = new$
END FUNCTION

'--------------------------------------------------------------------
' l$ = Lower$(s$)

FUNCTION Lower$ (BYVAL s$) PUBLIC
table$ = table$ + "                                "
table$ = table$ + " !"
table$ = table$ + CHR$(%quote)
table$ = table$ +    "#$%&'()*+,-./0123456789:;<=>?"
table$ = table$ + "@abcdefghijklmnopqrstuvwxyz[\]^_"
table$ = table$ + "`abcdefghijklmnopqrstuvwxyz{|}~"
table$ = table$ + "       "
table$ = table$ + "                          "
table$ = table$ + "                                "
table$ = table$ + "                                "
new$ = ""
sPos = 1
DO UNTIL sPos > LEN(s$)
    char$ = MID$(s$, sPos, 1)
    code = ASC(char$)
    cap$ = MID$(table$, code+1, 1)
    IF cap$=" " THEN
        new$ = new$ + char$
    ELSE
        new$ = new$ + cap$
    END IF
    INCR sPos
LOOP
Lower$ = new$
END FUNCTION

'--------------------------------------------------------------------
' paramcount = argC (cli$)

FUNCTION ArgC (BYVAL s$) PUBLIC
cli$=LTRIM$(RTRIM$(s$))
cliLen = LEN(cli$)
cliPos = 1
argCount = 0
state=%empty
DO UNTIL cliPos > cliLen
    char$=MID$(cli$,cliPos,1)
    code = ASC(char$)
    SELECT CASE state
    CASE %empty
        SELECT CASE code
        CASE %quote
            state=%instring ' begin new string
            arg$=char$
            INCR argCount
        CASE > %blank ' quote already trapped
            state=%intoken ' begin new token
            arg$=char$
            INCR argCount
        END SELECT
    CASE %intoken
        SELECT CASE code
        CASE %quote ' quote in token
            state=%instring ' if string in parameter
            arg$=arg$+char$
        CASE > %blank
            arg$=arg$+char$
        CASE ELSE
            state=%empty ' end of token
        END SELECT
    CASE %instring
        SELECT CASE code
        CASE %quote
            arg$=arg$+char$
            state=%empty ' end of string
        CASE > %blank
            arg$=arg$+char$
        CASE ELSE
            arg$=arg$+CHR$(%blank) ' remove TAB if any
        END SELECT
    END SELECT
    INCR cliPos
LOOP
ArgC = argCount
END FUNCTION

'--------------------------------------------------------------------
' param$ = ArgV$ (cli$, parmnumber) you must take care yourself of case

FUNCTION ArgV$ (BYVAL s$, BYVAL n) PUBLIC
IF n < 1 OR n > ArgC(s$) THEN
    argV$=""
    EXIT FUNCTION
END IF
cli$=LTRIM$(RTRIM$(s$))
cliLen = LEN(cli$)
cliPos = 1
argCount = 0
state=%empty
DO UNTIL cliPos > cliLen
    char$=MID$(cli$,cliPos,1)
    code = ASC(char$)
    SELECT CASE state
    CASE %empty
        IF n = argCount THEN ' argV$ test
            EXIT DO
        END IF
        SELECT CASE code
        CASE %quote
            state=%instring ' begin new string
            arg$=char$
            INCR argCount
        CASE > %blank ' quote already trapped
            state=%intoken ' begin new token
            arg$=char$
            INCR argCount
        END SELECT
    CASE %intoken
        SELECT CASE code
        CASE %quote ' quote in token
            state=%instring ' if string in parameter
            arg$=arg$+char$
        CASE > %blank
            arg$=arg$+char$
        CASE ELSE
            state=%empty ' end of token
        END SELECT
    CASE %instring
        SELECT CASE code
        CASE %quote
            arg$=arg$+char$
            state=%empty ' end of string
        CASE > %blank
            arg$=arg$+char$
        CASE ELSE
            arg$=arg$+CHR$(%blank) ' remove TAB if any
        END SELECT
    END SELECT
    INCR cliPos
LOOP
ArgV$ = arg$
END FUNCTION

'--------------------------------------------------------------------
' ok = Exist(filename$)

FUNCTION Exist(BYVAL filename$) PUBLIC
IF LEN(DIR$(filename$,%faLegal)) > 0 THEN
    Exist = %True
ELSE
    Exist = %False
END IF
END FUNCTION

'--------------------------------------------------------------------
' ok = CanWrite(filename$)

FUNCTION CanWrite (BYVAL filename$) PUBLIC
attr=ATTRIB(filename$)
IF (attr AND %faR) = 0 THEN
    CanWrite = %True
ELSE
    CanWrite = %False
END IF
END FUNCTION

'--------------------------------------------------------------------
' if DosVersion < 330 then

FUNCTION DosVersion () PUBLIC
REG %AX, &H30 * %hi
CALL INTERRUPT %Dos
rc??=REG(%AX)
major = rc?? MOD %hi    ' al
minor = rc?? \ %hi      ' ah
DosVersion = major*100+minor
END FUNCTION

'--------------------------------------------------------------------
' private for GetArg0$

FUNCTION GetPSP??
REG %AX, &H62 * %hi
CALL INTERRUPT %Dos
GetPSP?? = REG(%BX)
END FUNCTION

'--------------------------------------------------------------------
' exename$= GetArg0$ (alternative for DOS call function 60h)

FUNCTION GetArg0$ () PUBLIC
PSPAddr?? = GetPSP??
DEF SEG = PSPAddr??
ptrtoenv??=PEEK (&H2C)+PEEK(&H2D)* %hi ' &H2C is offset to environment block
DEF SEG = ptrtoenv??
ptr=0
DO UNTIL PEEK(ptr) = 0 AND PEEK(ptr+1) = 0 ' till end of environment
    INCR ptr
LOOP
INCR ptr,4 ' skip 00 00 lo hi
length=0
DO UNTIL PEEK(ptr+length)=0
    INCR length
LOOP
exename$ = PEEK$(ptr,length)
DEF SEG
GetArg0$=exename$
END FUNCTION

'--------------------------------------------------------------------
' assume canonical fullpath is legal
' splitpath ("c:\foo\bar.bat","c:","\foo\","bar.bat")
' directory always ends with \

SUB SplitPath (BYVAL fullpath$,unit$,directory$,filename$) PUBLIC
unit$=""
directory$=""
filename$=""
charpos=LEN(fullpath$)
DO WHILE charpos > 0
    char$=MID$(fullpath$,charpos,1)
    SELECT CASE char$
    CASE "\" ' "/" too ???
        DO WHILE charpos > 0
            char$=MID$(fullpath$,charpos,1)
            IF char$=":" THEN
                unit$=LEFT$(fullpath$,charpos)
                charpos=0
            ELSE
                directory$=char$+directory$
                DECR charpos
            END IF
        LOOP
    CASE ":"
        unit$=LEFT$(fullpath$,charpos)
        charpos=0
    CASE ELSE
        filename$=char$+filename$
        DECR charpos
    END SELECT
LOOP
END SUB

'--------------------------------------------------------------------
' assume filename is legal
' splitfilename ("foo.bar","foo","bar")

SUB SplitName (BYVAL filename$,theName$,extension$) PUBLIC
dotpos=INSTR(filename$,".")
IF dotpos=0 THEN
    theName$=filename$
    extension$=""
ELSE
    theName$=MID$(filename$,1,dotpos-1)
    extension$=MID$(filename$,dotpos+1)
END IF
END SUB

'--------------------------------------------------------------------
' if filename$ does not exist, create it so that writeini is happy!
' here we don't care creating original file in order to make backup
' (only one extension)

FUNCTION MakeBak (BYVAL filename$,BYVAL bakextension$) PUBLIC
filename$=Upper$(filename$)
IF Exist(filename$) = %False THEN
    hnd=FREEFILE
    OPEN "O",#hnd,filename$
    CLOSE #hnd
END IF
' now we can create backup !
IF LEFT$(bakextension$,1) = "." THEN
    bakextension$=MID$(bakextension$,2)
END IF
CALL SplitName(filename$,n$,e$)
bakname$=n$+"."+bakextension$
IF filename$=Upper$(bakname$) THEN ' identical files!
    MakeBak=%False
    EXIT FUNCTION
END IF
IF Exist(bakname$) =%True THEN
    IF CanWrite(bakname$)=%False THEN
        MakeBak=%False
        EXIT FUNCTION
    END IF
    KILL bakname$
END IF
NAME filename$ AS bakname$
MakeBak=%True
END FUNCTION

'--------------------------------------------------------------------
' private for next 3 routines

FUNCTION MatchInIt(BYVAL optionstr$,BYVAL test$,BYVAL exact)
IF RIGHT$(optionstr$,1) <> "|" THEN
    optionstr$=optionstr$+"|" ' trick to scan for alternates
END IF
IF LEFT$(optionstr$,1) <> "|" THEN
    optionstr$="|"+optionstr$ ' trick to scan for alternates
END IF
test$="|"+test$+"|" ' trick to scan for alternates and avoid duplicates
IF exact=%False THEN
    optionstr$=Upper$(optionstr$)
    test$=Upper$(test$)
END IF
IF INSTR(optionstr$,test$) = 0 THEN
    MatchInIt=%False
ELSE
    MatchInIt=%True
END IF
END FUNCTION

'--------------------------------------------------------------------
' arg is a command alone without specifier
' numberofargfound = FindArg(cli$, "?|H",%True)

FUNCTION FindArg (BYVAL s$, BYVAL arg$, BYVAL exact) PUBLIC
count=0
FOR i = 1 TO ArgC(s$)
    thisarg$=ArgV$(s$,i)
    IF MatchInIt(arg$,thisarg$,exact) = %True THEN
        INCR count
    END IF
NEXT
FindArg=count ' 0 is none found, else number of args
END FUNCTION

'--------------------------------------------------------------------
' opt is a command preceded by / or -
' numberofoptfound = FindOpt(cli$,"?|H",%false)

FUNCTION FindOpt (BYVAL s$, BYVAL opt$, BYVAL exact) PUBLIC
count=0
FOR i = 1 TO ArgC(s$)
    thisopt$=ArgV$(s$,i)
    first$=LEFT$(thisopt$,1)
    IF INSTR ("/-",first$) > 0 THEN
        thisopt$=MID$(thisopt$,2) ' remove leading / or -
        IF MatchInIt(opt$,thisopt$,exact) = %True THEN
            INCR count
        END IF
    END IF
NEXT
FindOpt=count ' 0 is none found, else number of options
END FUNCTION

'--------------------------------------------------------------------
' opt is a command preceded by / or -
' numberofoptstringfound = FindOptStr(cli$,"LA|lat",%false,result$)
' if several, keep first string found

FUNCTION FindOptStr (BYVAL s$, BYVAL opt$, BYVAL exact,result$) PUBLIC
count=0
FOR i = 1 TO ArgC(s$)
    thisopt$=ArgV$(s$,i)
    first$=LEFT$(thisopt$,1)
    IF INSTR("/-",first$) > 0 THEN
        thisopt$=MID$(thisopt$,2) ' remove leading / or -
        posequ=INSTR(thisopt$,ANY ":=") ' find first : or =
        IF posequ > 0 THEN ' xxx=yyyy
            r$=MID$(thisopt$,posequ+1) ' yyyy
            thisopt$=LEFT$(thisopt$,posequ-1) ' xxx
            IF MatchInIt(opt$,thisopt$,exact) = %True THEN
                IF count = 0 THEN
                    result$=r$ ' keep first only
                END IF
                INCR count
            END IF
        END IF
    END IF
NEXT
FindOptStr=count ' 0 is none found, else number of options
END FUNCTION

'--------------------------------------------------------------------
' returns first parameter WITHOUT / nor - (i.e. a filename)
' numberoffilenamefound = FindParamterStr(cli$,filename$)
' if several, keep first string found

FUNCTION FindParameterStr (BYVAL s$, result$) PUBLIC
count=0
FOR i = 1 TO ArgC(s$)
    thisopt$=ArgV$(s$,i)
    first$=LEFT$(thisopt$,1)
    IF INSTR("/-",first$) = 0 THEN
        IF count = 0 THEN
            result$=thisopt$ ' keep first only
        END IF
        INCR count
    END IF
NEXT
FindParameterStr=count ' 0 is none found, else number of options
END FUNCTION

' find many filenames given on command line
' no error checking : check number yourself!
FUNCTION FindThisParameterStr$ (BYVAL s$, BYVAL number) PUBLIC
result$=""
count=1
FOR i = 1 TO ArgC(s$)
    thisopt$=ArgV$(s$,i)
    first$=LEFT$(thisopt$,1)
    IF INSTR("/-",first$) = 0 THEN
        IF count = number THEN
            result$=thisopt$ ' keep first only
            EXIT FOR
        END IF
        INCR count
    END IF
NEXT
FindThisParameterStr$=result$
END FUNCTION

'--------------------------------------------------------------------
' force end with a trailing \
FUNCTION GetTmpDir$ () PUBLIC
tmp$=Upper$(ENVIRON$("TMP"))
IF tmp$="" THEN
    tmp$=Upper$(ENVIRON$("TEMP"))
END IF
IF tmp$<>"" THEN
    IF RIGHT$(tmp$,1) <> "\" THEN
        tmp$=tmp$+"\" ' force end with \
    END IF
ELSE ' no tmp variable defined, so use exe directory
    t$=GetArg0$
    t$=Upper$(t$)
    CALL SplitPath(t$,currunit$,currpath$,currfile$)
    tmp$=currunit$+currpath$ ' already ends with \
END IF
GetTmpDir$=tmp$
END FUNCTION

'--------------------------------------------------------------------
' should check for A..Z!!!

FUNCTION GetFreeSpace???(BYVAL u$) PUBLIC ' 1=A:, 3=C:, 4=D:
u$=Upper$(u$)
u$=LEFT$(u$,1) ' keep just letter
drive=ASC(u$)-ASC("A")+1
REG(%DX),drive
REG(%AX),&H36*%hi
CALL INTERRUPT %Dos
SectorsPerCluster = REG(%AX)
IF SectorsPerCluster = &HFFFF THEN ' drive does not exist
    GetFreeSpace???=0
ELSE
    FreeClusters=REG(%BX)
    BytesPerSector = REG(%CX)
    free???=SectorsPerCluster*FreeClusters*BytesPerSector
    GetFreeSpace???=free???
END IF
END FUNCTION
'--------------------------------------------------------------------
' private for SoundexAlt

FUNCTION IsVoyelle (BYVAL c$)
IsVoyelle=%False
IF c$="" THEN EXIT FUNCTION
IF INSTR("AEIOUY",c$) > 0 THEN IsVoyelle = %True
END FUNCTION

FUNCTION IsVoyelleForte (BYVAL c$)
IsVoyelleForte=%False
IF c$="" THEN EXIT FUNCTION
IF INSTR("AOU",c$) > 0 THEN IsVoyelleForte = %True
END FUNCTION

FUNCTION IsVoyelleFaible (BYVAL c$)
IsVoyelleFaible=%False
IF c$="" THEN EXIT FUNCTION
IF INSTR("EIY",c$) > 0 THEN IsVoyelleFaible = %True
END FUNCTION

FUNCTION IsConsonne (BYVAL c$)
IsConsonne=%False
IF c$="" THEN EXIT FUNCTION
IF INSTR ("BCDFGHJKLMNPQRSTVWXZ",c$) > 0 THEN IsConsonne = %True
END FUNCTION

FUNCTION Belongs (BYVAL ref$,BYVAL c$)
Belongs=%False
IF c$="" THEN EXIT FUNCTION
IF INSTR (ref$,c$) > 0 THEN Belongs = %True
END FUNCTION

' remove getridof chars at p and replace them with insert$
FUNCTION Subst$ (BYVAL s$,BYVAL p,BYVAL insertion$, BYVAL getridof)
remain$=MID$(s$,p+getridof)
begin$=LEFT$(s$,p-1)
Subst$=begin$+insertion$+remain$
END FUNCTION

'--------------------------------------------------------------------
' alternate for soundex (loosely based on WordConjug documentation)
' assume already upper case
' distinction entre voyelles faibles et fortes

FUNCTION SoundexAlt$ (BYVAL s$) PUBLIC
prev$=""
new$=""
p=1
DO
    IF p > LEN(s$) THEN EXIT LOOP ' len (s$) CAN vary so force evaluation
	c1$=MID$(s$,p,1) ' char at position p
	c2$=MID$(s$,p+1,1) ' char at position p+1
    c3$=MID$(s$,p+2,1) ' char at position p+2
    c4$=MID$(s$,p+3,1)
    c12$=c1$+c2$
    c123$=c1$+c2$+c3$

    IF (c1$="H") AND (prev$="") THEN ' ignore leading H
        INCR p
    ELSEIF (c1$="H") AND (Belongs("BDGLNRTX",prev$)=%True) THEN
        INCR p
    ELSEIF (c12$="SH") AND (IsVoyelle(c3$)=%True) THEN
    	s$=Subst$(s$,p,"CH",2)
    ELSEIF (c1$="H") AND (prev$="C") AND (IsConsonne(c2$)=%True) THEN
		INCR p
    ELSEIF c12$ = "PH" THEN
        s$=Subst$(s$,p,"F",2)
    ELSEIF (Belongs("BDFGLMNRPTX",c1$)=%True) AND (c1$=prev$) THEN
        INCR p
    ELSEIF (c1$="C") AND (prev$="C") AND (IsVoyelleForte(c2$)=%True) THEN
        INCR p
    ELSEIF (c12$="CC") AND (IsVoyelleFaible(c3$)=%True) THEN
        s$=Subst$(s$,p,"X",2)
    ELSEIF (c1$="Z") AND (IsVoyelle(prev$)=%True) AND (IsVoyelle(c2$)=%True) THEN
        s$=Subst$(s$,p,"S",1)
    ELSEIF (c1$="C") AND (prev$="X") AND (IsVoyelleFaible(c2$)=%True) THEN
        INCR p
    ELSEIF (c12$="SS") AND (IsVoyelleFaible(c3$)=%True) THEN
        s$=Subst$(s$,p,"S",2)
    ELSEIF (c12$="SC") AND (IsVoyelleFaible(c3$)=%True) THEN
        s$=Subst$(s$,p,"S",2)
    ELSEIF (c1$="") AND (IsVoyelle(c2$)=%True) THEN '  !!!
        s$=Subst$(s$,p,"S",2)
    ELSEIF (c1$="U") AND (prev$="G") AND (IsVoyelleForte(c2$)=%True) THEN
        INCR p
    ELSEIF (c1$="G") AND (IsVoyelleFaible(c2$)=%True) THEN
        s$=Subst$(s$,p,"J",1)
    ELSEIF (c12$="GE") AND (IsVoyelleForte(c3$)=%True) THEN ' was G -> JE ???
        s$=Subst$(s$,p,"JE",2)
    ELSEIF (c12$="AU") THEN
        s$=Subst$(s$,p,"O",2)
    ELSEIF (c123$="EAU") THEN
        s$=Subst$(s$,p,"O",3)
    ELSEIF (c12$="EN") AND (IsConsonne(c3$)=%True) THEN
        s$=Subst$(s$,p,"AN",2)
    ELSEIF (c12$="EM") AND (IsConsonne(c3$)=%True) THEN
        s$=Subst$(s$,p,"AN",2)
    ELSEIF (c12$="AM") AND (IsConsonne(c3$)=%True) THEN
        s$=Subst$(s$,p,"AN",2)
    ELSEIF (c12$="IM") AND (IsConsonne(c3$)=%True) THEN
        s$=Subst$(s$,p,"IN",2)
    ELSEIF (c12$="YN") AND (IsConsonne(c3$)=%True) THEN
        s$=Subst$(s$,p,"IN",2)
    ELSEIF (c12$="YM") AND (IsConsonne(c3$)=%True) THEN
        s$=Subst$(s$,p,"IN",2)
    ELSEIF (c12$="UN") AND (IsConsonne(c3$)=%True) THEN
        s$=Subst$(s$,p,"IN",2)
    ELSEIF (c12$="UM") AND (IsConsonne(c3$)=%True) THEN
        s$=Subst$(s$,p,"IN",2)
    ELSEIF (c123$="AIN") AND (IsConsonne(c4$)=%True) THEN
        s$=Subst$(s$,p,"IN",3)
    ELSEIF (c123$="EIN") AND (IsConsonne(c4$)=%True) THEN
        s$=Subst$(s$,p,"IN",3)
    ELSEIF (c12$="OM") AND (IsConsonne(c3$)=%True) THEN
        s$=Subst$(s$,p,"ON",2)
    ELSEIF (c123$="ILL") AND (IsVoyelle(prev$)=%True) THEN
        s$=Subst$(s$,p,"Y",3)
    ELSEIF (c1$="Y") THEN
        s$=Subst$(s$,p,"I",1)
    ELSEIF (c123$="CQU") THEN
        s$=Subst$(s$,p,"QU",3)
    ELSE
        new$=new$+c1$
        prev$=c1$
        INCR p
    END IF
LOOP
SoundexAlt$ = new$
END FUNCTION

'--------------------------------------------------------------------
' surprising results sometimes so beware : MoNaCo=MaNChe for instance
' try SoundexAlt first and then compute Soundex ?

FUNCTION Soundex$ (BYVAL s$) PUBLIC
'         ABCDEFGHIJKLMNOPQRSTUVWXYZ
'        "01230120022455012623010202"
Table$ = "01730180082455012673010707"
SoundexStr$ = LEFT$(s$,1)
prevcode$ = ""
FOR i = 2 TO LEN (s$) ' from 2 because we keep first letter for code
    char$ = MID$(s$, i, 1)
    CodeASCII = ASC(char$) - (ASC("A")-1) ' - 64
    IF CodeASCII >= 1 AND CodeASCII <= 26 THEN ' A..Z : always anyway!
        currcode$ = MID$(Table$, CodeASCII, 1)
        ' ignore vowels and runs of identical codes
        IF (currcode$ <> "0") AND (currcode$ <> prevcode$) THEN
            SoundexStr$ = SoundexStr$ + currcode$
            prevcode$ = currcode$
        END IF
    END IF
NEXT
' Soundex$ = LEFT$(SoundexStr$ + "0000", 4) ' code is normally 4 chars
Soundex$=SoundexStr$ ' try and keep length of original string
END FUNCTION

'--------------------------------------------------------------------
' no range check at all on passed values!
' %InitWorking = 0 , number of blocks
' %ShowWorking = 1 , style
' %ProgressWorking = 2 , style
' %EndWorking = 3 , style
' %ClearWorking = 4

SUB Working(BYVAL cmd,BYVAL info) PUBLIC
STATIC vtab,htab,blocks,currblock,curranim
msg$="["
SELECT CASE cmd
CASE 0 ' ok
    blocks=info
    PRINT msg$;
    vtab=CSRLIN
    htab=POS(1)
    PRINT STRING$(blocks,"");"]";
    currblock=1
    curranim=1
CASE 1 ' ok
    SELECT CASE info
    CASE 0
        ref$="\/" ' 196 \ 179 /
    CASE ELSE
        ref$="" ' 176 177 178  219
    END SELECT
    c$=MID$(ref$,curranim,1)
    LOCATE vtab,htab+(currblock-1)
    PRINT c$;
    INCR curranim
    IF curranim > LEN(ref$) THEN curranim=1
CASE 2 ' ok
    SELECT CASE info
    CASE 0
        ok$=""
    CASE ELSE
        ok$=""
    END SELECT
    LOCATE vtab,htab+(currblock-1)
    PRINT ok$;
    INCR currblock
    IF currblock > blocks THEN currblock=1
    curranim=1
CASE 3 ' ok
    SELECT CASE info
    CASE 0
        ok$=""
    CASE ELSE
        ok$=""
    END SELECT
    FOR i = currblock TO blocks
        LOCATE vtab,htab+(i-1)
        PRINT ok$;
    NEXT
    LOCATE vtab,htab+blocks+1
CASE 4 ' ok (this is a full clearline, maybe later add a partial one?)
    LOCATE vtab,1
    PRINT STRING$(htab+blocks," ");
    LOCATE vtab,1
END SELECT
END SUB

' kludgy... but useful!
FUNCTION CheckScreen80 () PUBLIC
IF pbvScrnMode <> 0 THEN ' only screen mode 0 is OK, don't care about mode 7
    CheckScreen80=%False
    EXIT FUNCTION
END IF
ncols=pbvScrnCols
nrows=pbvScrnRows
IF pbvScrnCard AND &B00101100 <> 0 THEN ' give chance to vga/ega/ega (BIOS)
    DEF SEG=&H40
    ncols=PEEK(&H4A)+PEEK(&H4B)* %hi ' ega and better
    nrows=PEEK(&H84)+1
    DEF SEG
END IF
IF ncols <> 80 THEN
    CheckScreen80=%False
ELSE
    CheckScreen80=%True
END IF
END FUNCTION

'--------------------------------------------------------------------

SUB FlushKBD () PUBLIC
DO WHILE INKEY$ <> ""
LOOP	' flush keyboard
END SUB

SUB WaitAnyKeyPress () PUBLIC
CALL FlushKBD
DO WHILE INKEY$= ""
LOOP 	' wait for keypress
END SUB

FUNCTION GetKeyPress$ (BYVAL flagFlush) PUBLIC
IF flagFlush=%True THEN CALL FlushKBD
DO
	k$=INKEY$
LOOP WHILE k$="" 	' wait for keypress
GetKeyPress$=k$
END FUNCTION


SUB Bip () PUBLIC
SOUND 55,1
END SUB

SUB BipTiny () PUBLIC
SOUND 333,0.1
END SUB

SUB BipErr () PUBLIC
SOUND 55,5 ' plus long
END SUB

SUB Blip () PUBLIC
SOUND 222,1
SOUND 88,1
END SUB

SUB Blap () PUBLIC
SOUND 88,1
SOUND 222,1
END SUB

SUB Toggle (flag) PUBLIC
SELECT CASE flag
CASE %True
	flag=%False
CASE %False
	flag=%True
END SELECT
END SUB

'--------------------------------------------------------------------
' if filename$ does not exist, create it so that writeini is happy!
' create countBak backups keeping extension and adding 0..countbak-1
' pray for baknames do not already exist !!! (no check is made for now)
' seems to work

FUNCTION MakeBakNum (BYVAL filename$,BYVAL countBak, firstBakExt$) PUBLIC
IF (countBak < 1) OR (countBak > 10) THEN
   	MakeBakNum=%False
	EXIT FUNCTION
END IF
' nonsense to proceed if original does not exist
filename$=Upper$(filename$)
IF Exist(filename$) = %False THEN
   	MakeBakNum=%True ' not an error here
	EXIT FUNCTION
END IF
' now check for extension
CALL SplitName(filename$,n$,ext$)
IF LEN(ext$)=3 THEN ' check if xxD (where D is a digit)
	c$=RIGHT$(ext$,1)
	IF INSTR("0123456789",c$) > 0 THEN
    	MakeBakNum=%False
		EXIT FUNCTION
	END IF
	ext$=LEFT$(ext$,2) ' ok, now truncate
END IF
' now process each backup from last to first and then original
DECR countBak ' 1..10 -> 0..9
FOR i = countBak TO 0 STEP -1
	bakname$=n$+ "."+ext$+CHR$(ASC("0")+ i )
	IF Exist(bakname$) = %True THEN
		IF CanWrite(bakname$)=%False THEN
   			MakeBakNum=%False
   			EXIT FUNCTION
	    END IF
    	KILL bakname$ ' normally necessary only with last .BK9
	END IF
    IF i = 0 THEN
		nowname$=filename$
    ELSE
		nowname$=n$+ "."+ext$+chr$(ASC("0")+ i-1 )
    END IF
	IF Exist(nowname$) = %True THEN
		firstBakExt$=ext$+CHR$(ASC("0")+ i ) ' keep for later use by writeini (Q&D hack)	
		NAME nowname$ AS bakname$
    END IF
NEXT
MakeBakNum=%True
END FUNCTION

'--------------------------------------------------------------------
' needed by WriteIni

%waiting=0
%sectionfound=1
%actiontaken=2

' needed for Upper$ , MakeBak , MakeBakNum

' $INCLUDE "QDBOX.DEF"

'--------------------------------------------------------------------
' private for ReadIni, WriteIni

SUB CleanStr (s$)
REPLACE CHR$(9) WITH " " IN s$ ' remove TAB if any
s$=LTRIM$(RTRIM$(s$))
END SUB

' section$ already cleaned
SUB CheckSection(section$)
IF LEFT$ (section$,1) <> "[" THEN ' just in case
    section$="["+section$
END IF
IF RIGHT$(section$,1) <> "]" THEN
    section$=section$+"]"
END IF
END SUB

SUB SplitParamValue(BYVAL s$,param$,value$)
equpos=INSTR(s$,"=")
param$=MID$(s$,1,equpos-1)
value$=MID$(s$,equpos+1)
CALL CleanStr(param$)
CALL CleanStr(value$)
END SUB

' strings already cleaned and we ignore case!
FUNCTION Match(BYVAL s1$, BYVAL s2$)
s1$=Upper$(s1$)
s2$=Upper$(s2$)
IF s1$=s2$ THEN
    Match=%True
ELSE
    Match=%False
END IF
END FUNCTION

'--------------------------------------------------------------------
' assume f$ has already been checked for existence and uppercase
' rc = ReadIni (f$,"[data]","atlas",value$)
' value$ is "" by default whether rc is false or true
' if param$ exist and value$ is "", rc will be %False!!!

' maybe we should not change value$ unless it exists???
' respect inside spaces for both section and parameter
' i.e. [milieu du ciel]
'      milieu du ciel=12
' is OK!

FUNCTION ReadIni (BYVAL inifile$, BYVAL section$, BYVAL param$, value$) PUBLIC
CALL CleanStr(section$)
CALL CleanStr(param$)
CALL CheckSection(section$)
hndIn = FREEFILE
OPEN "I",#hndIn,inifile$
value$=""
sectionfound=%False
paramfound=%False
DO UNTIL EOF(hndIn)
    LINE INPUT #hndIn,s$
    CALL CleanStr(s$)
    first$=LEFT$(s$,1)
    SELECT CASE first$
    CASE "",";","#"
        ' ignore comment or empty
    CASE "["
        sectionfound= Match(s$,section$)
    CASE ELSE
        IF sectionfound = %True THEN
            CALL SplitParamValue (s$,p$,v$)
            IF Match(p$,param$) =%True THEN
                value$=v$ ' v$ already cleaned
                IF v$="" THEN
                    paramfound=%False ' empty value$ means NOT found!
                ELSE
                    paramfound=%True
                END IF
                EXIT LOOP
            END IF
        END IF
    END SELECT
LOOP
CLOSE #hndIn
ReadIni = paramfound
END FUNCTION

'--------------------------------------------------------------------
' if f$ does not exist, create it
' assume f$ has already been checked for existence, uppercase and not readonly
' rc = WriteIni ("c:\foo.ini","[ data ]","atlas","atlas.rsc")
' if value$ is "" then erase param$
' an alternative would be to perform makebak from main code,
' read ini, write tmp, del ini, ren tmp as ini

FUNCTION WriteIni (BYVAL inifile$, BYVAL section$, BYVAL param$, BYVAL value$) PUBLIC
'(* old code 
' IF MakeBak(inifile$,"BAK")=%False THEN
'     WriteIni = %False ' we had a problem here creating backup
'     EXIT FUNCTION
' END IF
' CALL SplitName(inifile$,n$,e$) ' should be preceded by splitpath ?
' filein$=n$+"."+"BAK"
'*)

inifile$=Upper$(inifile$)
IF Exist(inifile$) = %False THEN
    hnd=FREEFILE
    OPEN "O",#hnd,inifile$
    CLOSE #hnd
END IF
' now we can create backup !
IF MakeBakNum (inifile$,5,firstBakExt$)=%False THEN
    WriteIni=%False ' we had a problem here creating backup
    EXIT FUNCTION
END IF
CALL SplitPath (inifile$,unit$,directory$,filename$)
CALL SplitName (filename$,n$,e$)
filein$=unit$+directory$+n$+"."+firstBakExt$

fileout$=inifile$
CALL CleanStr(section$)
CALL CleanStr(param$)
CALL CleanStr(value$)
CALL CheckSection(section$)
hndIn = FREEFILE
OPEN "I",#hndIn,filein$
hndOut = FREEFILE
OPEN "O",#hndOut,fileout$
status=%waiting
DO UNTIL EOF(hndIn)
    flagOut=%True
    LINE INPUT #hndIn,s$
    CALL CleanStr(s$)
    first$=LEFT$(s$,1)
    SELECT CASE first$
    CASE "",";","#"
        ' ignore comment or empty
    CASE "["
        SELECT CASE status
        CASE %waiting
            IF Match(s$,section$)=%True THEN
                status=%sectionfound
            END IF
        CASE %sectionfound ' new section while section was found & not param
            IF value$<>"" THEN
                entry$=param$+"="+value$
                PRINT #hndOut,entry$ ' add new entry "param=value"
                status=%actiontaken
            END IF
        END SELECT
    CASE ELSE
        SELECT CASE status
        CASE %sectionfound
            CALL SplitParamValue (s$,p$,v$)
            IF Match(p$,param$) =%True THEN
                IF value$ <> "" THEN
                    s$=p$+"="+value$ ' replace old "param=value"
                ELSE
                    flagOut=%False ' erase old "param=value"
                END IF
                status=%actiontaken
            END IF
        END SELECT
    END SELECT
    IF flagOut=%True THEN
        PRINT #hndOut,s$
    END IF
LOOP
SELECT CASE status
CASE %waiting
    IF value$ <> "" THEN
        PRINT #hndOut,section$ ' add new section and entry
        entry$=param$+"="+value$
        PRINT #hndOut,entry$
    END IF
CASE %sectionfound
    IF value$ <> "" THEN
        entry$=param$+"="+value$
        PRINT #hndOut,entry$    ' add entry in section
    END IF
END SELECT
CLOSE #hndOut
CLOSE #hndIn
WriteIni = %True
END FUNCTION

'--------------------------------------------------------------------
'  vrifier (exemple : ne pas perturber d'autres applications
' ayant redfini la souris

%MouseInt = &h33

FUNCTION MouseHere () PUBLIC
LOCAL rc?? ' for access from asm code and yes, virginia, WORD value
! push	DS          ; save DS forPB
! mov	AX,&h0000	; function 00h
! int  	%MouseInt
! mov 	rc??,AX
! pop 	DS			; for PB
IF rc?? = &h0000 THEN
	MouseHere=%False
ELSE
	MouseHere=%True
END IF
END FUNCTION

FUNCTION MouseButtonClicked () PUBLIC
LOCAL rc?? ' for access from asm code and yes, virginia, WORD value
! push	DS          ; save DS forPB
! mov	AX,&h0003	; function 03h
! int  	%MouseInt
! and	BX,&b0000000000000111 ; just in case
! mov 	rc??,BX
! pop 	DS			; for PB
IF rc?? = &h0000 THEN
	MouseButtonClicked=%False
ELSE
	MouseButtonClicked=%True
END IF
END FUNCTION

