(* ---------------------------------------------------------------
Title         Q&D Path Copy
Overview      tsk tsk...
Usage         see help
Notes         I'm probably the only programmer in the world
              (well, at least among the very (un)happy few)
              still writing little utilities for Good Old DOS
              using Good Old (DR-Novell) DOS itself.. ;-)

              serious (or more exactly : weird) potential problem :
              while testing P4 *.exe copying from Win98,
              Maxtor 80Gb hard disk suddenly made weird clicks
              as if heads were blocked or recalibrating
              when program was run again, the problem occurred again !
              yet, when we splitted list, it did not reoccur... go figure !

              this never happened from good old Novell DOS 7
              nothing in code can explain. M$ against command line again ?
              possible random hd failure ?

              UPDATE ABOUT THAT POINT :
              darn, good/bad news : it seems related to hd problems after all
              and it's NOT the program. ouf !

              if told to process a shortform, target will be this very shortform
              and not possible associated lfn original

              Yet Another JPI gag :
              Lib.SplitAllPath eats extension in directory part if path is fixed with trailing "\" !
              ("\foo.bar\" becomes "foo" and ".bar" gets lost in space !)

              -mem -fake is UNWISE and therefore UNDOCUMENTED ;-)

              v1.1m has not yet been fully checked
              (obsolete : it has, now, as of v1.2n)

Bugs          what bugs ? ;-)
              darn... under 9x, deep paths may lead to silent unexpected rename failure

              seen once : program aborted leaving msgBusy visible

              not a bug but an unwise design decision :
              we assume target unit will always have room enough
              move operation thus become VERY dangerous

Wish List     better directory check...
              bargraph while copying long files ?
              error log .ERR ? bah, let redirection handle this...
              check source is not a directory ? bah, it should be done by caller !

              with LFNs, prepend dirpath to name ?

              see //FIXME for cosmetic quirk

              an ini to avoid any dangerous MOVE or even COPY (swap etc.)
              (source = c:\ , c:\windows , c:\dos , target = c:\ etc.)
              done for source, but what about target ?
              let's protect user against his will, the m$ way ! ;-) bill's code kiddies know best !

              interactive mode could ask about erasing source when moving
              logically, -n should ignore -i but it's safer for user

              strPrompt could use a "rename target" method

              errFileNotFound could make a difference between "no match" and "protected" errors ?

              we could abort at first freespace room problem,
              but it's probably better to go on for possible smaller files

--------------------------------------------------------------- *)

MODULE pCopy;

IMPORT Str;
IMPORT Lib;
IMPORT FIO;
IMPORT SYSTEM;
IMPORT DOSErr;

FROM IO IMPORT WrStr, WrLn,  WrCard,WrBool;

FROM Storage IMPORT ALLOCATE,DEALLOCATE,Available;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose;

(* ------------------------------------------------------------ *)

CONST
    USEFLOATSTAMP = FALSE; (* false = compare filestamps using longcards instead of longreals *)

CONST
    tmpTARGET     = "$DEL_ME$.TMP"; (* 8+3 reserved tmpname used by doFileCopy() when processing LFNs *)
    (* lowercasealt *)
    fSwapWin92    = "386spart.par";
    fSwapWin98    = "win386.swp";
    fSwapWinXP    = "pagefile.sys";
    patSwapWin92  = "*\"+fSwapWin92;
    patSwapWin98  = "*\"+fSwapWin98;
    patSwapWinXP  = "*\"+fSwapWinXP;
CONST
    cr          = CHR(13);
    lf          = CHR(10);
    nl          = cr+lf;
    colon       = ":";
    dquote      = '"';
    dot         = ".";
    backslash   = "\";
    slash       = "/";
    semicolon   = ";";
    pound       = "#";
    charnull    = CHR(0); (* i.e. 0C *)
    nullchar    = charnull;
    dash        = "-";
    blank       = " ";
    coma        = ",";
    equal       = "=";
    dotdot      = dot+dot;
    extLST      = ".LST";
    extEXE      = ".EXE";
    extINI      = ".INI";
CONST
    sOKDONE         = "==> "; (* success copied to *)
    sPREFIX         = "    "; (* was "" *)
    sPREVIEW        = ";-) ";
    sOK             = "+++ ";
    sPB             = "--- ";
    sINFO           = "::: ";
    pathplaceholder = "~~~"; (* avoid nasty 9x tildes now : anyway file should always be last with such a placeholder *)
    dosrenmask      = "(#";
    lfnrenmask      = "(#)";
    lfnrenmasklong  = "(####)";
    renfixdefault   = 0;
    renfixLFN       = 4;
CONST
    pbNone        = 0; msgOK            = sOK;
    pbJoker       = 1; msgJoker         = sPB+"Jokers are not allowed in source";
    pbNotFound    = 2; msgNotFound      = sPB+"Source does not exist";
    pbTargetExists= 3; msgTargetExists  = sPB+"Target already exists";
    pbTargetRO    = 4; msgTargetRO      = sPB+"Read-only target already exists";
    pbTargetNewer = 5; msgTargetNewer   = sPB+"Source is older or same date than target"; (* was "not newer" *)
    pbRenameFailure=6; msgRenameFailure = sPB+"New target name could not be created";
    pbRoomCopy    = 7; msgRoomCopy      = sPB+"Not enough room for target";
    pbRoomMove    = 8; msgRoomMove      = sPB+"Not enough room for target (source was not deleted)";
    pbSourceRO    = 9; msgSourceRO      = sPB+"Source is read-only";
    pbCollision   =10; msgCollision     = sPB+"Source would overwrite itself";
    pbRenamed     =11; msgRenamed       = sINFO+'Target renamed to "'+pathplaceholder+'"';

    (*
    pbMovedRO     =12; msgMovedRO       = sINFO+'Read-only source moved to "'+pathplaceholder+'"';
    pbMoved       =13; msgMoved         = sINFO+'Source moved to "'+pathplaceholder+'"';
    *)
    pbMovedRO     =12; msgMovedRO       = sOKDONE+'Read-only source moved to "'+pathplaceholder+'"';
    pbMoved       =13; msgMoved         = sOKDONE+'Source moved to "'+pathplaceholder+'"';

    pbFreshen     =14; msgFreshen       = sINFO+'No existing target to freshen';
    pbUnexpected  =15; msgUnexpected    = "??? Unexpected problem !";
    pbTargetNewerOrSame = 16; msgTargetNewerOrSame = sPB+"Source is older than target";
CONST
    sProtectedDir  = sINFO+"PROTECTED "; (* uppercase for dirs *)
    sProtectedFile = sINFO+"Protected ";
    msgBusy        = "Working, please wait... "; (* trailing space for possible msgCopying *)
    msgDone        = sINFO+"~ file(s) processed successfully, ~ warning(s).";
CONST
    minProtected    = 1;
    maxProtected    = 50; (* at least 3 ! *)
    strMaxProtected = "50";
CONST
    progEXEname   = "PCOPY";
    progTitle     = "Q&D Path Copy";
    progVersion   = "v1.2q";
    progCopyright = "by PhG";
    banner        = progTitle+" "+progVersion+" "+progCopyright;
    sPCOPYenv     = progEXEname;
    (* errLogfile    = progEXEname+".ERR"; *)
CONST
    errNone            = 0;
    errHelp            = 1;
    errUnknownOption   = 2;
    errTooManyParms    = 3;
    errNonsense        = 4;
    errNonsenseStamp   = 5;
    errUserAbort       = 6;
    errMissingSource   = 7;
    errJokerTarget     = 8;
    errBase            = 9;
    errNotFile         = 10;
    errNotFound        = 11;
    errNonsenseShow    = 12;
    errNetSlash        = 13;
    errPhantomUnit     = 14;
    errDirCollision    = 15;
    errBadUnit         = 16;
    errColon           = 17;
    errNoParent        = 18;
    errInnerParent     = 19;
    errDirJoker        = 20;
    errStorage         = 21;
    errFileNotFound    = 22;
    errNotWithList     = 23;
    errBadEnv          = 24;
    errProtection      = 25;
    errMoreHelp        = 26;
    errDateRange       = 27;
    errSizeRange       = 28;
    errFilteredFileNotFound=29;
    errJokerList       = 30;
    errTargetIsFile    = 31;
    errRequiredOption  = 32;
    errRenFixLFN       = 33;
    errEvenMoreHelp    = 34;
    errNoneAlt         = 128;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE sound (freq,duration,pause:CARDINAL);
BEGIN
    Lib.Sound(freq);
    Lib.Delay(duration);
    Lib.NoSound();
    Lib.Delay(pause);
END sound;

PROCEDURE errbip (okbeep:BOOLEAN);
CONST
    freq     = 55;
    duration = 55; (* was 300 *)
    tempo    = 100;
BEGIN
    IF okbeep THEN sound (freq,duration,tempo); END;
END errbip;

PROCEDURE alert (  );
BEGIN
    sound(111,22,100);
    sound(111,22,10);
END alert;

PROCEDURE enclose (VAR S : ARRAY OF CHAR);
BEGIN
    Str.Prepend(S,dquote);
    Str.Append(S,dquote);
END enclose;

PROCEDURE preprocessLine (VAR S:pathtype);
VAR
    len:CARDINAL;
BEGIN
    LtrimBlanks(S);
    RtrimBlanks(S);
    (* we could use Str.Match(S,dquote+"*"+dquote) but... *)
    len:=Str.Length(S);
    IF len < 2 THEN RETURN; END; (* at least 1+1 for possible dquote+dquote *)
    IF S[len-1] # dquote THEN RETURN; END;
    IF S[0] # dquote THEN RETURN; END;
    S[len-1]:=charnull;
    Str.Delete(S,0,1);
    (* just in case *)
    LtrimBlanks(S);
    RtrimBlanks(S);
END preprocessLine;

CONST
    widmp = 27; (* Win<92|98|XP> forced us to use 30 *)

PROCEDURE padinf (n:INTEGER;S:ARRAY OF CHAR):str80;
VAR
    i:CARDINAL;
    R:str80;
BEGIN
    R:="";
    IF n > 0 THEN Str.Append(R,S);END;
    FOR i:=Str.Length(S)+1 TO ABS(n) DO Str.Append(R," ");END;
    IF n < 0 THEN Str.Append(R,S);END;
    Str.Append(R," : ");
    RETURN R;
END padinf;

PROCEDURE wF (S1,S2:ARRAY OF CHAR;useLFN:BOOLEAN);
BEGIN
    WrStr( padinf(widmp,S1));
    IF useLFN THEN enclose(S2);END;
    WrStr(S2);WrLn;
END wF;

PROCEDURE wB (S1:ARRAY OF CHAR;b:BOOLEAN; t,f:ARRAY OF CHAR);
BEGIN
    WrStr( padinf(widmp,S1));
    IF b THEN
        WrStr(t);
    ELSE
        WrStr(f);
    END;
    WrLn;
END wB;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    placeholder = "~";
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)

helpmsg =
banner+nl+
nl+
"Syntax 1 : "+progEXEname+" <spec> [targetdir] [option]..."+nl+
"Syntax 2 : "+progEXEname+" <-@> <@list["+extLST+"]> [targetdir] [option]..."+nl+
nl+
"-@        force list mode (thus assuming first parameter is a list)"+nl+
"-s[p|s]   recurse subdirectories (-ss = -sp = -s -p)"+nl+
"-t        test mode"+nl+
"-y|-t-    disable preview/test mode"+nl+
"-o[o][n]  overwrite existing target if any (-oo = overwrite read-only)"+nl+
"-f[n]     freshen existing target only (-fn = -f -n)"+nl+
'-n[o[o]]  do not overwrite target if source is "older or same date" (-o forced)'+nl+ (* was "not newer" *)
'-j        force -n to check for "older only" instead of "older or same date"'+nl+
'-r[r]     try and automagically rename existing target if any (see infra)'+nl+
"-p[r|p]   do not recreate paths on target (-pp = -pr = -p -r)"+nl+
"-m[m]     move mode, erasing source at copy completion (-mm = erase read-only)"+nl+
"-mo[o][n] shortcut combining -m, -o[o] and -n (-mo, -moon, -mon, -moo)"+nl+
"-i[o|i]   ask user to confirm target overwriting (-ii = -io = -i -o)"+nl+
"-k        keep source RHS flags (default is to clear them)"+nl+
'-d:$      filter according to specified "lower[:|..]upper" date range'+nl+
'          ("*"=today, "$"=same date, ":$"=before or on, "$:"=on or after)'+nl+
'-z:$      filter according to specified "lower[-|:|..]upper" size range'+nl+
'          ("#"=same size, ":#"=size less or equal, "#:"=size equal or more)'+nl+
"-g        do not show copy percentage"+nl+
"-q        alternate display (do not report successful operations)"+nl+
"-u        alternate display (report successful operations only)"+nl+
"-w        list source entries found protected and therefore skipped"+nl+
"-x        ignore existing "+progEXEname+extINI+nl+
"-swaps    do not default to swapfiles protection"+nl+
'          ("'+patSwapWin92+'", "'+patSwapWin98+'" and "'+patSwapWinXP+'")'+nl+
"-v[v]     show parameters (-vv = show parameters and terminate)"+nl+
"-!        filter files using operating system jokers (see infra)"+nl+
"-e        disable ESCape polling (may be necessary with Win9X/WinXP)"+nl+
"-l        disable LFN support even if available"+nl+
"-b        do not beep at unexpected choice"+nl+
"-a        audio beep"+nl+
"-copy     shortcut for -i -o -p"+nl+
"-move|mv  shortcut for -i -o -m"+nl+
"-cp       shortcut for -n -p"+nl+
"-xcp      shortcut for -n -s"+nl+
"-mem      ignore any Storage.ALLOCATE() error (unwise !)"+nl+
"-??[?]    (even) more help (to be read at least once !)"+nl;

    msgmorehelp = nl+
"a) With syntax 1, this program is SIMILAR to COPY/MOVE/XCOPY/REPLACE."+nl+
"   However, note that renaming source(s) using joker(s) is NOT supported :"+nl+
"   target destination MUST be a DIRECTORY (automatically created if necessary)."+nl+
"   Moreover, empty source subdirectories are NOT recreated."+nl+
"b) With syntax 2, this program copies each canonical file found in <list>"+nl+
"   (jokers and directories not allowed) preserving path information"+nl+
"   (unless -p was specified) but obviously ignoring unit."+nl+
"c) -p option (required for COPY-like mode) does NOT force -r automatically."+nl+
'd) By design, -j option still requires -n option.'+nl+
'e) Without -! option, "?" and "*" jokers do NOT work the DOS or Win9X way :'+nl+
'   "?" matches exactly one character, "*" matches any sequence of characters.'+nl+
"f) Up to "+strMaxProtected+" entries (M2 jokers supported) may be protected against access,"+nl+
"   if they are specified in "+progEXEname+extINI+" file located in executable directory."+nl+
"   If such a file does not exist, these entries are protected by default :"+nl+
'   "'+patSwapWin92+'", "'+patSwapWin98+'" and "'+patSwapWinXP+'".'+nl+
"   Note protection applies to sources ONLY : targets are NOT protected."+nl+
"g) Default display enables both -q and -u options ; redirection ignores them."+nl+
'h) -t option can be set as default with '+sPCOPYenv+'=T environment variable ;'+nl+
"   default mode can still be reset from command line with -y or -t- options."+nl+
    (* '?) Error checking is limited : -test rulez ! "Caveat utilisator" ! ;-)'+nl+ *)
'i) "'+tmpTARGET+'" filename is reserved when processing LFNs.'+nl+
'j) -r option tries and appends "'+dosrenmask+'" (DOS) or "'+lfnrenmask+'" (LFN),'+nl+
'   where "#" is in the [1..9999] range. Original DOS f8 may be truncated.'+nl+
'   Note -rr option is LFN-specific and appends "'+lfnrenmasklong+'" when renaming.'+nl+
"k) -mem option may help with huge Win9X and WinXP directories,"+nl+
"   although all matching files will not be processed."+nl+
"l) "+placeholder+nl+
"   "+placeholder+nl+
nl+
"Examples : "+progEXEname+" /oon /u @backup.lst f:\backup"+nl+
"           "+progEXEname+" c:\tools\*.exe c:\z /s /k /v /q /x"+nl+
"           "+progEXEname+" c:\txt\*.w51 g:\z\ /o /n /j"+nl;

    msgevenmorehelp = nl+
"Here is an example of "+progEXEname+extINI+" file :"+nl+
nl+
"   ;"+nl+
"   ; Entries matching these patterns will be ignored by Copy and Move."+nl+
"   ; Note protection applies to sources ONLY : targets are NOT protected."+nl+
"   ; M2 jokers are allowed :"+nl+
'   ; "?" matches exactly one character, "*" matches any sequence of characters.'+nl+
"   ; Entries may be enclosed with double quotes if necessary."+nl+
"   ;"+nl+
"   ; Swap files should always be protected in this INI file :"+nl+
"   ; the One and Golden Rule of Indifference should always rule."+nl+
"   ;"+nl+
"   "+patSwapWin92+nl+
"   "+patSwapWin98+nl+
"   "+patSwapWinXP+nl+
"   ;"+nl+
"   ?:\"+nl+
"   c:\dos\*"+nl+
'   "c:\windows\*"'+nl+
'   "*\index.dat"'+nl+
"   *\desktop.ini"+nl;

VAR
    S  : str1024; (* was str256 *)
    SS : str4096; (* should do *)
BEGIN
    CASE e OF
    | errHelp,errMoreHelp,errEvenMoreHelp :
        WrStr(helpmsg);
        IF e # errHelp THEN
            Str.Copy(SS,msgmorehelp);

            (* now tell user about PCOPY.INI *)

            Lib.ParamStr(S,0); (* retrieve executable location : yes, we assume it ! *)
            Str.Caps(S); (* safety *)
            Str.Subst(S,extEXE,extINI);

            IF FIO.Exists(S) THEN
                S:=progEXEname+extINI+" was found in executable directory :";
                Str.Subst(SS,placeholder,S);
                S:="protection against access is available for its entries (unless -x).";
            ELSE
                S:=progEXEname+extINI+" was NOT found in executable directory :";
                Str.Subst(SS,placeholder,S);
                S:="protection against access is limited to swapfiles (unless -swaps).";
            END;
            Str.Subst(SS,placeholder,S);
            IF e = errEvenMoreHelp THEN Str.Append(SS,msgevenmorehelp);END;
            WrStr(SS);
        END;
        e:=errHelp;
    | errUnknownOption:
        S:="Unknown | option !";
    | errTooManyParms:
        S:="| is one parameter too many !";
    | errNonsense:
        S:="| and -r options are mutually exclusive !";
    | errNonsenseStamp:
        S:="-n option is a nonsense without -o[o] option !";
    | errUserAbort:
        S := "Aborted by user !";
    | errMissingSource :
        S := "<spec> or <@list> expected !";
    | errJokerTarget:
        S:='"|" target cannot contain any joker !';
    | errBase:
        S:='Illegal "|" base directory !';
    | errNotFile:
        S:='"|" is not a file !';
    | errNotFound:
        S:='"|" list does not exist !';
    | errNonsenseShow:
        S:="-q and -u options are mutually exclusive !";
    | errNetSlash:
        S:='Illegal server "\\" in "|" specification !';
    | errPhantomUnit:
        S:='Unavailable or read-only unit in "|" specification !';
    | errDirCollision:
        S:= "Source files would overwrite themselves !";
    | errBadUnit:
        S:='Illegal unit in "|" specification !';
    | errColon:
        S:='Unexpected ":" in "|" specification !';
    | errNoParent:
        S:='Unresolvable ".." in "|" specification !';
    | errInnerParent:
        S:='Illegal ".." in "|" specification !';
    | errDirJoker:
        S:='Illegal "|" directory joker(s) !';
    | errStorage:
        S:='Storage.ALLOCATE() failure while processing "|" specification !';
    | errFileNotFound:
        S:='No match (or protection set) for "|" !';
    | errNotWithList:
        S:="| and -@ options are mutually exclusive !";
    | errBadEnv:
        S:='Illegal value in "|" environment variable !';
    | errProtection:
        S:=progEXEname+extINI+" should be checked for problems !";
    | errSizeRange  :
        S:="Illegal | size range !";
    | errDateRange  :
        S:="Illegal | date range !";
    | errFilteredFileNotFound:
        S:='No filtered match for "|" !';
    | errJokerList:
        S:='"|" list cannot contain any joker !';
    | errTargetIsFile:
        S:='Specified "|" target is an existing file !';
    | errRequiredOption:
        S:="-j option requires | option !";
    | errRenFixLFN:
        S:="-rr option requires LFN support to be enabled !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp,errNoneAlt :
        ;
    ELSE
        Str.Subst(S,"|",einfo);
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

PROCEDURE dbg (S1,S2:ARRAY OF CHAR);
VAR
    i:CARDINAL;
BEGIN
    WrStr("// ");
    WrStr(S1);
    FOR i:=Str.Length(S1) TO 20 DO WrStr(" ");END;
    WrStr(" : ");
    WrStr(S2);
    WrLn;
END dbg;

PROCEDURE dbgbool (S1:ARRAY OF CHAR ; ok:BOOLEAN );
BEGIN
    IF ok THEN
        dbg(S1,"success");
    ELSE
        dbg(S1,"failure");
    END;
END dbgbool;

PROCEDURE dbgcard (S1:ARRAY OF CHAR; v:CARDINAL  );
VAR
    i:CARDINAL;
BEGIN
    WrStr("// ");
    WrStr(S1);
    FOR i:=Str.Length(S1) TO 20 DO WrStr(" ");END;
    WrStr(" : ");
    WrCard(v,1);
    WrLn;
END dbgcard;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ioBufferSize      = (8 * 512) + FIO.BufferOverhead;
    firstioBufferByte = 1;
    lastioBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstioBufferByte..lastioBufferByte] OF BYTE;
VAR
    ioBufferIn,ioBufferOut : ioBufferType;

CONST
    firstDataByte = 0;
    lastDataByte  = 32*512-1;
    dataBufferSize= lastDataByte - firstDataByte + 1;
TYPE
    dataBufferType = ARRAY [firstDataByte..lastDataByte] OF BYTE;
VAR
    dataBuffer : dataBufferType;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE fmtlc (v:LONGCARD;base:CARDINAL;wi:INTEGER;ch,prefix:CHAR) : str80;
VAR
    R : str80;
    ok: BOOLEAN;
    i : CARDINAL;
BEGIN
    Str.CardToStr(v,R,base,ok);
    FOR i:= Str.Length(R)+1 TO ABS(wi) DO
        IF wi < 0 THEN
            Str.Append(R,ch);
        ELSE
            Str.Prepend(R,ch);
        END;
    END;
    IF base=16 THEN Str.Lows(R);END;
    Str.Prepend(R,prefix);
    RETURN R;
END fmtlc;

PROCEDURE fmt (v:CARDINAL;base:CARDINAL;wi:INTEGER;ch,prefix:CHAR) : str80;
BEGIN
    RETURN fmtlc(LONGCARD(v),base,wi,ch,prefix);
END fmt;

PROCEDURE nice (useLFN:BOOLEAN;S:pathtype):pathtype;
VAR
    R:pathtype;
BEGIN
    IF useLFN THEN
        Str.Concat(R,dquote,S);
        Str.Append(R,dquote);
    ELSE
        Str.Copy(R,S);
    END;
    RETURN R;
END nice;

PROCEDURE wrfi (useLFN: BOOLEAN;S1:ARRAY OF CHAR;S2:pathtype);
BEGIN
    WrStr(S1); WrStr( nice (useLFN, S2)); WrLn;
END wrfi;

PROCEDURE busy (showbusy,state:BOOLEAN);
BEGIN
    IF showbusy THEN
        video(msgBusy,state);
    END;
END busy;

(* ------------------------------------------------------------ *)

(* clever is not always faster : dynamic string allocation is much slower here -- and yes, we've tried it *)

VAR
    entryprotected      : ARRAY [minProtected..maxProtected] OF pathtype;
    lastEntryProtected  : CARDINAL; (* globerk *)

PROCEDURE chkNoProtection (notice,showbusy,isdir:BOOLEAN;S:pathtype):BOOLEAN; (* ok=store it *)
VAR
    last,i:CARDINAL;
    rc,ok:BOOLEAN;
    msg:str16;
BEGIN
    last:=lastEntryProtected;
    IF isdir THEN
        msg:=sProtectedDir;
    ELSE
        msg:=sProtectedFile;
    END;
    rc:=TRUE;
    IF last < minProtected THEN RETURN rc; END;
    LowerCaseAlt(S);
    i:=minProtected-1;
    LOOP
        INC(i);
        IF i > last THEN EXIT; END;
        ok:=Str.Match(S,entryprotected[i]);
        IF ok THEN
            IF notice THEN
                busy(showbusy,FALSE);
                WrStr(msg); WrStr(S); WrLn;
                busy(showbusy,TRUE);
            END;
            rc:=FALSE;
            EXIT;
        END;
    END;
    RETURN rc;
END chkNoProtection;

(*
             ignoreini    forceswapfilesprotection
default      FALSE        TRUE
-swap        ?            FALSE
-x           TRUE         ?

if ini exists, its content override default protection unless -x was specified
if no ini, swapfiles protected unless -swaps
*)

PROCEDURE swapfilesprotectionFIX (forceswapfilesprotection,inihere,ignoreini:BOOLEAN):BOOLEAN;
BEGIN
    IF inihere THEN
        IF NOT(ignoreini) THEN
            forceswapfilesprotection:=FALSE; (* override possible default : user is responsible for ini entries *)
        END;
    END;
    RETURN forceswapfilesprotection;
END swapfilesprotectionFIX;

PROCEDURE initProtected (VAR lastentry:CARDINAL;
                        ignoreini,forceswapfilesprotection,useLFN,DEBUG:BOOLEAN):BOOLEAN;
VAR
    ini,udne : pathtype;
    hin:FIO.File;
    i,pb:CARDINAL;
    S:str1024;
    inihere:BOOLEAN;
BEGIN
    Lib.ParamStr(ini,0);
    UpperCase(ini); (* useless *)
    Str.Subst(ini,extEXE,extINI);
    inihere:=fileExists(useLFN,ini);

    forceswapfilesprotection:=swapfilesprotectionFIX(forceswapfilesprotection, inihere,ignoreini);

    lastentry := minProtected-1;

    IF forceswapfilesprotection THEN
        FOR i:= 1 TO 3 DO
            CASE i OF
            | 1: S:=patSwapWin92;
            | 2: S:=patSwapWin98;
            | 3: S:=patSwapWinXP;
            END;
            INC(lastentry);
            Str.Copy(entryprotected[lastentry],S);
        END;
    END;

    IF ignoreini THEN RETURN TRUE; END;
    IF NOT(inihere) THEN RETURN TRUE; END;

    hin:=fileOpenRead(useLFN,ini);
    FIO.AssignBuffer(hin,ioBufferIn);

    pb:=0;

    LOOP
        IF FIO.EOF THEN EXIT; END;
        FIO.RdStr(hin,udne);
        IF FIO.EOF THEN EXIT; END;

        preprocessLine (udne);

        CASE udne[0] OF
        | CHR(0), semicolon,pound :
            ;
        ELSE
            (* IF chkJoker(udne) THEN INC(pb); EXIT; END; *)

            LowerCaseAlt(udne); (* keep accents *)

            S:="Protected ~ ~ : ~";
            INC(lastentry);
            IF lastentry > maxProtected THEN INC(pb);EXIT;END;
            entryprotected[lastentry]:=udne;
            IF DEBUG THEN
                Str.Subst(S,"~","entry");
                i:=lastentry;
            END;
            IF DEBUG THEN
                Str.Subst(S,"~",fmt(i,10,2," ",""));
                Str.Subst(S,"~",nice(useLFN,udne));
                WrStr(S);WrLn;
            END;
        END;
    END;
    FIO.Close(hin);
    RETURN (pb=0);
END initProtected;

PROCEDURE dmpProtected (useLFN,cr:BOOLEAN;lastentry:CARDINAL );
VAR
    last,i:CARDINAL;
    R:str16;
    S:pathtype;
BEGIN
    IF lastentry < minProtected THEN RETURN; END;
    IF cr THEN WrLn;END;
        last:=lastentry;  R:="entry ";
        i:=minProtected;
        LOOP
            IF i > last THEN EXIT; END;
            S:=entryprotected[i];
            WrStr("Protected ");WrStr(R);
            WrStr(fmt(i,10,2," ","") );WrStr(" ");
            WrStr( nice(useLFN,S));WrLn;
            INC(i);
        END;
END dmpProtected;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    attrstatetype = (dontcare,required,unwanted);
    masktype = RECORD (* D R H S A *)
        stateD,stateR,stateH,stateS,stateA : attrstatetype;
    END;
CONST
    firstattr      = 1;
    lastattr       = 5;
    allowedAttr    = "DRHSA"; (* 1..5 *)
CONST
    fakeoption     = "QD=";
    showfilesonly  = fakeoption+"D-";

(* see GetLongCard() in QD_Box *)

PROCEDURE removeOption (VAR R:ARRAY OF CHAR);
VAR
    p:CARDINAL;
BEGIN
    Str.Subst(R,equal,colon); (* command line option xxx= becomes xxx: *)
    p := Str.CharPos(R,colon);
    IF p # MAX(CARDINAL) THEN Str.Delete(R,0,p+1); END;
END removeOption;

PROCEDURE parseMask (S:ARRAY OF CHAR; VAR m:masktype):BOOLEAN;
VAR
    included,excluded,indifferent:str16;
    i,len:CARDINAL;
    ch,keepch:CHAR;
    state:(wait,grab);
    rc:BOOLEAN;
    attrstate:attrstatetype;
BEGIN
    removeOption(S);

    (* accept ?+, ?-, ?x, ? (assuming ?+) : exemple A+R-H+ *)

    len:=Str.Length(S);
    FOR i:= 1 TO len DO
        ch:=S[i-1];
        IF Belongs(allowedAttr,ch) THEN
            IF CharCount(S,ch) > 1 THEN RETURN FALSE; END; (* avoid repeated or contradictory *)
        END;
    END;
    included := "";
    excluded := "";
    indifferent:="";
    i:=1;
    rc:=FALSE;
    state:=wait;
    LOOP
        IF i > len THEN rc:=TRUE; EXIT; END;
        ch:=S[i-1];
        CASE state OF
        | wait:
            CASE ch OF
            | "D","R","H","S","A" : keepch:=ch;
                IF (i+1) > len THEN Str.Append(included,keepch);END;
            ELSE
                EXIT;
            END;
            state:=grab;
        | grab:
            CASE ch OF
            | "+"         : Str.Append(included,keepch);
            | "-"         : Str.Append(excluded,keepch);
            | "?","!","X" : Str.Append(indifferent,keepch);
            | "D","R","H","S","A": Str.Append(included,keepch); (* fake "+" for previous flag *)
                DEC(i); (* but cancel next advance *)
            ELSE
                EXIT;
            END;
            state:=wait;
        END;
        INC(i);
    END;
    (* included and excluded don't share any attribute *)
    FOR i:=firstattr TO lastattr DO
        ch:=allowedAttr[i-1];
        IF Belongs(included,ch) THEN
            attrstate:=required;
        ELSIF Belongs(excluded,ch) THEN
            attrstate:=unwanted;
        ELSIF Belongs(indifferent,ch) THEN
            attrstate:=dontcare;
        ELSE
            attrstate:=dontcare;
        END;
        CASE ch OF
        | "D" : m.stateD := attrstate;
        | "R" : m.stateR := attrstate;
        | "H" : m.stateH := attrstate;
        | "S" : m.stateS := attrstate;
        | "A" : m.stateA := attrstate;
        END;
    END;
    RETURN rc;
END parseMask;

(*
    attrstatetype = (dontcare,required,unwanted);
    masktype = RECORD (* D R H S A *)
        stateD,stateR,stateH,stateS,stateA : attrstatetype;
    END;
*)

PROCEDURE matchMask (attr:FIO.FileAttr ; m:masktype):BOOLEAN ;
VAR
    i,pb:CARDINAL;
    here:BOOLEAN;
    status:attrstatetype;
BEGIN
    pb:=0;
    FOR i:=firstattr TO lastattr DO
        CASE i OF
        | 1 : here:=( aD IN attr ); status := m.stateD;
        | 2 : here:=( aR IN attr ); status := m.stateR;
        | 3 : here:=( aH IN attr ); status := m.stateH;
        | 4 : here:=( aS IN attr ); status := m.stateS;
        | 5 : here:=( aA IN attr ); status := m.stateA;
        END;
        CASE status OF
        | dontcare: ;
        | required: IF NOT(here) THEN INC(pb); END;
        | unwanted: IF here      THEN INC(pb); END;
        END;
    END;
    RETURN (pb=0);
END matchMask;

(*
Year stored relative to 1980 (ex. 1988 stores as 8)
    year      month    day   

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

CONST
    yyMask=BITSET{9..15};
    yyShft=9;
    mmMask=BITSET{5..8};
    mmShft=5;
    ddMask=BITSET{0..4};
    ddShft=0;
    mindd=1;
    maxdd=31;
    minmm=1;
    maxmm=12;
    minyy=1980; (* base year for messdos *)
    maxyy=minyy+127; (* was 2099 *)
    baseyear=minyy;  (* 1980 *)

PROCEDURE PackDMY (d,m,y : CARDINAL  ) : CARDINAL;
BEGIN
    IF y < baseyear THEN
        y:=baseyear;
    END;
    DEC(y,baseyear);
    IF y > 127 THEN y:=127; END; (* %1111111 i.e. $7f max *)
    y := y << yyShft;
    m := m << mmShft;
    RETURN (y + m + d);
END PackDMY;

PROCEDURE UnpackDMY (dmy:CARDINAL;VAR d,m,y:CARDINAL);
BEGIN
    y := CARDINAL(BITSET(dmy) * yyMask) >> yyShft;
    m := CARDINAL(BITSET(dmy) * mmMask) >> mmShft;
    d := CARDINAL(BITSET(dmy) * ddMask) >> ddShft;
    INC(y,baseyear);
END UnpackDMY;

PROCEDURE parseDate (S : ARRAY OF CHAR;
                     VAR dmy : CARDINAL) : BOOLEAN;
CONST
    century = 1900;
CONST
    digits   = "0123456789";
    alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
CONST
    separator=dash;
    legaldateset = digits+separator+alphabet;
VAR
    i,day,month,year : CARDINAL;
    R : str80;
    v : LONGCARD;
    ok: BOOLEAN;
BEGIN
    UpperCase(S); (* in case months would be letters *)
    ReplaceChar(S,slash,separator);
    FOR i := 0 TO (Str.Length(S)-1) DO
        IF Str.CharPos(legaldateset,S[i])=MAX(CARDINAL) THEN RETURN FALSE; END;
    END;
    IF CharCount(S,separator) # 2 THEN RETURN FALSE; END;

    Str.ItemS(R,S,separator,0);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF (v < mindd) OR (v > maxdd) THEN RETURN FALSE; END;
    day := CARDINAL(v);

    Str.ItemS(R,S,separator,1);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN
        Str.Prepend(R,dash); (* fake command line parameter ! *)
        i := GetOptIndex(R,"JAN"+delim+"JAN"+delim+
                           "FEB"+delim+"FEV"+delim+
                           "MAR"+delim+"MAR"+delim+
                           "APR"+delim+"AVR"+delim+
                           "MAY"+delim+"MAI"+delim+
                           "JUN"+delim+"JUN"+delim+
                           "JUL"+delim+"JUI"+delim+
                           "AUG"+delim+"AOU"+delim+
                           "SEP"+delim+"SEP"+delim+
                           "OCT"+delim+"OCT"+delim+
                           "NOV"+delim+"NOV"+delim+
                           "DEC"+delim+"DEC");
        CASE i OF
        | 1..24 :
            v := LONGCARD(i+1) DIV 2;
        ELSE
            RETURN FALSE;
        END;
    END;
    IF (v < minmm) OR (v > maxmm) THEN RETURN FALSE; END;
    month := CARDINAL(v);

    Str.ItemS(R,S,separator,2);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF v < 100 THEN INC(v,century); END;
    IF (v < minyy) OR (v > maxyy) THEN RETURN FALSE; END;
    year := CARDINAL(v);
    dmy:=PackDMY (day,month,year);
    RETURN TRUE;
END parseDate;

PROCEDURE parseDateRange (S:ARRAY OF CHAR;VAR lodate,hidate:CARDINAL):BOOLEAN;
VAR
    rc:BOOLEAN;
    p:CARDINAL;
    S1,S2:str128;
    d,m,y:CARDINAL;
    dow:Lib.DayType;
BEGIN
    removeOption(S); (* we had gotten an option "$:*" *)
    rc:=FALSE;

    (* not here, because dash can be a date separator ! *)
    (* ReplaceChar(S,dash, colon); (* change possible "*-*" range TO "*:*" *) *)

    Str.Subst(S,dotdot,colon);  (* change possible "*..*" range to "*:*" *)
    p:=Str.CharPos(S,colon);

    IF p=MAX(CARDINAL) THEN
        IF same(S,"*") THEN                      (* today *)
            Lib.GetDate(y,m,d,dow);
            lodate:=PackDMY(d,m,y);
            rc:=TRUE;
        ELSE
            rc:=parseDate(S,lodate);
        END;
        hidate:=lodate;                          (* "$" means same *)
    ELSE
        Str.Slice(S1,S,0,p);
        Str.Delete(S,0,p+1); Str.Copy(S2,S);

        IF same(S1,"") THEN                      (* ":$" means before/on *)
            lodate:=PackDMY(1,1,0000);
            rc:=parseDate(S2,hidate);
        ELSIF same(S2,"") THEN                   (* "$:" means on/after *)
            hidate:=PackDMY(31,12,9999);
            rc:=parseDate(S1,lodate);
        ELSE
            rc:=parseDate(S1,lodate);
            IF rc THEN rc:=parseDate(S2,hidate); END;
        END;
    END;
    IF rc THEN
        rc:=(lodate <= hidate); (* safety check *)
    END;
    RETURN rc;
END parseDateRange;

PROCEDURE parseSizeRange (S:ARRAY OF CHAR;VAR losize,hisize:LONGCARD ):BOOLEAN ;
VAR
    rc:BOOLEAN;
    p:CARDINAL;
    S1,S2:str128;
BEGIN
    removeOption(S); (* we had gotten an option "$:*" *)
    rc:=FALSE;
    ReplaceChar(S,dash, colon); (* change possible "*-*" range to "*:*" *)
    Str.Subst(S,dotdot,colon);  (* change possible "*..*" range to "*:*" *)
    p:=Str.CharPos(S,colon);
    IF p=MAX(CARDINAL) THEN
        Str.Concat(S1,colon,S);
        rc:=GetLongCard(S1,losize);
        hisize:=losize;                          (* "$" means exact size *)
    ELSE
        Str.Slice(S1,S,0,p); Str.Prepend(S1,colon);
        Str.Delete(S,0,p+1); Str.Concat(S2,colon,S);

        IF same(S1,colon) THEN                   (* ":$" means $ and less *)
            losize:=MIN(LONGCARD); (* complicated ways to mean 0 ! *)
            rc:=GetLongCard(S2,hisize);
        ELSIF same(S2,colon) THEN                (* "$:" means $ and more *)
            hisize:=MAX(LONGCARD);
            rc:=GetLongCard(S1,losize);
        ELSE
            rc:=GetLongCard(S1,losize);
            IF rc THEN rc:=GetLongCard(S2,hisize); END;
        END;
    END;
    IF rc THEN
        rc:=(losize <= hisize); (* safety check *)
    END;
    RETURN rc;
END parseSizeRange;

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str16;
VAR
    ok   : BOOLEAN;
    v    : LONGCARD;
    len  : CARDINAL;
    S    : str16;
BEGIN
    v := LONGCARD(n);
    Str.CardToStr(v,S,10,ok);
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    RETURN S;
END using;

PROCEDURE fmtDate (dmy:CARDINAL;plain:BOOLEAN) : str16;
CONST
    separator = dash;
    pad       = "0";
    baseyear  = 1900;
    tmonths   = "Jan Fv Mar Avr Mai Jun Jui Ao Sep Oct Nov Dc ???";
    tmonths2  = "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ???";
VAR
    R : str16;
    d,m,y:CARDINAL;
BEGIN
    UnpackDMY(dmy,d,m,y);
    IF ((m < minmm) OR (m > maxmm)) THEN m := 13; END;
    IF plain THEN
    Str.ItemS(R,tmonths2," ",m-1);
    ELSE
    Str.Copy(R, using (m,2,pad));
    END;
    Str.Prepend(R,separator);
    Str.Prepend(R,using(d,2,pad));
    Str.Append(R,separator);
    Str.Append(R,using(y,4,pad));
    RETURN R;
END fmtDate;

PROCEDURE fmtSize (v : LONGCARD; pad:CHAR; sep:CHAR) : str80;
CONST
    field = 10+3; (* #,###,###,### *) (* 1Gb+ file okay now *)
VAR
    S,R   : str80;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.CardToStr( v,S,10,ok); (* fixRealToStr was overkill ! ah, cut/paste is not ALWAYS a good idea... *)
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmtSize;

PROCEDURE fmtDateRange (lodate,hidate:CARDINAL):str80;
VAR
    R:str80;
BEGIN
    IF lodate = hidate THEN
        Str.Copy(R, fmtDate(lodate,TRUE ) );
    ELSE
        R:="[~..~]";
        Str.Subst(R,"~", fmtDate(lodate,TRUE ) );
        Str.Subst(R,"~", fmtDate(hidate,TRUE ) );
    END;
    RETURN R;
END fmtDateRange;

PROCEDURE fmtSizeRange (losize,hisize:LONGCARD):str80;
VAR
    R : str80;
BEGIN
    IF losize = hisize THEN
        Str.Copy(R,      fmtSize(losize,blank,"" ) );
    ELSE
        R:="[~..~]";
        Str.Subst(R,"~", fmtSize(losize,blank,"" ) );
        Str.Subst(R,"~", fmtSize(hisize,blank,"" ) );
    END;
    ReplaceChar(R,blank,"");
    RETURN R;
END fmtSizeRange;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstindex = 1; (* because we'll need 1-1 *)
TYPE
    pEntry = POINTER TO entryType;
    entryType = RECORD
        next      : pEntry;
        index     : CARDINAL;  (* [1.. is ID of base dir for files *)
        slen      : SHORTCARD;
        str       : CHAR;
    END;

PROCEDURE initList (VAR anchor : pEntry );
BEGIN
    anchor := NIL;
END initList;

PROCEDURE freeList (anchor : pEntry);
VAR
    needed : CARDINAL;
    p      : pEntry;
BEGIN
    (* p:=anchor; *)
    WHILE anchor # NIL DO
        needed := SIZE(entryType) - SIZE(anchor^.str) + CARDINAL(anchor^.slen);
        p := anchor^.next;
        DEALLOCATE(anchor,needed);
        anchor:=p;
    END
END freeList;

PROCEDURE buildNewPtr (VAR anchor,p:pEntry; len:CARDINAL):BOOLEAN;
VAR
    needed : CARDINAL;
BEGIN
    needed := SIZE(entryType) - SIZE(p^.str) + len;
    IF Available(needed)=FALSE THEN RETURN FALSE; END;
    IF anchor = NIL THEN
        ALLOCATE(anchor,needed);
        p:=anchor;
    ELSE
        p:=anchor;
        WHILE p^.next # NIL DO
            p:=p^.next;
        END;
        ALLOCATE(p^.next,needed);
        p:=p^.next;
    END;
    p^.next := NIL;
    RETURN TRUE;
END buildNewPtr;

(* ------------------------------------------------------------ *)

(* assume p is valid *)

PROCEDURE getStr (VAR S : pathtype; p:pEntry);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(p^.slen);
    Lib.FastMove( ADR(p^.str),ADR(S),len);
    S[len] := nullchar; (* REQUIRED safety ! *)
END getStr;

PROCEDURE findByIndex(wanted:CARDINAL;anchor:pEntry) : pEntry;
VAR
    p:pEntry;
BEGIN
    p := anchor;
    LOOP
        IF p = NIL THEN EXIT;END; (* gloups ! should NEVER happen ! *)
        IF p^.index = wanted THEN EXIT; END;
        p := p^.next;
    END;
    RETURN p;
END findByIndex;

PROCEDURE isReservedEntry (S:ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isReservedEntry;

PROCEDURE buildDirList (VAR lastdir,lastdirReal:CARDINAL; VAR anchor:pEntry;
                       useLFN,recurse,showbusy,notice:BOOLEAN;base:pathtype):CARDINAL;
VAR
    p: pEntry;
    len : CARDINAL;
    root,rootspec,entryname,newroot : pathtype;
    entry : FIO.DirEntry;
    found : BOOLEAN;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    dosattr:FIO.FileAttr;
    w9Xhandle,errcode:CARDINAL;
    rc : CARDINAL;
    ok:BOOLEAN;
BEGIN
    Str.Copy(root,base);
    fixDirectory(root); (* safety *)

    (* assume base exists ! *)

    ok:=chkNoProtection(notice,showbusy,TRUE,root);
    IF ok THEN
        len:=Str.Length(root);
        IF buildNewPtr(anchor,p,len)=FALSE THEN RETURN errStorage; END;
        INC(lastdir);
        p^.index     := lastdir;
        p^.slen      := SHORTCARD(len);
        Lib.FastMove ( ADR(root),ADR(p^.str),len );
    END;

    INC(lastdirReal);

    IF NOT(recurse) THEN RETURN errNone; END;

    Str.Concat(rootspec,root,"*.*");
    IF useLFN THEN
        found := w9XfindFirst (rootspec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(rootspec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(entryname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(entryname,entry.Name);
        END;
        IF isReservedEntry (entryname) = FALSE THEN (* skip "." AND ".." *)
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=entry.attr;
            END;
            IF (aD IN dosattr) THEN
                Str.Concat(newroot,root,entryname); (* u:\xx\ + xxx *)
                fixDirectory(newroot);
                rc:= buildDirList (lastdir,lastdirReal,anchor,
                                  useLFN,recurse,showbusy,notice,newroot);
                IF rc # errNone THEN
                    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN rc;
                END;
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN errNone;
END buildDirList;

PROCEDURE dmpDirs (anchor:pEntry;useLFN:BOOLEAN);
CONST
    sInfo = "DIR  index= ~  ~"; (* file must always be last with this placeholder *)
VAR
    p : pEntry;
    R: pathtype;
    ok:BOOLEAN;
    S:str1024;   (* oversized *)
BEGIN
    p:=anchor;
    WHILE p # NIL DO
        getStr(R,p);
        Str.Copy(S, sInfo);  Str.Subst(S,"~",fmt(p^.index,10,5," ",""));
        Str.Subst(S,"~", nice(useLFN,R) );
        WrStr(S);WrLn;
        p:=p^.next;
    END;
END dmpDirs;

PROCEDURE dmpDirsAlt (anchor:pEntry;lastdir:CARDINAL;useLFN:BOOLEAN);
CONST
    sInfo = "DIR  INDEX= ~  ~"; (* uppercase to remind it's alt proc *)
VAR
    p : pEntry;
    R: pathtype;
    ok:BOOLEAN;
    S:str1024;   (* oversized *)
    i:CARDINAL;
BEGIN
    FOR i:=firstindex TO lastdir DO
        p:=findByIndex(i,anchor);
        getStr(R,p);
        Str.Copy(S, sInfo);  Str.Subst(S,"~",fmt(p^.index,10,5," ",""));
        Str.Subst(S,"~", nice(useLFN,R) );
        WrStr(S);WrLn;
    END;
END dmpDirsAlt;

PROCEDURE dmpFiles (fileanchor,diranchor:pEntry;dirindex:CARDINAL;useLFN:BOOLEAN);
CONST
    sInfo = "File index= ~  ~"; (* file must always be last with this placeholder *)
VAR
    p : pEntry;
    base,R: pathtype;
    ok:BOOLEAN;
    S:str1024;   (* oversized *)
BEGIN
    p:=findByIndex(dirindex,diranchor);
    getStr(base,p);

    p:=fileanchor;
    WHILE p # NIL DO
        getStr(R,p);
        Str.Copy(S, sInfo);
        Str.Subst(S,"~",fmt(p^.index,10,5," ",""));
        Str.Prepend(R,base);
        Str.Subst(S,"~", nice(useLFN,R) );
        WrStr(S);WrLn;
        p:=p^.next;
    END;
END dmpFiles;

PROCEDURE dmpFilesAlt (fileanchor,diranchor:pEntry; lastfile,dirindex:CARDINAL;useLFN:BOOLEAN);
CONST
    sInfo = "FILE INDEX= ~  ~"; (* uppercase to remind it's alt proc *)
VAR
    p : pEntry;
    base,R: pathtype;
    ok:BOOLEAN;
    S:str1024;   (* oversized *)
    i:CARDINAL;
BEGIN
    p:=findByIndex(dirindex,diranchor);
    getStr(base,p);

    FOR i:=firstindex TO lastfile DO
        p:=findByIndex(i,fileanchor);
        getStr(R,p);
        Str.Copy(S, sInfo);
        Str.Subst(S,"~",fmt(p^.index,10,5," ",""));
        Str.Prepend(R,base);
        Str.Subst(S,"~", nice(useLFN,R) );
        WrStr(S);WrLn;
    END;
END dmpFilesAlt;


PROCEDURE fakeDirList (VAR lastdir,lastdirReal:CARDINAL; VAR anchor:pEntry):CARDINAL;
VAR
    p : pEntry;
    root:pathtype;
    len:CARDINAL;
BEGIN
    root:="";
    len:=Str.Length(root);
    IF buildNewPtr(anchor,p,len)=FALSE THEN RETURN errStorage; END;
    INC(lastdir);
    p^.index     := lastdir;
    p^.slen      := SHORTCARD(len);
    Lib.FastMove ( ADR(root),ADR(p^.str),len );

    INC(lastdirReal);

    RETURN errNone;
END fakeDirList;

PROCEDURE fakeAddFile (VAR globallastfile,globallastfileReal:LONGCARD;
                      VAR lastfile,lastfileReal:CARDINAL; VAR anchor:pEntry;
                      showbusy,notice:BOOLEAN; S:pathtype):CARDINAL;
VAR
    entryname:pathtype;
    pp:pEntry;
    len:CARDINAL;
    ok:BOOLEAN;
BEGIN
    Str.Copy(entryname,S);
    IF isReservedEntry (entryname) THEN RETURN errNone; END; (* skip "." AND ".." *)

    (* if file has no extension, add it as a marker *)
    IF Str.RCharPos(entryname,".")=MAX(CARDINAL) THEN
        Str.Append(entryname,".");
    END;

    ok:= chkNoProtection(notice,showbusy,FALSE,entryname) ;
    IF ok THEN
        len:=Str.Length(entryname);
        IF buildNewPtr(anchor,pp,len)=FALSE THEN RETURN errStorage; END;

        INC(lastfile);
        INC(globallastfile);

        pp^.index     := lastfile;
        pp^.slen      := SHORTCARD(len);
        Lib.FastMove ( ADR(entryname),ADR(pp^.str),len );
    END;

    INC(lastfileReal);
    INC(globallastfileReal);

    RETURN errNone;
END fakeAddFile;

(* modified DD v1.0h sub *)

PROCEDURE storeFiles (VAR globallastfile,globallastfileReal:LONGCARD;
                     VAR lastfile,lastfileReal:CARDINAL;
                     VAR fileanchor : pEntry;
                     useLFN,showbusy,notice,osjokers,sizerange,daterange:BOOLEAN;
                     losize,hisize:LONGCARD; lodate,hidate:CARDINAL;
                     maskfilter : masktype;
                     base,spec:pathtype):CARDINAL;
VAR
    matchspec,rootspec,entryname : pathtype;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    dosattr:FIO.FileAttr;
    w9Xhandle,errcode:CARDINAL;
    entry : FIO.DirEntry;
    ok,keepit,found : BOOLEAN;
    len:CARDINAL;
    pp:pEntry;
    fsize:LONGCARD;
    stampdate,stamptime:CARDINAL;
BEGIN
    lastfile     := firstindex-1; (* 0 *)
    lastfileReal := firstindex-1;
    initList(fileanchor);

    IF osjokers THEN
        Str.Concat(rootspec,base,spec);
        Str.Copy(matchspec,"*");         (* match everything *)
    ELSE
        Str.Concat(rootspec,base,"*.*"); (* was spec before osjoker option *)
        Str.Copy(matchspec,spec);
    END;

    IF useLFN THEN
        found := w9XfindFirst (rootspec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
        unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(rootspec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(entryname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(entryname,entry.Name);
        END;
        IF isReservedEntry (entryname) = FALSE THEN (* skip "." AND ".." *)
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);

                fsize     := w9Xentry.fsize.lo; (* no file should be more than 4Gb anyway ;-) *)
                stampdate := CARDINAL(w9Xentry.lastmod.lo >> 16);
            ELSE
                dosattr:=entry.attr;

                fsize     := entry.size;
                stampdate := entry.date;
            END;

            (* some time, be more clever here -- er... let's try to be, at least *)

            ok:=matchMask(dosattr,maskfilter);

            IF sizerange THEN (* nonsense with dirs *)
                keepit:=NOT ( (fsize < losize) OR (fsize > hisize) );
                ok := (ok AND keepit);
            END;
            IF daterange THEN
                keepit:=NOT ( (stampdate < lodate) OR (stampdate > hidate) );
                ok := (ok AND keepit);
            END;

            IF ok THEN
                (* if file has no extension, add it as a marker *)
                IF Str.RCharPos(entryname,".")=MAX(CARDINAL) THEN
                    Str.Append(entryname,".");
                END;
                ok:=Str.Match(entryname,matchspec); (* was spec *)
                IF ok THEN
                    INC(lastfileReal);
                    INC(globallastfileReal);
                    ok:= chkNoProtection(notice,showbusy,FALSE,entryname);
                END;

                IF ok THEN
                    len:=Str.Length(entryname);
                    IF buildNewPtr(fileanchor,pp,len)=FALSE THEN
                        IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
                        RETURN errStorage;
                    END;
                    INC(lastfile);
                    INC(globallastfile);
                    pp^.index     := lastfile;
                    pp^.slen      := SHORTCARD(len);
                    Lib.FastMove ( ADR(entryname),ADR(pp^.str),len );
                END;
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN errNone;
END storeFiles;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* //FIXME *)

CONST
    CHKEVERY9X = 128; (* let's call chkEscape every CHKEVERY LOOP *)
    CHKEVERYDOS= 8;  (* safety *)

PROCEDURE pollEscape (VAR chkrounds:CARDINAL; useLFN,ignoreESC:BOOLEAN):BOOLEAN;
VAR
    alcatraz:BOOLEAN;
    every:CARDINAL;
BEGIN
    (*
    9x really does NOT like ChkEscape() and randomely hangs till a keypress
    Flushkey() does NOT help
    *)
    (*
    IF useLFN THEN
        hit:=FALSE;
    ELSE
        hit:=ChkEscape();
    END;
    *)
    IF ignoreESC THEN RETURN FALSE;END;
    IF useLFN THEN
        every:=CHKEVERY9X;
    ELSE
        every:=CHKEVERYDOS;
    END;
    INC(chkrounds);
    IF (chkrounds MOD every) = 0 THEN
        chkrounds:=0;
        alcatraz:=ChkEscape();
    ELSE
        alcatraz:=FALSE;
    END;
    RETURN alcatraz;
END pollEscape;

PROCEDURE chkEnvVar (VAR preview:BOOLEAN ):BOOLEAN ;
CONST
    sAllowed = "T"+delim+"TEST"+delim+"PREVIEW"; (* must match options *)
VAR
    R:str16;
    rc:BOOLEAN;
    i : CARDINAL;
BEGIN
    rc:=TRUE;
    Lib.EnvironmentFind(sPCOPYenv , R);
    LtrimBlanks(R);
    RtrimBlanks(R);
    IF same(R,"") THEN RETURN rc; END;
    CASE R[0] OF
    | "-" , "/" :
        ;
    ELSE
        Str.Prepend(R,"-");
    END;
    UpperCase(R);
    i := GetOptIndex(R, sAllowed);
    CASE i OF
    | 1..3 :
        preview:=TRUE;
    ELSE
        rc:=FALSE;
    END;
    RETURN rc;
END chkEnvVar;

(* ------------------------------------------------------------ *)

(*
Seconds are 0 to 29 -- DOS stores nearest even / 2
  hours    minutes   seconds 

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

PROCEDURE fmtTime (timedata:CARDINAL) : str16;
CONST
    hhMask=BITSET{11..15};
    hhShft=11;
    mmMask=BITSET{5..10};
    mmShft=5;
    ssMask=BITSET{0..4};
    ssShft=0;
CONST
    separator = colon;
    padhours = blank;
    pad="0";
VAR
    h,m,s : CARDINAL;
    R : str16;
BEGIN
    h := CARDINAL(BITSET(timedata) * hhMask) >> hhShft;
    m := CARDINAL(BITSET(timedata) * mmMask) >> mmShft;
    s := CARDINAL(BITSET(timedata) * ssMask) >> ssShft;
    s := s << 1; (* yes, yes, "* 2" works too... *)
    R := using(h,2,padhours);
    Str.Append(R,separator);
    Str.Append(R,using(m,2,pad));
    Str.Append(R,separator);
    Str.Append(R,using(s,2,pad));
    RETURN R;
END fmtTime;

PROCEDURE fmtquery (VAR R:ARRAY OF CHAR;isTarget,useLFN:BOOLEAN;canon:pathtype);
CONST
    sDOS = "| | | | |";   (* date time fsize motion file *)
    sLFN = '| | | | "|"';
    placeholder = "|";
VAR
    fsize,stamp:LONGCARD;
    jma,hms:CARDINAL;
BEGIN
    IF useLFN THEN
        Str.Copy(R,sLFN);
    ELSE
        Str.Copy(R,sDOS);
    END;
    fsize:=fileGetFileSize(useLFN,canon);
    stamp:=fileGetFileStamp(useLFN,canon);

    jma:=CARDINAL ( stamp >> 16 );
    hms:=CARDINAL ( stamp AND 0000FFFFH );

    Str.Subst(R,placeholder, fmtDate(jma,TRUE ) );
    Str.Subst(R,placeholder, fmtTime(hms) );
    Str.Subst(R,placeholder, fmtSize(fsize,blank,coma) );
    IF isTarget THEN
        Str.Subst(R,placeholder,"->");
    ELSE
        Str.Subst(R,placeholder,"  ");
    END;
    Str.Subst(R,placeholder, canon);
END fmtquery;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE doGetDir (useLFN:BOOLEAN;currdrive:SHORTCARD;
                   VAR currdir: pathtype);
VAR
    longform:pathtype;
    rc:CARDINAL;
BEGIN
    FIO.GetDir(currdrive,currdir); (* we could use 0 for default drive *)
    IF useLFN THEN
        IF w9XshortToLong(currdir,rc,longform) THEN
            Str.Copy(currdir,longform);
            (* seems this function always returns "u:\*" form  *)
        END;
    END;
    IF currdir[1]=colon THEN Str.Delete(currdir,0,2);END; (* safety for all ! *)
END doGetDir;

(* u, "\*\", "u:\*\" *)

PROCEDURE getAnchor (useLFN:BOOLEAN;
                     VAR currdrive:SHORTCARD;
                     VAR currdir,currpath:pathtype);
VAR
    driveletter:CHAR;
BEGIN
    currdrive := FIO.GetDrive(); (* 1=A, etc. *)
    doGetDir(useLFN,currdrive, currdir);
    fixDirectory(currdir);
    driveletter := CHAR (currdrive+ORD("A")-1);
    Str.Concat(currpath, driveletter,colon);
    Str.Append(currpath, currdir);
END getAnchor;

PROCEDURE doChDir (useLFN:BOOLEAN;dir:pathtype ):BOOLEAN;
VAR
    rc:CARDINAL;
    S:pathtype;
    ok:BOOLEAN;
BEGIN
    IF useLFN THEN
        IF w9XlongToShort(dir,rc,S) THEN
            Str.Copy(dir,S);
        END;
    END;
    FIO.ChDir(dir);
    ok:= (FIO.IOresult()=DOSErr.NO_ERROR); (* true if directory found *)
    RETURN ok; (* true if directory found *)
END doChDir;

PROCEDURE doMkDir (useLFN:BOOLEAN;S:pathtype  );
VAR
    rc:CARDINAL;
    ok:BOOLEAN;
BEGIN
    IF useLFN THEN
        ok:=w9XmakeDir(S,rc);
    ELSE
        FIO.MkDir(S);
    END;
END doMkDir;

(* "u:\xxx[\xxx]...", assume everything goes ok ! *)

PROCEDURE makemydir (S:pathtype;useLFN,setasdefault:BOOLEAN ):BOOLEAN ;
VAR
    i,pb : CARDINAL;
    path : pathtype; (* was str128 *)
    R    : pathtype;
    ok:BOOLEAN;
BEGIN
    pb := 0;

    isoleItemS(path,S,backslash,0);
    FOR i:= 1 TO CharCount(S,backslash) DO
        isoleItemS(R, S, backslash, i);
        Str.Append(path,backslash);
        Str.Append(path,R);
        doMkDir(useLFN,path);

        (*
        WrStr(path);WrLn;
        Lib.WrDosError(SHORTCARD(FIO.IOresult()));WrLn;
        CASE FIO.IOresult() OF
        | DOSErr.NO_ERROR, DOSErr.ERROR_ACCESS_DENIED: ;
        ELSE
            INC(pb);
        END;
        *)
    END;

    IF setasdefault THEN
        IF pb=0 THEN ok:=doChDir(useLFN,S); END;
    END;

    RETURN (pb=0);
END makemydir;

CONST
    buildKeepName = 0; (* flagMAKEPATH = FALSE = don't recreate path *)
    buildKeepPath = 1; (* flagMAKEPATH = TRUE  = keep full path *)
    buildXcopy    = 2; (* flagMAKEPATH = TRUE  = remove root spec in path *)
    buildUndefined= MAX(CARDINAL); (* v1.2i fix *)

PROCEDURE buildtarget (VAR R:pathtype;
                      method:CARDINAL;base,src,rootspec:pathtype);
VAR
    p : CARDINAL;
    u,d,n,e:pathtype;
BEGIN
    CASE method OF
    | buildKeepName :
        Lib.SplitAllPath(src,u,d,n,e);
        Lib.MakeAllPath(src,"","",n,e); (* src is a filename here *)
    | buildKeepPath :
        p:=Str.CharPos(src,colon);
        IF p # MAX(CARDINAL) THEN Str.Delete(src,0,p+1); END; (* remove "u:" if present *)
        IF src[0]=backslash THEN Str.Delete(src,0,1);END; (* remove leading "\" if present *)
    | buildXcopy :
        Str.Subst(src,rootspec,"");
        p:=Str.CharPos(src,colon);
        IF p # MAX(CARDINAL) THEN Str.Delete(src,0,p+1); END; (* remove "u:" if present *)
        IF src[0]=backslash THEN Str.Delete(src,0,1);END; (* remove leading "\" if present *)
    END;
    Str.Concat(R,base,src); (* assume trailing "\" for base *)
END buildtarget;

(* create target path if necessary *)

PROCEDURE handleTargetDir (useLFN,preview:BOOLEAN; currdrive:SHORTCARD;
                          currdir,target:pathtype);
VAR
    u,d,n,e:pathtype; (* "u:" "\*\" "" "" *)
    S:pathtype; (* destdir *)
    was:SHORTCARD;
    rc:BOOLEAN;
BEGIN
    IF preview=FALSE THEN
        Lib.SplitAllPath(target, u,d,n,e); (* d will be in "\*[\*]..\" form *)
        Lib.MakeAllPath(S,u,d,"","");
        unfixDirectory(S); (* FIO.ChDir does not like trailing "\" ! nor does FIO.Exists *)
        IF fileExists(useLFN,S) = FALSE THEN (* this checks for dirs too... without trailing slash *)
            rc:=makemydir(S,useLFN,FALSE); (* don't make newly created dir default *)
            was:= FIO.SetDrive(currdrive);
            unfixDirectory(currdir);
            FIO.ChDir(currdir); (* handles unit but not trailing "\" !!! *)
        END;
    END;
END handleTargetDir;

PROCEDURE initXCOPYtarget (VAR XCOPYrootspec:pathtype;
                          method:CARDINAL;basedir:pathtype);
BEGIN
    CASE method OF
    | buildXcopy :
        Str.Copy(XCOPYrootspec,basedir);
    ELSE
        Str.Copy(XCOPYrootspec,""); (* won't be used *)
    END;
END initXCOPYtarget;

(*
copyRHSdos DOES require DOS canonical paths
00a00shr
Bit(s)  Description
 5      archive   (set by copy)
 2      system
 1      hidden
 0      read-only
*)

PROCEDURE copyRHSdos (source,target:ARRAY OF CHAR );
VAR
    R : SYSTEM.Registers;
    filename : str256;
    attribute : CARDINAL;
BEGIN
    Str.Copy(filename,source);
    filename[Str.Length(filename)] := CHR(0); (* silly safety for asciiz ! *)
    R.AX := 4300H;                            (* get file attributes *)
    R.DS := Seg(filename);
    R.DX := Ofs(filename);
    Lib.Dos(R);
    attribute := R.CX;
    (* assume everything goes without error ! *)

    (* always set bit 5 -- archive --- : %0000000000100000 is $0020 *)
    attribute := (attribute OR 00020H);

    Str.Copy(filename,target);
    filename[Str.Length(filename)] := CHR(0); (* silly safety for asciiz ! *)
    R.AX := 4301H;
    R.DS := Seg(filename);
    R.DX := Ofs(filename);
    R.CX := attribute;
    Lib.Dos(R);
END copyRHSdos;

(* modified : pbroom,forceabort,askuser,dontshowcozuserdenied *)

PROCEDURE doFileCopy (VAR pbroom,forceabort,askuser,dontshowcozuserdenied:BOOLEAN;
                     keepattr,showbusy,kilroy,useLFN,preview,audiobeep,showpercentage,DEBUG:BOOLEAN;
                     orgsource,orgtarget:pathtype);
CONST
    msgCopying = "Copying, please wait..."; (* could add a blank for percentage *)
    kYes       = "Y"; sYes       = "Yes";
    kNo        = "N"; sNo        = "No";
    kYesAll    = "A"; sYesAll    = "Yes to all";
    kQuit      = "Q"; sQuit      = "Quit"; (* "Aborted by user !"+nl+nl *)
    kEsc       = CHR(27);
    kOui       = "O";
    kOuiTous   = "T";
    (* multilingual ! well, the two languages worth consideration, eh eh ! <g> *)
    strPrompt  = "Overwrite ? [Y|O]-yes  [N]-no  [A|T]-yes to all  [Q|Esc]-quit : ";
VAR
    hin,hout:FIO.File;
    got:CARDINAL;
    curreof,askagain:BOOLEAN;
    orgstamp:LONGCARD;
    source,target,shortform,u,d,n,e,S:pathtype;
    rc:CARDINAL;
    ok:BOOLEAN;
    key : str2;
    msg: str16;
    zSource,zTarget:str1024; (* oversized *)
    fsize,fpos,targetfsize:LONGCARD;
    candy:BOOLEAN;
BEGIN
    pbroom:= FALSE; (* default just in case *)
    candy := (showpercentage AND NOT(DEBUG) ) ; (* better safe than sorry *)

    forceabort            :=FALSE; (* default *)
    dontshowcozuserdenied :=FALSE; (* default -- true if user denied operation *)

    IF kilroy THEN (* target "was here" *)
        IF askuser THEN
            busy(showbusy,FALSE); (* it was ON *)
            fmtquery(zSource, FALSE,useLFN,orgsource);
            fmtquery(zTarget, TRUE ,useLFN,orgtarget);
            WrStr(zSource);WrLn;
            WrStr(zTarget);WrLn;
            WrLn;
            IF preview THEN WrStr(sPREVIEW);END;
            WrStr(strPrompt);
            LOOP
                askagain:=FALSE;
                Flushkey;  key := Waitkey();  UpperCase(key);
                IF same(key,kYes) THEN        msg:=sYes;
                ELSIF same(key,kYesAll) THEN  msg:=sYesAll; askuser:=FALSE;
                ELSIF same(key,kQuit) THEN    msg:=sQuit; forceabort:=TRUE;
                ELSIF same(key,kEsc) THEN     msg:=sQuit; forceabort:=TRUE;
                ELSIF same(key,kOui) THEN     msg:=sYes;
                ELSIF same(key,kOuiTous) THEN msg:=sYesAll; askuser:=FALSE;
                ELSIF same(key,kNo) THEN      msg:=sNo;dontshowcozuserdenied:=TRUE;
                ELSE                          errbip(audiobeep); askagain:=TRUE;
                END;
                IF NOT(askagain) THEN EXIT;END;
            END;
            WrStr(msg);WrLn;
            WrLn;
            busy(showbusy,TRUE); (* restore it now *)
            IF dontshowcozuserdenied THEN RETURN; END;
            IF forceabort            THEN RETURN; END;
        END;
    END;

    curreof:=FIO.EOF; (* almost certainly useless but cannot harm *)

    IF NOT(DEBUG) THEN video(msgCopying,TRUE); END;

    IF preview=FALSE THEN

IF DEBUG THEN dbg("orgsource",orgsource);END;
IF DEBUG THEN dbg("orgtarget",orgtarget);END;
        Str.Copy(source,orgsource);
        Str.Copy(target,orgtarget);

        IF useLFN THEN

            (* check future newname does not already exists and kill it if required *)

            IF fileExists (useLFN,orgtarget) THEN
                (* fileSetRW(useLFN,orgtarget); (* done earlier *) *)
                fileErase(useLFN,orgtarget);
IF DEBUG THEN dbg("orgtarget (del)",orgtarget);END;
            END;

            IF w9XlongToShort(source,rc,shortform) THEN
                Str.Copy(source,shortform);
            END;
IF DEBUG THEN dbg("source (short)",source);END;
            Lib.SplitAllPath(target,u,d,n,e);
            Lib.MakeAllPath(target,u,d,"","");
            unfixDirectory(target);
IF DEBUG THEN dbg("target",target);END;
            IF w9XlongToShort(target,rc,shortform) THEN
                Str.Copy(target,shortform);
            END;
            fixDirectory(target);
IF DEBUG THEN dbg("target (short)",target);END;
            Str.Append(target,tmpTARGET);
IF DEBUG THEN dbg("target",target);END;

        END;

        hin:=FIO.OpenRead(source);
        FIO.AssignBuffer(hin,ioBufferIn);
        hout:=FIO.Create(target);           (* // v1.0f it's a DOS function ! *)
        FIO.AssignBuffer(hout,ioBufferOut); (* // v1.0d bugfix ! *)

        orgstamp:=FIO.GetFileDate(hin); (* we were silly to forget that one ! *)

        fsize:=FIO.Size(hin);
        fpos :=0;
        IF candy THEN completed(completedInit,fsize); END;

        FIO.EOF:=FALSE;
        LOOP
            got:=FIO.RdBin(hin,dataBuffer,dataBufferSize);
(* IF DEBUG THEN dbgcard("got",got);END; *)
            IF got = 0 THEN EXIT; END;
            FIO.WrBin(hout,dataBuffer,got);
            IF got # dataBufferSize THEN EXIT; END;

            INC(fpos,LONGCARD(got));
            IF candy THEN completed(completedShow,fpos);END; (* SHOW is not faster *)

        END;

        IF candy THEN completed(completedEnd,0);END;

        FIO.Flush(hout);
        FIO.Close(hout);
        FIO.Close(hin);

        (* NOW and only NOW, we may update again date and time if needed *)

        hout:=FIO.Open(target);
        FIO.SetFileDate(hout,orgstamp);
        targetfsize := FIO.Size(hout); (* "yes we can" as bozos say *)
        pbroom := (fsize # targetfsize);
        FIO.Close(hout);

        IF pbroom THEN
            FIO.Erase(target); (* kill partially copied file *)
        ELSE
            IF keepattr THEN copyRHSdos(source,target);END;
        END;

        IF useLFN THEN
            (*
                here, we are to rename temporary DOS name to LFN
                so check newname does not already exists and kill it if required
            *)
            (*
            done earlier for the sake of free space on floppy
            IF fileExists (useLFN,orgtarget) THEN
                fileErase(useLFN,orgtarget);
IF DEBUG THEN dbg("orgtarget (del)",orgtarget);END;
            END;
            *)
            (*
                this function fails if it believes we try and rename across drives :
                give it a full path to avoid error 17 not same unit
            *)
IF DEBUG THEN dbg("target",target);END;
IF DEBUG THEN dbg("orgtarget",orgtarget);END;
            ok:= w9Xrename(target,orgtarget,rc); (* assume success *)
IF DEBUG THEN dbgcard("rename errcode",rc);END;
IF DEBUG THEN dbgbool("rename",ok);END;
        END;

    END;
    IF NOT(DEBUG) THEN video(msgCopying,FALSE);END;

    FIO.EOF := curreof;
END doFileCopy;

(* as of v1.2o+, different algos whether DOS or LFN *)

PROCEDURE buildnewname (useLFN,DEBUG:BOOLEAN;renfix:CARDINAL;
          VAR S : pathtype):BOOLEAN ;
CONST
    firsttry = 1; (* was 0 *)
    maxtries = 9999;
    maxf8    = 8;
    max9X    = 128; (* should be more than enough *)
VAR
    u,d,n,e,newfile,fname : pathtype;
    i   : LONGCARD;
    value,num : str16;
    ok  : BOOLEAN;
    len,maxlen,wi : CARDINAL;
BEGIN
    IF useLFN THEN
        maxlen := max9X;
    ELSE
        maxlen := maxf8;
    END;
    Lib.SplitAllPath(S,u,d,n,e);
    len:=Str.Length(n);
    i:=firsttry;
    LOOP
        Str.CardToStr(i,value,10,ok);
        FOR wi:=Str.Length(value)+1 TO renfix DO Str.Prepend(value,"0");END;
        IF useLFN THEN
            num:=lfnrenmask;
        ELSE
            num:=dosrenmask;
        END;
        Str.Subst(num,"#",value);
        WHILE (len+Str.Length(num)) > maxlen DO
            Str.Delete(n,len-1,1); (* delete last char of name *)
            DEC(len);
        END;
        Str.Concat(fname,n,num); (* build new name *)
        Lib.MakeAllPath(newfile,u,d,fname,e);
IF DEBUG THEN dbg("newfile",newfile);END;
        IF fileExists(useLFN,newfile)=FALSE THEN
            Str.Copy(S,newfile);
            RETURN TRUE;
        END;
        INC(i);
        IF i > maxtries THEN EXIT; END;
    END;
    RETURN FALSE;
END buildnewname;


(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE aboutProblem (pb:CARDINAL;
                       VAR isSuccess:BOOLEAN;VAR msg:ARRAY OF CHAR);
VAR
    R:str128;
BEGIN
    CASE pb OF
    | pbNone:         R:=msgOK;             (* ok *)
    | pbJoker:        R:=msgJoker;
    | pbNotFound:     R:=msgNotFound;
    | pbTargetExists: R:=msgTargetExists;
    | pbTargetRO:     R:=msgTargetRO;
    | pbTargetNewer:  R:=msgTargetNewer;
    | pbRenameFailure:R:=msgRenameFailure;
    | pbRoomCopy:     R:=msgRoomCopy;
    | pbRoomMove:     R:=msgRoomMove;
    | pbSourceRO:     R:=msgSourceRO;       (* well... half a success *)
    | pbCollision:    R:=msgCollision;
    | pbRenamed:      R:=msgRenamed;        (* ok *)
    | pbMovedRO:      R:=msgMovedRO;        (* ok *)
    | pbMoved:        R:=msgMoved;          (* ok *)
    | pbFreshen:      R:=msgFreshen;
    | pbTargetNewerOrSame:  R:=msgTargetNewerOrSame;
    ELSE
                      R:=msgUnexpected;
    END;
    Str.Copy(msg,R);
    CASE pb OF
    | pbNone,pbRenamed,pbMovedRO,pbMoved:
        isSuccess:=TRUE;
    | pbSourceRO:
        isSuccess:=FALSE; (* well... *)
    ELSE
        isSuccess:=FALSE;
    END;
END aboutProblem;

CONST
    INITSTATS = MAX(CARDINAL);

PROCEDURE keepStats (VAR successes,warnings:LONGCARD; pb:CARDINAL);
BEGIN
    CASE pb OF
    | INITSTATS:
        successes:=0;
        warnings :=0;
    | pbNone,pbRenamed,pbMovedRO,pbMoved:
        INC(successes);
    | pbSourceRO:
        INC(warnings); (* well... *)
    ELSE
        INC(warnings);
    END;
END keepStats;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* assume targetbasecooked is UpperCaseAlt-ed "u:\" or "u:\*\" *)

PROCEDURE chkCollision (DEBUG:BOOLEAN;src,dst,targetbasecooked:pathtype):BOOLEAN;
BEGIN
    UpperCaseAlt(src); (* keep accents *)
    UpperCaseAlt(dst);
IF DEBUG THEN
    dbg("chkCollision base",targetbasecooked);
    dbg("chkCollision dst ",dst);
    dbg("chkCollision src ",src);
END;
    IF Str.Match(src,"?:\*")=FALSE THEN (* should handle filename or partial filename *)
        Str.Prepend(src,targetbasecooked);
IF DEBUG THEN
    dbg("chkCollision SRC ",src);
    dbg("chkCollision dst ",dst);
END;
    END;
    RETURN same(src,dst);
END chkCollision;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* code adapted from FCOMP v1.3c *)

(* minimalist *)

PROCEDURE chkBothSpecsForCollision (b1,s1,b2,s2:pathtype ):BOOLEAN;
VAR
    p1,p2:pathtype;
BEGIN
    Str.Concat(p1,b1,s1);
    Str.Concat(p2,b2,s2);
    UpperCaseAlt(p1); (* keep accents *)
    UpperCaseAlt(p2);
    RETURN NOT( same(p1,p2) );
END chkBothSpecsForCollision;

(* current is "\" or "\*\" *)

PROCEDURE buildParent (VAR parent:pathtype; current:pathtype):BOOLEAN;
VAR
    p:CARDINAL;
BEGIN
    IF Str.Match(current,"\") THEN RETURN FALSE; END;
    unfixDirectory(current);
    p:=Str.RCharPos(current,"\");
    Str.Slice(parent,current,0,p+1); (* keep final "\" *)
    RETURN TRUE;
END buildParent;

PROCEDURE doGetCurrent (useLFN:BOOLEAN;drive:SHORTCARD;
                       VAR unit:str2; VAR current:pathtype);
VAR
    rc:CARDINAL;
    longform:pathtype;
BEGIN
    Str.Concat(unit, CHR( ORD("A")-1+ORD(drive) ),colon);

    FIO.GetDir(drive,current); (* \path without u: nor trailing \ except at root *)
    IF current[1] # colon THEN Str.Prepend(current,unit); END; (* safety *)
    IF useLFN THEN
        IF w9XshortToLong(current,rc,longform) THEN (* if error, keep DOS current *)
            Str.Copy(current,longform);
        END;
    END;
    (* LFN function seems to always return "u:\*" form except at root *)
    IF current[1] = colon THEN Str.Delete(current,0,2);END; (* safety *)
    fixDirectory(current);
END doGetCurrent;

(*
    remember dirs can have an extension, and LFNs can have inner dots
    we handle (whether u: or not) :

    .        current
    ..       parent
    .\xxx    current\xxx       F/D
    ..\xxx   parent\xxx        F/D

    xxx\     current\xxx\
    xxx\.    current\xxx\
    xxx      current\xxx       F/D

    \xxx\    \xxx\
    \xxx     \xxx              F/D
*)

PROCEDURE chkfixSpec (VAR base,spec:pathtype;
                     useLFN:BOOLEAN;orgS:pathtype;HDletters:ARRAY OF CHAR):CARDINAL;
VAR
    p,len,rc:CARDINAL;
    drive:SHORTCARD;
    u:CHAR;
    unit:str2;
    current,parent,S:pathtype;
    ok:BOOLEAN;
BEGIN
    Str.Copy(S,orgS);
    IF Str.Pos(S,"\\") # MAX(CARDINAL) THEN RETURN errNetSlash;END;

    (* process u: in S *)

    CASE CharCount(S,colon) OF
    | 0 :
        drive := FIO.GetDrive();
        rc:=errNone;
    | 1 :
        IF Str.CharPos(S,colon) = 1 THEN
            u:=CAP( S[0] );
            CASE u OF
            | "A".."Z" :
                IF verifyString(u,HDletters) THEN
                    drive := SHORTCARD( ORD(u) - ORD("A") +1 );
                    Str.Delete(S,0,2); (* remove u: *)
                    rc:=errNone;
                ELSE
                    rc:=errPhantomUnit;
                END;
            ELSE
                rc:=errBadUnit;
            END;
        ELSE
            rc:=errColon;
        END;
    ELSE
        rc:=errColon;
    END;
    IF rc # errNone THEN RETURN rc; END;

    (* note S no longer has u: *)

    doGetCurrent(useLFN,drive, unit,current); (* "u:" and "\" or "\*\" *)
    ok:=buildParent(parent, current);

    IF same(S,".") THEN Str.Copy(S,current);END;
    IF same(S,"..") THEN
        IF ok THEN Str.Copy(S,parent) ELSE RETURN errNoParent; END;
    END;
    IF Str.Match(S,".\*") THEN Str.Subst(S,".\",current); END;
    IF Str.Match(S,"..\*") THEN
        IF ok THEN Str.Subst(S,"..\",parent) ELSE RETURN errNoParent;END;
    END;
    IF Str.Match(S,"\*")=FALSE THEN Str.Prepend(S,current);END;
    IF Str.Match(S,"*\.") THEN
        (* S[Str.Length(S)-1]:=0C; *)
        len:=Str.Length(S);
        Str.Delete(S,len-1,1);
    END;
    (* we don't want inner or trailing ".." now *)
    IF Str.Pos(S,"..") # MAX(CARDINAL) THEN RETURN errInnerParent;END;

    (* base = "u:\xxx\" and spec = "xxx" *)

    IF Str.Match(S,"*\") THEN
        Str.Concat(base,unit,S);
        Str.Copy(spec,"*.*");
    ELSE
        Str.Prepend(S,unit);
        (* S is u:[\xxx]... without trailing "\" *)
        len:=Str.Length(S);
        p:=Str.RCharPos(S,"\");
        Str.Slice(base,S,0,p+1);
        Str.Slice(spec,S,p+1,len-p);
        IF chkJoker(spec)=FALSE THEN (* if spec has joker(s), assume files *)
            (* spec has no joker : dir or file ? *)
            IF fileIsDirectorySpec(useLFN,S) THEN
                Str.Copy(base,S);
                fixDirectory(base); (* safety *)
                Str.Copy(spec,"*.*");
            END;
        END;
    END;
    IF chkJoker(base) THEN RETURN errDirJoker; END;
    RETURN errNone;
END chkfixSpec;

(* ------------------------------------------------------------ *)

(* R is specified base, currpath is "u:\*" current dir, was handleDir() *)
(* now fixed for JPI Lib.SplitAllPath() bug -- and for ".[.]\$" forms too *)

PROCEDURE preprocessDir (VAR R:pathtype;useLFN:BOOLEAN;currpath:pathtype):CARDINAL;
VAR
    u,dne:pathtype; (* "u:" *)
    current,Z:pathtype;
    p,rc:CARDINAL;
    longform:pathtype;
    thisdrive:SHORTCARD;
BEGIN
    IF Str.Match(R,colon+"*") THEN RETURN errBase; END;  (* ":xxx" *)
    IF ( same(R,dot) OR same(R,dot+backslash) ) THEN     (* "." or ".\" *)
        Str.Copy(R,currpath);RETURN errNone;
    END;
    IF ( same(R,dotdot) OR same(R,dotdot+backslash) ) THEN (* ".." or "..\" *)
        IF buildParent (R,currpath) THEN
            RETURN errNone;
        ELSE
            RETURN errBase;
        END;
    END;

    (* note Lib.SplitAllPath eats extension in directory part if path is fixed with a trailing "\" ! *)

    IF NOT (Str.Match(R,"?"+colon)) THEN fixDirectory(R);END; (* keep possible "u:" alone *)

    p:=Str.CharPos(R,":");
    IF p = MAX(CARDINAL) THEN
        u:="";
        Str.Copy(dne,R);
    ELSE
        Str.Slice(u,R,0,p+1); (* "u:" *)
        Str.Copy(dne,R);
        Str.Delete(dne,0,p+1);
    END;

    IF same(u,"") THEN
        IF Str.Match(R,backslash+"*") THEN (* "\xxx\" *)
            Str.Prepend(R,colon);
            Str.Prepend(R,currpath[0]); (* driveletter *)
        ELSE
            IF Str.Match(R,dot+backslash+"*") THEN        (* ".\xxx\" *)
                Str.Subst(R,dot+backslash,"");
                Str.Prepend(R,currpath);
            ELSIF Str.Match(R,dotdot+backslash+"*") THEN  (* "..\xxx\" *)
                IF buildParent(Z,currpath)=FALSE THEN RETURN errBase;END;
                Str.Subst(R,dotdot+backslash,"");
                Str.Prepend(R,Z);
            ELSE                                          (* "xxx\" *)
                Str.Prepend(R,currpath);
            END;
        END;
    ELSE
        IF Str.Match(dne,backslash+"*") THEN (* "u:\xxx\" *)
            ;
        ELSE
            thisdrive :=SHORTCARD (ORD (CAP(u[0]) )-ORD("A")+1); (* uppercase *)
            doGetDir(useLFN,thisdrive, current); (* path without unit *)
            fixDirectory(current);
            IF Str.Match(dne,dot+backslash+"*") THEN       (* "u:.\xxx\" *)
                Str.Subst(dne,dot+backslash,"");
                Str.Concat(R,u,current);
                Str.Append(R,dne);
            ELSIF Str.Match(dne,dotdot+backslash+"*") THEN (* "u:..\xxx\" *)
                IF buildParent(Z,current)=FALSE THEN RETURN errBase;END;
                Str.Subst(dne,dotdot+backslash,"");
                Str.Concat(R,u,Z);
                Str.Append(R,dne);
            ELSE                                           (* "u:xxx\" *)
                Str.Concat(R,u,current);
                Str.Append(R,dne);
            END;
        END;
    END;

    (* safety : we don't want inner or trailing ".." now *)
    IF Str.Pos(R,"..") # MAX(CARDINAL) THEN RETURN errInnerParent;END;

    unfixDirectory(R);
    (* spec already filtered for joker by caller : now is dir or existing file ? *)
    IF NOT ( fileIsDirectorySpec(useLFN,R) ) THEN
        (* either entry not found, or found an existing file *)
        IF fileExists(useLFN,R) THEN RETURN errTargetIsFile; END;
        (* not found ? we'll create it ! *)
    END;
    fixDirectory(R);

    RETURN errNone;
END preprocessDir;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    showmodetype = (showboth,showsuccess,showfailure);

PROCEDURE showParms (flagVERBOSEBYE,  useLFN,
                    flagLISTMODE,flagRECURSE,flagOVERWRITE,flagRO,
                    flagSKIPNEWER,flagSKIPNEWERORSAME,
                    flagFRESHEN,flagATTR,flagAUTORENAME,
                    flagMOVE,flagROSOURCE,flagPREVIEW,flagERRBEEP,flagASKUSER,
                    flagDATErange,flagSIZErange,flagNOTICE,flagPERCENTAGE,
                    flagIGNOREESC,flagOSjokers,
                    flagIGNOREINI,flagFORCESWAPFILESPROTECTION,
                    flagAUDIOWHENDONE,FAKEOKSTORAGE:BOOLEAN;
                    renfix,buildMethod, lodate,hidate:CARDINAL;
                    losize,hisize:LONGCARD;
                    showmode:showmodetype;
                    listfile,specbase,spec,targetbase,currpath:pathtype);
CONST
    sYes       = "yes";
    sNo        = "no";
VAR
    msg:str80; (* oversized *)
    ini:pathtype;
    inihere,actualswapfilesprotection:BOOLEAN;
BEGIN
    Lib.ParamStr(ini,0);
    UpperCase(ini); (* useless *)
    Str.Subst(ini,extEXE,extINI);
    inihere:=fileExists(useLFN,ini);
    actualswapfilesprotection:=swapfilesprotectionFIX (flagFORCESWAPFILESPROTECTION,inihere,flagIGNOREINI);

            WrStr(banner);WrLn;
            WrLn;
    IF NOT(flagVERBOSEBYE) THEN
        IF flagLISTMODE THEN
            wF("List file"                ,listfile,useLFN);
        ELSE
            wF("Source directory"         ,specbase,useLFN);
            wF("Source specification"     ,spec,useLFN);
        END;
            wF("Target directory"         ,targetbase,useLFN);
            WrLn;
    END;
            wF("Default directory"        ,currpath,useLFN);

            WrStr( padinf(widmp,"Recreate paths") ); (* flagMAKEPATH *)
            CASE buildMethod OF
            | buildKeepName: msg:=sNo;
            | buildKeepPath: msg:=sYes;
            | buildXcopy:    msg:=sYes+" (XCOPY mode)";
            | buildUndefined:msg:="not yet defined";
            END;
            WrStr(msg);WrLn;

            wB("Recurse subdirectories"   ,flagRECURSE,sYes,sNo);
            wB("Overwrite target"         ,flagOVERWRITE,sYes,sNo);
            wB("Overwrite read-only"      ,flagRO,sYes,sNo);
            wB("Overwrite newer"          ,NOT(flagSKIPNEWER),sYes,sNo);
            wB("Overwrite same"           ,NOT(flagSKIPNEWERORSAME),sYes,sNo);
            wB("Freshen existing target"  ,flagFRESHEN,sYes,sNo);
            wB("Keep source RHS flags"    ,flagATTR,sYes,sNo);
            wB("Autorename"               ,flagAUTORENAME,sYes,sNo);
            wB("Erase source"             ,flagMOVE,sYes,sNo);
            wB("Erase read-only source"   ,flagROSOURCE,sYes,sNo);
            wB("Preview"                  ,flagPREVIEW,sYes+' (with "'+sPREVIEW+'" reminder prefix)',sNo);
            wB("Date range filter"        ,flagDATErange,fmtDateRange(lodate,hidate),sNo);
            wB("Size range filter"        ,flagSIZErange,fmtSizeRange(losize,hisize),sNo);
            wB("Show copy percentage"     ,flagPERCENTAGE,sYes,sNo);
            wB("Show successes"           ,((showmode=showboth) OR (showmode=showsuccess)),sYes,sNo);
            wB("Show failures/problems"   ,((showmode=showboth) OR (showmode=showfailure)),sYes,sNo);
            wB("Ignore allocation failure",FAKEOKSTORAGE,sYes,sNo);
            wB("List protected entries"   ,flagNOTICE,sYes,sNo);
            wB("Terminate if Escape"      ,NOT(flagIGNOREESC),sYes,sNo);

            wB("Confirmation by user"     ,flagASKUSER,sYes,sNo);
            wB("Beep on unexpected choice",flagERRBEEP,sYes,sNo);
            wB("Beep at completion"       ,flagAUDIOWHENDONE,sYes,sNo);

            wB("Windows 9x LFN"           ,useLFN,sYes,sNo);
            wB("Operating system jokers"  ,flagOSjokers,sYes,sNo);
            wB("Ignore "+progEXEname+extINI+" (cli)",flagIGNOREINI,sYes,sNo);
            wB("Protect Win swapfiles (cli)",flagFORCESWAPFILESPROTECTION,sYes,sNo);
            wB(progEXEname+extINI+" found",inihere,sYes,sNo);
            wB("Autoprotect Win swapfiles",actualswapfilesprotection,sYes,sNo);
            dmpProtected(useLFN,TRUE,lastEntryProtected );

END showParms;

PROCEDURE fixStorageError (VAR rc, ignoredstoragepb:CARDINAL;
                          fakeokstorage:BOOLEAN);
BEGIN
    IF rc=errStorage THEN
        IF fakeokstorage THEN
           rc:=errNone;
           INC(ignoredstoragepb);
        END;
    END;
END fixStorageError;

(* ------------------------------------------------------------ *)

(*%T USEFLOATSTAMP *)

(* now, this is UGLY -- should we use bigger K coeffs to handle rounding ? *)

PROCEDURE getPackedFileStamp (useLFN:BOOLEAN; S:pathtype):LONGREAL;
CONST
    k10e4 =   10000;
    k10e2 =     100;
    k10e6 = 1000000.0;
    baseyear = 1900; (* 2008 was 108 before this fix *)
VAR
    hnd:FIO.File;
    stamp:FIO.FileStamp;
    ok:BOOLEAN;
    y,m,d,hh,mm,ss:SHORTCARD;
    yyyymmdd : LONGCARD;
    hhmmss   : LONGCARD;
    n        : LONGREAL;
BEGIN
    hnd:=fileOpenRead(useLFN,S);
    ok:=FIO.GetFileStamp(hnd,stamp);
    FIO.Close(hnd);
    y  := stamp.Year ;
    m  := stamp.Month;
    d  := stamp.Day  ;
    hh := stamp.Hour ;
    mm := stamp.Min  ;
    ss := stamp.Sec  ;

    yyyymmdd:=k10e4*( LONGCARD(y)+baseyear )+k10e2*LONGCARD(m)+LONGCARD(d);
    hhmmss  :=k10e4*LONGCARD(hh)+k10e2*LONGCARD(mm)+LONGCARD(ss);
    n       := LONGREAL(yyyymmdd)+(LONGREAL(hhmmss)/k10e6);
    RETURN n;
END getPackedFileStamp;

PROCEDURE chkStamp (flagSKIPNEWERORSAME,useLFN:BOOLEAN;R,S:pathtype):BOOLEAN;
VAR
    stampR,stampS:LONGREAL;
    ok:BOOLEAN;
BEGIN
    stampR:=getPackedFileStamp(useLFN,R);
    stampS:=getPackedFileStamp(useLFN,S);
    IF flagSKIPNEWERORSAME THEN
        ok:=( stampR <= stampS );
    ELSE
        ok:=( stampR < stampS );
    END;
    RETURN ok;
END chkStamp;

(*%E  *)

(* ------------------------------------------------------------ *)

(*%F USEFLOATSTAMP *)

(*
PROCEDURE getPackedFileStamp (VAR yyyymmdd,hhmmss:LONGCARD;
                             useLFN:BOOLEAN; S:pathtype);
CONST
    k10e4    = LONGCARD(  10000);
    k10e2    = LONGCARD(    100);
    baseyear = LONGCARD(   1900); (* 2008 was 108 before this fix *)
VAR
    hnd:FIO.File;
    stamp:FIO.FileStamp;
    ok:BOOLEAN;
    y,m,d,hh,mm,ss:SHORTCARD;
BEGIN
    hnd:=fileOpenRead(useLFN,S);
    ok:=FIO.GetFileStamp(hnd,stamp);
    FIO.Close(hnd);
    y  := stamp.Year ;
    m  := stamp.Month;
    d  := stamp.Day  ;
    hh := stamp.Hour ;
    mm := stamp.Min  ;
    ss := stamp.Sec  ;

    yyyymmdd:=k10e4*( LONGCARD(y)+baseyear )+k10e2*LONGCARD(m)+LONGCARD(d);
    hhmmss  :=k10e4*LONGCARD(hh)+k10e2*LONGCARD(mm)+LONGCARD(ss);
END getPackedFileStamp;

PROCEDURE chkStamp (flagSKIPNEWERORSAME,useLFN:BOOLEAN;R,S:pathtype):BOOLEAN;
VAR
    ymdR,hmsR, ymdS,hmsS:LONGCARD;
    ok:BOOLEAN;
BEGIN
    getPackedFileStamp(ymdR,hmsR,useLFN,R);
    getPackedFileStamp(ymdS,hmsS,useLFN,S);
    IF flagSKIPNEWERORSAME THEN
        IF ymdR < ymdS THEN
            ok:=TRUE;
        ELSIF ymdR > ymdS THEN
            ok:=FALSE;
        ELSE                                (* = *)
            ok:=( hmsR <= hmsS);
        END;
    ELSE
        IF ymdR < ymdS THEN
            ok:=TRUE;
        ELSIF ymdR > ymdS THEN
            ok:=FALSE;
        ELSE                                (* = *)
            ok:=( hmsR < hmsS);
        END;
    END;
    RETURN ok;
END chkStamp;
*)

PROCEDURE getPackedFileStamp (useLFN:BOOLEAN; S:pathtype):LONGCARD;
VAR
    hnd:FIO.File;
    dt:LONGCARD;
BEGIN
    hnd:=fileOpenRead(useLFN,S);
    dt:=FIO.GetFileDate(hnd);
    FIO.Close(hnd);
    RETURN dt;
END getPackedFileStamp;

PROCEDURE chkStamp (flagSKIPNEWERORSAME,useLFN:BOOLEAN;R,S:pathtype):BOOLEAN;
VAR
    stampR,stampS:LONGCARD;
    ok:BOOLEAN;
BEGIN
    stampR:=getPackedFileStamp(useLFN,R);
    stampS:=getPackedFileStamp(useLFN,S);
    IF flagSKIPNEWERORSAME THEN
        ok:=( stampR <= stampS );
    ELSE
        ok:=( stampR < stampS );
    END;
    RETURN ok;
END chkStamp;

(*%E  *)

(* ------------------------------------------------------------ *)

PROCEDURE getcodePBstamp (flagSKIPNEWERORSAME:BOOLEAN;
                     pbTargetNewer,pbTargetNewerOrSame:CARDINAL):CARDINAL;
VAR
    pb:CARDINAL;
BEGIN
    IF flagSKIPNEWERORSAME THEN
        pb:=pbTargetNewerOrSame;
    ELSE
        pb:=pbTargetNewer;
    END;
    RETURN pb;
END getcodePBstamp;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstparm    = 1;
    maxparm      = 2;
VAR
    i,opt,parmcount,lastparm:CARDINAL;
    orgR,S,R:pathtype;
    flagPREVIEW:BOOLEAN;
    flagOVERWRITE,flagRO,flagSKIPNEWER,flagSKIPNEWERORSAME:BOOLEAN;
    flagAUDIOWHENDONE,flagABORT:BOOLEAN;
    flagMAKEPATH,flagAUTORENAME,flagATTR,flagRECURSE:BOOLEAN;
    flagMOVE,flagROSOURCE,flagVERBOSE,flagLISTMODE,flagASKUSER:BOOLEAN;
    flagDONTSHOWCOZUSERDENIED,flagIGNOREESC,flagVERBOSEBYE:BOOLEAN;
    flagIGNOREINI,flagFORCESWAPFILESPROTECTION,flagNOTICE,flagOSjokers:BOOLEAN;
    flagERRBEEP,flagDATErange,flagSIZErange,flagFRESHEN,flagPERCENTAGE:BOOLEAN;
    flagROOM:BOOLEAN;
    renfix:CARDINAL;
    FAKEOKSTORAGE : BOOLEAN;
    IGNOREDSTORAGEPB:CARDINAL;
    useLFN,DEBUG : BOOLEAN;
    parm : ARRAY [firstparm..maxparm] OF pathtype;
    showmode : showmodetype;
    showbusy,redirected,isSuccess, collisionRisk : BOOLEAN;
    sLegalUnits,sLegalTargetUnits:str80; (* more than enough *)
    hin:FIO.File;
    doit:BOOLEAN;
    stampSource,stampTarget:LONGCARD;
    pb:CARDINAL;
    ok,kilroy,md : BOOLEAN; (* because kilroy "was here" -- oui, c'est lamentable *)
    globallastfile,globallastfileReal:LONGCARD;
    lastfile,lastfileReal,fileindex:CARDINAL;
    msgPrefix : str16;
    successes,warnings:LONGCARD;
    lodate,hidate:CARDINAL;
    losize,hisize:LONGCARD;
    maskfilter:masktype;
    currdrive:SHORTCARD;
    listfile,basedir,currdir,currpath,XCOPYrootspec:pathtype;
    rc:CARDINAL;
    orgspec,specbase,spec, targetbase,targetspec,targetbasecooked:pathtype;
    pf,pdir,diranchor,fileanchor:pEntry;
    buildMethod:CARDINAL;
    msg:str1024; (* allow for orgR inclusion *)
    lastdir,lastdirReal,dirindex:CARDINAL;
    chkrounds:CARDINAL;
    base:pathtype;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    FIO.ShareMode:=FIO.ShareDenyNone; (* very, very important ! *)

    WrLn;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    lastparm      := firstparm-1;
    flagPREVIEW   := FALSE;
    useLFN        := TRUE;
    showmode      := showboth;
    flagOVERWRITE := FALSE;
    flagRO        := FALSE;
    flagSKIPNEWER := FALSE;
    flagSKIPNEWERORSAME := FALSE;
    flagAUDIOWHENDONE:= FALSE;
    flagMAKEPATH  := TRUE;
    flagAUTORENAME:= FALSE; renfix := renfixdefault;
    flagMOVE      := FALSE;
    flagROSOURCE  := FALSE;
    flagVERBOSE   := FALSE;
    flagVERBOSEBYE:= FALSE;
    flagLISTMODE  := FALSE;
    flagASKUSER   := FALSE;
    flagATTR      := FALSE;
    flagRECURSE   := FALSE;
    flagIGNOREESC := FALSE;
    flagIGNOREINI := FALSE; (* -x will force existing ini to be ignored *)
    flagFORCESWAPFILESPROTECTION := TRUE;
    flagNOTICE    := FALSE;
    flagOSjokers  := FALSE;
    flagDATErange := FALSE;
    flagSIZErange := FALSE;
    flagFRESHEN   := FALSE;
    flagERRBEEP   := TRUE;
    flagPERCENTAGE:= TRUE;
    buildMethod   := buildUndefined;
    ok:=parseMask(showfilesonly,maskfilter);
    FAKEOKSTORAGE    := FALSE;
    IGNOREDSTORAGEPB := 0;
    DEBUG         := FALSE;

    IF chkEnvVar(flagPREVIEW) = FALSE THEN abort(errBadEnv,sPCOPYenv);END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R,
                       "?"+delim+"H"+delim+"HELP"+delim+
                       "T"+delim+"TEST"+delim+"PREVIEW"+delim+
                       "Q"+delim+"QUIET"+delim+   (* failures and problems *)
                       "L"+delim+"LFN"+delim+
                       "O"+delim+"OVERWRITE"+delim+
                       "A"+delim+"AUDIOWARN"+delim+
                       "P"+delim+"NOMAKEPATH"+delim+
                       "R"+delim+"RENAME"+delim+
                       "M"+delim+

                       "MOVE"+delim+"MV"+delim+

                       "MM"+delim+
                       "N"+delim+"NEWER"+delim+
                       "ON"+delim+"NO"+delim+
                       "OON"+delim+"NOO"+delim+
                       "V"+delim+"VERBOSE"+delim+
                       "PP"+delim+"PR"+delim+
                       "@"+delim+"FILELIST"+delim+
                       "I"+delim+"QUERY"+delim+"INTERACTIVE"+delim+"ASK"+delim+

                       "COPY"+delim+

                       "IO"+delim+"II"+delim+
                       "K"+delim+"KEEP"+delim+"ATTRIBUTES"+delim+
                       "S"+delim+"RECURSE"+delim+
                       "SP"+delim+"SS"+delim+
                       "Y"+delim+"T-"+delim+"DOIT"+delim+
                       "OO"+delim+
                       "E"+delim+"ESC"+delim+
                       "X"+delim+"IGNOREINI"+delim+
                       "W"+delim+"NOTICE"+delim+"REMIND"+delim+
                       "U"+delim+"UPDATE"+delim+  (* successes *)
                       "MO"+delim+
                       "MON"+delim+
                       "MOO"+delim+
                       "MOON"+delim+
                       "!"+delim+"JOKERS"+delim+"OS"+delim+
                       "??"+delim+
                       "D:"+delim+"BYDATE:"+delim+
                       "Z:"+delim+"BYSIZE:"+delim+
                       "F"+delim+"FRESHEN"+delim+

                       "XX"+delim+ (* obsolete but left as a mere alias for -x *)

                       "VV"+delim+
                       "FN"+delim+"NF"+delim+
                       "B"+delim+"BEEP"+delim+
                       "CP"+delim+"KOPY"+delim+
                       "XCP"+delim+
                       "SF"+delim+"SWAPS"+delim+"SWAPFILES"+delim+
                       "G"+delim+"PERCENTAGE"+delim+
                       "MEM"+delim+"FAKE"+delim+
                       "J"+delim+"NEWERORSAME"+delim+"SAMEORNEWER"+delim+
                       "???"+delim+
                       "RR"+delim+
                       "PRR"+delim+"PPP"+delim+
                       "DEBUG"
                              );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5,6:  flagPREVIEW   := TRUE;
            | 7,8:    CASE showmode OF
                      | showboth,showfailure : showmode:=showfailure;
                      ELSE
                          abort(errNonsenseShow,"");
                      END;
            | 9,10:   useLFN        := FALSE;
            |11,12:   flagOVERWRITE := TRUE;
            |13,14:   flagAUDIOWHENDONE:= TRUE;
            |15,16:   flagMAKEPATH  := FALSE;
            |17,18:   flagAUTORENAME:= TRUE; renfix:=renfixdefault;
            |19:      flagMOVE      := TRUE;

            |20,21:   flagMOVE      := TRUE;
                      flagASKUSER   := TRUE; flagOVERWRITE:=TRUE;
                      (* flagMAKEPATH:=FALSE; *)

            |22:      flagMOVE      := TRUE; flagROSOURCE:=TRUE;
            |23,24:   flagSKIPNEWER := TRUE;
            |25,26:   flagSKIPNEWER := TRUE;
            |27,28:   flagSKIPNEWER := TRUE; flagRO:=TRUE;
            |29,30:   flagVERBOSE   := TRUE;
            |31,32:   flagMAKEPATH  := FALSE; flagAUTORENAME:=TRUE; renfix:=renfixdefault;
            |33,34:   flagLISTMODE  := TRUE;
            |35,36,37,38:flagASKUSER:= TRUE;

            |39:      flagASKUSER   := TRUE; flagOVERWRITE:=TRUE;
                      flagMAKEPATH:=FALSE;

            |40,41:   flagASKUSER   := TRUE; flagOVERWRITE:=TRUE;
            |42,43,44:flagATTR      := TRUE;
            |45,46:   flagRECURSE   := TRUE;
            |47,48:   flagRECURSE   := TRUE; flagMAKEPATH := FALSE;
            |49,50,51:flagPREVIEW   := FALSE;
            |52   :   flagOVERWRITE := TRUE; flagRO:=TRUE;
            |53,54:   flagIGNOREESC := TRUE;
            |55,56:   flagIGNOREINI := TRUE;
            |57,58,59:flagNOTICE    := TRUE;
            |60,61:   CASE showmode OF
                      | showboth,showsuccess : showmode:=showsuccess;
                      ELSE
                          abort(errNonsenseShow,"");
                      END;
            |62:      flagMOVE:=TRUE; flagOVERWRITE:=TRUE;
            |63:      flagMOVE:=TRUE; flagSKIPNEWER:=TRUE;
            |64:      flagMOVE:=TRUE; flagOVERWRITE := TRUE; flagRO:=TRUE;
            |65:      flagMOVE:=TRUE; flagRO:=TRUE; flagSKIPNEWER:=TRUE;
            |66,67,68:flagOSjokers  := TRUE;
            |69:      abort(errMoreHelp,"");
            |70,71:   ok:=parseDateRange(R,lodate,hidate);
                      IF ok=FALSE THEN abort(errDateRange,S);END;
                      flagDATErange := TRUE;
            |72,73:   ok:=parseSizeRange(R,losize,hisize);
                      IF ok=FALSE THEN abort(errSizeRange,S);END;
                      flagSIZErange := TRUE;
            |74,75:   flagFRESHEN   := TRUE;

            |76:      flagIGNOREINI := TRUE;

            |77:      flagVERBOSE   := TRUE; flagVERBOSEBYE:=TRUE;
            |78,79:   flagFRESHEN   := TRUE;
                      flagSKIPNEWER := TRUE;
            |80,81:   flagERRBEEP   := FALSE;
            |82,83:   flagMAKEPATH  := FALSE; flagSKIPNEWER:=TRUE;
            |84:      flagSKIPNEWER := TRUE;  flagRECURSE := TRUE;
            |85,86,87:flagFORCESWAPFILESPROTECTION:=FALSE;
            |88,89:   flagPERCENTAGE:= FALSE;
            |90,91:   FAKEOKSTORAGE  := TRUE;
            |92,93,94:flagSKIPNEWERORSAME := TRUE;
            |95:      abort(errEvenMoreHelp,"");
            |96:      flagAUTORENAME:= TRUE; renfix:=renfixLFN;
            |97,98:   flagMAKEPATH  := FALSE; flagAUTORENAME:=TRUE; renfix:=renfixLFN;

            |99:      DEBUG         := TRUE; (* for later use *)
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errTooManyParms,S);END;
            Str.Copy(parm[lastparm],S); (* keep case *)
        END;
    END;

    IF flagSKIPNEWER THEN flagOVERWRITE:=TRUE; END; (* v1.2 default *)

    IF (flagSKIPNEWER AND NOT(flagOVERWRITE) ) THEN abort(errNonsenseStamp,"");END; (* v1.2 makes this check useless *)

    IF (flagSKIPNEWER AND flagAUTORENAME) THEN abort(errNonsense,"-n[o[o]]");END; (* v1.2q *)
    IF (flagOVERWRITE AND flagAUTORENAME) THEN abort(errNonsense,"-o[o]");END;
    IF (flagPREVIEW   AND flagAUTORENAME) THEN abort(errNonsense,"-t");END;

    IF flagSKIPNEWERORSAME THEN
        IF NOT(flagSKIPNEWER) THEN abort(errRequiredOption,"-n");END;
    END;

    useLFN:=( useLFN AND w9XsupportLFN() );
    IF useLFN=FALSE THEN
        FOR i:=firstparm TO lastparm DO
            UpperCase( parm[i] );
        END;
    END;

    IF useLFN=FALSE THEN
        IF renfix # renfixdefault THEN abort(errRenFixLFN,"");END;
    END;

    (* anchor *)
    getAnchor(useLFN, currdrive,currdir, currpath); (* u, "\*\", "u:\*\" *)

    (* don't care about syntax if we're to just show parms *)

    IF flagVERBOSEBYE THEN
        IF initProtected (lastEntryProtected,
                         flagIGNOREINI,flagFORCESWAPFILESPROTECTION,useLFN,DEBUG)=FALSE THEN
            abort(errProtection,"");
        END;

        showParms ( flagVERBOSEBYE,  useLFN,
                    flagLISTMODE,flagRECURSE,flagOVERWRITE,flagRO,
                    flagSKIPNEWER,flagSKIPNEWERORSAME,
                    flagFRESHEN,flagATTR,flagAUTORENAME,
                    flagMOVE,flagROSOURCE,flagPREVIEW,flagERRBEEP,flagASKUSER,
                    flagDATErange,flagSIZErange,flagNOTICE,flagPERCENTAGE,
                    flagIGNOREESC,flagOSjokers,
                    flagIGNOREINI,flagFORCESWAPFILESPROTECTION,
                    flagAUDIOWHENDONE,FAKEOKSTORAGE,
                    renfix,buildMethod, lodate,hidate,
                    losize,hisize,
                    showmode,
                    listfile,specbase,spec,targetbase,currpath
                  );
        abort(errNone,"");
    END;

    (* ok, here, we must check user did not goof *)

    CASE lastparm OF
    | firstparm-1:
        abort(errMissingSource,"");
    | firstparm:
        Str.Copy(basedir,currpath);
    | maxparm:
        Str.Copy(basedir,parm[lastparm]);
        IF chkJoker(basedir) THEN abort(errJokerTarget,basedir);END;
        rc:= preprocessDir(basedir, useLFN,currpath);
        IF rc # errNone THEN abort(rc,basedir);END;
    END;

    Str.Copy(S,parm[firstparm]);
    IF S[0]="@" THEN
        Str.Delete(S,0,1);
        flagLISTMODE:=TRUE;
    END;

    getAllLegalUnits(TRUE,TRUE,TRUE,sLegalUnits); (* floppy,hd,CDROM *)
    getAllLegalUnits(TRUE,TRUE,FALSE,sLegalTargetUnits); (* floppy,hd,CDROM *)

    IF flagLISTMODE THEN
        IF flagRECURSE THEN abort(errNotWithList,"-s");END;

        Str.Copy(listfile,S);
        IF chkJoker(listfile) THEN abort(errJokerList,listfile);END;
        IF Str.CharPos(listfile,dot)=MAX(CARDINAL) THEN Str.Append(listfile,extLST);END;
        IF fileIsDirectorySpec(useLFN,listfile) THEN abort(errNotFile,listfile);END;
        IF fileExists(useLFN,listfile)=FALSE THEN abort(errNotFound,listfile);END;

        rc:= chkfixSpec( targetbase,targetspec,  useLFN,basedir,sLegalTargetUnits );
        IF rc # errNone THEN abort(rc,basedir);END;

        IF flagMAKEPATH THEN
            buildMethod:=buildKeepPath; (* keep paths from list entries *)
        ELSE
            buildMethod:=buildKeepName; (* don't recreate paths *)
        END;
    ELSE
        Str.Copy(orgspec,S);

        rc:= chkfixSpec( specbase,spec,  useLFN,orgspec,sLegalUnits );
        IF rc # errNone THEN abort(rc,orgspec);END;

        rc:= chkfixSpec( targetbase,targetspec,  useLFN,basedir,sLegalTargetUnits );
        IF rc # errNone THEN abort(rc,basedir);END;

        (* quick check before individual handling infra *)
        IF chkBothSpecsForCollision(specbase,"",targetbase,"")=FALSE THEN
            IF flagMAKEPATH THEN abort(errDirCollision,""); END;
        END;

        IF flagRECURSE THEN
            IF flagMAKEPATH THEN
                buildMethod:=buildXcopy; (* remove root base of source *)
            ELSE
                buildMethod:=buildKeepName; (* /p was specified *)
            END;
        ELSE
            flagMAKEPATH := FALSE; (* /p always forced for smarter COPY mode *)
            buildMethod  := buildKeepName; (* COPY = don't recreate paths *)
        END;
    END;

    targetbasecooked:=targetbase;
    UpperCaseAlt(targetbasecooked); (* for chkCollision() *)

    IF initProtected (lastEntryProtected,
                     flagIGNOREINI,flagFORCESWAPFILESPROTECTION,useLFN,DEBUG)=FALSE THEN
        abort(errProtection,"");
    END;

    (* let's warm up now *)

    IF flagVERBOSE THEN
        showParms ( flagVERBOSEBYE,  useLFN,
                    flagLISTMODE,flagRECURSE,flagOVERWRITE,flagRO,
                    flagSKIPNEWER,flagSKIPNEWERORSAME,
                    flagFRESHEN,flagATTR,flagAUTORENAME,
                    flagMOVE,flagROSOURCE,flagPREVIEW,flagERRBEEP,flagASKUSER,
                    flagDATErange,flagSIZErange,flagNOTICE,flagPERCENTAGE,
                    flagIGNOREESC,flagOSjokers,
                    flagIGNOREINI,flagFORCESWAPFILESPROTECTION,
                    flagAUDIOWHENDONE,FAKEOKSTORAGE,
                    renfix,buildMethod, lodate,hidate,
                    losize,hisize,
                    showmode,
                    listfile,specbase,spec,targetbase,currpath
                   );
        WrLn;
    END;

    (* go ! go ! GO ! *)

    IF flagPREVIEW THEN
        msgPrefix := sPREVIEW; (* reminder *)
    ELSE
        msgPrefix := sPREFIX;      (* was "" but "    " seems prettier *)
    END;

    redirected:=IsRedirected();
    IF redirected THEN showmode:=showboth; END; (* ignore -q and -u *)

    CASE showmode OF
    | showsuccess,showfailure: showbusy:=NOT(redirected);
    | showboth:                showbusy:=redirected;
    END;

    IF DEBUG THEN showbusy:=FALSE; END;

    busy(showbusy,TRUE); (* must be called before any abort() within this section *)

    chkrounds := 0;
    flagABORT:=FALSE; (* in case we'd exit before first check ! *)

    initList(diranchor); (* global *)
    lastdir            := firstindex-1; (* we can't init count in recursive buildDirList() *)
    lastdirReal        := firstindex-1; (* fix "no match" reason *)
    globallastfile     := firstindex-1;
    globallastfileReal := firstindex-1;

    IF flagLISTMODE THEN (* read entries to RAM with an empty base *)
        rc:= fakeDirList (lastdir,lastdirReal,diranchor);

        fixStorageError (rc,IGNOREDSTORAGEPB,  FAKEOKSTORAGE);

        IF rc # errNone THEN busy(showbusy,FALSE);abort(rc, listfile); END;

        initList(fileanchor);
        lastfile     := firstindex-1;
        lastfileReal := firstindex-1;

        hin:=fileOpenRead(useLFN,listfile);
        FIO.AssignBuffer(hin,ioBufferIn);
        LOOP
            IF FIO.EOF THEN EXIT; END;
            FIO.RdStr(hin,S);
            IF FIO.EOF THEN EXIT; END;
            preprocessLine(S);
            CASE S[0] OF
            | CHR(0), semicolon,pound :
                ;
            ELSE
                rc:=fakeAddFile (globallastfile,globallastfileReal,
                                lastfile,lastfileReal, fileanchor,
                                showbusy,flagNOTICE,S);

                fixStorageError (rc,IGNOREDSTORAGEPB,  FAKEOKSTORAGE);

                IF rc # errNone THEN busy(showbusy,FALSE);abort(rc, listfile); END;
            END;
        END;
        FIO.Close(hin);

    ELSE
        rc:= buildDirList (lastdir,lastdirReal, diranchor,
                          useLFN,flagRECURSE,showbusy,flagNOTICE, specbase);

        fixStorageError (rc,IGNOREDSTORAGEPB,  FAKEOKSTORAGE);

        IF rc # errNone THEN busy(showbusy,FALSE);abort(rc, orgspec); END;
    END;

    IF DEBUG THEN
        dmpDirs(diranchor,useLFN);
        (* dmpDirsAlt(diranchor,lastdir,useLFN); *)
    END;

    (* first minimalist "no match" check *)

    IF lastdir < firstindex THEN abort(errFileNotFound,orgspec);END;

    (* let's work now *)

    keepStats (successes,warnings, INITSTATS);

    initXCOPYtarget(XCOPYrootspec, buildMethod,specbase);

    dirindex:=firstindex; (* with flagLISTMODE, lastdir = firstindex *)
    LOOP
        IF dirindex > lastdir THEN EXIT; END;
        pdir:=findByIndex(dirindex,diranchor);
        getStr(base,pdir);

        IF NOT(flagLISTMODE) THEN
            rc:= storeFiles (globallastfile,globallastfileReal,
                            lastfile,lastfileReal,
                            fileanchor,
                            useLFN,showbusy, flagNOTICE,flagOSjokers,
                            flagSIZErange,flagDATErange,
                            losize,hisize,lodate,hidate,
                            maskfilter, base,spec);

            fixStorageError (rc,IGNOREDSTORAGEPB,  FAKEOKSTORAGE);

            IF rc # errNone THEN busy(showbusy,FALSE);abort(rc, orgspec); END;
        END;

        IF DEBUG THEN
           dmpFiles(fileanchor,diranchor,dirindex,useLFN);
           (* dmpFilesAlt(fileanchor,diranchor,lastfile,dirindex,useLFN); *)
        END;

        fileindex:=firstindex;
        LOOP
            IF fileindex > lastfile THEN EXIT; END;
            pf := findByIndex(fileindex,fileanchor);
            getStr(S,pf);

            Str.Prepend(S,base);

            pb:=pbNone;
            IF chkJoker(S) THEN (* can only happen with an entry from a filelist *)
                pb:=pbJoker;
            ELSE
                IF fileExists(useLFN,S) THEN
                    buildtarget(R, buildMethod,targetbase,S,XCOPYrootspec); (* basedir was... stupid at best ! *)

                    kilroy:=fileExists(useLFN,R);
                    IF kilroy THEN
                        md:=FALSE; (* no need to recreate existing target *)
                        collisionRisk := chkCollision(DEBUG,S,R,targetbase);
                    ELSE
                        md:=NOT(flagFRESHEN); (* no file to freshen, so don't recreate target path *)
                        collisionRisk := FALSE;
                    END;
                    IF (md AND (collisionRisk=FALSE)) THEN
                        handleTargetDir(useLFN,flagPREVIEW,currdrive,currdir,R);
                    END;

                    doit:=FALSE; (* default *)
                    IF (kilroy AND (collisionRisk=FALSE)) THEN
                        IF flagOVERWRITE THEN
                            IF fileIsRO(useLFN,R) THEN
                                IF flagRO THEN
                                    IF flagSKIPNEWER THEN
                                        (* IF getPackedFileStamp(useLFN,R) < getPackedFileStamp(useLFN,S) THEN *)
                                        IF chkStamp(flagSKIPNEWERORSAME,useLFN,R,S) THEN
                                            fileSetRW(useLFN,R);
                                            doit:=TRUE;
                                        ELSE
                                            pb:=getcodePBstamp(flagSKIPNEWERORSAME,pbTargetNewer,pbTargetNewerOrSame);
                                        END;
                                    ELSE
                                        fileSetRW(useLFN,R);
                                        doit:=TRUE;
                                    END;
                                ELSE
                                    pb:=pbTargetRO;
                                END;
                            ELSE
                                IF flagSKIPNEWER THEN
                                    (* IF getPackedFileStamp(useLFN,R) < getPackedFileStamp(useLFN,S) THEN *)
                                    IF chkStamp(flagSKIPNEWERORSAME,useLFN,R,S) THEN
                                        doit:=TRUE;
                                    ELSE
                                        pb:=getcodePBstamp(flagSKIPNEWERORSAME,pbTargetNewer,pbTargetNewerOrSame);
                                    END;
                                ELSE
                                    doit:=TRUE;
                                END;
                            END;
                        ELSE
                            IF flagAUTORENAME THEN
                                Str.Copy(orgR,R);
                                IF buildnewname(useLFN,DEBUG,renfix,R)=FALSE THEN
                                    pb:=pbRenameFailure;
                                ELSE
                                    pb:=pbRenamed; (* well, not a problem... *)
                                    doit:=TRUE;

                                    kilroy:=FALSE; (* never query user here *)

                                END;
                            ELSE
                                pb:=pbTargetExists;
                            END;
                        END;
                    ELSE
                        IF flagFRESHEN THEN
                            doit:= FALSE;
                            pb  := pbFreshen;
                        ELSE
                            doit:= TRUE;
                            (* pbNone is default *)
                        END;
                    END;

                    (* v1.0m check must change doit here *)

                    IF collisionRisk THEN
                        doit:=FALSE;
                        pb:=pbCollision;
                    END;

                    IF doit THEN

                        doFileCopy (flagROOM,flagABORT,flagASKUSER,flagDONTSHOWCOZUSERDENIED,
                                   flagATTR,showbusy,kilroy,useLFN,
                                   flagPREVIEW,flagERRBEEP,flagPERCENTAGE,DEBUG,
                                   S,R);
                        IF flagROOM THEN (* ignore possible flagABORT so we can inform user of problem *)
                            IF flagMOVE THEN
                                flagMOVE:= FALSE;
                                pb:=pbRoomMove;
                            ELSE
                                pb:=pbRoomCopy;
                            END;
                        ELSE
                            IF flagABORT THEN EXIT;END;
                        END;

                        IF flagMOVE THEN
                            doit:=FALSE; (* default -- pbNone too *)
                            IF NOT( flagDONTSHOWCOZUSERDENIED ) THEN
                                IF fileIsRO(useLFN,S) THEN
                                    IF flagROSOURCE THEN
                                        fileSetRW(useLFN,S);
                                        pb:=pbMovedRO; (* bis... *)
                                        doit:=TRUE;
                                    ELSE
                                        pb:=pbSourceRO;
                                    END;
                                ELSE
                                    pb:=pbMoved; (* ter... *)
                                    doit:=TRUE;
                                END;
                                IF doit THEN
                                    IF NOT(flagPREVIEW) THEN fileErase(useLFN,S);END;
                                END;
                            END;
                        END;
                    END;
                ELSE
                    pb:=pbNotFound;
                END;
            END;

            (* S=source, R=target, orgR=original target if pbRenameFailure *)

            (* //FIXME if user was queried and replied no
            (i.e. flagDONTSHOWCOZUSERDENIED=TRUE),
            we should not display anything
            fake no problem is user answered no : after all, file WAS processed
            *)

            aboutProblem( pb, isSuccess,msg);
            (* we could just check msg for placeholder existence *)
            CASE pb OF
            | pbRenamed,pbMoved,pbMovedRO : Str.Subst(msg, pathplaceholder,R);
            END;
            keepStats(successes,warnings, pb);

            IF NOT ( flagDONTSHOWCOZUSERDENIED ) THEN
                CASE showmode OF
                | showboth:
                    busy(showbusy,FALSE);
                    wrfi(useLFN,msgPrefix,S);  (* source *)
                    IF pb=pbNone THEN
                        wrfi(useLFN,sOKDONE,R); (* target *)
                    ELSE
                        WrStr(msg);WrLn;  (* failure or info *)
                    END;
                    busy(showbusy,TRUE);
                | showsuccess:
                    IF isSuccess THEN
                        busy(showbusy,FALSE);
                        IF pb=pbNone THEN
                            wrfi(useLFN,sOKDONE,R); (* target *)
                        ELSE
                            wrfi(useLFN,msgPrefix,S);  (* source *)
                            WrStr(msg);WrLn;  (* failure or info *)
                        END;
                        busy(showbusy,TRUE);
                    END;
                | showfailure:
                    IF NOT(isSuccess) THEN
                        IF pb # pbNone THEN
                            busy(showbusy,FALSE);
                            wrfi(useLFN,msgPrefix,S);  (* source *)
                            WrStr(msg);WrLn;  (* failure or info *)
                            busy(showbusy,TRUE);
                        END;
                    END;
                END;
            END;

            INC(fileindex);

            flagABORT:=pollEscape(chkrounds,useLFN,flagIGNOREESC);
            IF flagABORT THEN EXIT; END;
        END;

        freeList(fileanchor);
        INC(dirindex);

        IF flagABORT THEN EXIT; END;
    END;

    (* final cleanup *)

    freeList(diranchor);

    busy(showbusy,FALSE);

    (*
    //FIXME : no match either means REAL no match, or protected source
    we could do as DD and silently hide it : this IS the M$ code kiddy Way
    anyway, a Q&D kludge will tell us the Truth...
    *)
(*
msg:= nl+"lastdir= ~  realdirs= ~   lastfile= ~  realfiles= ~"+nl;
    Str.Subst(msg,"~",fmt(lastdir,10,4," ",""));
    Str.Subst(msg,"~",fmt(lastdirReal,10,4," ",""));
    Str.Subst(msg,"~",fmtlc(globallastfile,10,4," ",""));
    Str.Subst(msg,"~",fmtlc(globallastfileReal,10,4," ",""));
WrStr(msg);
*)

    IF globallastfile < firstindex THEN
        IF lastdir = lastdirReal THEN
            IF globallastfileReal < firstindex THEN
                (* ok, this looks like a real "no match" *)
                IF (flagDATErange OR flagSIZErange) THEN
                    abort(errFilteredFileNotFound,orgspec);
                ELSE
                    abort(errFileNotFound,orgspec);
                END;
            END;
        END;
    END;

    IF flagABORT THEN abort(errUserAbort,""); END;
    IF flagAUDIOWHENDONE THEN alert();END;

    (* final report *)

    Str.Copy(msg,msgDone);
    Str.Subst(msg,"~",fmtlc(successes,10,1," ",""));
    Str.Subst(msg,"~",fmtlc(warnings,10,1," ",""));
    WrStr(msg);WrLn;

    IF warnings # 0 THEN
        i:= errNoneAlt; (* freespace pbs, etc. *)
    ELSE
        i:= errNone;
    END;

    IF IGNOREDSTORAGEPB # 0 THEN
       WrStr("--- Storage.ALLOCATE() failure errors did happen and were ignored !");WrLn;
    END;

    abort(i,"");
END pCopy.





(*

// check "no match"

386spart.par
win386.swp
pagefile.sys
c:\bat\vital
*.exe

C:\MODULA>pcopy c:\bat\ c:\z
lastdir=    1  realdirs=    1   lastfile=  256  realfiles=  328

C:\MODULA>pcopy c:\bat\ /s c:\z
lastdir=    9  realdirs=   10   lastfile=  360  realfiles=  502

C:\MODULA>pcopy c:\bat\vital\*.* c:\z /s
lastdir=    1  realdirs=    2   lastfile=    2  realfiles=    4


C:\MODULA>pcopy c:\bat\*.X c:\z
lastdir=    1  realdirs=    1   lastfile=    0  realfiles=    0 FNF

C:\MODULA>pcopy c:\foobar\ c:\z
lastdir=    1  realdirs=    1   lastfile=    0  realfiles=    0 FNF

C:\MODULA>pcopy c:\foobar\*.X c:\z
lastdir=    1  realdirs=    1   lastfile=    0  realfiles=    0 FNF

C:\MODULA>pcopy c:\bat\*.Exe c:\z
lastdir=    1  realdirs=    1   lastfile=    0  realfiles=   72 FNF//


C:\MODULA>pcopy c:\bat\vital\*.* c:\z
lastdir=    0  realdirs=    1   lastfile=    0  realfiles=    0 FNF//

C:\MODULA>pcopy c:\bat\*.Exe /s c:\z
lastdir=    9  realdirs=   10   lastfile=    0  realfiles=  142 FNF//

C:\MODULA>pcopy c:\bat\vital\*.Exe c:\z /s
lastdir=    1  realdirs=    2   lastfile=    0  realfiles=    2 FNF//

C:\MODULA>pcopy c:\bat\vital\*.Exe c:\z
lastdir=    0  realdirs=    1   lastfile=    0  realfiles=    0 FNF//

C:\MODULA>pcopy c:\bat\vital\*.X c:\z
lastdir=    0  realdirs=    1   lastfile=    0  realfiles=    0 FNF//

*)
