(* ---------------------------------------------------------------
Title         Q&D pushdir
Author        PhG
Overview      push current directory
Usage         see help
Notes         assume TMP environment variable refers to an existing directory !
Bugs
Wish List     LFN support ? ah ah, only serious !

--------------------------------------------------------------- *)

MODULE PushDir;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT IO;
IMPORT DOSErr;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows, cleantabs,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
unfixDirectory;

(* ------------------------------------------------------------ *)

CONST
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;
CONST
    ProgEXEname   = "PUSHDIR";
    ProgTitle     = "Q&D Push Directory";
    ProgVersion   = "v1.0c";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    popname       = "~POPDIR.TMP";
    varPUSHPOP    = "PUSHPOP";
    varTMP        = "TMP";
    varTEMP       = "TEMP";
    varTMPDIR     = "TMPDIR";
    varTEMPDIR    = "TEMPDIR";
    vars          = varPUSHPOP+delim+
                    varTMP+delim+
                    varTEMP+delim+
                    varTMPDIR+delim+
                    varTEMPDIR;
    varlist       = varPUSHPOP+", "+
                    varTMP+", "+
                    varTEMP+", "+
                    varTMPDIR+" or "+
                    varTEMPDIR;
CONST
    firstDir    = 1;
    maxDir      = 100;
    strMaxDirs  = "100";

(* ------------------------------------------------------------ *)

CONST
    errNone             = 0;
    errHelp             = 1;
    errUnknownOption    = 2;
    errUselessParm      = 3;
    errVarTMP           = 4;
    errSyntax           = 5;
    errJokers           = 6;
    errStackOverflow    = 7;
    errEmptyStack       = 8;
    errNonsense         = 9;
    errNonsenseToo      = 10;
    errCHDIR            = 255;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
nl+
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" [path] [-list|-zero]"+nl+
nl+
"This program saves current drive and directory,"+nl+
"then it tries and changes to optional path (if specified),"+nl+
"returning 255 error code if operation was not possible for any reason."+nl+
nl+
popname+" companion data file will be located in directory"+nl+
"specified by any of the following environment variables :"+nl+
varlist+" (in that order)."+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errUnknownOption :
        Str.Concat(S,"Unknown ",einfo); Str.Append(S," option !");
    | errUselessParm :
        Str.Concat(S,"Uneeded ",einfo); Str.Append(S," parameter !");
    | errVarTMP:
        S := "Missing "+varlist+" environment variable !";
    | errSyntax:
        S := 'Syntax is "'+ProgEXEname+' [path]" !';
    | errJokers:
        Str.Concat(S,einfo," should not contain any joker !");
    | errStackOverflow:
        S := "Too many directories pushed on stack while limit is "+strMaxDirs+" !";
    | errEmptyStack:
        S := "No directory pushed on stack !";
    | errCHDIR:
        S := ""; (* won't be seen anyway *)
    | errNonsense :
        S := "-l and -z options are mutually exclusive !";
    | errNonsenseToo:
        S := "[path] parameter and -z option are mutually exclusive !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp,errCHDIR :
        ;(* nada *)
    ELSE
        WrLn; (* here *)
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE chkVarTMP (dbg:BOOLEAN; VAR R:ARRAY OF CHAR) : BOOLEAN;
VAR
    i:CARDINAL;
    varname,u,d,n,e:str128;
    rc:BOOLEAN;
BEGIN
    rc:= FALSE;
    i := 0;
    LOOP
        isoleItemS(varname,vars,delim,i);
        IF same(varname,"") THEN EXIT; END;
        Lib.EnvironmentFind(varname,R);
        IF dbg THEN WrStr(varname);WrStr(" = ");WrStr(R);WrLn;END;
        IF same(R,".") THEN
            Lib.ParamStr(R,0);
            Lib.SplitAllPath(R,u,d,n,e);
            Lib.MakeAllPath(R,u,d,"","");
            IF dbg THEN WrStr(varname);WrStr(" = ");WrStr(R);WrLn;END;
            rc:=TRUE;
            EXIT;
        END;
        IF same(R,"")=FALSE THEN
            rc:=TRUE;
            EXIT;
        END;
        INC(i);
    END;
    RETURN rc;
END chkVarTMP;

(* ------------------------------------------------------------ *)

(* from C2.MOD *)

PROCEDURE enhancedUnfixDirectory (VAR S : ARRAY OF CHAR);
VAR
    u,d,n,e:str128; (* "u:" "\*\" "" "" *)
BEGIN
    Lib.SplitAllPath(S,u,d,n,e);
    IF same(d,"\") THEN RETURN;END;
    (* we're not trying to go to root, so remove possible trailing "\" *)
    unfixDirectory(S);
END enhancedUnfixDirectory;

(* ------------------------------------------------------------ *)

CONST
    IObufferSize= (8 * 512) + FIO.BufferOverhead;
VAR
    IObuffer : ARRAY [1..IObufferSize] OF BYTE;
VAR
    i, parmcount, opt : CARDINAL;
    S,R               : str128;
    tmpdir,stackfile  : str128;
    u                 : SHORTCARD; (* current unit to save *)
    drive             : CHAR; (* current drive to save *)
    here,cdhere       : str128;
    hnd               : FIO.File;
    state             : (waiting,gotpath);
    zerolist,showlist,DEBUG,rc : BOOLEAN;
    ndx:CARDINAL;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    (* WrLn; *)

    showlist:=FALSE;
    zerolist:=FALSE;
    DEBUG := FALSE;

    state:=waiting;
    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "L"+delim+"LIST"+delim+
                                  "Z"+delim+"ZERO"+delim+
                                  "DEBUG"
                              );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5:
                showlist:=TRUE;
            | 6,7 :
                zerolist:=TRUE;
            | 8 :
                DEBUG := TRUE;
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            CASE state OF
            | waiting:
                Str.Copy(cdhere,S);
                IF chkJoker(cdhere) THEN abort(errJokers,cdhere);END;

            | gotpath:
                abort(errSyntax,""); (* was UselessParm,S *)
            END;
            INC(state);
        END;
    END;
    IF zerolist THEN
        IF showlist THEN abort(errNonsense,"");END;
        IF state=gotpath THEN abort(errNonsenseToo,"");END;
    END;

    IF (showlist OR DEBUG) THEN WrLn;END;

    IF chkVarTMP(DEBUG,tmpdir)=FALSE THEN abort(errVarTMP,"");END;
    fixDirectory(tmpdir);

    Str.Concat(stackfile,tmpdir,popname);
    Str.Caps(stackfile);
    IF DEBUG THEN WrStr(stackfile);WrLn;END;

    IF zerolist THEN
        IF FIO.Exists(stackfile) THEN
            FIO.Erase(stackfile);
            S:=nl+"::: ~ has been deleted."+nl;
        ELSE
            S:=nl+"::: ~ does not exist."+nl;
        END;
        Str.Subst(S,"~",stackfile);
        WrStr(S);
        abort(errNone,"");
    END;

    u := FIO.GetDrive();             (* 1=A, 2=B, etc. *)
    drive := CHR ( ORD("A")-1+u);
    FIO.GetDir (u,here);             (* no unit and \ at root only *)
    Str.Prepend(here,":");
    Str.Prepend(here,drive); (* now with unit AND : AND \ AND path *)
    IF DEBUG THEN WrStr(here);WrLn;END;

    IF showlist THEN
        hnd := FIO.OpenRead(stackfile);
        FIO.AssignBuffer(hnd,IObuffer);

        ndx := firstDir;
        FIO.EOF := FALSE;   (* just in case *)
        LOOP
            IF FIO.EOF THEN EXIT;END;
            IF ndx > maxDir THEN EXIT; END;
            FIO.RdStr(hnd,S);
            IF S[0] # CHR(0) THEN
                IF (showlist OR DEBUG) THEN IO.WrCard(ndx,3);WrStr(" : ");WrStr(S);WrLn;END;
                INC(ndx);
            END;
        END;
        FIO.Close(hnd);
        IF ndx > maxDir THEN abort(errStackOverflow,"");END;
        DEC(ndx);
        IF ndx < firstDir THEN abort(errEmptyStack,"");END;

        S:=nl+"::: No action was taken because -list option was specified."+nl;
        WrStr(S);
        abort(errNone,"");
    END;

    (* normal operation here, without -list *)

    IF FIO.Exists(stackfile) THEN
        hnd := FIO.Append (stackfile);
    ELSE
        hnd := FIO.Create(stackfile);
    END;
    FIO.AssignBuffer(hnd,IObuffer);
    FIO.WrStr(hnd,here);
    FIO.WrLn(hnd);
    FIO.Flush(hnd);
    FIO.Close(hnd);

    IF state=gotpath THEN
        IF DEBUG THEN WrStr("CD ");WrStr(cdhere);WrLn;END;

        enhancedUnfixDirectory(S); (* FIO.ChDir does not like trailing "\" ! *)
        FIO.ChDir(S);
        rc:=FALSE;
        CASE FIO.IOresult() OF
        | DOSErr.NO_ERROR :
            rc:=TRUE;
        | DOSErr.ERROR_PATH_NOT_FOUND :
            WrStr("Invalid directory specified");WrLn; (* ND7 message *)
        | DOSErr.ERROR_INVALID_DRIVE :
            WrStr("Invalid drive specified");WrLn;
        ELSE
            WrStr("ChDir() unexpected error !");WrLn;
        END;
        IF rc=FALSE THEN abort(errCHDIR,"");END;
    END;

    abort(errNone,"");
END PushDir.
