(* ---------------------------------------------------------------
Title         see help !
Author        who cares ?
Overview      see help !
Usage         see help !
Notes
Bugs

--------------------------------------------------------------- *)

MODULE whatLFN;

IMPORT Lib;
IMPORT Str;

FROM IO IMPORT WrLn,WrStr;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose;

(* ------------------------------------------------------------ *)

CONST
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;
CONST
    progEXEname   = "WHATLFN";
    progTitle     = "Q&D What LFN";
    progVersion   = "v1.0a";
    progCopyright = "by PhG";
    banner        = progTitle+" "+progVersion+" "+progCopyright;
CONST
    errNone             = 0;
    errHelp             = 1;
    errOption           = 2;
    errParm             = 3;
    errExpected         = 4;
    errUnsupportedLFN   = 5;
    errJoker            = 6;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
banner+nl+
nl+
"Syntax : "+progEXEname+" <path>..."+nl+
nl+
"This program shows DOS and LFN forms for specified path(s)."+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errOption :
        Str.Concat(S,"Unknown ",einfo); Str.Append(S," option !");
    | errParm :
        Str.Concat(S,"Uneeded ",einfo); Str.Append(S," parameter !");
    | errExpected:
        Str.Concat(S,"Missing ",einfo); Str.Append(S," parameter !");
    | errUnsupportedLFN:
        S:="This program requires LFN support !";
    | errJoker:
        Str.Concat(S,einfo," should not contain any joker !");
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ; (* nada *)
    ELSE
        WrStr(progEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE fmtbignum (v:LONGCARD; base:CARDINAL;wi:INTEGER; pad:CHAR ):str16;
VAR
    S:str16;
    ok:BOOLEAN;
    i : CARDINAL;
BEGIN
    Str.CardToStr( v, S, base,ok);
    FOR i:=Str.Length(S)+1 TO ABS(wi) DO
         IF wi < 0 THEN
             Str.Append(S,pad);
         ELSE
             Str.Prepend(S,pad);
         END;
    END;
    IF base=16 THEN Str.Lows(S);END;
    RETURN S;
END fmtbignum;

PROCEDURE fmtnum ( v:CARDINAL; base:CARDINAL;wi:INTEGER; pad:CHAR ):str16;
BEGIN
    RETURN fmtbignum( LONGCARD(v),base,wi,pad);
END fmtnum;

(* ------------------------------------------------------------ *)

TYPE
    pathtype = path9X;
CONST
    firstparm = 1;
    maxparm   = 10; (* why... but why not ? *)
VAR
    S,R,shortform,longform : pathtype;
    i,j,opt,parmcount:CARDINAL;
    parm:ARRAY [firstparm..maxparm] OF pathtype;
    lastparm:CARDINAL;
    ok, useLFN, DEBUG : BOOLEAN;
    Z:str16;
BEGIN
    WrLn;

    useLFN     := TRUE;
    DEBUG      := FALSE;

    lastparm := firstparm-1; (* 1.. *)

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "DEBUG"
                              );
            CASE opt OF
            | 1,2,3:    abort(errHelp,"");
            | 4:        DEBUG        :=TRUE;
            ELSE
                abort(errOption,S);
            END;
        ELSE
            INC(lastparm); IF lastparm > maxparm THEN abort(errParm,S);END;
            IF chkJoker(S) THEN abort(errJoker,S);END;
            Str.Copy(parm[lastparm],S); (* keep uppercased parm *)
        END;
    END;

    CASE lastparm OF
    | firstparm-1 : abort(errHelp,""); (* abort(errExpected,"<path>"); *)
    ELSE
        ;
    END;

    useLFN := ( useLFN AND w9XsupportLFN() );
    IF NOT(useLFN) THEN abort(errUnsupportedLFN,"");END;

    FOR j:=firstparm TO lastparm DO
        S:=parm[j];

        S:='DOS ~ "~"';
        shortform:="?";
        ok:=w9XlongToShort(parm[j],i,R);
        IF ok THEN
            Z:="+++";
            shortform:=R;
        ELSE
            Z:="---";
            Str.Concat(R, "Error ",fmtnum(i,10,1,"") );
        END;
        Str.Subst(S,"~",Z);
        Str.Subst(S,"~",R);
        WrStr(S);WrLn;

        S:='LFN ~ "~"';
        longform:="?";
        ok:=w9XshortToLong(parm[j],i,R);
        IF ok THEN
            Z:="+++";
            longform:=R;
        ELSE
            Z:="---";
            Str.Concat(R, "Error ",fmtnum(i,10,1,"") );
        END;
        Str.Subst(S,"~",Z);
        Str.Subst(S,"~",R);
        WrStr(S);WrLn;

        IF j < lastparm THEN WrLn;END;
    END;

    abort(errNone,"");
END whatLFN.

