
(* ---------------------------------------------------------------
Title         Q&D MAC2PC
Author        PhG
Overview      self-explanatory !
Notes         minimal error messages and checking, etc.
Bugs
Wish List	  tsk tsk...

--------------------------------------------------------------- *)

MODULE MAC2PC;

IMPORT IO;
IMPORT FIO;
IMPORT Str;
IMPORT Lib;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString;

FROM FIO IMPORT FIXEDLIBS;

(* ------------------------------------------------------------ *)

TYPE
    CharDef   = RECORD
                Code     : BYTE;
                Flag     : CHAR;
                MapChar  : BYTE;
                MetaChar : BYTE;
                END;
    CharTable = ARRAY [0..255] OF CharDef;

CONST
  TmacTOpc  = CharTable(
    CharDef(000H, "=", 000H,  " "),
    CharDef(001H, "=", 001H,  " "),
    CharDef(002H, "=", 002H,  " "),
    CharDef(003H, "=", 003H,  " "),
    CharDef(004H, "=", 004H,  " "),
    CharDef(005H, "=", 005H,  " "),
    CharDef(006H, "=", 006H,  " "),
    CharDef(007H, "=", 007H,  " "),
    CharDef(008H, "=", 008H,  " "),
    CharDef(009H, "!", 009H,  " "),
    CharDef(00AH, "=", 00AH,  " "),
    CharDef(00BH, "=", 00BH,  " "),
    CharDef(00CH, "=", 00CH,  " "),
    CharDef(00DH, "!", 00DH,  " "),
    CharDef(00EH, "=", 00EH,  " "),
    CharDef(00FH, "=", 00FH,  " "),
    CharDef(010H, "=", 010H,  " "),
    CharDef(011H, "?",  " ",  "X"),
    CharDef(012H, "?",  " ",  "/"),
    CharDef(013H, "?",  " ",  "x"),
    CharDef(014H, "?",  " ",  "@"),
    CharDef(015H, "=", 015H,  " "),
    CharDef(016H, "=", 016H,  " "),
    CharDef(017H, "=", 017H,  " "),
    CharDef(018H, "=", 018H,  " "),
    CharDef(019H, "=", 019H,  " "),
    CharDef(01AH, "=", 01AH,  " "),
    CharDef(01BH, "=", 01BH,  " "),
    CharDef(01CH, "=", 01CH,  " "),
    CharDef(01DH, "=", 01DH,  " "),
    CharDef(01EH, "=", 01EH,  " "),
    CharDef(01FH, "=", 01FH,  " "),
    CharDef(020H, "=",  " ",  " "),
    CharDef(021H, "=",  "!",  " "),
    CharDef(022H, "=",  '"',  " "),
    CharDef(023H, "=",  "#",  " "),
    CharDef(024H, "=",  "$",  " "),
    CharDef(025H, "=",  "%",  " "),
    CharDef(026H, "=",  "&",  " "),
    CharDef(027H, "=",  "'",  " "),
    CharDef(028H, "=",  "(",  " "),
    CharDef(029H, "=",  ")",  " "),
    CharDef(02AH, "=",  "*",  " "),
    CharDef(02BH, "=",  "+",  " "),
    CharDef(02CH, "=",  ",",  " "),
    CharDef(02DH, "=",  "-",  " "),
    CharDef(02EH, "=",  ".",  " "),
    CharDef(02FH, "=",  "/",  " "),
    CharDef(030H, "=",  "0",  " "),
    CharDef(031H, "=",  "1",  " "),
    CharDef(032H, "=",  "2",  " "),
    CharDef(033H, "=",  "3",  " "),
    CharDef(034H, "=",  "4",  " "),
    CharDef(035H, "=",  "5",  " "),
    CharDef(036H, "=",  "6",  " "),
    CharDef(037H, "=",  "7",  " "),
    CharDef(038H, "=",  "8",  " "),
    CharDef(039H, "=",  "9",  " "),
    CharDef(03AH, "=",  ":",  " "),
    CharDef(03BH, "=",  ";",  " "),
    CharDef(03CH, "=",  "<",  " "),
    CharDef(03DH, "=",  "=",  " "),
    CharDef(03EH, "=",  ">",  " "),
    CharDef(03FH, "=",  "?",  " "),
    CharDef(040H, "=",  "@",  " "),
    CharDef(041H, "=",  "A",  " "),
    CharDef(042H, "=",  "B",  " "),
    CharDef(043H, "=",  "C",  " "),
    CharDef(044H, "=",  "D",  " "),
    CharDef(045H, "=",  "E",  " "),
    CharDef(046H, "=",  "F",  " "),
    CharDef(047H, "=",  "G",  " "),
    CharDef(048H, "=",  "H",  " "),
    CharDef(049H, "=",  "I",  " "),
    CharDef(04AH, "=",  "J",  " "),
    CharDef(04BH, "=",  "K",  " "),
    CharDef(04CH, "=",  "L",  " "),
    CharDef(04DH, "=",  "M",  " "),
    CharDef(04EH, "=",  "N",  " "),
    CharDef(04FH, "=",  "O",  " "),
    CharDef(050H, "=",  "P",  " "),
    CharDef(051H, "=",  "Q",  " "),
    CharDef(052H, "=",  "R",  " "),
    CharDef(053H, "=",  "S",  " "),
    CharDef(054H, "=",  "T",  " "),
    CharDef(055H, "=",  "U",  " "),
    CharDef(056H, "=",  "V",  " "),
    CharDef(057H, "=",  "W",  " "),
    CharDef(058H, "=",  "X",  " "),
    CharDef(059H, "=",  "Y",  " "),
    CharDef(05AH, "=",  "Z",  " "),
    CharDef(05BH, "=",  "[",  " "),
    CharDef(05CH, "=",  "\",  " "),
    CharDef(05DH, "=",  "]",  " "),
    CharDef(05EH, "=",  "^",  " "),
    CharDef(05FH, "=",  "_",  " "),
    CharDef(060H, "=",  "`",  " "),
    CharDef(061H, "=",  "a",  " "),
    CharDef(062H, "=",  "b",  " "),
    CharDef(063H, "=",  "c",  " "),
    CharDef(064H, "=",  "d",  " "),
    CharDef(065H, "=",  "e",  " "),
    CharDef(066H, "=",  "f",  " "),
    CharDef(067H, "=",  "g",  " "),
    CharDef(068H, "=",  "h",  " "),
    CharDef(069H, "=",  "i",  " "),
    CharDef(06AH, "=",  "j",  " "),
    CharDef(06BH, "=",  "k",  " "),
    CharDef(06CH, "=",  "l",  " "),
    CharDef(06DH, "=",  "m",  " "),
    CharDef(06EH, "=",  "n",  " "),
    CharDef(06FH, "=",  "o",  " "),
    CharDef(070H, "=",  "p",  " "),
    CharDef(071H, "=",  "q",  " "),
    CharDef(072H, "=",  "r",  " "),
    CharDef(073H, "=",  "s",  " "),
    CharDef(074H, "=",  "t",  " "),
    CharDef(075H, "=",  "u",  " "),
    CharDef(076H, "=",  "v",  " "),
    CharDef(077H, "=",  "w",  " "),
    CharDef(078H, "=",  "x",  " "),
    CharDef(079H, "=",  "y",  " "),
    CharDef(07AH, "=",  "z",  " "),
    CharDef(07BH, "=",  "{",  " "),
    CharDef(07CH, "=",  "|",  " "),
    CharDef(07DH, "=",  "}",  " "),
    CharDef(07EH, "=",  "~",  " "),
    CharDef(07FH, "x",  " ", 0C6H),
    CharDef(080H, "=",  "",  " "),
    CharDef(081H, "=",  "A",  " "),
    CharDef(082H, "=",  "",  " "),
    CharDef(083H, "=",  "",  " "),
    CharDef(084H, "=",  "",  " "),
    CharDef(085H, "=",  "",  " "),
    CharDef(086H, "=",  "",  " "),
    CharDef(087H, "=",  "",  " "),
    CharDef(088H, "=",  "",  " "),
    CharDef(089H, "=",  "",  " "),
    CharDef(08AH, "=",  "",  " "),
    CharDef(08BH, "=",  "a",  " "),
    CharDef(08CH, "=",  "",  " "),
    CharDef(08DH, "=",  "",  " "),
    CharDef(08EH, "=",  "",  " "),
    CharDef(08FH, "=",  "",  " "),
    CharDef(090H, "=",  "",  " "),
    CharDef(091H, "=",  "",  " "),
    CharDef(092H, "=",  "",  " "),
    CharDef(093H, "=",  "",  " "),
    CharDef(094H, "=",  "",  " "),
    CharDef(095H, "=",  "",  " "),
    CharDef(096H, "=",  "",  " "),
    CharDef(097H, "=",  "",  " "),
    CharDef(098H, "=",  "",  " "),
    CharDef(099H, "=",  "",  " "),
    CharDef(09AH, "=",  "",  " "),
    CharDef(09BH, "=",  "o",  " "),
    CharDef(09CH, "=",  "",  " "),
    CharDef(09DH, "=",  "",  " "),
    CharDef(09EH, "=",  "",  " "),
    CharDef(09FH, "=",  "",  " "),
    CharDef(0A0H, "?",  " ",  "^"),
    CharDef(0A1H, "=",  "",  " "),
    CharDef(0A2H, "=",  "",  " "),
    CharDef(0A3H, "=",  "",  " "),
    CharDef(0A4H, "!", 015H, 015H),
    CharDef(0A5H, "=",  "",  " "),
    CharDef(0A6H, "!", 014H, 014H),
    CharDef(0A7H, "=",  "",  ""),
    CharDef(0A8H, "!",  "",  "R"),
    CharDef(0A9H, "!",  "",  "C"),
    CharDef(0AAH, "!",  "",  "T"),
    CharDef(0ABH, "?",  " ",  "'"),
    CharDef(0ACH, "?",  " ",  ":"),
    CharDef(0ADH, "?",  " ",  "#"),
    CharDef(0AEH, "=",  "",  " "),
    CharDef(0AFH, "=",  "O",  ""),
    CharDef(0B0H, "=",  "",  " "),
    CharDef(0B1H, "=",  "",  " "),
    CharDef(0B2H, "=",  "",  " "),
    CharDef(0B3H, "=",  "",  " "),
    CharDef(0B4H, "=",  "",  " "),
    CharDef(0B5H, "=",  "",  " "),
    CharDef(0B6H, "=",  "",  " "),
    CharDef(0B7H, "=",  "",  " "),
    CharDef(0B8H, "=",  "",  ""),
    CharDef(0B9H, "=",  "",  " "),
    CharDef(0BAH, "?",  " ",  ""),
    CharDef(0BBH, "=",  "",  " "),
    CharDef(0BCH, "=",  "",  " "),
    CharDef(0BDH, "=",  "",  " "),
    CharDef(0BEH, "=",  "",  " "),
    CharDef(0BFH, "=",  "o",  "o"),
    CharDef(0C0H, "=",  "",  " "),
    CharDef(0C1H, "=",  "",  " "),
    CharDef(0C2H, "=",  "",  " "),
    CharDef(0C3H, "=",  "",  " "),
    CharDef(0C4H, "=",  "",  " "),
    CharDef(0C5H, "=",  "",  " "),
    CharDef(0C6H, "?",  " ",  ""),
    CharDef(0C7H, "=",  "",  " "),
    CharDef(0C8H, "=",  "",  " "),
    CharDef(0C9H, "?",  " ",  "."),
    CharDef(0CAH, "=",  " ",  "_"),
    CharDef(0CBH, "=",  "A",  " "),
    CharDef(0CCH, "=",  "A",  " "),
    CharDef(0CDH, "=",  "O",  " "),
    CharDef(0CEH, "?",  " ",  ""),
    CharDef(0CFH, "?",  " ",  ""),
    CharDef(0D0H, "=",  "-",  "-"),
    CharDef(0D1H, "!",  "-",  "="),
    CharDef(0D2H, "=",  '"',  "{"),
    CharDef(0D3H, "=",  '"',  "}"),
    CharDef(0D4H, "=",  "'",  "["),
    CharDef(0D5H, "=",  "'",  "]"),
    CharDef(0D6H, "=",  "",  " "),
    CharDef(0D7H, "?",  " ",  ""),
    CharDef(0D8H, "=",  "",  " "),
    CharDef(0D9H, "x",  " ",  " "),
    CharDef(0DAH, "x",  " ",  " "),
    CharDef(0DBH, "x",  " ",  " "),
    CharDef(0DCH, "x",  " ",  " "),
    CharDef(0DDH, "x",  " ",  " "),
    CharDef(0DEH, "x",  " ",  " "),
    CharDef(0DFH, "x",  " ",  " "),
    CharDef(0E0H, "x",  " ",  " "),
    CharDef(0E1H, "x",  " ",  " "),
    CharDef(0E2H, "x",  " ",  " "),
    CharDef(0E3H, "x",  " ",  " "),
    CharDef(0E4H, "x",  " ",  " "),
    CharDef(0E5H, "x",  " ",  " "),
    CharDef(0E6H, "x",  " ",  " "),
    CharDef(0E7H, "x",  " ",  " "),
    CharDef(0E8H, "x",  " ",  " "),
    CharDef(0E9H, "x",  " ",  " "),
    CharDef(0EAH, "x",  " ",  " "),
    CharDef(0EBH, "x",  " ",  " "),
    CharDef(0ECH, "x",  " ",  " "),
    CharDef(0EDH, "x",  " ",  " "),
    CharDef(0EEH, "x",  " ",  " "),
    CharDef(0EFH, "x",  " ",  " "),
    CharDef(0F0H, "x",  " ",  " "),
    CharDef(0F1H, "x",  " ",  " "),
    CharDef(0F2H, "x",  " ",  " "),
    CharDef(0F3H, "x",  " ",  " "),
    CharDef(0F4H, "x",  " ",  " "),
    CharDef(0F5H, "x",  " ",  " "),
    CharDef(0F6H, "x",  " ",  " "),
    CharDef(0F7H, "x",  " ",  " "),
    CharDef(0F8H, "x",  " ",  " "),
    CharDef(0F9H, "x",  " ",  " "),
    CharDef(0FAH, "x",  " ",  " "),
    CharDef(0FBH, "x",  " ",  " "),
    CharDef(0FCH, "x",  " ",  " "),
    CharDef(0FDH, "x",  " ",  " "),
    CharDef(0FEH, "x",  " ",  " "),
    CharDef(0FFH, "x",  " ",  " "));

(* ------------------------------------------------------------ *)

CONST
    IObufferSize  = (8 * 512) + FIO.BufferOverhead;
VAR
    FileNameIn  : str128;
    FileNameOut : str128;
    HandleIn    : FIO.File;
    HandleOut   : FIO.File;
    BufferIn    : ARRAY [1..IObufferSize] OF BYTE;
    BufferOut   : ARRAY [1..IObufferSize] OF BYTE;
VAR
    Ch     : CHAR;
    index  : CARDINAL;
    NewCh  : CHAR; (* sent to output *)
    ChFlag : CHAR;

(* ------------------------------------------------------------ *)

CONST
    ErrHead = "MAC2PC : ";
    ExtIn   = ".MAC";
    ExtOut  = ".ASC";
    Gremlin = 0A8H;       (* inverted question mark in PC ASCII *)
    Illegal = Gremlin;
TYPE
    ErrCode = (ErrAlready,ErrMissing,ErrWildcard,
               ErrAsk,ErrSwitch,ErrSyntax);
CONST
    Errors  = "Output file already exists !|"+
              "Input file does not exist !|"+
              "No wildcard allowed in filename !|"+
              "No input file specified !|"+
              "Unknown option specified !|"+
              "Syntax error !";

    Title   = "Q&D MAC2PC v1.0a by PhG";
    Help    =
"CR|"+
Title+"|"+
"CR|"+
"Syntax : MAC2PC InFile["+ExtIn+"] [-o] [-sp] [-sym]|"+
"CR|"+
"-sp  Section and paragraph symbols are control characters|"+
"     in the PC ASCII set. Use this switch if you want MAC2PC|"+
"     to convert them to control characters in the PC ASCII|"+
"     set (default is converting them to a gremlin).|"+
"-sym Copyright, registered, trade mark and hyphen become|"+
'     "", "", "" and "-". Use this switch as to obtain "\(C)\",|'+
'     "\(R)\", "\TM\" and "\--\".|'+
"CR|"+
'Characters which are illegal or without equivalent become "",|'+
'graphic characters of the PC ASCII set become "+",|'+
"LF are added to CR.|"+
"CR|"+
"Converted file will have "+ExtOut+" extension.|";

PROCEDURE CrLf (  );
BEGIN
    IO.WrLn;
END CrLf;

PROCEDURE Print (S : ARRAY OF CHAR);
BEGIN
    IO.WrStr(S);
END Print;

PROCEDURE PrintCr (S : ARRAY OF CHAR);
BEGIN
    Print(S);
    CrLf;
END PrintCr;

(* ------------------------------------------------------------ *)

PROCEDURE Abort (e : ErrCode);
VAR
    str : str128;
BEGIN
    Str.ItemS(str,Errors,'|',CARDINAL(e));
    Str.Prepend(str,ErrHead);
    CrLf;
    PrintCr (str);
    Lib.SetReturnCode (1);
    HALT;
END Abort;

PROCEDURE AbortHelp;
VAR
    str : str128;
    i   : CARDINAL;
BEGIN
    i := 0;
    LOOP
        Str.ItemS(str,Help,"|",i);
        IF Str.Compare (str,"") = 0 THEN EXIT END;
        IF Str.Compare (str,"CR") = 0 THEN
            CrLf;
        ELSE
            PrintCr (str);
        END;
        INC (i);
    END;
    Lib.SetReturnCode (1);
    HALT;
END AbortHelp;

(* ------------------------------------------------------------ *)

VAR
    FlagOverwrite : BOOLEAN;
    FlagTranspose : BOOLEAN; (* section and paragraph *)
    FlagSymbols   : BOOLEAN;

PROCEDURE SetDefaultFlags;
BEGIN
    FlagOverwrite := FALSE;
    FlagTranspose := FALSE;
    FlagSymbols   := FALSE;
END SetDefaultFlags;

PROCEDURE DoOptionO;
BEGIN
    FlagOverwrite := TRUE;
END DoOptionO;

PROCEDURE DoOptionSP;
BEGIN
    FlagTranspose := TRUE;
END DoOptionSP;

PROCEDURE DoOptionSYM;
BEGIN
    FlagSymbols := TRUE;
END DoOptionSYM;

(* ------------------------------------------------------------ *)

PROCEDURE ParseFlag (VAR parm : ARRAY OF CHAR) : BOOLEAN;
CONST
    MaxFlags  = 11;
    CmdFlags  = "?,-?,/?,-H,/H,-O,/O,-SYM,/SYM,-SP,/SP";
TYPE
    ProcArray = ARRAY [0..MaxFlags-1] OF PROC;
CONST
    Action    = ProcArray (
                AbortHelp,AbortHelp,AbortHelp,
                AbortHelp,AbortHelp,
                DoOptionO,DoOptionO,
                DoOptionSYM,DoOptionSYM,
                DoOptionSP,DoOptionSP);
CONST
    Separator = ",";
VAR
    str : str128;
    i   : CARDINAL;
    op  : PROC;
BEGIN
    i := 0;
    LOOP
        Str.ItemS (str,CmdFlags,Separator,i);
        IF Str.Compare (parm,str) = 0 THEN
            op := Action[i];
            op;
            RETURN TRUE;                        (* action taken ok *)
        END;
        INC (i);
        IF i = MaxFlags THEN
            CASE parm[0] OF
                | "-","/" : Abort (ErrSwitch);  (* bad switch *)
            END;
            RETURN FALSE;                       (* maybe a filename here *)
        END;
    END;
END ParseFlag;

(* ------------------------------------------------------------ *)

PROCEDURE ParseCLI (VAR In : ARRAY OF CHAR);
VAR
    MaxParms : CARDINAL;
    i        : CARDINAL;
    option   : str128;
    legal    : BOOLEAN;
    FileHere : BOOLEAN;
BEGIN
    FileHere := FALSE;
    MaxParms := Lib.ParamCount ();
    IF MaxParms = 0 THEN
        AbortHelp;                              (* no parameter so help *)
    END;
    FOR i := 1 TO MaxParms DO
        Lib.ParamStr (option,i);
        Str.Caps (option);
        legal := ParseFlag (option);
        IF legal = FALSE THEN                   (* maybe a filename here *)
            IF FileHere = FALSE THEN
                Str.Copy (In,option);
                FileHere := TRUE;               (* allow only one filename *)
            ELSE
                Abort (ErrSyntax);
            END;
        END;
    END;
    IF FileHere = FALSE THEN
        Abort (ErrAsk);
    END;
END ParseCLI;

PROCEDURE CheckNames (VAR In  : ARRAY OF CHAR;
                      VAR Out : ARRAY OF CHAR);
VAR
    i : CARDINAL;
BEGIN
    IF Str.Pos (In, "*") <> MAX(CARDINAL) THEN
        Abort (ErrWildcard);
    END;
    IF Str.Pos (In, "?") <> MAX(CARDINAL) THEN
        Abort (ErrWildcard);
    END;
    Str.Copy (Out,In);
    i := Str.CharPos (In,".");
    IF i = MAX(CARDINAL) THEN
        Str.Append (In,ExtIn);                  (* add default extension *)
    ELSE
        Str.Slice (Out,Out,0,i);
    END;
    Str.Append (Out,ExtOut);
    IF NOT FIO.Exists (In) THEN
        Abort (ErrMissing);
    END;
    IF FlagOverwrite = FALSE THEN
        IF FIO.Exists (Out) THEN
            Abort (ErrAlready);
        END;
    END;
END CheckNames;

(* ------------------------------------------------------------ *)

CONST
    TAB            = CHAR (009H);
    LF             = CHAR (00AH); (* no linefeed for MAC ASCII *)
    CR             = CHAR (00DH);
    ParagraphMAC   = CHAR (0A6H);
    SectionMAC     = CHAR (0A4H);
    RegisteredMAC  = CHAR (0A8H);
    CopyrightMAC   = CHAR (0A9H);
    TradeMarkMAC   = CHAR (0AAH);
    HyphenMAC      = CHAR (0D1H);

PROCEDURE DoTranspose;
BEGIN
    IF FlagTranspose = FALSE THEN
        NewCh := CHAR(Gremlin);
    END;
END DoTranspose;

PROCEDURE DoSymbols (S : ARRAY OF CHAR);
BEGIN
    CASE FlagSymbols OF
        | FALSE : FIO.WrChar (HandleOut,NewCh);
        | TRUE  : FIO.WrStr (HandleOut,S);
    END;
END DoSymbols;

(* ------------------------------------------------------------ *)

BEGIN
    SetDefaultFlags;
    ParseCLI (FileNameIn);
    CheckNames (FileNameIn,FileNameOut);
    FIO.IOcheck := FALSE;
    HandleIn := FIO.OpenRead (FileNameIn);
    FIO.AssignBuffer (HandleIn,BufferIn);
    HandleOut := FIO.Create (FileNameOut);
    FIO.AssignBuffer (HandleOut,BufferOut);
    CrLf;
    PrintCr (Title);
    LOOP
        Ch := FIO.RdChar (HandleIn);
        IF FIO.EOF THEN EXIT; END;
        index := ORD (Ch);
        NewCh := CHAR (TmacTOpc[index].MapChar); (* MUST be done HERE *)
        ChFlag := CHAR (TmacTOpc[index].Flag);
            CASE ChFlag OF
                | "=" : FIO.WrChar (HandleOut,NewCh); (* send verbatim *)
                | "?" : NewCh := CHAR(Gremlin);
                        FIO.WrChar (HandleOut,NewCh);
                | "x" : NewCh := CHAR(Illegal);
                        FIO.WrChar (HandleOut,NewCh);
                | "!" : CASE Ch OF
                            | TAB           : FIO.WrChar (HandleOut,NewCh);
                            | CR            : FIO.WrChar (HandleOut,NewCh);
                                              FIO.WrChar (HandleOut,LF);
                            | ParagraphMAC  : DoTranspose;
                                              FIO.WrChar (HandleOut,NewCh);
                            | SectionMAC    : DoTranspose;
                                              FIO.WrChar (HandleOut,NewCh);
                            | RegisteredMAC : DoSymbols ("\(R)\"); (* WRITTEN *)
                            | CopyrightMAC  : DoSymbols ("\(C)\");
                            | TradeMarkMAC  : DoSymbols ("\TM\");
                            | HyphenMAC     : DoSymbols ("\--\");
                        END;
            END;
    END;
    FIO.Flush (HandleOut);
    FIO.Close (HandleOut);
    FIO.Close (HandleIn);
    Lib.SetReturnCode (0);
END MAC2PC.

