(* ---------------------------------------------------------------
Title         see help
Author        PhG
Overview      see help (bis repetita...)
Usage         see help (ter repetita...)
Notes
              possible problem when patching wininit.exe strings :
              if patched strings are smaller than original at $6b2 and $760
              what happens if executable code reads strings sequentially ?
              bah... seems there's no problem

              no eyeandy (would be too slow)
Bugs
Wish List

--------------------------------------------------------------- *)

MODULE PASpeek;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileExistsAlt,
fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose, fileSupportLFN;

(* ------------------------------------------------------------ *)

CONST
    cr          = CHR(13);
    lf          = CHR(10);
    nl          = cr+lf;
    tabul       = CHR(9);
    dquote      = '"';      (* 34 = $22 *)
    dollar      = "$";
    star        = "*";
    equal       = "=";
    colon       = ":";
    blank       = " ";
    gremlin     = CHR(168); (* reversed question mark *)
CONST
    ProgEXEname   = "PASPEEK";
    ProgTitle     = "Q&D Pascal strings finder";
    ProgVersion   = "v1.1a";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    errNone             = 0;
    errHelp             = 1;
    errOption           = 2;
    errParmOverflow     = 3;
    errExpecting        = 4;
    errReading          = 5;
    errJoker            = 6;
    errNotFound         = 7;
    errStrToCard        = 8;
    errStart            = 9;
    errEnd              = 10;
    errRange            = 11;
    errAborted          = 12;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" <file> [<[$]start> <[$]end|L[=][$]length|*>] [option]..."+nl+
nl+
"This program extracts PASCAL counted strings found in <first>..<end> range."+nl+
nl+
"-u    search for Unicode strings (default is to search for ASCII strings)"+nl+
"-v[v] show string address and character count (-vv = alternate format)"+nl+
"-q    show double-quoted strings (default is to show raw strings)"+nl+
"-m    more thorough search mode"+nl+
'-f    replace [0..31,255] with "'+gremlin+'" (except TAB, CR, LF).'+nl+
"-x    disable LFN support even if available"+nl+
nl+
'a) <start> is 0-based ; <end> can be specified as "*" for "end of file".'+nl+
"b) If only <file> parameter is specified, [0..filesize-1] range is assumed."+nl+
'c) Hexadecimal values are prefixed with "$".'+nl+
"d) Length is [1..255] for an ASCII string, [1..65535] for a Unicode string."+nl+
"e) While working, program can be aborted by pressing the Escape key."+nl+
"f) -m option is NOT recommended ; specifying <start> <end> is better an idea."+nl+
nl+
"Examples : "+ProgEXEname+" -v wininit.exe 929 2061"+nl+
"           "+ProgEXEname+" newspeak.exe $989a $bf27"+nl+
"           "+ProgEXEname+" -u vtuner.exe $4a1c0 $4b4ff"+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :        WrStr(helpmsg);
    | errOption :      S:='Unknown "~" option';
    | errParmOverflow: S:='"~" is one parameter too many';
    | errExpecting :   S:="Expecting ~ parameter";
    | errReading:      S:='Unexpected problem reading "~"';
    | errJoker :       S:='"~" cannot contain any joker';
    | errNotFound :    S:='"~" does not exist';
    | errStrToCard :   S:='Illegal "~" value';
    | errStart:        S:='"~" <start> value is beyond filesize';
    | errEnd:          S:='"~" <end> value is beyond filesize';
    | errRange:        S:="<end> value is before <start> value";
    | errAborted:      S:="Aborted by user";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ; (* nada *)
    ELSE
        IF Str.CharPos(S,"~") # MAX(CARDINAL) THEN Str.Subst(S,"~",einfo); END;
        Str.Append(S," !");
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    ioBufferIn:ioBufferType;

(* ------------------------------------------------------------ *)

PROCEDURE padded (wi:INTEGER;padchar:CHAR; S:ARRAY OF CHAR):str80;
VAR
    i:CARDINAL;
    R:str80;
BEGIN
    R:="";
    FOR i:=Str.Length(S)+1 TO ABS(wi) DO
        Str.Append(R,padchar);
    END;
    IF wi < 0 THEN
        Str.Prepend(R,S);
    ELSE
        Str.Append(R,S);
    END;
    RETURN R;
END padded;

PROCEDURE valToStr (v:LONGCARD;base:CARDINAL):str16;
VAR
    S:str16;
    ok:BOOLEAN;
BEGIN
    Str.CardToStr(v,S,base,ok);
    IF base=16 THEN Str.Lows(S);END;
    RETURN S;
END valToStr;

PROCEDURE dbgval (DEBUG: BOOLEAN; v:LONGCARD;S:ARRAY OF CHAR);
CONST
    wi = 20;
VAR
    N:str16;
    R:str80;
BEGIN
    IF DEBUG THEN
        R := "// ~ : ~ ($~)";
        Str.Subst(R, "~", padded(-wi,blank,S) );
        N:= valToStr(v,10);
        Str.Subst(R, "~", padded(10,blank,N) );
        N:= valToStr(v,16);
        Str.Subst(R, "~", padded(8,"0",N) );
        WrStr(R);WrLn;
    END;
END dbgval;

(* ------------------------------------------------------------ *)

PROCEDURE verify (S,allowed:ARRAY OF CHAR):BOOLEAN;
VAR
    i,mismatches : CARDINAL;
    ch : CHAR;
BEGIN
    mismatches := 0;
    FOR i := 1 TO Str.Length(S) DO
        ch := S[i-1];
        IF Belongs(allowed,ch)=FALSE THEN INC(mismatches);END;
    END;
    RETURN (mismatches=0);
END verify;

CONST
    pbNone   = 0;
    pbBadHex = 1;
    pbBadDec = 2;
    pbBadCard= 3;

PROCEDURE StrToLong (VAR v : LONGCARD; S:ARRAY OF CHAR) : CARDINAL;
CONST
    digits    = "0123456789";
    hexdigits = "ABCDEF"+digits;
VAR
    ok : BOOLEAN;
    rc,base : CARDINAL;
BEGIN
    Str.Caps(S);
    IF S[0]=dollar THEN
        Str.Delete(S,0,1);
        IF verify(S,hexdigits)=FALSE THEN RETURN pbBadHex;END;
        base := 16;
    ELSIF ( (S[0]="0") AND (S[1]="X") ) THEN
        Str.Delete(S,0,2);
        IF verify(S,hexdigits)=FALSE THEN RETURN pbBadHex;END;
        base := 16;
    ELSE
        IF verify(S,digits)=FALSE THEN RETURN pbBadDec;END;
        base := 10;
    END;
    v:=Str.StrToCard(S,base,ok);
    IF ok THEN
        rc:=pbNone;
    ELSE
        rc:=pbBadCard;
    END;
    RETURN rc;
END StrToLong;

PROCEDURE buildheader (searchunicrap,altformat:BOOLEAN;p:LONGCARD;n:CARDINAL):str80;
VAR
    R:str80;
    N:str16;
BEGIN
    R:="::: ~ @ ~ ($~) & L = ~ ($~) :::";
    IF searchunicrap THEN
        IF altformat THEN
            N:="Unicode";
        ELSE
            N:="U";
        END;
    ELSE
        IF altformat THEN
            N:="ASCII";
        ELSE
            N:="A";
        END;
    END;
    Str.Subst(R,"~",N);
    N:= valToStr(p,10);
    Str.Subst(R, "~", padded(10,blank,N) );
    N:= valToStr(p,16);
    Str.Subst(R, "~", padded(8,"0",N) );

    N:= valToStr(LONGCARD(n),10);
    Str.Subst(R, "~", padded(10,blank,N) );
    N:= valToStr( LONGCARD(n),16 );
    Str.Subst(R, "~", padded(8,"0",N) );
    IF altformat THEN
        Str.Append(R,nl);
    ELSE
        Str.Append(R,blank);
    END;
    RETURN R;
END buildheader;

PROCEDURE fixCtrl (c : CHAR;rigorous:BOOLEAN) : CHAR;
VAR
    v:CARDINAL;
BEGIN
    v:=ORD(c);
    CASE v OF
    | 0..ORD(blank):
        IF rigorous THEN
            CASE v OF
            | ORD(tabul),ORD(cr),ORD(lf): ;
            ELSE
                v:=ORD(gremlin);
            END;
        ELSE
            v:=ORD(gremlin);
        END;
    | 255: v:=ORD(gremlin);
    ELSE
        ;
    END;
    RETURN CHR(v);
END fixCtrl;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    pbReading = 101;
    pbEscape  = 102;

PROCEDURE  procPeek (VAR rc: CARDINAL;  searchunicrap,showinfos,
                    altformat,quoted,aggressive,filter,useLFN,DEBUG:BOOLEAN;
                    firstpos,lastpos:LONGCARD;
                    source:pathtype);
CONST
    CHKEVERY    = 1024; (* let's call chkEscape every CHKEVERY loop, 256 is NOT enough *)
TYPE
    chtype = RECORD
        ch1:CHAR;
        ch2:CHAR;
    END;
VAR
    hin:FIO.File;
    currpos,here,anchor:LONGCARD;
    status : (waiting,dumping);
    wlen:CARDINAL;
    blen:SHORTCARD;
    chkrounds,wanted,got,count:CARDINAL;
    S:str80;
    ch:chtype;
    carac:CHAR;
BEGIN
    chkrounds:=0;
    rc:=pbNone;
    hin:=fileOpenRead(useLFN,source);
    FIO.AssignBuffer(hin,ioBufferIn);
    FIO.Seek(hin,firstpos);
    currpos:=firstpos;
    status:=waiting;
    LOOP
        CASE status OF
        | waiting:
            IF searchunicrap THEN
                wanted:=SIZE(wlen);
                got:=FIO.RdBin(hin,wlen,wanted);
                IF got # wanted THEN rc:=pbReading; EXIT;END;
                count:=wlen;
            ELSE
                wanted:=SIZE(blen);
                got:=FIO.RdBin(hin,blen,wanted);
                IF got # wanted THEN rc:=pbReading; EXIT;END;
                count:=CARDINAL(blen);
            END;
            here:=currpos;
            INC(currpos,LONGCARD(got)); (* yes, FIO.Pos() would do too *)
            IF currpos > lastpos THEN EXIT; END;
            IF count # 0 THEN (* avoid 0-length *)
                IF showinfos THEN
                    S:=buildheader(searchunicrap,altformat,here,count);
                    WrStr(S);
                    IF quoted THEN WrStr(dquote);END;
                END;
                anchor:=currpos;
                dbgval(DEBUG,anchor,"store anchor");
                status := dumping;
            END;
        | dumping:
            got:=FIO.RdBin(hin,ch,wanted);
            IF got # wanted THEN rc:=pbReading; EXIT; END;
            IF searchunicrap THEN
                carac:=ch.ch1;
            ELSE
                carac:=ch.ch1;
            END;
            IF filter THEN carac:=fixCtrl(carac,FALSE);END;
            WrStr(carac);
            DEC(count);
            IF count = 0 THEN
                IF quoted THEN WrStr(dquote);END;
                WrLn;
                IF (chkrounds MOD CHKEVERY) = 0 THEN rc:=pbEscape;EXIT;END;
                IF aggressive THEN (* rewind *)
                    dbgval(DEBUG,anchor,"rewind to anchor");
                    FIO.Seek(hin,anchor);
                    currpos := anchor;
                    wanted:=0; (* fix later INC() ! *)
                END;
                status:=waiting;
            END;
            INC(currpos,LONGCARD(wanted));
            IF currpos > lastpos THEN EXIT; END;
        END;
        INC(chkrounds);
    END;
    fileClose(useLFN,hin);
END procPeek;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    minparm = 1;
    maxparm = 3;
VAR
    lastparm : CARDINAL;
    parm : ARRAY[minparm..maxparm] OF pathtype;
    searchascii,searchunicrap,showinfos:BOOLEAN;
    altformat,quoted,aggressive,filter,useLFN:BOOLEAN;
    DEBUG:BOOLEAN;
    source:pathtype;
    fsize,firstpos,lastpos,count:LONGCARD;
VAR
    parmcount,i,opt:CARDINAL;
    S,R:pathtype;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    WrLn;

    searchunicrap      := FALSE;
    showinfos          := FALSE;
    altformat          := TRUE;
    quoted             := FALSE;
    aggressive         := FALSE;
    filter             := FALSE;
    useLFN             := TRUE;

    lastparm := minparm-1;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);  cleantabs(R); (* YATB ! *)
        IF isOption(R)=TRUE THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "U"+delim+"UNICODE"+delim+
                                  "V"+delim+
                                  "VV"+delim+
                                  "Q"+delim+"QUOTED"+delim+
                                  "X"+delim+"LFN"+delim+
                                  "M"+delim+"SEARCHMODE"+delim+
                                  "F"+delim+"FILTER"+delim+
                                  "DEBUG"
                              );
            CASE opt OF
            |  1,  2,  3 : abort(errHelp,"");
            |  4,  5     : searchunicrap:= TRUE;
            |  6         : showinfos    := TRUE;
            |  7         : showinfos    := TRUE; altformat := FALSE;
            |  8,  9     : quoted       := TRUE;
            | 10, 11     : useLFN       := FALSE;
            | 12, 13     : aggressive   := TRUE;
            | 14, 15     : filter       := TRUE;
            | 16         : DEBUG        := TRUE;
            ELSE
                abort(errOption,S);
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errParmOverflow,S);END;
            parm[lastparm]:=S;
        END;
    END;
    CASE lastparm OF
    | minparm-1: abort(errExpecting,"<file>");
    (* | minparm:   abort(errExpecting,"<[$]start"); *)
    | minparm+1: abort(errExpecting,"<[$]end|L[=][$]lengh>");
    END;

    useLFN := (useLFN AND fileSupportLFN() );

    source := parm[minparm];
    IF chkJoker(source) THEN abort(errJoker,source); END;
    IF fileExists(useLFN,source)=FALSE THEN abort(errNotFound,source); END;
    fsize := fileGetFileSize(useLFN,source);

    IF fsize = 0 THEN abort(errNone,"");END;

    CASE lastparm OF
    | minparm:
        firstpos := 0;
        lastpos  := fsize-1;
        dbgval(DEBUG,firstpos,"firstpos");
        dbgval(DEBUG,lastpos,"lastpos");
    ELSE
        S:=parm[minparm+1];
        IF StrToLong (firstpos,S) # pbNone THEN abort(errStrToCard,S);END;
        dbgval(DEBUG,firstpos,"firstpos");

        S:=parm[minparm+2];
        CASE CAP( S[0] ) OF
        | star:
            lastpos := fsize-1;
        | "L" :
            Str.Delete(S,0,1);
            CASE S[0] OF
            | equal, colon :
                Str.Delete(S,0,1);
            END;
            IF same(S,star) THEN
                lastpos:=fsize-1;
            ELSE
                IF StrToLong(count,S) # pbNone THEN abort(errStrToCard,S);END;
                lastpos:=firstpos+count-1;
            END;
        ELSE
            IF StrToLong(lastpos,S) # pbNone THEN abort(errStrToCard,S);END;
        END;
        dbgval(DEBUG,lastpos,"lastpos");
    END;

    (* check range against 0..fsize-1 *)

    IF lastpos < firstpos THEN abort(errRange,"");END;

    S:="~ ($~)";
    Str.Subst(S,"~",valToStr(firstpos,10));
    Str.Subst(S,"~",valToStr(firstpos,16));
    IF firstpos > fsize THEN abort(errStart,S);END;
    S:="~ ($~)";
    Str.Subst(S,"~",valToStr(lastpos,10));
    Str.Subst(S,"~",valToStr(lastpos,16));
    IF lastpos  > fsize THEN abort(errEnd,S);END;

    procPeek (i,searchunicrap,showinfos,
                altformat,quoted,aggressive,filter,useLFN,DEBUG,
                firstpos,lastpos,
                source);
    CASE i OF
    | pbReading:abort(errReading,source);
    | pbEscape :abort(errAborted,"");
    END;

    abort(errNone,"");
END PASpeek.




(*

@echo off
set _o_=c:\bat\tools\paspeek
set _n_=paspeek

set _f_=wininit.exe 929 2061

%_o_% %_f_% > old1
%_n_% %_f_% > new1

set _f_=newspeak.exe $989a $bf27

%_o_% %_f_% > old2
%_n_% %_f_% > new2

set _f_=vtuner.exe $4a1c0 $4b4ff

%_o_% %_f_% ! > old3
%_n_% %_f_% -u > new3



set _f_=wininit.exe 929 2061

%_n_% %_f_% -v -q -m > new1a

set _f_=newspeak.exe $989a $bf27

%_n_% %_f_% -v -q -m > new2a

set _f_=vtuner.exe $4a1c0 $4b4ff

%_n_% %_f_% -v -q -u -m > new3a

set _f_=
set _n_=
set _o_=

filecomp old1 new1
filecomp old2 new2
filecomp old3 new3

rem filecomp new1 new1a
rem filecomp new2 new2a
rem filecomp new3 new3a

*)

