(* ---------------------------------------------------------------
Title         Q&D Unit Clone : a VITAL/DTHS/CS/PQMAGIC/SAVEPART companion
Author        PhG
Overview      see help
Notes         this is (very) poor man's ghost/driveimage disk cloning utility :-(

              for now, user can easily trash his hard disk,
              if he/she/it does not pay attention to specified command line !
              safety can be overidden : "caveat utilisator" (pseudo Latin, eh eh)

              once cloning has begun,
              at least portion of target is obviously lost !

              note MD5 (and CRC32 or SHA) individual file check is HIGHLY advised,
              even if BIOS did not report errors :
              P4+Award6.0+Maxtor gave us a few nasty surprises,
              (while P2+Award4.5+Quantum are perfect !)

              it may be wise to use the divide and conquer approach,
              manually saving each partition at a time in case of a problem



              -clone option has been fully tested for years now
              and is thought to be as safe as possible ;
              -backup has not yet been fully tested,
              and should be seen as a beta feature until proven safe !

              we don't know what can happen with SATA and USB newer hardware...
              and we don't care for now (update : this does work as expected)



              manually lowering BIOS HD values
              from "UDMA 6 & max sectors" to "UDMA 5 & 16 sectors"
              may solve problems : at least, it did it for us !
              (we wasted hours to try and fix imaginary software problems,
              while culprits were hardware-related !)

              now program WORKS, following comments are kept for history ;-) :-(

              ; history ON

              P4 = Pentium 4 2.4 GHz P4S8X-X, P2 = Pentium II 233 MHz P2L97
              P4 = UDMA 6 Maxtor hard disks, P2 = UDMA 2 Quantum hard disks
              real mode DOS=fastest, HIMEM=a little slower, EMM386=slowest
              -v (read) is almost same speed as -vv (verify)

              results vary upon processor, memory manager and BIOS !
              DOS maker (M$, Novell) does not seem to matter

              P4, 32 blocks, DOS, 80 Gb, -v  = 55mn
              P4, 63 blocks, DOS, 80 Gb, -v  = 29mn
              P4, 63 blocks, DOS, 80 Gb, -c  = 34mn
              P4, 63 blocks, EMM, 80 Gb, -c  = 7+ hours !!!

              P2, 63 blocks, EMM, 10 Gb, -v  = 29mn
              P2, 32 blocks, EMM,  4 Gb, -v  = 13mn
              P2, 32 blocks, DOS,  4 Gb, -v  = 13mn
              P2, 63 blocks, EMM,  4 Gb, -v  = 8mn
              P2,126 blocks, EMM,  4 Gb, -v  = 9mn
              P2, 63 blocks, EMM,  4 Gb, -c  = 18mn
              P2, 63 blocks, DOS,  4 Gb, -c  = 17mn



              note a few BIOSes (thanks, Award/Asus !) lie about
              their actual EDD v2.1+ support :
              thus, $134E can fail even though said to be supported !

              note a few BIOSes (thanks again, Award/Asus !) are unreliable
              when asked to return last hard disk operation status !



              cloning (read/read) test for 80 Gb from P4 :

              - with EMM386, it's desperately useless :
                in one hour, only 22.313.025 blocks were copied,
                which would translate as more than 7 hours for whole disk !

              - with HIMEM, process took 34 mn !

              - in real mode (no memory manager), process took 32 mn !

              cloning (read/write) test for 80 Gb from P4 :

              - in real mode (no memory manager), we get a few "$02 errors" !
                retrying 3 times was tested without benefit : errors still occur
                added waitReady() does not help at all !
                decreasing buffer number of blocks does not either

              - with EMM386, process is awfully slow...
                but does not report any error

              cloning (read/write) test for 4/10 Gb drives from P2 :

              - with EMM386, everything is perfect !
              - in real mode (no memory manager), everything is perfect !



              temporary fix for P4 : we run UCLONE from real mode DOS,
              then we rerun it from EMM386 using a batch
              created from UCLONE.LOG, just copying again problematic blocks :
              anyway, MD5 check still reveal a few discrepancies

              seems lunatic P4 likes to change randomly $df value to $ff !

              seems SiS controller and/or Maxtor hard drive
              do not really support UltraDMA 6 : liars !
              even seen an Internet bug report about SiS
              being unable to really handle 2 drives on same controller !

              others possible sources for those nasty problems :
              faulty BIOS support ? CPU speed ?
              can't think of any other factor for now... :-(
              it's an illogical nightmare !

              fed up... the only conforting thought is that similar
              demo/commercial programs tried all display
              the same kind of problems on our P4 system

              Asus, Award, Maxtor : so much time wasted because of you !

              ; history OFF

              undocumented isl342() may be related to IF..THEN..ELSE and/or LOOP..END

              available as of v1.1e : G M N O Q S X Y

              usb units seem to work if set as IDE in bios
              external usb is seen as $83 if plugged at boot
              (unrecognized if plugged after boot from DOS)

Bugs          support for $82 and $83 was not tested for lack of hardware

              Yet Another TopSpeed Bug : we can't concatenate (+) a string constant
              to an empty string constant, for result is truncated at empty string !

              check all FIXME (buildCLI, debug dump)

              note TxHxS is only cosmetic : values are NOT used by program !

Wish List     better consistency checks
              show disks serial numbers (read directly from i/o ports)
              reinject profiling code to "verify" process ?
              partition tables check/readjustment on target ?
              prettier display
              clone specified individual partition ? (fix MBR too ?)
              (could be faster... and less attractive to Hilarion)

              presence of UCLONE.!!! could disable -apply
              (thus always protecting user from doing real damage... er, work) ?

              display MB/s rate of operation ?
              warn against any memory manager ?
              (though a few BIOSes require slow EMM386 to work !)

              compare source with target ? (just block mismatch, not every byte)

              add estimated remaining time ?

              fix and adjust partition table (especially before/after partial copying)
              specify target block (would allow copying a partition to a disk)

              note it's useless to force tracksize to 63 sectors or less
              (see VITAL v1.3g) because maxWanted was already always set to 63

              save partition to files (to other unit, building MD5 or SHA,
              taking OS limits into account : 0.6, 1 or 2 Gb files)

              don't save whole unit but only space occupied by partitions

              save blocks to same unit (but to unused partition or space)
              (-b as not to change -c syntax for user safety)

              what of older TxHxS drives without LBA support ? let them die !

              rewrite DHTS, VITAL and UCLONE so they share common subs ?
              in another unlikely (un)life !

              sepdot (coma) for beautified could be a variable allowing fr dot ?

              crypt with password so backup is protected against curiosity ?
              (from cli, kbd, file)

--------------------------------------------------------------- *)

MODULE uClone;

IMPORT Str;
IMPORT Lib;
IMPORT FIO;
IMPORT SYSTEM;
IMPORT IO;

FROM IO IMPORT WrStr, WrLn;
FROM Storage IMPORT ALLOCATE,DEALLOCATE,Available;

FROM FIO IMPORT FIXEDLIBS;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits;

(* ------------------------------------------------------------ *)

CONST
    ENABLEREALUPDATE = TRUE;  (* if FALSE, unit is protected against writing *)
    TESTING          = FALSE; (* TRUE while...testing i.e. code not frozen *)

(* ------------------------------------------------------------ *)

(* globerks because referenced in abort() *)

VAR
    DYNALLOC                : BOOLEAN; (* if FALSE, fixed buffers *)
VAR
    AUDIO                   : BOOLEAN; (* globerk but we don't care *)
VAR
    FATALINAL               : BOOLEAN; (* globerk *)
    bFatalStatusCode        : BYTE;    (* op status or unreliable int $13 get status *)
    bFatalStatus            : BYTE;    (* copy of unreliable BIOS variable *)
    sFatalStatusExplanation : str128;  (* used by getFatalStatus() *)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE sound (freq,duration,pause:CARDINAL);
BEGIN
    Lib.Sound(freq);
    Lib.Delay(duration);
    Lib.NoSound();
    Lib.Delay(pause);
END sound;

PROCEDURE alarm (  );
BEGIN
    sound(55,55,100);
    sound(55,55,10);
END alarm;

PROCEDURE alert (  );
BEGIN
    sound(550,55,100);
    sound(550,55,10);
END alert;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    progTitle     = "Q&D Unit Clone";
    progVersion   = "v1.1f";
    progCopyright = "by PhG";
    Banner        = progTitle+" "+progVersion+" "+progCopyright;
    progEXEname   = "UCLONE";
CONST
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;
    coma          = ",";
    dot           = ".";
    backslash     = "\";
    colon         = ":";

    dotdot        = dot+dot;
    netslash      = backslash+backslash;

    extEXE        = ".EXE";
    extCFG        = ".CFG";
    extLOG        = ".LOG";
    LOGFILE       = progEXEname+extLOG;
    CFGFILE       = progEXEname+extCFG;
    strFmtTime    = "~h ~mn ~s";
    strFmtDateTime= "~, ~ ~ ~ at "+strFmtTime; (* dow j m a h m s *)
CONST
    maxSectorsPerTrack =  63; (* should be ok for extended int $134# calls *)
    sBlocksAtAtime     = "63";
CONST
    maxBlocksAtAtime   = maxSectorsPerTrack * 1 ; (* limit is $7f anyway *)

CONST
    defaultUpdateFreq = 64; (* was 4096 for oneSector, 1024 gives same timing *)
    CHKEVERY          = 4; (* let's call chkEscape every CHKEVERY loop *)
    wiblock           = 9+2; (* "###.###.###" is 512 Gb for # = 9 *)
    wiwanted          = 2;   (* always [1..63] *)
    sepdot            = coma; (* us, could be fr dot ! *)
    UNDEFINEDBLOCK    = MAX(LONGCARD);

CONST
    sINFO         = "::: ";
    sPROBLEM      = "--- ";
    sOK           = "+++ ";
    sCANCELLED    = "--- ";  (* not a problem but show nothing was done *)
    sWARN         = "*** ";
    sCLI          = "!!! ";
    sNOTICE       = "    ";
    sFAKE         = " ;-)"; (* suffix *)
CONST
    sBADideaWin = sWARN+"Please note running this program from Windows is a BAD idea !"+nl;
    sBADideaMode= sWARN+"Please note running this program with any memory manager is a BAD idea !"+nl;

(* ------------------------------------------------------------ *)

CONST
    errNone                 = 0;
    errHelp                 = 1;
    errHelper               = 2;
    errOption               = 3;
    errParameter            = 4;
    errRange                = 5;
    errNotXBIOS             = 6;
    errVerifyFailure        = 7;
    errSameUnit             = 8;
    errCmd                  = 9;
    errUnit                 = 10;
    errSyntaxCmd            = 11;
    errPhantom              = 12;
    errXBIOSvalues          = 13;
    errBlockRange           = 14;
    errUnexpectedUnitRange  = 15;
    errNoCommand            = 16;
    errRedirected           = 17;
    errCloningFailure       = 18;
    errCannotClone          = 19;
    errPIOorDMA             = 20;
    errEDD                  = 21;
    errBlock                = 22;
    errReserved             = 23;
    errCannotAdjustBackup   = 24;
    errUnexpectedUnitBlock  = 25;
    errOverlap              = 26;
    errMisfitSrc            = 27;
    errMisfitDst            = 28;
    errCopyingFailure       = 29;
    errNoUnit               = 30;

    errAborted              = 32;

    errBoundary             = 64;

    errXBIOSint13h          = 129; (* was 128 but 129 matches DTHS and VITAL *)
    errWrongTHSgeometry     = 130;
    errFatal                = errXBIOSint13h;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);

    PROCEDURE msg2 (VAR R : ARRAY OF CHAR;S1,S2:ARRAY OF CHAR);
    BEGIN
        Str.Concat(R,S1,S2);
    END msg2;

    PROCEDURE msg3 (VAR R : ARRAY OF CHAR;S1,S2,S3:ARRAY OF CHAR);
    BEGIN
         msg2(R,S1,S2);Str.Append(R,S3);
    END msg3;

CONST
    msgBEWARE =
"BE SURE TO KNOW WHAT YOU ARE DOING ! USE THIS OPTION AT YOUR OWN RISK !";
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
CONST
    msgHelp =
Banner+nl+
nl+
"Syntax 1 : "+progEXEname+" <-c[c]> <source> <target> [block_range] [option]..."+nl+
"Syntax 2 : "+progEXEname+" <-b[b]> <source> <target> <block_range> <block> [option]..."+nl+
"Syntax 3 : "+progEXEname+" <-v[v]> <unit> [block_range] [option]..."+nl+
"Syntax 4 : "+progEXEname+" [-p|-i] <unit> [unit [block_range [block]]] [option]..."+nl+
"Syntax 5 : "+progEXEname+" <-![!]>"+nl+
nl+
"-c[c]   clone <source> unit to <target> unit (-cc = -c -k)"+nl+
"-b[b]   copy <source> unit <block_range> to <target> <block> (-bb = -b -k)"+nl+
"-v[v]   verify <unit> (-v = really read data, -vv = standard verify)"+nl+
"-p|-i   display <unit>(s) geometry"+nl+
"-![!]   show available units (tested range is [$80..$83])"+nl+
nl+
"-z      automagically adjust block range to smallest of <source> and <target>"+nl+
"-k      retry one block at a time if buffer could be read but not written"+nl+
"        (-c[c]|-b[b]), or if buffer was not successfully verified (-v[v])"+nl+
"-parano if <target> buffer was successfully written,"+nl+
"        reread it and compare it with <source> buffer (ignored if no -apply)"+nl+
"-d      alternate display"+nl+
"-e      do not show percentage of completion"+nl+
"-t      show only percentage of completion"+nl+
"-a|-w   audio warning"+nl+
'-apply  really WRITE to <unit> (default is to READ, as shown by "'+sFAKE+'" trailer)'+nl+
"        "+msgBEWARE+nl+
"-yes    do not ask for confirmation"+nl+
"        "+msgBEWARE+nl+
"-ths    factorize blocks count ignoring unexpected values for TxHxS"+nl+
"-u      do not abort on fatal errors (forced fully by -v[v], partially by -k)"+nl+
"-l      prevent operations and errors from being reported to "+LOGFILE+" log"+nl+
"-ah     assume int $1301 returns last operation status in AH (default is AL)"+nl+
"-r      reset <unit> using int $130D (default is not to reset)"+nl+
"-f[f]   use fixed buffers (-ff = check page boundaries)"+nl+
"-j[j]   if rebuilding TxHxS is needed, instead of finding best factorization,"+nl+
"        force headcount=255 (-j) or headcount=240 (-jj)"+nl+
"-klonit dangerous shortcut for -c -k -apply -u -yes (-dupme = -klonit -e)"+nl+
"-??     more help (to be read at least once !)"+nl+
nl+
(*%F ENABLEREALUPDATE *)
"PLEASE NOTE THAT UPDATING HARD DISK DATA IS NOT ENABLED !"+nl+
nl+
(*%E  *)
"a) Assumed : BIOS interrupt $13 extensions support for IDE (AH=$42,$43,$44)."+nl+
"b) Assumed : DWORD <block>, WORD <track>, WORD <head>, 512 bytes WORD <sector>."+nl+
"c) <unit> is {$8<0|1|2|3>,8<0|1|2|3>H,HD_<A|B|C|D>,HD_<0|1|2|3>} hard disk."+nl+
"d) 0-based <block_range> is <first_block..last_block> or <first_block,count>."+nl+
"e) IMPORTANT : should best factorization fail, -j would be silently forced."+nl+
"f) Buffers, whether dynamic (default) or fixed (-f[f]), are "+sBlocksAtAtime+" blocks long."+nl+
"g) Use of these options is UNWISE and/or UNSAFE : -u, -l, -z, -klonit, -dupme."+nl+
"h) -ah option is forced if "+CFGFILE+" exists in executable directory."+nl+
"i) -c[c], -b[b] and -v[v] commands can be aborted with ESCape key."+nl+
'j) -backup is an "advanced" (i.e. less restrictive and more dangerous) -clone :'+nl+
"   as it gives more responsability to user, it does not support -z option."+nl;

CONST
    msgverbosehelp =
"j) Three options rely on BIOS *not* lying about its EDD v2.1+ $134E support :"+nl+
"   -pio, -dma and -pf, which respectively try and force"+nl+
"   maximum PIO mode, interrupt $13 DMA maximum mode, and prefetch mode."+nl+
"k) Any option irrelevant to specified command is ignored without notice."+nl+
nl+
"This program should always be run in real mode from a DOS boot floppy disk,"+nl+
"with enough free space for "+LOGFILE+" (if not disabled)."+nl+
"Both <source> and <target> should be verified before trying to perform cloning."+nl+
nl+
"Speed and reliability depend upon UDMA, memory manager, processor and BIOS."+nl+
"Unlikely problems should be solved by lowering these settings from BIOS setup :"+nl+
'"UltraDMA" and/or "maximum sectors transferred".'+nl+
nl+
"While this program supports IDE units only, it CAN use S-ATA and USB devices."+nl+
"Any modern BIOS setup may allow S-ATA devices to emulate IDE units ;"+nl+
"it may also see USB devices plugged in when turning PC on as IDE units."+nl+
nl+
"Once cloning process is done, target <unit> should be disconnected."+nl+
"Should <target> unit stay plugged in PC, its partition table MUST be edited :"+nl+
"Windows XP disk ID serial number WILL have to be changed,"+nl+
"while partitions SHOULD be hidden. VITAL utility may be of some help here."+nl+
nl+
"For added safety, each individual file should be checked against its MD5 digest"+nl+
"and possibly CRC32 or SHA as to help prevent collisions, however unlikely."+nl+
nl+
'If specified as "=" or "*", <target> unit will be the same as <source> unit :'+nl+
msgBEWARE+nl+
nl+
"Examples : "+progEXEname+" -c hd_a hd_b"+nl+
"           "+progEXEname+" -v $81 0,63"+nl+
"           "+progEXEname+" -p $80"+nl+
"           "+progEXEname+" -b $80 $81 0..62 10000"+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp,errHelper:
        WrStr(msgHelp);
        IF e = errHelper THEN
            WrStr(msgverbosehelp);
            e := errHelp;
        END;
    | errOption :     msg3(S,'Unknown "',einfo,'" option !');
    | errParameter:   msg3(S,'Unexpected "',einfo,'" parameter !');
    | errRange:       msg3(S,'Illegal "',einfo,'" range !');
    | errNotXBIOS:    msg3(S,'"',einfo,'" <unit> BIOS interrupt $13 extensions are either not available or too limited !');
    | errVerifyFailure:S:= "Verify operation did not report success !";
    | errSameUnit:    S := "<source> and <target> cannot be identical !";
    | errCmd:         S := "-c[c], -b[b], -v[v], -p and -! commands are mutually exclusive !";
    | errUnit:        msg3(S,'Illegal "',einfo,'" <unit> specification !');
    | errSyntaxCmd:   msg3(S,'Wrong number of parameters for "',einfo,'" command !');
    | errPhantom:     msg3(S,'"',einfo,'" <unit> does not exist !');
    | errXBIOSvalues: msg3(S,'Unexpected values returned by "',einfo,'" procedure !');
    | errBlockRange:  msg3(S,"First and last blocks must belong to [0..",einfo,"] range !");
    | errUnexpectedUnitRange:msg3(S,'Illegal "',einfo,'" <unit> instead of expected [block_range] !');
    | errNoCommand:   S := "None of -c[c], -b[b], -v[v] or -p commands was specified !";
    | errRedirected:  msg3(S,"Redirection is not allowed with ",einfo," command !");
                      video(progEXEname+" : ",TRUE);video(S,TRUE); (* send message to screen anyway ! *)
                      IF AUDIO THEN alarm();END;
    | errCloningFailure:S:="Cloning operation did not report success !";
    | errCannotClone: S := "Cloning cannot be performed with current geometry and block range !";
    | errPIOorDMA:    S := "-pio and -dma options are mutually exclusive !";
    | errEDD:         msg3(S,einfo," EDD command failed"," !");
    | errBlock:       msg3(S,'Illegal "',einfo,'" block !');
    | errReserved:    msg3(S,'Illegal MAX(CARDINAL) reserved value in "',einfo,'" expression !');
    | errCannotAdjustBackup:   S:="-b[b] and -z option are mutually exclusive !";
    | errUnexpectedUnitBlock:msg3(S,'Illegal "',einfo,'" <unit> instead of expected <block> !');
    | errOverlap:     S:="<target> block range would overwrite <source> <block_range> !";
    | errMisfitSrc:   S:="<source> <block_range> would not fit <source> unit geometry !";
    | errMisfitDst:   S:="<target> block range would not fit <target> unit geometry !";
    | errCopyingFailure:S:="Copying operation did not report success !";
    | errNoUnit:      S := "No unit could be found !";

    | errAborted :    S := "Aborted by user !";

    | errBoundary:
         IF DYNALLOC THEN
             msg2(S,einfo," dynamic");
         ELSE
             msg2(S,einfo," fixed");
         END;
         Str.Append(S," buffer would cross 64Kb page boundary !");

    | errXBIOSint13h :
                      msg3(S,'Unexpected BIOS interrupt $13 extensions failure in "',einfo,'" procedure !');
                      Str.Append(S,sFatalStatusExplanation);
                      IF AUDIO THEN alert();END;
    | errWrongTHSgeometry:
                      msg3(S,'Unexpected geometry values returned by "',einfo,'" procedure !');
                      IF AUDIO THEN alert();END;

    ELSE
        S := "How did you get THERE ???";
    END;
    CASE e OF
    | errNone, errHelp :
        ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;

    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* fills global sFatalStatusExplanation and useless bFatalStatus *)

PROCEDURE initFatalStatus (  );
CONST
    msg=nl+progEXEname+" : This message should never be seen !";
BEGIN
    bFatalStatusCode := 00H;
    bFatalStatus     := 00H;
    sFatalStatusExplanation := msg;
END initFatalStatus;

(* 1301----INT 13 - DISK - GET STATUS OF LAST OPERATION *)

PROCEDURE getFatalStatus(unit,mystatus:BYTE;explainmystatus:BOOLEAN);
CONST
    placeholder = "@";
    msg = nl+progEXEname+" : int $1301 @=$@ i.e. @ !";
    sb = 040H; (* segBiosData *)
VAR
    RC:str16;
    S,Z:str128;
    statuscode:BYTE;
    ok,rc:BOOLEAN;
    R:SYSTEM.Registers;
    biosFloppyLastRC [sb:041H] : BYTE;
    biosFixedLastRC  [sb:074H] : BYTE;
BEGIN
    IF unit < BYTE(80H) THEN
        bFatalStatus := biosFloppyLastRC; (* DISKETTE - LAST OPERATION STATUS *)
    ELSE
        bFatalStatus := biosFixedLastRC;  (* FIXED DISK LAST OPERATION STATUS (except ESDI drives) *)
    END;

    IF explainmystatus THEN
        statuscode:= mystatus;
    ELSE
        (* Award is utterly unreliable here !!! *)
        R.AH := 01H; (* get status of last operation *)
        R.DL := unit; (* bit 7 for hard disk *)
        Lib.Intr (R,13H);
        rc:=( NOT (SYSTEM.CarryFlag IN R.Flags) ); (* CF clear if successful status 00h *)
        IF FATALINAL THEN
            statuscode:= R.AL;
        ELSE
            statuscode:= R.AH; (* not standard, Ralf ! *)
        END;
    END;
    bFatalStatusCode := statuscode;

    CASE CARDINAL(statuscode) OF
    | 000H : S:="successful completion";
    | 001H : S:="invalid function in AH or invalid parameter";
    | 002H : S:="address mark not found";
    | 003H : S:="disk write-protected";
    | 004H : S:="sector not found/read error";
    | 005H : S:="reset failed (hard disk)";
    (* | 005H : S:="data did not verify correctly (TI Professional PC)"; *)
    | 006H : S:="disk changed (floppy)";
    | 007H : S:="drive parameter activity failed (hard disk)";
    | 008H : S:="DMA overrun";
    | 009H : S:="data boundary error (attempted DMA across 64K boundary or >80h sectors)";
    | 00AH : S:="bad sector detected (hard disk)";
    | 00BH : S:="bad track detected (hard disk)";
    | 00CH : S:="unsupported track or invalid media";
    | 00DH : S:="invalid number of sectors on format (PS/2 hard disk)";
    | 00EH : S:="control data address mark detected (hard disk)";
    | 00FH : S:="DMA arbitration level out of range (hard disk)";
    | 010H : S:="uncorrectable CRC or ECC error on read";
    | 011H : S:="data ECC corrected (hard disk)";
    | 020H : S:="controller failure";
	| 030H : S:="drive does not support media sense"; (* added by hand from MEMORY.LST *)
    | 031H : S:="no media in drive (IBM/MS INT 13 extensions)";
    | 032H : S:="incorrect drive type stored in CMOS (Compaq)";
    | 040H : S:="seek failed";
    | 080H : S:="timeout (not ready)";
    | 0AAH : S:="drive not ready (hard disk)";
    | 0B0H : S:="volume not locked in drive (INT 13 extensions)";
    | 0B1H : S:="volume locked in drive (INT 13 extensions)";
    | 0B2H : S:="volume not removable (INT 13 extensions)";
    | 0B3H : S:="volume in use (INT 13 extensions)";
    | 0B4H : S:="lock count exceeded (INT 13 extensions)";
    | 0B5H : S:="valid eject request failed (INT 13 extensions)";
    | 0B6H : S:="volume present but read protected (INT 13 extensions)";
    | 0BBH : S:="undefined error (hard disk)";
    | 0CCH : S:="write fault (hard disk)";
    | 0E0H : S:="status register error (hard disk)";
    | 0FFH : S:="sense operation failed (hard disk)";
    ELSE
             S:="unexpected fatal disk operation status";
    END;

    Str.Copy(Z,msg);

    IF FATALINAL THEN
        RC:="AL";
    ELSE
        RC:="AH";
    END;
    Str.Subst(Z,placeholder,RC);

    Str.CardToStr (LONGCARD(statuscode),RC,16,ok);
    IF statuscode < BYTE(10H) THEN Str.Prepend(RC,"0");END;
    Str.Lows(RC);
    Str.Subst(Z,placeholder,RC);

    (*
    Str.CardToStr (LONGCARD(bFatalStatus),RC,16,ok);
    IF bFatalStatus < 10H THEN Str.Prepend(RC,"0");END;
    Str.Lows(RC);
    Str.Subst(Z,placeholder,RC);
    *)

    Str.Subst(Z,placeholder,S);
    Str.Copy(sFatalStatusExplanation,Z);
END getFatalStatus;

PROCEDURE fixFatalStatusBios ():BOOLEAN;
VAR
    ini:str128;
BEGIN
    Lib.ParamStr(ini,0); (* retrieve executable location : yes, we assume it ! *)
    Str.Caps(ini); (* safety *)
    Str.Subst(ini,extEXE,extCFG);
    RETURN FIO.Exists(ini);
END fixFatalStatusBios;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    DTtype = RECORD
        Year      : CARDINAL;
        Month     : CARDINAL;
        Day       : CARDINAL;
        Hours     : CARDINAL;
        Minutes   : CARDINAL;
        Seconds   : CARDINAL;
        Hundredths: CARDINAL;
        DayOfWeek : Lib.DayType;
    END;

PROCEDURE GetDateTimeNow (VAR dt : DTtype);
BEGIN
    Lib.GetDate(dt.Year,dt.Month,dt.Day,dt.DayOfWeek);
    Lib.GetTime(dt.Hours,dt.Minutes,dt.Seconds,dt.Hundredths);
END GetDateTimeNow;

(* ------------------------------------------------------------ *)

PROCEDURE fmtlc (v:LONGCARD;base:CARDINAL;wi:INTEGER;ch,prefix:CHAR) : str80;
VAR
    R : str80;
    ok: BOOLEAN;
    i : CARDINAL;
BEGIN
    Str.CardToStr(v,R,base,ok);
    FOR i:= Str.Length(R)+1 TO ABS(wi) DO
        IF wi < 0 THEN
            Str.Append(R,ch);
        ELSE
            Str.Prepend(R,ch);
        END;
    END;
    IF base=16 THEN Str.Lows(R);END;
    Str.Prepend(R,prefix);
    RETURN R;
END fmtlc;

PROCEDURE fmt (v:CARDINAL;base:CARDINAL;wi:INTEGER;ch,prefix:CHAR) : str80;
BEGIN
    RETURN fmtlc(LONGCARD(v),base,wi,ch,prefix);
END fmt;

PROCEDURE fmtrangelc (lower,upper:LONGCARD):str80;
VAR
    R:str80;
BEGIN
    Str.Concat(R,"[",fmtlc(lower,10,0,"",""));
    Str.Append(R,"..");
    Str.Append(R,fmtlc(upper,10,0,"",""));
    Str.Append(R,"]");
    RETURN R;
END fmtrangelc;

PROCEDURE fmtrange (lower,upper:CARDINAL):str80;
BEGIN
    RETURN fmtrangelc( LONGCARD(lower),LONGCARD(upper) );
END fmtrange;

PROCEDURE beautifiedlc (v : LONGCARD;pad:CHAR; sep:CHAR; field:INTEGER) : str80;
VAR
    S,R   : str80;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.CardToStr(v,S,10,ok);
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END beautifiedlc;

PROCEDURE fmtDateTimeUS (dt:DTtype):str80;
TYPE
    tDays   = ARRAY [1..7] OF str16;
    tMonths = ARRAY [1..12] OF str16;
CONST
    tJours = tDays("Sunday","Monday","Tuesday","Wednesday",
                   "Thursday","Friday","Saturday"
                  );
    tMois = tMonths("January","February","March","April",
                    "May","June","July","August",
                    "September","October","November","December"
                   );
VAR
    Year,Month,Day : CARDINAL;
    H,M,S,s        : CARDINAL;
    R              : str80;
BEGIN
    (* yes, we know it's not very american a date/time format... so what ? *)

    R:=strFmtDateTime;
    Str.Subst(R,"~", tJours[ORD(dt.DayOfWeek)+1]);

    Str.Subst(R,"~", fmt(dt.Day,10,0,"",""));
    Str.Subst(R,"~", tMois[dt.Month]);
    Str.Subst(R,"~", fmt(dt.Year,10,0,"",""));
    Str.Subst(R,"~", fmt(dt.Hours,  10,2,"0",""));
    Str.Subst(R,"~", fmt(dt.Minutes,10,2,"0",""));
    Str.Subst(R,"~", fmt(dt.Seconds,10,2,"0",""));
    RETURN R;
END fmtDateTimeUS;

PROCEDURE fmtTHS (ALTFORMAT:BOOLEAN; t,h,s:CARDINAL;mul:CHAR):str80;
VAR
    S:str80;
BEGIN
    IF NOT(ALTFORMAT) THEN
        S:="~ = ~@~@~";
        Str.Subst(S,"~", beautifiedlc( (LONGCARD(t)*LONGCARD(h)*LONGCARD(s))," ",sepdot,wiblock) );
        Str.Subst(S,"~", fmt(t,10,0,"",""));
        Str.Subst(S,"@", mul);
        Str.Subst(S,"~", fmt(h,10,0,"",""));
        Str.Subst(S,"@", mul);
        Str.Subst(S,"~", fmt(s,10,0,"",""));
    ELSE
        S:="~@~@~ = ~";
        Str.Subst(S,"~", fmt(t,10,0,"",""));
        Str.Subst(S,"@", mul);
        Str.Subst(S,"~", fmt(h,10,0,"",""));
        Str.Subst(S,"@", mul);
        Str.Subst(S,"~", fmt(s,10,0,"",""));
        Str.Subst(S,"~", fmtlc( (LONGCARD(t)*LONGCARD(h)*LONGCARD(s)),10,0,"",""));
    END;
    RETURN S;
END fmtTHS;

PROCEDURE fmtpercentage (base,curr,total:LONGCARD):str16; (* oversized *)
VAR
    R:str16;
    divisor:LONGCARD;
    n:CARDINAL;
    cH,cD,cU : CHAR;
BEGIN
    divisor := total DIV 100;
    IF divisor = 0 THEN divisor:=1; END; (* safety *)
    n  := CARDINAL( (curr-base) DIV divisor );

    cH := CHR( n DIV 100          + ORD('0') );
    cD := CHR((n MOD 100) DIV 10  + ORD('0') );
    cU := CHR( n MOD 10           + ORD('0') );

    IF cH = '0' THEN
        cH := " ";
        IF cD = '0' THEN cD := " ";END;
    END;

    Str.Copy(R,"");
    IF cH # " " THEN Str.Append(R,cH);END;
    IF cD # " " THEN Str.Append(R,cD);END;
    Str.Append(R,cU);
    Str.Append(R,"%");

    RETURN R;
END fmtpercentage;

(* ------------------------------------------------------------ *)

(*
    gregorian calendar rule : leap 366 years if divisible by 4
    but centurial years NOT divisible by 4 are common
    Leap years are divisible by 400, or by 4 and not by 100
    1900 is common, 2000 is leap
*)

PROCEDURE getDaysInFebruary (annee:CARDINAL):CARDINAL;
CONST
    common = 28;
    leap   = 29;
BEGIN
    IF (annee MOD 400) = 0 THEN RETURN leap; END;
    IF (((annee MOD 4) = 0) AND ((annee MOD 100) # 0)) THEN RETURN leap; END;
    RETURN common;
END getDaysInFebruary;

(* assume month and year are correct *)

PROCEDURE getDaysInMonth (mois,annee:CARDINAL):CARDINAL;
TYPE
    daysinmonthtype = ARRAY [1..12] OF CARDINAL;
CONST
    (*                    JanFevMarAprMayJunJulAugSepOctNovDec *)
    (*                     1  2  3  4  5  6  7  8  9 10 11 12  *)
    dpm = daysinmonthtype(31, 0,31,30,31,30,31,31,30,31,30,31);
VAR
    m : CARDINAL;
BEGIN
    m:= dpm[mois];
    IF m=0 THEN m:=getDaysInFebruary(annee);END;
    RETURN m;
END getDaysInMonth;

(* jan 1 = 1, etc. *)

PROCEDURE getCountOfDays (jour,mois,annee:CARDINAL):CARDINAL;
VAR
    n,i : CARDINAL;
BEGIN
    n:=jour;
    FOR i:= 1 TO (mois-1) DO
        INC(n, getDaysInMonth(mois,annee) );
    END;
    RETURN n;
END getCountOfDays;

(* out of lazyness, reasonably assume process won't take more than 24 hours ! *)

PROCEDURE fmtDelta (started,ended:DTtype):str80;
CONST
    minutesPerHour   = 60;
    secondsPerMinute = 60;
    hundred          = 100;
    midnight         = 24*minutesPerHour*secondsPerMinute*hundred;
    baseyear         = 1980; (* historic ! *)
VAR
    R : str80;
    n,hmsStart,hmsEnd,jmaStart,jmaEnd : LONGCARD; (* in hundredths of seconds *)
    delta : DTtype;
    i,v:CARDINAL;
BEGIN
    n := LONGCARD(started.Hours) * minutesPerHour + LONGCARD(started.Minutes);
    n := n * secondsPerMinute + LONGCARD(started.Seconds);
    n := n * hundred + LONGCARD(started.Hundredths);
    hmsStart := n;

    n := LONGCARD(ended.Hours)   * minutesPerHour + LONGCARD(ended.Minutes);
    n := n * secondsPerMinute + LONGCARD(ended.Seconds);
    n := n * hundred + LONGCARD(ended.Hundredths);
    hmsEnd := n;

    n:=LONGCARD ( getCountOfDays(started.Day,started.Month,started.Year) );
    v:=started.Year-1;
    FOR i:= baseyear TO v DO
         INC (n, LONGCARD ( getCountOfDays(31,12,i) ) );
    END;
    jmaStart:=n;

    n:=LONGCARD ( getCountOfDays(ended.Day,ended.Month,ended.Year) );
    v:=ended.Year-1;
    FOR i:= baseyear TO v DO
         INC (n, LONGCARD ( getCountOfDays(31,12,i) ) );
    END;
    jmaEnd:=n;

    IF jmaEnd # jmaStart THEN (* assume no more than one day ! *)
        hmsEnd := hmsEnd + midnight;
    END;
    n := hmsEnd-hmsStart; (* always >= 0 *)
    delta.Hours     :=CARDINAL (n DIV (minutesPerHour*secondsPerMinute*hundred) );
    delta.Minutes   :=CARDINAL((n DIV (               secondsPerMinute*hundred) ) MOD 60 );
    delta.Seconds   :=CARDINAL((n DIV (                                hundred) ) MOD 60 );
    delta.Hundredths:=CARDINAL (n MOD hundred);

    R:=strFmtTime;
    Str.Subst(R,"~", fmt(delta.Hours,  10,2,"0",""));
    Str.Subst(R,"~", fmt(delta.Minutes,10,2,"0",""));
    Str.Subst(R,"~", fmt(delta.Seconds,10,2,"0",""));

    RETURN R;
END fmtDelta;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    oneBlock          = 1; (* used when desperate *)
    sectorSize        = 512;
    firstTrack        = 0;
    firstHead         = 0;
    firstSector       = 1;
    firstBlock        = 0; (* 0-based *)
    maxheadcount      = 255; (* yes, 255 and not 256 because we want to avoid MessDOS fatal boot bug *)
CONST
    trackSize         = maxBlocksAtAtime * sectorSize; (* misleading buffer name if not 63 blocks ! *)
TYPE
    trackType         = ARRAY [0..trackSize-1] OF BYTE;
    ptrToTrackType    = POINTER TO trackType;
VAR (* globerks *)
    buffTrack         : trackType;
    pbuffTrack        : ptrToTrackType;

    buffTrackParano   : trackType;
    pbuffTrackParano  : ptrToTrackType;


TYPE
    unitInfoType = RECORD
        unit                : BYTE;

        ENHINT13Havailable  : BOOLEAN; (* TRUE required *)
        EDDmajor            : BYTE;
        EDDflag             : BYTE;

        bytesPerSector      : CARDINAL;
        lastTrackOrg        : CARDINAL;
        lastHeadOrg         : CARDINAL;
        lastSectorOrg       : CARDINAL;
        totalSectorsOrg     : LONGCARD;

        needTHSautorebuild    : BOOLEAN; (* NEWGEOMETRY *)
        perfectTHSautorebuild : BOOLEAN; (* PERFECTGEOMETRY *)

        lastTrack           : CARDINAL;
        lastHead            : CARDINAL;
        lastSector          : CARDINAL;
        lastBlock           : LONGCARD;

        trackcount          : CARDINAL;
        headcount           : CARDINAL;
        sectorcount         : CARDINAL;
        blockcount          : LONGCARD;
    END;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE fmtbignum (base,wi:CARDINAL;v:LONGCARD):str16;
VAR
    i : CARDINAL;
    R:str16;
    ok,lo:BOOLEAN;
    pad,prefix,suffix:CHAR;
BEGIN
    CASE base OF
    | 16: pad:="0";prefix:="$"; suffix:=""; lo:=TRUE;
    ELSE
          pad:=" ";prefix:= ""; suffix:=""; lo:=FALSE;
    END;
    Str.CardToStr ( v, R, base, ok);
    FOR i:=Str.Length(R)+1 TO wi DO Str.Prepend(R,pad);END;
    IF lo THEN Str.Lows(R); END;
    Str.Prepend(R,prefix);Str.Append(R,suffix);
    RETURN R;
END fmtbignum;

PROCEDURE fmtnum (base,wi:CARDINAL;v:CARDINAL):str16;
BEGIN
    RETURN fmtbignum(base,wi,LONGCARD(v));
END fmtnum;

PROCEDURE fmtsegofs (hi,lo:CARDINAL;sepa:CHAR ):str16;
VAR
    R:str16;
BEGIN
    Str.Concat(R, fmtnum(16,4,hi), sepa);
    Str.Append(R, fmtnum(16,4,lo));
    ReplaceChar(R,"$","");
    RETURN R;
END fmtsegofs;

(* ------------------------------------------------------------ *)

PROCEDURE segofs2addr (segment,offset:CARDINAL):LONGCARD;
BEGIN
    RETURN LONGCARD(segment) << 4 + LONGCARD(offset);
END segofs2addr;

(* ssss:oooo to linear address *)

PROCEDURE so2addr (so:LONGCARD):LONGCARD ;
VAR
    segment,offset:LONGCARD;
BEGIN
    segment:=so >> 16;
    offset :=so AND 0000FFFFH;
    RETURN segment << 4 + offset;
END so2addr;

PROCEDURE splitaddr (a:LONGCARD;VAR hi,lo:CARDINAL );
BEGIN
    hi:= CARDINAL(a >> 16);
    lo:= CARDINAL(a AND 0000FFFFH);
END splitaddr;

(* ------------------------------------------------------------ *)

PROCEDURE crosspages (DEBUG:BOOLEAN;a:FarADDRESS; varsize :CARDINAL):BOOLEAN;
VAR
    a1,a2:FarADDRESS;
    page1,page2,lo1,lo2:CARDINAL;
    seg1,seg2,ofs1,ofs2:CARDINAL;

    so1,so2:LONGCARD;
    addr1,addr2:LONGCARD;
    S:str128;
BEGIN
    IF DEBUG THEN WrStr("::: crosspages"+nl);END;

    a1:=a;
    a2:=Lib.AddFarAddr(a1,varsize-1);

    so1:=LONGCARD(a1); (* automagically converted to ssss:oooo *)
    so2:=LONGCARD(a2);

    splitaddr(so1, seg1,ofs1);
    splitaddr(so2, seg2,ofs2);

    addr1:=so2addr(so1); (* ssss:oooo to linear *)
    addr2:=so2addr(so2);
    splitaddr(addr1, page1,lo1);
    splitaddr(addr2, page2,lo2);

    IF DEBUG THEN
        S := ":::   ~..~  ~..~  ~..~";
        Str.Subst(S,"~", fmtbignum(16,8,addr1));
        Str.Subst(S,"~", fmtbignum(16,8,addr2));

        Str.Subst(S,"~", fmtsegofs(CARDINAL(page1),CARDINAL(lo1),"-" ));
        Str.Subst(S,"~", fmtsegofs(CARDINAL(page2),CARDINAL(lo2),"-" ));

        Str.Subst(S,"~", fmtsegofs(CARDINAL(seg1),CARDINAL(ofs1),":" ));
        Str.Subst(S,"~", fmtsegofs(CARDINAL(seg2),CARDINAL(ofs2),":" ));
        WrStr(S);WrLn;
    END;

    RETURN ( page1 # page2 );
END crosspages;

PROCEDURE onsamepage (DEBUG:BOOLEAN;anchor:ptrToTrackType ):BOOLEAN;
VAR
    a1,a2:FarADDRESS;
    page1,page2,lo1,lo2:CARDINAL;
    seg1,seg2,ofs1,ofs2:CARDINAL;

    so1,so2:LONGCARD;
    addr1,addr2:LONGCARD;
    S:str128;
BEGIN
    a1:=FarADDRESS(anchor^);
    a2:=Lib.AddFarAddr(a1,SIZE(ptrToTrackType^)-1);

    so1:=LONGCARD(a1); (* automagically converted to ssss:oooo *)
    so2:=LONGCARD(a2);

    splitaddr(so1, seg1,ofs1);
    splitaddr(so2, seg2,ofs2);

    addr1:=so2addr(so1); (* ssss:oooo to linear *)
    addr2:=so2addr(so2);
    splitaddr(addr1, page1,lo1);
    splitaddr(addr2, page2,lo2);

    IF DEBUG THEN
        S:="[~..~]  ~..~  ~..~";

        Str.Subst(S,"~", fmtbignum(16,8,addr1));
        Str.Subst(S,"~", fmtbignum(16,8,addr2));

        Str.Subst(S,"~", fmtsegofs(CARDINAL(page1),CARDINAL(lo1),"-" ));
        Str.Subst(S,"~", fmtsegofs(CARDINAL(page2),CARDINAL(lo2),"-" ));

        Str.Subst(S,"~", fmtsegofs(CARDINAL(seg1),CARDINAL(ofs1),":" ));
        Str.Subst(S,"~", fmtsegofs(CARDINAL(seg2),CARDINAL(ofs2),":" ));
        WrStr(S);WrLn;
    END;

    RETURN ( page1=page2 );
END onsamepage;

PROCEDURE releaseMem (anchor:ptrToTrackType);
BEGIN
    IF anchor # NIL THEN DEALLOCATE(anchor,SIZE(anchor^)); END;
END releaseMem;

PROCEDURE grabMem (DEBUG,CHECKBOUNDARIES :BOOLEAN):ptrToTrackType;
CONST
    firstbuff = 1;
    lastbuff  = 16;
VAR
    buff : ARRAY [firstbuff..lastbuff] OF ptrToTrackType;
    anchor : ptrToTrackType;
    last,i,wanted:CARDINAL;
BEGIN
    IF DEBUG THEN WrStr("::: grabMem");WrLn;END;
    anchor:=NIL;
    wanted:=SIZE(ptrToTrackType^);
    i:=firstbuff-1;
    LOOP
        INC(i);
        IF i > lastbuff THEN EXIT; END;
        IF Available(wanted)=FALSE THEN
            IF DEBUG THEN WrStr("Storage.Available() returned FALSE !");WrLn;END;
            EXIT;
        END;
        ALLOCATE(buff[i],wanted);
        IF DEBUG THEN WrStr("::: ");WrStr( fmtnum(10,2,i) );WrStr(" @ "); END;

        IF CHECKBOUNDARIES THEN
            IF onsamepage(DEBUG,buff[i]) THEN anchor:=buff[i]; EXIT; END;
        ELSE
            IF DEBUG THEN WrStr("?:?"+nl);END;
            anchor:=buff[i]; EXIT; (* the first one is a good one here *)
        END;
    END;
    DEC(i);
    last:=i;
    FOR i:= firstbuff TO last DO
        DEALLOCATE( buff[i] ,wanted);
    END;
    RETURN anchor;
END grabMem;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* 1310----INT 13 - HARD DISK - CHECK IF DRIVE READY *)

PROCEDURE isUnitReady(DEBUG:BOOLEAN;unit:BYTE):BOOLEAN ;
VAR
    R : SYSTEM.Registers;
    rc:BOOLEAN;
BEGIN
(* IF DEBUG THEN WrStr("::: isUnitReady - Hard disk");WrLn;END; was garbling debug display for nothing *)
    R.AH := 10H;
    R.DL := unit;
    Lib.Intr (R,13H);
    rc:=NOT (SYSTEM.CarryFlag IN R.Flags);
    IF NOT(rc) THEN getFatalStatus(unit,0,FALSE);END;
    RETURN rc;
END isUnitReady;

PROCEDURE waitReady (DEBUG:BOOLEAN; unit:BYTE);
CONST
    maxretry = 3;
VAR
    retry : CARDINAL;
BEGIN
    retry := 0;
    LOOP
        IF isUnitReady(DEBUG,unit) THEN EXIT;END;
        INC(retry);
        IF retry=maxretry THEN EXIT; END;
    END;
END waitReady;

(* ------------------------------------------------------------ *)

(* 1300----INT 13 - DISK - RESET DISK SYSTEM *)
(* 130D----INT 13 - HARD DISK - RESET HARD DISKS *)

PROCEDURE resetUnit (DEBUG,FAKERESET:BOOLEAN;unit:BYTE):BOOLEAN ;
VAR
    R : SYSTEM.Registers;
    rc:BOOLEAN;
BEGIN
IF DEBUG THEN WrStr("::: resetUnit - Hard disk");WrLn;END;
    IF FAKERESET THEN
        rc:=TRUE; (* we won't reset hard disk *)
    ELSE
        R.AH := 0DH; (* reset hard disk *)
        R.DL := unit;
        Lib.Intr (R,13H);
        rc:=NOT (SYSTEM.CarryFlag IN R.Flags);
    END;
    IF NOT(rc) THEN getFatalStatus(unit,0,FALSE);END;
    RETURN rc;
END resetUnit;

(* 1341--BX55AA---INT 13 - IBM/MS INT 13 Extensions - INSTALLATION CHECK *)

PROCEDURE chkExtendedSupport (DEBUG:BOOLEAN; VAR ui:unitInfoType);
VAR
    R : SYSTEM.Registers;
    ok: BOOLEAN;
BEGIN
IF DEBUG THEN WrStr("::: chkExtendedSupport");WrLn;END;
    ok:=FALSE;
    R.AH := 41H; (* installation check *)
    R.BX := 55AAH;
    R.DL := ui.unit;
    Lib.Intr (R,13H);
    IF NOT (SYSTEM.CarryFlag IN R.Flags) THEN
        IF R.BX = 0AA55H THEN
            IF (R.CX AND 0001H)=0001H THEN (* extended disk access functions (AH=42h-44h,47h,48h) supported *)
                ui.EDDmajor:=R.AH;
                ui.EDDflag :=BYTE (R.CX AND 07H); (* we care about bits 0..2 i.e. %111 *)
                ok:=TRUE;
            END;
        END;
    END;
    IF NOT(ok) THEN getFatalStatus(ui.unit,0,FALSE);END;
    ui.ENHINT13Havailable:=ok;
END chkExtendedSupport;

(* 134E----INT 13 - IBM/MS INT 13 Extensions v2.1+ - SET HARDWARE CONFIGURATION *)

PROCEDURE canCallEDD ( EDDmajor,EDDflag:BYTE ):BOOLEAN ;
VAR
    okfunction, okedd:BOOLEAN;
BEGIN

    CASE CARDINAL(EDDmajor) OF
    | 21H,30H : okedd := TRUE;
    | 01H,20H : okedd := FALSE;
    ELSE
                okedd := FALSE;
    END;

    okfunction := ( ( CARDINAL(EDDflag) AND 04H) = 04H ); (* %0100 bit 2=$134E function ok *)

    RETURN ( okfunction AND okedd );
END canCallEDD;

CONST
    cmdPIO         = 02H;
    cmdDMA         = 05H;
    cmdPREFETCH    = 00H;
    eddUseless     = 0;
    eddUnsupported = 1;
    eddError       = 2;
    eddOKsafe      = 3;
    eddOKunsafe    = 4;

PROCEDURE setEDDcfg (DEBUG,YES:BOOLEAN;EDDcmd:BYTE; ui:unitInfoType):CARDINAL;
VAR
    R : SYSTEM.Registers;
    rc:CARDINAL;
BEGIN
IF DEBUG THEN WrStr("::: setEDDcfg");WrLn;END;
    IF NOT (YES) THEN RETURN eddUseless; END;

    IF canCallEDD( ui.EDDmajor, ui.EDDflag)=FALSE THEN
IF DEBUG THEN WrStr(":::   int $134e call is not supported");WrLn;END;
        RETURN eddUnsupported;
    END;

    R.AH := 4EH;
    R.AL := EDDcmd;
    R.DL := ui.unit;
    INCL (R.Flags, SYSTEM.CarryFlag);
    Lib.Intr (R,13H);
    IF NOT (SYSTEM.CarryFlag IN R.Flags) THEN
        (* assume AH is $00 *)
        IF R.AL = 0 THEN
            rc:=eddOKsafe;
        ELSE
            rc:=eddOKunsafe;
        END;
    ELSE
IF DEBUG THEN
    WrStr("::: error code ");
    WrStr( fmt( CARDINAL(R.AH),16,2,"0","$") );WrLn;
END;
        rc:=eddError;
    END;
    RETURN rc;
END setEDDcfg;

(* ------------------------------------------------------------ *)

TYPE
    QWORD = RECORD
        lo:LONGWORD;
        hi:LONGWORD;
    END;
    enhInt13Hinfotype = RECORD
        bufsize         : WORD;   (* always $1A here because v1.x call *)
        flag            : WORD;
        cylinders       : LONGWORD;  (* physical *)
        heads           : LONGWORD;  (* id. *)
        sectorsPerTrack : LONGWORD;  (* id. *)
        totalSectors    : QWORD;
        bytesPerSector  : WORD;
        EDDdata         : LONGWORD;  (* unused because we only call v1.x function *)
    END;

CONST
    rcNoProblemo        = 0;
    rcPhantom           = 1;
    rcInt13HPB          = 2;
    rcEnhInt13HPB       = 3;
    rcEnhInt13HvaluesPB = 4;
    rcWrongTHSgeometry  = 5;

(* 1348----INT 13 - IBM/MS INT 13 Extensions - GET DRIVE PARAMETERS *)
(* 1308----INT 13 - DISK - GET DRIVE PARAMETERS (PC,XT286,CONV,PS,ESDI,SCSI) *)

PROCEDURE chkTHSgeometry (maxTrack,maxHead,maxSector:CARDINAL):BOOLEAN;
VAR
    i,pb,v:CARDINAL;
BEGIN
    pb:=0;
    FOR i:=1 TO 3 DO
        CASE i OF
        | 1: v:=maxTrack;
        | 2: v:=maxHead;
        | 3: v:=maxSector;
        END;
        CASE v OF
        | 0 , MAX(CARDINAL): INC(pb);
        END;
    END;
    RETURN (pb = 0);
END chkTHSgeometry;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE trydiv (VAR q : LONGCARD ;v,d:LONGCARD):BOOLEAN ;
BEGIN
    q := v DIV d;
(*
WrStr("value = ");WrLngCard(v,0);
WrStr("  divisor = ");WrLngCard(d,0);
WrStr("  quotient = ");WrLngCard(q,0);WrLn;
*)
    RETURN ( v = (q * d) );
END trydiv;

CONST
    minfactentry = 0;
    maxfactentry = 1;
    minfactor    = 1;    (* so we can flag using minfactor-1=0 *)
    maxfactor    = 32+1; (* should do for at most 2^32 ! *)
TYPE
    factortype = RECORD
       k    : LONGCARD;
       flag : BOOLEAN;
    END;
VAR
    factor : ARRAY[minfactentry..maxfactentry] , [minfactor..maxfactor] OF factortype;

PROCEDURE factorize (where:CARDINAL; v:LONGCARD):CARDINAL;
VAR
    i,ndx:CARDINAL;
    quotient, divisor,added : LONGCARD;
BEGIN
    ndx:=minfactor-1;
    (* handle trivial cases *)
    IF v = 0 THEN RETURN ndx; END;
    IF v = 1 THEN
        INC(ndx);
        factor[where][ndx].k:=v;
        factor[where][ndx].flag:=TRUE;
        RETURN ndx;
    END;

    FOR i:=1 TO 2 DO
        CASE i OF
        | 1: divisor := 2;
        | 2: divisor := 3;
        END;
        LOOP
            IF trydiv (quotient, v,divisor) THEN
                INC(ndx);
                IF ndx > maxfactor THEN RETURN minfactor-1; END; (* should never happen *)
                factor[where][ndx].k:=divisor;
                factor[where][ndx].flag:=TRUE;
                v:=quotient;
                IF quotient < divisor THEN RETURN ndx; END;
            ELSE
                EXIT;
            END;
        END;
    END;

    (*
    after 2 and 3, gen next prime (5, 7, 11, 13, 17, 19, 23, 25, 29, 31...)
    by adding alternatively 2 then 4 to previous value
    *)

    added := 2;
    INC(divisor,added); (* 3+2=5 *)
    LOOP
        IF trydiv (quotient,v,divisor) THEN
            INC(ndx);
            IF ndx  > maxfactor THEN RETURN minfactor-1; END;
            factor[where][ndx].k   :=divisor;
            factor[where][ndx].flag:=TRUE;
            v:=quotient;
            IF quotient < divisor THEN RETURN ndx; END;
        ELSE
            INC(divisor,added);
            IF added=2 THEN
                added:=4;
            ELSE (* is 4 *)
                added:=2;
            END;
        END;
    END;

    RETURN ndx;
END factorize;

PROCEDURE findinfact (where,ndx:CARDINAL; limit:LONGCARD):LONGCARD;
VAR
    v, k: LONGCARD;
    i : CARDINAL;
BEGIN
    (*
    (* lazy eval : we don't find highest value here *)
    v := 1;
    i := minfactor-1;
    LOOP
        INC(i);
        IF i > ndx THEN EXIT; END;
        IF factor[where][i].flag THEN
            k:=factor[where][i].k;
            IF v * k <= limit THEN
                factor[where][i].flag := FALSE; (* no longer useable *)
                v := v * k;
            ELSE
                EXIT;
            END;
        END;
    END;
    *)
    v := 1;
    i := ndx+1;
    LOOP
        DEC(i);
        IF i < minfactor THEN EXIT; END;
        IF factor[where][i].flag THEN
            k:=factor[where][i].k;
            IF v * k <= limit THEN
                factor[where][i].flag := FALSE; (* no longer useable *)
                v := v * k;
            END;
        END;
    END;
    RETURN v;
END findinfact;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE buildTHSfromTOTAL (VAR maxTrack,maxHead,maxSector:WORD;
                            BESTFIT:CARDINAL;totalSectors:LONGCARD ):BOOLEAN;
CONST
    mintrack      = 0;
    minhead       = 0;
    minsector     = 1;
CONST
    maxsectorcount    = 63;
    maxsectorcountalt = 255; (* desperate try to keep CARDINALs everywhere *)
    maxheadcount      = 255;
    maxtrackcount     = MAX(LONGCARD);
VAR
    rebuilt,v,quotient:LONGCARD;
    t,h,s,smax:LONGCARD;
    headcount,trackcount,sectorcount:CARDINAL;
    retry,ndx,ndxref:CARDINAL;
    rc:BOOLEAN;
BEGIN
    rc:=TRUE;
    retry := 1;
    LOOP
        v:=totalSectors;
        CASE retry OF
        | 1 :
            s:=maxsectorcount; (* try 63 first *)
            IF trydiv(quotient, v,s) THEN
                v:=quotient;
            ELSE
                s:=0;
            END;
            smax := maxsectorcount;
        | 2 :
            s:=0;
            smax := maxsectorcountalt;
        END;
        (*
        FOR now, don't care about BESTFIT which is a BAD idea here
        CASE BESTFIT OF (* should always be FORCEBEST *)
        | FORCEBEST : h:=16;
        | FORCE255:   h:=255;
        | FORCE240:   h:=240;
        ELSE
                      h:=16; (* safety *)
        END;
        *)
        ndx:=factorize(minfactentry,v);

        IF s = 0 THEN s:=findinfact(minfactentry,ndx,smax);END;
        h:=findinfact(minfactentry,ndx,maxheadcount);
        t:=findinfact(minfactentry,ndx,maxtrackcount);

        trackcount  := CARDINAL(t);
        headcount   := CARDINAL(h);
        sectorcount := CARDINAL(s);

        rebuilt     := LONGCARD(trackcount) * LONGCARD(headcount) * LONGCARD(sectorcount); (* safety *)
        IF rebuilt = totalSectors THEN EXIT; END;
        INC(retry);
        IF retry > 2 THEN rc:=FALSE; EXIT; END;
    END;
    maxTrack    := trackcount + mintrack -1;
    maxHead     := headcount  + minhead  -1;
    maxSector   := sectorcount+ minsector-1;
    RETURN rc;
END buildTHSfromTOTAL;

(* ------------------------------------------------------------ *)

PROCEDURE getGeometry (DEBUG,FIXBADTHS:BOOLEAN; BESTFIT:CARDINAL;
                      VAR ui:unitInfoType):CARDINAL;
VAR
    R : SYSTEM.Registers;
    v:enhInt13Hinfotype;
    n,rc:CARDINAL;
    good:BOOLEAN;
BEGIN
IF DEBUG THEN WrStr("::: getGeometry - ENHINT13H");WrLn;END;

    v.bufsize := 1AH; (* $1A v1.x or $1E v2.x *)

    R.AH := 48H; (* get drive parameters *)
    R.DL := ui.unit;
    R.DS := Seg(v); (* was seg(faraddress()) *)
    R.SI := Ofs(v);
    Lib.Intr (R,13H);
    (* IF BYTE(R.AH) = BYTE(00H) THEN *)
    IF NOT (SYSTEM.CarryFlag IN R.Flags) THEN
        (* this is inline getXBIOSvalues() seen in DTHS and VITAL *)
IF DEBUG THEN
    WrStr("::: inline getXBIOSvalues");WrLn;
    WrStr(":::   bytes per sector ");IO.WrCard(v.bytesPerSector,0);WrLn;
    WrStr(":::   cylinders        ");IO.WrLngCard(v.cylinders,0);WrLn;
    WrStr(":::   heads            ");IO.WrLngCard(v.heads,0);WrLn;
    WrStr(":::   sectors          ");IO.WrLngCard(v.sectorsPerTrack,0);WrLn;
    WrStr(":::   total            ");IO.WrLngCard(v.totalSectors.lo,0);WrLn;
END;
        n:=0;
        IF v.bytesPerSector  # WORD(sectorSize)    THEN INC(n);END;
        IF v.cylinders       > LONGWORD(MAX(WORD)) THEN INC(n);END;
        IF v.heads           > LONGWORD(MAX(WORD)) THEN INC(n);END;
        IF v.sectorsPerTrack > LONGWORD(MAX(WORD)) THEN INC(n);END;
        IF n = 0 THEN
            ui.lastTrackOrg   :=WORD( v.cylinders); DEC(ui.lastTrackOrg); (* normalize count for 0..range *)
            ui.lastHeadOrg    :=WORD( v.heads);     DEC(ui.lastHeadOrg);  (* the same *)
            ui.lastSectorOrg  :=WORD( v.sectorsPerTrack);
            ui.bytesPerSector :=WORD( v.bytesPerSector);

            ui.totalSectorsOrg:=v.totalSectors.lo; (* we won't handle more than LONGCARD here *)

            rc:=rcNoProblemo;
        ELSE
            rc:=rcEnhInt13HvaluesPB;
        END;
    ELSE
        rc:=rcEnhInt13HPB;
    END;

IF DEBUG THEN
    WrStr(":::   lasttrackorg     ");IO.WrCard(ui.lastTrackOrg,0);WrLn;
    WrStr(":::   lastheadorg      ");IO.WrCard(ui.lastHeadOrg,0);WrLn;
    WrStr(":::   lastsectororg    ");IO.WrCard(ui.lastSectorOrg,0);WrLn;
END;

    IF rc = rcNoProblemo THEN
        IF chkTHSgeometry(ui.lastTrackOrg,ui.lastHeadOrg,ui.lastSectorOrg) = FALSE THEN
            IF FIXBADTHS THEN
                good:=buildTHSfromTOTAL(ui.lastTrackOrg,ui.lastHeadOrg,ui.lastSectorOrg, BESTFIT,ui.totalSectorsOrg);
                (* //FIXME update cylinders heads sectorsPerTrack ??? *)
                IF good THEN
                    rc:=rcNoProblemo;
                ELSE
                    rc:=rcWrongTHSgeometry;
                END;
            ELSE
                rc:=rcWrongTHSgeometry;
            END;
        END;
    ELSE
        getFatalStatus(ui.unit,0,FALSE);
    END;

    RETURN rc;
END getGeometry;

(*
    first, we try to find headcount (<=highest) and trackcount
    so that their product is v (totalblocks)
    if we fail finding exact values, we rely to headcount=highest
*)

CONST
    FORCEBEST = 0;   (* always but 1 was a better choice as to avoid 0-divide ! *)
    FORCE255  = 255;
    FORCE240  = 240;

PROCEDURE findBestFactors (BESTFIT:CARDINAL;v:LONGCARD;highest:LONGCARD;
                          VAR headcount,trackcount:CARDINAL);
VAR
    a,b : LONGCARD;
    needhack : BOOLEAN;
BEGIN
    needhack := TRUE;
    a        := highest;      (* maxheadcount is 255 *)
    LOOP
(* WrStr("a = ");IO.WrLngCard(a,1);WrLn; *)
        b:=(v DIV a);
(* WrStr("b = ");IO.WrLngCard(b,1);WrLn; *)
        IF (a*b)=v THEN
            needhack := FALSE;
            EXIT;
        END;
        DEC (a);
        IF a < 2 THEN EXIT; END;
    END;
    IF BESTFIT # FORCEBEST THEN needhack:=TRUE; END;
    IF needhack THEN
(* WrStr("BESTFIT = ");IO.WrCard(BESTFIT,1);WrLn; *)
        IF BESTFIT = FORCEBEST THEN BESTFIT := FORCE255; END; (* fix 0-divide *)
        a := LONGCARD(BESTFIT); (* 255 or 240 *)
        b := (v DIV a);
        IF b > MAX(CARDINAL) THEN b:=MAX(CARDINAL);END; (* ugly fix just in case because it should never happen *)
    END;
(* WrStr("a  = ");IO.WrLngCard(a,1);WrLn; *)
(* WrStr("b  = ");IO.WrLngCard(b,1);WrLn; *)
    headcount  := CARDINAL(a);
    trackcount := CARDINAL(b);
(* WrStr("headcount  = ");IO.WrCard(headcount,1);WrLn; *)
(* WrStr("trackcount = ");IO.WrCard(trackcount,1);WrLn; *)
END findBestFactors;

PROCEDURE fixGeometry (DEBUG:BOOLEAN;BESTFIT:CARDINAL; VAR ui:unitInfoType);
VAR
    v:LONGCARD;
BEGIN
IF DEBUG THEN WrStr("::: fixGeometry");WrLn;END;

    (* BESTFIT := FORCEBEST; (* user should not change this setting *) *)

    ui.needTHSautorebuild:=FALSE; (* NEWGEOMETRY *)

    ui.lastTrack   := ui.lastTrackOrg;
    ui.lastHead    := ui.lastHeadOrg;
    ui.lastSector  := ui.lastSectorOrg;

    ui.trackcount := ui.lastTrack  - firstTrack  +1;
    ui.headcount  := ui.lastHead   - firstHead   +1;
    ui.sectorcount:= ui.lastSector - firstSector +1;

    ui.blockcount := LONGCARD(ui.trackcount)*LONGCARD(ui.headcount)*LONGCARD(ui.sectorcount);
    ui.lastBlock  := ui.blockcount + firstBlock  -1;

IF DEBUG THEN
    WrStr(":::   lastTrack        ");IO.WrCard(ui.lastTrack,0);WrLn;
    WrStr(":::   lastHead         ");IO.WrCard(ui.lastHead,0);WrLn;
    WrStr(":::   lastSector       ");IO.WrCard(ui.lastSector,0);WrLn;
    WrStr(":::   lastBlock        ");IO.WrLngCard(ui.lastBlock,0);WrLn;
    WrStr(":::");WrLn;
    WrStr(":::   trackcount       ");IO.WrCard(ui.trackcount,0);WrLn;
    WrStr(":::   headcount        ");IO.WrCard(ui.headcount,0);WrLn;
    WrStr(":::   sectorcount      ");IO.WrCard(ui.sectorcount,0);WrLn;
    WrStr(":::   blockcount       ");IO.WrLngCard(ui.blockcount,0);WrLn;
    WrStr(":::   totalsectorsorg  ");IO.WrLngCard(ui.totalSectorsOrg,0);WrLn;
END;

    ui.needTHSautorebuild := (ui.blockcount # ui.totalSectorsOrg);
    IF ui.needTHSautorebuild THEN
IF DEBUG THEN
    WrLn;
    WrStr("::: rebuilding TxHxS for XBIOS use is needed now...");WrLn;
END;
        (* rebuild THS from totalSectors assuming maxsectororg is correct and trying 256 heads *)
        (* should we assume 255 heads or finds a better matching product ? *)
        ui.blockcount  := ui.totalSectorsOrg;
        ui.lastBlock   := ui.blockcount + firstBlock -1;

        v:=ui.blockcount; (* T*H*S *)
        v:=v DIV LONGCARD(ui.sectorcount); (* T*H *)

        findBestFactors(BESTFIT,v,LONGCARD(maxheadcount), ui.headcount,ui.trackcount);

        ui.lastHead    := ui.headcount  + firstHead  -1;
        ui.lastTrack   := ui.trackcount + firstTrack -1;

IF DEBUG THEN
    WrLn;
    WrStr(":::   lastTrack        ");IO.WrCard(ui.lastTrack,0);WrLn;
    WrStr(":::   lastHead         ");IO.WrCard(ui.lastHead,0);WrLn;
    WrStr(":::   lastSector       ");IO.WrCard(ui.lastSector,0);WrLn;
    WrStr(":::   lastBlock        ");IO.WrLngCard(ui.lastBlock,0);WrLn;
    WrStr(":::");WrLn;
    WrStr(":::   trackcount       ");IO.WrCard(ui.trackcount,0);WrLn;
    WrStr(":::   headcount        ");IO.WrCard(ui.headcount,0);WrLn;
    WrStr(":::   sectorcount      ");IO.WrCard(ui.sectorcount,0);WrLn;
    WrStr(":::   blockcount       ");IO.WrLngCard(ui.blockcount,0);WrLn;
    WrStr(":::   totalsectorsorg  ");IO.WrLngCard(ui.totalSectorsOrg,0);WrLn;
END;
    END;

    v:=LONGCARD(ui.trackcount) * LONGCARD(ui.headcount) * LONGCARD(ui.sectorcount);
    ui.perfectTHSautorebuild := (ui.blockcount = v);

END fixGeometry;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    opRead   = BYTE(02H);
    opWrite  = BYTE(03H);
    opVerify = BYTE(04H);

TYPE
    diskAddressPacketType = RECORD
        packetsize : BYTE;
        reserved   : BYTE; (* must be $00 *)
        count      : WORD; (* number of blocks to transfer: updated after call *)
        (* DWORD : transfer buffer in segment:offset form according to officiel specs *)
        ofsBuf     : WORD;
        segBuf     : WORD;
        startblock : QWORD; (* starting absolute block number *)
        (*
           for non-LBA devices, compute as
           (Cylinder*NumHeads + SelectedHead) * SectorPerTrack +
           SelectedSector - 1
        *)
    END;

(* 1302----INT 13 - DISK - READ SECTOR(S) INTO MEMORY *)
(* 1303----INT 13 - DISK - WRITE DISK SECTOR(S) *)
(* 1304----INT 13 - DISK - VERIFY DISK SECTOR(S) *)
(* 1342----INT 13 - IBM/MS INT 13 Extensions - EXTENDED READ *)
(* 1343----INT 13 - IBM/MS INT 13 Extensions - EXTENDED WRITE *)
(* 1344----INT 13 - IBM/MS INT 13 Extensions - VERIFY SECTORS *)

PROCEDURE XTDrwCHS (unit:BYTE;command:BYTE;block:LONGCARD;
                   count,bufsegment,bufoffset:CARDINAL):BYTE;
VAR
    R : SYSTEM.Registers;
    bcylinder,bsector,LBAcmd,retcode:BYTE;
    dap:diskAddressPacketType;
BEGIN
    CASE command OF
    | opRead   : ;
    | opWrite  : ;
                 (*%F ENABLEREALUPDATE *)
                 command:=opRead; (* don't take chances with hard disk ! *)
                 (*%E  *)
    | opVerify : ;
    ELSE
        RETURN BYTE(0FFH); (* do nothing and force a problem *)
    END;

    dap.packetsize:=10H;
    dap.reserved  :=00H;
    dap.count     :=count;       (* $7f at most ! *)
    dap.segBuf    :=bufsegment;
    dap.ofsBuf    :=bufoffset;
    dap.startblock.lo:=block; (* assume our qword is a longword *)
    dap.startblock.hi:=0;
    CASE command OF
    | opRead:   LBAcmd:=42H;
    | opWrite:  LBAcmd:=43H; R.AL:=00H; (* no verify, and we don't care about v2.1 : maybe we should ? *)
    | opVerify: LBAcmd:=44H;
    END;
    R.AH:=LBAcmd;
    R.DL:=unit;
    R.DS:=Seg(FarADDRESS(dap));
    R.SI:=Ofs(FarADDRESS(dap));
    INCL(R.Flags,SYSTEM.CarryFlag); (* safety *)
    Lib.Intr(R,13H);
    IF NOT (SYSTEM.CarryFlag IN R.Flags) THEN
(*// WrStr("XBIOS ok : ");WrStr( fmt( CARDINAL(R.AH),16,2,"0","$"));WrLn; *)
        retcode:=R.AH; (* assume 00H *)
    ELSE
(*// WrStr("XBIOS PB : ");WrStr( fmt( CARDINAL(R.AH),16,2,"0","$"));WrLn; *)
        retcode:=R.AH;
    END;
    RETURN retcode;
END XTDrwCHS;

PROCEDURE procBlocks (VAR biosRC:BYTE; DEBUG:BOOLEAN;unit:BYTE;opcode:BYTE;block:LONGCARD;
                      wanted,bufsegment,bufoffset:CARDINAL):BOOLEAN;
CONST
    maxretry = 1;
VAR
    rc : BOOLEAN;
    retry : CARDINAL;
BEGIN
    retry := 0;
    LOOP
        biosRC := XTDrwCHS (unit,opcode,block,wanted, bufsegment,bufoffset);
        rc:= ( biosRC = BYTE(00H) );
        IF rc THEN EXIT; END;
        INC(retry);
        IF retry = maxretry THEN EXIT; END;
    END;

    IF NOT(rc) THEN getFatalStatus(unit, biosRC,TRUE); END;

    RETURN rc;
END procBlocks;

(* ------------------------------------------------------------ *)

PROCEDURE doOpBlocks (VAR biosRC:BYTE;
                     DEBUG, DYNALLOC:BOOLEAN;unit:BYTE;op:BYTE;
                     block:LONGCARD;count:CARDINAL) : BOOLEAN;
VAR
    ok : BOOLEAN;
BEGIN
    IF DYNALLOC THEN
        ok := procBlocks(biosRC, DEBUG,unit,op,block,count,
              Seg(pbuffTrack^),Ofs(pbuffTrack^));
    ELSE
        ok := procBlocks(biosRC, DEBUG,unit,op,block,count,
              Seg(buffTrack),Ofs(buffTrack));
    END;
    RETURN ok;
END doOpBlocks;

PROCEDURE doOpBlocksParano (VAR biosRC:BYTE;
                     DEBUG, DYNALLOC:BOOLEAN;unit:BYTE;op:BYTE;
                     block:LONGCARD;count:CARDINAL) : BOOLEAN;
VAR
    ok : BOOLEAN;
BEGIN
    IF DYNALLOC THEN
        ok := procBlocks(biosRC, DEBUG,unit,op,block,count,
              Seg(pbuffTrackParano^),Ofs(pbuffTrackParano^));
    ELSE
        ok := procBlocks(biosRC, DEBUG,unit,op,block,count,
              Seg(buffTrackParano),Ofs(buffTrackParano));
    END;
    RETURN ok;
END doOpBlocksParano;

PROCEDURE buffersMismatch (DYNALLOC:BOOLEAN;count:CARDINAL):BOOLEAN;
VAR
    len,n : CARDINAL;
BEGIN
    len := count * sectorSize;
    IF DYNALLOC THEN
        n:=Lib.Compare(ADR(pbuffTrack^),ADR(pbuffTrackParano^),len);
    ELSE
        n:=Lib.Compare(ADR(pbuffTrack), ADR(pbuffTrackParano) ,len);
    END;
    RETURN (n # len);
END buffersMismatch;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST               (* "1234567890123456789" *)
    strOpened        = "Log opened";
    strClosed        = "Log closed";
    strElapsed       = "Elapsed time"; (* 12 *)
    strCommand       = "Command";
    strSpecified     = "Required"; (* was "To be processed" *)
    strAdjusted      = "Adjusted";
    strNormalized    = "Normalized"; (* real values used when working *)
    strProcessed     = "Processed";
    strUnit          = "Unit";
    strTHS           = "TxHxS";
    strTHSREMINDER   = " (values ignored by program)";
    strTotal         = "Total blocks"; (* 12 *)
    strBlock         = "Block range";
    strEDDplus       = "EDD v2.1+";
CONST
    strSourceRange   = "Source range";
    strTargetRange   = "Target range";
CONST
    strSource        = "(source) ";
    strTarget        = "(target) ";
    strUser          = " (user-defined)";

PROCEDURE getwidef (  ):CARDINAL;
CONST
    widefault = 12; (* should do *)
BEGIN
    RETURN widefault;
END getwidef;

PROCEDURE fmtshow (wi:CARDINAL;S1,S2:ARRAY OF CHAR):str128;
VAR
    i:CARDINAL;
    R:str128;
BEGIN
    Str.Copy(R,S1);
    FOR i:=Str.Length(S1)+1 TO wi DO Str.Append(R," ");END;
    Str.Append(R," : ");
    Str.Append(R,S2);
    Str.Append(R,nl);
    RETURN R;
END fmtshow;

PROCEDURE highestcard (a,b:CARDINAL):CARDINAL;
BEGIN
    IF a < b THEN
        RETURN b;
    ELSE
        RETURN a;
    END;
END highestcard;

PROCEDURE prefixpadstr (VAR R:ARRAY OF CHAR; wi:CARDINAL );
VAR
    i:CARDINAL;
BEGIN
    FOR i:=1 TO wi DO Str.Prepend(R," ");END;
END prefixpadstr;

(* ------------------------------------------------------------ *)

PROCEDURE setBlockRange (VAR userdefined:BOOLEAN;
                        VAR opfirstblock,oplastblock:LONGCARD;
                        blockcount:LONGCARD):BOOLEAN ;
VAR
    ufirstblock,ulastblock:LONGCARD;
    default:BOOLEAN;
BEGIN
    ufirstblock := firstBlock;
    ulastblock  := firstBlock + blockcount -1;

    default:=( ( opfirstblock=UNDEFINEDBLOCK ) AND (oplastblock=UNDEFINEDBLOCK) );
    userdefined:=NOT(default);

    IF default THEN
        opfirstblock := ufirstblock;
        oplastblock  := ulastblock;
    ELSE
        (* we know opfirst <= oplast *)
        IF opfirstblock < ufirstblock THEN RETURN FALSE; END; (* never < 0 ! *)
        IF oplastblock  > ulastblock  THEN RETURN FALSE; END;
    END;
    RETURN TRUE;
END setBlockRange;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    fixeddiskparametersType = RECORD
        cylcount:WORD;
        headcount:BYTE;
        pad1:WORD; (* starting reduced write current cylinder (XT only, 0 for others) *)
        pad2:WORD; (* starting write precompensation cylinder number *)
        pad3:BYTE; (* maximum ECC burst length (XT only) *)
        pad4:BYTE; (* control BYTE *)
        pad5:BYTE; (* standard timeout (XT only, 0 for others) *)
        pad6:BYTE; (* formatting timeout (XT and WD1002 only, 0 for others) *)
        pad7:BYTE; (* timeout for checking drive (XT and WD1002 only, 0 for others) *)
        pad8:WORD; (* cylinder number of landing zone (AT and later only) *)
        sectorcount:BYTE;
        rsvd:BYTE;
    END;

(* see INT 41 - SYSTEM DATA - HARD DISK 0 PARAMETER TABLE ADDRESS [NOT A VECTOR!] *)
(*
    BIOSes which support four hard drives may store the parameter tables
        for drives 81h-83h immediately following the parameter table pointed
        at by INT 41, with a separate copy of the drive 81h table for INT 46.
        The check for such an arrangement is to test whether INT 46 points
        somewhere other than exactly 16 bytes past INT 41, and the sixteen
        bytes starting at offset 10h from INT 41 are identical to the sixteen
        bytes pointed at by INT 46
    another arrangement for BIOSes which support four IDE drives is to have
        four tables pointed at by INT 41 in the order primary master,
        primary slave, secondary master, and secondary slave, in which case
        (for example) a system with only primary master and secondary master
        will have valid tables at offsets 00h and 20h, with garbage (but
        sectors-per-track = 00h) at offsets 10h and 30h
*)

PROCEDURE fmtBIOSgeometry (ALTFORMAT:BOOLEAN; unit:BYTE):str80;
CONST
    sBadGeom = "?x?x?";
VAR
    S:str80;
    a : FarADDRESS;
    table : fixeddiskparametersType;
    R:SYSTEM.Registers;
    c,h,s:CARDINAL;
    v:BYTE;
BEGIN
    CASE unit OF
    | 80H : v:=41H;
    | 81H : v:=46H;
    | 82H : v:=41H;
    | 83H : v:=41H;
    ELSE
        RETURN sBadGeom; (* cannot happen : already trapped ! *)
    END;
    R.AH := 35H;
    R.AL := v;
    Lib.Dos(R);
    a := [R.ES:R.BX];
    CASE unit OF        (* assumption ! *)
    | 82H: Lib.IncAddr(a,SIZE(table));   (* 10H *)
    | 83H: Lib.IncAddr(a,SIZE(table)*2); (* 20H *)
    END;
    Lib.FarMove ( a, FarADR(table), SIZE(table));
    CASE unit OF
    | 82H: IF CARDINAL(table.sectorcount) = 00H THEN RETURN sBadGeom;END;
    | 83H: IF CARDINAL(table.sectorcount) = 00H THEN RETURN sBadGeom;END;
    END;
    c := CARDINAL(table.cylcount);
    h := CARDINAL(table.headcount);
    s := CARDINAL(table.sectorcount);
    RETURN fmtTHS(ALTFORMAT,c,h,s,"x");
END fmtBIOSgeometry;

PROCEDURE showbool (tf:BOOLEAN;S,Y,N:ARRAY OF CHAR);
BEGIN
    WrStr(S);
    IF tf THEN
        WrStr(Y)
    ELSE
        WrStr(N);
    END;
    WrLn;
END showbool;

PROCEDURE rptwr (SKIPLOG:BOOLEAN;F,prefix,S:ARRAY OF CHAR);
VAR
    hnd:FIO.File;
BEGIN
    IF SKIPLOG THEN RETURN;END;
    IF FIO.Exists(F) THEN
        hnd:=FIO.Append(F);
    ELSE
        hnd:=FIO.Create(F);
    END;
    FIO.WrStr(hnd,prefix);FIO.WrStr(hnd,S);
    FIO.Close(hnd);
END rptwr;

PROCEDURE showDbgParms (DEBUG,SHOWTARGET:BOOLEAN;wanted:CARDINAL;
                       currblock,targetcurrblock,remaining:LONGCARD;msg:ARRAY OF CHAR);
VAR
    S:str128;
BEGIN
    IF DEBUG THEN
        video(msg,FALSE);
        IF SHOWTARGET THEN
            S:="block=~  target=~  wanted=~  remaining=~"+nl;
        ELSE
            S:="block=~  wanted=~  remaining=~"+nl;
        END;
        Str.Subst(S,"~",fmtlc(currblock,10,wiblock," ",""));
        IF SHOWTARGET THEN
            Str.Subst(S,"~",fmtlc(targetcurrblock,10,wiblock," ",""));
        END;
        Str.Subst(S,"~",fmt(wanted,10,wiwanted," ",""));
        Str.Subst(S,"~",fmtlc(remaining,10,wiblock," ",""));
        WrStr(S);
        video(msg,TRUE);
    END;
END showDbgParms;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE doCmdParms (DEBUG,ALTFORMAT,SKIPLOG:BOOLEAN;
                     ui:unitInfoType; prefix:ARRAY OF CHAR);
VAR
    R,RR, S,STR : str128;
    total:LONGCARD;
    wi:CARDINAL;
BEGIN
IF DEBUG THEN
    WrStr("::: doCmdParms");WrLn;
    showbool(ui.ENHINT13Havailable   ,":::   XBIOS available  ","yes","no");
    showbool(ui.needTHSautorebuild   ,":::   THS autorebuilt  ","yes","no");
    showbool(ui.perfectTHSautorebuild,":::   perfect geometry ","yes","no");
    WrLn;
    WrStr(":::   blockcount       ");IO.WrLngCard(ui.blockcount,0);WrLn;
    WrStr(":::   totalsectorsorg  ");IO.WrLngCard(ui.totalSectorsOrg,0);WrLn;

    (* redundant with PERFECTGEOMETRY *)
    total:=LONGCARD(ui.lastTrack-firstTrack+1)*LONGCARD(ui.lastHead-firstHead+1)*LONGCARD(ui.lastSector-firstSector+1);
    WrStr(":::   totalsectors     ");IO.WrLngCard(total,0);WrLn;
    showbool( (ui.blockcount # total),":::   mismatch         ","yes","no");
END;

    wi:=getwidef()+Str.Length(prefix);

    Str.Concat(STR,prefix,strUnit);
    Str.Copy(S,fmt( CARDINAL(ui.unit),16,2,"0","$"));
    R:=fmtshow(wi,STR,S);
    WrStr(R);   rptwr(SKIPLOG,LOGFILE,sINFO,R);

    Str.Concat(STR,prefix,strBlock);
    R:=fmtshow(wi,STR, fmtrangelc(LONGCARD(firstBlock),  ui.lastBlock));
    WrStr(R);   rptwr(SKIPLOG,LOGFILE,sINFO,R);

    Str.Concat(STR,prefix,strTotal);
    IF NOT(ALTFORMAT) THEN
        R:=fmtshow(wi,STR,beautifiedlc(ui.blockcount," ",sepdot,wiblock));
    ELSE
        R:=fmtshow(wi,STR,fmtlc(ui.blockcount,10,0,"",""));
    END;
    WrStr(R);   rptwr(SKIPLOG,LOGFILE,sINFO,R);

    Str.Concat(STR,prefix,strTHS);
    Str.Concat(RR, fmtTHS(ALTFORMAT,ui.trackcount,ui.headcount,ui.sectorcount,"x") , strTHSREMINDER);
    R:=fmtshow(wi,STR, RR );
    WrStr(R);   rptwr(SKIPLOG,LOGFILE,sINFO,R);

    Str.Concat(STR,prefix,strEDDplus);
    IF canCallEDD(ui.EDDmajor,ui.EDDflag) THEN
        R:=fmtshow(wi,STR,"yes (as reported by BIOS even if actually unsupported)");
    ELSE
        R:=fmtshow(wi,STR,"no");
    END;
    WrStr(R);   rptwr(SKIPLOG,LOGFILE,sINFO,R);

END doCmdParms;

(* ------------------------------------------------------------ *)

CONST
    geomSame              = 0;
    geomTargetSmaller     = 1;
    geomTargetBigger      = 2;
    geomUserFit           = 3;
    geomUserPartial       = 4;
    geomUserNope          = 5;
CONST
    geomBackupFit         = 6;
    geomBackupMisfitSrc   = 7;
    geomBackupMisfitDst   = 8;
    geomBackupOverlap     = 9;

PROCEDURE getGeometriesFriendly (VAR R:ARRAY OF CHAR;i:CARDINAL);
CONST
    sDefault      = "With default range, ";
    sUser         = "With user-defined range, ";
    sGood         = "cloning should work.";
    sGoodBig      = "cloning to bigger target should work.";
    sPartial      = "partial cloning would require -z option.";
    sPartialSmall = "partial cloning to smaller target would require -z option.";
    sBad          = "cloning is impossible.";
CONST
    (* sUserBackup      = "With user-specified values, "; (* an empty string would not accept concatenation ! YATB ! *) *)
    sBackupFit       = "Copying should work.";
    sBackupMisfitSrc = "Source block range would not fit source unit geometry !";
    sBackupMisfitDst = "Target block range would not fit target unit geometry !";
    sBackupOverlap   = "Target block range would overwrite source block range !";
VAR
    S:str128;
BEGIN
    CASE i OF
    | geomSame:              S:=sINFO   +sDefault+sGood;
    | geomTargetSmaller:     S:=sWARN   +sDefault+sPartialSmall;
    | geomTargetBigger:      S:=sINFO   +sDefault+sGoodBig;
    | geomUserFit:           S:=sINFO   +sUser   +sGood;
    | geomUserPartial:       S:=sWARN   +sUser   +sPartial;
    | geomUserNope:          S:=sPROBLEM+sUser   +sBad;

    | geomBackupFit:         S:=sINFO   +sBackupFit;
    | geomBackupMisfitSrc:   S:=sPROBLEM+sBackupMisfitSrc;
    | geomBackupMisfitDst:   S:=sPROBLEM+sBackupMisfitDst;
    | geomBackupOverlap:     S:=sPROBLEM+sBackupOverlap;
    END;
    Str.Copy(R,S);
END getGeometriesFriendly;

(* ------------------------------------------------------------ *)

PROCEDURE chkGeometries (VAR userdefined:BOOLEAN;
                        VAR newfirstblock,newlastblock:LONGCARD;
                        VAR opfirstblock,oplastblock:LONGCARD;
                        sourceblockcount,targetblockcount:LONGCARD):CARDINAL;
VAR
    rc:CARDINAL;
    default:BOOLEAN;
    srclast,dstlast,ufirst,ulast:LONGCARD;
BEGIN
    srclast :=firstBlock + sourceblockcount -1;
    dstlast :=firstBlock + targetblockcount -1;

    default:=( ( opfirstblock=UNDEFINEDBLOCK ) AND (oplastblock=UNDEFINEDBLOCK) );
    userdefined:=NOT(default);

    IF default THEN
        opfirstblock := firstBlock;  oplastblock  := srclast;
        ufirst       := firstBlock;  ulast        := srclast;
        IF targetblockcount = sourceblockcount THEN
            rc:=geomSame;
        ELSIF targetblockcount < sourceblockcount THEN
            rc:=geomTargetSmaller;   ulast        := dstlast;
        ELSE
            rc:=geomTargetBigger;
        END;
    ELSE
        IF targetblockcount < sourceblockcount THEN
            ulast := dstlast;
        ELSE
            ulast := srclast;
        END;
        IF opfirstblock > ulast THEN
            rc:=geomUserNope;
            (* u values won't be used *)
            ufirst:=opfirstblock;
            ulast :=oplastblock;
        ELSE
            ufirst := opfirstblock;
            (* we know opfirst <= oplast *)
            IF oplastblock > ulast THEN
                rc:=geomUserPartial;
            ELSE
                rc:=geomUserFit;     ulast       := oplastblock;
            END;
        END;
    END;
    newfirstblock := ufirst;
    newlastblock  := ulast;
    RETURN rc;
END chkGeometries;

PROCEDURE aboutGeometries (SKIPLOG:BOOLEAN;wiprefix:CARDINAL;
                          opfirstblock,oplastblock,
                          sourceblockcount,targetblockcount:LONGCARD);
VAR
    wi,rc:CARDINAL;
    userdefined:BOOLEAN;
    R,S:str128;
    newfirstblock,newlastblock:LONGCARD;
BEGIN
    wi:=getwidef();

    rc:=chkGeometries (userdefined,
                      newfirstblock,newlastblock,opfirstblock,oplastblock,
                      sourceblockcount,targetblockcount);

    Str.Copy(S, fmtrangelc (opfirstblock,oplastblock) );
    IF userdefined THEN Str.Append(S,strUser);END;
    R:=fmtshow(wi,strSpecified,S);
    prefixpadstr(R,wiprefix);
    WrStr(R);      rptwr(SKIPLOG,LOGFILE,sINFO,R);

    CASE rc OF
    | geomTargetSmaller, geomUserPartial :
        R:=strAdjusted;
    ELSE
        R:=strNormalized; (* useless confirmation *)
    END;
    Str.Copy(S, fmtrangelc (newfirstblock,newlastblock) );
    R:=fmtshow(wi,R,S);
    prefixpadstr(R,wiprefix);
    WrStr(R);  rptwr(SKIPLOG,LOGFILE,sINFO,R);

    getGeometriesFriendly(R, rc); Str.Append(R,nl);
    WrLn;
    WrStr(R);      rptwr(SKIPLOG,LOGFILE,"",R);
END aboutGeometries;

(* ------------------------------------------------------------ *)

(* if same unit, we just check [dstfirst..dstlast] is out [srcfirst..srclast] *)

PROCEDURE chkOverlap (usrc,udst:BYTE;
                     srcfirst,srclast,dstfirst:LONGCARD ):BOOLEAN;
VAR
    count,dstlast:LONGCARD;
BEGIN
    IF usrc # udst THEN RETURN TRUE; END; (* different units is ok *)
    count  := srclast-srcfirst+1;
    dstlast:= dstfirst+count-1;
    IF dstlast < srcfirst THEN RETURN TRUE; END; (* --dstlast--srcfirst-- *)
    IF dstfirst > srclast THEN RETURN TRUE; END; (* --srclast--dstfirt-- *)
    (* one of dstfirst,dstlast is within [srcfirst..srclast] *)
    RETURN FALSE; (* --srcfirst--dstlast-- and --dstfirst--srclast-- *)
END chkOverlap;

(*
    check [firstblock..lastblock] is within [ufirst..ulast]
    ufirst--firstblock--lastblock--ulast
    assume lower <= upper for both
*)

PROCEDURE chkSubRange (firstblock,lastblock:LONGCARD; u:unitInfoType):BOOLEAN;
VAR
    drivefirstblock,drivelastblock:LONGCARD;
    rc:BOOLEAN;
BEGIN
    drivefirstblock := firstBlock; (* 0-based convention *)
    (* //FIXME 8-UNG ! we asume u.blockcount is ok, as clone does *)
    drivelastblock  := u.blockcount + firstBlock -1;

    rc:=FALSE;
    IF firstblock >= drivefirstblock THEN
        IF lastblock <= drivelastblock THEN rc:=TRUE;END;
    END;

    (*
    O&O : overkill and overcomplicated !
    IF firstblock <  drivefirstblock THEN RETURN FALSE; END;
    IF firstblock >  drivelastblock  THEN RETURN FALSE; END;
    (* firstblock belongs to [drivefirstblock..drivelastblock] *)

    IF lastblock  <  drivefirstblock THEN RETURN FALSE; END; (* already trapped because first<=last *)
    IF lastblock  >  drivelastblock  THEN RETURN FALSE; END;
    (* lastblock belongs to [drivefirstblock..drivelastblock] too *)

    RETURN TRUE; (* assume firstblock <= lastblock *)
    *)

    RETURN rc;
END chkSubRange;

PROCEDURE chkGeometriesAdv (VAR optargetlastblock:LONGCARD;
                            opfirstblock,oplastblock,optargetfirstblock:LONGCARD;
                            uisrc,uidst:unitInfoType):CARDINAL;
VAR
    count:LONGCARD;
BEGIN
    (* must be computed first ! *)
    count := oplastblock-opfirstblock+1;
    optargetlastblock := optargetfirstblock+count-1;

    (* check source range fits source unit geometry *)
    IF chkSubRange(opfirstblock,oplastblock,uisrc)=FALSE THEN
        RETURN geomBackupMisfitSrc;
    END;

    (* check target range fits target unit geometry *)
    IF chkSubRange(optargetfirstblock,optargetlastblock,uidst)=FALSE THEN
        RETURN geomBackupMisfitDst;
    END;

    IF chkOverlap (uisrc.unit,uidst.unit,
                  opfirstblock,oplastblock,optargetfirstblock)=FALSE THEN
        RETURN geomBackupOverlap;
    END;

    RETURN geomBackupFit;
END chkGeometriesAdv;

(* "adv" because -backup is an "advanced" (i.e. less restrictive and more dangerous) -clone *)

PROCEDURE aboutGeometriesAdv (SKIPLOG:BOOLEAN;wiprefix:CARDINAL;
                             opfirstblock,oplastblock,optargetfirstblock:LONGCARD;
                             usource,utarget:unitInfoType);
VAR
    rc,wi:CARDINAL;
    R,S:str128;
    optargetlastblock:LONGCARD;
BEGIN
    wi:=getwidef();

    rc:=chkGeometriesAdv (optargetlastblock,
                         opfirstblock,oplastblock,optargetfirstblock,
                         usource,utarget);

    Str.Copy(S, fmtrangelc (opfirstblock,oplastblock) );
    R:=fmtshow(wi,strSourceRange,S);
    prefixpadstr(R,wiprefix);
    WrStr(R);      rptwr(SKIPLOG,LOGFILE,sINFO,R);

    Str.Copy(S, fmtrangelc (optargetfirstblock,optargetlastblock) );
    R:=fmtshow(wi,strTargetRange,S);
    prefixpadstr(R,wiprefix);
    WrStr(R);      rptwr(SKIPLOG,LOGFILE,sINFO,R);

    getGeometriesFriendly(R, rc); Str.Append(R,nl);
    WrLn;
    WrStr(R);      rptwr(SKIPLOG,LOGFILE,"",R);
END aboutGeometriesAdv;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    numplaceholder     = "~";
    percentplaceholder = "|";
    SAMEBLOCK          = MAX(LONGCARD); (* safety *)

PROCEDURE initCompletion (VAR orgmsg,msg:ARRAY OF CHAR;
                         REALLY,SHOWPERCENT,SHOWPERCENTONLY:BOOLEAN;
                         currblock,targetcurrblock:LONGCARD;wiblock:INTEGER;sepdot:CHAR;
                         opstr:ARRAY OF CHAR  );
CONST
    zeropercent = "0%";
BEGIN
    IF SHOWPERCENTONLY THEN
        Str.Copy(orgmsg,percentplaceholder);
    ELSE
        Str.Copy(orgmsg,opstr);
        IF SHOWPERCENT THEN Str.Append(orgmsg," ("+percentplaceholder+")"); END;
    END;
    IF NOT(REALLY) THEN Str.Append(orgmsg,sFAKE);END;
    Str.Copy(msg,orgmsg);
    Str.Subst(msg,numplaceholder    , beautifiedlc(currblock," ",sepdot,wiblock));
    Str.Subst(msg,numplaceholder    , beautifiedlc(targetcurrblock," ",sepdot,wiblock));
    Str.Subst(msg,percentplaceholder, zeropercent);
    video(msg,TRUE); (* let's handle it *)
END initCompletion;

PROCEDURE showCompletion (VAR msg:ARRAY OF CHAR;
                         currblock,targetcurrblock,opfirstblock,totalblockcount:LONGCARD;
                         wiblock:INTEGER;sepdot:CHAR;orgmsg:ARRAY OF CHAR);
BEGIN
     video(msg,FALSE); (* let's handle it *)
     Str.Copy(msg,orgmsg);
     Str.Subst(msg,numplaceholder    , beautifiedlc(currblock," ",sepdot,wiblock));
     Str.Subst(msg,numplaceholder    , beautifiedlc(targetcurrblock," ",sepdot,wiblock));
     Str.Subst(msg,percentplaceholder, fmtpercentage(opfirstblock,currblock,totalblockcount) );
     video(msg,TRUE) (* let's handle it *)
END showCompletion;

(* ------------------------------------------------------------ *)

CONST
    sNOERRORSOFAR = sOK+"No error found so far.";
    sCOMPLETE     = sOK+"Operation complete.";
    sNOERROR      = sOK+"No error found.";

PROCEDURE strRange (VAR S:ARRAY OF CHAR;p:LONGCARD;n:CARDINAL);
BEGIN
    Str.Subst(S,"~",fmtlc(p,10,0,"",""));
    Str.Subst(S,"~",fmtlc(p+LONGCARD(n)-1,10,0,"",""));
END strRange;

(* ------------------------------------------------------------ *)

PROCEDURE doCmdVerify (DEBUG,ALTFORMAT,SKIPLOG,IGNOREFATAL,WINWARN,MODEWARN,
                      VEREADFY,SHOWPERCENT,SHOWPERCENTONLY,DESPERATE:BOOLEAN;
                      opfirstblock,oplastblock:LONGCARD;ui:unitInfoType) : CARDINAL;
VAR
    pb:LONGCARD;
    updateFreq,currblock,remaining,maxWanted,totalblockcount,thisblock : LONGCARD;
    fuwi,alcatraz,ok : BOOLEAN;
    wanted:CARDINAL;
    unit,op,biosRC : BYTE;
    wi,chkrounds,rc : CARDINAL;
    S,orgmsg,msg:str128;
    userdefined:BOOLEAN;
    dtStart,dtEnd:DTtype;
BEGIN
    IF setBlockRange(userdefined,opfirstblock,oplastblock,ui.blockcount)=FALSE THEN
        RETURN errBlockRange;
    END;

    wi:=getwidef();

    GetDateTimeNow(dtStart);
    S:=fmtshow(wi,strOpened,fmtDateTimeUS(dtStart) );
    Str.Prepend(S,nl+sINFO);
    rptwr(SKIPLOG,LOGFILE,"",S);
    IF WINWARN  THEN rptwr(SKIPLOG,LOGFILE,"",sBADideaWin);END;
    IF MODEWARN THEN rptwr(SKIPLOG,LOGFILE,"",sBADideaMode);END;

    doCmdParms (DEBUG,ALTFORMAT,SKIPLOG,ui,"");

    IF VEREADFY THEN
        msg:="Verify (read)";
    ELSE
        msg:="Verify";
    END;
    S:=fmtshow(wi,strCommand,msg);
    WrStr(S);   rptwr(SKIPLOG,LOGFILE,sINFO,S);

    Str.Copy(msg,fmtrangelc (opfirstblock,oplastblock) );
    IF userdefined THEN Str.Append(msg,strUser);END;
    S:=fmtshow(wi,strSpecified,msg );
    WrStr(S);   rptwr(SKIPLOG,LOGFILE,sINFO,S);

    unit  := ui.unit;
    IF VEREADFY THEN
        op:= opRead;
    ELSE
        op:= opVerify;
    END;

    maxWanted := LONGCARD (maxBlocksAtAtime);
    updateFreq:= LONGCARD (defaultUpdateFreq);
    remaining := oplastblock - opfirstblock +1; totalblockcount:=remaining;
    currblock := opfirstblock;

    pb        := 0;
    chkrounds := 0;
    alcatraz  := FALSE;

    initCompletion (orgmsg,msg,
                   TRUE,SHOWPERCENT,SHOWPERCENTONLY,
                   currblock,SAMEBLOCK,wiblock,sepdot,
                   "Verifying blocks from ~");
    LOOP
        IF remaining = 0 THEN EXIT; END;
        IF remaining > maxWanted THEN
            wanted    := CARDINAL(maxWanted);
            DEC (remaining,maxWanted);
        ELSE
            wanted    := CARDINAL(remaining);
            remaining := 0;
        END;

        showDbgParms(DEBUG,FALSE,wanted,currblock,currblock,remaining,msg);
(* v1.0h : avoid isl342
IF DEBUG THEN
   video(msg,FALSE);
   S:="block=~  wanted=~  remaining=~"+nl;
   Str.Subst(S,"~",fmtlc(currblock,10,wiblock," ",""));
   Str.Subst(S,"~",fmt(wanted,10,wiblock," ",""));
   Str.Subst(S,"~",fmtlc(remaining,10,wiblock," ",""));
   WrStr(S); (* nl here *)
   video(msg,TRUE);
END;
*)
        waitReady(DEBUG,unit);

        ok:=doOpBlocks(biosRC, DEBUG,DYNALLOC,unit,op,currblock,wanted);

(*%T TESTING *) IF Lib.RAND() < 0.02 THEN ok:=FALSE; END; (*%E *)

        IF NOT(ok) THEN
            fuwi:=DESPERATE;
            IF fuwi THEN (* retry one block at a time, fake IGNOREFATAL=TRUE *)
                FOR thisblock := currblock TO (currblock+LONGCARD(wanted)-1) DO
                    (* //FIXME okread is supposed to warrant read will always be ok *)
                    (*
                    unit  := ui.unit;
                    IF VEREADFY THEN
                        op:= opRead;
                    ELSE
                        op:= opVerify;
                    END;
                    *)
                    waitReady(DEBUG,unit);

                    ok:=doOpBlocks(biosRC, DEBUG,DYNALLOC,unit,op,thisblock,oneBlock);

                    IF NOT(ok) THEN
                        INC(pb);
                        S:=sPROBLEM+"Error ~ verifying block ~"+nl;
                        Str.Subst(S,"~",fmt( CARDINAL(bFatalStatusCode),16,2,"0","$") );
                        Str.Subst(S,"~",fmtlc(thisblock,10,0,"",""));
                        rptwr(SKIPLOG,LOGFILE,"",S);
                        video(msg,FALSE); WrStr(S); video(msg,TRUE);
                        (*
                        buildCLI(sBATCH, usource.unit,utarget.unit,thisblock,oneBlock);
                        rptwr(SKIPLOG,LOGFILE,"",sBATCH);
                        *)
                    END;
                END;
            ELSE
                INC(pb);
                S:=sPROBLEM+"Error ~ verifying blocks from [~..~]"+nl;
                Str.Subst(S,"~",fmt( CARDINAL(bFatalStatusCode),16,2,"0","$") );
                strRange(S,currblock,wanted);
                rptwr(SKIPLOG,LOGFILE,"",S);
                video(msg,FALSE); WrStr(S); video(msg,TRUE);
                IF IGNOREFATAL=FALSE THEN
                    video(msg,FALSE);
                    RETURN errFatal;
                END;
            END;
        END;

        INC(chkrounds);
        IF (chkrounds MOD CHKEVERY) = 0 THEN chkrounds:=0;alcatraz:=ChkEscape(); END;
        IF alcatraz THEN EXIT; END;

        INC(currblock,LONGCARD(wanted));

        IF (currblock MOD updateFreq) = 0 THEN
            showCompletion (msg,
                           currblock,SAMEBLOCK,opfirstblock,totalblockcount,
                           wiblock,sepdot,orgmsg);
        END;
    END;
    video(msg,FALSE);

    IF alcatraz THEN
        S:=sCANCELLED+"Operation aborted by user while verifying blocks from [~..~]"+nl;
        strRange(S,currblock,wanted);
        IF pb=0 THEN
            msg:=sNOERRORSOFAR+nl;
            rc:=errAborted;
        ELSE
            msg:=sPROBLEM+"At least ~ error(s) found so far !"+nl;
            Str.Subst(msg,"~",fmtlc(pb,10,0,"",""));
            rc:=errVerifyFailure;
        END;
    ELSE
        S:=sCOMPLETE+nl;
        IF pb=0 THEN
            msg:=sNOERROR+nl;
            rc:=errNone;
        ELSE
            msg:=sPROBLEM+"At least ~ error(s) found !"+nl;
            Str.Subst(msg,"~",fmtlc(pb,10,0,"",""));
            rc:=errVerifyFailure;
        END;
    END;

    WrStr(S);   rptwr(SKIPLOG,LOGFILE,"",S);
    WrStr(msg); rptwr(SKIPLOG,LOGFILE,"",msg);

    GetDateTimeNow(dtEnd);
    S:=fmtshow(wi,strClosed,fmtDateTimeUS(dtEnd) );
    rptwr(SKIPLOG,LOGFILE,sINFO,S);

    S:=fmtshow(wi,strElapsed,fmtDelta(dtStart,dtEnd) );
    rptwr(SKIPLOG,LOGFILE,sINFO,S);

    RETURN rc;
END doCmdVerify;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE getkbd (VAR c1,c2:CHAR);
BEGIN
    BiosFlushkey(); (* useless against DOSKEY ! *)
    BiosWaitkey(c1,c2);
END getkbd;

(* we can use video here because we know redirection cannot happen here *)

PROCEDURE ShallWeProceed (firsttime:BOOLEAN; src:ARRAY OF CHAR):BOOLEAN;
CONST
    acceptA = "<^F9>"; acceptA1 = CHR(0); acceptA2 = CHR(102);
    acceptB = "<^F1>"; acceptB1 = CHR(0); acceptB2 = CHR(94);
VAR
    S : str128;
    c1,c2 , expected1,expected2:CHAR;
BEGIN
    CASE firsttime OF
    | TRUE:
        IF same(src,"") THEN
            S:=sNOTICE+acceptA+" to perform requested operation : ";
        ELSE
            Str.Concat(S,sNOTICE+acceptA+" to update <target> with ",src);
            Str.Append(S," : " );
        END;
        expected1:=acceptA1;
        expected2:=acceptA2;
    | FALSE:
        IF same(src,"") THEN
            S:=sNOTICE+"Now, "+acceptB+" to _perform_ requested operation : ";
        ELSE
            Str.Concat(S,sNOTICE+"Now, "+acceptB+" to _update_ <target> with ",src);
            Str.Append(S," : " );
        END;
        expected1:=acceptB1;
        expected2:=acceptB2;
    END;
    video(S,TRUE);
    getkbd(c1,c2);
    video(S,FALSE);
    IF ((c1=expected1) AND (c2=expected2) ) THEN
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END ShallWeProceed;

PROCEDURE queryUser (AUTOCONFIRM:BOOLEAN;msg,src:ARRAY OF CHAR):BOOLEAN;
VAR
    letsdoit:BOOLEAN;
BEGIN
    IF AUTOCONFIRM THEN
        letsdoit := TRUE;
    ELSE
        (* WrStr(msg);WrLn; *)
        letsdoit := FALSE;
        IF ShallWeProceed(TRUE, src) THEN
            IF ShallWeProceed(FALSE, src) THEN
                (* dmp(sINFO+"Update confirmed twice !"); *)
                letsdoit:=TRUE;
            ELSE
                WrStr(sCANCELLED+"Operation cancelled"+nl); (* " at second thought" *)
            END;
        ELSE
            WrStr(sCANCELLED+"Operation cancelled"+nl);
        END;
    END;
    RETURN letsdoit;
END queryUser;

(* //FIXME command line should probably be changed now ! *)

PROCEDURE buildCLI (VAR R:ARRAY OF CHAR;
                   usource,utarget:BYTE;block:LONGCARD;count:CARDINAL);
BEGIN
    (* "uclone -c $80 $81 -apply -yes 344516,1" *)
    Str.Copy(R,sCLI+progEXEname+" -c ~ ~ -apply -yes ~,~");
    Str.Subst(R,"~",fmt( CARDINAL(usource),16,2,"0","$") );
    Str.Subst(R,"~",fmt( CARDINAL(utarget),16,2,"0","$") );
    Str.Subst(R,"~",fmtlc(block,10,0,"",""));
    Str.Subst(R,"~",fmt( count,10,0,"",""));
END buildCLI;

PROCEDURE buildCLIcopy (VAR R:ARRAY OF CHAR;
                       usource,utarget:BYTE;block,targetblock:LONGCARD;count:CARDINAL);
BEGIN
    (* "uclone -b $80 $81 -apply -yes 344516,1 999999" *)
    Str.Copy(R,sCLI+progEXEname+" -b ~ ~ -apply -yes ~,~ ~");
    Str.Subst(R,"~",fmt( CARDINAL(usource),16,2,"0","$") );
    Str.Subst(R,"~",fmt( CARDINAL(utarget),16,2,"0","$") );
    Str.Subst(R,"~",fmtlc(block,10,0,"",""));
    Str.Subst(R,"~",fmt( count,10,0,"",""));
    Str.Subst(R,"~",fmtlc(targetblock,10,0,"",""));
END buildCLIcopy;

(* ------------------------------------------------------------ *)

PROCEDURE doCmdClone  (DEBUG,ALTFORMAT,SKIPLOG,IGNOREFATAL,WINWARN,MODEWARN,
                      REALLY,AUTORANGE,AUTOCONFIRM,DESPERATE,PARANO,SHOWPERCENT,SHOWPERCENTONLY:BOOLEAN;
                      opfirstblock,oplastblock:LONGCARD;
                      usource,utarget:unitInfoType) : CARDINAL;
VAR
    i : CARDINAL;
    pb,pbRd,pbWr:LONGCARD;
    updateFreq,currblock,remaining,maxWanted,thisblock,totalblockcount : LONGCARD;
    alcatraz,ok, okread, fuwi : BOOLEAN;
    wanted:CARDINAL;
    unit,op,biosRC : BYTE;
    wi,chkrounds,rc : CARDINAL;
    S,orgmsg,msg,sBATCH:str128;
    userdefined:BOOLEAN;
    newfirstblock,newlastblock,orgfirstblock,orglastblock:LONGCARD;
    dtStart,dtEnd:DTtype;
BEGIN
    orgfirstblock:=opfirstblock;
    orglastblock :=oplastblock;
    rc:=chkGeometries (userdefined,
                      newfirstblock,newlastblock,orgfirstblock,orglastblock,
                      usource.blockcount,utarget.blockcount);
    CASE rc OF
    | geomUserNope:
         RETURN errCannotClone;
    | geomTargetSmaller,geomUserPartial:
         IF NOT(AUTORANGE) THEN RETURN errCannotClone;END;
    | geomSame,geomTargetBigger,geomUserFit:
         ;
    END;

    wi:=getwidef();

    GetDateTimeNow(dtStart);
    S:=fmtshow(wi,strOpened,fmtDateTimeUS(dtStart) );
    Str.Prepend(S,nl+sINFO);
    rptwr(SKIPLOG,LOGFILE,"",S);
    IF WINWARN  THEN rptwr(SKIPLOG,LOGFILE,"",sBADideaWin);END;
    IF MODEWARN THEN rptwr(SKIPLOG,LOGFILE,"",sBADideaMode);END;

    doCmdParms (DEBUG,ALTFORMAT,SKIPLOG,usource,strSource);
    WrLn;
    doCmdParms (DEBUG,ALTFORMAT,SKIPLOG,utarget,strTarget);
    WrLn;
    i:=highestcard( Str.Length(strSource), Str.Length(strTarget) );
    aboutGeometries (SKIPLOG,i,opfirstblock,oplastblock,
                    usource.blockcount,utarget.blockcount);

    IF queryUser (AUTOCONFIRM,sWARN+"Ready to clone disk","") = FALSE THEN RETURN errAborted;END;

    (* okay, let's try and clone those damn disks *)

    opfirstblock:=newfirstblock;
    oplastblock :=newlastblock;

    msg:="Clone";
    S:=fmtshow(wi,strCommand,msg);
    WrStr(S);   rptwr(SKIPLOG,LOGFILE,sINFO,S);

    Str.Copy(msg,fmtrangelc (opfirstblock,oplastblock) );
    S:=fmtshow(wi,strProcessed,msg );
    WrStr(S);   rptwr(SKIPLOG,LOGFILE,sINFO,S);

    maxWanted := LONGCARD (maxBlocksAtAtime);
    updateFreq:= LONGCARD (defaultUpdateFreq);
    remaining := oplastblock - opfirstblock +1; totalblockcount:=remaining;
    currblock := opfirstblock;

    pb        := 0;
    pbRd      := 0;
    pbWr      := 0;
    chkrounds := 0;
    alcatraz  := FALSE;

    initCompletion (orgmsg,msg,
                   REALLY,SHOWPERCENT,SHOWPERCENTONLY,
                   currblock,SAMEBLOCK,wiblock,sepdot,
                   "Cloning blocks from ~");
    LOOP
        IF remaining = 0 THEN EXIT; END;
        IF remaining > maxWanted THEN
            wanted    := CARDINAL(maxWanted);
            DEC (remaining,maxWanted);
        ELSE
            wanted    := CARDINAL(remaining);
            remaining := 0;
        END;

        showDbgParms(DEBUG,FALSE,wanted,currblock,currblock,remaining,msg);
(* v1.0h : avoid isl342
IF DEBUG THEN
   video(msg,FALSE);
   S:="block=~  wanted=~  remaining=~"+nl;
   Str.Subst(S,"~",fmtlc(currblock,10,wiblock," ",""));
   Str.Subst(S,"~",fmt(wanted,10,wiblock," ",""));
   Str.Subst(S,"~",fmtlc(remaining,10,wiblock," ",""));
   WrStr(S); (* nl here *)
   video(msg,TRUE);
END;
*)
        unit:=usource.unit;
        op:=opRead;

        waitReady(DEBUG,unit);

        ok:=doOpBlocks(biosRC, DEBUG,DYNALLOC,unit,op,currblock,wanted);

(*%T TESTING *) IF Lib.RAND() < 0.02 THEN ok:=FALSE; END; (*%E *)

        IF NOT(ok) THEN
            INC(pb);
            INC(pbRd);
            S:=sPROBLEM+"Error ~ cloning blocks from [~..~]"+nl;
            Str.Subst(S,"~",fmt( CARDINAL(bFatalStatusCode),16,2,"0","$") );
            strRange(S,currblock,wanted);
            rptwr(SKIPLOG,LOGFILE,"",S);
            video(msg,FALSE); WrStr(S); video(msg,TRUE);
            IF IGNOREFATAL=FALSE THEN
                video(msg,FALSE);
                RETURN errFatal;
            END;
        END;
        okread := ok; (* in case we'd need to try a desperate procedure *)

        unit:=utarget.unit;

        IF REALLY THEN
            op:=opWrite;
        ELSE
            op:=opRead;
        END;

        waitReady(DEBUG,unit);

        ok:=doOpBlocks(biosRC, DEBUG,DYNALLOC,unit,op,currblock,wanted);

(*%T TESTING *) IF Lib.RAND() < 0.02 THEN ok:=FALSE; END; (*%E *)

        IF NOT(ok) THEN
            fuwi := (DESPERATE AND REALLY);
            fuwi := (fuwi AND okread);
            IF fuwi THEN (* retry one block at a time, fake IGNOREFATAL=TRUE *)
                FOR thisblock := currblock TO (currblock+LONGCARD(wanted)-1) DO
                    (* //FIXME okread is supposed to warrant read will always be ok *)
                    unit:=usource.unit;
                    op:=opRead;
                    waitReady(DEBUG,unit);
                    ok:=doOpBlocks(biosRC, DEBUG,DYNALLOC,unit,op,thisblock,oneBlock);

                    (* //FIXME assume ok though it's not so good an idea after all *)
                    unit:=utarget.unit;
                    op:=opWrite;
                    waitReady(DEBUG,unit);
                    ok:=doOpBlocks(biosRC, DEBUG,DYNALLOC,unit,op,thisblock,oneBlock);
                    IF NOT(ok) THEN
                        INC(pb);
                        INC(pbWr);
                        S:=sPROBLEM+"Error ~ cloning block to ~"+nl;
                        Str.Subst(S,"~",fmt( CARDINAL(bFatalStatusCode),16,2,"0","$") );
                        Str.Subst(S,"~",fmtlc(thisblock,10,0,"",""));
                        rptwr(SKIPLOG,LOGFILE,"",S);
                        video(msg,FALSE); WrStr(S); video(msg,TRUE);

                        buildCLI(sBATCH, usource.unit,utarget.unit,thisblock,oneBlock);
                        rptwr(SKIPLOG,LOGFILE,"",sBATCH);
                    ELSE
                        IF (PARANO AND REALLY) THEN
                            unit:=utarget.unit; (* useless safety *)
                            op:=opRead;         (* required safety *)

                            waitReady(DEBUG,unit);

                            ok:=doOpBlocksParano(biosRC, DEBUG,DYNALLOC,unit,op,thisblock,oneBlock);

                            (* //FIXME assume ok though it's not so good an idea after all *)

                            IF buffersMismatch(DYNALLOC,oneBlock) THEN
                                INC(pb);
                                INC(pbWr);

                                S:=sPROBLEM+"Mismatch error cloning block to ~"+nl;
                                Str.Subst(S,"~",fmtlc(thisblock,10,0,"",""));
                                rptwr(SKIPLOG,LOGFILE,"",S);
                                video(msg,FALSE); WrStr(S); video(msg,TRUE);

                                buildCLI(sBATCH, usource.unit,utarget.unit,thisblock,oneBlock);
                                rptwr(SKIPLOG,LOGFILE,"",sBATCH);
                            END;
                        END;
                    END;
                END;
            ELSE
                INC(pb);
                INC(pbWr);
                S:=sPROBLEM+"Error ~ cloning blocks to [~..~]"+nl;
                Str.Subst(S,"~",fmt( CARDINAL(bFatalStatusCode),16,2,"0","$") );
                strRange(S,currblock,wanted);
                rptwr(SKIPLOG,LOGFILE,"",S);
                video(msg,FALSE); WrStr(S); video(msg,TRUE);

                buildCLI(sBATCH, usource.unit,utarget.unit,currblock,wanted);
                rptwr(SKIPLOG,LOGFILE,"",sBATCH);

                IF IGNOREFATAL=FALSE THEN
                    video(msg,FALSE);
                    RETURN errFatal;
                END;
            END;
        ELSE
            IF (PARANO AND REALLY) THEN
                unit:=utarget.unit; (* useless safety *)
                op:=opRead;         (* required safety *)

                waitReady(DEBUG,unit);

                ok:=doOpBlocksParano(biosRC, DEBUG,DYNALLOC,unit,op,currblock,wanted);

                (* //FIXME assume ok though it's not so good an idea after all *)

                IF buffersMismatch(DYNALLOC,wanted) THEN
                    INC(pb);
                    INC(pbWr);

                    S:=sPROBLEM+"Mismatch error cloning blocks to [~..~]"+nl;
                    strRange(S,currblock,wanted);
                    rptwr(SKIPLOG,LOGFILE,"",S);
                    video(msg,FALSE); WrStr(S); video(msg,TRUE);

                    buildCLI(sBATCH, usource.unit,utarget.unit,currblock,wanted);
                    rptwr(SKIPLOG,LOGFILE,"",sBATCH);

                    IF IGNOREFATAL=FALSE THEN
                        video(msg,FALSE);
                        RETURN errFatal;
                    END;
                END;
            END;
        END;

        INC(chkrounds);
        IF (chkrounds MOD CHKEVERY) = 0 THEN chkrounds:=0;alcatraz:=ChkEscape(); END;
        IF alcatraz THEN EXIT; END;

        INC(currblock,LONGCARD(wanted));

        IF (currblock MOD updateFreq) = 0 THEN
            showCompletion (msg,
                           currblock,SAMEBLOCK,opfirstblock,totalblockcount,
                           wiblock,sepdot,orgmsg);
        END;
    END;
    video(msg,FALSE);

    IF alcatraz THEN
        S:=sCANCELLED+"Operation aborted by user while cloning blocks from [~..~]";
        strRange(S,currblock,wanted);
        IF NOT(REALLY) THEN Str.Append(S,sFAKE);END;
        Str.Append(S,nl);

        IF pb=0 THEN
            msg:=sNOERRORSOFAR+nl;
            rc:=errAborted;
        ELSE
            msg:=sPROBLEM+"At least ~ error(s) found so far (~ reading, ~ writing) !"+nl;
            Str.Subst(msg,"~",fmtlc(pb  ,10,0,"",""));
            Str.Subst(msg,"~",fmtlc(pbRd,10,0,"",""));
            Str.Subst(msg,"~",fmtlc(pbWr,10,0,"",""));
            rc:=errCloningFailure;
        END;
    ELSE
        S:=sCOMPLETE;
        IF NOT(REALLY) THEN Str.Append(S,sFAKE);END;
        Str.Append(S,nl);
        IF pb=0 THEN
            msg:=sNOERROR+nl;
            rc:=errNone;
        ELSE
            msg:=sPROBLEM+"At least ~ error(s) found (~ reading, ~ writing) !"+nl;
            Str.Subst(msg,"~",fmtlc(pb  ,10,0,"",""));
            Str.Subst(msg,"~",fmtlc(pbRd,10,0,"",""));
            Str.Subst(msg,"~",fmtlc(pbWr,10,0,"",""));
            rc:=errCloningFailure;
        END;
    END;
    WrStr(S);   rptwr(SKIPLOG,LOGFILE,"",S);
    WrStr(msg); rptwr(SKIPLOG,LOGFILE,"",msg);

    GetDateTimeNow(dtEnd);
    S:=fmtshow(wi,strClosed,fmtDateTimeUS(dtEnd) );
    rptwr(SKIPLOG,LOGFILE,sINFO,S);

    S:=fmtshow(wi,strElapsed,fmtDelta(dtStart,dtEnd) );
    rptwr(SKIPLOG,LOGFILE,sINFO,S);

    RETURN rc;
END doCmdClone;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE doCmdBackup (DEBUG,ALTFORMAT,SKIPLOG,IGNOREFATAL,WINWARN,MODEWARN,
                      REALLY,AUTORANGE,AUTOCONFIRM,DESPERATE,PARANO,SHOWPERCENT,SHOWPERCENTONLY:BOOLEAN;
                      opfirstblock,oplastblock,optargetfirstblock:LONGCARD;
                      usource,utarget:unitInfoType) : CARDINAL;
VAR
    optargetlastblock,maxWanted,updateFreq,remaining,totalblockcount:LONGCARD;
    currblock,targetcurrblock,thisblock,thistargetblock:LONGCARD;
    wanted,rc,wi,i,chkrounds:CARDINAL;
    dtStart,dtEnd: DTtype;
    pb,pbRd,pbWr:LONGCARD;
    alcatraz,ok,okread,fuwi:BOOLEAN;
    S,msg,orgmsg,sBATCH:str128;
    unit,op,biosRC:BYTE;
BEGIN
    (* must be done first so we compute optargetlastblock *)
    rc:=chkGeometriesAdv (optargetlastblock,
                         opfirstblock,oplastblock,optargetfirstblock,
                         usource,utarget);

    CASE rc OF
    | geomBackupFit:       ;
    | geomBackupMisfitSrc: RETURN errMisfitSrc;
    | geomBackupMisfitDst: RETURN errMisfitDst;
    | geomBackupOverlap:   RETURN errOverlap;
    END;

    wi:=getwidef();

    GetDateTimeNow(dtStart);
    S:=fmtshow(wi,strOpened,fmtDateTimeUS(dtStart) );
    Str.Prepend(S,nl+sINFO);
    rptwr(SKIPLOG,LOGFILE,"",S);
    IF WINWARN  THEN rptwr(SKIPLOG,LOGFILE,"",sBADideaWin);END;
    IF MODEWARN THEN rptwr(SKIPLOG,LOGFILE,"",sBADideaMode);END;

    doCmdParms (DEBUG,ALTFORMAT,SKIPLOG,usource,strSource);
    WrLn;
    doCmdParms (DEBUG,ALTFORMAT,SKIPLOG,utarget,strTarget);
    WrLn;
    i:=highestcard( Str.Length(strSource) , Str.Length(strTarget) );
    aboutGeometriesAdv (SKIPLOG,i,
                       opfirstblock,oplastblock,optargetfirstblock,
                       usource,utarget);

    IF queryUser (AUTOCONFIRM,sWARN+"Ready to copy disk","") = FALSE THEN RETURN errAborted;END;

    (* okay, let's try and clone those damn disks *)

    msg:="Copy";
    S:=fmtshow(wi,strCommand,msg);
    WrStr(S);   rptwr(SKIPLOG,LOGFILE,sINFO,S);

    Str.Copy(msg,fmtrangelc (opfirstblock,oplastblock) );
    S:=fmtshow(wi,strSourceRange,msg );
    WrStr(S);   rptwr(SKIPLOG,LOGFILE,sINFO,S);

    Str.Copy(msg, fmtrangelc (optargetfirstblock,optargetlastblock) );
    S:=fmtshow(wi,strTargetRange,msg);
    WrStr(S);   rptwr(SKIPLOG,LOGFILE,sINFO,S);

    maxWanted := LONGCARD (maxBlocksAtAtime);
    updateFreq:= LONGCARD (defaultUpdateFreq);
    remaining := oplastblock - opfirstblock +1; totalblockcount:=remaining;
    currblock := opfirstblock;
    targetcurrblock:=optargetfirstblock;

    pb        := 0;
    pbRd      := 0;
    pbWr      := 0;
    chkrounds := 0;
    alcatraz  := FALSE;

    initCompletion (orgmsg,msg,
                   REALLY,SHOWPERCENT,SHOWPERCENTONLY,
                   currblock,targetcurrblock,wiblock,sepdot,
                   "Copying blocks from ~ to ~");
    LOOP
        IF remaining = 0 THEN EXIT; END;
        IF remaining > maxWanted THEN
            wanted    := CARDINAL(maxWanted);
            DEC (remaining,maxWanted);
        ELSE
            wanted    := CARDINAL(remaining);
            remaining := 0;
        END;

        showDbgParms(DEBUG,TRUE,wanted,currblock,targetcurrblock,remaining,msg);

        unit:=usource.unit;
        op:=opRead;

        waitReady(DEBUG,unit);

        ok:=doOpBlocks(biosRC, DEBUG,DYNALLOC,unit,op,currblock,wanted);

(*%T TESTING *) IF Lib.RAND() < 0.02 THEN ok:=FALSE; END; (*%E *)

        IF NOT(ok) THEN
            INC(pb);
            INC(pbRd);
            S:=sPROBLEM+"Error ~ copying blocks from [~..~] to [~..~]"+nl;
            Str.Subst(S,"~",fmt( CARDINAL(bFatalStatusCode),16,2,"0","$") );
            strRange(S,currblock,wanted);
            strRange(S,targetcurrblock,wanted);
            rptwr(SKIPLOG,LOGFILE,"",S);
            video(msg,FALSE); WrStr(S); video(msg,TRUE);
            IF IGNOREFATAL=FALSE THEN
                video(msg,FALSE);
                RETURN errFatal;
            END;
        END;
        okread := ok; (* in case we'd need to try a desperate procedure *)

        unit:=utarget.unit;

        IF REALLY THEN
            op:=opWrite;
        ELSE
            op:=opRead;
        END;

        waitReady(DEBUG,unit);

        ok:=doOpBlocks(biosRC, DEBUG,DYNALLOC,unit,op,targetcurrblock,wanted);

(*%T TESTING *) IF Lib.RAND() < 0.02 THEN ok:=FALSE; END; (*%E *)

        IF NOT(ok) THEN
            fuwi := (DESPERATE AND REALLY);
            fuwi := (fuwi AND okread);
            IF fuwi THEN (* retry one block at a time, fake IGNOREFATAL=TRUE *)
                thistargetblock:=targetcurrblock;
                FOR thisblock := currblock TO (currblock+LONGCARD(wanted)-1) DO
                    (* //FIXME okread is supposed to warrant read will always be ok *)
                    unit:=usource.unit;
                    op:=opRead;
                    waitReady(DEBUG,unit);
                    ok:=doOpBlocks(biosRC, DEBUG,DYNALLOC,unit,op,thisblock,oneBlock);

                    (* //FIXME assume ok though it's not so good an idea after all *)
                    unit:=utarget.unit;
                    op:=opWrite;
                    waitReady(DEBUG,unit);
                    ok:=doOpBlocks(biosRC, DEBUG,DYNALLOC,unit,op,thistargetblock,oneBlock);
                    IF NOT(ok) THEN
                        INC(pb);
                        INC(pbWr);
                        S:=sPROBLEM+"Error ~ copying block ~ to block ~"+nl;
                        Str.Subst(S,"~",fmt( CARDINAL(bFatalStatusCode),16,2,"0","$") );
                        Str.Subst(S,"~",fmtlc(thisblock,10,0,"",""));
                        Str.Subst(S,"~",fmtlc(thistargetblock,10,0,"",""));
                        rptwr(SKIPLOG,LOGFILE,"",S);
                        video(msg,FALSE); WrStr(S); video(msg,TRUE);

                        buildCLIcopy(sBATCH, usource.unit,utarget.unit,thisblock,thistargetblock,oneBlock);
                        rptwr(SKIPLOG,LOGFILE,"",sBATCH);
                    ELSE
                        IF (PARANO AND REALLY) THEN
                            unit:=utarget.unit; (* useless safety *)
                            op:=opRead;         (* required safety *)

                            waitReady(DEBUG,unit);

                            ok:=doOpBlocksParano(biosRC, DEBUG,DYNALLOC,unit,op,thistargetblock,oneBlock);

                            (* //FIXME assume ok though it's not so good an idea after all *)

                            IF buffersMismatch(DYNALLOC,oneBlock) THEN
                                INC(pb);
                                INC(pbWr);

                                S:=sPROBLEM+"Mismatch error copying block ~ to block ~"+nl;
                                Str.Subst(S,"~",fmtlc(thisblock,10,0,"",""));
                                Str.Subst(S,"~",fmtlc(thistargetblock,10,0,"",""));
                                rptwr(SKIPLOG,LOGFILE,"",S);
                                video(msg,FALSE); WrStr(S); video(msg,TRUE);

                                buildCLIcopy(sBATCH, usource.unit,utarget.unit,thisblock,thistargetblock,oneBlock);
                                rptwr(SKIPLOG,LOGFILE,"",sBATCH);
                            END;
                        END;
                    END;
                    INC(thistargetblock); (* add oneBlock i.e. 1 *)
                END;
            ELSE
                INC(pb);
                INC(pbWr);
                S:=sPROBLEM+"Error ~ copying blocks from [~..~] to [~..~]"+nl;
                Str.Subst(S,"~",fmt( CARDINAL(bFatalStatusCode),16,2,"0","$") );
                strRange(S,currblock,wanted);
                strRange(S,targetcurrblock,wanted);
                rptwr(SKIPLOG,LOGFILE,"",S);
                video(msg,FALSE); WrStr(S); video(msg,TRUE);

                buildCLIcopy(sBATCH, usource.unit,utarget.unit,currblock,targetcurrblock,wanted);
                rptwr(SKIPLOG,LOGFILE,"",sBATCH);

                IF IGNOREFATAL=FALSE THEN
                    video(msg,FALSE);
                    RETURN errFatal;
                END;
            END;
        ELSE
            IF (PARANO AND REALLY) THEN
                unit:=utarget.unit; (* useless safety *)
                op:=opRead;         (* required safety *)

                waitReady(DEBUG,unit);

                ok:=doOpBlocksParano(biosRC, DEBUG,DYNALLOC,unit,op,targetcurrblock,wanted);

                (* //FIXME assume ok though it's not so good an idea after all *)

                IF buffersMismatch(DYNALLOC,wanted) THEN
                    INC(pb);
                    INC(pbWr);

                    S:=sPROBLEM+"Mismatch error copying blocks from [~..~] to [~..~]"+nl;
                    strRange(S,currblock,wanted);
                    strRange(S,targetcurrblock,wanted);
                    rptwr(SKIPLOG,LOGFILE,"",S);
                    video(msg,FALSE); WrStr(S); video(msg,TRUE);

                    buildCLIcopy(sBATCH, usource.unit,utarget.unit,currblock,targetcurrblock,wanted);
                    rptwr(SKIPLOG,LOGFILE,"",sBATCH);

                    IF IGNOREFATAL=FALSE THEN
                        video(msg,FALSE);
                        RETURN errFatal;
                    END;
                END;
            END;
        END;

        INC(chkrounds);
        IF (chkrounds MOD CHKEVERY) = 0 THEN chkrounds:=0;alcatraz:=ChkEscape(); END;
        IF alcatraz THEN EXIT; END;

        INC(currblock,LONGCARD(wanted));
        INC(targetcurrblock,LONGCARD(wanted));

        IF (currblock MOD updateFreq) = 0 THEN
            showCompletion (msg,
                           currblock,targetcurrblock,opfirstblock,totalblockcount,
                           wiblock,sepdot,orgmsg);
        END;
    END;
    video(msg,FALSE);

    IF alcatraz THEN
        S:=sCANCELLED+"Operation aborted by user while copying blocks from [~..~] to [~..~]";
        strRange(S,currblock,wanted);
        strRange(S,targetcurrblock,wanted);
        IF NOT(REALLY) THEN Str.Append(S,sFAKE);END;
        Str.Append(S,nl);

        IF pb=0 THEN
            msg:=sNOERRORSOFAR+nl;
            rc:=errAborted;
        ELSE
            msg:=sPROBLEM+"At least ~ error(s) found so far (~ reading, ~ writing) !"+nl;
            Str.Subst(msg,"~",fmtlc(pb  ,10,0,"",""));
            Str.Subst(msg,"~",fmtlc(pbRd,10,0,"",""));
            Str.Subst(msg,"~",fmtlc(pbWr,10,0,"",""));
            rc:=errCopyingFailure;
        END;
    ELSE
        S:=sCOMPLETE;
        IF NOT(REALLY) THEN Str.Append(S,sFAKE);END;
        Str.Append(S,nl);
        IF pb=0 THEN
            msg:=sNOERROR+nl;
            rc:=errNone;
        ELSE
            msg:=sPROBLEM+"At least ~ error(s) found (~ reading, ~ writing) !"+nl;
            Str.Subst(msg,"~",fmtlc(pb  ,10,0,"",""));
            Str.Subst(msg,"~",fmtlc(pbRd,10,0,"",""));
            Str.Subst(msg,"~",fmtlc(pbWr,10,0,"",""));
            rc:=errCopyingFailure;
        END;
    END;
    WrStr(S);   rptwr(SKIPLOG,LOGFILE,"",S);
    WrStr(msg); rptwr(SKIPLOG,LOGFILE,"",msg);

    GetDateTimeNow(dtEnd);
    S:=fmtshow(wi,strClosed,fmtDateTimeUS(dtEnd) );
    rptwr(SKIPLOG,LOGFILE,sINFO,S);

    S:=fmtshow(wi,strElapsed,fmtDelta(dtStart,dtEnd) );
    rptwr(SKIPLOG,LOGFILE,sINFO,S);

    RETURN rc;
END doCmdBackup;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE getvallc (S:ARRAY OF CHAR;VAR v : LONGCARD ):BOOLEAN;
VAR
    lc   : LONGCARD;
    base : CARDINAL;
    ok   : BOOLEAN;
BEGIN
    IF S[0]="$" THEN
        Str.Delete(S,0,1);
        base := 16;
    ELSE
        base := 10;
    END;
    lc:=Str.StrToCard(S,base,ok);
    IF NOT(ok) THEN RETURN FALSE; END;
    IF lc > MAX(LONGCARD) THEN RETURN FALSE; END; (* gloups... how could such a thing be ? ;-) *)
    v := lc;
    RETURN TRUE;
END getvallc;

PROCEDURE getval (S:ARRAY OF CHAR;VAR v : CARDINAL ):BOOLEAN;
VAR
    lc:LONGCARD;
BEGIN
    lc := LONGCARD(v);
    IF getvallc(S, lc) THEN
        IF lc > MAX(CARDINAL) THEN
            RETURN FALSE;
        ELSE
            v := CARDINAL(lc);
            RETURN TRUE;
        END;
    ELSE
        RETURN FALSE;
    END;
END getval;

PROCEDURE parseRange (VAR first,last:LONGCARD;S:ARRAY OF CHAR):BOOLEAN;
CONST
    seprange = "..";
    sepcount = ",";
VAR
    lc1,lc2:LONGCARD;
    len,p:CARDINAL;
    isrange:BOOLEAN;
    N:str128; (* really oversized ! *)
BEGIN
    IF Str.Match(S,"*"+seprange+"*") THEN
        p:=Str.Pos(S,seprange); len:=Str.Length(seprange); isrange:=TRUE;
    ELSIF Str.Match(S,"*"+sepcount+"*") THEN
        p:=Str.Pos(S,sepcount); len:=Str.Length(sepcount); isrange:=FALSE;
    ELSE
        RETURN FALSE;
    END;
    Str.Slice(N,S,0,p);
    Str.Delete(S,0,p+len);

    IF getvallc (N, lc1)=FALSE THEN RETURN FALSE; END;

    Str.Copy(N,S);

    IF getvallc (N, lc2)=FALSE THEN RETURN FALSE; END;

    IF isrange THEN
        IF lc2 < lc1 THEN RETURN FALSE; END;
    ELSE
        IF lc2=0 THEN RETURN FALSE;END;
        (* lc2 = lc2 + lc1 -1 *)
        INC(lc2,lc1);
        DEC(lc2);
    END;

    (* here we're sure first <= last *)

    first:=lc1;
    last :=lc2;

    RETURN TRUE;
END parseRange;

PROCEDURE parseBlock (VAR block:LONGCARD; S:ARRAY OF CHAR):BOOLEAN;
BEGIN
    RETURN getvallc(S, block);
END parseBlock;

(* ------------------------------------------------------------ *)

TYPE
    cmdtype = (cmdnone,cmdverify,cmdabout,cmdclone,cmdbackup,cmdaboutallunits);

PROCEDURE chkCmd (VAR cmd : cmdtype; wanted:cmdtype):BOOLEAN;
VAR
    rc:BOOLEAN;
BEGIN
    rc:=TRUE;
    IF cmd=cmdnone THEN
        cmd:=wanted;
    ELSIF cmd=wanted THEN
        ;
    ELSE
        rc:=FALSE;
    END;
    RETURN rc;
END chkCmd;

CONST
    UNSUPPORTEDUNIT = BYTE(0FFH); (* maybe a file *)
    legalUnits = "HD_A"+delim+"HD_0"+delim+
                 "HD_B"+delim+"HD_1"+delim+
                 "$80"+delim+"80H"+delim+"128"+delim+"0X80"+delim+
                 "$81"+delim+"81H"+delim+"129"+delim+"0X81"+delim+
                 "$82"+delim+"82H"+delim+"130"+delim+"0X82"+delim+
                 "$83"+delim+"83H"+delim+"131"+delim+"0X83"+delim+
                 "HD_C"+delim+"HD_2"+delim+
                 "HD_D"+delim+"HD_3";

PROCEDURE chkUnit (VAR unit:BYTE;S:ARRAY OF CHAR):BOOLEAN;
VAR
    i:CARDINAL;
    rc:BOOLEAN;
BEGIN
    rc:=TRUE;
    i := getStrIndex(delim,S,legalUnits);
    CASE i OF
    |  1..2  : unit := BYTE(80H);
    |  3..4  : unit := BYTE(81H);
    |  5..8  : unit := BYTE(80H);
    |  9..12 : unit := BYTE(81H);
    | 13..16 : unit := BYTE(82H);
    | 17..20 : unit := BYTE(83H);
    | 21..22 : unit := BYTE(82H);
    | 23..24 : unit := BYTE(83H);
    ELSE
               unit := UNSUPPORTEDUNIT;
               rc   := FALSE;
    END;
    RETURN rc;
END chkUnit;

PROCEDURE runningManager (  ):BOOLEAN ; (* //FIXME *)
BEGIN
    RETURN FALSE;
END runningManager;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE doCmdParmsAlt (DEBUG,SKIPLOG,FAKERESET,FIXBADTHS,ALTFORMAT,
                        PIO,DMA,PREFETCH,showfailure:BOOLEAN;
                        BESTFIT:CARDINAL;S:ARRAY OF CHAR):BOOLEAN;
CONST
    MBRblock                = firstBlock; (* 0 and 0-based ! ;-) *)
    winXPuniqueIDoffset     = 01B8H; (* LONGCARD : M$ bastards taking liberties with standards ! *)
    MBRsigOffset            = 01FEH; (* $AA55 *)
    MBRsig                  = 0AA55H;
VAR
    rc,YES:BOOLEAN;
    ui:unitInfoType;
    i,j,opt:CARDINAL;
    U,R,Z:str80;
    eddCmd,biosRC:BYTE;
    winXPid : LONGCARD;
    sig : CARDINAL;
BEGIN
    rc:= chkUnit(ui.unit,S); (* always ok : $80..$83 *)

    Str.Concat(U,fmt( CARDINAL(ui.unit),16,2,"0","$"), " unit"); (* S is already formatted at entry but... *)
    Str.Concat(R,U," with ~ ID has ~ blocks available."+nl);

    rc:=FALSE;
    Z:=" is not available."+nl;

    chkExtendedSupport (DEBUG, ui);
    IF ui.ENHINT13Havailable THEN
        IF resetUnit(DEBUG,FAKERESET, ui.unit) THEN

            FOR j:=1 TO 3 DO
                CASE j OF
                | 1: YES:=PIO;      eddCmd:=cmdPIO;
                | 2: YES:=DMA;      eddCmd:=cmdDMA;
                | 3: YES:=PREFETCH; eddCmd:=cmdPREFETCH;
                END;
                opt:=setEDDcfg(DEBUG,YES,eddCmd, ui); (* ignore return code *)
            END;

            i:= getGeometry (DEBUG,FIXBADTHS,BESTFIT,  ui);
            CASE i OF
            | rcPhantom :          ;
            | rcInt13HPB:          ;
            | rcEnhInt13HPB:       ;
            | rcEnhInt13HvaluesPB: ;
            | rcWrongTHSgeometry:  ;
            ELSE
                fixGeometry(DEBUG, BESTFIT,ui); (* useless here *)

                waitReady(DEBUG,ui.unit);
                IF doOpBlocks(biosRC, DEBUG,DYNALLOC,ui.unit,opRead,MBRblock,oneBlock) THEN

                    IF NOT ( DYNALLOC ) THEN
                        Lib.FarMove(FarADR(buffTrack[winXPuniqueIDoffset]),FarADR(winXPid),SIZE(winXPid));
                        Lib.FarMove(FarADR(buffTrack[MBRsigOffset]),FarADR(sig),SIZE(sig));
                    ELSE
                        Lib.FarMove(FarADR(pbuffTrack^[winXPuniqueIDoffset]),FarADR(winXPid),SIZE(winXPid));
                        Lib.FarMove(FarADR(pbuffTrack^[MBRsigOffset]),FarADR(sig),SIZE(sig));
                    END;
                    IF sig = MBRsig THEN
                        Str.Subst(R,"~",fmtlc(winXPid,16,8,"0","$"));
                        IF NOT(ALTFORMAT) THEN
                            Str.Subst(R,"~", beautifiedlc(ui.blockcount," ",sepdot,wiblock));
                        ELSE
                            Str.Subst(R,"~", fmtlc(ui.blockcount,10,0,"",""));
                        END;
                        rc:=TRUE;
                    ELSE
                        Z := " is available but does not have expected $aa55 MBR signature.";
                    END;
                ELSE
                    Z:= " is available but denied MBR read access."+nl;
                END;
            END;
        END;
    END;
    IF rc THEN
        WrStr(R);   rptwr(SKIPLOG,LOGFILE,sINFO,R);
    ELSE
        IF showfailure THEN
            Str.Concat(R,U,Z);
            WrStr(R);   rptwr(SKIPLOG,LOGFILE,sINFO,R);
        END;
    END;
    RETURN rc;
END doCmdParmsAlt;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ndxsource = 1;
    ndxtarget = 2;
    firstparm = 1;
    maxparm   = 4; (* "source target range block" *)
VAR
    ui : ARRAY [ndxsource..ndxtarget] OF unitInfoType;
    S,R:str128;
    parm:ARRAY [firstparm..maxparm] OF str128;
    parmcount,i,opt,lastparm,ndxlast:CARDINAL;
    cmd:cmdtype;
    rc,DEBUG:BOOLEAN;
    ALTFORMAT,SHOWPERCENTONLY:BOOLEAN;
    SKIPLOG,VEREADFY,IGNOREFATAL,DESPERATE,PARANO:BOOLEAN;
    WINWARN,MODEWARN:BOOLEAN;
    CHECKBOUNDARIES,REALLY,AUTORANGE,AUTOCONFIRM,FAKERESET,SHOWPERCENT:BOOLEAN;
    PIO,DMA,PREFETCH:BOOLEAN;
    FIXBADTHS , SHOWFAILURE: BOOLEAN;
    opfirstblock,oplastblock,optargetfirstblock:LONGCARD;
    utmp:BYTE;
    j,ucount:CARDINAL;
    YES:BOOLEAN;
    eddCmd:BYTE;
    aboutwhat:(aboutunit,aboutclonefull,aboutclonerange,aboutbackup);
    BESTFIT:CARDINAL; (* no longer a constant in fact *)
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck:=FALSE;
    WrLn;

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;

    initFatalStatus;
    cmd            := cmdnone;
    DYNALLOC       := TRUE;
    AUDIO          := FALSE;
    FATALINAL      := TRUE;

    opfirstblock       := UNDEFINEDBLOCK;
    oplastblock        := UNDEFINEDBLOCK;
    optargetfirstblock := UNDEFINEDBLOCK;

    FOR i:= ndxsource TO ndxtarget DO ui[i].unit:=UNSUPPORTEDUNIT; END;

    VEREADFY       := TRUE;  (* useless *)
    DESPERATE      := FALSE; (* useless *)
    FAKERESET      := TRUE;
    PARANO         := FALSE;
    SKIPLOG        := FALSE;
    ALTFORMAT      := FALSE;
    IGNOREFATAL    := FALSE;
    CHECKBOUNDARIES:= FALSE;
    REALLY         := FALSE;
    AUTORANGE      := FALSE;
    AUTOCONFIRM    := FALSE;
    PIO            := FALSE;
    DMA            := FALSE;
    PREFETCH       := FALSE;
    SHOWPERCENT    := TRUE;  (* default because no performance hit *)
    FIXBADTHS      := FALSE;
    DEBUG          := FALSE;
    BESTFIT        := FORCEBEST; (* user should not change this setting *)
    SHOWFAILURE    := FALSE;
    SHOWPERCENTONLY:= FALSE;

    lastparm       := firstparm-1;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "APPLY"+delim+"UPDATE"+delim+"WRITE"+delim+
                                  "DEBUG"+delim+"VERYVERBOSE"+delim+
                                  "FF"+delim+
                                  "AH"+delim+
                                  "A"+delim+"AUDIO"+delim+"W"+delim+"WARNING"+delim+
                                  "D"+delim+"DISPLAY"+delim+
                                  "U"+delim+"UNSAFE"+delim+"UNWISE"+delim+"IGNOREFATAL"+delim+
                                  "L"+delim+"NOLOG"+delim+
                                  "V"+delim+"VERIFY"+delim+
                                  "P"+delim+"PARMS"+delim+"ABOUT"+delim+
                                  "C"+delim+"COPY"+delim+"CLONE"+delim+
                                  "I"+delim+"INFOS"+delim+
                                  "VV"+delim+
                                  "Z"+delim+"AUTORANGE"+delim+"ADJUST"+delim+
                                  "YES"+delim+"OUI"+delim+"AUTOCONFIRM"+delim+
                                  "PIO"+delim+
                                  "DMA"+delim+
                                  "PF"+delim+"PREFETCH"+delim+
                                  "F"+delim+"FIXED"+delim+
                                  "R"+delim+"RESET"+delim+"RST"+delim+
                                  "K"+delim+"BIS"+delim+"DESPERATE"+delim+
                                  "CC"+delim+"CK"+delim+
                                  "REALLY"+delim+
                                  "??"+delim+"HH"+delim+
                                  "KLONIT"+delim+
                                  "PARANO"+delim+"COMPARE"+delim+"COMP"+delim+
                                  "E"+delim+"PERCENT"+delim+"PERCENTAGE"+delim+
                                  "DUPME"+delim+
                                  "DOIT"+delim+
                                  "B"+delim+"BACKUP"+delim+
                                  "BB"+delim+"BK"+delim+
                                  "THS"+delim+"FIXBADTHS"+delim+"BAD"+delim+
                                  "CHK"+delim+
                                  "J"+delim+"F255"+delim+"MAXHEAD"+delim+
                                  "JJ"+delim+"F240"+delim+
                                  "!"+delim+"ABOUTALLUNITS"+delim+
                                  "!!"+delim+
                                  "$"+delim+
                                  "$$"+delim+
                                  "T"+delim+"UI"
                              );
            CASE opt OF
            | 1,2,3 :      abort(errHelp,"");
            | 4,5,6 :      REALLY          := TRUE;
            | 7,8   :      DEBUG           := TRUE;
            | 9     :      DYNALLOC        := FALSE;CHECKBOUNDARIES := TRUE;
            | 10    :      FATALINAL       := FALSE;
            | 11,12,13,14: AUDIO           := TRUE;
            | 15,16 :      ALTFORMAT       := TRUE;
            | 17,18,19,20: IGNOREFATAL     := TRUE;
            | 21,22:       SKIPLOG         := TRUE;
            | 23,24:       IF chkCmd(cmd,cmdverify)=FALSE THEN abort(errCmd,"-v[v]");END;
                           VEREADFY        := TRUE;
            | 25,26,27:    IF chkCmd(cmd,cmdabout) =FALSE THEN abort(errCmd,"-p");END;
            | 28,29,30:    IF chkCmd(cmd,cmdclone) =FALSE THEN abort(errCmd,"-c[c]");END;
                           DESPERATE       := FALSE;
            | 31,32:       IF chkCmd(cmd,cmdabout) =FALSE THEN abort(errCmd,"-p");END;
            | 33:          IF chkCmd(cmd,cmdverify)=FALSE THEN abort(errCmd,"-v[v]");END;
                           VEREADFY        := FALSE;
            | 34,35,36:    AUTORANGE       := TRUE;
            | 37,38,39:    AUTOCONFIRM     := TRUE;
            | 40:          PIO             := TRUE;
            | 41:          DMA             := TRUE;
            | 42,43:       PREFETCH        := TRUE;
            | 44,45 :      DYNALLOC        := FALSE;
            | 46,47,48 :   FAKERESET       := FALSE;
            | 49,50,51 :   DESPERATE       := TRUE;
            | 52,53 :      IF chkCmd(cmd,cmdclone) =FALSE THEN abort(errCmd,"-c[c]");END;
                           DESPERATE       := TRUE;
            | 54:          REALLY          := TRUE;
            | 55,56:       abort(errHelper,"");
            | 57 :         IF chkCmd(cmd,cmdclone) =FALSE THEN abort(errCmd,"-c[c]");END;
                           DESPERATE       := TRUE; (* -k *)
                           REALLY          := TRUE; (* -apply *)
                           IGNOREFATAL     := TRUE; (* -u *)
                           AUTOCONFIRM     := TRUE; (* -yes *)
            | 58,59,60:    PARANO          := TRUE;
            | 61,62,63:    SHOWPERCENT     := FALSE;
            | 64 :         IF chkCmd(cmd,cmdclone) =FALSE THEN abort(errCmd,"-c[c]");END;
                           DESPERATE       := TRUE; (* -k *)
                           REALLY          := TRUE; (* -apply *)
                           IGNOREFATAL     := TRUE; (* -u *)
                           AUTOCONFIRM     := TRUE; (* -yes *)
                           SHOWPERCENT     := FALSE; (* -e *)
            | 65 :         REALLY          := TRUE;
            | 66,67:       IF chkCmd(cmd,cmdbackup)=FALSE THEN abort(errCmd,"-b[b]");END;
            | 68,69:       IF chkCmd(cmd,cmdbackup)=FALSE THEN abort(errCmd,"-b[b]");END;
                           DESPERATE       := TRUE;
            | 70,71,72:    FIXBADTHS       := TRUE;
            | 73      :    DYNALLOC        := FALSE;CHECKBOUNDARIES := TRUE; (* same as "FF" *)
            | 74,75,76:    BESTFIT   := FORCE255;
            | 77,78:       BESTFIT   := FORCE240;
            | 79,80:       IF chkCmd(cmd,cmdaboutallunits) =FALSE THEN abort(errCmd,"-!");END;
            | 81:          IF chkCmd(cmd,cmdaboutallunits) =FALSE THEN abort(errCmd,"-!!");END;
                           ALTFORMAT := TRUE;
            | 82:          IF chkCmd(cmd,cmdaboutallunits) =FALSE THEN abort(errCmd,"-$");END;
                           SHOWFAILURE := TRUE;
            | 83:          IF chkCmd(cmd,cmdaboutallunits) =FALSE THEN abort(errCmd,"-$$");END;
                           ALTFORMAT := TRUE;
                           SHOWFAILURE := TRUE;
            | 84,85:       SHOWPERCENTONLY := TRUE;
            ELSE
                abort(errOption,S);
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errParameter,S);END;
            Str.Copy( parm[lastparm], R); (* keep uppercase *)
        END;
    END;

    IF cmd = cmdnone THEN cmd:=cmdabout;END;

    (* ndxlast required later on *)

    CASE cmd OF
    | cmdnone: abort(errNoCommand,"");
    | cmdclone:                              (* <source> <target> [range] *)
        CASE lastparm OF
        | 2,3 : ndxlast:=ndxtarget;
        ELSE    abort(errSyntaxCmd,"-c[c]");
        END;

        IF IsRedirected() THEN abort(errRedirected,"-c[c]"); END;

        FOR i:=ndxsource TO ndxlast DO
            CASE i OF
            | ndxsource : Str.Copy(S, parm[ndxsource]);
            | ndxtarget : Str.Copy(S, parm[ndxtarget]);
            END;
            IF chkUnit(ui[i].unit,S)=FALSE THEN abort(errUnit,S);END;
        END;

        IF lastparm = 3 THEN
            Str.Copy(S, parm[3]);
            IF chkUnit(utmp,S) THEN abort(errUnexpectedUnitRange,S);END;
            IF parseRange(opfirstblock,oplastblock,S)=FALSE THEN
                abort(errRange,S);
            END;
            IF opfirstblock = UNDEFINEDBLOCK THEN abort(errReserved,S);END;
            IF oplastblock  = UNDEFINEDBLOCK THEN abort(errReserved,S);END;
        END;

        IF ui[ndxsource].unit=ui[ndxtarget].unit THEN abort(errSameUnit,"");END;

    | cmdbackup:                            (* <source> <target> <range> <block> *)

        CASE lastparm OF
        | 4 : ndxlast:=ndxtarget;
        ELSE    abort(errSyntaxCmd,"-b[b]");
        END;

        IF IsRedirected() THEN abort(errRedirected,"-b[b]"); END;

        IF AUTORANGE THEN abort(errCannotAdjustBackup,"");END; (* in fact, we could do it but it would be unwise *)

        FOR i:=ndxsource TO ndxlast DO
            CASE i OF
            | ndxsource : Str.Copy(S, parm[ndxsource]);
            | ndxtarget : Str.Copy(S, parm[ndxtarget]);
                (* undocumented ! *)
                IF (same(S,"=") OR same(S,"*")) THEN Str.Copy(S, parm[ndxsource]); END;
            END;
            IF chkUnit(ui[i].unit,S)=FALSE THEN abort(errUnit,S);END;
        END;

        Str.Copy(S, parm[3]);
        IF chkUnit(utmp,S) THEN abort(errUnexpectedUnitRange,S);END;
        IF parseRange(opfirstblock,oplastblock,S)=FALSE THEN
                abort(errRange,S);
        END;
        IF opfirstblock = UNDEFINEDBLOCK THEN abort(errReserved,S);END;
        IF oplastblock  = UNDEFINEDBLOCK THEN abort(errReserved,S);END;

        Str.Copy(S, parm[4]);
        IF chkUnit(utmp,S) THEN abort(errUnexpectedUnitBlock,S);END;
        IF parseBlock(optargetfirstblock,S)=FALSE THEN
                abort(errBlock,S);
        END;
        IF optargetfirstblock = UNDEFINEDBLOCK THEN abort(errReserved,S);END;

        (* here, we can just check values are ok, without relation to geometries *)

        IF chkOverlap ( ui[ndxsource].unit, ui[ndxtarget].unit ,
                        opfirstblock,oplastblock,optargetfirstblock)=FALSE THEN
            abort(errOverlap,"");
        END;

    | cmdabout:                             (* <unit> [unit [range [block]]] *)
        CASE lastparm OF
        | 1 : ndxlast:=ndxsource; aboutwhat:=aboutunit;
        | 2 : ndxlast:=ndxtarget; aboutwhat:=aboutclonefull;
        | 3 : ndxlast:=ndxtarget; aboutwhat:=aboutclonerange;
        | 4 : ndxlast:=ndxtarget; aboutwhat:=aboutbackup;
        ELSE  abort(errSyntaxCmd,"-p");
        END;

        FOR i:=ndxsource TO ndxlast DO
            CASE i OF
            | ndxsource : Str.Copy(S, parm[ndxsource]);
            | ndxtarget : Str.Copy(S, parm[ndxtarget]);
                (* undocumented *)
                IF (same(S,"=") OR same(S,"*")) THEN Str.Copy(S, parm[ndxsource]); END;
            END;
            IF chkUnit(ui[i].unit,S)=FALSE THEN abort(errUnit,S);END;
        END;

        CASE aboutwhat OF
        | aboutclonerange,aboutbackup:
            Str.Copy(S, parm[3]);
            IF chkUnit(utmp,S) THEN abort(errUnexpectedUnitRange,S);END;
            IF parseRange(opfirstblock,oplastblock,S)=FALSE THEN
                abort(errRange,S);
            END;
            IF opfirstblock = UNDEFINEDBLOCK THEN abort(errReserved,S);END;
            IF oplastblock  = UNDEFINEDBLOCK THEN abort(errReserved,S);END;
        END;

        CASE aboutwhat OF
        | aboutclonefull,aboutclonerange:
            IF ui[ndxsource].unit=ui[ndxtarget].unit THEN abort(errSameUnit,"");END;
        | aboutbackup:
            Str.Copy(S, parm[4]);
            IF chkUnit(utmp,S) THEN abort(errUnexpectedUnitBlock,S);END;
            IF parseBlock(optargetfirstblock,S)=FALSE THEN
                abort(errBlock,S);
            END;
            IF optargetfirstblock = UNDEFINEDBLOCK THEN abort(errReserved,S);END;
        END;

    | cmdverify:                            (* <unit> [range] *)
        CASE lastparm OF
        | 1,2 : ndxlast:=ndxsource;
        ELSE
                abort(errSyntaxCmd,"-v[v]");
        END;

        Str.Copy(S, parm[ndxsource]);
        IF chkUnit(ui[ndxsource].unit,S)=FALSE THEN abort(errUnit,S);END;

        IF lastparm=2 THEN
            Str.Copy(S, parm[2]);
            IF chkUnit(utmp,S) THEN abort(errUnexpectedUnitRange,S);END;
            IF parseRange(opfirstblock,oplastblock,S)=FALSE THEN
                abort(errRange,S);
            END;
            IF opfirstblock = UNDEFINEDBLOCK THEN abort(errReserved,S);END;
            IF oplastblock  = UNDEFINEDBLOCK THEN abort(errReserved,S);END;
        END;
    | cmdaboutallunits:
        IF lastparm # 0 THEN abort(errSyntaxCmd,"-!");END;
    END;

IF DYNALLOC THEN
    (* now is a good time to create (ptrTo)SectorType buffers *)
    (* we'll let good old DOS handle deallocation alone in most abort()cases *)

    CHECKBOUNDARIES := TRUE; (* always check even though it seems useless *)

    pbuffTrack      := NIL;
    pbuffTrack      := grabMem(DEBUG,CHECKBOUNDARIES);
    IF pbuffTrack = NIL THEN abort(errBoundary,"pbuffTrack");END;

    pbuffTrackParano:= NIL;
    pbuffTrackParano:= grabMem(DEBUG,CHECKBOUNDARIES);
    IF pbuffTrackParano = NIL THEN abort(errBoundary,"pbuffTrackParano");END;

ELSE
    (* now is a good time to (uselessly) check if static buffers don't cross 64Kb boundary *)

    IF CHECKBOUNDARIES THEN
        IF crosspages( DEBUG,FarADR(buffTrack),SIZE(buffTrack)) THEN
            abort(errBoundary,"buffTrack");
        END;

        IF crosspages( DEBUG,FarADR(buffTrackParano),SIZE(buffTrackParano)) THEN
            abort(errBoundary,"buffTrackParano");
        END;

    END;
END;

    IF (PIO AND DMA) THEN abort(errPIOorDMA,"");END;

    (* now check BIOS quirk, set log to RW, video warn against vindoze *)

    IF fixFatalStatusBios () THEN FATALINAL:=FALSE; END; (* if .CFG exists, force -AH *)

    IF FIO.Exists(LOGFILE) THEN setReadWrite(LOGFILE);END; (* safety *)

    WINWARN := runningWindows();
    IF WINWARN THEN WrStr(sBADideaWin);WrLn;END; (* already nl *)

    MODEWARN := runningManager();
    IF MODEWARN THEN WrStr(sBADideaMode);WrLn;END; (* already nl *)

  IF cmd # cmdaboutallunits THEN
    FOR i:=ndxsource TO ndxlast DO
        CASE i OF
        | ndxsource: Str.Copy(S,parm[ndxsource]);
        | ndxtarget: Str.Copy(S,parm[ndxtarget]);
        END;
        IF ui[i].unit # UNSUPPORTEDUNIT THEN (* we always have a valid unit here *)
            chkExtendedSupport (DEBUG, ui[i]);
            IF ui[i].ENHINT13Havailable=FALSE THEN abort(errNotXBIOS,S);END;

            IF resetUnit(DEBUG,FAKERESET, ui[i].unit)=FALSE THEN abort(errXBIOSint13h,"resetUnit");END;

            FOR j:=1 TO 3 DO
                CASE j OF
                | 1: YES:=PIO;      eddCmd:=cmdPIO;      R:="PIO";
                | 2: YES:=DMA;      eddCmd:=cmdDMA;      R:="DMA";
                | 3: YES:=PREFETCH; eddCmd:=cmdPREFETCH; R:="Prefetch";
                END;
                opt:=setEDDcfg(DEBUG,YES,eddCmd, ui[i]);
                CASE opt OF
                | eddUseless    : R:="";
                | eddUnsupported: Str.Append(R," command was ignored for lack of EDD v2.1+ support.");
                | eddError      : abort(errEDD,R);
                | eddOKsafe     : Str.Append(R," command was safely set.");
                | eddOKunsafe   : Str.Append(R," command was unsafely set.");
                END;
                IF opt # eddUseless THEN WrStr(sINFO);WrStr(R);WrLn;END;
            END;

            opt:= getGeometry (DEBUG,FIXBADTHS,BESTFIT,  ui[i]);
            CASE opt OF
            | rcPhantom :          abort(errPhantom,S); (* will only trap phantom floppy ! *)
            | rcInt13HPB:          abort(errXBIOSint13h,"getDiskGeometry");
            | rcEnhInt13HPB:       abort(errXBIOSint13h,"getDiskGeometry");
            | rcEnhInt13HvaluesPB: abort(errXBIOSvalues,"getXBIOSvalues");
            | rcWrongTHSgeometry:  abort(errWrongTHSgeometry,"getDiskGeometry");
            END;
            fixGeometry(DEBUG, BESTFIT,ui[i]);
        END;
    END;
  END;

    (* ------------------------------------------------------------ *)

    CASE cmd OF
    | cmdabout:
        SKIPLOG := TRUE; (* force -l here *)
        CASE aboutwhat OF
        | aboutunit:
            doCmdParms (DEBUG,ALTFORMAT,SKIPLOG,ui[ndxsource],"");
        ELSE

(*%T TESTING *)
ui[ndxsource].blockcount := 10000;
ui[ndxtarget].blockcount := 20000;
ui[ndxsource].lastBlock  := ui[ndxsource].blockcount-1;
ui[ndxtarget].lastBlock  := ui[ndxtarget].blockcount-1;
(*%E *)

            doCmdParms (DEBUG,ALTFORMAT,SKIPLOG,ui[ndxsource],strSource);
            WrLn;
            doCmdParms (DEBUG,ALTFORMAT,SKIPLOG,ui[ndxtarget],strTarget);
            WrLn;
            i:=highestcard( Str.Length(strSource) , Str.Length(strTarget) );

            IF aboutwhat # aboutbackup THEN
            aboutGeometries (SKIPLOG,i,opfirstblock,oplastblock,
                            ui[ndxsource].blockcount,ui[ndxtarget].blockcount);
            ELSE
            aboutGeometriesAdv (SKIPLOG,i,
                               opfirstblock,oplastblock,optargetfirstblock,
                               ui[ndxsource],ui[ndxtarget]);
            END;
        END;
    | cmdverify:
        IGNOREFATAL:=TRUE; (* force -u because Esc key should be enough *)

        i:=doCmdVerify (DEBUG,ALTFORMAT,SKIPLOG,IGNOREFATAL,WINWARN,MODEWARN,
                       VEREADFY,SHOWPERCENT,SHOWPERCENTONLY,DESPERATE,
                       opfirstblock,oplastblock,ui[ndxsource]);
        CASE i OF
        | errBlockRange: abort(i,fmtlc(ui[ndxsource].blockcount-1,10,1,"",""));
        | errFatal:      abort(i,"doCmdVerify");
        ELSE
                         abort(i,"");
        END;
    | cmdclone:

(*%T TESTING *)
ui[ndxsource].blockcount := 10000;
ui[ndxtarget].blockcount := 20000;
ui[ndxsource].lastBlock  := ui[ndxsource].blockcount-1;
ui[ndxtarget].lastBlock  := ui[ndxtarget].blockcount-1;
(*%E *)

        i:=doCmdClone  (DEBUG,ALTFORMAT,SKIPLOG,IGNOREFATAL,WINWARN,MODEWARN,
                       REALLY,AUTORANGE,AUTOCONFIRM,DESPERATE,PARANO,SHOWPERCENT,SHOWPERCENTONLY,
                       opfirstblock,oplastblock,
                       ui[ndxsource],ui[ndxtarget]);
        CASE i OF
        | errFatal:      abort(i,"doCmdClone");
        ELSE
                         abort(i,"");
        END;
    | cmdbackup:

(*%T TESTING *)
ui[ndxsource].blockcount := 10000;
ui[ndxtarget].blockcount := 20000;
ui[ndxsource].lastBlock  := ui[ndxsource].blockcount-1;
ui[ndxtarget].lastBlock  := ui[ndxtarget].blockcount-1;
(*%E *)

        i:=doCmdBackup (DEBUG,ALTFORMAT,SKIPLOG,IGNOREFATAL,WINWARN,MODEWARN,
                       REALLY,AUTORANGE,AUTOCONFIRM,DESPERATE,PARANO,SHOWPERCENT,SHOWPERCENTONLY,
                       opfirstblock,oplastblock,optargetfirstblock,
                       ui[ndxsource],ui[ndxtarget]);
        CASE i OF
        | errFatal:      abort(i,"doCmdBackup");
        ELSE
                         abort(i,"");
        END;
    | cmdaboutallunits:
        SKIPLOG := TRUE; (* force -l here *)
        ucount:=0;
        i:=ndxsource;
        FOR j := 1 TO 4 DO
            Str.Concat(S,"$8",CHR ( ORD("0") + j -1) );
            IF doCmdParmsAlt (DEBUG,SKIPLOG,FAKERESET,FIXBADTHS,ALTFORMAT,
                             PIO,DMA,PREFETCH, SHOWFAILURE,
                             BESTFIT, S) THEN INC(ucount);END;
        END;
        IF ucount = 0 THEN abort(errNoUnit,"");END;
    END;

IF DYNALLOC THEN
    (* yes, we know we let good old DOS handle this with earlier abort() calls *)
    releaseMem(pbuffTrack);
END;

    abort(errNone,"");
END uClone.






(*

in order to retry problematic individual blocks (-cc) :

copy uclone.log retry.bat

newline -k "cloning block to"            retry.bat
columns -d 1 30                          retry.bat
trim -b                                  retry.bat
newline -a ",1"                          retry.bat
newline -p "uclone $80 $81 -apply -yes " retry.bat

batch will have fixes in this form :

uclone $80 $81 -apply -yes 344516,1

note whole tracks (-c) would require ",63" of course

*)




(*
@echo off
set p=uclone $80 $81
if "%1%" == "" goto help
goto %1

:A
rem 20000 20000
set f=idem

echo.           >  %f%
%p% 25000,10000 >> %f%
%p% 15000,10000 >> %f%
%p%  5000,10000 >> %f%
%p%  5000,1000  >> %f%
%p%             >> %f%
goto end

:B
rem 20000 10000
set f=smaller
echo.           >  %f%
%p% 25000,10000 >> %f%
%p% 15000,10000 >> %f%
%p%  5000,10000 >> %f%
%p%  5000,1000  >> %f%
%p%             >> %f%
goto end

:C
rem 10000 20000
set f=bigger
echo.           >  %f%
%p% 25000,10000 >> %f%
%p% 15000,10000 >> %f%
%p%  5000,10000 >> %f%
%p%  5000,1000  >> %f%
%p%             >> %f%
goto end

:help
echo.
echo Syntax : %0 A=idem / B=smaller / C=bigger
goto end

:end
set f=
set p=
*)




(* // seems IBM PS/2 specific

TYPE
    driveInfoBlockType = RECORD (* 512 bytes *)
        cfg       : WORD;
        cyls      : WORD;
        rsvd      : WORD;
        heads     : WORD;
        bPerTrack : WORD;
        bPerSector: WORD;
        sPerTrack : WORD;
        vendorspecific : ARRAY [1..6] OF BYTE;
        serialnumber   : ARRAY [1..20] OF CHAR; (* 0000H = not specified *)
        buffertype     : WORD;
        buffsize       : WORD;
        eccnum         : WORD;
        firmware       : ARRAY [1..8] OF CHAR;  (* 0000H = not specified *)
        modelnumber    : ARRAY [1..40] OF CHAR; (* 0000H = not specified *)
        vendorunique   : WORD;
        doublewordcap  : WORD;
        capabilities   : WORD;
        rsvd2          : WORD;
        PIOtiming      : WORD;
        DMAtiming      : WORD;
        transla        : WORD;
        currcyls       : WORD;
        currheads      : WORD;
        currSperT      : WORD;
        currsectors    : LONGWORD;
        rsvd3          : WORD;
        undefined      : ARRAY [1..136] OF BYTE;
        rsvdvendor     : ARRAY [1..64] OF BYTE; (* at $100 *)
        rsvd4          : ARRAY [1..96] OF BYTE;
        filler         : ARRAY [1..96] OF BYTE; (* make buffer 512 *)
    END;

(* 1325----INT 13 - HARD DISK - PS/1 and newer PS/2 - IDENTIFY DRIVE *)

PROCEDURE identifyUnit(DEBUG:BOOLEAN; unit:BYTE);
VAR
    R : SYSTEM.Registers;
    nfo:driveInfoBlockType;
    i,imax,n:CARDINAL;
    ch:CHAR;
BEGIN
IF DEBUG THEN WrStr("::: identifyUnit");WrLn;END;

    R.AH := 25H;
    R.DL := unit;
    R.ES := Seg(nfo);
    R.BX := Ofs(nfo);
    Lib.Intr (R,13H);
    IF NOT (SYSTEM.CarryFlag IN R.Flags) THEN
        FOR n:=1 TO 3 DO
            CASE n OF
            | 1: imax:=20; WrStr("Serial number : ");
            | 2: imax:=8;  WrStr("Firmware      : ");
            | 3: imax:=40; WrStr("Model number  : ");
            END;
            i:=1-1;
            LOOP
                INC(i);
                IF i > imax THEN EXIT; END;
                CASE n OF
                | 1 : ch:=nfo.serialnumber[i];
                | 2 : ch:=nfo.firmware[i];
                | 3 : ch:=nfo.modelnumber[i];
                END;
                IF ch = CHR(00H) THEN EXIT; END;
                WrStr(ch);
            END;
            WrLn;
        END;
    ELSE
        WrStr("unsupported $1325 call !");WrLn; (* pb ! *)
    END;
END identifyUnit;

*)

