{
* qmsgs (unit)
* Copyright (c) 2003-2005 Andreas K. Foerster <akfquiz@akfoerster.de>
*
* Thanks to
* Martin Guy for italiano
* Tommy Jensen for dansk
*
* This file contains characters in UTF-8 - keep that encoding
*
* Environment: FreePascal or GNU-Pascal
*
* This file is part of AKFQuiz
*
* AKFQuiz is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* AKFQuiz is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
*}

{$IfDef FPC}
  {$Mode Delphi}
  {$Smartlink on}
{$EndIf}

{ compatiblity definition }
{$IfDef _WIN32} {$Define Win32} {$EndIf}


unit qmsgs;

interface
uses qsys;

{ must end with a slash
  see also:  msg_URI }
const Homepage = 'http://akfoerster.de/akfquiz/';

type languages = (deutsch, english, italiano, dansk);

var lang : languages = english;

procedure setmsgconverter(p: Tconverter);

function msg_advertisement: mystring;
function msg_anykey(const key: string): mystring;
function msg_noquizfound: mystring;
function msg_filenotfound: mystring;
function msg_quiz: mystring;
function msg_author: mystring;
function msg_translator: mystring;
function msg_right: mystring;
function msg_wrong: mystring;
function msg_points: mystring;
function msg_seen: mystring;
function msg_really: mystring;
function msg_sol1: mystring;
function msg_sol2: mystring;
function msg_sol3: mystring;
function msg_sol4: mystring;
function msg_sol5: mystring;
function msg_error: mystring;
function msg_fileerror: mystring;
function msg_result: mystring;
function msg_solution: mystring;
function msg_new: mystring;
function msg_made: mystring;
function msg_back: mystring;
function msg_URI: mystring;
function msg_noJS: mystring;
function msg_notusable: mystring;
function msg_assessment: mystring;


Implementation

var cnv: Tconverter = noconversion;

procedure setmsgconverter(p: Tconverter);
begin
cnv := p
end;

{ Translators: }
{ if you need an apostrophe, use it twice like this: 'That''s it' }
{ use the function cnv if and only if you use non-ASCII chars }

function msg_advertisement: mystring;
begin
{ may be used for other advertisements }
{ just one line! }

{$IfDef Advertisement}
  case lang of
    deutsch  : msg_advertisement := 
        cnv('Das original AKFQuiz ist für GNU/Linux erhältlich');
    dansk    :  msg_advertisement := 
        'Den oprindelige AKFQuiz findes til GNU/Linux';
    otherwise  msg_advertisement := 
        'The original of AKFQuiz is available for GNU/Linux'
    end
{$Else}
  msg_advertisement := '' { to reduce the size of the binary  }
{$EndIf}
end;

function msg_noquizfound: mystring;
begin
case lang of
  deutsch : msg_noquizfound := 'Keine AKFQuiz-Dateien gefunden';
  italiano: msg_noquizfound := 'Nessum AKFQuiz-Archivio trovato';
  dansk   : msg_noquizfound := 'Ingen AKFQuiz filer fundet';
  otherwise msg_noquizfound := 'No AKFQuiz-files found'
  end
end;

function msg_filenotfound: mystring;
begin
case lang of 
  deutsch : msg_filenotfound := 'Fehler: Datei nicht gefunden';
  italiano: msg_filenotfound := 'Errore: Archivio non trovato';
  dansk   : msg_filenotfound := 'Fejl: Fil ikke fundet';
  otherwise msg_filenotfound := 'Error: file not found'
  end
end;

function msg_anykey(const key: string): mystring;
begin
case lang of
  deutsch : 
    if key='' 
      then msg_anykey := 'beliebige Taste zum Fortfahren...'
      else msg_anykey := 
             'beliebige Taste zum Fortfahren, oder ['+key+'] zum Beenden...';
  italiano : 
    if key='' 
      then msg_anykey := 'Premere un tasto per continuare...'
      else msg_anykey := 
            'Premere un tasto per continuare o ['+key+'] per uscire...';
  dansk :
    if key='' 
      then msg_anykey := cnv('Tryk på en tast for at fortsætte...')
      else msg_anykey := cnv('Tryk på en tast for at fortsætte eller ['+
                             key+'] for at stoppe...');
  otherwise if key='' 
              then msg_anykey := 'press any key to continue...'
              else msg_anykey := 
	           'press any key to continue or ['+key+'] to stop...'
  end
end;

function msg_quiz: mystring;
begin
case lang of
  deutsch,
  italiano,
  dansk    : msg_quiz := 'QUIZ: ';
  otherwise  msg_quiz := 'QUIZ: '
  end
end;

function msg_author: mystring;
begin
case lang of
  deutsch  : msg_author := 'AUTOR: ';
  italiano : msg_author := 'AUTORE: ';
  dansk    : msg_author := 'FORFATTER: '
  otherwise  msg_author := 'AUTHOR: '
  end
end;

function msg_translator: mystring;
begin
case lang of
  deutsch  : msg_translator := cnv('ÜBERSETZER: ');
  italiano : msg_translator := 'TRADUTTORE: ';
  dansk    : msg_translator := cnv('OVERSÆTTER: ');
  otherwise  msg_translator := 'TRANSLATOR: '
  end
end;

function msg_right: mystring;
begin
case lang of
  deutsch  : msg_right := 'richtig';
  italiano : msg_right := 'giusto';
  dansk    : msg_right := 'rigtigt';
  otherwise  msg_right := 'right'
  end
end;
	 
function msg_wrong: mystring;
begin
case lang of
  deutsch  : msg_wrong := 'leider falsch';
  italiano : msg_wrong := 'sbagliato, mi dispiace';
  dansk    : msg_wrong := 'beklager, det er forkert';
  otherwise  msg_wrong := 'wrong, sorry'
  end
end;

function msg_points: mystring;
begin
case lang of
  deutsch  : msg_points := 'Punkte: ';
  italiano : msg_points := 'punti: ';
  dansk    : msg_points := 'point: '; {???}
  otherwise  msg_points := 'points: '
  end
end;
 
function msg_seen: mystring;
begin
case lang of
  deutsch  : msg_seen := cnv('Du hast die Lösung doch schon gesehen!');
  italiano : msg_seen := cnv('Ehi! Hai già visto la soluzione!');
  dansk    : msg_seen := cnv('Du har jo allerede set løsningen!');
  otherwise  msg_seen := 'Hey, you have seen the solution already!'
  end
end;

function msg_really: mystring;
begin
case lang of
  deutsch  : msg_really := cnv('Wirklich die Lösung zeigen?');
  italiano : msg_really := 'Vuoi vedere la soluzione davvero?';
  dansk    : msg_really := cnv('Ønsker du virkelig at se løsningen?');
  otherwise  msg_really := 'You really want to see the solution?'
  end
end;

function msg_sol1: mystring;
begin
case lang of
  deutsch  : msg_sol1 := 'Du hast ';
  italiano : msg_sol1 := 'Hai guagadnato ';
  dansk    : msg_sol1 := cnv('Du har fået ');
  otherwise  msg_sol1 := 'You have gained '
  end
end;

function msg_sol2: mystring;
begin
case lang of
  deutsch  : msg_sol2 := ' von maximal ';
  italiano : msg_sol2 := ' dei ';
  dansk    : msg_sol2 := ' af ';
  otherwise  msg_sol2 := ' of '
  end
end;

function msg_sol3: mystring;
begin
case lang of
  deutsch  : msg_sol3 := ' Punkten.';
  italiano : msg_sol3 := ' punti possibili.';
  dansk    : msg_sol3 := ' mulige point.';
  otherwise  msg_sol3 := ' possible points.'
  end
end;

function msg_sol4: mystring;
begin
case lang of
  deutsch  : msg_sol4 := 'Das sind ';
  italiano : msg_sol4 := cnv('Ciò fà ');
  dansk    : msg_sol4 := 'Det giver ';
  otherwise  msg_sol4 := 'That makes '
  end
end;

function msg_sol5: mystring;
begin
case lang of
  deutsch  : msg_sol5 := 'Das sind leider nicht genug.';
  italiano : msg_sol5 := 'Mi dispiace, ma non basta.';
  dansk    : msg_sol5 := 'Beklager, det er ikke nok.';
  otherwise  msg_sol5 := 'Sorry, that''s not enough.'
  end
end;

function msg_error: mystring;
begin
case lang of
  deutsch  : msg_error := 'Fehler';
  italiano : msg_error := 'Errore';
  dansk    : msg_error := 'Fejl';
  otherwise  msg_error := 'Error'
  end
end;

function msg_fileerror: mystring;
begin
case lang of
  deutsch  : msg_fileerror := 'Fehler in der Eingabe-Datei';
  italiano : msg_fileerror := 'Errore nell''archivio di input';
  dansk    : msg_fileerror := 'Fejl i input filen';
  otherwise  msg_fileerror := 'Error in input file'
  end
end;

function msg_result: mystring;
begin
case lang of
  deutsch  : msg_result := 'Auswertung';
  italiano : msg_result := 'risultato';
  dansk    : msg_result := 'resultat';
  otherwise  msg_result := 'result'
  end
end;

function msg_solution: mystring;
begin
case lang of
  deutsch  : msg_solution := cnv('Auflösung');
  italiano : msg_solution := 'soluzione';
  dansk    : msg_solution := cnv('løsning');
  otherwise  msg_solution := 'solution'
  end
end;

function msg_new: mystring;
begin
case lang of
  deutsch  : msg_new := 'neu';
  italiano : msg_new := 'nuovo';
  dansk    : msg_new := 'ny';
  otherwise  msg_new := 'new'
  end
end;

function msg_made: mystring;
begin
case lang of
  deutsch  : msg_made := 'erstellt mit';
  italiano : msg_made := 'Creato con';
  dansk    : msg_made := 'skabt ved brug af'; {???}
  otherwise  msg_made := 'made using'
  end
end;

function msg_back: mystring;
begin
case lang of
  deutsch  : msg_back := cnv('zurück');
  italiano : msg_back := 'Indietro';
  dansk    : msg_back := 'tilbage';
  otherwise  msg_back := 'back'
  end
end;

function msg_URI: mystring;
begin
case lang of
  deutsch  : msg_URI := 'index.de.html';
  otherwise  msg_URI := 'index.html'
  end
end;

function msg_noJS: mystring;
begin
case lang of
  deutsch  : 
    msg_noJS := cnv('JavaScript nicht verfügbar oder deaktiviert');
  italiano : 
    msg_noJS := cnv('JavaScript o non è disponibile o è disattivato');
  dansk    : msg_noJS := 'JavaScript ikke installeret eller deaktiveret';
  otherwise  msg_noJS := 'JavaScript not available or deactivated'
  end
end;

function msg_notusable: mystring;
begin
case lang of
  deutsch  : msg_notusable := 'Quiz nicht benutzbar!';
  italiano : msg_notusable := 'Quiz non utilizzabile!';
  dansk    : msg_notusable := 'Quizzen kan ikke bruges!';
  otherwise  msg_notusable := 'Quiz not usable!'
  end
end;

function msg_assessment: mystring;
begin
case lang of
  deutsch  : msg_assessment := 'Auswertung';
  dansk    : msg_assessment := cnv('bedømmelse');
  otherwise  msg_assessment := 'assessment'
  end
end;

end.
