{
* qsys (unit)
* Copyright (c) 2004-2005 Andreas K. Foerster <akfquiz@akfoerster.de>
*
* Environment: FreePascal or GNU-Pascal
*
* This file is part of AKFQuiz
*
* AKFQuiz is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* AKFQuiz is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
*}

{ system specific stuff for AKFQuiz }

{$X+}
{$I-}

{$IfDef FPC}
  {$Mode Delphi}
  {$Smartlink on}
{$EndIf}


{ compatiblity definition }
{$IfDef _WIN32} {$Define Win32} {$EndIf}


unit qsys;

interface

{$IfDef __GPC__}

  import GPC (GetEnv => GetEnvironmentVariable,
              FSearch => FileSearch,
	      FExpand => ExpandFilename,
	      DirFromPath => ExtractFilePath,
              DirSeparator => DirectorySeparator,
              LineBreak => LineEnding);
  {$IfDef Win32}
         Winprocs (GetEnvironmentVariable => WGetEnvironmentVariable); 
	 WinTypes;
  {$EndIf}

{$Else}

    uses
    {$IfDef Win32}
       Windows,
    {$EndIf} { Win32 }
    SysUtils;

{$EndIf} { __GPC__ }


{$IfDef FPC}
    type mystring = ansistring; { Delphi dialect (unlimited length) }
{$Else}
    type mystring = string(2048); { Extended Pascal }
{$EndIf}

type shortstring = string[255]; { needed by GPC }

type Tshowentry = procedure(const s : string);
type Tconverter = function(const s: string): mystring;

{ Displays for which converters are there }
type DisplayType = (ISOdisplay, OEMdisplay, UTF8display);

{ only used on very few systems - on most it's autodetected }
{$IfDef UNIX}
  const defaultPrefix = '/usr/local';
{$Else}
  const defaultPrefix = '';
{$EndIf}

const quizext  = '.akfquiz';
const quizext2 = '.aqz';

const platform =
{$IfDef __GPC__} 'GPC'; {$EndIf}
{$IfDef FPC}     'FPC '+{$I %FPCTARGETOS%}+'/'+{$I %FPCTARGETCPU%};
{$EndIf}

{ what platforms have charset IBM850 as default? }
{$IfDef DPMI}       {$Define IBM850} {$EndIf}
{$IfDef __OS_DOS__} {$Define IBM850} {$EndIf}
{$IfDef MSDOS}      {$Define IBM850} {$EndIf}

{ IBM850 is supported by more webbrowsers than IBM437,
  but in most every case it's okay to pretend it's 850 }

{$IfDef IBM850}
  const sys_charset = 'IBM850'; { see comment above }
{$Else}
  {$IfDef Win32}
    const sys_charset = 'WINDOWS-1252';
  {$Else}
    const sys_charset = 'ISO-8859-1';
  {$EndIf}
{$EndIf}

const TAB = chr(9);
const nl = LineEnding;

{ HTML 4.01 is the last HTML definition
  Transitional is needed, because of the "target" attribute }
const HTML4DTD = 'http://www.w3.org/TR/REC-html4/loose.dtd';
const HTMLDoctype =
    '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"'+nl+
    '"'+HTML4DTD+'">';

{ Attetion:
  XHTML conflicts with the JavaScript implementation! }
const XHTML1DTD = 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd';
const XHTMLDoctype =
    '<?xml version="1.0" encoding="iso-8859-1"?>'+nl+
    '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"'+nl+
    '"'+XHTML1DTD+'">';

const xmlns='http://www.w3.org/1999/xhtml';

var 
  QuestionSignal, { for filechooser }
  RightSignal,
  FalseSignal,
  InfoSignal,  { for result screen }
  ErrorSignal: procedure;

function makeUpcase(x: string): mystring;
function stripWhitespace(x: string): mystring;
function Min(a, b: LongInt): LongInt;
function Max(a, b: LongInt): LongInt;
{ remove to last dot }
function stripext(const s: string): mystring;

function basename(const s: string): mystring;
function getnextdir(var rest: mystring): mystring;
function getquizpath: mystring;
function getquizdir: mystring; { first dir from QUIZPATH }
function useDirSeparator(const s: string): mystring;

{ searches quizfile: }
function getquizfile(var s: mystring): boolean; 
function quizfileExists(const s: string): boolean;
function gethtmlname(s: mystring): mystring;
function ListEntries(const path, ext: string; showentry: Tshowentry): boolean;
procedure nobreak;
procedure setLFNsupport;

{ check what the display supports }
function checkOEM: boolean;
function checkUTF8: boolean;
function getSystemLanguage: mystring;

{ procedures for signal variables }
procedure NoSignal;
procedure SystemBeep;

{ assign all signals: }
procedure DisableSignals;
procedure useBeepSignals; { use system beeps (#7) }

{ for Tconverter }
{ OEM means IBM850, but it can also be used for IBM437 }

function Latin1toUTF8(const s: string): mystring;
function UTF8toLatin1(const s: string): mystring;
function Latin1toOEM(const s: string): mystring;
function OEMtoLatin1(const s: string): mystring;
function OEMtoUTF8(const s: string): mystring;
function UTF8toOEM(const s: string): mystring;
{ HTML numeric entities: }
function Latin1toHTML(const s: string): mystring;
function UTF8toHTML(const s: string): mystring; {@@@}
function forceASCII(const s: string): mystring;
function noconversion(const s: string): mystring;

{ length of real characters in a UTF8 string }
function UTF8CharNum(const s: string): LongInt;

function GetSecs: Cardinal;

{$IfDef __GPC__}
  function IntToStr(i: integer): mystring;
{$EndIf}

implementation

{ I'm still using FPC 1.0.10 under DOS due to problems with newer versions }
{$IfDef FPC}{$IfDef VER1_0}
  {$INFO 1_0}
  uses DOS; { for GetEnv }
{$EndIf}{$EndIf}

{$I transtab.inc}

var QUIZPATH : mystring;


{$IfDef FPC}{$IfDef VER1_0}
  function GetEnvironmentVariable(s: string): mystring;
  begin
  GetEnvironmentVariable := GetEnv(s)
  end;
{$EndIf}{$EndIf}

function Min(a, b: LongInt): LongInt;
begin
if a<b then Min := a else Min := b
end;

function Max(a, b: LongInt): LongInt;
begin
if a>b then Max := a else Max := b
end;

{ removes leading and trailing spaces and tabs }
function stripWhitespace(x: string): mystring;
var len, f, t: integer;
begin
len := length(x);
f := 1;
t := len;
while (f<len) and ((x[f]=' ') or (x[f]=TAB)) do f := succ(f);
while (t>1) and ((x[t]=' ') or (x[t]=TAB) or (x[t]=chr(13)))
  do t := pred(t);
if f<=t 
  then stripWhitespace := copy(x, f, t)
  else stripWhitespace := ''
end;

function makeUpcase(x: string): mystring;
begin
{$IfDef __GPC__}
  makeUpcase := UpcaseStr(x)
{$Else}
  makeUpcase := Uppercase(x)
{$EndIf}
end;

procedure NoSignal;
begin end;

procedure SystemBeep;
begin Write(#7) end;

procedure DisableSignals;
begin
QuestionSignal := NoSignal;
RightSignal    := NoSignal;
FalseSignal    := NoSignal;
InfoSignal     := NoSignal;
ErrorSignal    := NoSignal
end;

procedure useBeepSignals;
begin
QuestionSignal := NoSignal;
RightSignal    := NoSignal;
FalseSignal    := SystemBeep;
InfoSignal     := SystemBeep;
ErrorSignal    := SystemBeep
end;

function getSystemLanguage: mystring;
var l: mystring;
begin
l := GetEnvironmentVariable('LANG');

{$IfDef Win32}
  if l='' then
    case (GetUserDefaultLangID and $03FF) of
      { GPC doesn't have the LANG constants yet }
      $36 : l := 'af';
      $04 : l := 'zh';
      $05 : l := 'cs';
      $06 : l := 'da';
      $13 : l := 'nl';
      $09 : l := 'en';
      $0B : l := 'fi';
      $0C : l := 'fr';
      $07 : l := 'de';
      $08 : l := 'el';
      $0D : l := 'he';
      $10 : l := 'it';
      $11 : l := 'jp';
      $14 : l := 'no';
      $15 : l := 'pl';
      $16 : l := 'pt';
      $19 : l := 'ru';
      $0A : l := 'es';
      $1D : l := 'sv';
      $1F : l := 'tr';
      { ... to be continued @@ }
      end;
{$EndIf}

getSystemLanguage := l
end;

function useDirSeparator(const s: string): mystring;
begin
{$IfDef __GPC__}
  useDirSeparator := ForceAddDirSeparator(s)
{$Else}
  useDirSeparator := IncludeTrailingPathDelimiter(s)
{$EndIf}
end;

{$IfDef NoRelocation}

  function getprefix: mystring;
  begin
  getprefix := defaultPrefix
  end;

{$Else} { Relocation }

  function searchExecutable(const s: mystring): mystring;
  begin
  searchExecutable := FileSearch(s, GetEnvironmentVariable('PATH'))
  end;

  function getprefix: mystring;
  var s: mystring;
  begin
  s := ParamStr(0);
  if s='' 
    then getprefix := defaultPrefix
    else begin
         if pos(DirectorySeparator, s)=0 { no directory given }
           then s := searchExecutable(s);
         getprefix := ExpandFileName(ExtractFilePath(s)+'..')
         end
  end;
 
{$EndIf} { NoRelocation }


{ search for Parameter -d }
function getparamdir: mystring;
var i, count : integer;
begin
{ search for Parameter -d }
count := ParamCount;
i:=1;
while (i<count) 
      and (ParamStr(i)<>'-d') 
      and (ParamStr(i)<>'-D') 
        do inc(i);
if (i<count) and ((ParamStr(i)='-d') or (ParamStr(i)='-D')) 
  then getparamdir := ParamStr(i+1)
  else getparamdir := ''
end;

function getnextdir(var rest: mystring): mystring;
var p: integer;
begin
p := pos(PathSeparator, rest);
if p<>0 
  then begin
       getnextdir := copy(rest, 1, p-1);
       delete(rest, 1, p)
       end
  else begin
       getnextdir := rest;
       rest := ''
       end
end;

function getquizpath: mystring;
begin
getquizpath := QUIZPATH
end;

function getquizdir: mystring;
var d: mystring;
begin
{ must be in a separate variable for getnextdir changes the content }
d := QUIZPATH;

{ only one directory! }
getquizdir := getnextdir(d)
end;

function getquizfile(var s: mystring): boolean;
var e, path: mystring;
begin
{ only search, when s hasn't a path yet }
if pos(DirectorySeparator, s)<>0 
  then getquizfile := FileExists(s)
  else begin
       path := QUIZPATH;
       e := FileSearch(s, path);
       if e='' then
          e := FileSearch(s+quizext, path);
       if e='' then
          e := FileSearch(s+quizext2, path);
       s := e;
       getquizfile := (e<>'')
       end
end;

function quizfileExists(const s: string): boolean;
begin
quizfileExists := FileExists(s) and not DirectoryExists(s)
end;

{ remove to last dot }
function stripext(const s: string): mystring;
var i: integer;
begin
i:=length(s);
while (i>1) and (s[i]<>'.') do i := i - 1;
dec(i);
if i>1 then stripext := copy(s, 1, i)
       else stripext := s
end;

{ functions for Tconvert }

function noconversion(const s: string): mystring;
begin
noconversion := s
end;

function forceASCII(const s: string): mystring;
var 
  i: integer;
  e: mystring;
begin
e := s;
for i := 1 to Length(e) do 
  if (e[i]<#32) or (e[i]>#127) then e[i] := '?';
forceASCII := e
end;

function Latin1toUTF8(const s: string): mystring;
var
  i : integer;
  e : mystring;
begin
e := '';
for i := 1 to length(s) do
  if s[i] < #$80
     then e := e + s[i]
     else e := e + chr($C0 or (ord(s[i]) shr 6)) +
                   chr($80 or (ord(s[i]) and $3F));
Latin1toUTF8 := e
end;


function UTF8toLatin1(const s: string): mystring;
var
  i : integer;
  e : mystring;
begin
e := '';
i := 1;
while i <= length(s) do
  begin
    case s[i] of
     #$00..#$7F : e := e + s[i];
     #$C2       : begin
                  inc(i); { next char }
                  e := e + chr($80 or (ord(s[i]) and $3F))
                  end;
     #$C3       : begin
                  inc(i); { next char }
                  e := e + chr($C0 or (ord(s[i]) and $3F))
                  end;
      { simply ignoring everything else should be okay
        it cannot be translated anyway, while it IMHO doesn't
        conflict with the other codes }
      end; { case }
   inc(i)
   end;

UTF8toLatin1 := e
end;

function UTF8toHTML(const s: string): mystring; {@@@}
var
  i,v : integer;
  e : mystring;
begin
e := '';
i := 1;
while i <= length(s) do
  begin
    case s[i] of
     #$00..#$7F : e := e + s[i];
     #$C2..#$DF : begin { 2 byte encoding }
                  v := (ord(s[i]) and $1F) shl 6;
                  inc(i); { second byte }
                  v := v + (ord(s[i]) and $3F);
                  e := e + '&#' + IntToStr(v) + ';'
                  end;
     #$E0..#$EF : begin { 3 byte encoding }
                  inc(i,2) { ignore for now @@@ }
                  end;
     #$F0..#$FF : begin { 4 byte encoding }
                  inc(i,3) { ignore for now @@@ }
                  end;
     { @@@ }
     end; { case }
  inc(i)
  end;

UTF8toHTML := e
end;

function Latin1toHTML(const s: string): mystring;
var
  i : integer;
  e : mystring;
begin
{ HTML entities are coded as unicode.
  But Latin1 code-nubers are equivalent with unicode (subset) }
e := '';
for i := 1 to length(s) do
  if s[i] < #$80
     then e := e + s[i]
     else e := e + '&#' + IntToStr(ord(s[i])) + ';';

Latin1toHTML := e
end;

function Latin1toOEM(const s: string): mystring;
var
  i : integer;
  e : mystring;
begin
e := s;
for i := 1 to length(e) do
  if e[i] >= #$80 then
    e[i] := Latin1toOEMTable[e[i]];
Latin1toOEM := e
end;


function OEMtoLatin1(const s: string): mystring;
var
  i : integer;
  e : mystring;
begin
e := s;
for i := 1 to length(e) do
  if e[i] >= #$80 then
    e[i] := OEMtoLatin1Table[e[i]];
OEMtoLatin1 := e
end;

function OEMtoUTF8(const s: string): mystring;
begin
OEMtoUTF8 := Latin1toUTF8(OEMtoLatin1(s))
end;

function UTF8toOEM(const s: string): mystring;
begin
UTF8toOEM := Latin1toOEM(UTF8toLatin1(s))
end;

function UTF8CharNum(const s: string): LongInt;
var i, res: LongInt;
begin
res := 0;
{ count ASCII bytes and start bytes, ignore the rest }
for i := 1 to length(s) do
   if (ord(s[i])<=127) or (ord(s[i])>=$C0) then inc(res);
UTF8CharNum := res
end;

function basename(const s: string): mystring;
begin
{$IfDef __GPC__}
  basename := NameExtFromPath(s)
{$Else}
  basename := ExtractFileName(s)
{$EndIf}
end;

{$IfDef __GPC__}

  function gethtmlname(s: mystring): mystring;
  var path, name, ext: mystring;
  begin
  FSplit(s, path, name, ext);
  gethtmlname := name + '.html'
  end;

{$Else}

  function gethtmlname(s: mystring): mystring;
  begin
  gethtmlname := ChangeFileExt(ExtractFileName(s), '.html')
  end;

{$EndIf}

{$IfDef __GPC__}
  function ListEntries(const path, ext: string; showentry: Tshowentry): boolean;
  var
    d: DirPtr;
    s: TString;
    found: boolean;
  begin
  found := false;
  if path=''
    then d := OpenDir('.')
    else d := OpenDir(path);
  if IOResult=0 then
    begin
    s := ReadDir(d);
    while s<>'' do
      begin
      if s[length(s)-length(ext)+1 .. length(s)] = ext then
         begin
         showentry(s);
         found := true
         end;
      s := ReadDir(d)
      end
    end;
  CloseDir(d);
  ListEntries := found
  end;

{$Else} { not GPC }

  function ListEntries(const path, ext: string; showentry: Tshowentry): boolean;
  var
    info  : TSearchRec;
    rslt  : LongInt;
    found : boolean;
  begin
  found := false;

  if path=''
     then rslt := SysUtils.FindFirst('*'+ext, FaAnyFile, info)
     else rslt := SysUtils.FindFirst(path+DirectorySeparator+'*'+ext, FaAnyFile, info);
  if rslt=0 then found := true;

  while rslt=0 do
     begin
     showentry(info.name);
     rslt := SysUtils.FindNext(info)
     end;
  SysUtils.FindClose(info);

  ListEntries := found
  end;
{$EndIf} { not __GPC__}

procedure nobreak;
begin
{ SetCBreak(false) } {@@@ too DOS specific }
end;

procedure setLFNsupport;
begin
{$IfDef FPC}
  {$IfDef Go32v2}
    LFNsupport := true;
    FileNameCaseSensitive := true
  {$EndIf}
{$EndIf}
end;

function checkUTF8: boolean;
var
 UTF8 : boolean;
 s: mystring;
begin
UTF8 := false;

s := makeUpcase(GetEnvironmentVariable('MM_CHARSET'));
if (s='UTF-8') or (s='UTF8') then UTF8 := true;

s := makeUpcase(GetEnvironmentVariable('LANG'));
if (pos('UTF-8', s)<>0) or (pos('UTF8', s)<>0) then UTF8 := true;

checkUTF8 := UTF8
end;

function checkOEM: boolean;
var s: mystring;
begin
{ Windows uses different charsets in the Editor and in console mode }
{$IfDef Win32} {$Define OEM} {$EndIf}
{$IfDef DPMI} {$Define OEM} {$EndIf}
{$IfDef __OS_DOS__} {$Define OEM} {$EndIf}
{$IfDef MSDOS}      {$Define OEM} {$EndIf}

{$IfDef OEM}
  checkOEM := true;
{$Else}
  s := makeUpcase(GetEnvironmentVariable('MM_CHARSET'));
  checkOEM := (s='DOS') { 'DOS' is not official! }
              or (s='CP850') or (s='CP437')
              or (s='IBM850')or (s='IBM437')
              or (s='850') or (s='437')
{$EndIf}
end;

function GetSecs: Cardinal;
begin
{$IfDef FPC}
  GetSecs := trunc(TimestampToMSecs(DateTimeToTimestamp(Now))/1000)
{$Else}
  GetSecs := 0 {@@@}
{$EndIf}
end;

{$IfDef __GPC__}
  function IntToStr(i: integer): mystring;
  var s: mystring;
  begin
  str(i, s);
  IntToStr := s
  end;
{$EndIf}


begin
disableSignals; { initializes Signals }

QUIZPATH := getParamDir; { highest priority }
if QUIZPATH='' then QUIZPATH := GetEnvironmentVariable('QUIZPATH');
if QUIZPATH='' then 
  QUIZPATH := getprefix+DirectorySeparator+'share'+DirectorySeparator+
              'akfquiz'+PathSeparator+'.';

{$IfDef Go32v2}
  { Compiler checks LFNsupport just on drive C: - that's stupid! :-( }
  if GetEnvironmentVariable('LFN')<>'' then setLFNsupport;

  {$IfDef ForceLFN}
    setLFNsupport;
    {$Info LFN support enforced}
  {$EndIf}
{$EndIf}
end.
