/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.user.CellChangeJobs;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightArea;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.tool.user.ui.MessagesWindow;
import com.sun.electric.tool.user.ui.OutlineListener;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.EDimension;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class CircuitChanges {
    private static double lastRotationAmount = 90.0;

    private CircuitChanges() {
    }

    public static void rotateObjects(int amount) {
        Highlighter highlighter;
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (amount == 0) {
            String val = JOptionPane.showInputDialog("Amount to rotate", (Object)lastRotationAmount);
            if (val == null) {
                return;
            }
            double fAmount = TextUtils.atof(val);
            if (fAmount == 0.0) {
                System.out.println("Null rotation amount");
                return;
            }
            lastRotationAmount = fAmount;
            amount = (int)(fAmount * 10.0);
        }
        ArrayList<Geometric> highs = new ArrayList<Geometric>();
        ArrayList<ElectricObject> highTexts = new ArrayList<ElectricObject>();
        ArrayList<Variable.Key> highTextKeys = new ArrayList<Variable.Key>();
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf != null && (highlighter = wf.getContent().getHighlighter()) != null) {
            for (Highlight high : highlighter.getHighlights()) {
                ElectricObject eobj = high.getElectricObject();
                if (eobj instanceof PortInst) {
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                if (high.isHighlightEOBJ()) {
                    if (!(eobj instanceof Geometric)) continue;
                    highs.add((Geometric)eobj);
                    continue;
                }
                if (!high.isHighlightText()) continue;
                highTexts.add(eobj);
                highTextKeys.add(high.getVarKey());
            }
        }
        if (highs.size() == 0) {
            if (highTexts.size() > 0) {
                new CircuitChangeJobs.RotateText(cell, highTexts, highTextKeys, amount, false, false);
                return;
            }
            System.out.println("Cannot rotate: nothing is selected");
            return;
        }
        new CircuitChangeJobs.RotateSelected(cell, highs, amount, false, false);
    }

    public static void mirrorObjects(boolean horizontally) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Cell cell = wf.getContent().getCell();
        if (cell == null) {
            return;
        }
        ArrayList<Geometric> highs = new ArrayList<Geometric>();
        ArrayList<ElectricObject> highTexts = new ArrayList<ElectricObject>();
        ArrayList<Variable.Key> highTextKeys = new ArrayList<Variable.Key>();
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter != null) {
            for (Highlight high : highlighter.getHighlights()) {
                ElectricObject eobj = high.getElectricObject();
                if (eobj instanceof PortInst) {
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                if (high.isHighlightEOBJ()) {
                    if (!(eobj instanceof Geometric)) continue;
                    highs.add((Geometric)eobj);
                    continue;
                }
                if (!high.isHighlightText()) continue;
                highTexts.add(eobj);
                highTextKeys.add(high.getVarKey());
            }
        }
        if (highs.size() == 0) {
            if (highTexts.size() > 0) {
                new CircuitChangeJobs.RotateText(cell, highTexts, highTextKeys, 0, true, horizontally);
                return;
            }
            System.out.println("Cannot mirror: nothing is selected");
            return;
        }
        new CircuitChangeJobs.RotateSelected(cell, highs, 0, true, horizontally);
    }

    public static void alignToGrid() {
        List<Geometric> selected = MenuCommands.getSelectedObjects(true, true);
        HashSet<NodeInst> selectedNodes = new HashSet<NodeInst>();
        for (Geometric geometric : selected) {
            if (!(geometric instanceof NodeInst)) continue;
            selectedNodes.add((NodeInst)geometric);
        }
        ArrayList<NodeInst> addedNodes = new ArrayList<NodeInst>();
        for (Geometric geom : selected) {
            NodeInst tail;
            if (!(geom instanceof ArcInst)) continue;
            ArcInst ai = (ArcInst)geom;
            NodeInst head = ai.getHead().getPortInst().getNodeInst();
            if (!selectedNodes.contains(head)) {
                addedNodes.add(head);
                selectedNodes.add(head);
            }
            if (selectedNodes.contains(tail = ai.getTail().getPortInst().getNodeInst())) continue;
            addedNodes.add(tail);
            selectedNodes.add(tail);
        }
        for (NodeInst ni : addedNodes) {
            selected.add(ni);
        }
        if (selected.size() == 0) {
            System.out.println("Must select something before aligning it to the grid");
            return;
        }
        EDimension eDimension = User.getAlignmentToGrid();
        if (eDimension.getWidth() <= 0.0 || eDimension.getHeight() <= 0.0) {
            System.out.println("No alignment given: set Alignment Options first");
            return;
        }
        new CircuitChangeJobs.AlignObjects(selected, eDimension);
    }

    public static void alignNodes(boolean horizontal, int direction) {
        ERectangle bounds;
        NodeInst ni;
        int i;
        Cell np = WindowFrame.needCurCell();
        if (np == null) {
            return;
        }
        List<Geometric> list = MenuCommands.getSelectedObjects(true, true);
        if (list.size() == 0) {
            System.out.println("First select objects to move");
            return;
        }
        for (Geometric geometric : list) {
            if (geometric.getParent() == np) continue;
            System.out.println("All moved objects must be in the same cell");
            return;
        }
        ArrayList<NodeInst> nodes = new ArrayList<NodeInst>();
        for (Geometric geom : list) {
            if (!(geom instanceof NodeInst)) continue;
            nodes.add((NodeInst)geom);
        }
        int n = nodes.size();
        if (n == 0) {
            return;
        }
        NodeInst[] nis = new NodeInst[n];
        double[] dCX = new double[n];
        double[] dCY = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            nis[i2] = (NodeInst)nodes.get(i2);
        }
        double lX = 0.0;
        double hX = 0.0;
        double lY = 0.0;
        double hY = 0.0;
        for (i = 0; i < n; ++i) {
            ni = nis[i];
            bounds = ni.getBounds();
            if (i == 0) {
                lX = ((RectangularShape)bounds).getMinX();
                hX = ((RectangularShape)bounds).getMaxX();
                lY = ((RectangularShape)bounds).getMinY();
                hY = ((RectangularShape)bounds).getMaxY();
                continue;
            }
            if (((RectangularShape)bounds).getMinX() < lX) {
                lX = ((RectangularShape)bounds).getMinX();
            }
            if (((RectangularShape)bounds).getMaxX() > hX) {
                hX = ((RectangularShape)bounds).getMaxX();
            }
            if (((RectangularShape)bounds).getMinY() < lY) {
                lY = ((RectangularShape)bounds).getMinY();
            }
            if (!(((RectangularShape)bounds).getMaxY() > hY)) continue;
            hY = ((RectangularShape)bounds).getMaxY();
        }
        block14: for (i = 0; i < n; ++i) {
            ni = nis[i];
            bounds = ni.getBounds();
            dCY[i] = 0.0;
            dCX[i] = 0.0;
            if (horizontal) {
                switch (direction) {
                    case 0: {
                        dCX[i] = lX - ((RectangularShape)bounds).getMinX();
                        break;
                    }
                    case 1: {
                        dCX[i] = hX - ((RectangularShape)bounds).getMaxX();
                        break;
                    }
                    case 2: {
                        dCX[i] = (lX + hX) / 2.0 - ((RectangularShape)bounds).getCenterX();
                    }
                }
                continue;
            }
            switch (direction) {
                case 0: {
                    dCY[i] = hY - ((RectangularShape)bounds).getMaxY();
                    continue block14;
                }
                case 1: {
                    dCY[i] = lY - ((RectangularShape)bounds).getMinY();
                    continue block14;
                }
                case 2: {
                    dCY[i] = (lY + hY) / 2.0 - ((RectangularShape)bounds).getCenterY();
                }
            }
        }
        new CircuitChangeJobs.AlignNodes(nis, dCX, dCY);
    }

    public static void arcRigidCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ChangeArcProperties(cell, CircuitChangeJobs.ChangeArcEnum.RIGID, CircuitChanges.getHighlighted());
    }

    public static void arcNotRigidCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ChangeArcProperties(cell, CircuitChangeJobs.ChangeArcEnum.NONRIGID, CircuitChanges.getHighlighted());
    }

    public static void arcFixedAngleCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ChangeArcProperties(cell, CircuitChangeJobs.ChangeArcEnum.FIXEDANGLE, CircuitChanges.getHighlighted());
    }

    public static void arcNotFixedAngleCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ChangeArcProperties(cell, CircuitChangeJobs.ChangeArcEnum.NONFIXEDANGLE, CircuitChanges.getHighlighted());
    }

    public static void arcDirectionalCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ChangeArcProperties(cell, CircuitChangeJobs.ChangeArcEnum.DIRECTIONAL, CircuitChanges.getHighlighted());
    }

    public static void arcHeadExtendCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ChangeArcProperties(cell, CircuitChangeJobs.ChangeArcEnum.HEADEXTEND, CircuitChanges.getHighlighted());
    }

    public static void arcTailExtendCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ChangeArcProperties(cell, CircuitChangeJobs.ChangeArcEnum.TAILEXTEND, CircuitChanges.getHighlighted());
    }

    public static void toggleNegatedCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ToggleNegationJob(cell, CircuitChanges.getHighlighted());
    }

    public static List<Highlight> getHighlighted() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return new ArrayList<Highlight>();
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return new ArrayList<Highlight>();
        }
        return highlighter.getHighlights();
    }

    public static void ripBus() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        List<ArcInst> list = MenuCommands.getSelectedArcs();
        if (list.size() == 0) {
            System.out.println("Must select bus arcs to rip into individual signals");
            return;
        }
        new CircuitChangeJobs.RipTheBus(cell, list);
    }

    public static void deleteSelected() {
        Highlight high;
        MessagesWindow mw = MessagesWindow.getFocusOwner();
        if (mw != null) {
            mw.clear(false);
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        if (wf.getContent() instanceof WaveformWindow) {
            WaveformWindow ww = (WaveformWindow)wf.getContent();
            ww.deleteSelectedSignals();
            return;
        }
        if (WindowFrame.getListener() == OutlineListener.theOne) {
            OutlineListener.theOne.deletePoint();
            return;
        }
        boolean highlightedArea = ToolBar.getSelectMode() == ToolBar.SelectMode.AREA;
        List<Highlight> highlights = highlighter.getHighlights();
        if (highlights.size() == 1 && (high = highlights.get(0)) instanceof HighlightArea) {
            highlightedArea = true;
        }
        if (highlightedArea) {
            EditWindow wnd = EditWindow.getCurrent();
            Rectangle2D bounds = highlighter.getHighlightedArea(wnd);
            if (bounds == null) {
                System.out.println("Nothing is selected");
                return;
            }
            new CircuitChangeJobs.DeleteSelectedGeometry(cell, bounds);
        } else {
            boolean formerMoveWithText = User.isMoveNodeWithExport();
            Pref.delayPrefFlushing();
            User.setMoveNodeWithExport(false);
            List<DisplayedText> highlightedText = highlighter.getHighlightedText(true);
            List<Geometric> highlighted = highlighter.getHighlightedEObjs(true, true);
            User.setMoveNodeWithExport(formerMoveWithText);
            Pref.resumePrefFlushing();
            if (highlightedText.size() == 0 && highlighted.size() == 0) {
                return;
            }
            new CircuitChangeJobs.DeleteSelected(cell, highlightedText, highlighted, User.isReconstructArcsAndExportsToDeletedCells());
        }
    }

    public static void cellCenterToCenterOfSelection() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (CircuitChangeJobs.cantEdit(cell, null, true, false, false) != 0) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter == null) {
            return;
        }
        Rectangle2D bounds = highlighter.getHighlightedArea(wnd);
        if (bounds == null) {
            return;
        }
        new CircuitChangeJobs.CellCenterToCenterOfSelection(cell, EPoint.fromLambda(bounds.getCenterX(), bounds.getCenterY()));
    }

    public static void deleteArcsOnSelected(boolean both) {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (CircuitChangeJobs.cantEdit(cell, null, true, false, false) != 0) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter == null) {
            return;
        }
        HashSet<NodeInst> selectedNodes = new HashSet<NodeInst>();
        for (Geometric g : highlighter.getHighlightedEObjs(true, false)) {
            selectedNodes.add((NodeInst)g);
        }
        HashSet<ArcInst> arcsToDelete = new HashSet<ArcInst>();
        for (NodeInst ni : selectedNodes) {
            Iterator<Connection> it = ni.getConnections();
            while (it.hasNext()) {
                Connection con = it.next();
                ArcInst ai = con.getArc();
                if (both && (!selectedNodes.contains(ai.getHeadPortInst().getNodeInst()) || !selectedNodes.contains(ai.getTailPortInst().getNodeInst()))) continue;
                arcsToDelete.add(ai);
            }
        }
        if (arcsToDelete.size() == 0) {
            System.out.println("There are no arcs on the selected nodes that can be deleted");
            return;
        }
        new CircuitChangeJobs.DeleteArcs(arcsToDelete);
    }

    public static boolean deleteCell(Cell cell, boolean confirm, boolean quiet) {
        int response;
        if (cell.isInUse("delete", quiet, true)) {
            return false;
        }
        if (confirm && (response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Are you sure you want to delete '" + cell + "'?", "Delete Cell Dialog", 0)) != 0) {
            return false;
        }
        CircuitChanges.cleanCellRef(cell);
        new CellChangeJobs.DeleteCell(cell);
        return true;
    }

    public static void cleanCellRef(Cell cell) {
        Library lib = cell.getLibrary();
        if (cell == lib.getCurCell()) {
            lib.setCurCell(null);
        }
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (content == null || content.getCell() != cell) continue;
            if (!(content instanceof EditWindow)) {
                wf.setCellWindow(null, null);
                continue;
            }
            content.setCell(null, null, null);
            content.fullRepaint();
        }
    }

    public static void renameCellInJob(Cell cell, String newName) {
        int response;
        String newGroupCell = null;
        HashSet<Cell> set = new HashSet<Cell>();
        set.add(cell);
        if (cell.getNumVersions() > 1 && (response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Also rename previous versions of the cell \"" + cell.getName() + "\" ?")) == 0) {
            Iterator<Cell> it = cell.getVersions();
            while (it.hasNext()) {
                set.add(it.next());
            }
        }
        for (Cell c : set) {
            new CellChangeJobs.RenameCell(c, newName, newGroupCell);
        }
    }

    public static void renameCellGroupInJob(Cell.CellGroup cellGroup, String newName) {
        new CellChangeJobs.RenameCellGroup(cellGroup.getCells().next(), newName);
    }

    public static void graphCellsFromCell() {
        Cell top = WindowFrame.needCurCell();
        if (top == null) {
            return;
        }
        new CellChangeJobs.GraphCells(top);
    }

    public static void graphCellsInLibrary() {
        new CellChangeJobs.GraphCells(null);
    }

    public static void graphLibraries() {
        new CellChangeJobs.GraphLibraries();
    }

    public static void packageIntoCell() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell curCell = wnd.getCell();
        if (curCell == null) {
            System.out.println("No cell in this window");
            return;
        }
        Rectangle2D bounds = highlighter.getHighlightedArea(wnd);
        if (bounds == null) {
            System.out.println("Must first select circuitry to package");
            return;
        }
        Object newCellName = JOptionPane.showInputDialog("New cell name:", (Object)curCell.getName());
        if (newCellName == null) {
            return;
        }
        newCellName = (String)newCellName + curCell.getView().getAbbreviationExtension();
        HashSet<Geometric> whatToPackage = new HashSet<Geometric>();
        List<Geometric> highlighted = highlighter.getHighlightedEObjs(true, true);
        for (Geometric geom : highlighted) {
            whatToPackage.add(geom);
            if (!(geom instanceof ArcInst)) continue;
            ArcInst ai = (ArcInst)geom;
            whatToPackage.add(ai.getHeadPortInst().getNodeInst());
            whatToPackage.add(ai.getTailPortInst().getNodeInst());
        }
        new CellChangeJobs.PackageCell(curCell, whatToPackage, (String)newCellName);
    }

    public static void extractCells(int depth) {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (depth < 0) {
            String obj = JOptionPane.showInputDialog("Number of levels to extract", (Object)"1");
            if (obj != null) {
                depth = TextUtils.atoi(obj);
            }
            if (depth <= 0) {
                return;
            }
        }
        List<NodeInst> selected = MenuCommands.getSelectedNodes();
        ArrayList<NodeInst> instances = new ArrayList<NodeInst>();
        int schematicCells = 0;
        for (NodeInst ni : selected) {
            if (!ni.isCellInstance()) continue;
            if (!ni.getProto().getTechnology().isLayout()) {
                ++schematicCells;
                continue;
            }
            instances.add(ni);
        }
        if (schematicCells > 0) {
            System.out.println("WARNING: Cannot extract non-layout cells (" + schematicCells + " selected)");
        }
        if (instances.size() == 0) {
            Object msg = "No extraction done";
            if (schematicCells == 0) {
                msg = "No cell instances are selected..." + (String)msg;
            }
            System.out.println((String)msg);
            return;
        }
        new CellChangeJobs.ExtractCellInstances(cell, instances, depth, User.isExtractCopiesExports(), User.isIncrementRightmostIndex(), false);
    }

    public static void cleanupPinsCommand(boolean everywhere, EditingPreferences ep) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        if (everywhere) {
            boolean cleaned = false;
            for (Library lib : Library.getVisibleLibraries()) {
                Iterator<Cell> it = lib.getCells();
                while (it.hasNext()) {
                    Cell cell = it.next();
                    if (!CircuitChanges.cleanupCell(cell, false, highlighter, ep)) continue;
                    cleaned = true;
                }
            }
            if (!cleaned) {
                System.out.println("Nothing to clean");
            }
        } else {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return;
            }
            CircuitChanges.cleanupCell(cell, true, highlighter, ep);
        }
    }

    private static boolean cleanupCell(Cell cell, boolean justThis, Highlighter highlighter, EditingPreferences ep) {
        Connection con;
        HashSet<NodeInst> pinsToRemove = new HashSet<NodeInst>();
        List<CircuitChangeJobs.Reconnect> pinsToPassThrough = CircuitChangeJobs.getPinsToPassThrough(cell, ep);
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.getFunction().isPin() || ni.hasExports() || ni.hasConnections()) continue;
            boolean hasDisplayable = false;
            Iterator<Variable> vIt = ni.getVariables();
            while (vIt.hasNext()) {
                Variable var = vIt.next();
                if (!var.isDisplay()) continue;
                hasDisplayable = true;
                break;
            }
            if (hasDisplayable) continue;
            pinsToRemove.add(ni);
        }
        HashMap<NodeInst, EPoint> pinsToScale = new HashMap<NodeInst, EPoint>();
        Iterator<NodeInst> it2 = cell.getNodes();
        while (it2.hasNext()) {
            double overSizeY;
            NodeInst ni = it2.next();
            if (!ni.getFunction().isPin()) continue;
            double overSizeX = ni.getXSize() - ni.getProto().getDefWidth(ep);
            if (overSizeX < 0.0) {
                overSizeX = 0.0;
            }
            if ((overSizeY = ni.getYSize() - ni.getProto().getDefHeight(ep)) < 0.0) {
                overSizeY = 0.0;
            }
            if (overSizeX == 0.0 && overSizeY == 0.0) continue;
            boolean arcsInCenter = true;
            Iterator<Connection> cIt = ni.getConnections();
            while (cIt.hasNext()) {
                con = cIt.next();
                ArcInst ai = con.getArc();
                if (ai.getHeadPortInst().getNodeInst() == ni) {
                    if (ai.getHeadLocation().getX() != ni.getAnchorCenterX()) {
                        arcsInCenter = false;
                        break;
                    }
                    if (ai.getHeadLocation().getY() != ni.getAnchorCenterY()) {
                        arcsInCenter = false;
                        break;
                    }
                }
                if (ai.getTailPortInst().getNodeInst() != ni) continue;
                if (ai.getTailLocation().getX() != ni.getAnchorCenterX()) {
                    arcsInCenter = false;
                    break;
                }
                if (ai.getTailLocation().getY() == ni.getAnchorCenterY()) continue;
                arcsInCenter = false;
                break;
            }
            if (!arcsInCenter) continue;
            double overSizeArc = 0.0;
            Iterator<Connection> cIt2 = ni.getConnections();
            while (cIt2.hasNext()) {
                Connection con2 = cIt2.next();
                ArcInst ai = con2.getArc();
                double overSize = ai.getLambdaBaseWidth() - ai.getProto().getDefaultLambdaBaseWidth(ep);
                if (overSize < 0.0) {
                    overSize = 0.0;
                }
                if (!(overSize > overSizeArc)) continue;
                overSizeArc = overSize;
            }
            if (overSizeArc >= overSizeX && overSizeArc >= overSizeY) continue;
            double dSX = 0.0;
            double dSY = 0.0;
            if (overSizeArc < overSizeX) {
                dSX = overSizeX - overSizeArc;
            }
            if (overSizeArc < overSizeY) {
                dSY = overSizeY - overSizeArc;
            }
            pinsToScale.put(ni, EPoint.fromLambda(-dSX, -dSY));
        }
        ArrayList<NodeInst> textToMove = new ArrayList<NodeInst>();
        Iterator<NodeInst> it3 = cell.getNodes();
        while (it3.hasNext()) {
            NodeInst ni = it3.next();
            Point2D pt = ni.invisiblePinWithOffsetText(false);
            if (pt == null) continue;
            textToMove.add(ni);
        }
        int overSizePins = 0;
        Iterator<NodeInst> it4 = cell.getNodes();
        while (it4.hasNext()) {
            NodeInst ni = it4.next();
            if (!ni.getFunction().isPin()) continue;
            boolean nodeIsBad = false;
            Iterator<Connection> cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con3 = cIt.next();
                ArcInst ai = con3.getArc();
                Poly poly = ai.makeLambdaPoly(ai.getGridBaseWidth(), Poly.Type.FILLED);
                Iterator<Connection> oCIt = ni.getConnections();
                while (oCIt.hasNext()) {
                    Poly oPoly;
                    double dist;
                    Connection oCon = oCIt.next();
                    ArcInst oAi = oCon.getArc();
                    if (ai.getArcId() <= oAi.getArcId() || (dist = poly.separation(oPoly = oAi.makeLambdaPoly(oAi.getGridBaseWidth(), Poly.Type.FILLED))) <= 0.0) continue;
                    nodeIsBad = true;
                    break;
                }
                if (!nodeIsBad) continue;
                break;
            }
            if (!nodeIsBad) continue;
            if (justThis) {
                highlighter.addElectricObject(ni, cell);
            }
            ++overSizePins;
        }
        HashSet<ArcInst> arcsToKill = new HashSet<ArcInst>();
        Iterator<ArcInst> ait = cell.getArcs();
        while (ait.hasNext()) {
            ArcInst ai = ait.next();
            int arcId = ai.getArcId();
            if (arcsToKill.contains(ai)) continue;
            PortInst pi = ai.getHeadPortInst();
            Iterator<Connection> it5 = pi.getConnections();
            while (it5.hasNext()) {
                int otherEnd;
                PortInst oPi;
                con = it5.next();
                ArcInst oAi = con.getArc();
                if (oAi.getArcId() >= arcId || ai.getProto() != oAi.getProto() || (oPi = oAi.getPortInst(otherEnd = 1 - con.getEndIndex())) != ai.getTailPortInst()) continue;
                arcsToKill.add(oAi);
            }
        }
        int zeroSize = 0;
        int negSize = 0;
        Iterator<NodeInst> it6 = cell.getNodes();
        while (it6.hasNext()) {
            NodeInst ni = it6.next();
            if (Generic.isCellCenterOrEssentialBnd(ni) || ni.getProto() == Generic.tech().invisiblePinNode || ni.getProto() == Generic.tech().universalPinNode) continue;
            double sX = ni.getLambdaBaseXSize();
            double sY = ni.getLambdaBaseYSize();
            if (sX > 0.0 && sY > 0.0 || sX > 0.0 || sY > 0.0 && ni.getProto().getTechnology() == Artwork.tech() || sX == 0.0 && sY == 0.0 && ni.getFunction().isPin()) continue;
            if (justThis) {
                highlighter.addElectricObject(ni, cell);
            }
            if (sX < 0.0 || sY < 0.0) {
                ++negSize;
                continue;
            }
            ++zeroSize;
        }
        if (pinsToRemove.isEmpty() && pinsToPassThrough.isEmpty() && pinsToScale.isEmpty() && zeroSize == 0 && negSize == 0 && textToMove.isEmpty() && overSizePins == 0 && arcsToKill.size() == 0) {
            if (justThis) {
                System.out.println("Nothing to clean");
            }
            return false;
        }
        CircuitChangeJobs.CleanupChanges ccJob = new CircuitChangeJobs.CleanupChanges(cell, justThis, pinsToRemove, pinsToPassThrough, pinsToScale, textToMove, arcsToKill, zeroSize, negSize, overSizePins);
        ccJob.startJob();
        return true;
    }

    public static void showNonmanhattanCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        HashSet<Cell> cellsSeen = new HashSet<Cell>();
        Iterator<Library> lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = lIt.next();
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = cIt.next();
                if (cell.getView() == View.ICON || cell.getView() == View.SCHEMATIC) continue;
                Iterator<ArcInst> aIt = cell.getArcs();
                while (aIt.hasNext()) {
                    ArcInst ai = aIt.next();
                    ArcProto ap = ai.getProto();
                    if (ap.getTechnology() == Generic.tech() || ap.getTechnology() == Artwork.tech() || ap.getTechnology() == Schematics.tech()) continue;
                    Variable var = ai.getVar(ImmutableArcInst.ARC_RADIUS);
                    if (var != null) {
                        cellsSeen.add(cell);
                    }
                    if (ai.getHeadLocation().getX() == ai.getTailLocation().getX() || ai.getHeadLocation().getY() == ai.getTailLocation().getY()) continue;
                    cellsSeen.add(cell);
                }
                Iterator<NodeInst> nIt = cell.getNodes();
                while (nIt.hasNext()) {
                    NodeInst ni = nIt.next();
                    if (ni.getAngle() % 900 == 0) continue;
                    cellsSeen.add(cell);
                }
            }
        }
        int i = 0;
        Iterator<ArcInst> aIt = curCell.getArcs();
        while (aIt.hasNext()) {
            ArcInst ai = aIt.next();
            ArcProto ap = ai.getProto();
            if (ap.getTechnology() == Generic.tech() || ap.getTechnology() == Artwork.tech() || ap.getTechnology() == Schematics.tech()) continue;
            boolean nonMan = false;
            Variable var = ai.getVar(ImmutableArcInst.ARC_RADIUS);
            if (var != null) {
                nonMan = true;
            }
            if (ai.getHeadLocation().getX() != ai.getTailLocation().getX() && ai.getHeadLocation().getY() != ai.getTailLocation().getY()) {
                nonMan = true;
            }
            if (!nonMan) continue;
            if (i == 0) {
                highlighter.clear();
            }
            highlighter.addElectricObject(ai, curCell);
            ++i;
        }
        Iterator<NodeInst> nIt = curCell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = nIt.next();
            if (ni.getAngle() % 900 == 0) continue;
            if (i == 0) {
                highlighter.clear();
            }
            highlighter.addElectricObject(ni, curCell);
            ++i;
        }
        if (i == 0) {
            System.out.println("No nonmanhattan objects in this cell");
        } else {
            highlighter.finished();
            System.out.println(i + " objects are not manhattan in this cell");
        }
        Iterator<Library> lIt2 = Library.getLibraries();
        while (lIt2.hasNext()) {
            Library lib = lIt2.next();
            if (lib.isHidden()) continue;
            int numBad = 0;
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = cIt.next();
                if (!cellsSeen.contains(cell) || cell == curCell) continue;
                ++numBad;
            }
            if (numBad == 0) continue;
            int cellsFound = 0;
            Object infstr = "";
            Iterator<Cell> cIt2 = lib.getCells();
            while (cIt2.hasNext()) {
                Cell cell = cIt2.next();
                if (cell == curCell || !cellsSeen.contains(cell)) continue;
                if (cellsFound > 0) {
                    infstr = (String)infstr + " ";
                }
                infstr = (String)infstr + cell.describe(true);
                ++cellsFound;
            }
            if (cellsFound == 1) {
                System.out.println("Library " + lib.getName() + " has nonmanhattan geometry in cell " + (String)infstr);
                continue;
            }
            System.out.println("Library " + lib.getName() + " has nonmanhattan geometry in these cells: " + (String)infstr);
        }
    }

    public static void showPureLayerCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        int i = 0;
        Iterator<NodeInst> nIt = curCell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = nIt.next();
            if (ni.getFunction() != PrimitiveNode.Function.NODE) continue;
            if (i == 0) {
                highlighter.clear();
            }
            highlighter.addElectricObject(ni, curCell);
            ++i;
        }
        if (i == 0) {
            System.out.println("No pure layer nodes in this cell");
        } else {
            highlighter.finished();
            System.out.println(i + " pure layer nodes in this cell");
        }
    }

    public static void shortenArcsCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ShortenArcs(cell, MenuCommands.getSelectedArcs());
    }

    public static void showRedundantPureLayerNodes() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        LayerVisibility lv = wnd.getLayerVisibility();
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        HashSet<NodeInst> redundantPures = new HashSet<NodeInst>();
        Iterator<Layer> it = cell.getTechnology().getLayers();
        while (it.hasNext()) {
            PrimitiveNode pNp;
            Layer lay = it.next();
            if (!lv.isVisible(lay) || (pNp = lay.getPureLayerNode()) == null) continue;
            ArrayList<NodeInst> allPures = new ArrayList<NodeInst>();
            HashMap<NodeInst, Double> pureAreas = new HashMap<NodeInst, Double>();
            RTNode<Object> root = RTNode.makeTopLevel();
            Iterator<NodeInst> nIt = cell.getNodes();
            while (nIt.hasNext()) {
                double area;
                NodeInst ni = nIt.next();
                if (ni.getProto() != pNp) continue;
                allPures.add(ni);
                Point2D[] points = ni.getTrace();
                if (points == null) {
                    area = ni.getXSize() * ni.getYSize();
                } else {
                    boolean hasGaps = false;
                    for (int i = 0; i < points.length; ++i) {
                        if (points[i] != null) continue;
                        hasGaps = true;
                        break;
                    }
                    if (hasGaps) {
                        area = 0.0;
                        int start = 0;
                        for (int i = 0; i < points.length; ++i) {
                            if (i != points.length - 1 && points[i + 1] != null) continue;
                            Point2D[] segment = new Point2D[i - start + 1];
                            for (int j = start; j <= i; ++j) {
                                segment[j - start] = points[j];
                            }
                            area += GenMath.getAreaOfPoints(segment);
                            start = i + 2;
                        }
                    } else {
                        area = GenMath.getAreaOfPoints(points);
                    }
                }
                pureAreas.put(ni, area);
                root = RTNode.linkGeom(null, root, ni);
            }
            block5: for (NodeInst ni : allPures) {
                Double nodeArea = (Double)pureAreas.get(ni);
                ERectangle nodeRect = ni.getBounds();
                RTNode.Search sea = new RTNode.Search(nodeRect, root, false);
                while (sea.hasNext()) {
                    Poly[] neighborPolys;
                    Poly neighborPoly;
                    Double neighborArea;
                    NodeInst neighbor = (NodeInst)sea.next();
                    if (neighbor == ni || (neighborArea = (Double)pureAreas.get(neighbor)) < nodeArea || redundantPures.contains(neighbor) || !(neighborPoly = (neighborPolys = neighbor.getProto().getTechnology().getShapeOfNode(neighbor))[0]).contains(nodeRect)) continue;
                    redundantPures.add(ni);
                    continue block5;
                }
            }
        }
        wnd.clearHighlighting();
        for (NodeInst ni : redundantPures) {
            wnd.addElectricObject(ni, cell);
        }
        wnd.finishedHighlighting();
        System.out.println("Highlighted " + redundantPures.size() + " redundant pure-layer nodes");
    }

    public static boolean isBox(Point2D[] points) {
        if (points.length != 4) {
            if (points.length == 5) {
                if (points[0].getX() != points[4].getX() || points[0].getY() != points[4].getY()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (points[0].getX() == points[1].getX() && points[2].getX() == points[3].getX() && points[0].getY() == points[3].getY() && points[1].getY() == points[2].getY()) {
            return true;
        }
        return points[0].getX() == points[3].getX() && points[1].getX() == points[2].getX() && points[0].getY() == points[1].getY() && points[2].getY() == points[3].getY();
    }

    public static void newVersionOfCell(Cell cell) {
        int status = Project.getCellStatus(cell);
        if (status != 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "This cell is part of a project.  To get a new version of it, check it out.", "Cannot Make New Version", 0);
            return;
        }
        new CellChangeJobs.NewCellVersion(cell);
    }

    public static void connectOverlappingNetworks() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Cell cell = wf.getContent().getCell();
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        List<Highlight> highlighted = highlighter.getHighlights();
        GetNetName gnn = new GetNetName(cell);
        String netName = gnn.getSelectedNetwork();
        if (netName == null) {
            return;
        }
        ArrayList<ArcInst> arcsToConnect = new ArrayList<ArcInst>();
        for (Highlight h : highlighted) {
            ElectricObject eObj;
            if (!h.isHighlightEOBJ() || !((eObj = h.getElectricObject()) instanceof ArcInst)) continue;
            ArcInst ai = (ArcInst)eObj;
            arcsToConnect.add(ai);
        }
        new RouteOverlapJob(cell, arcsToConnect, netName);
    }

    public static void manyMove(double dX, double dY) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Cell cell = wf.getContent().getCell();
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        List<Highlight> highlighted = highlighter.getHighlights();
        int nonCellCenterCount = 0;
        Highlight cellCenterHighlight = null;
        ArrayList<ElectricObject> highlightedEObjs = new ArrayList<ElectricObject>();
        for (Highlight h : highlighted) {
            if (!h.isHighlightEOBJ()) continue;
            ElectricObject eObj = h.getElectricObject();
            highlightedEObjs.add(eObj);
            if (eObj instanceof NodeInst) {
                NodeInst ni = (NodeInst)eObj;
                if (Generic.isCellCenter(ni)) {
                    cellCenterHighlight = h;
                    continue;
                }
                ++nonCellCenterCount;
                continue;
            }
            ++nonCellCenterCount;
        }
        if (cellCenterHighlight != null && nonCellCenterCount != 0) {
            System.out.println("Cannot move the Cell-center along with other objects.  Cell-center will not be moved.");
            highlighted.remove(cellCenterHighlight);
        }
        List<DisplayedText> highlightedText = highlighter.getHighlightedText(true);
        if (!highlightedEObjs.isEmpty() || !highlightedText.isEmpty()) {
            new CircuitChangeJobs.ManyMove(cell, highlightedEObjs, highlightedText, dX, dY);
        }
    }

    public static void DoExpandCommands(boolean unExpand, int amount) {
        List<NodeInst> list;
        if (amount < 0) {
            String obj = JOptionPane.showInputDialog("Number of levels to " + (unExpand ? "unexpand" : "expand"), (Object)"1");
            if (obj != null) {
                amount = TextUtils.atoi(obj);
            }
            if (amount <= 0) {
                return;
            }
        }
        if ((list = MenuCommands.getSelectedNodes()).isEmpty()) {
            return;
        }
        Cell cell = list.get(0).getParent();
        for (NodeInst ni : list) {
            assert (ni.getParent() == cell);
            if (!ni.isCellInstance()) continue;
            if (!unExpand) {
                CircuitChanges.doExpand(cell, ni.getD(), amount, 0);
                continue;
            }
            if (!ni.isExpanded()) continue;
            CircuitChanges.doUnExpand(cell, ni.getD(), amount);
        }
        EditWindow.expansionChanged(cell);
        EditWindow.clearSubCellCache();
        EditWindow.repaintAllContents();
    }

    private static void doExpand(Cell parent, ImmutableNodeInst n, int amount, int sofar) {
        if (!parent.isExpanded(n.nodeId)) {
            parent.setExpanded(n.nodeId, true);
            if (++sofar >= amount) {
                return;
            }
        }
        if (!n.isCellInstance()) {
            return;
        }
        EDatabase database = parent.getDatabase();
        Cell cell = (Cell)n.protoId.inDatabase(database);
        for (ImmutableNodeInst subN : cell.backup().cellRevision.nodes) {
            Cell subCell;
            if (!subN.isCellInstance() || (subCell = (Cell)subN.protoId.inDatabase(database)).isIconOf(cell)) continue;
            CircuitChanges.doExpand(cell, subN, amount, sofar);
        }
    }

    private static int doUnExpand(Cell parent, ImmutableNodeInst n, int amount) {
        if (!parent.isExpanded(n.nodeId)) {
            return 0;
        }
        if (!n.isCellInstance()) {
            return 1;
        }
        EDatabase database = parent.getDatabase();
        int depth = 0;
        Cell cell = (Cell)n.protoId.inDatabase(database);
        for (ImmutableNodeInst subN : cell.backup().cellRevision.nodes) {
            Cell subCell;
            if (!subN.isCellInstance() || (subCell = (Cell)subN.protoId.inDatabase(database)).isIconOf(cell) || !cell.isExpanded(subN.nodeId)) continue;
            depth = Math.max(depth, CircuitChanges.doUnExpand(cell, subN, amount));
        }
        if (depth < amount) {
            parent.setExpanded(n.nodeId, false);
        }
        return depth + 1;
    }

    public static void listLibrariesCommand() {
        System.out.println("----- Libraries: -----");
        int k = 0;
        for (Library lib : Library.getVisibleLibraries()) {
            Cell subCell;
            NodeInst ni;
            Iterator<NodeInst> nIt;
            Cell cell;
            Iterator<Cell> cIt;
            if (lib.isHidden()) continue;
            StringBuffer infstr = new StringBuffer();
            infstr.append(lib.getName());
            if (lib.isChanged()) {
                infstr.append("*");
                ++k;
            }
            if (lib.getLibFile() != null) {
                infstr.append(" (disk file: " + lib.getLibFile() + ")");
            }
            System.out.println(infstr.toString());
            HashSet<String> dummyLibs = new HashSet<String>();
            HashSet<Library> markedLibs = new HashSet<Library>();
            Iterator<Cell> cIt2 = lib.getCells();
            while (cIt2.hasNext()) {
                Cell cell2 = cIt2.next();
                Iterator<NodeInst> nIt2 = cell2.getNodes();
                while (nIt2.hasNext()) {
                    NodeInst ni2 = nIt2.next();
                    if (!ni2.isCellInstance()) continue;
                    Cell subCell2 = (Cell)ni2.getProto();
                    String pt = subCell2.getVarValue(LibraryFiles.IO_TRUE_LIBRARY, String.class);
                    if (pt != null) {
                        dummyLibs.add(pt);
                    }
                    markedLibs.add(subCell2.getLibrary());
                }
            }
            Iterator<Library> lIt = Library.getLibraries();
            while (lIt.hasNext()) {
                Library oLib = lIt.next();
                if (oLib == lib || !markedLibs.contains(oLib)) continue;
                System.out.println("   Makes use of cells in " + oLib);
                infstr = new StringBuffer();
                infstr.append("      These cells make reference to that library:");
                cIt = lib.getCells();
                while (cIt.hasNext()) {
                    cell = cIt.next();
                    boolean found = false;
                    nIt = cell.getNodes();
                    while (nIt.hasNext()) {
                        ni = nIt.next();
                        if (!ni.isCellInstance() || (subCell = (Cell)ni.getProto()).getLibrary() != oLib) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    infstr.append(" " + cell.noLibDescribe());
                }
                System.out.println(infstr.toString());
            }
            for (String dummyLibName : dummyLibs) {
                System.out.println("   Has dummy cells that should be in library " + dummyLibName);
                infstr = new StringBuffer();
                infstr.append("      Instances of these dummy cells are in:");
                cIt = lib.getCells();
                while (cIt.hasNext()) {
                    cell = cIt.next();
                    boolean found = false;
                    nIt = cell.getNodes();
                    while (nIt.hasNext()) {
                        String libName;
                        ni = nIt.next();
                        if (!ni.isCellInstance() || !dummyLibName.equals(libName = (subCell = (Cell)ni.getProto()).getVarValue(LibraryFiles.IO_TRUE_LIBRARY, String.class))) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    infstr.append(" " + cell.noLibDescribe());
                }
                System.out.println(infstr.toString());
            }
        }
        if (k != 0) {
            System.out.println("   (* means library has changed)");
        }
    }

    public static void renameCurrentTechnology() {
        Technology tech = Technology.getCurrent();
        String techName = tech.getTechName();
        String val = JOptionPane.showInputDialog("New Name of Technology " + techName + ":", (Object)techName);
        if (val == null) {
            return;
        }
        if (val.equals(techName)) {
            return;
        }
        new CircuitChangeJobs.RenameTechnology(tech, val);
    }

    public static void renameLibrary(Library lib) {
        String val = JOptionPane.showInputDialog("New Name of Library:", (Object)lib.getName());
        if (val == null) {
            return;
        }
        new CircuitChangeJobs.RenameLibrary(lib, val);
    }

    public static void checkAndRepairCommand(boolean repair) {
        new CircuitChangeJobs.CheckAndRepairJob(repair);
    }

    public static void findUnusedLibraryFiles() {
        HashMap<String, ArrayList<String>> directories = new HashMap<String, ArrayList<String>>();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            ArrayList<String> filesInDir;
            String fileName;
            URL libFile;
            Library lib = it.next();
            if (lib.isHidden() || !lib.isFromDisk()) continue;
            String dirName = lib.getLibFile().getFile();
            File file = TextUtils.getFile(lib.getLibFile());
            if (file == null || (libFile = LibFile.getLibFile(fileName = file.getName())) != null && libFile.getFile().equals(dirName)) continue;
            int crop = dirName.lastIndexOf(fileName);
            if (crop > 0) {
                dirName = dirName.substring(0, crop);
            }
            if ((filesInDir = (ArrayList<String>)directories.get(dirName)) == null) {
                filesInDir = new ArrayList<String>();
                directories.put(dirName, filesInDir);
            }
            filesInDir.add(fileName);
        }
        if (directories.size() == 0) {
            System.out.println("Before running this command, you must read some libraries from disk.");
            System.out.println("The command will then examine the disk to see if there are other libraries that were not read in");
            return;
        }
        for (String dirName : directories.keySet()) {
            File dirFile = new File(dirName);
            boolean firstInDir = true;
            if (!dirFile.isDirectory()) continue;
            List filesInDir = (List)directories.get(dirName);
            String[] files = dirFile.list();
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                String file = files[i].toLowerCase();
                if (!file.endsWith(".jelib") && !file.endsWith(".elib") && !file.endsWith(".delib") || filesInDir.contains(files[i])) continue;
                if (firstInDir) {
                    System.out.println("Directory " + dirName + " has these unused library files:");
                }
                firstInDir = false;
                System.out.println("   " + files[i]);
            }
        }
    }

    public static void removeUnusedLayers(Library lib) {
    }

    private static class GetNetName
    extends EDialog {
        private JList list;
        private DefaultListModel model;

        GetNetName(Cell cell) {
            super((Frame)TopLevel.getCurrentJFrame(), true);
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Select Network");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    this.closeDialog();
                }
            });
            JScrollPane objectPane = new JScrollPane();
            objectPane.setMinimumSize(new Dimension(200, 200));
            objectPane.setPreferredSize(new Dimension(200, 200));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)objectPane, gridBagConstraints);
            this.model = new DefaultListModel();
            this.list = new JList(this.model);
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt != null && evt.getClickCount() >= 2) {
                        this.closeDialog();
                    }
                }
            });
            objectPane.setViewportView(this.list);
            Netlist netlist = cell.getNetlist();
            if (netlist == null) {
                System.out.println("Sorry, a deadlock aborted selection (network information unavailable).  Please try again");
                return;
            }
            ArrayList<String> netNames = new ArrayList<String>();
            Iterator<Network> it = netlist.getNetworks();
            while (it.hasNext()) {
                Network net = it.next();
                String netName = net.describe(false);
                if (netName.length() == 0) continue;
                netNames.add(netName);
            }
            Collections.sort(netNames);
            for (String s : netNames) {
                this.model.addElement(s);
            }
            JButton done = new JButton("Done");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)done, gridBagConstraints);
            done.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.closeDialog();
                }
            });
            JButton cancel = new JButton("Cancel");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gridBagConstraints);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    list.clearSelection();
                    this.closeDialog();
                }
            });
            this.pack();
            this.setVisible(true);
        }

        public String getSelectedNetwork() {
            String name = (String)this.list.getSelectedValue();
            if (name == null) {
                return null;
            }
            return name;
        }
    }

    private static class RouteOverlapJob
    extends Job {
        private Cell cell;
        private List<ArcInst> arcsToConnect;
        private String netName;

        public RouteOverlapJob(Cell cell, List<ArcInst> arcsToConnect, String netName) {
            super("Connect arcs to network", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.arcsToConnect = arcsToConnect;
            this.netName = netName;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            EditingPreferences ep = this.getEditingPreferences();
            for (ArcInst aiConnect : this.arcsToConnect) {
                boolean lastExtend;
                boolean firstExtend;
                String arcName;
                Netlist nl = this.cell.getNetlist();
                Network net = null;
                Iterator<Network> it = nl.getNetworks();
                while (it.hasNext()) {
                    Network n = it.next();
                    String nn = n.describe(false);
                    if (!nn.contains(this.netName)) continue;
                    net = n;
                    break;
                }
                EPoint conHeadLoc = aiConnect.getHeadLocation();
                EPoint conTailLoc = aiConnect.getTailLocation();
                ERectangle conBound = aiConnect.getBounds();
                ArrayList<NodeArcPair> newNodes = new ArrayList<NodeArcPair>();
                Iterator<Geometric> it2 = this.cell.searchIterator(conBound);
                block2: while (it2.hasNext()) {
                    ArcInst ai;
                    Geometric geom = it2.next();
                    if (!(geom instanceof ArcInst) || nl.getNetwork(ai = (ArcInst)geom, 0) != net) continue;
                    EPoint aiHeadLoc = ai.getHeadLocation();
                    EPoint aiTailLoc = ai.getTailLocation();
                    Point2D intersect = GenMath.intersect(conHeadLoc, aiConnect.getAngle(), ai.getHeadLocation(), ai.getAngle());
                    if (intersect == null || intersect.getX() < Math.min(conHeadLoc.getX(), conTailLoc.getX()) || intersect.getX() > Math.max(conHeadLoc.getX(), conTailLoc.getX()) || intersect.getX() < Math.min(aiHeadLoc.getX(), aiTailLoc.getX()) || intersect.getX() > Math.max(aiHeadLoc.getX(), aiTailLoc.getX())) continue;
                    EPoint intersectEP = EPoint.fromLambda(intersect.getX(), intersect.getY());
                    Technology tech = aiConnect.getProto().getTechnology();
                    ArrayList<PrimitiveNode> possibleConnections = new ArrayList<PrimitiveNode>();
                    Iterator<PrimitiveNode> nIt = tech.getNodes();
                    while (nIt.hasNext()) {
                        PrimitiveNode pnp = nIt.next();
                        if (pnp.getFunction() != PrimitiveNode.Function.CONTACT || pnp.connectsTo(aiConnect.getProto()) == null || pnp.connectsTo(ai.getProto()) == null) continue;
                        possibleConnections.add(pnp);
                    }
                    if (possibleConnections.size() == 0) continue;
                    Collections.sort(possibleConnections, new PrimsBySize(ep));
                    for (PrimitiveNode pnp : possibleConnections) {
                        NodeInst ni = NodeInst.makeDummyInstance(pnp, ep, intersectEP, pnp.getDefWidth(ep), pnp.getDefHeight(ep), Orientation.IDENT);
                        if (this.fitsInArcs(ni, aiConnect, ai)) {
                            newNodes.add(new NodeArcPair(ni, ai));
                            continue block2;
                        }
                        ni = NodeInst.makeDummyInstance(pnp, ep, intersectEP, pnp.getDefWidth(ep), pnp.getDefHeight(ep), Orientation.R);
                        if (!this.fitsInArcs(ni, aiConnect, ai)) continue;
                        newNodes.add(new NodeArcPair(ni, ai));
                        continue block2;
                    }
                }
                if (newNodes.size() == 0) continue;
                ArrayList<PortInst> portsAlongTheWay = new ArrayList<PortInst>();
                for (NodeArcPair nap : newNodes) {
                    NodeInst dummyNi = nap.getNodeInst();
                    NodeInst ni = NodeInst.makeInstance(dummyNi.getProto(), ep, dummyNi.getTrueCenter(), dummyNi.getXSize(), dummyNi.getYSize(), this.cell, dummyNi.getOrient(), null);
                    portsAlongTheWay.add(ni.getOnlyPortInst());
                    ArcInst ai = nap.getArcInst();
                    arcName = ai.getName();
                    ArcInst ai1 = ArcInst.makeInstanceBase(ai.getProto(), ep, ai.getLambdaBaseWidth(), ai.getHeadPortInst(), ni.getOnlyPortInst());
                    ai1.setHeadExtended(ai.isHeadExtended());
                    ai1.setAngle(ai.getAngle());
                    ArcInst ai2 = ArcInst.makeInstanceBase(ai.getProto(), ep, ai.getLambdaBaseWidth(), ni.getOnlyPortInst(), ai.getTailPortInst());
                    ai2.setHeadExtended(ai.isTailExtended());
                    ai2.setAngle(ai.getAngle());
                    ai.kill();
                    if (arcName == null) continue;
                    if (ai1.getLambdaLength() > ai2.getLambdaLength()) {
                        ai1.setName(arcName, ep);
                        ai1.copyTextDescriptorFrom(ai, ArcInst.ARC_NAME);
                        continue;
                    }
                    ai2.setName(arcName, ep);
                    ai2.copyTextDescriptorFrom(ai, ArcInst.ARC_NAME);
                }
                portsAlongTheWay.add(aiConnect.getHeadPortInst());
                portsAlongTheWay.add(aiConnect.getTailPortInst());
                Collections.sort(portsAlongTheWay, new PortsByLocation());
                ArcInst longestAi = null;
                double longestAiLength = 0.0;
                if (portsAlongTheWay.get(0) == aiConnect.getHeadPortInst()) {
                    firstExtend = aiConnect.isHeadExtended();
                    lastExtend = aiConnect.isTailExtended();
                } else {
                    firstExtend = aiConnect.isTailExtended();
                    lastExtend = aiConnect.isHeadExtended();
                }
                for (int i = 1; i < portsAlongTheWay.size(); ++i) {
                    PortInst prevPort = (PortInst)portsAlongTheWay.get(i - 1);
                    PortInst thisPort = (PortInst)portsAlongTheWay.get(i);
                    ArcInst ai = ArcInst.makeInstanceBase(aiConnect.getProto(), ep, aiConnect.getLambdaBaseWidth(), prevPort, thisPort);
                    if (longestAi == null || ai.getLambdaLength() > longestAiLength) {
                        longestAi = ai;
                        longestAiLength = ai.getLambdaLength();
                    }
                    ai.setAngle(aiConnect.getAngle());
                    if (i == 1) {
                        ai.setHeadExtended(firstExtend);
                    }
                    if (i != portsAlongTheWay.size() - 1) continue;
                    ai.setTailExtended(lastExtend);
                }
                arcName = aiConnect.getName();
                aiConnect.kill();
                if (arcName == null) continue;
                longestAi.setName(arcName, ep);
                longestAi.copyTextDescriptorFrom(aiConnect, ArcInst.ARC_NAME);
            }
            return true;
        }

        private boolean fitsInArcs(NodeInst ni, ArcInst ai1, ArcInst ai2) {
            Layer lay;
            Poly[] polys1 = ai1.getProto().getTechnology().getShapeOfArc(ai1, null);
            Poly[] polys2 = ai2.getProto().getTechnology().getShapeOfArc(ai2, null);
            ArrayList<Poly> possiblePolys = new ArrayList<Poly>();
            for (Poly p : polys1) {
                lay = p.getLayer();
                if (lay == null || !lay.getFunction().isMetal()) continue;
                possiblePolys.add(p);
            }
            for (Poly p : polys2) {
                lay = p.getLayer();
                if (lay == null || !lay.getFunction().isMetal()) continue;
                possiblePolys.add(p);
            }
            Poly[] polys = ni.getProto().getTechnology().getShapeOfNode(ni);
            FixpTransform trans = ni.rotateOut();
            for (Poly p : polys) {
                Layer lay2 = p.getLayer();
                if (lay2 == null || !lay2.getFunction().isMetal()) continue;
                p.transform(trans);
                double lX = p.getBounds2D().getMinX();
                double hX = p.getBounds2D().getMaxX();
                double lY = p.getBounds2D().getMinY();
                double hY = p.getBounds2D().getMaxY();
                boolean nodeLayerFits = false;
                for (Poly pArc : possiblePolys) {
                    if (pArc.getLayer() != lay2 || pArc.getBounds2D().getMinX() > lX || pArc.getBounds2D().getMaxX() < hX || pArc.getBounds2D().getMinY() > lY || pArc.getBounds2D().getMaxY() < hY) continue;
                    nodeLayerFits = true;
                    break;
                }
                if (nodeLayerFits) continue;
                return false;
            }
            return true;
        }
    }

    private static class PrimsBySize
    implements Comparator<PrimitiveNode> {
        private EditingPreferences ep;

        public PrimsBySize(EditingPreferences ep) {
            this.ep = ep;
        }

        @Override
        public int compare(PrimitiveNode pn1, PrimitiveNode pn2) {
            double sz2;
            double sz1 = pn1.getDefWidth(this.ep) * pn1.getDefHeight(this.ep);
            if (sz1 < (sz2 = pn2.getDefWidth(this.ep) * pn2.getDefHeight(this.ep))) {
                return 1;
            }
            if (sz1 > sz2) {
                return -1;
            }
            return 0;
        }
    }

    private static class PortsByLocation
    implements Comparator<PortInst> {
        private PortsByLocation() {
        }

        @Override
        public int compare(PortInst pi1, PortInst pi2) {
            if (pi1.getCenter().getX() < pi2.getCenter().getX()) {
                return 1;
            }
            if (pi1.getCenter().getX() > pi2.getCenter().getX()) {
                return -1;
            }
            if (pi1.getCenter().getY() < pi2.getCenter().getY()) {
                return 1;
            }
            if (pi1.getCenter().getY() > pi2.getCenter().getY()) {
                return -1;
            }
            return 0;
        }
    }

    private static class NodeArcPair {
        private NodeInst ni;
        private ArcInst ai;

        public NodeArcPair(NodeInst ni, ArcInst ai) {
            this.ni = ni;
            this.ai = ai;
        }

        public NodeInst getNodeInst() {
            return this.ni;
        }

        public ArcInst getArcInst() {
            return this.ai;
        }
    }
}

