/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.ECoord;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class LEF
extends Output {
    private Layer currentLayer;
    private Layer metalLayer;
    private Set<NodeInst> nodesSeen;
    private Set<ArcInst> arcsSeen;
    private LEFPreferences localPrefs;

    LEF(LEFPreferences lp) {
        this.localPrefs = lp;
    }

    private void writeLEFHeader(Cell cell) {
        Technology tech = cell.getTechnology();
        double nanometersPerUnit = tech.getScale();
        ECoord resolution = tech.getFactoryResolution();
        if (this.localPrefs.includeDateAndVersionInOutput) {
            this.printWriter.println("# Electric VLSI Design System, version " + Version.getVersion());
            this.printWriter.println("# " + TextUtils.formatDate(new Date()));
        } else {
            this.printWriter.println("# Electric VLSI Design System");
        }
        this.emitCopyright("# ", "");
        this.printWriter.println();
        this.printWriter.println("NAMESCASESENSITIVE ON ;");
        this.printWriter.println("UNITS");
        this.printWriter.println("  DATABASE MICRONS " + TextUtils.formatDouble(nanometersPerUnit * 100.0) + " ;");
        this.printWriter.println("END UNITS");
        this.printWriter.println("MANUFACTURINGGRID " + resolution + " ;");
        this.printWriter.println();
        if (!this.localPrefs.ignoreTechnology) {
            int i;
            for (i = 0; i < tech.getNumMetals(); ++i) {
                this.printWriter.println("LAYER M" + (i + 1));
                this.printWriter.println("  TYPE ROUTING ;");
                this.printWriter.println("END M" + (i + 1));
                this.printWriter.println();
            }
            this.printWriter.println("LAYER CONT");
            this.printWriter.println("  TYPE CUT ;");
            this.printWriter.println("END CONT");
            this.printWriter.println();
            for (i = 0; i < tech.getNumMetals() - 1; ++i) {
                this.printWriter.println("LAYER VIA" + (i + 1));
                this.printWriter.println("  TYPE CUT ;");
                this.printWriter.println("END VIA" + (i + 1));
                this.printWriter.println();
            }
            for (i = 0; i < 3; ++i) {
                this.printWriter.println("LAYER POLY" + (i + 1));
                this.printWriter.println("  TYPE MASTERSLICE ;");
                this.printWriter.println("END POLY" + (i + 1));
                this.printWriter.println();
            }
            this.printWriter.println("LAYER PDIFF");
            this.printWriter.println("  TYPE MASTERSLICE ;");
            this.printWriter.println("END PDIFF");
            this.printWriter.println();
            this.printWriter.println("LAYER NDIFF");
            this.printWriter.println("  TYPE MASTERSLICE ;");
            this.printWriter.println("END NDIFF");
            this.printWriter.println();
        }
    }

    private void writeLEFTrailer() {
        this.printWriter.println("END LIBRARY");
    }

    private void writeCellHeader(Netlist netList) {
        Cell cell = netList.getCell();
        Technology tech = cell.getTechnology();
        this.printWriter.println("MACRO " + cell.getName());
        this.printWriter.println("  CLASS CORE ;");
        this.printWriter.println("  FOREIGN " + cell.getName() + " 0 0 ;");
        this.printWriter.println("  ORIGIN 0 0 ;");
        ERectangle bounds = cell.getBounds();
        double width = TextUtils.convertDistance(((RectangularShape)bounds).getWidth(), tech, TextUtils.UnitScale.MICRO);
        double height = TextUtils.convertDistance(((RectangularShape)bounds).getHeight(), tech, TextUtils.UnitScale.MICRO);
        this.printWriter.println("  SIZE " + TextUtils.formatDouble(width) + " BY " + TextUtils.formatDouble(height) + " ;");
        this.printWriter.println("  SYMMETRY X Y ;");
        this.printWriter.println("  SITE " + cell.getName() + " ;");
        this.nodesSeen = new HashSet<NodeInst>();
        this.arcsSeen = new HashSet<ArcInst>();
        NccCellAnnotations anna = NccCellAnnotations.getAnnotations(cell);
        if (anna != null && anna.getExportsConnected().hasNext()) {
            this.printWriter.println("\n### Exports shorted due to NCC annotation 'exportsConnectedByParent':\n");
        }
        HashMap<Network, ArrayList<Object>> unconnectedExports = new HashMap<Network, ArrayList<Object>>();
        HashMap<Object, Network> patNetworkMap = new HashMap<Object, Network>();
        Iterator<PortProto> it = cell.getPorts();
        while (it.hasNext()) {
            ArrayList<Object> exportsOnNet;
            Export e = (Export)it.next();
            Network net = netList.getNetwork(e, 0);
            if (anna != null) {
                Network match = null;
                String name = e.getName();
                Iterator<List<NccCellAnnotations.NamePattern>> pIt = anna.getExportsConnected();
                while (pIt.hasNext()) {
                    List<NccCellAnnotations.NamePattern> list = pIt.next();
                    Iterator<NccCellAnnotations.NamePattern> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        NccCellAnnotations.NamePattern pat = iterator.next();
                        if (!pat.matches(name)) continue;
                        match = (Network)patNetworkMap.get(list);
                        if (match != null) break;
                        patNetworkMap.put(list, net);
                        match = net;
                        break;
                    }
                    if (match == null) continue;
                    break;
                }
                if (match != null) {
                    net = match;
                }
            }
            if ((exportsOnNet = (ArrayList<Object>)unconnectedExports.get(net)) == null) {
                exportsOnNet = new ArrayList<Object>();
                unconnectedExports.put(net, exportsOnNet);
            }
            exportsOnNet.add(e);
        }
        ArrayList<Network> netsToWrite = new ArrayList<Network>();
        for (Network net : unconnectedExports.keySet()) {
            netsToWrite.add(net);
        }
        Collections.sort(netsToWrite, new TextUtils.NetworksByName());
        boolean first = true;
        for (Network net : netsToWrite) {
            List exportsOnNet = (List)unconnectedExports.get(net);
            Export main = null;
            for (Export e : exportsOnNet) {
                if (main == null) {
                    main = e;
                    continue;
                }
                if (main.getName().length() <= e.getName().length()) continue;
                main = e;
            }
            if (first) {
                first = false;
            } else {
                this.printWriter.println();
            }
            this.printWriter.println("  PIN " + main.getName());
            HashSet<NodeInst> nodesUnderExports = new HashSet<NodeInst>();
            PortCharacteristic type = PortCharacteristic.UNKNOWN;
            for (Export e : exportsOnNet) {
                type = e.getCharacteristic();
                nodesUnderExports.add(e.getOriginalPort().getNodeInst());
            }
            if (type == PortCharacteristic.IN || type.isClock() || type == PortCharacteristic.REFIN) {
                this.printWriter.println("    DIRECTION INPUT ;");
            } else if (type == PortCharacteristic.OUT || type == PortCharacteristic.REFOUT) {
                this.printWriter.println("    DIRECTION OUTPUT ;");
            } else if (type == PortCharacteristic.BIDIR) {
                this.printWriter.println("    DIRECTION INOUT ;");
            } else if (type == PortCharacteristic.GND) {
                this.printWriter.println("    DIRECTION INOUT ;\n    USE GROUND ;");
            } else if (type == PortCharacteristic.PWR) {
                this.printWriter.println("    DIRECTION INOUT ;\n    USE POWER ;");
            }
            for (Export e : exportsOnNet) {
                PrimitiveNode np;
                Technology.NodeLayer[] nls;
                PortOriginal fp = new PortOriginal(e.getOriginalPort());
                NodeInst rni = fp.getBottomNodeInst();
                PrimitivePort rpp = fp.getBottomPortProto();
                FixpTransform trans = fp.getTransformToTop();
                this.printWriter.println("    PORT");
                this.currentLayer = null;
                Poly[] polys = tech.getShapeOfNode(rni, true, false, null);
                if (polys.length == 0 && (nls = (np = (PrimitiveNode)rni.getProto()).getNodeLayers()).length > 0) {
                    polys = new Poly[]{new Poly(rni.getAnchorCenterX(), rni.getAnchorCenterY(), rni.getXSize(), rni.getYSize())};
                    polys[0].setLayer(nls[0].getLayer());
                    polys[0].setPort(rpp);
                }
                for (int i = 0; i < polys.length; ++i) {
                    Poly poly = polys[i];
                    if (poly.getPort() != rpp) continue;
                    String layerName = "";
                    Layer layer = poly.getLayer();
                    if (layer != null) {
                        layerName = this.io_lefoutlayername(layer);
                    }
                    if (layerName.length() == 0) {
                        poly.setLayer(this.metalLayer);
                    }
                    poly.transform(trans);
                    FixpRectangle polyBounds = poly.getBox();
                    if (polyBounds == null) {
                        EPoint ctr = poly.getCenter();
                        Poly newPoly = new Poly(ctr.getX(), ctr.getY(), 0.0, 0.0);
                        newPoly.setLayer(poly.getLayer());
                        poly = newPoly;
                    }
                    this.io_lefwritepoly(poly, trans, tech, true);
                }
                if (e == main) {
                    this.io_lefoutspread(cell, net, nodesUnderExports, netList);
                }
                this.printWriter.println("    END");
            }
            if (main.getCharacteristic() == PortCharacteristic.PWR) {
                this.printWriter.println("    USE POWER ;");
            }
            if (main.getCharacteristic() == PortCharacteristic.GND) {
                this.printWriter.println("    USE GROUND ;");
            }
            this.printWriter.println("  END " + main.getName());
        }
        this.printWriter.println();
        this.printWriter.println("  OBS");
        this.currentLayer = null;
    }

    private void writeCellTrailer(Cell cell) {
        this.printWriter.println("  END");
        this.printWriter.println("END " + cell.getName());
        this.printWriter.println();
    }

    private void dumpCellContents(Cell cell, FixpTransform trans, boolean isRootCell) {
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.isCellInstance() || isRootCell && this.nodesSeen.contains(ni)) continue;
            FixpTransform rot = ni.rotateOut(trans);
            Technology tech = ni.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                this.io_lefwritepoly(poly, rot, tech, false);
            }
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (isRootCell && this.arcsSeen.contains(ai)) continue;
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                this.io_lefwritepoly(poly, trans, tech, false);
            }
        }
    }

    void io_lefoutspread(Cell cell, Network net, Set<NodeInst> nodesUnderExports, Netlist netList) {
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            PrimitiveNode.Function fun;
            NodeInst ni = it.next();
            if (ni.isCellInstance() || nodesUnderExports.contains(ni) || !(fun = ni.getFunction()).isPin() && !fun.isContact() && fun != PrimitiveNode.Function.NODE && fun != PrimitiveNode.Function.WELL && fun != PrimitiveNode.Function.SUBSTRATE && fun != PrimitiveNode.Function.CONNECT) continue;
            boolean found = true;
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                Network pNet = netList.getNetwork(pi);
                if (pNet == net) continue;
                found = false;
                break;
            }
            if (!found) continue;
            this.nodesSeen.add(ni);
            FixpTransform trans = ni.rotateOut();
            Technology tech = ni.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                this.io_lefwritepoly(poly, trans, tech, true);
            }
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            Network aNet = netList.getNetwork(ai, 0);
            if (aNet != net) continue;
            this.arcsSeen.add(ai);
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                this.io_lefwritepoly(poly, GenMath.MATID, tech, true);
            }
        }
    }

    private void io_lefwritepoly(Poly poly, FixpTransform trans, Technology tech, boolean extraIndent) {
        Layer layer = poly.getLayer();
        if (layer == null) {
            return;
        }
        String layername = this.io_lefoutlayername(layer);
        if (layername.length() == 0) {
            return;
        }
        poly.transform(trans);
        FixpRectangle polyBounds = poly.getBox();
        if (polyBounds == null) {
            return;
        }
        double flx = TextUtils.convertDistance(((RectangularShape)polyBounds).getMinX(), tech, TextUtils.UnitScale.MICRO);
        double fly = TextUtils.convertDistance(((RectangularShape)polyBounds).getMinY(), tech, TextUtils.UnitScale.MICRO);
        double fhx = TextUtils.convertDistance(((RectangularShape)polyBounds).getMaxX(), tech, TextUtils.UnitScale.MICRO);
        double fhy = TextUtils.convertDistance(((RectangularShape)polyBounds).getMaxY(), tech, TextUtils.UnitScale.MICRO);
        if (layer != this.currentLayer) {
            if (extraIndent) {
                this.printWriter.print("  ");
            }
            this.printWriter.println("    LAYER " + layername + " ;");
            this.currentLayer = layer;
        }
        if (extraIndent) {
            this.printWriter.print("  ");
        }
        this.printWriter.println("      RECT " + TextUtils.formatDouble(flx) + " " + TextUtils.formatDouble(fly) + " " + TextUtils.formatDouble(fhx) + " " + TextUtils.formatDouble(fhy) + " ;");
    }

    private String io_lefoutlayername(Layer layer) {
        Layer.Function fun = layer.getFunction();
        if (fun.isMetal()) {
            return "M" + fun.getLevel();
        }
        if (fun == Layer.Function.GATE) {
            return "POLY1";
        }
        if (fun.isPoly()) {
            return "POLY" + fun.getLevel();
        }
        if (fun.isContact()) {
            int level = fun.getLevel();
            if (level == 1) {
                return "CONT";
            }
            return "VIA" + (level - 1);
        }
        if (fun == Layer.Function.DIFFN) {
            return "NDIFF";
        }
        if (fun == Layer.Function.DIFFP) {
            return "PDIFF";
        }
        if (fun == Layer.Function.DIFF) {
            return "DIFF";
        }
        return "";
    }

    public static class LEFPreferences
    extends Output.OutputPreferences {
        public boolean ignoreTechnology;

        public LEFPreferences(boolean factory) {
            super(factory);
            this.ignoreTechnology = factory ? IOTool.isFactoryLEFIgnoreTechnology() : IOTool.isLEFIgnoreTechnology();
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            LEF out = new LEF(this);
            out.metalLayer = null;
            Technology tech = cell.getTechnology();
            Iterator<Layer> it = tech.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                if (!layer.getFunction().isMetal()) continue;
                out.metalLayer = layer;
                break;
            }
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            int levelCount = 1;
            TreeSet<Cell> writeThese = new TreeSet<Cell>();
            Iterator<NodeInst> it2 = cell.getNodes();
            while (it2.hasNext()) {
                NodeInst ni = it2.next();
                if (ni.isCellInstance()) {
                    levelCount = 2;
                    Cell subCell = (Cell)ni.getProto();
                    writeThese.add(subCell);
                    Iterator<NodeInst> sIt = subCell.getNodes();
                    while (sIt.hasNext()) {
                        NodeInst subNi = sIt.next();
                        if (!subNi.isCellInstance()) continue;
                        levelCount = 3;
                        break;
                    }
                }
                if (levelCount <= 2) continue;
                break;
            }
            if (levelCount == 2) {
                out.writeLEFHeader(cell);
                FixpTransform ident = new FixpTransform();
                for (Cell c : writeThese) {
                    Netlist netlist = c.getNetlist();
                    out.writeCellHeader(netlist);
                    out.dumpCellContents(c, ident, false);
                    out.writeCellTrailer(c);
                }
                out.writeLEFTrailer();
                System.out.println("NOTE: Wrote subcells, but did not write the " + cell.describe(false) + " cell. Use DEF export for that.");
            } else {
                Netlist netlist = cell.getNetlist(Netlist.ShortResistors.ALL);
                out.writeLEFHeader(cell);
                out.writeCellHeader(netlist);
                HierarchyEnumerator.enumerateCell(netlist, context, (HierarchyEnumerator.Visitor)new LEFVisitor(out));
                out.writeCellTrailer(cell);
                out.writeLEFTrailer();
            }
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }
    }

    private static class LEFVisitor
    extends HierarchyEnumerator.Visitor {
        private LEF generator;

        public LEFVisitor(LEF generator) {
            this.generator = generator;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            FixpTransform trans = info.getTransformToRoot();
            this.generator.dumpCellContents(cell, trans, info.isRootCell());
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            return true;
        }
    }
}

