#include <alloc.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "define.h"
#include "buffers.h"
#include "tools.h"

//--------------------------------------------------------------------------
//------ Excuter les commandes du fichier DXTODO --------------------------
//--------------------------------------------------------------------------
void AUTOPROC_do(void)
{
  char 	Heure[5];
  int 	index;
  char  Line[256];
  FILE	* fPtr;

  //------ Quelle heure est-il ?
  TOOLS_whatTime(Heure);

  //------ Ouvrir le fichier, et lire les lignes une a une
  fPtr = fopen(DXTODO_FILE, "rt");

  //Le fichier n'a pas pu tre ouvert
  if( ! fPtr )
  {
    perror("fopen in AUTOPROC_do");
    return;
  }/*EndIF*/

  while(1)
  {
    if( ! fgets(Line, 255, fPtr) )
      break;

#ifdef LINUX
    //Supprime les ventuels "RETURN" sous LINUX
    TOOLS_removeR(Line);
#endif

    for(index = 0; index < 4 && index < (int) strlen(Line); index++)
    {
      if( Line[index] != '?' )
      {
	//Vrifier s'il y a concordance ?
	if( isdigit(Line[index]) && atoi(Line + index) == atoi(Heure + index) )
	{
	  break;
	}
	else
	{
	  index = -1;
	  break;
	}
      }/*End IF*/
    }/*End FOR*/

    //S'il y avait concordance, index n'est pas gal  4
    if( index >= 0 ) //Dans ce cas, ajouter la commande dans le buffer
    {
      TOOLS_removeN(Line);//Enlve tous les '\n' (normallement, il n'y en a qu'un, situ  la fin de la chaine)
      BUFFERS_printBuff(BUFFER_SCREEN1, IN, "%s\r", Line + 5);
    }
  };/*End WHILE*/

  fclose( fPtr );
}
