#include <alloc.h>
#include <stdio.h>
#include <string.h>
#include "define.h"
#include "buffers.h"
#include "tools.h"
#include "database.h"
#include "node.h"
#include "hops.h"
#include "language.h"
#include "params.h"

/*--------------------------------------------------------------------------
  ------ Lire le fichier SYSTEM\DXNET.CFG ----------------------------------
  -------------------------------------------------------------------------- */
void CONFIG_init(void)
{
	FILE* fPtr;
	char  szLine[256];

	fPtr = fopen(DXNET_FILE, "rt");

	if( ! fPtr )
		return;

	for(;;)
	{
		if( ! fgets(szLine, 255, fPtr) )
		{
			fclose(fPtr);
			return;
		}

		TOOLS_removeNR(szLine);

		if( szLine[0] != '\0' )		/* Inutile de bufferiser une ligne vide */
			BUFFERS_printBuff(BUFFER_SCREEN1, IN, "%s\r", szLine);
  }/*End WHILE*/
}

/*--------------------------------------------------------------------------
  ------ Recharger des configs ---------------------------------------------
  -------------------------------------------------------------------------- 
  Retour : TRUE si OK 
*/
int CONFIG_reload(char* pszCfg)
{
	extern char PARAMS_nUpdateConfig;
	int nDone = FALSE;

	PARAMS_nUpdateConfig = TRUE;

	/* CFG  : dxnet.cfg */
	if( ! strcmp(pszCfg, "ALL") || ! strcmp(pszCfg, "CFG") )
	{
		PARAMS_init();
		CONFIG_init();
		nDone = TRUE;
	}

	/* DB   : databases */
	if( ! strcmp(pszCfg, "ALL") || ! strcmp(pszCfg, "DB") )
	{
		DATABASE_init();
		nDone = TRUE;
	}

	/* HOPS : ~/scrips/*.cfg */
	if( ! strcmp(pszCfg, "ALL") || ! strcmp(pszCfg, "HOPS") )
	{
		extern int LastStream;	/* switch.cpp */
		extern int FirstStream;	/* switch.cpp */
		int stream;
		char szNodeCall[16];

		/* Parcourir tous les streams et recharcher les configs HOPS pour
		   les clusters trouves */
		for(stream = FirstStream; stream <= LastStream; stream++)
		{
			NODE_getNodeCall(stream, 0, szNodeCall);
			if( *szNodeCall )
			{
				/* Lire le fichier de config des hop count */
				HOPS_readFile(stream, szNodeCall);
			}
		}

		nDone = TRUE;
	}

	/* LANG : Languages */
	if( ! strcmp(pszCfg, "ALL") || ! strcmp(pszCfg, "LANG") )
	{
		LANG_init();
		nDone = TRUE;
	}

	return nDone;
}