#include <alloc.h>
#include <string.h>
#include "database.h"
#include "cupdate.h"
#include "define.h"
#include "message.h"
#include "commands.h"
#include "buffers.h"
#include "config.h"

/*-------------------------------------------------------------------------
  ------ Rediriger les commandes UPDATE -----------------------------------
  ------------------------------------------------------------------------
  La fonction return TRUE si la commande a ete executee                   */
#pragma argsused
int CUPDATE_execute(int StreamNum, char * pCmd_p, int nParams, char **pArg, char **pStrArg)
{
	int Length;			/*Longueur de la commande*/
	
	if( *pArg[0] == SNULL )
		return FALSE;

	/*Longueur de la commande*/
	Length = strlen (pArg[0]);

	/* Ne pas autoriser les remote commands */
	if( StreamNum >= RCMD_VIRTSTREAM )
		return FALSE;

	if( COMMANDS_check(pArg[0], "config", Length, 4) )
		return CUPDATE_config(StreamNum, nParams, pArg, pStrArg);

	if( CUPDATE_database(StreamNum, nParams, pArg, pStrArg) )
		return TRUE;

	return FALSE;		/* La commande n'a pas ete trouvee */
}

/*------------------------------------------------------------------------
  ------ UP/CONFIG - Updater la config du cluster (eq. a un redemarrage) -
  ------------------------------------------------------------------------*/
#pragma argsused
int CUPDATE_config(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern int  STREAMS_level[MAX_STREAMS];
	extern char PARAMS_nUpdateConfig;

	/* Niveau d'utilisateur */
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	/* Ne pas autoriser les remote commands */
	if( StreamNum >= RCMD_VIRTSTREAM )
		return FALSE;

	if( nParams != 2 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	/* Lancer l'update de la config */
	strupr(pArg[1]);
	PARAMS_nUpdateConfig = TRUE;
	if( ! CONFIG_reload(pArg[1]) )
	{
		MSG_send(StreamNum, MSG18);
		BUFFERS_addBuff(StreamNum, "UPLOAD/CONFIG <ALL|CFG|DB|HOPS|LANG>\n", OUT);
	}
	else
		BUFFERS_addBuff(StreamNum, "Done\r", IN);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ UP/DATABASE -----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CUPDATE_database(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern int STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur */
	if( STREAMS_level[StreamNum] & LEVEL_user_RXonly )
		return FALSE;

	/* Ne pas autoriser les remote commands */
	if( StreamNum >= RCMD_VIRTSTREAM )
		return FALSE;

	if( nParams > 2 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	if( DATABASE_update(StreamNum, pArg[0], pArg[1], DB_LOCAL) )
		return TRUE;	/* Commande update OK */
	else
		return FALSE;
}

