#ifndef _DEFINE_H
#define _DEFINE_H

#define PCFLEX		2
#define G8BPQ		1
#define NONE		0
#define CONNECTED	1
#define DISCONNECTED	2

#define DONE			0
#define ERR_NOT_ENOUGH_MEMORY   1
#define SNULL			'\0'

#ifndef TRUE
#define TRUE	(1==1)
#endif
#ifndef FALSE
#define FALSE	!TRUE
#endif
#define BYTE 	unsigned char

#ifdef LINUX
	#define LANGUAGE_PATH		"language/"
//	#define LANGUAGE_PATH1		"/language/"
	#define LANGUAGE_CFG_FILE	"system/language.dat"
	#define SCRIPT_PATH			"script/"
	#define HOPS_PATH			SCRIPT_PATH
	#define LFILTER_PATH		SCRIPT_PATH
	#define HOPS_BIN_FILE		"system/bin/hops.bin"
	#define DXTODO_FILE			"system/dxtodo.dat"
	#define DXNET_FILE			"system/dxnet.cfg"
	#define DX_FILE				"system/bin/dx.bin"
	#define WWV_FILE			"system/bin/wwv.bin"
	#define WCY_FILE			"system/bin/wcy.bin"
	#define ANNOUNCE_FILE		"system/bin/announce.bin"
	#define USERS_FILE			"system/bin/userscfg.bin"
	#define NODE_MAXUSERS		"system/bin/maxusers.bin"
	#define EXTCMD_PATH			"extcmd/"
	#define SYSCMD_PATH			"syscmd/"
	#define CALLBOOK_PATH		"callbook/"
	#define PASSWORD_PATH		"password/"
	#define PASSWORD_FILE		"system/passwd.dat"
	#define RCMD_FILE			"system/rcmd.dat"
	#define DATABASE_LOCAL_FILE	"system/local.dat"
	#define DATABASE_REMOTE_FILE	"system/remote.dat"
	#define DATABASE_UPDATE_FILE	"system/update.dat"
	#define MODE_FILE		"system/mode.dat"
	#define DATABASE_PATH		"database/"
	#define DATABASE_PREFIX_FILE	"database/cty.dat"
	#define LOG_PING_FILE		"logs/ping.log"
	#define LOG_NODE_FILE		"logs/node"
	#define LOG_USER_FILE		"logs/user"
	#define LOG_BUFFERIN_FILE	"logs/in"
	#define LOG_BUFFEROUT_FILE	"logs/out"
	#define LOG_TIME_FILE		"logs/time.log"
	#define LOG_MEM_FILE		"logs/mem"
	#define LOG_MARKER_FILE		"logs/marker.log"
	#define LOG_PAVILLON_FILE	"logs/pc"
	#define LOG_CLULINK_FILE	"logs/cl"
	#define LOG_PATH		"logs/"
	#define LOG_MESSAGES_FILE	"logs/messages"
	#define LOG_DEBUG_FILE		"logs/debug"
	#define MAIL_PATH		"mail/"
	#define MAIL_QUEUE_FILE		"system/bin/queue.bin"
	#define MAIL_QUEUE_BAKFILE	"system/bin/queue.bak"
	#define MAIL_DIRMES_FILE	"system/bin/dirmes.bin"
	#define MAIL_FORWARDSYS_FILE	"system/forward.sys"
	#define MAIL_LASTNUMBER		"system/bin/lastmail.bin"
	#define USERCMD_PATH		"users/"
	#define CFILTER_FILE		"language/cfilter.txt"
	#define TEMP_PATH			"tmp/"
	#define TEMP_RCMD_FILE		"tmp/rcmd.tmp"
	#define TEMP_VSNPRINTF		"tmp/vsn.tmp"
	#define BID_DATABASE_FILE	"system/bin/bid.bin"
	#define MAIL_BIDNUM_FILE	"system/bin/lastbid.bin"	
	#define CONFDIR				"./"
#else
	#define LANGUAGE_PATH		"language\\"
//	#define LANGUAGE_PATH1		"\\language\\"
	#define LANGUAGE_CFG_FILE	"system\\language.dat"
	#define SCRIPT_PATH			"script\\"
	#define HOPS_PATH			SCRIPT_PATH
	#define LFILTER_PATH		SCRIPT_PATH
	#define HOPS_BIN_FILE		"system\\bin\\hops.bin"
	#define DXTODO_FILE			"system\\dxtodo.dat"
	#define DXNET_FILE			"system\\dxnet.cfg"
	#define DX_FILE				"system\\bin\\dx.bin"
	#define WWV_FILE			"system\\bin\\wwv.bin"
	#define WCY_FILE			"system\\bin\\wcy.bin"
	#define ANNOUNCE_FILE		"system\\bin\\announce.bin"
	#define USERS_FILE			"system\\bin\\userscfg.bin"
	#define NODE_MAXUSERS		"system\\bin\\maxusers.bin"
	#define EXTCMD_PATH			"extcmd\\"
	#define SYSCMD_PATH			"syscmd\\"
	#define CALLBOOK_PATH		"callbook\\"
	#define PASSWORD_PATH		"password\\"
	#define PASSWORD_FILE		"system\\passwd.dat"
	#define RCMD_FILE			"system\\rcmd.dat"
	#define DATABASE_LOCAL_FILE	"system\\local.dat"
	#define DATABASE_REMOTE_FILE	"system\\remote.dat"
	#define DATABASE_UPDATE_FILE	"system\\update.dat"
	#define MODE_FILE			"system\\mode.dat"
	#define DATABASE_PATH		"database\\"
	#define DATABASE_PREFIX_FILE	"database\\cty.dat"
	#define LOG_PING_FILE		"logs\\ping"
	#define LOG_NODE_FILE		"logs\\node"
	#define LOG_USER_FILE		"logs\\user"
	#define LOG_BUFFERIN_FILE	"logs\\in"
	#define LOG_BUFFEROUT_FILE	"logs\\out"
	#define LOG_TIME_FILE		"logs\\time.log"
	#define LOG_MEM_FILE		"logs\\mem"
	#define LOG_MARKER_FILE		"logs\\marker.log"
	#define LOG_PAVILLON_FILE	"logs\\pc"
	#define LOG_CLULINK_FILE	"logs\\cl"
	#define LOG_PATH		"logs\\"
	#define LOG_MESSAGES_FILE	"logs\\messages"
	#define LOG_DEBUG_FILE		"logs\\debug"
	#define MAIL_PATH		"mail\\"
	#define MAIL_QUEUE_FILE		"system\\bin\\queue.bin"
	#define MAIL_QUEUE_BAKFILE	"system\\bin\\queue.bak"
	#define MAIL_DIRMES_FILE	"system\\bin\\dirmes.bin"
	#define MAIL_FORWARDSYS_FILE	"system\\forward.sys"
	#define MAIL_LASTNUMBER		"system\\bin\\lastmail.bin"
	#define USERCMD_PATH		"users\\"
	#define CFILTER_FILE		"language\\cfilter.txt"
	#define TEMP_PATH			"tmp\\"
	#define TEMP_RCMD_FILE		"tmp\\rcmd.tmp"
	#define TEMP_VSNPRINTF		"tmp\\vsn.tmp"
	#define BID_DATABASE_FILE	"system\\bin\\bid.bin"
	#define MAIL_BIDNUM_FILE	"system\\bin\\lastbid.bin"		
	#define CONFDIR				".\\"
#endif


#ifdef LINUX
	#define VERSION_INT	5431
#endif
#ifdef WIN32
	#define VERSION_INT 5432
#endif
#ifdef DOS
	#define VERSION_INT	5430
#endif

#define VERSION		"4.2"
#define VERSION_CLU	"0.5"
#define VERSION_CLU_INT	0005	/* Ne pas oublier d'accorder celui ci avec le precedent */

#define MAX_STREAMS	66			/* En comptant la console locale (F2) */

#define LEVEL_user_RXonly			1	// CFilter
#define LEVEL_user					2
#define LEVEL_sysopD				4	// Sysop Declare
#define LEVEL_sysopV				8	// Sysop Valide
#define LEVEL_cluster				16
#define LEVEL_term					32	// Sysop connecte sur le terminal
#define LEVEL_discByOp				64
#define LEVEL_linkSetup				128	// Un link sortant est en cours d'etablissement
#define LEVEL_bbs					256
#define LEVEL_bbsSIDOK				512
#define LEVEL_user_NoAnnoucements	1024 // CFilter
#define LEVEL_hiddenUser			2048

#define BYTE		unsigned char
#define Prompt				MSG_sendPrompt(StreamNum)
#define RCMD_VIRTSTREAM	100

#endif
