#include <alloc.h>
#include <stdio.h>
#include <string.h>
#include "dx.h"
#include "define.h"
#include "buffers.h"
#include "symbol.h"
#include "tools.h"
#include "users.h"
#include "log.h"

extern char	STREAMS_callsign[MAX_STREAMS][10];
extern char	STREAMS_level[MAX_STREAMS];

/*-------------------------------------------------------------------------
  ------ Ajouter un DX dans le fichier DX ---------------------------------
  -------------------------------------------------------------------------*/
void DX_add(char * pszDxCall, unsigned long lFrequency, char * pszComments, char * pszTime, char * pszDate, char * pszLogger, char * pszFromPC)
{
	FILE * fPtr;
	DXSPOT DxSpot;

	/* Limiter la longueur des champs */
	TOOLS_maxLength(pszFromPC,    9);
	TOOLS_maxLength(pszLogger,    9);
	TOOLS_maxLength(pszDxCall,   14);
	TOOLS_maxLength(pszComments, 30);
	TOOLS_maxLength(pszDate,     11);
	TOOLS_maxLength(pszTime,      4);

	/* Preparer les champs de l'enregistrement */
	memset(&DxSpot, 0, sizeof(DxSpot)); /* Fichier plus clean */
	strcpy(DxSpot.szFromPC,   pszFromPC);
	strcpy(DxSpot.szLogger,   pszLogger);
	strcpy(DxSpot.szDxCall,   pszDxCall);
	strcpy(DxSpot.szComments, pszComments);
	strcpy(DxSpot.szDate,	  pszDate);
	strcpy(DxSpot.szTime,	  pszTime);
	DxSpot.lFrequency = lFrequency;

	/* Ouvrir le fichier pour placer le nouveau DX a la fin */
	fPtr = fopen(DX_FILE, "a+b");

	if( ! fPtr )	/* Erreur d'ouverture du fichier */
	{
		perror("fopen in DX_add");
		return;
	}

	/* Enregistrer le DX a la fin du fichier */
	fwrite(&DxSpot, sizeof(DXSPOT), 1, fPtr);
	fclose(fPtr);
}

/*-------------------------------------------------------------------------
  ------ Vrifier la validit de la frquence -----------------------------
  -------------------------------------------------------------------------
  La fonctionne retourne la bande correspodant  la Frquence et 0 sinon   */
unsigned long DX_checkFrequency(unsigned long lFrequency)
{
	unsigned long Done = 0;

	if( lFrequency >= 710L          &&      lFrequency <= 750L )
		Done = USERS_2KM;

	if( lFrequency >= 1350L         &&      lFrequency <= 1380L )
		Done = USERS_2KM;

	if( lFrequency >= 18000L 	&&	lFrequency <= 20000L )
		Done = USERS_160M;
	else
	if( lFrequency >= 35000L 	&&	lFrequency <= 40000L )
		Done = USERS_80M;
	else
	if( lFrequency >= 70000L 	&&	lFrequency <= 73000L )
		Done = USERS_40M;
	else
	if( lFrequency >= 100000L 	&&	lFrequency <= 101500L )
		Done = USERS_30M;
	else
	if( lFrequency >= 140000L 	&&	lFrequency <= 143500L )
		Done = USERS_20M;
	else
	if( lFrequency >= 180680L 	&&	lFrequency <= 181680L )
		Done = USERS_17M;
	else
	if( lFrequency >= 210000L 	&&	lFrequency <= 214500L )
		Done = USERS_15M;
	else
	if( lFrequency >= 248900L 	&&	lFrequency <= 249900L )
		Done = USERS_12M;
	else
	if( lFrequency >= 280000L 	&&	lFrequency <= 297000L )
		Done = USERS_10M;
	else
	if( lFrequency >= 400000L 	&&	lFrequency <= 600000L ) /* 500000L -> 540000L */
		Done = USERS_6M;
	else
	if( lFrequency >= 700000L 	&&	lFrequency <= 705000L )
		Done = USERS_4M;
	else
	if( lFrequency >= 1440000L 	&&	lFrequency <= 1480000L )
		Done = USERS_2M;
	else
	if( lFrequency >= 2200000L 	&&	lFrequency <= 2250000L )
		Done = USERS_135CM;
	else
	if( lFrequency >= 4200000L 	&&	lFrequency <= 4500000L )
		Done = USERS_70CM;
	else
	if( lFrequency >= 9020000L 	&&	lFrequency <= 9280000L )
		Done = USERS_34CM;
	else
	if( lFrequency >= 12400000L 	&&	lFrequency <= 13000000L )
		Done = USERS_23CM;
	else
	if( lFrequency >= 23000000L 	&&	lFrequency <= 24500000L )
		Done = USERS_13CM;
	else
    if( lFrequency >= 33000000L 	&&	lFrequency <= 35000000L )
		Done = USERS_9CM;
	else
	if( lFrequency >= 56500000L 	&&	lFrequency <= 58500000L )
		Done = USERS_5CM;
	else
	if( lFrequency >= 100000000L 	&&	lFrequency <= 105000000L )
		Done = USERS_3CM;
	else
	if( lFrequency >= 240000000L 	&&	lFrequency <= 245000000L )
		Done = USERS_1CM;
	else
	if( lFrequency >= 470000000L 	&&	lFrequency <= 472000000L )
		Done = USERS_6MM;

	return Done;
}
/*-------------------------------------------------------------------------
  ------ Charger un DX du fichier DX --------------------------------------
  -------------------------------------------------------------------------
  La fonction retourne TRUE si le DX a pu etre lu                          */
int DX_get(int nPos, DXSPOT * pDxSpot)
{
	FILE *fPtr;
	long  lOffset;

	/* Ouvrir le fichier */
	fPtr = fopen(DX_FILE, "rb");

	if( ! fPtr ) /* Erreur d'ouverture du fichier */
	{
		perror("fopen in DX_get");
		return FALSE;
	}

	/* Se placer  la fin du fichier */
	fseek(fPtr, 0L, SEEK_END);

	/* Remonter de nPos enregistrements */
	lOffset =  (long) nPos * (long) sizeof(DXSPOT);
	if( lOffset > ftell(fPtr) )
	{
		fclose(fPtr);
		return FALSE;
	}
	fseek(fPtr, -lOffset, SEEK_CUR);

	/* Extraire les champs */
	fread(pDxSpot, sizeof(DXSPOT), 1, fPtr);

	/* Fermer le fichier et retourner */
	fclose( fPtr );
	return TRUE;
}

/*---------------------------------------------------------------------------
  ------ Rechercher si le spot DX est un double -----------------------------
  ---------------------------------------------------------------------------
  La fonction retourne LOG_PROT_OK | LOG_PROT_DUPE | LOG_PROT_AGE 
*/
int DX_isDupe(char * pszDxCall, unsigned long lFrequency, char * pszComments, char * pszTime, char * pszDate, char * pszLogger)
{
	extern long PARAMS_lDxRejectBefore;
	extern long PARAMS_lDxRejectAfter;

	#define	NLAST	4000L
	FILE   *fPtr;
	long	lOffset;
	int	index;
	char	szLogger[16];
	char	szBuffer1[256];
	char	szBuffer2[256];
	DXSPOT  DxSpot;
	unsigned long lCurrentDateTime;
	unsigned long lSpotDateTime;
	long lSearchDBTimeout = PARAMS_lDxRejectBefore + PARAMS_lDxRejectAfter;
	long lFileSize;

	/* Le spot rentre t-il dans la fenetre des heures */
	lCurrentDateTime = TOOLS_whatDateTime();
	lSpotDateTime    = TOOLS_dateTime_Str2Long(pszDate, pszTime);

	if( TOOLS_diffDateTime(lCurrentDateTime, lSpotDateTime) > (double) PARAMS_lDxRejectBefore )
		return LOG_PROT_AGE;	/* Spot trop vieux */

	if( TOOLS_diffDateTime(lSpotDateTime, lCurrentDateTime) > (double) PARAMS_lDxRejectAfter )
		return LOG_PROT_AGE;	/* Spot trop " recent " */

	/* Recherche de DUPE a effectuer qqs le SSID du logger */
	strcpy(szLogger, pszLogger);
	TOOLS_removeSsid(szLogger);

	/* Ouvrir le fichier */
	fPtr = fopen(DX_FILE, "rb");

	if( ! fPtr )	/* Impossible d'ouvrir */
	{
		perror("fopen in DX_isDupe");
		return FALSE;
	}

	/* Taille du fichier */
	fseek(fPtr, 0L, SEEK_END);
	lFileSize = ftell(fPtr);

	/* Tester chacun des spots */
	TOOLS_removeNonAscii(pszComments, szBuffer1);
	for(index = 1; index < NLAST; index++)
	{
		long lDateTime;

		/* Positionner dans le fichier */
		lOffset = (long) index * (long) sizeof(DXSPOT);
		if( lOffset > lFileSize )
			break;
		fseek(fPtr, -lOffset, SEEK_END);

		/* Lecture enregistrement */
		if( ! fread(&DxSpot, sizeof(DXSPOT), 1, fPtr) )
			break;	/* EOF */

		/* Timeout recherche ? */
		lDateTime = TOOLS_dateTime_Str2Long(DxSpot.szDate, DxSpot.szTime);
		if( TOOLS_diffDateTime(lCurrentDateTime, lDateTime) > (double) lSearchDBTimeout )
			break;

		/* Comparer ... */
		TOOLS_removeNonAscii(DxSpot.szComments, szBuffer2);
		TOOLS_removeSsid(DxSpot.szLogger);	/* Qqs le SSID du logger */
		if( ! strcmp(pszDxCall,   DxSpot.szDxCall)   &&
		      lFrequency    ==    DxSpot.lFrequency  &&
		    ! strcmp(szBuffer1,   szBuffer2)         &&
		    ! strcmp(pszTime,     DxSpot.szTime)     &&
		    ! strcmp(szLogger,    DxSpot.szLogger)  )
		{
			/* DUPE */
			fclose( fPtr );
			return LOG_PROT_DUPE;
		}

	}/* End FOR */

	/* Fermer le fichier et retourner */
	fclose( fPtr );
	return LOG_PROT_OK;
}