#include <alloc.h>
#include <stdio.h>
#include <stdarg.h>
#include <dir.h>
#include <string.h>
#include <stdarg.h>
#include "define.h"
#include "log.h"
#include "tools.h"
#include "users.h"
#include "symbol.h"

int LOG_nSysLogLevel     = 3;
int LOG_nDebugLogLevel   = 1;
int LOG_nUserLogLevel    = 1;
int LOG_nClusterLogLevel = 1;

/* Ces fonctions enregistrent un log des activites du serveur              */

//---------------------------------------------------------------------------
//------ LOG_write ----------------------------------------------------------
//---------------------------------------------------------------------------
//La fonction retourne TRUE si le log a pu etre enregistre, et FALSE sinon
int LOG_write(char * FileName, int Date, char * String, ...)
{
  va_list     	args;
  char 		sBuf[512];
  char		sDate[15];
  char		sTime[10];
  char		sFileName[MAXPATH];

  FILE	     *fPtr;

  //Lire les arguments
  va_start(args, String);
  vsprintf(sBuf, String, args);
  va_end(args);

  //Preparer le nom de fichier
  sprintf(sFileName, "%s%02d%02d.log", FileName, TOOLS_whatYear(), TOOLS_whatMonth());

  //Ouvrir le fichier en ajout
  fPtr = fopen(sFileName, "at");

  if( ! fPtr )
  {
    perror("fopen in LOG_write");
    return FALSE;	//Le fichier n'a pas pu etre ouvert
  }

  //Ecriture de la chaine
  if( Date == LOG_DATE_YES )	//Faut-il dater l'info ?
    fprintf(fPtr, "%s <%sZ> : ", TOOLS_whatDate(sDate), TOOLS_whatTime(sTime));

  fputs(sBuf, fPtr);

  //Fermeture du fichier et retour
  fclose (fPtr);
  return TRUE;
}

//--------------------------------------------------------------------------
//------ Enregistrer un marqueur pour indiquer ou en est le programme ------
//--------------------------------------------------------------------------
#ifdef DEBUG_MARK_
void LOG_saveMarker(char * String)
{
  FILE *fPtr;

  fPtr = fopen(LOG_MARKER_FILE, "wt");

  if( ! fPtr )
  {
    perror("fopen in LOG_saveMarker");
    return;   	//PB ouverture du fichier
  }

  fputs(String, fPtr);

  fclose (fPtr);
}
#endif

/*--------------------------------------------------------------------------
  ------ Reglages de parametres LOG ----------------------------------------
  --------------------------------------------------------------------------
  si value < 0, la fonction retourne la valeur courante du LOG sans la
  modifier 
*/
int LOG_setSysLogLevel(int value)
{
	int old = LOG_nSysLogLevel;
	if( value >= 0 )
		LOG_nSysLogLevel = value;
	return old;
}

int LOG_setDebugLogLevel(int value)
{
	int old = LOG_nDebugLogLevel;
	if( value >= 0 )
		LOG_nDebugLogLevel = value;
	return old;
}

/* log des connexions utilisateur */
int LOG_setUserLogLevel(int value)
{
	int old = LOG_nUserLogLevel;
	if( value >= 0 )
		LOG_nUserLogLevel = value;
	return old;
}

/* log des connexions cluster */
int LOG_setClusterLogLevel(int value)
{
	int old = LOG_nClusterLogLevel;
	if( value >= 0 )
		LOG_nClusterLogLevel = value;
	return old;
}

#undef fopen(filename,mode)
#undef fclose(fptr)
#undef perror(ptr)

/*--------------------------------------------------------------------------
  ------ Enregistrer une info dans le log messages -------------------------
  --------------------------------------------------------------------------
  Niveaux de log :
  0 : rien
  1 : login/logout
  2 : erreurs de protocoles
  4 : out of age, pings, WWV/WCY, ...
  8 : protocoles rejets (dupes, loop, ping_pong)

  Niveaux de log/debug
  0 : rien
  1 : erreurs internes (ouverture de fichiers, sh/fc, ...)
  2 : trace ds les fonctions principales
  4 : buffers in/out
  8 : tout
*/
void LOG_message(int StreamNum, int nDirection, int nMessageType, char* str, ...)
{
	extern char	STREAMS_callsign[MAX_STREAMS][10];

	static va_list args;
	static char buffer[8192];
	static FILE* fPtr;
	char* pszRaison = "";
	int nLogType = -1;
	int nLevel   = -1;

	switch(nMessageType)
	{
	case LOG_PROT_DUPE :
		pszRaison = "DUPE";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 8;
		break;
	case LOG_PROT_LOOP :
		pszRaison = "LOOP";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 8;
		break;
	case LOG_PROT_BADCALL :
		pszRaison = "BADCALL";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 2;
		break;
	case LOG_PROT_BADNUMARG :
		pszRaison = "BADNUMARG";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 2;
		break;
	case LOG_PROT_BADFREQ:
		pszRaison = "BADFREQ";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 2;
		break;
	case LOG_PROT_STROVERFLOW :
		pszRaison = "TOO_LONG";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 2;
		break;
	case LOG_PROT_NODEUNKNOWN :
		pszRaison = "UNKNOWN_NODE";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 2;
		break;
	case LOG_PROT_USERUNKNOWN :
		pszRaison = "UNKNOWN_USER";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 2;
		break;
	case LOG_PROT_UNEXPECTEDERROR :
		pszRaison = "UNEXPECTED_ERROR";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 2;
		break;
	case LOG_PROT_BADMSGNUMBER :
		pszRaison = "BAD_MSG_NUMBER";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 2;
		break;
	case LOG_PROT_AGE :
		pszRaison = "AGE";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 4;
		break;
	case LOG_PROT_WAZFILTER :
		pszRaison = "WAZ_FILTRED";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 8;
		break;
	case LOG_PROT_PINGPONG :
		pszRaison = "PING_PONG";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 8;
		break;
	case LOG_PROT_WWVTWICEINWINDOW :
		pszRaison = "WWV/WCY_TWICE_IN_WINDOW";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 8;
		break;
	case LOG_PROT_PING :
		pszRaison = "PING";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 8;
		break;
	case LOG_PROT_BADCRC :
		pszRaison = "BAD_CRC";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 2;
		break;
	case LOG_PROT_PROTUNKNOWN :
		pszRaison = "PROTOCOL_UNKNOWN";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 2;
		break;

	case LOG_LOGIN :
		pszRaison = "LOGIN";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 1;
		break;
	case LOG_LOGOUT :
		pszRaison = "LOGOUT";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 1;
		break;

		/* DEBUG */
	case LOG_FILEIOERROR :
		pszRaison = "FILE_IO_ERROR";
		nLogType = LOG_TYPE_DEBUG;
		nLevel = 1;
		break;
	case LOG_FILEIO :
		pszRaison = "FILE_IO";
		nLogType = LOG_TYPE_DEBUG;
		nLevel = 1;
		break;
	case LOG_INTERNALERROR :
		pszRaison = "INTERNAL_ERROR";
		nLogType = LOG_TYPE_DEBUG;
		nLevel = 1;
		break;
	case LOG_DEBUG1 :
		pszRaison = "DEBUG1";
		nLogType = LOG_TYPE_DEBUG;
		nLevel = 1;
		break;
	case LOG_DEBUG2 :
		pszRaison = "DEBUG2";
		nLogType = LOG_TYPE_DEBUG;
		nLevel = 2;
		break;
	case LOG_DEBUG3 :
		pszRaison = "DEBUG3";
		nLogType = LOG_TYPE_DEBUG;
		nLevel = 4;
		break;
	case LOG_DEBUG4 :
		pszRaison = "DEBUG4";
		nLogType = LOG_TYPE_DEBUG;
		nLevel = 8;
		break;
	case LOG_IO_BUFFER_TRACE :
		pszRaison = "IO_BUFFER";
		nLogType = LOG_TYPE_DEBUG;
		nLevel = 4;
		break;
	case LOG_SOCKET_ERROR :
		pszRaison = "SOCKET";
		nLogType = LOG_TYPE_DEBUG;
		nLevel = 1;
		break;

	case LOG_STATUS :
		pszRaison = "STATUS";
		nLogType = LOG_TYPE_SYSTEM;
		nLevel = 1;
		break;

	default :
		pszRaison = "???";
		nLogType = LOG_TYPE_DEBUG;
		nLevel = 1;
		break;
	}

	/* lire les arguments */
	va_start(args, str);
	TOOLS_vsnprintf(buffer, 8191, str, args);
	va_end(args);
	buffer[8191] = SNULL;

	/* Si c'est une trace STATUS, il faut l'ecrire dans messages et dans debug */
	for(;;)
	{
		char* ptr;

		/* quel type de log, avec quel niveau ? */
		if( nLogType == LOG_TYPE_SYSTEM )
		{
			if( ! (nLevel & LOG_nSysLogLevel) )
				return;
			fPtr = fopen(LOG_MESSAGES_FILE, "at");
		}
		else
		{
			if( ! (nLevel & LOG_nDebugLogLevel) )
				return;
			fPtr = fopen(LOG_DEBUG_FILE, "at");
		}
		
		if( ! fPtr )
		{
			perror("fopen in LOG_messages :");
			return;
		}

		/* date et heure - format YYYYMMDD HHMMSS */
		fprintf(fPtr, "%04d%02d%02d %04d%02d ", TOOLS_whatYear4(), TOOLS_whatMonth(),
			TOOLS_whatDay(), TOOLS_whatTime(), TOOLS_whatSec());

		/* stream - format nn */
		if( StreamNum != -1 )
		{
			fprintf(fPtr, "%02d%c%c%s: ", StreamNum, nDirection == LOG_IN ? '-' : '<',
				nDirection == LOG_IN ? '>' : '-', STREAMS_callsign[StreamNum]);
		}

		/* raison et datas (en remplacant certains caracteres) */
		fprintf(fPtr, "%s: ", pszRaison);
		ptr = buffer;
		while(*ptr)
		{
			if( *ptr == '\n' || *ptr == '\r' )
				fputc('', fPtr);
			else if( *ptr == BELL )
				fputc('', fPtr);
			else
				fputc(*ptr, fPtr);
			ptr++;
		}
		fputc('\n', fPtr);
		
		fclose(fPtr);

		if( nMessageType == LOG_STATUS && nLogType != LOG_TYPE_DEBUG )
		{
			nLogType = LOG_TYPE_DEBUG;
			continue;
		}
		break;
	}
}

/*--------------------------------------------------------------------------
  ------ Enregistrer une info SYSTEM dans le log messages ------------------
  --------------------------------------------------------------------------
*/
void LOG_sysMessage(int nMessageType, char* str, ...)
{
	va_list args;
	static char buffer[1024];

	/* lire les arguments */
	va_start(args, str);
	TOOLS_vsnprintf(buffer, 1023, str, args);
	va_end(args);
	buffer[1023] = SNULL;

	LOG_message(-1, -1, nMessageType, "%s", buffer);
}