#ifndef LOG_H
#define LOG_H

int  LOG_write(char * FileName, int Date, char * String, ...);
void LOG_saveTime(void);
int LOG_setSysLogLevel(int value);
int LOG_setDebugLogLevel(int value);
int LOG_setUserLogLevel(int value);
int LOG_setClusterLogLevel(int value);
void LOG_message(int StreamNum, int nDirection, int nMessageType, char* str, ...);
void LOG_sysMessage(int nMessageType, char* str, ...);

#define LOG_getSysLogLevel()		LOG_setSysLogLevel(-1)
#define LOG_getDebugLogLevel()		LOG_setDebugLogLevel(-1)
#define LOG_getUserLogLevel()		LOG_setUserLogLevel(-1)
#define LOG_getClusterLogLevel()	LOG_setClusterLogLevel(-1)


#define	LOG_PING_STR		"PING"
#define LOG_NODE_STR		"NODE"
#define LOG_USER_STR		"USER"
#define LOG_BUFFER_STR		"BUFFER"	//En DEBUG_LOG_ uniquement
#define LOG_MEM_STR			"MEMORY"	//En DEBUG_LOG_ uniquement
#define LOG_PAVILLON_STR	"PAVILLON"
#define LOG_CLULINK_STR		"CLULINK"

#define LOG_DATE_YES	1
#define LOG_DATE_NO	0

#define LOG_IN		0	/* adjacent -> moi */
#define LOG_OUT		1	/* moi -> adjacent */

/* raisons */
#define LOG_PROT_OK					0
#define LOG_PROT_DUPE				1
#define LOG_PROT_LOOP				2
#define LOG_PROT_BADCALL			3
#define LOG_PROT_BADNUMARG			4
#define LOG_PROT_BADFREQ			5
#define LOG_PROT_STROVERFLOW		6
#define LOG_PROT_USERUNKNOWN		7
#define LOG_PROT_NODEUNKNOWN		8
#define LOG_PROT_UNEXPECTEDERROR	9
#define LOG_PROT_BADMSGNUMBER		10
#define LOG_PROT_AGE				11
#define LOG_PROT_WAZFILTER			12
#define LOG_PROT_WWVTWICEINWINDOW	13
#define LOG_PROT_PINGPONG			14
#define LOG_PROT_PING				15
#define LOG_PROT_BADCRC				16
#define LOG_PROT_PROTUNKNOWN		17
#define LOG_SOCKET_ERROR			18

#define LOG_LOGIN				100
#define LOG_LOGOUT				101

/* debug */
#define LOG_FILEIOERROR				200
#define LOG_FILEIO				201
#define LOG_INTERNALERROR			202
#define LOG_DEBUG1				203
#define LOG_DEBUG2				204
#define LOG_DEBUG3				205
#define LOG_DEBUG4				206
#define LOG_IO_BUFFER_TRACE			207

#define LOG_STATUS				300

/* Quel type de log ? */
#define LOG_TYPE_SYSTEM	1
#define LOG_TYPE_DEBUG	2

#endif LOG_H