#include <alloc.h>
#include <string.h>
#include <dir.h>
#include <stdio.h>
#include "define.h"
#include "tools.h"
#include "symbol.h"
#include "mail.h"
#include "message.h"
#include "node.h"
#include "buffers.h"
#include "users.h"
#include "protocol.h"
#include "commands.h"

//---------------------------------------------------------------------------
//------ variables globales -------------------------------------------------
//---------------------------------------------------------------------------
unsigned long 	MAIL_lFwdMsgNumber[MAX_STREAMS];
int  MAIL_nNumOfLines[MAX_STREAMS];
int	 MAIL_nCurrentLine[MAX_STREAMS];
int	 MAIL_nTimeOut[MAX_STREAMS];
char MAIL_szBid[7] = "";	/* BID, 6 caracteres max */

static unsigned long MAIL_getBidNum(unsigned long dwMailNumber);

//---------------------------------------------------------------------------
//------ Variables externes -------------------------------------------------
//---------------------------------------------------------------------------
extern char	STREAMS_callsign[MAX_STREAMS][10];
extern int	STREAMS_level[MAX_STREAMS];

//---------------------------------------------------------------------------
//------ Rechercher les separateurs dans la ligne de commande "S" -----------
//---------------------------------------------------------------------------
char * MAIL_searchSep( char * pszBuffer )
{
  char	cSep[6] = {' ', '@', '<', '$', '+', '\0'};
  int	index;
  char *pPtr     = SNULL;
  char *pPtr_Old = SNULL;

  for(index = 0; index < 6; index++)
  {
    pPtr = strchr(pszBuffer, cSep[index]);

    //Est-il plus proche que le separateur trouve precedemment ?
    if( pPtr && ((pPtr < pPtr_Old) || pPtr_Old == SNULL) )
      pPtr_Old = pPtr;

  }/*End FOR*/

  return pPtr_Old;
}

/*--------------------------------------------------------------------------
  ------ Preparer l'envoi d'un message -------------------------------------
  --------------------------------------------------------------------------
  La fonction retourne : 
	0 => OK
	1 => PB systeme
	2 => BID
*/
int MAIL_rcvRecip(int StreamNum, char * pszType, char * pszParams, BYTE byRetReceipt, int nDupe)
{
	char szBuffer[1024];
	char *pszBuffer;
	char szRecipient[16];
	char szRoute[10];
	char szSender[7];
	char szBID[13];
	char szType[3];
	char *pPtr;
	char cChr = SNULL;
	int	 nDone = FALSE;
	char szFileName[MAXPATH];
	FILE *fPtr;

	/* Verifier la presence du champ "RECIPIENT" */
	if( ! pszParams )
	{	
		MSG_send(StreamNum, MSG17);
		return 1;	/* Inutile d'aller plus loin */
	}

	/* En majuscule svp ... */
	strupr( pszParams );

	/* Copier le contenu de szParams dans szBuffer afin de preserver
       le contenu de la variable d'origine (pour l'affichage sur la
       console) */
	TOOLS_maxLength(pszParams, 1023);	/* Par simple securite */
	strcpy(szBuffer, pszParams);
	pszBuffer = szBuffer;

	pPtr = szBuffer;

	/* Lecture du destinataire */
	/* Rechercher un separateur */
	pPtr = MAIL_searchSep(pszBuffer);
	if( pPtr )
	{
		/* De quel separateur s'agit-il ? */
		cChr = *pPtr;

		/* Placer un NULL */
		*pPtr = SNULL;
	}/*End IF*/

	/* Limiter la longueur de l'indicatif a 8 caracteres, sans SSID
       et copier dans la variable szRecipient */
	TOOLS_maxLength(pszBuffer, 8);
	TOOLS_removeSsid(pszBuffer);
	strcpy(szRecipient, pszBuffer);

	/* Initialisation des champs facultatifs */
	szRoute[0] 	= SNULL;
	szSender[0]	= SNULL;
	szBID[0]    = SNULL;

	/* Lecture des champs facultatifs */
	for(;;)
	{
		pszBuffer = pPtr + 1;
		switch( cChr )
		{
		case SNULL :
			nDone = TRUE;
			break;

		case ' ' :	/* Rechercher le separateur suivant */	
			pPtr = MAIL_searchSep( pszBuffer );
			cChr = *pPtr;
			*pPtr = SNULL;
			break;

		case '@' : 
			/* Virrer les espaces eventuels au debut du champ */			
			while( *pszBuffer == ' ' )
				pszBuffer++;
			/* Rechercher le separateur suivant */
			pPtr = MAIL_searchSep( pszBuffer );
			cChr = *pPtr;
			*pPtr = SNULL;
			TOOLS_maxLength(pszBuffer, 10);
			strcpy(szRoute, pszBuffer);
			break;

		case '<' :
			/* Virrer les espaces eventuels au debut du champ */
			while( *pszBuffer == ' ' )
				pszBuffer++;
			/* Rechercher le separateur suivant */
			pPtr = MAIL_searchSep( pszBuffer );
			cChr = *pPtr;
			*pPtr = SNULL;
			TOOLS_maxLength(pszBuffer, 6);
			TOOLS_removeSsid(pszBuffer);
			strcpy(szSender, pszBuffer);
			break;

		case '$' :	/* BID */
			pPtr = MAIL_searchSep(pszBuffer);
			cChr = *pPtr;
			*pPtr = SNULL;
			TOOLS_maxLength(pszBuffer, 13);
			strcpy(szBID, pszBuffer);
			break;
		}

		if( nDone == TRUE )
			break;
	}

	/* Chercher si le BID existe dans la base de donnees */
	if( *szBID && MAIL_searchBidDB(szBID) )
		return 2;

	/* Generer un fichier TEMP qui contiendra :
	 * 1) Premiere ligne   : SB ou SP RECIPIENT ROUTE EXPEDITEUR $BID RET_RECEIPT_FLAG DUPE_FLAG
     *                       si un des champs est "vide", il est remplace par
     *                       un jocker (*)
	 * 2) Deuxieme ligne   : Titre du message
	 * 3) Troisime ligne  : si recu d'un adjacent : 
							 F: 10-jan-1996 1018 F5AAA-3 F6BBB-6
							 (voir fonction MAIL_tmp2mail pour dtails)
     * 4) Lignes suivantes : message
	 */

	/* Ouvrir un fichier temporaire (STREAMnn.TMP, ou nn est le numero
       du stream) dans le repertoire MAIL */
	sprintf(szFileName, "%sstream%02d.tmp", MAIL_PATH, StreamNum);

    fPtr = fopen(szFileName, "wt");
	if( ! fPtr )	
	{
		perror("fopen in MAIL_rcvRecip");
		return 1;
	}

	/* MAJ des variables qui vont etre sauvegardees */
	if( ! szRoute[0] ) /* Placer un jocker si szRoute est vide */
		strcpy(szRoute, "*");

	if( ! szSender[0] )	/* Copier l'indicatif utilisateur du stream si */
	{
		strcpy(szBuffer, STREAMS_callsign[StreamNum]);
		strcpy(szSender, TOOLS_removeSsid(szBuffer) );
	}

	/*Type du message (PERSO ou BULL ?) -- ATTENTION : pszType ne DOIT pas etre NULL */
	TOOLS_maxLength(pszType, 2);
	strcpy(szType, pszType);
	strupr( szType );
	if( szType[0] != 'S' || (szType[1] != 'B' && szType[1] != 'P') )
	{
		/* Le destinataire est-il un indicatif ? */
		if( TOOLS_isCall( szRecipient ) || ! strcmp(szRecipient, "SYSOP") )
			strcpy(szType, "SP");	/* Message perso */
		else
			strcpy(szType, "SB");	//Bulletin
	}

	fprintf(fPtr, "%s %s %s %s $%s %d %d\n", szType, szRecipient, szRoute,
		szSender, szBID, byRetReceipt, nDupe ? 1 : 0);

	/* Fermer le fichier */
	fclose( fPtr );

	return 0;
}

/*-------------------------------------------------------------------------
  ------ Effacer le fichier temporaire ------------------------------------
  ------------------------------------------------------------------------- */
void MAIL_delTemp(int StreamNum)
{
	char	szFileName[MAXPATH];
	sprintf(szFileName, "%sstream%02d.tmp", MAIL_PATH, StreamNum);
	unlink(szFileName);
}

/*-------------------------------------------------------------------------
  ------ Creer un nouveau message a partir d'un TMP -----------------------
  -------------------------------------------------------------------------
  La fonction retourne le numero du nouveau message (et 0 sinon)
  Si c'est un DUPE la fonction retourne ~0                                 */
unsigned long MAIL_tmp2Msg(int StreamNum)
{
	char szTime[10];
	char szType[10];
	char szBuffer[256];
	char szNodeCall[11];
	char szBID[256];
	int	nStream;
	FILE* fTmp;
	FILE* fMsg;
	FILE* fDirMes;
	char szFileName[MAXPATH];
	DirMesStruct	tDirMes;
	int	nRetReceipt;
	int nDupe;
	int nContainBid = FALSE;	/* TRUE si le corps du message contient un BID */
	int nLocalMail  = FALSE;	/* TRUE si forwarde par BBS ou poste par utilisateur local */
	int nForwarded  = FALSE;	/* TRUE si message forwarde */

	/* Init */
	memset(&tDirMes, 0, sizeof(DirMesStruct));
	tDirMes.dwNumber = MAIL_lastNum() + 1L;

	/* Ouvrir le fichier TMP */
	sprintf(szFileName, "%sstream%02d.tmp", MAIL_PATH, StreamNum);
	fTmp = fopen(szFileName, "rt");
	if( ! fTmp )
	{
		perror("fopen in MAIL_tmp2Msg (fTmp)");
		return 0L;
	}

	/* Lire la premiere ligne (parametres) */
	fgets(szBuffer, 255, fTmp);
	sscanf(szBuffer, "%s %s %s %s %s %d %d", szType,
						tDirMes.szRecipient,
						tDirMes.szRoute,
						tDirMes.szSender,
						szBID,
						&nRetReceipt,
						&nDupe);

	strcpy(tDirMes.szBid, szBID + 1);	/* Enleve le $ qui precede le BID */
//	TOOLS_removeSsid(tDirMes.szRecipient);

	/* Si c'est un message DUPE, ne pas l'enregistrer */
	if( nDupe != 0 )
	{
		fclose(fTmp);
		return (unsigned long) ~0L;
	}

	/* Gestion du return receipt */
	if( nRetReceipt && szType[1] == 'P' )
		tDirMes.byRetReceipt = TRUE;
	else
		tDirMes.byRetReceipt = FALSE;

	/* Virrer le jocker du routage s'il existe */
	if( tDirMes.szRoute[0] == '*' )
		tDirMes.szRoute[0] = SNULL;

	/* Lire la deuxieme ligne (sujet du msg) */
	fgets(szBuffer, 255, fTmp);
	TOOLS_removeNR(szBuffer);
	strcpy(tDirMes.szTitle, szBuffer);

	/* BULL ou PERSO ? */
	if( szType[1] == 'P' )
		tDirMes.cType = TYPE_P;
	else
		tDirMes.cType = TYPE_B;

	/* STATUT N automatiquement */
	tDirMes.cStatut = STATUT_N;

	/* ouvrir le fichier MSG definitif */
	sprintf(szFileName, "%sm%07ld.msg", MAIL_PATH, tDirMes.dwNumber);
	fMsg = fopen(szFileName, "wt");
	if( ! fMsg )	
	{
		fclose( fTmp );	/* Ne pas oublier de fermer ce fichier ! */
		perror("fopen in MAIL_tmp2Msg (fMsg)");
		return 1L;
	}

	/* Lire la troisieme ligne
	 * Format : "F: 10-jan-1996 1018 F5AAA-3 F6BBB-6"
	 *              ^^Date      ^^H  ^^StartNode ^^RcvNode
	 */
	if( ! fgets(szBuffer, 255, fTmp) )
		szBuffer[0] = SNULL;

	if( ! strncmp(szBuffer, "F: ", 3) )
	{
		char szDate[20];

		/* Extraire les parametres */
		sscanf(szBuffer + 3, "%s %s %s %s", szDate,
							szTime,
							tDirMes.szStartNode,
							tDirMes.szRcvNode);

		/* Lorsque StartNode est inconnu, c'est un ? qui est enregistre pour
		   que sscanf puisse l'extraire. Il faut ICI le replacer par un SNULL */
		if( * tDirMes.szStartNode == '?' )
		    * tDirMes.szStartNode = SNULL;

		/* Jour de la date sur un chiffre ? Il faut ajouter un espace devant */
		sprintf(tDirMes.szDate, "%11s", szDate);
	}
	else
	{
		/* La ligne n'existe pas. On considere dans ce cas que le message
		   est local.
		   Il faudra sauvegarder cette ligne dans le message ! */
		TOOLS_whatDate(tDirMes.szDate);
		TOOLS_whatTime(szTime);
		NODE_getNodeCall(0, 0, tDirMes.szStartNode);
		tDirMes.szRcvNode[0] = SNULL;
		nLocalMail = TRUE;	/* message forwarde par BBS ou poste par utilisateur local */

		/* Creer, si besoin, un BID */
		if( tDirMes.szBid[0] == SNULL )
			sprintf(tDirMes.szBid, "%ld_%s", MAIL_getBidNum(tDirMes.dwNumber), MAIL_getBid());
		else
			nForwarded = TRUE;

		fputs(szBuffer, fMsg);
	}

	/* Effectuer la copie du message en parsant le BID */
	while( fgets(szBuffer, 255, fTmp) )
	{
		char* pszBID;
		char* pszDollar;
		int   index;
			
		fputs(szBuffer, fMsg);

		/* Rechercher le BID du message */
		if( (pszBID = strstr(szBuffer, "BID: $")) == NULL )
			if( (pszBID = strstr(szBuffer, "BID:$")) == NULL )
				continue;	/* pas de BID dans cette ligne */

		/* Extraire le BID */
		pszDollar = strchr(pszBID, '$');
		pszDollar++;	/* Passer le $ */
		pszBID = tDirMes.szBid;
		for(index = 0; index < 12; index++) /* Le BID fait, au plus, 12 characteres de long */
		{
			if( *pszDollar <= 32 || (unsigned char) *pszDollar > 127 )
				break;
			*pszDollar++ = *pszBID++;
		}
		*pszBID = '\0';

		nContainBid = TRUE;
	}

	/* Ajouter, si besoin, une ligne a la fin du fichier contenant l'info BID */
	if( nLocalMail && ! nContainBid )
	{
		char szNodeCall[16];

		NODE_getNodeCall(0, 0, szNodeCall);

		if( nForwarded )
			fprintf(fMsg, "BBS Message forwarded to %s  BID: $%s\n", szNodeCall, tDirMes.szBid);
		else
			fprintf(fMsg, "Message sent from %s  BID: $%s\n", szNodeCall, tDirMes.szBid);
	}

	tDirMes.byTi_Min  = atoi(szTime) % 100;
	tDirMes.byTi_Hour = atoi(szTime) / 100;

	/* Fermer les fichiers ouverts */
	fclose( fTmp );
	fclose( fMsg );

	//Definir le routage du message
	//Strategie :
	//	1/ Le routage est precise.
	//		Tant mieux, moins de boulot
	//	2/ Le routage n'est pas precise
	//		a/ Si c'est un bulletin
	//			Rechercher dans le fichier FORWARD.SYS
	//		b/ Si c'est un message PERSO
	//			L'utilisateur est connecte ?
	//				Alors router dans sa direction
	//			L'utilisateur n'est pas connecte ?
	//				Rechercher dans les configs user
	//			Rien de trouve ?
	//				Prevenir l'utilisateur que le message
	//				ne pourra pas etre route

	if( tDirMes.szRoute[0] )	//Un routage a ete precise ?
	{
		//On fait confiance ... aie aie aie
		MAIL_queue(tDirMes.szRoute, tDirMes.dwNumber);
	}
	else
	{
		if( tDirMes.cType == TYPE_B )  //------ BULLETIN ------
		{
			char	szSearchFor[20];
			char	szAt[20];
			char	szBuffer[256];
			char	szLine[256];
			FILE     *fFwdSys;

			//Format du fichier SYSTEM/FORWARD.SYS
			//	:CLUSTERCALL1
			//	  >RECIP1
			//	  >RECIP2
			//	  END
			//	:CLUSTERCALL2
			//	  >RECIP1
			//	  >... etc ...
			//	  END

			//Prepare la chaine qu'il faut rechercher
			sprintf(szSearchFor, ">%s", tDirMes.szRecipient);

			//Ouvrir le fichier FORWARD.SYS
			fFwdSys = fopen(MAIL_FORWARDSYS_FILE, "rt");

			if( fFwdSys )	//Seulement si le fichier a pu etre ouvert
			{
				while( fgets(szBuffer, 255, fFwdSys) )
				{
					//S'affranchir de la mise en page
					sscanf(szBuffer, "%s", szLine);

					if( szLine[0] == ':' ) //Un nouvel adjacent ?
					{
						//Eh oui ...
						TOOLS_maxLength(szLine, 11);
						strcpy(szAt, szLine + 1);
						strupr(szAt);

						//Rechercher maintenant si le routage est specifie
						while( fgets(szBuffer, 255, fFwdSys) )
						{
							sscanf(szBuffer, "%s", szLine);
							strupr(szLine);

							//Fin atteinte pour cet adjacent ?
							if( ! strcmp(szLine, "END") )
								break;

							//Concordance avec le Recipient specifie par l'utilisateur ?
							if( ! strcmp(szLine, szSearchFor) )
							{
								//Pas de ping-pong ...
								if( strcmp(tDirMes.szRcvNode, szAt) )
									MAIL_queue(szAt, tDirMes.dwNumber);
							}
						}/*End WHILE*/
					}/*End WHILE*/
				}/*End IF*/
				fclose( fFwdSys );
			}/*End IF*/
		}
		else                           //------ MESSAGE PERSO ------
		{
			char szConnectedCall[16];

			/* Is the user connected ? */
			/* WARNING : NODE_searchUser is destructive ! */
			strcpy(szConnectedCall, tDirMes.szRecipient);
			if( NODE_searchUser(szConnectedCall, NODE_CHECKSSID_NO, tDirMes.szRoute) )
			{
				if( TOOLS_whatSsid(tDirMes.szRoute) == 0 )
					TOOLS_removeSsid(tDirMes.szRoute);	//Pour viter F5MZN-0, qui pose un pb de routage

				//Trouve. Ajouter le message dans la file d'attente.
				MAIL_queue(tDirMes.szRoute, tDirMes.dwNumber);
			}
			//L'utilisateur n'est pas connecte. Rechercher
			else if( USERS_getHomeQth(tDirMes.szRecipient, tDirMes.szRoute) )
			{
				//Trouve. Ajouter le message dans la file d'attente.
				//Pas de ping-pong ...
				if( strcmp(tDirMes.szRcvNode, tDirMes.szRoute) )
					MAIL_queue(tDirMes.szRoute, tDirMes.dwNumber);
			}
			else
			{
				tDirMes.szRoute[0] = SNULL;
			}
		}
	}/*End IF*/

	/* Ajouter la nouvelle structure DirMes */
	fDirMes = fopen(MAIL_DIRMES_FILE, "ab");

	if( ! fDirMes )	//Le fichier n'a pu etre ouvert
	{
		perror("fopen in MAIL_tmp2Msg (fDirMes)");
		return 0L;
	}

	/* Sauvegarder a la fin du fichier */
	fseek(fDirMes, 0L, SEEK_END);
	fwrite(&tDirMes, sizeof(DirMesStruct), 1, fDirMes);

	fclose(fDirMes);

	/* Ajouter le BID dans la base de donnees BID */
	MAIL_addBidToDB(tDirMes.szBid);

	/* Sauvegarder le numero du dernier message */
	MAIL_setLastNum(tDirMes.dwNumber);

	/* Effacer le fichier temporaire */
	sprintf(szFileName, "%sstream%02d.tmp", MAIL_PATH, StreamNum);
	unlink(szFileName);

	/* Avertir le destinataire qu'il a recu un message (s'il est connecte) */
	NODE_getNodeCall(0, 0, szNodeCall);
	nStream = NODE_searchUser(tDirMes.szRecipient, NODE_CHECKSSID_NO, szNodeCall);
	if( nStream && STREAMS_level[nStream] & LEVEL_user)
	{
		extern unsigned long COMMANDS_statut[MAX_STREAMS];
			
		if( ! (USERS_getFlags(nStream) & USERS_NOMAILBEEP) )
			BUFFERS_printBuff(nStream, OUT, "%c", BELL);
		MSG_send(nStream, MSG56);
		
		if( nStream && STREAMS_level[nStream] & LEVEL_user)
			COMMANDS_statut[nStream] |= COMMANDS_statusNewMail;		
	}

	return tDirMes.dwNumber;
}

/*------------------------------------------------------------------------
  ------ Saved the last current message number ---------------------------
  ------------------------------------------------------------------------ */
void MAIL_setLastNum(unsigned long dwNumber)
{
	FILE* fNumber;

	fNumber = fopen(MAIL_LASTNUMBER, "wb");

	if( ! fNumber )
	{
		perror("fopen in MAIL_setLastNum");
		return;
	}

	fwrite(&dwNumber, sizeof(dwNumber), 1, fNumber);

	fclose (fNumber);
}

/*------------------------------------------------------------------------
  ------ What is the last saved message number ? -------------------------
  ------------------------------------------------------------------------
  Return : last message number */
unsigned long MAIL_lastNum(void)
{
	FILE* fNumber;
	int Done = 0;
	unsigned long dwNumber;

	fNumber = fopen(MAIL_LASTNUMBER, "rb");

	if( ! fNumber )
	{
		perror("fopen in MAIL_lasNum ");
		return 0L;
	}

	Done = fread(&dwNumber, sizeof(dwNumber), 1, fNumber);
	fclose (fNumber);

	if( Done == 1 )
		return dwNumber;
	else
		return 0L;
}

/*---------------------------------------------------------------------------
  ------ Liste les messages -------------------------------------------------
  ---------------------------------------------------------------------------
  La fonction retourne le numero du dernier message liste, sauf si
  une recherche (areas, sender, subject ...) etait effectuee. Dans ce cas
  la fonction retourne 0L.
  Si le parametre dwToNumber est egal a 0L, la fonction liste tous les
  nouveaux messages a partir de dwFromNumber.
  StreamNum    : numero du stream sur lequel effectuer l'affichage
  pszArea      : indicatif ou aire a chercher le cas echant (commandes l>, lm, ln ...)
  pszSender    : indicatif de l'expediteur a chercher le cas echeant (commande l<)
  pszSubject   : partie du sujet a chercher le cas echant
  pszUserCall  : indicatif de l'utilisateur
  dwFromNumber : numero du message a partir duquel effectuer la liste ou 0L
  dwToNumber   : idem mais pour la fin
  nUserLevel   : level utilisateur - si egal a zero, une recherche sur une aire ne
                 retournera que les NOUVEAUX messages
  dwNtoList    : nombre de messages a liste ou 0L
*/
#pragma argsused
unsigned long MAIL_list(int StreamNum, char * pszArea, char * pszSender,
			char * pszSubject, char * pszUserCall,
			unsigned long dwFromNumber, unsigned long dwToNumber,
			int nUserLevel, unsigned long dwNtoList)
{
	long dwFilePos;
	FILE* fDirMes;
	char szUserCall[10];
	char szTitleLWR[61];
	DirMesStruct tDirMes;
	unsigned long dwLastListed;
	BYTE byDone = FALSE;

	/* Si on liste des nouveaux messages, charger dans dwLastListed le
       numero du dernier message liste par l'utilisateur ... */
	if( dwToNumber == 0L )
		dwLastListed = dwFromNumber;
	else
		dwLastListed = 0L;

	/* Pour la rechercher sur le sujet (le cas echeant) */
	strlwr(pszSubject);

	/* Indicatif de l'utilisateur (sans SSID) */
	strcpy(szUserCall, STREAMS_callsign[StreamNum]);
	TOOLS_removeSsid( szUserCall );

	/* Ouvrir DirMes */
	fDirMes = fopen(MAIL_DIRMES_FILE, "rb");

	if( ! fDirMes )	/* Le fichier n'a pu etre ouvert */
	{
		perror("fopen in MAIL_list");
		return 0L;
	}

	/* Placer le pointeur en fin de fichier */
	fseek(fDirMes, 0L, SEEK_END);
	dwFilePos = ftell( fDirMes );

	/* Lister les messages */
	for(;;)
	{
		/* Pointer sur le msg precedent */
		dwFilePos -= (long) sizeof( DirMesStruct );
		if( dwFilePos < 0 )
			break;	/* Fin de liste atteinte */
		fseek(fDirMes, dwFilePos, SEEK_SET);

		/* Lire la structure sur le disque */
		if( ! fread(&tDirMes, sizeof(DirMesStruct), 1, fDirMes) )
			break;	/* PB ... */

		/* Tous les entetes nouveaux ont-ils ete listes ? */
		if( dwFromNumber > tDirMes.dwNumber && dwNtoList == 0L )
			break;	/* Oui, alors c'est fini */

		/* Pour la recherche sur une partie du sujet (le cas echeant) */
		if( *pszSubject )
		{
			strcpy(szTitleLWR, tDirMes.szTitle);
			strlwr(szTitleLWR);
		}

		/* Faut-il afficher cet entete ? */
		if( (tDirMes.cType == 'B' || ! strcmp(szUserCall, tDirMes.szSender) ||
			! strcmp(szUserCall, tDirMes.szRecipient) || nUserLevel & LEVEL_sysopD )
			&& (dwToNumber == 0L || dwToNumber >= tDirMes.dwNumber)
			&&  
			/* Rechercher dans une aire ou recherche des nouveaux messages pour l'utilisateur*/
			(! *pszArea || ! strcmpi(pszArea, tDirMes.szRecipient))
			&&  
			/* Seulement les message emits par pszSender (commande l<) ? */
			(! *pszSender || ! strcmpi(pszSender, tDirMes.szSender))
			&&  
			/* Recherche sur une partie du sujet */
			(! *pszSubject || strstr(szTitleLWR, pszSubject))
			&&
			/* Si cUserLevel est a ZERO cela signifie qu'on recherche les
			   nouveaux messages pour l'utilisateur uniquement.*/
			(nUserLevel || tDirMes.cStatut == STATUT_N)
			&&
			/* Si le message est kille, ne pas l'afficher */
			(tDirMes.cStatut != STATUT_K || nUserLevel & LEVEL_sysopD )
			)
		{
			/* Le message peut-etre vu par l'utilisateur. Tester maintenant s'il
			   a precise des filtres */
			//A FAIRE ....

			/* Entete */
			if( ! byDone )
			{
				MSG_send(StreamNum, MSG49);
				byDone = TRUE;
			}

			/* Limiter la longueur du sujet a 48 caracteres (pour eviter les debordements) */
			TOOLS_maxLength(tDirMes.szTitle, 48);
			/* Limiter la longueur de la date (JJ-MMM) */
			tDirMes.szDate[6] = SNULL;
			BUFFERS_printBuff(StreamNum, OUT, "%6ld %c%c %-8s %-6s %-6s %s\n",
				tDirMes.dwNumber,
				tDirMes.cType,
				tDirMes.cStatut,
				tDirMes.szRecipient,
				tDirMes.szSender,
				tDirMes.szDate,
				tDirMes.szTitle);

			/* Reperer le numero du denier message liste */
			if( dwLastListed < tDirMes.dwNumber )
				dwLastListed = tDirMes.dwNumber;

			/* Decrementer le nombre de messages a lister, si la commande est une
               LL n*/
			if( dwNtoList > 0L )
				dwNtoList--;
		}
	}

	fclose (fDirMes);

	if( ! byDone )
		return 0L;	/* Aucun message liste */

	return dwLastListed;
}

/*---------------------------------------------------------------------------
  ------ Lire un message ----------------------------------------------------
  ---------------------------------------------------------------------------
  La fonction retourne TRUE si le message a pu etre lu */
int MAIL_read(int StreamNum, unsigned long dwNumber, char * pszUserCall, char cUserLevel)
{
	long  dwFilePos;
	char  szUserCall[10];
	char  szFileName[MAXPATH];
	char  szBuffer[256];
	FILE* fDirMes;
	FILE* fMsg;
	DirMesStruct	tDirMes;
	BYTE  byDone = FALSE;
	BYTE  byRetReceipt = FALSE;

	/* Enlever le SSID de l'utilisateur */
	TOOLS_maxLength(pszUserCall, 9);
	strcpy(szUserCall, pszUserCall);
	TOOLS_removeSsid(szUserCall);

	/* Ouvrir dirmes et chercher le message */
	fDirMes = fopen(MAIL_DIRMES_FILE, "r+b");
	if( ! fDirMes )
	{
		perror("fopen in MAIL_read (fDirMes)");
		return FALSE;
	}

	/* Rechercher le message dans dirmes */
	dwFilePos = MAIL_searchHeader(fDirMes, dwNumber, &tDirMes);

	/* Message atteint ? */
	if( dwFilePos != -1L )
	{
		/* Les tests suivants sont volontairement decomposes ...*/

		/* Droit d'acces */
		if( cUserLevel & LEVEL_sysopV )
		{
			/* Le sysop a acces a tout .. s'il est declare ! */
			byDone = TRUE;

		}
		else if( tDirMes.cStatut == STATUT_K )
		{
			/* C'est un message kille, pas d'acces possible */
			byDone = FALSE;
		}
		else if( tDirMes.cType == TYPE_B )
		{
			/* Si c'est un bulletin, OK pour tout le monde */
			byDone = TRUE;
		}
		else if( ! strcmp(tDirMes.szRecipient, szUserCall) || ! strcmp(tDirMes.szSender, szUserCall) )
		{
			/* Message perso */
			byDone = TRUE;
		}
		else
		{
			/* Tout autre cas ... */
			byDone = FALSE;
		}
	}

	/* Autorise a lire le message ? */
	if( byDone == FALSE )
	{
		/* Non */
		MSG_send(StreamNum, MSG50);
		fclose(fDirMes);
		return FALSE;
	}

	/* Gerer le flag return receipt */
	/* Modifier, sur un message PERSO, le Statut du mail en READ s'il etait en N
	   et que le message est bien lu par le destinataire ... */
	if( tDirMes.cStatut == STATUT_N && ! strcmp(szUserCall, tDirMes.szRecipient) )
	{
		/* Flag Return Receipt */
		byRetReceipt = tDirMes.byRetReceipt;
		tDirMes.byRetReceipt = FALSE;

		tDirMes.cStatut = STATUT_R;

		/* Sauvegarder */
		fseek(fDirMes, dwFilePos, SEEK_SET);
		fwrite(&tDirMes, sizeof(DirMesStruct), 1, fDirMes);
	}

	/* Envoyer l'entete du message a l'utilisateur */
	BUFFERS_printBuff(StreamNum, OUT, "To      : %s\n", tDirMes.szRecipient);
	BUFFERS_printBuff(StreamNum, OUT, "From    : %s\n", tDirMes.szSender);
	BUFFERS_printBuff(StreamNum, OUT, "Date    : %s at %02d:%02dZ\n", tDirMes.szDate,
		tDirMes.byTi_Hour,
		tDirMes.byTi_Min);
	BUFFERS_printBuff(StreamNum, OUT, "Subject : %s\n", tDirMes.szTitle);

	/* Envoyer le contenu du message */
	sprintf(szFileName, "%sm%07ld.msg", MAIL_PATH, tDirMes.dwNumber);
	fMsg = fopen(szFileName, "rt");
	if( ! fMsg )	
	{
		perror("fopen in MAIL_read (fMsg)");
		return 0L;
	}

	while( fgets(szBuffer, 255, fMsg) )
		BUFFERS_addBuff(StreamNum, szBuffer, OUT);

	/* Fermer les fichiers */
	fclose( fDirMes );
	fclose( fMsg );

	/* Generer un Return Receipt si necessaire */
	if( byRetReceipt )
	{
		char szDate[20];
		char szTime[20];
		char szNodeCall[20];

		/* Creer le message */
		sprintf(szBuffer, "%s @ %s", tDirMes.szSender, tDirMes.szStartNode);
		MAIL_rcvRecip(0, "SP", szBuffer, FALSE, FALSE);

		/* Envoyer le sujet */
		sprintf(szBuffer, "Re: %s", tDirMes.szTitle);
		TOOLS_maxLength(szBuffer, 60);

		MAIL_addSubject2Tmp(0, szBuffer, TOOLS_whatDate(szDate),
			TOOLS_whatTime(szTime),
			NODE_getNodeCall(0, 0, szNodeCall),
			"");

		/* Envoyer le corps du message */
		sprintf(szBuffer, "Return receipt from delivering node. Message read by %s.", 
			tDirMes.szRecipient);
		MAIL_addText2Tmp(0, szBuffer);

		/* Envoyer le message */
		MAIL_tmp2Msg(0);
		MAIL_fwd();

	}

	return TRUE;
}

/*---------------------------------------------------------------------------
  ------ Killer un message --------------------------------------------------
  ---------------------------------------------------------------------------
  La fonction retourne TRUE si le message a pu etre efface
*/
int MAIL_kill(int StreamNum, unsigned long dwNumber, char * pszUserCall, char cUserLevel)
{
	long		dwFilePos;
	char		szUserCall[10];
	FILE	       *fDirMes;
	DirMesStruct	tDirMes;
	BYTE		byDone = FALSE;

	/* Enlever le SSID de l'utilisateur */
	TOOLS_maxLength(pszUserCall, 9);
	strcpy(szUserCall, pszUserCall);
	TOOLS_removeSsid(szUserCall);

	/* Ouvrir dirmes et chercher le message */
	fDirMes = fopen(MAIL_DIRMES_FILE, "r+b");

	if( ! fDirMes )		/* Le fichier n'a pu etre ouvert */
	{
		perror("fopen in MAIL_kill (fDirMes)");
		return FALSE;
	}

	dwFilePos = MAIL_searchHeader(fDirMes, dwNumber, &tDirMes);

	/* Message atteint ? */
	if( dwFilePos != -1L )
	{
		/* Les tests suivants sont volontairement decomposes ainsi */
		/* Droit d'acces */
		if( tDirMes.cStatut == STATUT_K )
		{
			/* C'est un message deja kille, pas d'acces possible */
			byDone = FALSE;
		}
		else if( cUserLevel & LEVEL_sysopV )
		{
			/* Le sysop a acces a tout */
			byDone = TRUE;
		}
		else if( ! strcmp(tDirMes.szRecipient, szUserCall) || ! strcmp(tDirMes.szSender, szUserCall) )
		{
			/* Message adresse ou ecrit pour/par l'utilisateur */
			byDone = TRUE;
		}
		else
		{
			/* Tout autre cas ... */
			byDone = FALSE;
		}/*End IF*/
	}/*End IF*/


	if( byDone == TRUE )
	{
		/* Ok, il faut killer le message */
		tDirMes.cStatut = STATUT_K;

		/* Sauvegarder l'entete modifie */
		fseek(fDirMes, dwFilePos, SEEK_SET);
		fwrite(&tDirMes, sizeof(DirMesStruct), 1, fDirMes);

		/* Confirmer a l'utilisateur */
		MSG_send(StreamNum, MSG51);
	}
	else
	{
		/* Impossible d'effacer le message */
		MSG_send(StreamNum, MSG52);
	}/*End IF*/

	fclose( fDirMes );

	/* Enlever le message de la file d'attente */
	MAIL_deQueue("*", dwNumber);

	return byDone;
}

//---------------------------------------------------------------------------
//------ Rechercher un header dans DirMes -----------------------------------
//---------------------------------------------------------------------------
//La fonction retourne la position du header, et -1 si le header n'a pas
//ete trouve
long MAIL_searchHeader(FILE * fDirMes, unsigned long dwNumber,
		       DirMesStruct * tDirMes)
{
  long dwFilePos;

 //Placer le pointeur en fin de fichier
  fseek(fDirMes, 0L, SEEK_END);
  dwFilePos = ftell( fDirMes );

  //parcourir dirmes.bin
  for(;;)
  {
    //Pointer sur le msg precedent
    dwFilePos -= (long) sizeof( DirMesStruct );
    if( dwFilePos < 0 )
      break;	//Fin de liste atteinte
    fseek(fDirMes, dwFilePos, SEEK_SET);

    //Lire la structure sur le disque
    if( ! fread(tDirMes, sizeof(DirMesStruct), 1, fDirMes) )
      break;	//PB ...

    //Message atteint ?
    if( tDirMes->dwNumber == dwNumber )
      return dwFilePos;
  }/*End LOOP*/

  return -1L;
}

/*--------------------------------------------------------------------------
  ------ Get new message count for a user ----------------------------------
  --------------------------------------------------------------------------*/
unsigned long MAIL_isNew(char * pszUserCall)
{
	FILE *	fDirMes;
	char	szUserCall[10];
	unsigned long	dwUnList = 0L;
	DirMesStruct	tDirMes;

	/* no SSID */
	TOOLS_maxLength(pszUserCall, 9);
	strcpy(szUserCall, pszUserCall);
	TOOLS_removeSsid(szUserCall);

	fDirMes = fopen(MAIL_DIRMES_FILE, "r+b");

	if( ! fDirMes )
	{
		perror("fopen in MAIL_isNew");
		return 0L;
	}

	/* Scan dirmes.bin looking for unread mails ... */
	for(;;)
	{
		if( ! fread(&tDirMes, sizeof(DirMesStruct), 1, fDirMes) )
			break;	/* EOF */

		if( ! strcmp(tDirMes.szRecipient, szUserCall) && tDirMes.cStatut == STATUT_N )
			dwUnList++;
	}

	/* Update COMMANDS_statusNewMail flags if any */
	if( dwUnList )
	{
		extern unsigned long COMMANDS_statut[MAX_STREAMS];
		char szNodeCall[16];
		int nStream;

		NODE_getNodeCall(0, 0, szNodeCall);
		nStream = NODE_searchUser(szUserCall, NODE_CHECKSSID_NO, szNodeCall);

		if( nStream && STREAMS_level[nStream] & LEVEL_user)
			COMMANDS_statut[nStream] |= COMMANDS_statusNewMail;
	}

	fclose(fDirMes);
	return dwUnList;
}

//---------------------------------------------------------------------------
//------ Ajouter un fwd a la file d'attente ---------------------------------
//---------------------------------------------------------------------------
//La fonction retourne TRUE si succes
int MAIL_queue(char * szRoute, unsigned long dwNumber)
{
  QueueStruct	tQueue;
  FILE	       *fQueue;
  FILE	       *fFwdSys;
  char		szMyNodeCall[10];
  char		szAdjacent[10];
  char		szAt[10];
  char		szSearchFor[20];
  char		szLine[256];
  char		szBuffer[256];

  //Inutile de placer dans la file d'attente si le message est pour "moi"
  NODE_getNodeCall(0, 0, szMyNodeCall);
  if( ! strcmp(szRoute, szMyNodeCall) )
    return FALSE;

  //De meme, ne pas placer dans la file d'attente si szRoute est NULL
  if( ! *szRoute )
    return FALSE;

  //Verifier que ce message n'est pas deja dans la file d'attente
  if( MAIL_isQueued(szRoute, dwNumber) )
    return FALSE;

  //Verifier maintenant s'il ne faut pas rerouter le mail ...
  strcpy(szAdjacent, szRoute);

  //Prepare la chaine qu'il faut rechercher
  sprintf(szSearchFor, "@%s", szRoute);

  //Ouvrir le fichier FORWARD.SYS
  fFwdSys = fopen(MAIL_FORWARDSYS_FILE, "rt");

  if( fFwdSys )	//Seulement si le fichier a pu etre ouvert
  {
    while( fgets(szBuffer, 255, fFwdSys) )
    {
      //S'affranchir de la mise en page
      sscanf(szBuffer, "%s", szLine);

      if( szLine[0] == ':' ) //Un nouvel adjacent ?
      {
	//Eh oui ...
	TOOLS_maxLength(szLine, 11);
	strcpy(szAt, szLine + 1);
	strupr(szAt);

	//Rechercher maintenant si le routage est specifie
	while( fgets(szBuffer, 255, fFwdSys) )
	{
	  sscanf(szBuffer, "%s", szLine);
	  strupr(szLine);

	  //Fin atteinte pour cet adjacent ?
	  if( ! strcmp(szLine, "END") )
	    break;

	  //Concordance avec l'indicatif du fichier FORWARD.SYS ?
	  if( ! strcmp(szLine, szSearchFor) )
	    strcpy(szAdjacent, szAt);
	}/*End WHILE*/
      }/*End IF*/
    }/*End WHILE*/

    /* Fermer le fichier */
    fclose( fFwdSys );
  }/*End IF*/

  /* Copier les datas dans la structure tQueue */
  strcpy(tQueue.szRoute, szAdjacent);
  tQueue.dwNumber = dwNumber;
  tQueue.nNow     = MAIL_FWD_LATER;

  //Ouvrir le fichier
  fQueue = fopen(MAIL_QUEUE_FILE, "ab");

  if( ! fQueue )		//Le fichier n'a pas pu tre ouvert
  {
    perror("fopen in MAIL_queue (fQueue)");
    return FALSE;
  }

  //Sauvegarder a la fin du fichier
  fseek(fQueue, 0L, SEEK_END);
  fwrite(&tQueue, sizeof(QueueStruct), 1, fQueue);

  fclose( fQueue );

  return TRUE;
}

//---------------------------------------------------------------------------
//------ Liste les messages de la file d'attente ----------------------------
//---------------------------------------------------------------------------
//Si ToNode est vide, la fonction renvoie tous les messages de la
//file d'attente
void MAIL_viewQueue(int StreamNum, char * ToNode)
{
  FILE 	       *fQueue;
  FILE	       *fDirMes;
  int		nDone = FALSE;
  QueueStruct	tQueue;
  DirMesStruct	tDirMes;

  strupr (ToNode);

  fQueue = fopen(MAIL_QUEUE_FILE, "rb");

  if( ! fQueue )		//Le fichier n'a pas pu tre ouvert
  {
    perror("fopen in MAIL_viewQueue (fQueue)");
    return;
  }

  //Ouvrir dirmes
  fDirMes = fopen(MAIL_DIRMES_FILE, "r+b");

  if( ! fDirMes )	//Le fichier n'a pu tre ouvert
  {
    perror("fopen in MAIL_viewQueue (fDirMes)");
    fclose (fQueue);
    return;
  }


  while( fread(&tQueue, sizeof(QueueStruct), 1, fQueue) )
  {
    if( ToNode[0] == SNULL || ! strcmp(ToNode, tQueue.szRoute) )
    {
      //Afficher l'entete pour le premier message
      if( ! nDone )
      {
	nDone = TRUE;
	BUFFERS_addBuff(StreamNum, "  Msg #   Fwd to     Date        Time\n", OUT);
	BUFFERS_addBuff(StreamNum, "---------------------------------------\n", OUT);
      }/*End IF*/

      MAIL_searchHeader(fDirMes, tQueue.dwNumber, &tDirMes);

      BUFFERS_printBuff(StreamNum, OUT, "%7ld   %-10s %s %02d:%02dz\n",
		      tQueue.dwNumber,
		      tQueue.szRoute,
		      tDirMes.szDate,
		      tDirMes.byTi_Hour,
		      tDirMes.byTi_Min);
    }/*End IF*/
  }/*End WHILE*/

  if( ! nDone )
    BUFFERS_addBuff(StreamNum, "No message queued.\n", OUT);

  fclose (fQueue);
  fclose (fDirMes);
}

/*---------------------------------------------------------------------------
  ------ Dequeue a mail from the forwarding queue ---------------------------
  ---------------------------------------------------------------------------
  Return TRUE si OK
  if szRoute == '*', all queued mail #dwnumber are removed 
  if dwNumber == ~0L (0xFFFFFFFF), all queued mail @szRoute are removed */
int MAIL_deQueue(char * szRoute, unsigned long dwNumber)
{
	FILE* fQueue;
	FILE* fBak;
	QueueStruct tQueue;
	int done = FALSE;

	strupr(szRoute);

	/* Make a backup */
	TOOLS_makeBak(MAIL_QUEUE_FILE);

	fBak = fopen(MAIL_QUEUE_BAKFILE, "rb");
	if( ! fBak )
	{
		perror("fopen in MAIL_deQueue (fBak)");
		return FALSE;
	}

	fQueue = fopen(MAIL_QUEUE_FILE, "wb");
	if( ! fQueue )
	{
		perror("fopen in MAIL_deQueue (fQueue)");
		fclose(fBak);
		return FALSE;
	}

	while( fread(&tQueue, sizeof(QueueStruct), 1, fBak) )
	{
		if( (! strcmp(szRoute, tQueue.szRoute) || szRoute[0] == '*') && (dwNumber == ~0L || 
			dwNumber == tQueue.dwNumber) )
			done = TRUE;	/* remove this one */
		else
			fwrite(&tQueue, sizeof(QueueStruct), 1, fQueue);
	}

	fclose(fBak);
	fclose(fQueue);

	return done;
}

//---------------------------------------------------------------------------
//------ Verifie si un message est dans la file d'attente -------------------
//---------------------------------------------------------------------------
//La fonction retourne TRUE si OUI
int MAIL_isQueued(char * szRoute, unsigned long dwNumber)
{
  FILE 	       *fQueue;
  QueueStruct	tQueue;
  int		nDone = FALSE;

  strupr (szRoute);

  fQueue = fopen(MAIL_QUEUE_FILE, "rb");

  if( ! fQueue )	//Le fichier n'a pas pu tre ouvert
  {
    perror("fopen in MAIL_isQueued");
    return FALSE;
  }

  while( fread(&tQueue, sizeof(QueueStruct), 1, fQueue) )
  {
    //Concordance trouvee
    if( dwNumber == tQueue.dwNumber && ! strcmp(szRoute, tQueue.szRoute) )
    {
	nDone = TRUE;
	break;
    }
  }/*End WHILE*/

  fclose (fQueue);

  return nDone;
}

//---------------------------------------------------------------------------
//------ Lire un champ dans la queue ----------------------------------------
//---------------------------------------------------------------------------
//La fonction retourne TRUE si le champ a pu etre lu
static int MAIL_readQueue(int nPos, QueueStruct* queue)
{
	FILE *fQueue;
	long  lFilePos;

	fQueue = fopen(MAIL_QUEUE_FILE, "rb");
	if( ! fQueue )
		return FALSE;

	/* L'element existe t-il ? */
	lFilePos = (long) nPos * (long) sizeof(QueueStruct);
	fseek(fQueue, 0L, SEEK_END);
	if( lFilePos >= ftell(fQueue) )
	{
		fclose(fQueue);
		return FALSE;	/* EOF */
	}

	/* Lire */
	fseek(fQueue, lFilePos, SEEK_SET);
	fread(queue, sizeof(QueueStruct), 1, fQueue);
	fclose(fQueue);
	return TRUE;
}

//---------------------------------------------------------------------------
//------ Ecrire un champ dans la queue --------------------------------------
//---------------------------------------------------------------------------
static void MAIL_writeQueue(int nPos, QueueStruct* queue)
{
	FILE *fQueue;
	long  lFilePos;

	fQueue = fopen(MAIL_QUEUE_FILE, "r+b");
	if( ! fQueue )
		return;

	/* Ecrire */
	lFilePos = (long) nPos * (long) sizeof(QueueStruct);
	fseek(fQueue, lFilePos, SEEK_CUR);
	fread(queue, sizeof(QueueStruct), 1, fQueue);
	fclose(fQueue);
}

//---------------------------------------------------------------------------
//------ Verifie si le message existe ---------------------------------------
//---------------------------------------------------------------------------
//La fonction retourne TRUE si OUI
int MAIL_isMailExist(unsigned long dwNumber)
{
  FILE 	       *fDirMes;
  DirMesStruct	tDirMes;
  int		nDone;

  //Ouvrir dirmes et chercher le message
  fDirMes = fopen(MAIL_DIRMES_FILE, "r+b");

  if( ! fDirMes )	//Le fichier n'a pas pu tre ouvert
  {
    perror("fopen in MAIL_isMailExist");
    return FALSE;
  }

  if( MAIL_searchHeader(fDirMes, dwNumber, &tDirMes) != -1L )
	nDone = TRUE;
  else
	nDone = FALSE;

  fclose (fDirMes);
  return nDone;
}

//---------------------------------------------------------------------------
//------ Changer le statut d'un message de la file d'attente ----------------
//---------------------------------------------------------------------------
//Valeurs pour nCmd :
//	ONLYTHISONE	Changer le statut du message #dwNumber @szRoute
//	ALLQUEUED	Changer le statut de tous les messages
//	ONLYTHISROUTE	Changer le statut des messages @szRoute
void MAIL_changeQueueStat(char * szRoute, unsigned long dwNumber, int nNewStat, int nCmd)
{
  FILE 	       *fQueue;
  long		lSeekPos = 0L;
  QueueStruct	tQueue;
  int		nOld;

  strupr (szRoute);

  fQueue = fopen(MAIL_QUEUE_FILE, "r+b");

  if( ! fQueue )	//Le fichier n'a pas pu tre ouvert
  {
    perror("fopen in MAIL_changeQueueStat");
    return;
  }

  //Parcourir le fichier QUEUE.BIN
  while( fread(&tQueue, sizeof(QueueStruct), 1, fQueue) )
  {
    nOld = tQueue.nNow;	//Pour detecter une eventuelle modification

    switch( nCmd )
    {
      case ONLYTHISONE :
	if( tQueue.dwNumber == dwNumber && ! strcmp(tQueue.szRoute, szRoute) )
	  tQueue.nNow = nNewStat;
	break;

      case ALLQUEUED :
	tQueue.nNow = nNewStat;
	break;

      case ONLYTHISROUTE :
	if( ! strcmp(tQueue.szRoute, szRoute) )
	  tQueue.nNow = nNewStat;
	break;

      default :
	break;
    }/*End SWITCH*/

    //Sauvegarder l'entete (si necessaire)
    if( tQueue.nNow != nOld )
    {
      //Repositionner le pointeur dans le fichier et ecrire
      fseek(fQueue, lSeekPos, SEEK_SET);
      fwrite(&tQueue, sizeof(QueueStruct), 1, fQueue);
    }

    lSeekPos = ftell (fQueue);

  }/*End WHILE*/

  fclose (fQueue);
}

//---------------------------------------------------------------------------
//------ Lancer les forwards ------------------------------------------------
//---------------------------------------------------------------------------
//Il est possible de specifier une route, ou un numero de message, ou
//les deux.
//Si aucun n'est specifie (szRoute="" et dwnumber=0), la fonction lance
//tous les forwards
void MAIL_fwd(char * pszRoute, unsigned long dwNumber, int StreamNum)
{
	FILE 	       *fDirMes;
	DirMesStruct	tDirMes;
	QueueStruct		tQueue;
	int		nOkRoute;
	int		nOkNumber;
	char	szMyNodeCall[10];
	char	szTime[10];
	char	szRoute[16];
	int		nQueuePos = 0;

	strcpy(szRoute, pszRoute);
	strupr (szRoute);
	NODE_getNodeCall(0, 0, szMyNodeCall);

	/* Ouvrir dirmes */
	fDirMes = fopen(MAIL_DIRMES_FILE, "r+b");

	if( ! fDirMes )	/* Le fichier n'a pas pu etre ouvert */
	{
		perror("fopen in MAIL_isMailExist");
		return;
	}

	while( MAIL_readQueue(nQueuePos, &tQueue) == TRUE )
	{
		/* Tenter de lancer le fwd pour ce message */
		nOkRoute = nOkNumber = FALSE;

		if( ! szRoute[0] )	/* Teste de la route */
			nOkRoute = TRUE;
		else if( ! strcmp(tQueue.szRoute, szRoute) )
			nOkRoute = TRUE;

		if( ! dwNumber )	/* Test sur le numero */
			nOkNumber = TRUE;
		else if( tQueue.dwNumber == dwNumber )
			nOkNumber = TRUE;

		if( nOkRoute && nOkNumber )
		{
			int	nStreamOfNode;
			int	nNodePos;

			/* Rechercher le port sur lequel est connecte le node */
			if( NODE_isNodeConnected(tQueue.szRoute, &nStreamOfNode, &nNodePos) )
			{
				/* Trouve - Verifier s'il n'y a pas deja des fwd vers ce cluster */
				if( ! MAIL_lFwdMsgNumber[nStreamOfNode] )
				{
					if( MAIL_searchHeader(fDirMes, tQueue.dwNumber, &tDirMes) != -1L )
					{
						/* Pas de ping-pong ! De meme, ne pas forwarder deux fois le meme 
						   message PERSO */
						if( strcmp(tQueue.szRoute, tDirMes.szRcvNode) &&
						    (tDirMes.cType != 'P' || tDirMes.cStatut == 'N') )
						{
							/* Quel est l'indicatif du cluster adjacent sur ce stream ? /*/
							NODE_getNodeCall(nStreamOfNode, 0, tQueue.szRoute);

							BUFFERS_printBuff(StreamNum, OUT, "Starting forwarding mail #%ld to %s.\n",
								tQueue.dwNumber,
								tQueue.szRoute);

							/* Reecrire l'indicatif de l'adjacent dans le fichier, car il
							   est peut-etre different de clui qui etait precise dans le
							   le fichier */
							MAIL_writeQueue(nQueuePos, &tQueue);

							/* Lancer le forward */
							sprintf(szTime, "%02d%02d", tDirMes.byTi_Hour, tDirMes.byTi_Min);
							MAIL_lFwdMsgNumber[nStreamOfNode] = tQueue.dwNumber;
							MAIL_nNumOfLines  [nStreamOfNode] = 5;
							MAIL_nCurrentLine [nStreamOfNode] = 0;
							MAIL_nTimeOut     [nStreamOfNode] = 240;

							PROTOCOL_sendSubject(nStreamOfNode, tQueue.szRoute,
								szMyNodeCall, tDirMes.szRecipient,
								tDirMes.szSender, tDirMes.szDate,
								szTime, tDirMes.cType,
								tDirMes.szTitle,
								5,
								tDirMes.szStartNode,
								tDirMes.byRetReceipt);
						}
						else
						{
							/* Ping-pong : enlever le message de la file d'attente */
							MAIL_deQueue(tQueue.szRoute, tQueue.dwNumber);
							break;	/* Oblige de faire un break a ce moment la.
									   Car on modifie le fichier QUEUE.BIN */
						}/*End IF*/
					}
					else
					{
							/* Le message n'existe plus - l'enlever de la file d'attente */
							MAIL_deQueue(tQueue.szRoute, tQueue.dwNumber);
							break;
					}/*End IF*/
				}/*End IF*/
			}/*End IF*/
		}/*End IF*/

		/* Position courante dans le fichier de queue */
		nQueuePos++;

	}/*End WHILE*/

  fclose(fDirMes);
}

//---------------------------------------------------------------------------
//------ Lancer tous les forwards -------------------------------------------
//---------------------------------------------------------------------------
void MAIL_fwd(void)
{
  MAIL_fwd("", 0, BUFFER_SCREEN1);
}

//---------------------------------------------------------------------------
//------ Lancer les forward vers des utilisateurs ---------------------------
//---------------------------------------------------------------------------
//Cette fonction est appelee lorsqu'un nouvel utilisateur se connecte sur
//un cluster du reseau. La fonction recherche tout d'abord si des messages
//non forwardes et non lus existent pour cet utilisateur.
//Si c'est le cas, il faut interroger la file d'attente de forward pour
//s'assurer que ce message n'est pas deja en attente pour un autre forward.
//Si ce message est deja en attente, virrer et remplacer par celui ci.
void MAIL_fwd2User(int StreamNum, char * szUser, int nIsInitDone)
{
  char		szUserCall[10];
  char		szAdjacent[10];
  FILE	       *fDirMes;
  DirMesStruct	tDirMes;
  int		index;

  //Virrer le SSID de l'utilisateur
  strcpy(szUserCall, szUser);
  TOOLS_removeSsid(szUserCall);

  //Indicatif de l'adjacent sur ce port
  NODE_getNodeCall(StreamNum, 0, szAdjacent);

  //Ouvrir DirMes.sys
  //Ajouter la nouvelle structure DirMes
  fDirMes = fopen(MAIL_DIRMES_FILE, "rb");

  if( ! fDirMes )	//Le fichier n'a pu tre ouvert
  {
    perror("fopen in MAIL_fwd2User (fDirMes)");
    return;
  }

  while( fread(&tDirMes, sizeof(DirMesStruct), 1, fDirMes) )
  {
    if(   tDirMes.cType   == TYPE_P   && 		/*Message perso*/
	  tDirMes.cStatut == STATUT_N &&		/*Non lu, non forwarde*/
	! strcmp(tDirMes.szRecipient, szUserCall) )	/*Indicatif OK*/
    {
      //Message en attente trouve
      //On ne fait rien si ce message est deja en cours de routage qq part
      for(index = 1; index < 65; index++)
      {
	if( MAIL_lFwdMsgNumber[index] == tDirMes.dwNumber )
	  break;
      }/*End FOR*/

      if( index == 65 )
      {
	MAIL_deQueue("*", tDirMes.dwNumber);
	MAIL_queue(szAdjacent, tDirMes.dwNumber);
	if( nIsInitDone == PROTOCOL_INIT_DONE )
		MAIL_fwd(szAdjacent, tDirMes.dwNumber, BUFFER_SCREEN1);
      }/*End IF*/
    }
  }/*End WHILE*/

  fclose (fDirMes);
}

/*---------------------------------------------------------------------------
  ------ Envoyer un bloc de lignes au cluster -------------------------------
  ---------------------------------------------------------------------------
*/
void MAIL_sendNextBloc(int StreamNum, char * ToNode, char * FmNode, unsigned long dwMesNum)
{
	FILE *fMsg;
	char szFileName[MAXPATH];
	char szBuffer[256];
	int	 index;

	MAIL_nTimeOut[StreamNum] = 240;
	
	/* Envoyer le contenu du message */
	sprintf(szFileName, "%sm%07ld.msg", MAIL_PATH, MAIL_lFwdMsgNumber[StreamNum]);
	fMsg = fopen(szFileName, "rt");
	
	if( ! fMsg ) /* Le fichier n'a pu etre ouvert */
	{
		perror("fopen in MAIL_sendNextBloc");
		return;
	}
	
	/* Rechercher la ligne */
	for(index = 0; index < MAIL_nCurrentLine[StreamNum]; index++)
	{
		if( ! fgets(szBuffer, 80, fMsg) ) /* limite a 80 octets : voir plus loin */
		{
			/* EOF - envoyer le protocole "completetext */
			PROTOCOL_sendCompleteText(StreamNum, FmNode, ToNode, dwMesNum);
			fclose (fMsg);
			return;
		}
	}/*End FOR*/

	/* Envoyer le bloc de ligne */
	for(index = 0; index < MAIL_nNumOfLines[StreamNum]; index++)
	{
		/* ATTENTION : pas plus de 80 caracteres ici, compte tenu de la
		   limitation du protocole de pavillon */

		if( ! fgets(szBuffer, 80, fMsg) )
		{
			/* EOF - envoyer le protocole "completetext */
			PROTOCOL_sendCompleteText(StreamNum, FmNode, ToNode, dwMesNum);
			fclose (fMsg);
			return;
		}
		else
		{
			TOOLS_removeNR (szBuffer);
			PROTOCOL_sendText(StreamNum, FmNode, ToNode, dwMesNum, szBuffer);
			MAIL_nCurrentLine[StreamNum]++;
		}
	}/*End FOR*/

	/* Fermer les fichiers */
	fclose( fMsg );
}

//---------------------------------------------------------------------------
//------ Changer le statut d'un mail ----------------------------------------
//---------------------------------------------------------------------------
//Retourne TRUE si succes
int MAIL_changeStatut(unsigned long dwNumber, char cNewStatut)
{
  FILE 	       *fDirMes;
  long		lFilePos;
  DirMesStruct	tDirMes;

  //Ouvrir dirmes et chercher le message
  fDirMes = fopen(MAIL_DIRMES_FILE, "r+b");

  if( ! fDirMes )	//Le fichier n'a pu tre ouvert
  {
    perror("fopen in MAIL_read (fDirMes)");
    return FALSE;
  }

  //Rechercher le message dans dirmes
  lFilePos = MAIL_searchHeader(fDirMes, dwNumber, &tDirMes);

  if( lFilePos == -1L )
  {
    //Numero non trouve
    fclose (fDirMes);
    return FALSE;
  }

  //Enregistrer le nouveau statut
  fseek(fDirMes, lFilePos, SEEK_SET);
  tDirMes.cStatut = cNewStatut;
  fwrite(&tDirMes, sizeof(DirMesStruct), 1, fDirMes);

  fclose (fDirMes);

  return TRUE;
}

//-------------------------------------------------------------------------
//------ Ajouter le sujet a un mail et les datas concernant le mail -------
//-------------------------------------------------------------------------
//La fonction retourne TRUE si succes
int MAIL_addSubject2Tmp(int StreamNum, char * szSubject, char * szDate, char * szTime, char * szStartNode, char * szAdjacentNode)
{
  char	szFileName[MAXPATH];
  FILE *fPtr;

  //Ouvrir le fichier temporaire
  sprintf(szFileName, "%sstream%02d.tmp", MAIL_PATH, StreamNum);
  fPtr = fopen(szFileName, "a+t");
  if( ! fPtr )
  {
    perror("fopen in MAIL_addSubject2Tmp");
    return FALSE;
  }/*End IF*/

  //Enregistrer le sujet dans le msg temporaire
  fprintf(fPtr, "%s\n", szSubject);

  //Enregistrer les renseignements concernant le message
  //Format : "F: 10-jan-1996 1018 F5AAA-3 F6BBB-6 0/1"
  //             date        heure PC-origine  PC-adjacent Dupe-Flag
  szTime[4] = SNULL;	//Virrer le Z a la fin de l'heure (si present)
  fprintf(fPtr, "F: %s %s %s %s\n", szDate,
				    szTime,
				    szStartNode,
				    szAdjacentNode);
  //Fermer le fichier temporaire
  fclose (fPtr);

  return TRUE;
}

//-------------------------------------------------------------------------
//------ Ajouter une ligne de texte dans le fichier de mail temporaire-----
//-------------------------------------------------------------------------
//La fonction retourne TRUE si succes
int MAIL_addText2Tmp(int StreamNum, char * szText)
{
  char	szFileName[MAXPATH];
  FILE *fPtr;

  //Ouvrir le fichier temporaire
  sprintf(szFileName, "%sstream%02d.tmp", MAIL_PATH, StreamNum);
  fPtr = fopen(szFileName, "a+t");
  if( ! fPtr )
  {
    perror("fopen in MAIL_addText2Tmp");
    return FALSE;
  }/*End IF*/

  //Enregistrer le sujet dans le msg temporaire
  fprintf(fPtr, "%s\n", szText);

  //Fermer le fichier temporaire
  fclose (fPtr);

  return TRUE;
}

/*-------------------------------------------------------------------------
  ------ Gestion des doubles dans les messages ----------------------------
  -------------------------------------------------------------------------
  Retourne TRUE si le message est un DUPE                                  */
int MAIL_isDupe(char * pszToStn, char * pszFromStn, char * pszSubject, char * pszDate, char * pszTime)
{
	extern long PARAMS_lMailReject;

	long   	     dwFilePos;
	FILE * 	     fDirMes;
	DirMesStruct tDirMes;
	char  	     szDate[16];
	char	     szBuffer1[256];
	char	     szBuffer2[256];	
	int			 nIsDupe = FALSE;

	BYTE byTi_Min  = atoi(pszTime) % 100;
	BYTE byTi_Hour = atoi(pszTime) / 100;

	unsigned long lCurrentDateTime;
	unsigned long lMailDateTime;
	
	/* Enlever le zero des dizaines sur la date (jour) si besoin */
	TOOLS_maxLength(pszDate, 11);
	strcpy(szDate, pszDate);
	if( szDate[0] == '0' )
		szDate[0] = ' ';

	/* Verifier l'age du message : s'il est trop vieux, il faut le rejeter */
	lCurrentDateTime = TOOLS_whatDateTime();
	lMailDateTime    = TOOLS_dateTime_Str2Long(pszDate, pszTime);

	if( PARAMS_lMailReject && TOOLS_diffDateTime(lCurrentDateTime, lMailDateTime) > (double) PARAMS_lMailReject )
		return TRUE;	/* Message trop vieux */

	/* Ouvrir DirMes */
	fDirMes = fopen(MAIL_DIRMES_FILE, "rb");

	if( ! fDirMes )	/* Le fichier n'a pu etre ouvert */
	{
		perror("fopen in MAIL_isDupe");
		return FALSE;
	}

	/* Placer le pointeur en fin de fichier */
	fseek(fDirMes, 0L, SEEK_END);
	dwFilePos = ftell(fDirMes);

	/* Lister les messages */
	TOOLS_removeNonAscii(pszSubject, szBuffer1);
	for(;;)
	{
		/* Pointer sur le msg precedent */
		dwFilePos -= (long) sizeof( DirMesStruct );
		if( dwFilePos < 0 )
			break;	/* Fin de liste atteinte */
		fseek(fDirMes, dwFilePos, SEEK_SET);

		/* Lire la structure sur le disque */
		if( ! fread(&tDirMes, sizeof(DirMesStruct), 1, fDirMes) )
			break;	/* PB ... */
			
		/* Enlever le 0 sur les dizaines du jour (si besoin) */
		if( tDirMes.szDate[0] == '0' )
			tDirMes.szDate[0] = ' ';

		/* Comparer ... */
		TOOLS_removeNonAscii(tDirMes.szTitle, szBuffer2);
		if( ! strcmp(tDirMes.szRecipient, pszToStn) &&
		    ! strcmp(tDirMes.szSender, pszFromStn)  &&
		    ! strcmp(szBuffer1, szBuffer2)          &&
		    ! strcmp(tDirMes.szDate, szDate)        &&
		    tDirMes.byTi_Min == byTi_Min            &&
		    tDirMes.byTi_Hour == byTi_Hour )
		{
			/* C'est un double (ou tout le laisse croire) */
			nIsDupe = TRUE;
			break;
		}
	}

	fclose(fDirMes);
	return nIsDupe;
}
/*-------------------------------------------------------------------------
  ------ Retourne la chaine BID -------------------------------------------
  -------------------------------------------------------------------------*/
char* MAIL_getBid(void)
{
	if( MAIL_szBid[0] == SNULL )
	{
		char szNodeCall[16];
		NODE_getNodeCall(0, 0, szNodeCall);
		TOOLS_removeSsid(szNodeCall);
		TOOLS_maxLength(szNodeCall, 6);
		strcpy(MAIL_szBid, szNodeCall);
	}

	return MAIL_szBid;
}

/*-------------------------------------------------------------------------
  ------ Definir la chaine BID --------------------------------------------
  -------------------------------------------------------------------------*/
void MAIL_setBid(char* szBid)
{
	TOOLS_maxLength(szBid, 6);
	strcpy(MAIL_szBid, szBid);
}			

/*-------------------------------------------------------------------------
  ------ Ajouter un BID dans la base de donnees BID -----------------------
  -------------------------------------------------------------------------*/
void MAIL_addBidToDB(char* szBid)
{
	FILE* fPtr;
	MAILBID MailBid;

	if( szBid[0] == SNULL )
		return;		/* Pas de BID */

	fPtr = fopen(BID_DATABASE_FILE, "a+b");
	if( ! fPtr )
	{
		perror("fopen in MAIL_saveBidToDB ");
		return;
	}

	memset(&MailBid, 0, sizeof(MAILBID));	/* fichier plus clean */
	MailBid.lDateTime = TOOLS_whatDateTime();
	TOOLS_maxLength(szBid, 12);
	strcpy(MailBid.szBid, szBid);

	fwrite(&MailBid, sizeof(MAILBID), 1, fPtr);

	fclose(fPtr);		
}			

/*-------------------------------------------------------------------------
  ------ Rechercher un BID dans labase de donnees BID ---------------------
  -------------------------------------------------------------------------
  Retour : TRUE si le BID existe deja et FALSE sinon
  Remarque : recherche sequentielle (pouah ! quelle horreur !)             */
int MAIL_searchBidDB(char* szBid)
{
	FILE* fPtr;
	MAILBID MailBid;
	int nFound = FALSE;

	fPtr = fopen(BID_DATABASE_FILE, "rb");
	if( ! fPtr )
		return FALSE;

	while( fread(&MailBid, sizeof(MAILBID), 1, fPtr) == 1 )
	{
		if( ! strcmp(MailBid.szBid, szBid) )
		{
			nFound = TRUE;
			break;
		}
	}

	fclose(fPtr);
	return nFound;
}			

/*------------------------------------------------------------------------
  ------ Get a BID number ------------------------------------------------
  ------------------------------------------------------------------------
  Return : last message number */
unsigned long MAIL_getBidNum(unsigned long dwMailNumber)
{
	FILE* fPtr;
	int Done = 0;
	unsigned long dwBidNumber;
	
	/* Read the current bid number */
	fPtr = fopen(MAIL_BIDNUM_FILE, "rb");
	if( fPtr )
	{
		Done = fread(&dwBidNumber, sizeof(dwBidNumber), 1, fPtr);
		fclose (fPtr);
	}

	/* If not found or if smaller than message_number, take 
	   message_number */
	if( Done != 1 || dwBidNumber < dwMailNumber )
		dwBidNumber = dwMailNumber;
		
	/* Write the BID number + 1 (the one which be used next time a
	   BID is needed) */
	fPtr = fopen(MAIL_BIDNUM_FILE, "wb");
	if( fPtr )
	{
		dwBidNumber++;
		fwrite(&dwBidNumber, sizeof(dwBidNumber), 1, fPtr);
		dwBidNumber--;
		fclose(fPtr);
	}
	else
		perror("fopen in MAIL_getBidNum ");
	
	return (dwBidNumber % 65535L);
}
