#ifndef _MAIL_H
#define _MAIL_H

#include "define.h"
#include "stdio.h"

#define TYPE_B		'B'
#define TYPE_P		'P'

#define STATUT_N	'N'
#define STATUT_K	'K'
#define STATUT_R	'R'
#define STATUT_F	'F'

#define MAIL_FWD_NOW	1
#define MAIL_FWD_LATER	0

#define ONLYTHISONE	0
#define ALLQUEUED	1
#define ONLYTHISROUTE	2

typedef struct _MAILBID
{
	unsigned long lDateTime;
	char szBid[12];
} MAILBID;

typedef struct
{
	char		cType;		//Type du message (BULL, PERSO)
	char		cStatut; 	//Status
	unsigned long   dwNumber;	//Numero du message
	char		szDate[12];	//Date d'ecriture du message
	BYTE		byTi_Hour;	//Heure      "          "
	BYTE		byTi_Min;	//Minutes    "          "
	char		szRecipient[16];//Destinataire
	char		szRoute[16];	//Routage (@) (Indicatif+ssid)
	char		szSender[16];	//Expediteur
	char		szTitle[61];	//Titre
	char		szStartNode[16];//Cluster de depart du message
	char		szBid[13];	//BID du message
	char		szRcvNode[16];	//Dernier cluster a avoir fwd le msg
	BYTE		byNoAutoDelete;	//TRUE si le message ne doit pas
					//pas etre efface lors de la
					//maintenance
	BYTE		byRetReceipt;  	//Est TRUE quand il faut retourner
					//un ack au moment o le dest. lit
					//le message
	char		szReserved[99]; //Reserve
} DirMesStruct;

typedef struct
{
	char		szRoute[16];
	unsigned long	dwNumber;
	int   		nNow;
} QueueStruct;

char * 	MAIL_searchSep( char * szBuffer );
int	MAIL_rcvRecip(int StreamNum, char * szType, char * szParams, BYTE byRetReceipt, int nDupe);
void 	MAIL_delTemp(int StreamNum);

unsigned long 	MAIL_tmp2Msg(int StreamNum);
unsigned long 	MAIL_lastNum(void);
void  MAIL_setLastNum(unsigned long dwNumber);
unsigned long MAIL_list(int StreamNum, char * pszArea, char * pszSender, char * pszSubject, char * pszUserCall,	unsigned long dwFromNumber, unsigned long dwToNumber, int nUserLevel, unsigned long dwNtoList);
int   MAIL_read(int StreamNum, unsigned long dwNumber, char * pszUserCall, char cUserLevel);
int   MAIL_kill(int StreamNum, unsigned long dwNumber, char * pszUserCall, char cUserLevel);
long  MAIL_searchHeader(FILE * fDirMes, unsigned long dwNumber, DirMesStruct * tDirMes);
unsigned long MAIL_isNew(char * pszUserCall);
int   MAIL_queue(char * szRoute, unsigned long dwNumber);
void  MAIL_viewQueue(int StreamNum, char * ToNode);
int   MAIL_deQueue(char * szRoute, unsigned long dwNumber);
int   MAIL_isQueued(char * szRoute, unsigned long dwNumber);
int   MAIL_isMailExist(unsigned long dwNumber);
void  MAIL_fwd(char * szRoute, unsigned long dwNumber, int StreamNum);
void  MAIL_fwd(void);
void  MAIL_sendNextBloc(int StreamNum, char * ToNode, char * FmNode, unsigned long dwMesNum);
int   MAIL_changeStatut(unsigned long dwNumber, char cNewStatut);
int   MAIL_addSubject2Tmp(int StreamNum, char * szSubject, char * szDate, char * szTime, char * szStartNode, char * szAdjacentNode);
int   MAIL_addText2Tmp(int StreamNum, char * szText);
void  MAIL_fwd2User(int StreamNum, char * szUser, int nIsInitDone);
int   MAIL_isDupe(char * pszToStn, char * pszFromStn, char * pszSubject, char * pszDate, char * pszTime);
char* MAIL_getBid(void);
void  MAIL_setBid(char* szBid);
void  MAIL_addBidToDB(char* szBid);
int   MAIL_searchBidDB(char* szBid);

#endif
