#include <bios.h>
#include <alloc.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <time.h>
#include <dos.h>
#include "define.h"
#include "display.h"
#include "keyboard.h"
#include "symbol.h"
#include "switch.h"
#include "buffers.h"
#include "main.h"
#include "language.h"
#include "commands.h"
#include "message.h"
#include "autoproc.h"
#include "streams.h"
#include "params.h"
#include "script.h"
#include "node.h"
#include "config.h"
#include "protocol.h"
#include "argv.h"
#include "tools.h"
#include "protocol.h"
#include "users.h"
#include "database.h"
#include "ping.h"
#include "log.h"
#include "term.h"
#include "spy.h"
#include "ltimeout.h"
#include "medit.h"
#include "fbbsrv.h"

#ifdef WIN32
 #undef BYTE
 #include "agw.h"
// #include "windows.h"
#endif

#ifdef DOS
 extern "C" {
 #include "com.h"
 }
 #include "dos.h"
#endif


#ifdef LINUX
 #include <sys/signal.h>
 #include <sys/wait.h>
 #include <syslog.h>
#endif

//------ Augmentation de la taille de la pile -------------------------------
#ifdef DOS
 extern unsigned _stklen = 16384U;
#endif

//------ Variables globales ------
time_t	MAIN_timeStart;
#ifdef DOS
int	MAIN_bpqBuffLeft = 0;
#endif

extern int FirstStream;		//Dfinie dans SWITCH.CPP
extern int LastStream;		//Dfinie dans SWITCH.CPP

extern	unsigned long COMMANDS_statut[MAX_STREAMS];

extern char STREAMS_callsign[MAX_STREAMS][10];	//Definie dans STREAMS.CPP
extern int	STREAMS_level[MAX_STREAMS];			//idem
extern char	PROTOCOL_linkType[65];				//Definie dans PROTOCOL.CPP
extern	int	SCRIPT_fromStream[MAX_STREAMS];		//Y compris la console (F2)
extern char SCRIPT_fileName[65][9];			//Limite a 8 caracteres (+NULL), l'extension .FWD tant ajout chaque fois
extern	int	SCRIPT_timer[65];
extern	int	COMMANDS_iExitCode;
extern  int	STREAMS_iDiddle[MAX_STREAMS];
extern	int	PARAMS_iDefaultDiddle;
extern	int	MAIL_nTimeOut[MAX_STREAMS];
extern	unsigned long 	MAIL_lFwdMsgNumber[MAX_STREAMS];
extern  int PARAMS_nIsMonitorOn;

/*---------------------------------------------------------------------------
  ------ signals managements (LINUX only) -----------------------------------
  ---------------------------------------------------------------------------*/
#ifdef LINUX
static void sig_fct (int sig)
{
	int pid, pstatus;
	char* ptr;

	sig &= 0xff;
	pid = wait (&pstatus);
	signal (sig, sig_fct);
	
	switch (sig)
	{
	case SIGHUP :
		/* reload system files */
		CONFIG_reload("all");
		LOG_sysMessage(LOG_STATUS, "Reload system files");		
		return;
		
	case SIGTERM :
		TOOLS_exitDxNet(0, "SIGTERM");
		exit(0);

	case SIGINT :
		TOOLS_exitDxNet(0, "SIGINT");
		exit(0);
		
	case SIGBUS :
		ptr = "Bus Error";
		break;
		
	case SIGPIPE :
		ptr = "Broken pipe";
		break;
		
	case SIGFPE :
		ptr = "Floating point exception";
		break;
		
	case SIGILL :
		ptr = "Illegal instruction";
		break;
		
	case SIGSEGV :
		ptr = "Segmentation violation";
		break;

	case SIGSTKFLT :
		ptr = "Stack fault";
		break;
		
	default :
		LOG_sysMessage(LOG_STATUS, "Received signal %d", sig);
		return;
	}
	
	/* Log it into syslog */
	openlog("DxNet", 0, 0);
	syslog(LOG_USER | LOG_ERR, ptr);
	syslog(LOG_USER | LOG_ERR, "Abnormal program termination (core dumped)");	
	closelog();
	abort();
}
#endif

/*---------------------------------------------------------------------------
  ------ gestion des evenements CONSOLE (clavier) ---------------------------
  ---------------------------------------------------------------------------
  Avant d'appeler cette fonction, il est necessaire de s'assurer qu'une
  touche a bien ete frappee -bioskey(1)-
*/
void MAIN_console(void)
{
	static char SysopInputStr[80];
	static int  SysopInputPos = 0;
	static char SwitchInputStr[80];
	static int  SwitchInputPos = 0;
	int RetChar;

	DISP_PutStat();

	switch( DISP_GetActiveScreen() )
	{
	case SCREEN2 :
		RetChar = ScanKeyboard(SysopInputStr, SysopInputPos, 79);
		/* Le sysop a-t-il valide la saisie ? */
		if( RetChar == CR )
		{
			/* ajouter la commande dans le buffer d'entree */
			BUFFERS_printBuff(BUFFER_SCREEN2, IN, "%s\r", SysopInputStr);

			/* reinitialiser les variables */
			SysopInputStr[0] = SNULL;
			SysopInputPos    = 0;
		}
#ifndef WIN32
		DISP_PutsInputString(SCREEN2, SysopInputStr, SysopInputPos);
#endif
		break;

	case SCREEN3 :
		RetChar = ScanKeyboard(SwitchInputStr, SwitchInputPos, 79);
		/* Le sysop a-t-il valide la saisie ? */
		if( RetChar == CR )
		{
			/* envoyer la ligne au module de gestion du terminal */
#ifdef DOS
			TERM_put(SwitchInputStr);
#endif
			/* reinitialiser les variables */
			SwitchInputStr[0] = SNULL;
			SwitchInputPos    = 0;
		}
		DISP_PutsInputString(SCREEN3, SwitchInputStr, SwitchInputPos);
		break;

	default :
		RetChar = getkey();
	}

	switch( RetChar )
	{
	case PGUPKEY :
		DISP_StatRowUp();
		break;

	case PGDNKEY :
		DISP_StatRowDown();
		break;

	case F1 :
		DISP_SetActiveScreen( SCREEN1 );
		break;

	case F2 :
		DISP_SetActiveScreen( SCREEN2 );
		break;

	case F3 :
		DISP_SetActiveScreen( SCREEN3 );
		break;

	case F4 :
		DISP_SetActiveScreen( SCREEN4 );
		break;
	}/* End SWITCH */
}

/*--------------------------------------------------------------------------
  ------ LOOP - L'ensemble du fonctionnement de DxNet se passe ICI ---------
  --------------------------------------------------------------------------*/
void MAIN_loop(void)
{
	static int 	StreamNum;
	static int   	index;
	static int 	job = TRUE;
	static char	Buffer[16384];
	static int	Secondes = -1,
			OldSecondes = -1;
	static int	iBuffSize;
	static char 	ConnectedCall[11];
	static int	nUnAcked;

	/* Boucle Principale (repetee a l'infini) */
	for(;;)
	{
		/* Liberer du temps machine sous LINUX */
#ifndef DOS
		if( ! job )
		{
			/* Attendre un evenement */
			while( SWITCH_wait(10) == 0 && OldSecondes == TOOLS_whatSec() );
		}
#endif
		job = FALSE;

		/* Port redirige : y a t-il des caracteres */
#ifdef DOS
		if( COM_getRow(Buffer) )
		{
			int nConsole = COM_getConsoleNum();

			switch( nConsole )
			{
			case 2 : /* Console 2 */
				/* Executer la commande */
				CMD_execute(BUFFER_SCREEN2, Buffer);

				/* Afficher un echo sur la console */
				strcat(Buffer, "\n");
				if( Buffer[0] != 127 )	/* 127 : Id MACRO */
					DISP_PutsConsole(SCREEN2, Buffer, COLOR_IN);
				break;

			case 3 : /* console 3 (terminal) */
				/* Executer la commande */
				TERM_put(Buffer);
				break;
			}
		}
#endif

		for(StreamNum = FirstStream; StreamNum <= LastStream; StreamNum++)
		{
			/* ------ Gerer les evenements console --------------------------------- */

			/* Detecter l'appuis sur une touche */
			if( bioskey(1) )
			{
				MAIN_console();
				job = TRUE;
			}

			/* Y a t-il une commande a executer pour la fenetre PROGRAM (F1) ? */
			if( BUFFERS_getRow(BUFFER_SCREEN1, Buffer, IN) )
			{
				CMD_execute(BUFFER_SCREEN1, Buffer);		//Executer la commande
				strcat(Buffer, "\n");				//Retour charriot
				if( Buffer[0] != 127 )	/* 127 : Id MACRO */
					DISP_PutsConsole(SCREEN1, Buffer, COLOR_IN);	//Afficher un echo de la commande sur l'cran
				job = TRUE;
			}

			/* Y a t-il quelque chose a afficher dans la fenetre PROGRAM (F1) ? */
			if( BUFFERS_getBloc(BUFFER_SCREEN1, Buffer, OUT) )
			{
				DISP_PutsConsole(SCREEN1, Buffer, COLOR_OUT);
				job = TRUE;
			}

			/* Y a t-il une commande a executer pour la fenetre CONSOLE (F2) ? */
			if( BUFFERS_getRow(BUFFER_SCREEN2, Buffer, IN) )
			{
				CMD_execute(BUFFER_SCREEN2, Buffer);		//Executer la commande
				strcat(Buffer, "\n");				//Retour charriot
				if( Buffer[0] != 127 )	/* 127 : Id MACRO */
					DISP_PutsConsole(SCREEN2, Buffer, COLOR_IN);	//Afficher un echo de la commande sur l'cran
				job = TRUE;
			}

			/* Y a t-il quelque chose a afficher dans la fenetre CONSOLE (F2) ? */
			if( BUFFERS_getBloc(BUFFER_SCREEN2, Buffer, OUT) )
			{
				DISP_PutsConsole(SCREEN2, Buffer, COLOR_OUT);

				/* Port redirige ? */
#ifdef DOS
				if( COM_getConsoleNum() == 2 )
					COM_puts(Buffer);
#endif
				job = TRUE;
			}

			/* Gerer les evenements utilisateurs */
			/* Si le Stream est connecte, traiter les buffers IN et OUT */

			/* Y a t-il des caracteres en attente dans le SWITCH pour ce stream ? */
			iBuffSize = SWITCH_getFrame(StreamNum, Buffer);
			if( iBuffSize )
			{
				/* Peut-etre est-ce pour le terminal (version DOS uniquement) */
#ifdef DOS
				if( StreamNum == TERM_conStream() )
				{
					TOOLS_R2N(Buffer);
					/* Placer une SNULL a la fin de la chaine (car la fonction 
					  SWITCH ne le retourne pas */
					Buffer[iBuffSize] = SNULL;
					DISP_PutsConsole(SCREEN3, Buffer, COLOR_OUT);
				}
				else
					BUFFERS_addBuff_sized(StreamNum, Buffer, IN, iBuffSize);
#else
				BUFFERS_addBuff_sized(StreamNum, Buffer, IN, iBuffSize);
#endif
				job = TRUE;
			}

			/* Y a t-il une commande a executer dans le stream ? */
			if( BUFFERS_getRow(StreamNum, Buffer, IN) )
			{
				/* Aiguillage */
				if( STREAMS_level[StreamNum] & LEVEL_user )				/* Utilisateur */
					CMD_execute(StreamNum, Buffer);
				else if( STREAMS_level[StreamNum] & LEVEL_bbs )			/* BBS */
					CMD_execute(StreamNum, Buffer);
				else if( STREAMS_level[StreamNum] & LEVEL_hiddenUser )	/* Utilisateur cache */
					CMD_execute(StreamNum, Buffer);
				else if( STREAMS_level[StreamNum] & LEVEL_linkSetup )	/* Link Setup */
					SCRIPT_do(StreamNum, Buffer);
				else if( STREAMS_level[StreamNum] & LEVEL_cluster )     /* Cluster */
				{
					/* Si le protocol est un CluLink, ajouter un '\n' a la fin
					de la la chaine, car ce caractere n'est pas envoye a 
					l'emission */
					PROTOCOL_do(StreamNum, Buffer);

					/* Reset du link timeout */
					LTIMEOUT_reset(StreamNum);
				}
				job = TRUE;
			}

			/* Y a t-il quelque chose en attente a envoyer au switch ? */
			nUnAcked = SWITCH_getUnack(StreamNum);
			if( nUnAcked < 14 )
				iBuffSize = BUFFERS_getBloc(StreamNum, Buffer, OUT);
			else
				iBuffSize = 0;

			if( iBuffSize )
			{
				/* Remplacer les '\n' par des '\r' sauf s'il s'agit d'une trame
				   CluLink */
				if( PROTOCOL_linkType[StreamNum] != CLU_LINK )
					TOOLS_N2R(Buffer);

				SWITCH_sendFrame(StreamNum, Buffer, iBuffSize);
//				nUnAcked = 255;	/* Eviter la connexion immediate apres un B sous AGWpe */

				/* Initialiser la variable Diddle (sauf si c'est un cluster) */
				if( ! (STREAMS_level[StreamNum] & LEVEL_cluster) )
					STREAMS_iDiddle[StreamNum] = PARAMS_iDefaultDiddle;

				job = TRUE;
			}

			/* Nouvel evenement sur le Stream ? */
			switch( SWITCH_getStatut(StreamNum) )
			{
			case NONE :
				/* Donc ne fait rien */
				break;

			case CONNECTED :
				/* Qui a connecte le SWITCH ? */
				SWITCH_getCall(StreamNum, ConnectedCall);
				STREAMS_connect(StreamNum, ConnectedCall);
				job = TRUE;
				break;

			case DISCONNECTED :
#ifdef DOS
				if( StreamNum == TERM_conStream() )
					TERM_disconnect();
				else
					STREAMS_disconnect(StreamNum);
#else
				/* Verifier si un indicatif est connu */
				STREAMS_disconnect(StreamNum);
#endif
				job = TRUE;
				break;
			}

			/* Afficher le monitoring (DOS) */
			if( PARAMS_nIsMonitorOn && SWITCH_rawRx(1, Buffer) )
			{
#ifdef DOS
				/*Gestion des spy*/
				SPY_frame (Buffer);
#endif
				DISP_PutsConsole(MONITOR, Buffer, OUT);
				job = TRUE;
			}

			/* Faut-il deconnecter le stream ? */
			if( COMMANDS_statut[StreamNum] & COMMANDS_statutDisconnect )
			{
				/* Deconnecter si toutes les trames en attente ont ete ACKed */
				if( nUnAcked == 0 && BUFFERS_getSize(StreamNum, OUT) == 0 )
				{
					SWITCH_discSwitch(StreamNum);

					/* Pour que le stream puisse etre a nouveau connecte ... */
					COMMANDS_statut[StreamNum] = COMMANDS_statutInit;
					job = TRUE;
				}
			}

			/* Faudra t-il deconnecter ce stream lors de la prochaine boucle ? */
			if( COMMANDS_statut[StreamNum] & COMMANDS_statutWillDisconnect )
			{
				COMMANDS_statut[StreamNum] &= ~COMMANDS_statutWillDisconnect;
				COMMANDS_statut[StreamNum] |= COMMANDS_statutDisconnect;
			}

			/*  ShutDown ? */
			if( COMMANDS_statut[0] & COMMANDS_statutShutDown )
			{
				int iCanDo = TRUE;
				job = TRUE;

				/* Ballayer les streams */
				for(index = FirstStream; index <= LastStream; index++)
				{
					/* Le stream est-il tjrs connecte ? */
					if( SWITCH_conStat(index) )
					{
						iCanDo = FALSE;
						job    = FALSE; 
						break;
					}
				}

				/* Si un stream est tjrs connecte -> ne pas quitter */
				if( iCanDo )
				{
					if( COMMANDS_iExitCode )
					{
						TOOLS_exitDxNet(
							COMMANDS_iExitCode, 
							"EXIT");
					}
					else
						TOOLS_exitDxNet(0, "EXIT");
				}
			}

			/*  Seconde ? */
			Secondes = TOOLS_whatSec();

			/* La seconde a t-elle changee depuis la derniere fois ? */
			if( Secondes != OldSecondes )
			{
#ifdef DOS
				/* gestion des buffers sous BPQ */
				if( (Secondes % 10 == 0 ) && MAIN_bpqBuffLeft > 0 && ! SWITCH_isPcFlexNet())
				{
					if( SWITCH_getBufferLeft() < MAIN_bpqBuffLeft )
						TOOLS_exitDxNet(9, "BPQBUFFER");
				}
#endif

#ifdef WIN32
				/* sortir du mode idle de AGW (si besoin) */
				if( Secondes == 0 || Secondes == 30 )
					AGW_goOutOfIdleState();
#endif
				/* Afficher la barre de statut */
				DISP_PutStat();

				/* Lancement des process automatiques - Declanchements aux
				   secondes rondes (ou a la prochaine seconde qui suit
				   un passage a zero en cas de depassement) */
				/* Egalement : effectuer un rafraichissement de la liste des
				   station connectees vers les clients FBB */
				if( Secondes < OldSecondes )
				{
					AUTOPROC_do();
#ifndef DOS
					FBBSRV_connectedList(0, FBBSRV_CONLIST_REFRESH, NULL);
#endif
				}

				/* Timeout des scripts de connexion ansi que le Diddle */
				/* Windows version : ask AGWpe for unacked frames */
				for(index = FirstStream; index <= LastStream; index++)
				{
					if( STREAMS_level[index] & LEVEL_linkSetup )
					{
						if( --SCRIPT_timer[index] <= 0 )	/* Timeout ? */
						{
							BUFFERS_printBuff(SCRIPT_fromStream[index], OUT, "*** Link setup timeout with %s on stream %d.\n", SCRIPT_fileName[index], index);
							MSG_send(SCRIPT_fromStream[index], MSG1);
							SWITCH_discSwitch(index);
							STREAMS_disconnect(index);
						}
					}
					else if( STREAMS_level[index] ) /* Seulement s'il y a quelqu'un de connecte */
					{
#ifdef WIN32
						/* Ask AGWpe for unAcked frames */
						SWITCH_ask4Unack(index);
#endif
						if( (STREAMS_level[index] & LEVEL_cluster) )
						{
							int  nLTimeout;

							/* Link timeout (cluster) */
							nLTimeout = LTIMEOUT_inc(index);

							switch(nLTimeout)
							{
							case LTIMEOUT_PING :
							{
								char szBuffer[128];
								char szClusterCall[16];
			
								NODE_getNodeCall(index, 0, szClusterCall);

								/* transmetre un PING */
								sprintf(szBuffer, "ping %s", szClusterCall);
								CMD_execute(0, szBuffer);
							}
								break;

							case LTIMEOUT_DISCONNECT :
								/* deconnecter */
								BUFFERS_printBuff(0, OUT,
									"*** Link timeout with %s on stream %d.\n",
								STREAMS_callsign[index], index);
								SWITCH_discSwitch(index);
								STREAMS_disconnect(index);
								break;

							default:
								/* ex : LTIMEOUT_OK */
								break;
							}

							/* Forward timeout ? */
							if( MAIL_lFwdMsgNumber[index] && --MAIL_nTimeOut[index] <= 0 )
							{
								/* OUI */
								MAIL_lFwdMsgNumber[index] = 0L;
								PROTOCOL_abortForwarding(index);
							}
						}

						if( STREAMS_iDiddle[index] != -1 && STREAMS_level[index] != LEVEL_term )	/* -1 signifie que la commande est sur off */
						{
							if( --STREAMS_iDiddle[index] <= 0 )	/* Faut-il envoyer un diddle packet ? */
							{
								/* Oui, et il faut aussi reinitialiser la variable diddle */
								if( STREAMS_level[index] & LEVEL_cluster )
								{
									char sNodeCall[16];
									/* Call du cluster */
									NODE_getNodeCall(0, 0, sNodeCall);
									PROTOCOL_userCount(index, sNodeCall, FALSE, 0, 100);
									STREAMS_iDiddle[index] = 900;		/*15 minutes*/
								}
								else
								{
									MSG_send(index, MSG41);	/* transmettre le diddle */
									STREAMS_iDiddle[index] = PARAMS_iDefaultDiddle;
								}
							}
						}
					}
				}
				/* Actualiser */
				OldSecondes = Secondes;
			}
		} 
	}
}

//--------------------------------------------------------------------------
//------ Fonction principale -----------------------------------------------
//--------------------------------------------------------------------------
int main(int Argc, char * Argv[])
{
	int _FirstStream = 1;
	int _LastStream  = 64;
	int _ApplMask    = 1;
	int iScreenSize;
#ifndef DOS
	int   port;
#endif
#ifdef WIN32
	char AGW_szHostAddr[256];
	int  AGW_nPort;	
#endif

	extern int PROTOCOL_nFixedInit;

	LOG_sysMessage(LOG_STATUS, "DxNet started");
	
#ifdef LINUX
	/* LOG and SIGNAl handling */
	for(int i = 1; i < _NSIG; i++)
	{
		signal (i, sig_fct);
	}
	openlog("DxNet", 0, 0);
	syslog(LOG_USER | LOG_INFO, "Started");
 	closelog();
#endif

	//------ Lecture des Arguments ------
	_FirstStream = ARGV_get(Argc, Argv, "-fs");
	if( _FirstStream == -1 )
		_FirstStream = 1;

	_LastStream = ARGV_get(Argc, Argv, "-ls");
	if( _LastStream == -1 )
		_LastStream = 64;

	_ApplMask = ARGV_get(Argc, Argv, "-appl");
	if( _ApplMask == -1 )
		_ApplMask = 1;

	iScreenSize = ARGV_get(Argc, Argv, "-s");
	if( iScreenSize != 43 && iScreenSize != 50 )
		iScreenSize = 25;

	if( ARGV_get(Argc, Argv, "-moff") != -1 )
		PARAMS_nIsMonitorOn = FALSE;

	if( ARGV_get(Argc, Argv, "-noinit") != -1 )
		PROTOCOL_nFixedInit = FALSE;

#ifndef DOS
	/* Specifique a linux et a windows */
	if( (port = ARGV_get(Argc, Argv, "-p")) == -1 )
		port = 3287;
#endif

#ifdef DOS
	/* Specifique a DOS */
	MAIN_bpqBuffLeft = ARGV_get(Argc, Argv, "-bpql");
#endif

#ifdef WIN32
	char szBuffer[256];
	/* HostAddr et portnum pour le AGW pe */
	if( ARGV_getStr(Argc, Argv, "-agw=", szBuffer) )
	{
		char* token;
		int   index = 0;

		AGW_nPort = 8000;	/* valeur par defaut */
		token = strtok(szBuffer, " :");
		while(token)
		{
			switch(index++)
			{
			case 0 :
				strcpy(AGW_szHostAddr, token);
				break;
			case 1 :
				AGW_nPort = atoi(token);
				break;
			default :
				break;
			}
			token = strtok(NULL, " :");
		}
	}
	else
	{
		strcpy(AGW_szHostAddr, "127.0.0.1");
		AGW_nPort = 8000;
	}

	LOG_sysMessage(LOG_STATUS, "Trying to connect AGWpe on %s:%d", AGW_szHostAddr, AGW_nPort);
#endif

	//------ Initialiser la table des streams ------
	BUFFERS_init();

	//------ Initialiser le SWITCH packet ------
	if( ! SWITCH_initSwitch(_FirstStream, _LastStream, _ApplMask) )
	{
#ifdef DOS
		char* str = "*** Error : can't find either G8BPQ switch nor PcFlexNet kernel.";
		printf("%s\n", str);
		LOG_sysMessage(LOG_STATUS, "%s", str);
#endif
		TOOLS_exitDxNet(10, "Can't init switch");
	}

#ifdef WIN32
	if( ! AGW_connectPE(AGW_szHostAddr, AGW_nPort) )
		LOG_sysMessage(LOG_STATUS, "SV2AGW packet engine not found : program enters idled mode");
	else
		LOG_sysMessage(LOG_STATUS, "Done");
#endif
  
  /* Initialition du serveur console */
#ifndef DOS
	if( FBBSRV_initOrb(port) == 0 )
  		TOOLS_exitDxNet(10, "Can't init FBBSRV");
#endif

	//------ Initialiser la table des langues et des Helps ------
	LANG_init();

	//------ Initialiser les databases --------------------------
	DATABASE_init();

	printf("Starting DxNet...\n");
	delay(1000);

	//------ Initialiser les crans ------
	DISP_InitDisplay(iScreenSize);

	//------ Initialiser les paramtres du serveur ------
	if( ! USERS_init() )
	{
		static char* error = "MAIN : Not enough memory to allocate the users buffers.";
		printf("*** Error : %s\n");
		LOG_sysMessage(LOG_INTERNALERROR, "%s", error);		
		TOOLS_exitDxNet(10, "Not enough memory");
	}
	PARAMS_init();
	STREAMS_init();
	SCRIPT_init();
	NODE_init();
	COMMANDS_init();
	PING_init();
	MEDIT_init();
#ifdef DOS
	TERM_init();
	DOS_init();
#endif

	//------ Heure du lancement de DxNet ------
	MAIN_timeStart = time(NULL);

	//------ Lire le fichier de configuration (SYSTEM\DXNET.CFG) ------
	CONFIG_init();
  
	//------ Lancer DxNet ------
/*	atexit( MAIN_ExitDxNet ); */
	MAIN_loop();

	return 0;
}
