#include <alloc.h>
#include <string.h>
#include <stdlib.h>
#include "language.h"
#include "buffers.h"
#include "message.h"
#include "node.h"
#include "define.h"
#include "tools.h"
#include "users.h"
#include "help.h"
#include "mail.h"
#include "commands.h"

/* Liste des variables
	%D	Date	JJ-MMM-YYYY
	%d	Date	JJ-MMM
	%H	Heure
	%I	Prnom de l'utilisateur
	%L	Numero du dernier message recu
	%l	Langue de l'utilisateur
	%O	Indicatif du serveur
	%o	indicatif du serveur SANS SSID
	%U	Indicatif de l'OM connect
	%u	indicatif de l'OM connecte SANS SSID
	%x      Date of the last connection (format 01-Apr-2000)
	%y      Time of the last connection (format 01:02)
	%Z 	Dernier message liste par l'OM
	%0-%9	Variables temporaires (commande et paramtres taps par l'utilisateur)
*/

extern 	char  	STREAMS_lang[MAX_STREAMS];
extern  char	STREAMS_callsign[MAX_STREAMS][10];
extern  tUser * pUser;


char    *MSG_pParams[10];

//---------------------------------------------------------------------------
//------ Envoyer un message -------------------------------------------------
//---------------------------------------------------------------------------
//La liste des messages se trouve dans le fichier MESSAGE.H
void MSG_send(int StreamNum, int Line)
{
  char sBuffer[256];

  //Lire le message (en faisant attention aux remote commands)
  if( StreamNum >= 0 && StreamNum <= 65 )
  	LANG_getMessage(STREAMS_lang[StreamNum], Line, sBuffer);
else
	LANG_getMessage(0, Line, sBuffer);

  //Remplacer les variables
  MSG_insertVar(StreamNum, sBuffer);

  //Ajouter dans le buffer
  BUFFERS_addBuff(StreamNum, sBuffer, OUT);
}

/*---------------------------------------------------------------------------
  ------ Inserer les variables ----------------------------------------------
  ---------------------------------------------------------------------------*/
void MSG_insertVar(int StreamNum, char * String)
{
	char* pPtr;
	char  sVariable[256];

	if( StreamNum >= RCMD_VIRTSTREAM )
		StreamNum = 65;

	/* Parcourir la chaine, en cherchant les variables */
	while( (pPtr = strchr(String, '%')) != NULL )
	{
		if( pPtr[1] == 'D' )			/* Date actuelle '10-Oct-1997' */
			TOOLS_whatDate(sVariable);
	    else if( pPtr[1] == 'd' )		/* Date actuelle '10-Oct' */
		{
			TOOLS_whatDate(sVariable);
			/* Virrer l'annee */
			sVariable[6] = SNULL;
		}
        else if( pPtr[1] == 'H' )		/*  Heure 14:15 */
		{
			TOOLS_whatTime( sVariable );

			/* Inserer un ':' entre les heures et les minutes */
			sVariable[5] = SNULL;
			sVariable[4] = sVariable[3];
			sVariable[3] = sVariable[2];
			sVariable[2] = ':';
		}
		else if( pPtr[1] == 'O' )		/* L'indicatif du serveur */
		{
			char sNodeCall[11];
			strcpy(sVariable, NODE_getNodeCall(0, 0, sNodeCall));
		}
		else if( pPtr[1] == 'o' )		/* L'indicatif du serveur SANS SSID */
		{
			char sNodeCall[11];
			strcpy(sVariable, NODE_getNodeCall(0, 0, sNodeCall));
	
			TOOLS_removeSsid(sVariable);
		}
		else if( pPtr[1] == 'l' )		/* Langue definie */
		{
			char sBuffer[256];
			/* Pour les remote commands */
			if( StreamNum >= 0 && StreamNum <= 65 )
			{
      			strcpy(sVariable, LANG_getMessage(STREAMS_lang[StreamNum], LANGUAGE,
	   			sBuffer));
			}
			else
      			strcpy(sVariable, LANG_getMessage(1, LANGUAGE, sBuffer));
      	
			TOOLS_removeN(sVariable);
		}
		else if( pPtr[1] >= '0' && pPtr[1] <= '9' )	/* Variables temporaires */
		{
			int iTemp = atoi(pPtr+1);

			/* Au cas ou %9 pointe sur un NULL ... */
			if( MSG_pParams[9] == NULL )
				MSG_pParams[9] = MSG_pParams[1];

			if( iTemp >= 0 && iTemp <= 9 )
				strcpy(sVariable, MSG_pParams[iTemp]);

			/* Convertir la commande en majuscule (les parametres restent tels quels) */
			if( iTemp == 0 )
				strupr(sVariable);
		}
		else if( pPtr[1] == 'I' )		/* Prenom de l'OM connecte */
		{
			/* Charger la config de l'utilisateur */
			USERS_getRecord(StreamNum);
			strcpy(sVariable, pUser->sName);
		}
		else if( pPtr[1] == 'L' )		/* Numero du dernier message recu */
			sprintf(sVariable, "%ld", MAIL_lastNum());
		else if( pPtr[1] == 'U' )		/* Indicatif de l'OM connecte */
			strcpy(sVariable, STREAMS_callsign[StreamNum]);
		else if( pPtr[1] == 'u' )		/* Indicatif de l'OM connecte SANS SSID */
		{
			strcpy(sVariable, STREAMS_callsign[StreamNum]);
			TOOLS_removeSsid(sVariable);
		}
		else if( pPtr[1] == 'x' )		/* Date de la derniere connexion */
		{
			char szDate[16];
			char szTime[16];

			/* Charger la config de l'utilisateur */
			USERS_getRecord(StreamNum);

			/* Convertir et copier la date */
			TOOLS_dateTime_Long2Str(szDate, szTime, pUser->lLastConnect);
			strcpy(sVariable, szDate);
		}
		else if( pPtr[1] == 'y' )		/* Heure de la derniere connexion */
		{
			char szDate[16];
			char szTime[16];

			/* Charger la config de l'utilisateur */
			USERS_getRecord(StreamNum);

			/* Convertir et copier la date */
			TOOLS_dateTime_Long2Str(szDate, szTime, pUser->lLastConnect);
			strcpy(sVariable, szTime);
			sVariable[2] = ':';
			strcpy(sVariable + 3, szTime + 2);
		}
		else if( pPtr[1] == 'Z' )		/* Dernier message liste par l'utilisateur */
		{
			/* Charger la config utilisateur */
			USERS_getRecord(StreamNum);
			sprintf(sVariable, "%ld", pUser->lLastMsg);
		}		
		else							/* Inconnu */
			strcpy(sVariable, " ");

		/* Inserer la variable, en s'assurant que la longueur totale
		   de la chaine n'excedera pas 255 caracteres */
		if( (strlen(String) + strlen(sVariable)) < 256 )
		{
			/* inverser les deux chaines */
			strrev(pPtr);
			strrev(sVariable);

			/* ajouter a la suite */
			String[ strlen(String) - 2] = SNULL;
			strcat(String, sVariable);

			/* remettre dans l'ordre initial */
			strrev( pPtr );
		}
	}
}

//---------------------------------------------------------------------------
//------ Rcuprer un message -----------------------------------------------
//---------------------------------------------------------------------------
//La liste des messages se trouve dans le fichier MESSAGE.H
char * MSG_get(int StreamNum, int Line, char * Buffer)
{
  //Lire le message (en faisant attention aux remote commands)
  if( StreamNum >= 0 && StreamNum <= 65 )
  	LANG_getMessage(STREAMS_lang[StreamNum], Line, Buffer);
else
  	LANG_getMessage(1, Line, Buffer);

  //Remplacer les variables
  MSG_insertVar(StreamNum, Buffer);

  //Retourner le pointeur
  return Buffer;
}

/*----------------------------------------------------------------------------
  ------ Send prompt ---------------------------------------------------------
  ----------------------------------------------------------------------------*/
void MSG_sendPrompt(int StreamNum)
{
	extern int STREAMS_level[MAX_STREAMS];
	extern unsigned long COMMANDS_statut[MAX_STREAMS];
	
	/* BBS ? */
	if( STREAMS_level[StreamNum] & LEVEL_bbs )
	{
		if( STREAMS_level[StreamNum] & LEVEL_bbsSIDOK )
			BUFFERS_addBuff(StreamNum, ">\n", OUT);	
		else
			BUFFERS_addBuff(StreamNum, "DxNet>\n", OUT);
		return;
	}

	/* send prompt */
	MSG_send(StreamNum, PROMPT);
	
	/* Is there new mail for this user ? */
	if( COMMANDS_statut[StreamNum] & COMMANDS_statusNewMail )
	{
		unsigned long dwNumber;
		char szUserCall[16];

		/* Yes probably, but verify before sending prompt, this has maybe
		   changed */
		strcpy(szUserCall, STREAMS_callsign[StreamNum]);

		dwNumber = MAIL_isNew(szUserCall);
		if( dwNumber )
		{
			char szNewMail[256];
			sprintf(szNewMail, "%ld", dwNumber);
			MSG_pParams[1] = szNewMail;
			MSG_send(StreamNum, MSG55);
		}
		else
			COMMANDS_statut[StreamNum] &= ~COMMANDS_statusNewMail;	/* no new mail */
	}
}
