#include <alloc.h>
#include <stdio.h>
#include <dir.h>
#include <string.h>
#include "language.h"
#include "message.h"
#include "define.h"
#include "buffers.h"
#include "motd.h"
#include "users.h"
#include "commands.h"
#include "tools.h"

/* Message of the day
   Il y a un MOTD par langue - la commande set/motd #n permet de definir
   le message du jour pour la langue #n. Si #n n'est pas precise, set/motd
   modifie le message correspondant a la langue du sysop uniquement.
									   */

extern 	unsigned long COMMANDS_statut[MAX_STREAMS];
extern	tUserCfg * pUserCfg;
extern  char	 LANG_file[MAX_LANG][81];       //Nom de fichiers LANG - 80 caractres au maximum pour chauqe nom de fichier


//---------------------------------------------------------------------------
//------ MOTD_send ----------------------------------------------------------
//---------------------------------------------------------------------------
//la fonction retourne TRUE si le message du jour a pu etre envoye et
//false sinon
int MOTD_send(int StreamNum, int Langue)
{
  FILE	*fPtr;
  char  sFileName[MAXPATH];
  char	sLine[256];

  if( Langue < 0 || Langue >= MAX_LANG )
    return FALSE;	//Depassement

//  sprintf(sFileName, "%smotd%d.txt", LANGUAGE_PATH, Langue + 1);
  sprintf(sFileName, "%s%s.mot", LANGUAGE_PATH, LANG_file[Langue]);

  fPtr = fopen(sFileName, "rt");

  if( ! fPtr )
    return FALSE;	//Fichier inexistant

  for(;;)
  {
    if( ! fgets(sLine, 255, fPtr) )
    {
      fclose( fPtr );
      return TRUE;	//Fin de fichier atteinte
    }/*End IF*/

    //Inserer des variables
    MSG_insertVar(StreamNum, sLine);

    //Envoyer la chaine dans le buffer ...
#ifdef LINUX
    TOOLS_removeR  (sLine);			/*Pour linux*/
#endif
    BUFFERS_addBuff(StreamNum, sLine, OUT);
  }/*End LOOP*/
}

//---------------------------------------------------------------------------
//------ MOTD_change --------------------------------------------------------
//---------------------------------------------------------------------------
//la fonction retourne TRUE si la modification du mot du jour est
//acceptee et FALSE sinon
int MOTD_change(int StreamNum, int Langue)
{
  char	sFileName[MAXPATH];

  if( Langue < 1 || Langue > MAX_LANG )	//Le numero correspond a celui a LANG + 1
  {
    MSG_send(StreamNum, MSG18);
    return FALSE;
  }

  //Preparer le nom du fichier
//  sprintf(sFileName, "%smotd%d.txt", LANGUAGE_PATH, Langue);
  sprintf(sFileName, "%s%s.mot", LANGUAGE_PATH, LANG_file[Langue - 1]);

  //Memoriser la config utilisateur
  USERS_getRecord(StreamNum);			//Acceder a la config de l'utilisateur
  strcpy(pUserCfg->sFileName, sFileName);	//Copier le nom du fichier MOTD
  pUserCfg->iBufferLength = 0;			//Si le buffer existe deja, il sera automatiquement vide au premier appel
  USERS_updateLocalConfig(StreamNum);   	//Sauvegarder les modifs

  COMMANDS_statut[StreamNum] |= COMMANDS_statutChangeMOTD;

  MSG_send(StreamNum, MSG38);

  return TRUE;
}