#include <alloc.h>
#include <stdio.h>
#include <string.h>
#include <stdio.h>
#include "node.h"
#include "define.h"
extern "C" {
#include "memory.h"
}
#include "protocol.h"
#include "switch.h"
#include "tools.h"
#include "users.h"

//Creer un tableau de handles pour 64 streams (1-64), pour un maximum
//de 100 adjacents par stream (ce qui semble largement suffisant).
static	mem_hand	NODE_hand[66][NODE_MAXANODE];

/*
NODE_hand permet d'accder au gestionnaire mmoire utilis pour grer la
configuration du reseau Cluster.

Chaque handle contient une structure tAnode.
La premiere structure contient l'indicatif du cluster.
La deuxieme le numero de version de ce cluster
La troisieme contient le usercount (PC50).
Les 64 suivantes contiennent les utilisateurs du cluster.

Un indicatif est limit  7 octets (y compris le caractres
TERMINAL NULL).
Le SSID est stock dans la variable char cSSID.
Le UserFlag est stocke dans la variable char cFlag (set/here, etc...)

Les clusters se suivent dans la table. Si un cluster est "delete", tous les
clusters situe apres dans la liste sont decales.

Les utilisateurs sont places, pour le serveur, a la position correspondant
au numero du stream sur lequel ils sont connectes. Pour les autres clusters,
chaque nouvel utilisateur est place  la premiere position disponible. Si
un utilisateur est deconnecte, les suivants ne sont pas decales.

Le stream 0 est utilis pour sauvegarder la configuration du serveur.
*/

int	NODE_iNodes,
	NODE_iLocalUsers,
	NODE_iTotalUsers,
	NODE_iMaxUsers;

extern int FirstStream;		//Dfinie dans SWITCH.CPP
extern int LastStream;		//Dfinie dans SWITCH.CPP

//---------------------------------------------------------------------------
//------ Initialiser les variables ------------------------------------------
//---------------------------------------------------------------------------
void NODE_init(void)
{
  int   index1;
  int   index2;
  FILE *fPtr;

  for(index1 = FirstStream; index1 <= LastStream; index1++)
  {
    for(index2 = 0; index2 < NODE_MAXANODE; index2++)
      NODE_hand[index1][index2] = 0;
  }/*End FOR*/

  NODE_newNode(0, "NOCALL", VERSION_INT, FLAG_DXNET);

  //Initialiser les variables users
  NODE_iNodes = 1;
  NODE_iLocalUsers = 0;
  NODE_iTotalUsers = 0;

  //Lire le MaxUsers
  fPtr = fopen(NODE_MAXUSERS, "rb");
  if( fPtr )
  {
    fread(&NODE_iMaxUsers, sizeof(NODE_iMaxUsers), 1, fPtr);
    fclose(fPtr);
  }
  else
    NODE_iMaxUsers = 0;
}

//---------------------------------------------------------------------------
//------ Isoler l'indicatif et le SSID --------------------------------------
//---------------------------------------------------------------------------
//L'indicatif AVEC SSID est place dans WithSSID
//La fonction retourne le SSID et copie dans WithoutSSID l'indicatif apres
//avoir enleve son SSID
int NODE_cutOffSsid(char * WithoutSSID, char * pszWithSSID)
{
  int 	iSSID;
  char  WithSSID[16];

  TOOLS_maxLength(pszWithSSID, 15);
  strcpy(WithSSID, pszWithSSID);

  //S'assurer qu'il y a bien un indicatif
  if ( WithSSID == NULL || *WithSSID == SNULL )
  {
    strcpy(WithoutSSID, "");
    return 0;
  }

  //Limiter la longueur a 12 caracteres (ex FD1MZN-15)
  TOOLS_maxLength(WithSSID, 9);

  strcpy(WithoutSSID, WithSSID);		//Pour bricoler l'indicatif sans toucher a l'original
  iSSID = TOOLS_whatSsid( WithoutSSID );	//Quel est le SSID ?
  TOOLS_removeSsid( WithoutSSID );		//L'enlever ...

  return iSSID;
}

//---------------------------------------------------------------------------
//------ Ajouter un nouvel adjacent -----------------------------------------
//---------------------------------------------------------------------------
//La fonction retourne TRUE si l'ajout du nouveau node a pu se faire,
//et FALSE sinon
int NODE_newNode(int StreamNum, char * NodeCall, int Version, char Flag)
{
  int	iFirstNodePos;
  int	index;
  char	sString[12];
//  int	iUserCount = 0;

  tANode * pANode;

  //S'assurer qu'il y a bien un indicatif
  if( NodeCall == NULL || *NodeCall == SNULL )
    return FALSE;

  /* Adresser un message aux utilisateurs locaux */
  USERS_sendNodeLoginAnnouncement(NodeCall, TRUE);

  //Rechercher le premier emplacement disponible pour ce nouveau cluster
  for(iFirstNodePos = 0; iFirstNodePos < NODE_MAXANODE; iFirstNodePos++)
  {
    if( NODE_hand[StreamNum][iFirstNodePos] == 0 )
      break;
  }

  //Un emplacement a t-il ete trouve ?
  if( iFirstNodePos == NODE_MAXANODE )
    return FALSE;	//Non, retour

  //Allouer un bloc memoire
  setXMstrat("XECV");		//Definit strategie d'allocation
  NODE_hand[StreamNum][iFirstNodePos] = xalloc(sizeof(*pANode), ANODE_MAX);

  //Allouer de la memoire sur le pointeur de structure
  pANode = (tANode *) xget(0, NODE_hand[StreamNum][iFirstNodePos]);
  memset(pANode, 0, sizeof(*pANode));

  //Stocker l'indicatif du nouvel adjacent
  pANode = (tANode *) xget(ANODE_CLUSTERPOS, NODE_hand[StreamNum][iFirstNodePos]);
  TOOLS_maxLength(NodeCall, 9);	//Par securite
  strcpy(sString, NodeCall);	//Pour pouvoir bricoler dans la chaine

  pANode->cSSID = (unsigned char) TOOLS_whatSsid( sString );
  strcpy(pANode->sCallSign, TOOLS_removeSsid( sString ));
  pANode->cFlag = Flag;

  xput((byte *) pANode,     ANODE_CLUSTERPOS, NODE_hand[StreamNum][iFirstNodePos]);

  //Initialiser la version du cluster
  pANode = (tANode *) xget(ANODE_VERSIONPOS, NODE_hand[StreamNum][iFirstNodePos]);
  sprintf(pANode->sCallSign, "%04d", Version);
  pANode->cSSID = 0;
  pANode->cFlag = 0;

  xput((byte *) pANode, ANODE_VERSIONPOS, NODE_hand[StreamNum][iFirstNodePos]);

  //Initialiser le usercount
  pANode = (tANode *) xget(ANODE_USERCOUNT, NODE_hand[StreamNum][iFirstNodePos]);
  memset(pANode, 0, sizeof(*pANode));
  xput((byte *) pANode, ANODE_USERCOUNT, NODE_hand[StreamNum][iFirstNodePos]);

  //Initialiser les blocs utilisateurs
  for(index = ANODE_FIRSTUSERPOS; index <= ANODE_LASTUSERPOS; index++)
  {
    pANode = (tANode *) xget(index, NODE_hand[StreamNum][iFirstNodePos]);
    memset(pANode, 0, sizeof(*pANode));
    xput((byte *) pANode, index, NODE_hand[StreamNum][iFirstNodePos]);
  }/*End FOR*/

  //Valider le mode X_FAST
  SetReadMode(NODE_hand[StreamNum][iFirstNodePos], X_FAST);

  //Updater le nombre de node
  NODE_iNodes++;

  return TRUE;	//Le node a pu etre ajoute
}

//---------------------------------------------------------------------------
//------ Effacer un adjacent ------------------------------------------------
//---------------------------------------------------------------------------
//La fonction retourne TRUE si le node a t trouv, et FALSE sinon
int NODE_deleteNode(int StreamNum, char * NodeCall)
{
  int	iNodePos;
  int	index;

  //Chercher l'indicatif du node
  iNodePos = NODE_searchNode(StreamNum, NodeCall);

  //A t-il ete trouve ?
  if( iNodePos == -1 )
    return FALSE;      //Non, retourner ...

  /* Adresser un message aux utilisateurs locaux */
  USERS_sendNodeLoginAnnouncement(NodeCall, FALSE);

  //Oui ! Liberer la memoire, l'effacer de la liste et decaller les suivants
  xfree( NODE_hand[StreamNum][iNodePos]);
  for(index = iNodePos; index < (NODE_MAXANODE - 1); index++)
    NODE_hand[StreamNum][index] = NODE_hand[StreamNum][index + 1];

  NODE_hand[StreamNum][index] = 0;

/*  //Updater NODE_iNodes
  NODE_iNodes--;*/

  //Updater la config du serveur
  NODE_setConfig();

  return TRUE;
}

//---------------------------------------------------------------------------
//------ Chercher un node dans la table -------------------------------------
//---------------------------------------------------------------------------
//La fonction retourne la position de la structure ou est memorisee le
//le node
//Si le node n'a pas ete trouve, la fonction retourne -1
//La fonction n'est pas capable de localiser l'indicatif du serveur
int NODE_searchNode(int StreamNum, char * NodeCall)
{
  int	iNodePos;
  int	iSSID;
  char	sNodeCall[10];

  tANode * pANode;

  //S'assurer qu'il y a bien un indicatif
  if( NodeCall == NULL || *NodeCall == SNULL )
    return -1;

  //Isoler l'indicatif et le SSID
  iSSID = NODE_cutOffSsid(sNodeCall, NodeCall);

  //Parcourir la table ...
  for(iNodePos = 0; iNodePos < NODE_MAXANODE; iNodePos++)
  {
    //Liste epuisee ?
    if( ! NODE_hand[StreamNum][iNodePos] )
      return -1;

    pANode = (tANode *) xget(ANODE_CLUSTERPOS, NODE_hand[StreamNum][iNodePos]);

    //Comparer ...
    if( ! strcmp(pANode->sCallSign, sNodeCall) && pANode->cSSID == (unsigned char) iSSID )
      return iNodePos;
  }/*End FOR*/

  return -1;
}

//---------------------------------------------------------------------------
//------ Retourne l'indicatif du node connect au stream --------------------
//---------------------------------------------------------------------------
char * NODE_getNodeCall(int StreamNum, int NodePos, char * NodeCall)
{
  tANode * pANode;

  if( NODE_hand[StreamNum][NodePos] )
  {
    //Recuperer le bloc
    pANode = (tANode *) xget(ANODE_CLUSTERPOS, NODE_hand[StreamNum][NodePos]);

    //Copier l'indicatif puis le SSID
    strcpy(NodeCall, pANode->sCallSign);

    if( pANode->cSSID )
      TOOLS_addSsid(NodeCall, (int) pANode->cSSID);
  }
  else
  {
    //Il n'y a personne !
    strcpy(NodeCall, "");
  }/*End IF*/

  return NodeCall;
}

//---------------------------------------------------------------------------
//------ Retourne la config du cluster --------------------------------------
//---------------------------------------------------------------------------
char NODE_getNodeFlag(int StreamNum, int NodePos)
{
  tANode * pANode;

  if( NODE_hand[StreamNum][NodePos] )
  {
    pANode = (tANode *) xget(ANODE_CLUSTERPOS, NODE_hand[StreamNum][NodePos]);
    return pANode->cFlag;
  }
  else
    return 0;
}

/*------------------------------------------------------------------------
  ------ Mettre a jour la config du cluster ------------------------------
  ------------------------------------------------------------------------*/
void NODE_setNodeFlag(int StreamNum, int nNodePos, unsigned char cFlag)
{
	tANode * pANode;

	if( ! NODE_hand[StreamNum][nNodePos] )
		return;

	pANode = (tANode *) xget(ANODE_CLUSTERPOS, NODE_hand[StreamNum][nNodePos]);
	pANode->cFlag = cFlag;
	xput((byte *) pANode, ANODE_CLUSTERPOS, NODE_hand[StreamNum][nNodePos]);
}

//---------------------------------------------------------------------------
//------ Retourne la version du cluster --------------------------------------
//---------------------------------------------------------------------------
char * NODE_getNodeVersion(int StreamNum, int NodePos, char * Version)
{
  tANode * pANode;

  if( NODE_hand[StreamNum][NodePos] )
  {
    pANode = (tANode *) xget(ANODE_VERSIONPOS, NODE_hand[StreamNum][NodePos]);
    strcpy(Version, pANode->sCallSign);	//Callsign est utilise pour memoriser le numero de version
  }
  else
    strcpy(Version, "");

  return Version;
}

//---------------------------------------------------------------------------
//------ Dfinir l'indicatif du serveur -------------------------------------
//---------------------------------------------------------------------------
void NODE_myNodeCall(char * NodeCall)
{
  char sString[10];
  tANode * pANode;

  //Pointeur sur le bloc memoire
  pANode = (tANode *) xget(ANODE_CLUSTERPOS, NODE_hand[0][0]);
  memset(pANode, 0, sizeof(*pANode));

  //Memoriser l'indicatif
  TOOLS_maxLength(NodeCall, 9);	//Par securite
  strcpy(sString, NodeCall);	//Pour pouvoir bricoler dans la chaine

  pANode->cSSID = (unsigned char) TOOLS_whatSsid( sString );
  strcpy(pANode->sCallSign, TOOLS_removeSsid( sString ));
  /*On ne touche au Flag*/

  xput((byte *) pANode, ANODE_CLUSTERPOS, NODE_hand[0][0]);

  //Redfinir l'indicatif du serveur
  SWITCH_setMyCall( NodeCall );
}

//---------------------------------------------------------------------------
//------ Ce node est-il dans les tables ------------------------------------
//---------------------------------------------------------------------------
//La fonction retourne TRUE si le node a ete trouve et FALSE sinon
//NodePos et StreamOfNode indiquent a la fonction appelante le position
//du node dans la table et le stream sur lequel il est connecte
//Si l'indicatif recherche est celui du serveur, NodePos = StreamOfNode = 0
//Fonction 1
int NODE_isNodeConnected(char * NodeCall, int * StreamOfNode, int * NodePos)
{
  int	iStream;
  int	iNodePos;
  int 	iSSID;
  char	sNodeCall[10];

  tANode * pANode;

  *StreamOfNode = *NodePos = 0;

  //S'assurer qu'il y a bien un indicatif
  if( NodeCall == NULL || *NodeCall == SNULL )
    return FALSE;

  //Isoler l'indicatif et le SSID
  iSSID = NODE_cutOffSsid(sNodeCall, NodeCall);

  //L'indicatif recherche est-il celui du serveur ?
  pANode = (tANode *) xget(ANODE_CLUSTERPOS, NODE_hand[0][0]);
  if( ! strcmp(pANode->sCallSign, sNodeCall) && pANode->cSSID == (unsigned char) iSSID)
    return TRUE;

  //Parcourir les streams
  for(iStream = FirstStream; iStream <= LastStream; iStream++)
  {
    for(iNodePos = 0; iNodePos < NODE_MAXANODE; iNodePos++)
    {
      //Sortir de la boucle si la liste de node a ete epuisee sur ce stream
      if( NODE_hand[iStream][iNodePos] == 0 )
	break;

      //Lire le buffer ...
      pANode = (tANode *) xget(ANODE_CLUSTERPOS, NODE_hand[iStream][iNodePos]);

      //Comparer ...
      if( ! strcmp(pANode->sCallSign, sNodeCall) && pANode->cSSID == (unsigned char) iSSID )
      {
	*StreamOfNode = iStream;
	*NodePos      = iNodePos;
	return TRUE;
      }
    }/*End FOR*/
  }/*End FOR*/

  //Le node n'a pas ete trouve
  return FALSE;
}

//--------------------------------------------------------------------------
//------ Ce node est-il dans les tables ------------------------------------
//--------------------------------------------------------------------------
//Foncion 2 (cf fonction precedente)
int NODE_isNodeConnected(char * NodeCall)
{
  int   iStreamOfNode;
  int	iNodePos;

  return NODE_isNodeConnected(NodeCall, &iStreamOfNode, &iNodePos);

}

/*---------------------------------------------------------------------------
 *------ Ajouter un utilisateur dans la table -------------------------------
 *---------------------------------------------------------------------------
 *La fonction retourne 0 si l'utilisateur a pu tre ajout dans la table
 *et un code d'erreur sinon
 *Code d'erreurs
 *--------------
 *	NODE_USER_NODEUNKOWN :	Node non trouve
 *	NODE_USER_FULL	     :  Plus de place disponible pour enregistrer l'utilisateur
 *	NODE_USER_DUPE	     :  L'utilisateur est deja connecte au node
 * 	NODE_USER_BADCALL    :  L'indicatif n'est pas correct
 *  NODE_USER_ADDOK      :  = 0 -> l'utilisateur a ete enregistre
 *StreamNum :       stream sur lequel est connecte le node - StreamNum est
 *  	            egal a 0 si c'est une connexion locale
 *ConnectedStream : stream sur lequel est connecte l'utilisateur local
 */
int NODE_newUser(int StreamNum, int ConnectedStream, char * NodeCall, char * UserCall, char Flag)
{
	int	iNodePos;
	int	iUserPos;
	char sUserCall[10];
	int	iUserSSID;
	tANode * pANode;

	/* Verifier qu'il y a bien des indicatifs */
	if( UserCall == NULL || *UserCall == SNULL )
		return 0;

	/* Isoler indicatifs et SSIDs du node et de l'utilisateur */
	iUserSSID = NODE_cutOffSsid(sUserCall, UserCall);

	/* Rechercher la position du node ... */
	if( StreamNum != 0 )	//sauf si c'est un utilisateur local
	{
		/* Utilisateur connecte sur un node du reseau cluster ... */
		iNodePos = NODE_searchNode(StreamNum, NodeCall);

		if( iNodePos == -1 )
			return NODE_USER_NODEUNKOWN;
	}
	else
	{
		/* Connexion d'un utilisateur local ... */
		iNodePos = 0;
	}

	/* Indiquer que ce n'est pas un link external pour la gestion des usercount */
	pANode = (tANode *) xget(ANODE_USERCOUNT, NODE_hand[StreamNum][iNodePos]);
	pANode->cFlag = TRUE;
	xput((byte *) pANode, ANODE_USERCOUNT, NODE_hand[StreamNum][iNodePos]);

	/* Verifier que c'est utilisateur n'est pas deja connecte sur ce node */
	for(iUserPos = ANODE_FIRSTUSERPOS; iUserPos <= ANODE_LASTUSERPOS; iUserPos++)
	{
		pANode = (tANode *) xget(iUserPos, NODE_hand[StreamNum][iNodePos]);

		if( ! strcmp(pANode->sCallSign, sUserCall) && pANode->cSSID == (unsigned char) iUserSSID )
			return NODE_USER_DUPE;
	}

	/*
	 * Rechercher un emplacement disponible pour enregistrer cet utilisateur 
	 * (sauf si c'est une connexion locale, auquel cas, la position de 
	 * l'utilisateur correspond au stream sur lequel il est connecte)
	 */
	if( StreamNum == 0 )
	{
		iUserPos = ConnectedStream + ANODE_USEROFFSET;
	}
	else
	{
		/* Balayer la table */
		for(iUserPos = ANODE_FIRSTUSERPOS; iUserPos <= ANODE_LASTUSERPOS; iUserPos++)
		{
			pANode = (tANode *) xget(iUserPos, NODE_hand[StreamNum][iNodePos]);

			if( *pANode->sCallSign == SNULL )
				break; /* Emplacement vide trouve */
		}
	}

	/* Un emplacement vide a t-il ete trouve ? */
	if( iUserPos == ANODE_MAX )
		return NODE_USER_FULL;	/* Non */

	/* Memoriser cet utilisateur */
	pANode = (tANode *) xget(iUserPos, NODE_hand[StreamNum][iNodePos]);
	strcpy(pANode->sCallSign, sUserCall);
	pANode->cSSID = (unsigned char) iUserSSID;
	pANode->cFlag = Flag;
	xput((byte *) pANode, iUserPos, NODE_hand[StreamNum][iNodePos]);

	/* Updater le nombre d'utilisateurs */
	NODE_iTotalUsers++;
	if( StreamNum == 0 )	/* Connexion locale */
		NODE_iLocalUsers++;
	NODE_iMaxUsers = NODE_setMaxUsers(NODE_iTotalUsers);

	return NODE_USER_ADDOK;
}

//---------------------------------------------------------------------------
//------ Effacer un utilisateur de la table ---------------------------------
//---------------------------------------------------------------------------
//Si c'est un utilisateur local, NodeCall est egal a "".
//La fonction retourne 0 si l'utilisateur a pu tre enlev, et un code d'erreur sinon
int NODE_deleteUser(int StreamNum, char * NodeCall, char * UserCall)
{
  int	iNodePos;
  int	iUserPos;
  char	sUserCall[10];
  int	iUserSSID;

  tANode * pANode;

  //Verifier qu'il y a bien des indicatifs
  if( UserCall == NULL || *UserCall == SNULL )
    return 0;

  //Isoler indicatifs et SSIDs du node et de l'utilisateur
  iUserSSID = NODE_cutOffSsid(sUserCall, UserCall);

  //Rechercher la position du node ...
  if( *NodeCall != SNULL )	//sauf si c'est un utilisateur local
  {
    //Utilisateur connecte sur un node du reseau cluster ...
    //Rechercher la position du node
    iNodePos = NODE_searchNode(StreamNum, NodeCall);

    if( iNodePos == -1 )
      return NODE_USER_NODEUNKOWN;

    //Rechercher la position de cet utilisateur dans la table
    for(iUserPos = ANODE_FIRSTUSERPOS; iUserPos <= ANODE_LASTUSERPOS; iUserPos++)
    {
      pANode = (tANode *) xget(iUserPos, NODE_hand[StreamNum][iNodePos]);

      if( ! strcmp(pANode->sCallSign, sUserCall) && pANode->cSSID == (unsigned char) iUserSSID )
	break;
    }/*End FOR*/

    //L'utilisateur a t-il ete trouve ?
    if( iUserPos == ANODE_MAX )
      return NODE_USER_USERUNKOWN;
  }
  else
  {
    //Comme c'est un utilisateur local ...
    iUserPos = StreamNum + ANODE_USEROFFSET;
    StreamNum = iNodePos = 0;
  }

  //Acceder au buffer
  pANode = (tANode *) xget(iUserPos, NODE_hand[StreamNum][iNodePos]);

  //Supprimer cet utilisateur et updater le buffer en memoire
  memset(pANode, 0, sizeof(*pANode));
  xput((byte *) pANode, iUserPos, NODE_hand[StreamNum][iNodePos]);

  //Updater
  NODE_iTotalUsers--;
  if( *NodeCall == SNULL )	//Est ce un utilisateur local ?
    NODE_iLocalUsers--;

  return NODE_USER_DELETEOK;
}

/*------------------------------------------------------------------------
  ------ Retourne l'indicatif de l'utilisateur connect ------------------
  ------------------------------------------------------------------------*/
char * NODE_getUserCall(int StreamOfNode, int NodePos, int UserPos, char * UserCall)
{
	tANode * pANode;

	if( UserPos == 65 )	/* Console F2 */
	{
		if( StreamOfNode == 0 )
			return NODE_getNodeCall(0, 0, UserCall);
		else
		{
			strcpy(UserCall, "");
			return UserCall;
		}
	}

	if( NODE_hand[StreamOfNode][NodePos] )
	{
		pANode = (tANode *) xget(UserPos + ANODE_USEROFFSET,
			NODE_hand[StreamOfNode][NodePos]);

		/* Ya kekun ? */
		if( *pANode->sCallSign )
		{
			/* Recuperer l'indicatif de l'utilisateur ... */
			strcpy(UserCall, pANode->sCallSign);

			if( pANode->cSSID )
				TOOLS_addSsid(UserCall, (int) pANode->cSSID);
		}
		else
			strcpy(UserCall, "");
	}
	else
		strcpy(UserCall, ""); /* Ce node n'existe pas a l'emplacement prevu */

	return UserCall;
}

//---------------------------------------------------------------------------
//------ Retourne la config de l'utilisateur --------------------------------
//---------------------------------------------------------------------------
//Fontion 1
//la fonction retourne 0 si l'utilisateur n'a pas ete trouve
char NODE_getUserFlag(int StreamOfNode, int NodePos, int UserPos)
{
  tANode * pANode;

  if( NODE_hand[StreamOfNode][NodePos] )
  {
    pANode = (tANode *) xget(UserPos + ANODE_USEROFFSET, NODE_hand[StreamOfNode][NodePos]);
    return pANode->cFlag;
  }
  else
    return 0;
}

//---------------------------------------------------------------------------
//------ Retourne la config de l'utilisateur --------------------------------
//---------------------------------------------------------------------------
//Fonction 2
//La fonction retourne 0 si l'utilisateur n'a pas ete trouve
char NODE_getUserFlag(char * NodeCall, char * UserCall)
{
  int 	iStreamOfNode;
  int   iNodePos;
  int	iUserPos;

  tANode * pANode;

  //Chercher l'utilisateur
  if( ! NODE_searchUser(NodeCall, UserCall, NODE_CHECKSSID_YES, &iStreamOfNode, &iNodePos, &iUserPos) )
    return 0;	//L'utilisateur n'a pas ete trouve

  pANode = (tANode *) xget(iUserPos, NODE_hand[iStreamOfNode][iNodePos] );
  return pANode->cFlag;
}

//---------------------------------------------------------------------------
//------ Modifie la config d'un utilisateur ---------------------------------
//---------------------------------------------------------------------------
//La fonction retourne TRUE si l'utilisateur a pu tre trouv, et FALSE sinon
int NODE_setUserFlag(char * NodeCall, char * UserCall, char Flag)
{
  int	iStreamOfNode;
  int	iNodePos;
  int	iUserPos;

  tANode * pANode;

  //Chercher l'utilisateur
  if( ! NODE_searchUser(NodeCall, UserCall, NODE_CHECKSSID_YES, &iStreamOfNode, &iNodePos, &iUserPos) )
    return FALSE;	//L'utilisateur n'a pas ete trouve

  //Recuperer le bloc
  pANode = (tANode *) xget(iUserPos, NODE_hand[iStreamOfNode][iNodePos] );

  //Modifier et updater le bloc
  pANode->cFlag = Flag;
  xput((byte *) pANode, iUserPos, NODE_hand[iStreamOfNode][iNodePos]);

  return TRUE;
}

//---------------------------------------------------------------------------
//------ Chercher le stream, la position du node et la position d'un --------
//------ utilisateur dans les tables ----------------------------------------
//---------------------------------------------------------------------------
//Fonction 1
//la fonction retourne TRUE si l'utilisateur a ete trouve et FALSE sinon
int NODE_searchUser(char * NodeCall, char * UserCall, int CheckSSID, int * StreamOfNode, int * NodePos, int * UserPos)
{
  int	iStreamOfNode;
  int	iNodePos;
  int	iUserPos;
  int	iUserSSID;
  char	sUserCall[10];

  tANode * pANode;

  //Verifier qu'il y a bien des indicatifs
  if( NodeCall == NULL || *NodeCall == SNULL ||
      UserCall == NULL || *UserCall == SNULL )
    return FALSE;		//Erreur sur indicatif(s)

  //Rechercher la position du node
  if( ! NODE_isNodeConnected(NodeCall, &iStreamOfNode, &iNodePos ) )
    return FALSE;		//Le node n'a pas ete trouve

  //Isoler indicatif et SSID de l'utilisateur ...
  iUserSSID = NODE_cutOffSsid(sUserCall, UserCall);

  //Rechercher l'indicatif dans la table ...
  for(iUserPos = ANODE_FIRSTUSERPOS; iUserPos <= ANODE_LASTUSERPOS; iUserPos++)
  {
    pANode = (tANode *) xget(iUserPos, NODE_hand[iStreamOfNode][iNodePos] );

    //Comparer ...
    if( ! strcmp(pANode->sCallSign, sUserCall) )
    {
      //Indicatif localise - verifier le SSID le cas echeant
      if( CheckSSID == NODE_CHECKSSID_NO || pANode->cSSID == (unsigned char) iUserSSID )
      {
	*StreamOfNode = iStreamOfNode;
	*NodePos      = iNodePos;
	*UserPos      = iUserPos;

	return TRUE;
      }/*End IF*/
    }/*End IF*/
  }/*End FOR*/

  //L'utilisateur n'a pas ete trouve
  return FALSE;
}

/*--------------------------------------------------------------------------
  ------ Search a connected user -------------------------------------------
  --------------------------------------------------------------------------
  WARNING : UserCall can be changed -> ssid is added if needed
  Return : return the user stream number
  This function copy the user ClusterCallsign in NodeCall
  If the user is locally connected, the function copies "" in NodeCall
  This function returns 0 if UserCall is not connected anywhere
  A cluster acts as a user by this station
*/
int NODE_searchUser(char * UserCall, int CheckSSID, char * NodeCall)
{
	int iStreamOfNode;
    int iNodePos;
    int iUserPos;
	char sCallSign[10];
	int iSSID;
	tANode* pANode;

	/* Check UserCall */
	if( UserCall == NULL || *UserCall == SNULL )
		return 0;

	/* get user_call (without ssid) and ssid if any */
	iSSID = NODE_cutOffSsid(sCallSign, UserCall);

	/* Scan tables */
	for(iStreamOfNode = 0; iStreamOfNode <= LastStream; iStreamOfNode++)
	{
		for(iNodePos = 0; iNodePos < NODE_MAXANODE; iNodePos++)
		{
			if( NODE_hand[iStreamOfNode][iNodePos] == 0 )
				break;	/* List ended */

			/* Scan all structures */
			for(iUserPos = ANODE_FIRSTUSERPOS; iUserPos <= ANODE_LASTUSERPOS; iUserPos++)
			{
				pANode = (tANode *) xget(iUserPos, NODE_hand[iStreamOfNode][iNodePos]);

				if( ! strcmp(pANode->sCallSign, sCallSign) )
				{
					if( CheckSSID == NODE_CHECKSSID_NO || pANode->cSSID == (unsigned char) iSSID )
					{
						/* For pavillon's : add ssid to the user call */
							if( pANode->cSSID != 0 && iSSID == 0 )
								TOOLS_addSsid(UserCall, (int) pANode->cSSID);

						/* Bingo !! */
						/* Get NodeCall */
						pANode = (tANode *) xget(ANODE_CLUSTERPOS, NODE_hand[iStreamOfNode][iNodePos]);

						if( iStreamOfNode != 0 )	/* local user ? */
						{
							/* no */
							strcpy(NodeCall, pANode->sCallSign);
							TOOLS_addSsid(NodeCall, (int) pANode->cSSID);
							return iStreamOfNode;
						}
						else
						{
							/* yes */
							strcpy(NodeCall, "");
							return( iUserPos - ANODE_USEROFFSET );
						}
					}
				}
			}/*End FOR*/

			/* Check if it is not mynodecall */
			pANode = (tANode *) xget(ANODE_CLUSTERPOS, NODE_hand[iStreamOfNode][iNodePos]);

			if( ! strcmp(pANode->sCallSign, sCallSign) )
			{
				if( CheckSSID == NODE_CHECKSSID_NO || pANode->cSSID == (unsigned char) iSSID )
				{
					/* Bingo ! */
					/* Is it for me ? */
					if( iStreamOfNode != 0 )
					{
						strcpy(NodeCall, pANode->sCallSign);
						TOOLS_addSsid(NodeCall, (int) pANode->cSSID);
					}
					else
					{
						strcpy(NodeCall, "");
						iStreamOfNode = 65;		/* display on SCREEN F2 */
					}
					return iStreamOfNode;
				}
			}
		}/*End FOR*/
	}/*End FOR*/

	/* user not found */
	return 0;
}

//---------------------------------------------------------------------------
//------ Retourner la config du serveur -------------------------------------
//---------------------------------------------------------------------------
void NODE_getConfig(int & Nodes, int & LocalUsers, int & TotalUsers, int & MaxUsers)
{
  int	iStreamOfNode;
  int	iNodePos;
  int	iUserPos;
  int	iDone;

  tANode * pANode;

  LocalUsers = TotalUsers = Nodes = MaxUsers = 0;


  //Balayer la table ...
  //Commencer sur le stream 0 (config locale egalement)
  for(iStreamOfNode = 0; iStreamOfNode <= LastStream; iStreamOfNode++)
  {
    for(iNodePos = 0; iNodePos < NODE_MAXANODE; iNodePos++)
    {
      //Y a t-il un cluster sur ce handle ?
      if( NODE_hand[iStreamOfNode][iNodePos] )
      {
	Nodes++;

	//Determiner le nombre d'utilisateurs sur ce node
	iDone = FALSE;
	for(iUserPos = ANODE_FIRSTUSERPOS; iUserPos <= ANODE_LASTUSERPOS; iUserPos++)
	{
	  pANode = (tANode *) xget(iUserPos, NODE_hand[iStreamOfNode][iNodePos]);

	  if( *pANode->sCallSign )
	  {
	    iDone = TRUE;
	    TotalUsers++;

	    if( iStreamOfNode == 0 )	//Connexion locales
	      LocalUsers++;
	  }
	}/*End FOR*/

	if( iDone == FALSE )
	{
	  pANode = (tANode *) xget(ANODE_USERCOUNT, NODE_hand[iStreamOfNode][iNodePos]);
	  if( pANode->cFlag == FALSE )
	    TotalUsers += atoi (pANode->sCallSign);
	}
      }
      else
	break;
    }/*End FOR*/
  }/*End FOR*/

  //Updater les variables globales
  NODE_iNodes 		= Nodes;
  NODE_iLocalUsers 	= LocalUsers;
  NODE_iTotalUsers 	= TotalUsers;

  //Updater le maxusers
  MaxUsers = NODE_setMaxUsers( TotalUsers );
}

//---------------------------------------------------------------------------
//------ Dfinir le nombre maximum d'utilisateurs ---------------------------
//---------------------------------------------------------------------------
int NODE_setMaxUsers(int MaxUsers)
{
  //Faut-il updater (le nouveau maxusers est-il suprieur  l'ancien) ?
  if( MaxUsers > NODE_iMaxUsers )
  {
    FILE *fPtr;

    NODE_iMaxUsers = MaxUsers;

    fPtr = fopen(NODE_MAXUSERS, "wb");
    if( fPtr )
    {
      fwrite(&NODE_iMaxUsers, sizeof(NODE_iMaxUsers), 1, fPtr);
      fclose(fPtr);
    }/*End IF*/
  }/*End IF*/

  return NODE_iMaxUsers;
}

//---------------------------------------------------------------------------
//------ Mettre  jour la configuration du cluster --------------------------
//---------------------------------------------------------------------------
void NODE_setConfig(void)
{
  int	iNodes,
	iLocalUsers,
	iTotalUsers,
	iMaxUsers;

  NODE_getConfig(iNodes, iLocalUsers, iTotalUsers, iMaxUsers);
}

//---------------------------------------------------------------------------
//------ Retourner le nombre d'utilisateurs sur un adjacent -----------------
//---------------------------------------------------------------------------
int NODE_getUserCount(int iStreamOfNode, char * NodeCall)
{
  int	iNodePos;
  int	iUserCount = 0;
  int	iDone = FALSE;
  tANode * pANode;


  /*Ne pas autoriser la gestion des usercount pour le serveur lui meme*/
  if( iStreamOfNode == 0 )
  	return 0;		

  iNodePos = NODE_searchNode(iStreamOfNode, NodeCall);

  if( iNodePos == -1 )
    return 0;		//Le cluster n'a pas ete trouve

  //Y a t-il un cluster sur ce handle ?
  if( NODE_hand[iStreamOfNode][iNodePos] )
  {
    int iUserPos;

    //Determiner le nombre d'utilisateurs sur ce node
    iDone = FALSE;
    for(iUserPos = ANODE_FIRSTUSERPOS; iUserPos <= ANODE_LASTUSERPOS; iUserPos++)
    {
      pANode = (tANode *) xget(iUserPos, NODE_hand[iStreamOfNode][iNodePos]);
      if( *pANode->sCallSign )
      {
	iDone = TRUE;
	iUserCount++;
      }
    }/*End FOR*/
  }

  if( iDone == FALSE ) 	/*Aucun utilisateurs connectes - retourner le dernier PC50*/
  {
    pANode = (tANode *) xget(ANODE_USERCOUNT, NODE_hand[iStreamOfNode][iNodePos]);
    if( pANode->cFlag == FALSE )
      iUserCount = atoi (pANode->sCallSign);
  }

  return iUserCount;
}

//---------------------------------------------------------------------------
//------ Sauvegarder le PC50 ------------------------------------------------
//---------------------------------------------------------------------------
//On utilise pANode->sCallsign pour sauvegarder, sous forme de chaine, la
//valeur
//cFlag est mis a 1 lorsqu'au cours des init il y a eu au moins un PC16
//provenant du cluster. Cela signifie que ce n'est pas un external et qu'il
//ne faut pas prendre en compte le PC50
void NODE_setUserCount(int iStreamOfNode, char * NodeCall, int iUserCount)
{
  int	iNodePos;
  tANode * pANode;


  /*Ne pas autoriser la gestion du usercount pour le cluster lui-meme*/
  if( iStreamOfNode == 0 )
  	return;

  iNodePos = NODE_searchNode(iStreamOfNode, NodeCall);

  if( iNodePos == -1 )
    return;		//Le cluster n'a pas ete trouve

  if( iUserCount < 0 || iUserCount > 32766 )
    iUserCount = 0;

  //Acceder a la structure
  pANode = (tANode *) xget(ANODE_USERCOUNT, NODE_hand[iStreamOfNode][iNodePos]);
  sprintf(pANode->sCallSign, "%d", iUserCount);
  xput((byte *) pANode, ANODE_USERCOUNT, NODE_hand[iStreamOfNode][iNodePos]);

  //Mettre a jour les datas pour l'affichage de la baniere
  NODE_setConfig ();
}
