#include <alloc.h>
#include <stdio.h>
#include <stdlib.h>
#include "params.h"
#include "define.h"

//-------------------------------------------------------------------------
//------ Variables globales -----------------------------------------------
//-------------------------------------------------------------------------

char* PARAMS_adjacentNodes;
char* PARAMS_sysop;
char* PARAMS_blackCalls;
char* PARAMS_ssid;
char* PARAMS_bbs;
char* PARAMS_hideUsers;

long PARAMS_lTz = 0L;

int	PARAMS_iDefaultDiddle = -1;
int	PARAMS_iSetDxSsid     = 0;
int	PARAMS_nCFilter       = 0;
	/* 0 : Pas de filtre de connexion
	   1 : Filtre de connexion actif / Systeme ferme
	   2 : Filtre de connexion actif / Read Only*/
int PARAMS_nCFilterNoAnnoucements = FALSE;

int	PARAMS_nIsMonitorOn = TRUE;

long PARAMS_lDxRejectBefore  = 1800L;	/* secondes */
long PARAMS_lDxRejectAfter   = 900L;
long PARAMS_lAnnDupeAllowed  = 86400L;	/* secondes */
long PARAMS_lMailReject	     = 2592000L;/* secondes */

long PARAMS_userBuffTimeout	 = 1200L;	/* secondes */
long PARAMS_userPageTimeout  = 300L;	/* secondes */

char PARAMS_nNTWULogin		= FALSE;	/* Enregistre les login des utilisateurs sur les adjacents */

char PARAMS_nUpdateConfig   = FALSE;	/* Est TRUE lorsqu'un UPDATE/CONFIG est en cours */

#ifndef DOS
char PARAMS_cVerboseConsole = FALSE;
#endif

/* Initialisation des parametres du node */
void PARAMS_init(void)
{
	static int initialized = FALSE;

	if( initialized == FALSE )
	{
		PARAMS_adjacentNodes	= (char*) malloc(512);
		PARAMS_sysop			= (char*) malloc(256);
		PARAMS_blackCalls		= (char*) malloc(256);
		PARAMS_ssid				= (char*) malloc(256);
		PARAMS_bbs				= (char*) malloc(256);
		PARAMS_hideUsers		= (char*) malloc(256);

		if( ! PARAMS_adjacentNodes ||
			! PARAMS_sysop         ||
			! PARAMS_blackCalls    ||
			! PARAMS_ssid          ||
			! PARAMS_bbs		   ||
			! PARAMS_hideUsers	)
		{
			printf("*** Error in PARAMS.CPP : not enough memory to allocate buffers.\n");
			exit(EXIT_FAILURE);
		}

		initialized = TRUE;
	}

	*PARAMS_adjacentNodes = SNULL;
	*PARAMS_sysop		= SNULL;
	*PARAMS_blackCalls	= SNULL;
	*PARAMS_ssid		= SNULL;
	*PARAMS_bbs			= SNULL;
	*PARAMS_hideUsers	= SNULL;
}

