#include <alloc.h>
#include <dir.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "password.h"
#include "define.h"
#include "tools.h"
#include "users.h"
#include "buffers.h"
#include "node.h"

extern	tUserCfg * pUserCfg;

//--------------------------------------------------------------------------
//------ Envoyer la cle  l'utilisateur -----------------------------------
//--------------------------------------------------------------------------
//La retourne TRUE si la cle a pu tre transmise, et FALSE sinon
int PASSWORD_sendKey(int StreamNum, char * CallSign)
{
  char	sPass[256];
  char	sNodeCall[11];
  int	index;
  int	iPos;
  time_t t;

  //Accder  la config de l'utilisateur
  USERS_getRecord (StreamNum);

  //Quel est le password ?
  if( ! PASSWORD_getPass(CallSign, sPass) )
    return FALSE;	/*Password introuvable*/

  //Initialiser le gnrateur de nombres alatoires
  srand((unsigned) time(&t));

  //Pour respecter le format standard ...
  BUFFERS_printBuff(StreamNum, OUT, "%s> ", NODE_getNodeCall(0, 0, sNodeCall));

  //Lire 5 caractres alatoirement
  for(index = 0; index < 5; index++)
  {
    //Gnrer un nombre alatoire de position dans la chaine
    iPos = rand() % strlen(sPass);

    //Envoyer la position  l'utilisateur et mmoriser le caractre
    BUFFERS_printBuff(StreamNum, OUT, "%d ", iPos + 1);
    pUserCfg->sPassword[index] = sPass[iPos];
  }/*End FOR*/

  pUserCfg->sPassword[5] = SNULL;

  /* Envoyer la clef */
  /* 15-05-2000 : Support MD5 */
  BUFFERS_printBuff(StreamNum, OUT, "[%010ld]\n", t);
  pUserCfg->MD_Key = t;
//  sprintf(sKey, "%010ld%s", t, sPass);
//  MD2String((unsigned char*)pUserCfg->sMD2, (unsigned char*) sKey);

  //Updater la config utilisateur
  USERS_updateLocalConfig(StreamNum);

  return TRUE;
}

//--------------------------------------------------------------------------
//------ Acceder a la chaine -----------------------------------------------
//--------------------------------------------------------------------------
int PASSWORD_getPass(char * pszCallSign, char * pszPass)
{
  FILE * fPtr;
  char * pPtr;
  char   szUserCall[16];
  char	 szLine[256];


  /*Ouvrir le fichier password*/
  fPtr = fopen(PASSWORD_FILE, "rt");

  if( ! fPtr )
  {
    perror("fopen in PASSWORD_sendKey");
    return FALSE;	/*Le fichier n'a pas pu tre ouvert*/
  }/*End IF*/

  /*Chercher l'indicatif de l'utilisateur dans le fichier*/
  strcpy(szUserCall, pszCallSign);
  TOOLS_removeSsid (szUserCall);
  for(;;)
  {
    /*Lire une ligne dans le fichier*/
    if( ! fgets(szLine, 255, fPtr) )
    {
      fclose (fPtr);
      return FALSE;	/*Fin de fichier atteinte / indicatif non trouve*/
    }

    TOOLS_removeNR (szLine);

    /*Isoler l'indicatif dans la chaine lue ...*/
    pPtr = szLine;
    while( *pPtr != ' ' && *pPtr != '\t' && *pPtr != SNULL )
      pPtr++;

    if( *pPtr == SNULL )
    {
      fclose (fPtr);
      return FALSE;	/*Mot de passe inexistant ...*/
    }

    *pPtr = SNULL;
    strupr (szLine);		/*Pour etre en rapport avec szUserCall*/
    TOOLS_removeSsid (szLine);  /*Normallement inutile ...*/

    /*Est-ce le bon indicatif ?*/
    if( ! strcmp(szUserCall, szLine) )
    {
      /*OUI - Passer les espaces qui separent l'indicatif du password*/
      pPtr++;
      while( *pPtr == ' ' && *pPtr != SNULL )
	pPtr++;

      if( *pPtr == SNULL )
      {
	fclose (fPtr);
	return FALSE;		/*Mot de passe inexistant ...*/
      }

      /*Tout est OK, quitter la boucle*/
      strcpy(pszPass, pPtr);
      fclose (fPtr);
      return TRUE;
    }/*End IF*/
  }/*End LOOP*/
}

/*-----------------------------------------------------------------------
  ------ Enlever un utilisateur de la base de donnees des passwds -------
  -----------------------------------------------------------------------
  Retourne TRUE si ok                                                    */
int PASSWORD_noRegister(char* pszCallSign)
{
	FILE *fSrc, *fDest;
	char  szBuffer[1024];
	char  szCallSign[256];
	char* ptr;
	int   nDone = FALSE;

	if( pszCallSign == NULL || *pszCallSign == SNULL )
		return FALSE;
	strcpy(szCallSign, pszCallSign);
	strupr(szCallSign);

	/* First create a bak file */
	TOOLS_makeBak(PASSWORD_FILE);

	/* Ouvrir les fichiers src et dest */
	strcpy(szBuffer, PASSWORD_FILE);
	ptr = strchr(szBuffer, '.');
	if( ptr == NULL )
		return FALSE;
	strcpy(ptr, ".bak");

	fSrc = fopen(szBuffer, "rt");
	if( !fSrc )
	{
		perror("fopen in PASSWORD_noRegister (1)");
		return FALSE;
	}

	fDest = fopen(PASSWORD_FILE, "wt");
	if( ! fDest )
	{
		perror("fopen in PASSWORD_noRegister (2)");
		fclose(fSrc);
		return FALSE;
	}

	while( fgets(szBuffer, sizeof(szBuffer), fSrc) )
	{
		char szField[1024];

		if( sscanf(szBuffer, "%s", szField) != 1 )
			continue;

		strupr(szField);
		if( ! strcmp(szField, szCallSign) )
		{
			nDone = TRUE;
			continue;
		}

		fputs(szBuffer, fDest);
	}

	fclose(fDest);
	fclose(fSrc);
	return nDone;
}

/*-----------------------------------------------------------------------
  ------ Voir le contenu du fichier passwd.dat --------------------------
  -----------------------------------------------------------------------
  Si callsign est vide (ou NULL), la fonction montre l'integralalite du
  fichier
  Retourne TRUE si OK                                                    */
int PASSWORD_showFile(int StreamNum, char* pszCallSign)
{
	FILE* fPtr;
	char szCallSign[256];
	char szBuffer[1024];
	int  nDone = FALSE;
	int  nLen = 0;

	if( pszCallSign != NULL )
	{
		strcpy(szCallSign, pszCallSign);
		strupr(szCallSign);
                nLen = strlen(szCallSign);
	}
	else
		*szCallSign = SNULL;

	fPtr = fopen(PASSWORD_FILE, "rt");
	if( !fPtr )
	{
		perror("fopen in PASSWORD_showFile");
		return FALSE;
	}

	while( fgets(szBuffer, sizeof(szBuffer), fPtr) )
	{
		char szField[1024];

		if( sscanf(szBuffer, "%s", szField) != 1 )
			continue;

		strupr(szField);

		if( *szCallSign == SNULL || ! strncmp(szCallSign, szField, nLen) )
		{
			char* pszField1;
			char* pszField2;

			pszField1 = strtok(szBuffer, "\t ");
			pszField2 = strtok(NULL, "\t\r\n ");

			nDone = TRUE;

			if( pszField1 && pszField2 )
			{
                        	strupr(pszField1);
				BUFFERS_printBuff(StreamNum, OUT,
					"%-11s %s\n", pszField1, pszField2);
			}
		}
	}

	fclose(fPtr);
	return nDone;
}


/*-----------------------------------------------------------------------
  ------ Ajouter un utilisateur dans la base de donnees des passwds -----
  -----------------------------------------------------------------------
  Retourne TRUE si OK                                                    */
int PASSWORD_register(char* pszCallSign, char* pszKey)
{
	FILE* fPtr;
	char  szCallSign[1024];

	if( pszCallSign == NULL || *pszCallSign == SNULL )
		return FALSE;

	if( pszKey == NULL || *pszKey == SNULL )
		return FALSE;

	strcpy(szCallSign, pszCallSign);
	strupr(szCallSign);

	/* First remove the callsign if it already exists */
	PASSWORD_noRegister(pszCallSign);

	/* Now add the new entry to the end of the passwd file */
	fPtr = fopen(PASSWORD_FILE, "a+t");
	if( !fPtr )
	{
		perror("fopen in PASSWORD_showFile");
		return FALSE;
	}

	fprintf(fPtr, "%s %s\n", szCallSign, pszKey);

	fclose(fPtr);
	return TRUE;
}

/*-----------------------------------------------------------------------
  ------ Verifier le password pour un utilisateur -----------------------
  -----------------------------------------------------------------------*/
int PASSWORD_verify(int StreamNum, char * pszRcvdPass)
{
	char	szKey[300];
	char	szPass[300];
	char	szMDString[40];
	char	szCallSign[16];
	extern char 	STREAMS_callsign[MAX_STREAMS][10];

	/*Acceder a la config de l'utilisateur */
	USERS_getRecord(StreamNum);

	/* Indicatif du l'utilisateur */
	strcpy(szCallSign, STREAMS_callsign[StreamNum]);

	/* Lire la chaine password dans le fichier de passwd */
	if( ! PASSWORD_getPass(szCallSign, szPass) )
		return FALSE;	/* Pas de chaine ... */

	/* Creer la chaine MD2/MD5 */
	sprintf(szKey, "%010ld%s", pUserCfg->MD_Key, szPass);

	/* Tester MD5 */
	PASSWORD_MD5String((unsigned char*) szMDString, (unsigned char*) szKey);
	if( ! stricmp(szMDString, pszRcvdPass) )
		return TRUE;

	/* Tester MD2 */
	PASSWORD_MD2String((unsigned char*) szMDString, (unsigned char*) szKey);
	if( ! stricmp(szMDString, pszRcvdPass) )
		return TRUE;

	if( ! strcmp(pUserCfg->sPassword, pszRcvdPass) )
		return TRUE;

	return FALSE;	/* Erreur, non accepte */
}

/*-----------------------------------------------------------------------
  ------ Verifier la validite d'un pass MD2/MD5 -------------------------
  -----------------------------------------------------------------------
  Retourne TRUE si OK
*/
int PASSWORD_isMDKeyOK(char * pszCall, char * pszRcvdPass, time_t MD_Key)
{
	char szKey[300];
	char szPass[300];
	char szMDString[40];
	
	/* Lire la chaine password dans le fichier de passwd */
	if( ! PASSWORD_getPass(pszCall, szPass) )
		return FALSE;	/* Pas de chaine ... */
	
	/* Creer la chaine MD2/MD5 */
	sprintf(szKey, "%010ld%s", MD_Key, szPass);
	
	/* Tester MD5 */
	PASSWORD_MD5String((unsigned char*) szMDString, (unsigned char*) szKey);
	if( ! stricmp(szMDString, pszRcvdPass) )
		return TRUE;

	/* Tester MD2 */
	PASSWORD_MD2String((unsigned char*) szMDString, (unsigned char*) szKey);
	if( ! stricmp(szMDString, pszRcvdPass) )
		return TRUE;
		
	return FALSE;	
}

#define PROTOTYPES 1
extern "C" {
#include "md2.h"
#include "md5.h"
};


/*-----------------------------------------------------------------------
  ------ Calcule une clef MD5 -------------------------------------------
  -----------------------------------------------------------------------
  Extrait de mbl_sys.c (bbs f6fbb)                                       */
void PASSWORD_MD5String (unsigned char *dest, unsigned char *source)
{
	int i;
	MD5_CTX context;
	unsigned char digest[16];
	unsigned int len = strlen ((char*)source);

	MD5Init (&context);
	MD5Update (&context, source, len);
	MD5Final (digest, &context);

	*dest = '\0';

	for (i = 0; i < 16; i++)
	{
		char tmp[5];

		sprintf (tmp, "%02X", (int) digest[i]);
		strcat ((char*) dest, (char*) tmp);
	}
}


/*-----------------------------------------------------------------------
  ------ Calcule une clef MD2 -------------------------------------------
  -----------------------------------------------------------------------
  Extrait de mbl_sys.c (bbs f6fbb)                                       */
void PASSWORD_MD2String (unsigned char *dest, unsigned char *source)
{
	int i;
	MD2_CTX context;
	unsigned char digest[16];
	unsigned int len = strlen ((char*) source);

	MD2Init (&context);
	MD2Update (&context, source, len);
	MD2Final (digest, &context);

	*dest = '\0';

	for (i = 0; i < 16; i++)
	{
		char tmp[5];

		sprintf (tmp, "%02X", (int) digest[i]);
		strcat ((char*) dest, (char*) tmp);
	}
}

