#include <alloc.h>
#include <mem.h>
#include <string.h>
#include "ping.h"
#include "define.h"
#include "node.h"
#include "buffers.h"
#include "message.h"
#include "set.h"
#include "log.h"
#include "tools.h"

extern "C" {
#include "memory.h"
}

PING * pPing;
mem_hand PING_hand;

#define	PING_MAX	20	//Pas plus de 20 pings simultanes

/*---------------------------------------------------------------------------
  ------ Initialisation -----------------------------------------------------
  ---------------------------------------------------------------------------*/
void PING_init(void)
{
	int index;

	/* Allouer un buffer */
	setXMstrat("XEV");
	PING_hand = xalloc(sizeof(*pPing), PING_MAX);

	for(index = 0; index < PING_MAX; index++)
	{
		pPing = (PING *) xget(index, PING_hand);
		memset(pPing, 0, sizeof(*pPing));
		xput((byte *) pPing, index, PING_hand);
	}/*End FOR*/
}


/*---------------------------------------------------------------------------
  ------ Ajouter un ping a la liste -----------------------------------------
  ---------------------------------------------------------------------------
  la fonction retourne PING_OK   (0) si le ping a pu etre memorise
                       PING_DUPE (1) si le meme cluster est deja pinge
				       PING_FULL (2) s'il n'y a plus de place pour memorise le ping
*/
int PING_add(int StreamNum, char * ToNode, char * FromUser)
{
	int index;
	time_t lTime;
	int iEmpty = PING_MAX;

	/* Dans un premier temps, verifier s'il n'y aurait pas un vieux ping oublie
	   dans la table (on considere qu'il est vieux a partir de 10 minutes)
       Verifier, par la meme occasion qu'un tel ping n'est pas deja en
       attente */
	lTime = time(NULL);
	for(index = 0; index < PING_MAX; index++)
	{
		pPing = (PING*) xget(index, PING_hand);

		if( *pPing->sToNode == SNULL )
			iEmpty = index; /* vide */
		else if( pPing->lTime < (lTime - 600L) )
		{
			/* Virrer ce record */
			memset(pPing, 0, sizeof(*pPing));
			xput((byte *) pPing, index, PING_hand);

			iEmpty = index;
		}

		if( ! strcmp(pPing->sToNode, ToNode) )
			return PING_DUPE;	/* Ce cluster est deja pinge par quelqu'un */
	}/*End FOR*/

	/* un emplacement vide a t-il ete trouve ? */
	if( iEmpty == PING_MAX )
		return PING_FULL;	/* Eh non ... */

	pPing = (PING*) xget(iEmpty, PING_hand);
	strcpy(pPing->sToNode, ToNode);
	strcpy(pPing->sFromUser, FromUser);
	pPing->lTime = lTime;
	pPing->iStreamOfUser = StreamNum;
	xput((byte *) pPing, iEmpty, PING_hand);

	return PING_OK;
}

/*---------------------------------------------------------------------------
  ------ Calculer le temps d'un ping et adresser la reponse a l'utilisateur--
  ---------------------------------------------------------------------------
  la fonction retourne TRUE si OK, et false sinon
*/
int PING_sendUser(int StreamOfNode, char * FromNode)
{
	int  index;
	int	 Done = FALSE;
	char sUserCall[11];
//	char sDate[15];
//	char sTime[10];
	time_t lTime;

	/* Rechercher le cluster dans la liste */
	for(index = 0; index < PING_MAX; index++)
	{
		pPing = (PING*) xget(index, PING_hand);

		if( ! strcmp(pPing->sToNode, FromNode ) )
			break; /* trouve */
	}/*End FOR*/

	if( index == PING_MAX )
		return FALSE;

	/* Est-ce le bon utilisateur sur le bon stream (il a pu deconnecter entre temps) ? */
	NODE_getUserCall(0, 0, pPing->iStreamOfUser, sUserCall);
	if( pPing->iStreamOfUser == 0 || ! strcmp(pPing->sFromUser, sUserCall) )
	{
		/* Oui : calculer le temps et adresser la reponse a l'utilisateur ... */
		lTime = time(NULL) - pPing->lTime;
		BUFFERS_printBuff(pPing->iStreamOfUser, OUT, "Ping with %s : %lds.\n", pPing->sToNode, lTime);
		MSG_send(pPing->iStreamOfUser, MSG1);	/* Prompt */

		/* Enregistrer le ping dans le LOG */
		LOG_message(StreamOfNode, LOG_IN, LOG_PROT_PING, "%lds", lTime);

	    Done = TRUE;
	}/*End IF*/

	/* Virrer ce record */
	memset(pPing, 0, sizeof(*pPing));
	xput((byte *) pPing, index, PING_hand);

	return (Done);
}
