#include <alloc.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <dir.h>
#include "protocol.h"
#include "define.h"
#include "node.h"
#include "buffers.h"
#include "hops.h"
#include "tools.h"
#include "symbol.h"
#include "users.h"
#include "dx.h"
#include "announce.h"
#include "clulink.h"
#include "switch.h"
#include "streams.h"
#include "ping.h"
#include "wwv.h"
#include "mail.h"
#include "message.h"
#include "database.h"
#include "pavillon.h"
#include "set.h"
#include "log.h"
#include "coninit.h"
#include "commands.h"
#include "filter.h"
#include "locator.h"
#include "ufilter.h"
#include "wcy.h"
#include "rcmd.h"

#define	 SPECIAL_DX_

char	PROTOCOL_linkType[65];
char	PROTOCOL_initDone[65];	//TRUE lorsque l'initialisation est termine
int 	PROTOCOL_adjacentVersion[65];
char	PROTOCOL_badCRC[65];
char	PROTOCOL_mailEveryNLines[65];
char	PROTOCOL_mailLinesCounter[65];
unsigned long PROTOCOL_lFwdMesNum[MAX_STREAMS];

int	iProtNum;		//Numero de version (poid fort = n de version MAJEUR, poid faible = n de version mineur)

extern int  STREAMS_level[MAX_STREAMS + RCMD_VIRTSTREAM];
extern char	STREAMS_callsign[MAX_STREAMS][10];
extern int 	FirstStream;
extern int 	LastStream;
extern char	SCRIPT_fileName[65][9];
extern unsigned long MAIL_lFwdMsgNumber[MAX_STREAMS];

unsigned int	iCluLinkPos;

int	PROTOCOL_nFixedInit = TRUE;	/* TRUE si on utilise la version corrigee de l'init de connexion */

static char* pszError[] = {"Ok",
			   "Bad callsign",
			   "Bad number of arguments",
			   "Unknown user",
			   "Unknown cluster",
			   "Bad frequency",
			   "Unknown error",
			   "Bad message number",
			   "Bad user count",
			   "String too long",
			   "Bad size",
                           "Bad CRC",
			   "Unknown protocol",
			   "Loop"};

//-------------------------------------------------------------------------
//------ Envoyer un protocole  tous les clusters -------------------------
//-------------------------------------------------------------------------
void PROTOCOL_sendProt(int StreamNum, char * pszOriginatedPC, int Pc, char * Pavillon, char * CluLink, int Hops, int CluLinkSize, int ToStream, int nWAZ)
{
  int 	index;
  int  	iHops;

  int  	iFstream,
	iLstream;

  char	sHops[5];

  /* Enlever 1 de CluLinkSize (octet 0, qui ne compte pas) */
  CluLinkSize--;

  /* A qui faut-il envoyer ce protocole ? */
  if( ToStream == PROTOCOL_ALL )
  {
	/* Envoyer a tous les clusters */
	iFstream = FirstStream;
	iLstream = LastStream;
  }
  else
  {
	/* Envoyer uniquement sur le stream designe */
	iFstream = iLstream = ToStream;
  }


  /* Balayage des streams, a la recherche de clusters */
  for(index = iFstream; index <= iLstream; index++)
  {
	if( StreamNum == index )
		continue;	/* Pas a soi meme ! */

	if( ! (STREAMS_level[index] & LEVEL_cluster ) )
		continue;	/* Ce n'est pas un cluster */

	if( HOPS_fix(index, NULL, 0, PCAS_USER, IN, 100) )
		continue;	/* Mode AsUser */

	if( PROTOCOL_initDone[index] != PROTOCOL_INIT_DONE &&
	    (Pc == 16 || Pc == 17 || Pc == 19 || Pc == 21) )
		continue; 	/* L'init n'est pas terminee */

	/* Protocole valide ? */
	iHops = HOPS_fix(index, pszOriginatedPC, StreamNum, Pc, HOPS_OUT, Hops);
	if( iHops < 1 || iHops > 99 )
		continue;	/* Le protocole n'est pas valide */

	/* Filtre sortant */
	if( ! FILTER_isOK(index, FILTER_OUT, nWAZ) )
		continue;	/* Protocole filtre */

	/* Pavillon */
	if( PROTOCOL_linkType[index] == PAVILLON )
	{
		/* Y a t-il un hops ? */
		if( Pc == 10 || Pc == 25 || Pc == 26 || Pc == 27 || (Pc >= 28 && Pc <= 38) || Pc == 40 || (Pc >= 42 && Pc <= 48) || Pc == 51 )
			strcpy(sHops, "");		/* Pas de hop count */
		else
			sprintf(sHops, "H%d^", iHops);	/* Oui, y'a un hops */

		/* Faut-il un tild (~) ? */
		if( (Pc >= 10 && Pc <= 12) ||  Pc == 15 || Pc == 18  || Pc == 23 ||
		    (Pc >= 26 && Pc <= 29) || (Pc >= 34 && Pc <= 38) || Pc == 41 ||
		     Pc == 45 )
			BUFFERS_printBuff(index, OUT, "%s%s~\n", Pavillon, sHops);
		else
			BUFFERS_printBuff(index, OUT, "%s%s\n", Pavillon, sHops);
	}
	else
	/* CluLink */
	{
		if( CluLinkSize == 0 )	/* Par securite */
			break;

		/* Hop count */
		CluLink[4] = (unsigned char) iHops;

		/* Longueur du protocole */
		 CLULINK_putSize(CluLink, CluLinkSize - 1);

		/* Rechercher les protocoles NON BROADCASTES */
		if( Pc != PC10 )
			CluLink[0] |= CL_BROADCAST; /* Mettre a 1 le bit BROADCAST */

		BUFFERS_addBuff_sized(index, CluLink, OUT, CluLinkSize + 1);
	}
  }/* End FOR */
}

//-------------------------------------------------------------------------
//------ Aiguiller le dcodage de la commande reue -----------------------
//-------------------------------------------------------------------------
void PROTOCOL_do(int StreamNum, char * Cmd)
{
  //------ Quel protocol est utilis ? ------
  //Au depart, le protocol par dfaut est Pavillon software
  //Un entete [MZN-3.ALPHA-$1.0], transmis lors de la phase
  //d'initialisation, permet de commuter vers le protocol CluLink.

  if( PROTOCOL_linkType[StreamNum] == CLU_LINK )
    PROTOCOL_cluLink(StreamNum, Cmd);
  else
    PROTOCOL_pavillon(StreamNum, Cmd);
}

//-------------------------------------------------------------------------
//------ Extraire les arguments -------------------------------------------
//-------------------------------------------------------------------------
int PROTOCOL_extractPC(char* pszString, char** pArg)
{
	int index;
	int nNbArg;
	char* pPtr;

	pPtr= pszString + 5; /* Pointer juste apres le numro de protocole */

	for(index = 0; index < PPARAM; index++)
	{
		pArg[index] = pPtr;

		/* Rechercher le champs suivant */
//		for(;;)
//		{
			while( *pPtr != SNULL && *pPtr != '^' )
				pPtr++;
//
//			if( *pPtr == '^' && *(pPtr + 1) == '^' )
//			{
//				memmove(pPtr, pPtr + 1, strlen(pPtr));
//				pPtr++;
//				continue;
//			}
//
//			break;
//		}

		/* Fin de la ligne de commande atteinte ? */
		if( *pPtr == SNULL || *pPtr == '~' )
			break;

		*pPtr++ = SNULL;
	}

	/* Sauvegarder le nombre de parametres recus dans le protocole */
	nNbArg = index;

	/* Completer les champs restant par des NULLs */
	for(;index < PPARAM; index++)
		pArg[index] = NULL;

	return nNbArg;
}

//---------------------------------------------------------------------------
//------ Coonection en mode utilisateur -------------------------------------
//---------------------------------------------------------------------------
void PROTOCOL_asUser(int StreamNum, char * pszString)
{
	char 	szLogger[20];
	char 	szFrequency[20];
	char 	szDxCall[30];
	char 	szComments[80];
	char 	szTime[20];
	char 	szDate[20];
	char 	szServer[20];
	int	index;
	char*	pPtr1;


	if( strlen (pszString) > 255 )
		return;

	/* Identifier un spot DX */
	if( pszString[0] == 'D' && pszString[1] == 'X' && pszString[2] == ' ')
	{
		pPtr1 = pszString + 6;	/* Pointer sur l'indicatif de l'om */

		/* Lire l'indicatif */
		for(index = 0; index < 19; index++)
		{
			if( *pPtr1 != ':' && *pPtr1 != ' ' )
				szLogger[index] = *pPtr1++;
			else
				break;
		}
		szLogger[index] = SNULL;
		strupr(szLogger);

		/* Passer les espaces */
		pPtr1++;
		while( *pPtr1 == ' ' )
			pPtr1++;

		/* Lire la frequence */
		for(index = 0; index < 19; index++)
		{
			if( *pPtr1 != ' ' )
				szFrequency[index] = *pPtr1++;
			else
				break;
		}
		szFrequency[index] = SNULL;

		/* Passer les espaces */
		while( *pPtr1 == ' ' )
			pPtr1++;

		/* Lire l'indicatif du DX */
		for(index = 0; index < 29; index++)
		{
			if( *pPtr1 != ' ' )
				szDxCall[index] = *pPtr1++;
			else
				break;
		}
		szDxCall[index] = SNULL;

		/* Passer les espaces */
		while( *pPtr1 == ' ' )
			pPtr1++;

		/* Lire le commentaire */
		strcpy(szComments, pPtr1);

		/* y avait-il un commentaire ? */
		if( strlen(szComments) < 8 )
		{
			/* Non ... */
			strcpy(szTime, szComments);
			strcpy(szComments, " ");
		}
		else
		{
			/* Oui ... Lire le commentaire ... et l'heure */
			pPtr1 = strchr(szComments, SNULL); /* Fin de la chaine */

			/* Chercher le dbut de l'heure */
			while( *pPtr1 != ' ' )
				pPtr1--;

			strcpy(szTime, pPtr1 + 1);

			/* Chercher la fin du commentaire */
			while( *pPtr1 == ' ' )
				pPtr1--;

			*++pPtr1 = SNULL;
		}

		/* Clean up de szLogger et sTime */
		pPtr1 = strchr(szTime, '\a');	//BELL
		if( pPtr1 )
			*pPtr1 = SNULL;

		//Prparer le protocole a reinjecter
		NODE_getNodeCall(0, 0, szServer);
		sprintf(pszString, "PC11^%1s^%1s^%1s^%1s^%1s^%1s^%1s^H%d^~",
			szFrequency,
			szDxCall,
			TOOLS_whatDate(szDate),
			szTime,
			szComments,
			szLogger,
			szServer,
			HOPS_fix(StreamNum, NULL, StreamNum, PC11, HOPS_IN, 100));
	}
#if 0
	else
	{
		pPtr1 = strstr(pszString, "***");
		if( pPtr1 && pPtr1 < (pszString + 6) )
		{
			SWITCH_discSwitch(StreamNum);
			STREAMS_disconnect(StreamNum);
		}

	}/*End IF*/
#endif

}


//-------------------------------------------------------------------------
//------ Dcoder un protocol Pavillon -------------------------------------
//-------------------------------------------------------------------------
void PROTOCOL_pavillon(int StreamNum, char * pszCmd)
{
	static char * pArg[PPARAM];
	static char   szArg[1024];
	static int    nParams;
	static int    nProtocol;
	static int    nRet;

	/* Il peut arriver que des trames arrivent avec comme premier
	   caractere \n : il faut absilument supprimer ce caractere */
	while( *pszCmd == '\n' )
		pszCmd++;

	/* As User ? */
	if( HOPS_fix(StreamNum, NULL, 0, PCAS_USER, HOPS_IN, 100) )
	{
		PROTOCOL_asUser(StreamNum, pszCmd);
		if( pszCmd[2] != '1' || pszCmd[3] != '1' )
			return;
	}

	/* Ne pas deconnecter sur les chaines vides */
	if( pszCmd[0] == SNULL )
		return;

	/* Verifier que le msg est un protocole */
	if( pszCmd[0] != 'P' || pszCmd[1] != 'C' || strlen(pszCmd) > 1023 ||
	    strlen(pszCmd) < 3 )
	{
		/* Peut-tre est-ce un entte, qu'il faut alors traiter */
		if( ! strncmp(pszCmd, "<CLU-", 4) )
		{
			/* CluLink valid : lire le numro de version */
			PROTOCOL_adjacentVersion[StreamNum] = 1000 * atoi(pszCmd+5) + atoi(pszCmd+7);
			PROTOCOL_linkType[StreamNum]  = CLU_LINK;

			BUFFERS_printBuff(BUFFER_SCREEN1, OUT, "Node %s> CluLink v%d.%d implemented.\n", STREAMS_callsign[StreamNum], PROTOCOL_adjacentVersion[StreamNum]/1000, PROTOCOL_adjacentVersion[StreamNum]%1000);
			BUFFERS_addBuff(BUFFER_SCREEN1, "Transmitting local configuration...\n", OUT);

			/* Transmettre la configuration locale */
			PROTOCOL_sendInit(StreamNum);
			return;
		}

		/* L'init du link est elle OK ? */
		if( PROTOCOL_initDone[StreamNum] == PROTOCOL_INIT_DONE )
		{
			/* Oui -> Deconnecter. */
			SWITCH_discSwitch(StreamNum);
			STREAMS_disconnect(StreamNum);
		}
		return;
	}

	/* Extraire les arguments */
	strcpy(szArg, pszCmd);
	nParams = PROTOCOL_extractPC(szArg, pArg);

	/* Appeler la fonction correspondante */
	nProtocol = atoi(pszCmd + 2);
	nRet	  = LOG_PROT_PROTUNKNOWN;
#ifdef	DEBUGLINK_
LOG_write(LOG_BUFFERIN_FILE, LOG_DATE_NO, "[PROTOCOL_pavillon #2] %d> nProtocol = %d\n", StreamNum, nProtocol);
#endif
	switch( nProtocol )
	{
		case PC10 :
			nRet = PAVILLON_pc10(StreamNum, nParams, pArg);
			break;

		case PC11 :
			nRet = PAVILLON_pc11(StreamNum, nParams, pArg);
			break;

		case PC12 :
			nRet = PAVILLON_pc12(StreamNum, nParams, pArg);
			break;

		case PC13 :
			nRet = PAVILLON_pc13(StreamNum, nParams, pArg);
			break;

		case PC14 :
			nRet = PAVILLON_pc14(StreamNum, nParams, pArg);
			break;

		case PC15 :
			nRet = PAVILLON_pc15(StreamNum, nParams, pArg);
			break;

		case PC16 :
			nRet = PAVILLON_pc16(StreamNum, nParams, pArg);
			break;

		case PC17 :
			nRet = PAVILLON_pc17(StreamNum, nParams, pArg);
			break;

		case PC18 :
			nRet = PAVILLON_pc18(StreamNum, nParams, pArg);
			break;

		case PC19 :
			nRet = PAVILLON_pc19(StreamNum, nParams, pArg);
			break;

		case PC20 :
			nRet = PAVILLON_pc20(StreamNum, nParams, pArg);
			break;

		case PC21 :
			nRet = PAVILLON_pc21(StreamNum, nParams, pArg);
			break;

		case PC22 :
			nRet = PAVILLON_pc22(StreamNum, nParams, pArg);
			break;

		case PC23 :
			nRet = PAVILLON_pc23(StreamNum, nParams, pArg);
			break;

		case PC24 :
			nRet = PAVILLON_pc24(StreamNum, nParams, pArg);
			break;

		case PC25 :
			nRet = PAVILLON_pc25(StreamNum, nParams, pArg);
			break;

		case PC26 :
			nRet = PAVILLON_pc26(StreamNum, nParams, pArg);
			break;

		case PC27 :
			nRet = PAVILLON_pc27(StreamNum, nParams, pArg);
			break;

		case PC28 :
			nRet = PAVILLON_pc28(StreamNum, nParams, pArg);
			break;

		case PC29 :
			nRet = PAVILLON_pc29(StreamNum, nParams, pArg);
			break;

		case PC30 :
			nRet = PAVILLON_pc30(StreamNum, nParams, pArg);
			break;

		case PC31 :
			nRet = PAVILLON_pc31(StreamNum, nParams, pArg);
			break;

		case PC32 :
			nRet = PAVILLON_pc32(StreamNum, nParams, pArg);
			break;

		case PC33 :
			nRet = PAVILLON_pc33(StreamNum, nParams, pArg);
			break;

		case PC34 :
			nRet = PAVILLON_pc34(StreamNum, nParams, pArg);
			break;

		case PC35 :
			nRet = PAVILLON_pc35(StreamNum, nParams, pArg);
			break;
			
		case PC38 :
			nRet = PROTOCOL_OK;	/* Protocol sans interet */
			break;

		case PC39 :
			nRet = PAVILLON_pc39(StreamNum, nParams, pArg);
			break;

		case PC41 :
			nRet = PAVILLON_pc41(StreamNum, nParams, pArg);
			break;

		case PC42 :
			nRet = PAVILLON_pc42(StreamNum, nParams, pArg);
			break;

		case PC44 :
			nRet = PAVILLON_pc44(StreamNum, nParams, pArg);
			break;

		case PC45 :
			nRet = PAVILLON_pc45(StreamNum, nParams, pArg);
			break;

		case PC46 :
			nRet = PAVILLON_pc46(StreamNum, nParams, pArg);
			break;

		case PC50 :
			nRet = PAVILLON_pc50(StreamNum, nParams, pArg);
			break;

		case PC51 :
			nRet = PAVILLON_pc51(StreamNum, nParams, pArg);
			break;

		case PC73 :
			nRet = PAVILLON_pc73(StreamNum, nParams, pArg);
			break;

		case PC84 :
			nRet = PAVILLON_pc84(StreamNum, nParams, pArg);
			break;

		case PC85 :
			nRet = PAVILLON_pc85(StreamNum, nParams, pArg);
			break;
	}

	if( nRet != PROTOCOL_OK )
		LOG_message(StreamNum, LOG_IN, nRet, "%s", pszCmd);
}

//-------------------------------------------------------------------------
//------ Decoder un protocol CluLink --------------------------------------
//-------------------------------------------------------------------------
void PROTOCOL_cluLink(int StreamNum, char * pszCmd)
{
	static	unsigned int nMessageType;
	static	unsigned int nSize;
	static	char	crc;
	static	int	nRet;
	static	char*	pszCluLink;

	pszCluLink = pszCmd;

	/* Taille du protocole CluLink */
	nSize = CLULINK_getSize(pszCluLink);

	/* Passer ProtLength */
	pszCluLink += 2;

	/* Verifier le CRC */
	crc = *pszCluLink++;
	if( crc != CLULINK_fixCRC(pszCluLink, nSize) )
	{
		/* Mauvais CRC */
		 BUFFERS_printBuff(BUFFER_SCREEN1, OUT,
			"*** Protocol error : received bad CRC on stream %d.\n",
			StreamNum);

		/* 3 bad CRC consecutifs. Deconnecter ! */
		if( PROTOCOL_badCRC[StreamNum]++ > 1 )
		{
			STREAMS_disconnect(StreamNum);
			SWITCH_discSwitch(StreamNum);
		}

		/* Message dans le log */
		nMessageType = (unsigned int) *pszCluLink;
		LOG_message(StreamNum, LOG_IN, LOG_PROT_BADCRC, "link is being disconnected");
		return;
	}
	else
	{
		/* CRC ok - reinitialiser le compteur */
		PROTOCOL_badCRC[StreamNum] = 0;
	}

	/* Identifier le type de protocole */
	nMessageType = (unsigned int) ((unsigned char) *pszCluLink++);

	/* Oter de la taille ProtLength & MessageType */
	nSize -= 2;

	/* Router le protocole */
	switch( nMessageType )
	{
		case	CL(0):
			nRet = CLULINK_cl0(StreamNum, pszCluLink, nSize);
			break;

		case	CL(1):
			nRet = CLULINK_cl1(StreamNum, pszCluLink, nSize);
			break;

		case	CL(2):
			nRet = CLULINK_cl2(StreamNum, pszCluLink, nSize);
			break;

		case	CL(3):
			nRet = CLULINK_cl3(StreamNum, pszCluLink, nSize);
			break;

		case	CL(4):
			nRet = CLULINK_cl4(StreamNum, pszCluLink, nSize);
			break;

		case	CL(5):
			nRet = CLULINK_cl5(StreamNum, pszCluLink, nSize);
			break;

		case	CL(10):
			nRet = CLULINK_cl10(StreamNum, pszCluLink, nSize);
			break;

		case	CL(11):
			nRet = CLULINK_cl11(StreamNum, pszCluLink, nSize);
			break;

		case	CL(12):
			nRet = CLULINK_cl12(StreamNum, pszCluLink, nSize);
			break;

		case	CL(13):
			nRet = CLULINK_cl13(StreamNum, pszCluLink, nSize);
			break;

		case	CL(60):
			nRet = CLULINK_cl60(StreamNum, pszCluLink, nSize);
			break;

		case	CL(64):
			nRet = CLULINK_cl64(StreamNum, pszCluLink, nSize);
			break;

		case	CL(65):
			nRet = CLULINK_cl65(StreamNum, pszCluLink, nSize);
			break;

		case	CL(66):
			nRet = CLULINK_cl66(StreamNum, pszCluLink, nSize);
			break;

		case	CL(67):
			nRet = CLULINK_cl67(StreamNum, pszCluLink, nSize);
			break;

		case	CL(68):
			nRet = CLULINK_cl68(StreamNum, pszCluLink, nSize);
			break;

		case	CL(69):
			nRet = CLULINK_cl69(StreamNum, pszCluLink, nSize);
			break;

		case	CL(70):
			nRet = CLULINK_cl70(StreamNum, pszCluLink, nSize);
			break;

		case	CL(71):
			nRet = CLULINK_cl71(StreamNum, pszCluLink, nSize);
			break;

		case	CL(95):
			nRet = CLULINK_cl95(StreamNum, pszCluLink, nSize);
			break;

		case	CL(96):
			nRet = CLULINK_cl96(StreamNum, pszCluLink, nSize);
			break;

		case	CL(97):
			nRet = CLULINK_cl97(StreamNum, pszCluLink, nSize);
			break;

		case	CL(98):
			nRet = CLULINK_cl98(StreamNum, pszCluLink, nSize);
			break;

		case	CL(99):
			nRet = CLULINK_cl99(StreamNum, pszCluLink, nSize);
			break;

		case	CL(100):
			nRet = CLULINK_cl100(StreamNum, pszCluLink, nSize);
			break;

		case	CL(101):
			nRet = CLULINK_cl101(StreamNum, pszCluLink, nSize);
			break;

		case	CL(140):
			nRet = CLULINK_cl140(StreamNum, pszCluLink, nSize);
			break;

		case	CL(141):
			nRet = CLULINK_cl141(StreamNum, pszCluLink, nSize);
			break;

		case	CL(142):
			nRet = CLULINK_cl142(StreamNum, pszCluLink, nSize);
			break;

		case	CL(160):
			nRet = CLULINK_cl160(StreamNum, pszCluLink, nSize);
			break;

		case	CL(161):
			nRet = CLULINK_cl161(StreamNum, pszCluLink, nSize);
			break;

		case	CL(162):
			nRet = CLULINK_cl162(StreamNum, pszCluLink, nSize);
			break;

		case	CL(200):
			nRet = CLULINK_cl200(StreamNum, pszCluLink, nSize);
			break;

		case	CL(201):
			nRet = CLULINK_cl201(StreamNum, pszCluLink, nSize);
			break;

		case	CL(202):
			nRet = CLULINK_cl202(StreamNum, pszCluLink, nSize);
			break;

		case	CL(203):
			nRet = CLULINK_cl203(StreamNum, pszCluLink, nSize);
			break;

		default :
			nRet = PROTOCOL_UNKNOWN;
			break;
	}

	if( nRet != PROTOCOL_OK )
		LOG_message(StreamNum, LOG_IN, nRet, "%s", pszCmd);
}

/*-----------------------------------------------------------------------
  ------ Transmettre l'initialisation (PC19 et PC16) --------------------
  -----------------------------------------------------------------------*/
void PROTOCOL_sendInit(int StreamNum)
{
	if( PROTOCOL_nFixedInit )
	{
		/* Initialisation du link corrigee */
		CONINIT_sendInitProtocols(StreamNum);
	}
	else
	{
		/* Initialisation du link buggee (idem a Pavillon) */
		char  	sCluLink[256];
		char	sNodeCall[11];
		char  	sUserCall[11];
		char  	sVersionString[10];
		unsigned short shVersion;
		char  	cFlag;

		int   	iNodeStream = 0;
		int	iNodePos = 0;
		int   	iUserPos = 0;
		int	iCount = 0;
		int 	iHops;
	
		/* Transmettre les Clusters */

		/* Parcourir les streams, un  un */
		for(iNodeStream = 0; iNodeStream <= 64; iNodeStream++)
		{
			/* Est-ce un cluster ? (ATTENTION, ne pas rebalancer la config de l'autre !) */
			if( iNodeStream != StreamNum && (iNodeStream == 0 || STREAMS_level[iNodeStream] & LEVEL_cluster) )
			{
				/* Parcourir toutes les positions pour ce stream */
				for(iNodePos = 0; iNodePos < 100; iNodePos++)
				{
					NODE_getNodeCall(iNodeStream, iNodePos, sNodeCall);

					/* Transmettre le protocole PC19 */
					if( sNodeCall[0] )
					{
						/* Definir le hop count */
						iHops = HOPS_fix(StreamNum, NULL, iNodeStream, PC19, HOPS_OUT, 100);

						/* L'indicatif de MON cluster doit OBLIGATOIREMENT etre transmis
						   meme en cas de "link external" */
						if(iNodeStream == 0 && iNodePos == 0 && iHops == 0)
							iHops = HOPS_fix(StreamNum, NULL, iNodeStream, PCEXTERNAL, HOPS_OUT, 100);

						/* Lecture du numero de version et du Flag */
						cFlag = NODE_getNodeFlag(iNodeStream, iNodePos);
						NODE_getNodeVersion(iNodeStream, iNodePos, sVersionString);

						if( PROTOCOL_linkType[StreamNum] == PAVILLON )
						{
							/* Creer le protocole pavillon */
							if( iCount == 0 )
								BUFFERS_addBuff(StreamNum, "PC19^", OUT);

							BUFFERS_printBuff(StreamNum, OUT, "%c^%s^%c^%s^", (cFlag & BIT6 ? '1' : '0'), sNodeCall, (cFlag & BIT7 ? '1' : '0'), sVersionString);

							if( HOPS_fix(StreamNum, NULL, iNodeStream, PCEXTERNAL, HOPS_OUT, 100) )
							{
								/* C'est un link external, ne transmettre que MON cluster */
								BUFFERS_printBuff(StreamNum, OUT, "H%d^\n", iHops);
								return;
							}

							if( iCount++ == 12 )
							{
								BUFFERS_printBuff(StreamNum, OUT, "H%d^\n", iHops);
								iCount = 0;
							}/*End IF*/
						}
						else
						{
							/* Creer le protocole clulink */
							if( iCount == 0 )
							{
								/* Definir le protocol et le hop count */
								iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(1));
								sCluLink[4] = (BYTE) iHops;
							}

							/* Ajouter longueur indicatif et indicatif */
							iCluLinkPos = PROTOCOL_addPascalString(sCluLink, sNodeCall, iCluLinkPos);
							/* Ajouter le node flag */
							sCluLink[iCluLinkPos++] = cFlag;
							/* Ajouter numro de version */
							shVersion = (unsigned short) atoi(sVersionString);
							iCluLinkPos = CLULINK_addShort(sCluLink, &shVersion, iCluLinkPos);

							/* Transmettre par blocs et 12 et gerrer le PB des links external */
							if( iCount++ == 12 || HOPS_fix(StreamNum, NULL, 0, PCEXTERNAL, HOPS_OUT, 100) )
							{
								/* Longueur du protocole */
								CLULINK_putSize(sCluLink, iCluLinkPos - 2);
								sCluLink[0] |= CL_BROADCAST;	/* Mettre a 1 le bit BROADCAST */
								BUFFERS_addBuff_sized(StreamNum, sCluLink, OUT, iCluLinkPos);
								iCount = 0;

								if( HOPS_fix(StreamNum, NULL, 0, PCEXTERNAL, HOPS_OUT, 100) )
									return;	/* Ne transmettre que MON cluster (ce qui est fait), donc arrter ICI */
							}
						}/*End IF*/
					}
					else
						break;
				}/*End FOR*/
			}/*End IF*/
		}/*End FOR*/

		if( iCount != 0 )
		{
			if( PROTOCOL_linkType[StreamNum] == PAVILLON )
				BUFFERS_printBuff(StreamNum, OUT, "H%d^\n", HOPS_fix(StreamNum, NULL, iNodeStream, PC19, HOPS_OUT, 100) );
			else
			{
				/* Longueur du protocole */
				CLULINK_putSize(sCluLink, iCluLinkPos - 2);
				sCluLink[0] |= CL_BROADCAST;	/* Mettre a 1 le bit BROADCAST */
				BUFFERS_addBuff_sized(StreamNum, sCluLink, OUT, iCluLinkPos);
			}/*End IF*/
		}/*End IF*/

		/* Transmettre les Utilisateurs */
		/* Definir le hop count */
		iHops = HOPS_fix(StreamNum, NULL, iNodeStream, PC16, HOPS_OUT, 100);

		/* Reinitialiser le compteur */
		iCount = 0;

		/* Inutile d'aller plus loin si le hop count est null */
		if( iHops == 0 )
			return;

		/* Parcourir les streams, un  un */
		for(iNodeStream = 0; iNodeStream <= 64; iNodeStream++)
		{
			/* Est-ce un cluster ? (ATTENTION, ne pas rebalancer la config de l'autre !) */
			if( iNodeStream != StreamNum && (iNodeStream == 0 || STREAMS_level[iNodeStream] & LEVEL_cluster) )
			{
				/* Parcourir toutes les positions pour ce stream */
				for(iNodePos = 0; iNodePos < 100; iNodePos++)
				{
					NODE_getNodeCall(iNodeStream, iNodePos, sNodeCall);

					/* Transmettre le protocole PC16 */
					if( sNodeCall[0] )
					{
						/* Parcourir la table pour trouver les indicatifs */
						for(iUserPos = 1; iUserPos <= 64; iUserPos++)
						{
							/* Lire l'indicatif (s'il existe) */
							NODE_getUserCall(iNodeStream, iNodePos, iUserPos, sUserCall);

							/* Y a t-il un utilisateur connecte ? */
							if( sUserCall[0] != SNULL )
							{
								/* Lire la config de cet utilisateur */
								cFlag = NODE_getUserFlag(iNodeStream, iNodePos, iUserPos);

								/* Selon le protocol mis en place avec l'adjacent */
								if( PROTOCOL_linkType[StreamNum] == PAVILLON )
								{
									/* Creer le protocol PAVILLON */
									if( iCount == 0 )
										BUFFERS_printBuff(StreamNum, OUT, "PC16^%s^", sNodeCall);

									BUFFERS_printBuff(StreamNum, OUT, "%s %c %c^", sUserCall, (cFlag & PROTOCOL_USER_CLUSTERCONF ? '*' : '-'), (cFlag & PROTOCOL_USER_HERE ? '1' : '0') );

									if( iCount++ == 16 )
									{
										BUFFERS_printBuff(StreamNum, OUT, "H%d^\n", iHops);
										iCount = 0;
									}/*End IF*/
								}
								else
								{
									/* Creer le protocol CluLink */
									if( iCount == 0 )
									{
										/* Definir le protocol et le hop count */
										iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(3));
										sCluLink[4] = (BYTE) iHops;

										/* Ajouter longueur indicatif et indicatif du node */
										iCluLinkPos = PROTOCOL_addPascalString(sCluLink, sNodeCall, iCluLinkPos);
									}/*End IF*/

									/* Ajouter longueur indicatif et indicatif de l'utilisateur */
									iCluLinkPos = PROTOCOL_addPascalString(sCluLink, sUserCall, iCluLinkPos);

									/* Ajouter le user flag */
									sCluLink[iCluLinkPos++] = cFlag;

									if( iCount++ == 16 )
									{
										/* Longueur du protocole */
										CLULINK_putSize(sCluLink, iCluLinkPos - 2);
										sCluLink[0] |= CL_BROADCAST;	/* Mettre a 1 le bit BROADCAST */
										BUFFERS_addBuff_sized(StreamNum, sCluLink, OUT, iCluLinkPos);
										iCount = 0;
									}/*End IF*/
								}/*End IF*/
							}/*End IF*/
						}/*End FOR*/
					}/*End IF*/

					/* Transmettre le protocol pour ce node (selon le protocol mis en place avec l'adjacent) */
					if( iCount != 0 )	/* Sauf s'il n'y a pas d'utilisateurs */
					{
						if( PROTOCOL_linkType[StreamNum] == PAVILLON )
							BUFFERS_printBuff(StreamNum, OUT, "H%d^\n", iHops);
						else
						{
							CLULINK_putSize(sCluLink, iCluLinkPos - 2);
							sCluLink[0] |= CL_BROADCAST;	/* Mettre a 1 le bit BROADCAST */
							BUFFERS_addBuff_sized(StreamNum, sCluLink, OUT, iCluLinkPos);
						}
						iCount = 0;
					}
				}/*End FOR*/
			}/*End IF*/
		}/*End FOR*/

		if( iCount != 0 )
		{
			if( PROTOCOL_linkType[StreamNum] == PAVILLON )
				BUFFERS_printBuff(StreamNum, OUT, "H%d^\n", iHops);
			else
			{
				/* Longueur du protocole */
				CLULINK_putSize(sCluLink, iCluLinkPos - 2);
				sCluLink[0] |= CL_BROADCAST;	//Mettre a 1 le bit BROADCAST
				BUFFERS_addBuff_sized(StreamNum, sCluLink, OUT, iCluLinkPos);
			}/*End IF*/
		}/*End IF*/
	} /* End IF */

	/* Protocol CluLink : Indiquer que l'initialisation est termine */
	if( PROTOCOL_linkType[StreamNum] == CLU_LINK )
	{
		char 	szCluLink[256];
		int     nCluLinkPos;

		nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(0));
		CLULINK_putSize(szCluLink, nCluLinkPos - 2);
		BUFFERS_addBuff_sized(StreamNum, szCluLink, OUT, nCluLinkPos);
	}
}

//---------------------------------------------------------------------------
//------ Creer l'entete d'un protocole CluLink ------------------------------
//---------------------------------------------------------------------------
unsigned int PROTOCOL_setCluLink(char * CluLink, unsigned char ProtNum)
{
  CluLink[0] = 255;	//CluLink size
  CluLink[1] = 255;	//CluLink size
  CluLink[2] = 255;	//CRC
  CluLink[3] = ProtNum;	//#Protocole
  CluLink[4] = 99; 	//Hop count
  CluLink[5] = SNULL;

  return 5;		//Position du pointeur iCluLinkPos
}

//---------------------------------------------------------------------------
//------ Informer les adjacents qu'un node a ete deconnecte -----------------
//---------------------------------------------------------------------------
void PROTOCOL_nodeDisconnect(int StreamNum, char * NodeCall, char * sReason, int iReason, int Hops)
{
  char 	sPavillon[256];
  char	sCluLink[256];

  //Limiter la raison  40 caractres
  TOOLS_maxLength(sReason, 40);

  //------ Protocol Pavillon ------
  sprintf(sPavillon, "PC21^%s^%1s^", NodeCall, sReason);

  //------ Protocol CluLink ------
  iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(2));

  //Ajouter longueur indicatif et indicatif
  iCluLinkPos = PROTOCOL_addPascalString(sCluLink, NodeCall, iCluLinkPos);

  //Raison
  sCluLink[iCluLinkPos++] = (BYTE) iReason;

  //Si la raison n'est pas prdfinie (en particulier si le protocole
  //provient d'un link pavillon ...
  if( iReason == 255 )
  {
    //Ajouter longueur de la raison, et la raison
    iCluLinkPos = PROTOCOL_addPascalString(sCluLink, sReason, iCluLinkPos);
  }/*End IF*/

  PROTOCOL_sendProt(StreamNum, NULL, PC21, sPavillon, sCluLink, Hops, iCluLinkPos, PROTOCOL_ALL, -1);
}

//---------------------------------------------------------------------------
//------ Ajouter une chaine du type Pascal  une chaine de caractres -------
//---------------------------------------------------------------------------
//La fonction retourne la nouvelle longueur de Dest
int PROTOCOL_addPascalString(char * Dest, char * Org, unsigned int Pos)
{
  char * pPtr = Org;

  //Longueur de la chaine
  Dest[Pos++] = (BYTE) strlen( Org );

  //Ajouter la chaine
  while( *pPtr != SNULL )
    Dest[Pos++] = *pPtr++;

  return Pos;
}

//--------------------------------------------------------------------------
//------ Extraire une chaine du type Pascal --------------------------------
//--------------------------------------------------------------------------
//La fonction retourne un pointeur pointant sur la caractre qui suit la
//chaine Pascal
char * PROTOCOL_readPascalString(char * Dest, char * Org, int nMaxSize)
{
	int	index;
	int 	nSize;

	nSize = *Org++;

	if( nMaxSize != 0 && nSize > nMaxSize )
		return NULL;

	for(index = 0; index < nSize; index++)
		Dest[index] = *Org++;
	Dest[index] = SNULL;

	return Org;
}

char * PROTOCOL_readPascalString(char * Dest, char * Org)
{
	return PROTOCOL_readPascalString(Dest, Org, 0);
}

//--------------------------------------------------------------------------
//------ Informer les adjacents de la connection d'un utilisateur local ----
//--------------------------------------------------------------------------
void PROTOCOL_sendNewLocalUser(char * UserCall, unsigned char Flag)
{
  char sPavillon[256];
  char sCluLink[256];
  char sNodeCall[11];

  //Lire l'indicatif de MON cluster
  NODE_getNodeCall(0, 0, sNodeCall);

  //------ Creer le protocol Pavillon ------
  sprintf(sPavillon, "PC16^%s^%s - %c^", sNodeCall, UserCall, (Flag & PROTOCOL_USER_HERE ? '1' : '0'));

  //------ Creer le protocol CluLink ------
  iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(3));
  //Ajouter mon indicatif
  iCluLinkPos = PROTOCOL_addPascalString(sCluLink, sNodeCall, iCluLinkPos);
  //Ajouter l'indicatif de l'utilisateur
  iCluLinkPos = PROTOCOL_addPascalString(sCluLink, UserCall, iCluLinkPos);
  //Ajouter le cFlag
  sCluLink[iCluLinkPos++] = Flag;

  //Envoyer les protocols aux adjacents
  PROTOCOL_sendProt(0, NULL, PC16, sPavillon, sCluLink, 100, iCluLinkPos, PROTOCOL_ALL, -1);
}

/*--------------------------------------------------------------------------
  ------ Informer les adjacents de la deconnection d'un utilisateur --------
  --------------------------------------------------------------------------*/
void PROTOCOL_deleteUser(int StreamNum, char * NodeCall, char * UserCall, int Hops)
{
	char 	sPavillon[256];
	char	sCluLink[256];
  
	/* Creer le protocol Pavillon */
	sprintf(sPavillon, "PC17^%s^%s^", UserCall, NodeCall);

	/* Creer le protocol CluLink */
	iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(4));
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, NodeCall, iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, UserCall, iCluLinkPos);

	/* Envoyer les protocols aux adjacents */
	PROTOCOL_sendProt(StreamNum, NULL, PC16, sPavillon, sCluLink, Hops, iCluLinkPos, 
		PROTOCOL_ALL, -1);
}

//--------------------------------------------------------------------------
//------ Informer les adjacents de la dconnection d'un utilisateur local --
//--------------------------------------------------------------------------
void PROTOCOL_deleteLocalUser(char * UserCall)
{
  char sNodeCall[11];

  //Lire l'indicatif de MON cluster
  NODE_getNodeCall(0, 0, sNodeCall);

  PROTOCOL_deleteUser(0, sNodeCall, UserCall, 100);
}

/*--------------------------------------------------------------------------
  ------ Envoyer un DX -----------------------------------------------------
  --------------------------------------------------------------------------*/
int PROTOCOL_sendDx(int StreamNum, char * pszFromPC, char * pszLogger, unsigned long lFrequency, char * pszDate, char * pszTime, char * pszDxCall, char * pszComments, int nHops)
{
	extern char	STREAMS_callsign[MAX_STREAMS][10];
	extern int PARAMS_iSetDxSsid;

	unsigned long lDateTime;
	unsigned long lBand, lMode;
	char szPavillon[256];
	char szCluLink[256];
	char szBuffer[256];
	char szBufferNoBeep[256];
	char szLogger[11];
	int	 nWAZ;
	int	 nCluLinkPos;
	int	 index;
	int	 nRet;

	/* Filtre entrant */
	nWAZ = FILTER_searchWAZ(pszFromPC);

	if( ! FILTER_isOK(StreamNum, FILTER_IN, nWAZ) )
		return LOG_PROT_WAZFILTER;		/* Filtre */

	/* Verifier que le spot n'est pas deja logge (DUPE) */
	nRet = DX_isDupe(pszDxCall, lFrequency, pszComments, pszTime, pszDate, pszLogger);
	if( nRet != LOG_PROT_OK )
		return nRet;

	/* Enregistrer le DX dans la database */
	DX_add(pszDxCall, lFrequency, pszComments, pszTime, pszDate, pszLogger, pszFromPC);

	/* Ne retransmettre le protocole que si ce n'est pas un MERGE */
	if( strcmp(pszFromPC, "?") )
	{
		/*  Creer le protocol CluLink */
		lDateTime = TOOLS_dateTime_Str2Long(pszDate, pszTime);
		nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(64));
		nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszFromPC, nCluLinkPos);
		nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszLogger, nCluLinkPos);
		nCluLinkPos = CLULINK_addLong(szCluLink, &lFrequency, nCluLinkPos);
		nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszDxCall, nCluLinkPos);
		nCluLinkPos = CLULINK_addLong(szCluLink, &lDateTime, nCluLinkPos);
		nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszComments, nCluLinkPos);

		/*  Creer le protocol Pavillon */
		sprintf(szPavillon, "PC11^%ld.%ld^%1s^%s^%sZ^%1s^%s^%s^",
			    lFrequency/10L, lFrequency%10L,
			    pszDxCall,
			    pszDate,
			    pszTime,
			    pszComments,
			    pszLogger,
			    pszFromPC);

		/* Transmettre le protocole */
		PROTOCOL_sendProt(StreamNum, pszFromPC, PC11, szPavillon,
			szCluLink, nHops, nCluLinkPos, PROTOCOL_ALL, nWAZ);
	}

	/* Maintenant generer l'information a transmettre aux utilisateurs */
	strcpy(szLogger, pszLogger);
	/* Faut il enlever le SSID du logger ? */
	if( PARAMS_iSetDxSsid == FALSE )
		TOOLS_removeSsid(szLogger);
	strcat(szLogger, ":");

	sprintf(szBuffer, "DX de %-9s%10.1f %-12s %-30s %4sZ%c%c\n",
		szLogger,
		(float) lFrequency / 10.0,
		pszDxCall,
		pszComments,
		pszTime,
		BELL,
		BELL);

	strcpy(szBufferNoBeep, szBuffer);
	TOOLS_removeBell(szBufferNoBeep);

	lBand = DX_checkFrequency(lFrequency);
	lMode = TOOLS_mode2bits(lFrequency / 10.0);

	for(index = 1; index < MAX_STREAMS; index++)
	{
		/* Y a t-il quelqu'un de connecte ? */
		if( ! STREAMS_callsign[index][0] )
			continue;

		/* Est-ce un utilisateur ? */
		if( ! (STREAMS_level[index] & LEVEL_user) && ! (STREAMS_level[index] & LEVEL_hiddenUser) )
			continue;

		/* Test sur le filtrage WW */
		if( ! FILTER_isOK(index, FILTER_USER, nWAZ) )
			continue;

		if( ! UFILTER_isOK(index, lBand, lMode) )
			continue;

		/* Beep ou NoBeep ? */
		if( USERS_getFlags(index) & USERS_NODXBEEP )
			BUFFERS_addBuff(index, szBufferNoBeep, OUT);
		else
			BUFFERS_addBuff(index, szBuffer, OUT);
	}

	return PROTOCOL_OK;
}

/*---------------------------------------------------------------------------
  ------ Transmettre une configuration utilisateur --------------------------
  ---------------------------------------------------------------------------
*/
int PROTOCOL_sendUserConfig(int StreamNum, char * FromNode, char * FromUser, char * String, int Data, int Hops)
{
	char	sPavillon[256];
	char	sCluLink[256];
	char	sFromNode[11];

	/* Creer le protocole PAVILLON */
	if( Data == USERS_LOCATOR )
	{	
		LOCATOR_PAVCOORDINATES pavCoordinates;
		LOCATOR_locator2pavCoordinates(String, &pavCoordinates);
		sprintf(sPavillon, "PC41^%s^3^%d %d %c %d %d %c^",
			FromUser,
			pavCoordinates.nLatDegrees,
			pavCoordinates.nLatMinutes,
			(pavCoordinates.nLatN ? 'N' : 'S'),
			pavCoordinates.nLongDegrees,
			pavCoordinates.nLongMinutes,
			(pavCoordinates.nLongE ? 'E' : 'W'));
	}
	else
  		sprintf(sPavillon, "PC41^%s^%d^%1s^", FromUser, Data, String);

	/* Rechercher l'indicatif du home node (s'il n'est pas precise lors de
	   l'appel de la fonction) */
	if( *FromNode == SNULL || *FromNode == '?' )
	{
		/* Rechercher dans la table */
		if( ! NODE_searchUser(FromUser, NODE_CHECKSSID_YES, sFromNode) )
		{
			/* L'indicatif n'a pas ete trouve */
			strcpy(sFromNode, "?");
		}

		/* Ceci ne peut normallement pas arriver, mais on teste quand meme ... */
		if( *sFromNode == SNULL )
			strcpy(sFromNode, "?");
	}
	else
		strcpy(sFromNode, FromNode);

	/* Si c'est une info lat/long, transmettre le locator en lieu et place */
	if( Data == USERS_COORDINATES )
	{
		char szLocator[8];

		/* Convertir */
		if( ! LOCATOR_pavStr2locator(String, szLocator) )
			return LOG_PROT_UNEXPECTEDERROR;	/* Probleme sur le nbr d'arg */

		strcpy(String, szLocator);
		Data = USERS_LOCATOR;
	}

	//------ Crer le protocole CluLink ------
	iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(11));
	//Ajouter l'indicatif du cluster expediteur
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, sFromNode, iCluLinkPos);
	//Ajouter l'indicatif de l'utilisateur
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, FromUser, iCluLinkPos);
	//Ajouter data type (type d'information)
	sCluLink[iCluLinkPos++] = (BYTE) Data;
	//Ajouter la chaine d'information
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, String, iCluLinkPos);

	//Envoyer les protocols aux adjacents
	PROTOCOL_sendProt(StreamNum, NULL, PC41, sPavillon, sCluLink, Hops, iCluLinkPos, PROTOCOL_ALL, -1);

	return LOG_PROT_OK;
}

/*--------------------------------------------------------------------------
  ------ Transmettre une annonce -------------------------------------------
  --------------------------------------------------------------------------
*/
int PROTOCOL_sendAnnounce(int StreamNum, char * FromNode, char * FromUser, char * ToNode, unsigned long DateTime, char Flag, char * String, int Hops)
{
	char	sToWho[21];
	char	sPavillon[256];
	char	sCluLink[256];
	char	sBuffer[256];
	int	iStreamOfNode;
	int	iNodePos;
	int	nWAZ;

	/* Filtre entrant */
	nWAZ = FILTER_searchWAZ(FromNode);
	if( ! FILTER_isOK(StreamNum, FILTER_IN, nWAZ) )
		return LOG_PROT_WAZFILTER;		/* Filtre */

	/* Limiter la longueur du message a 80 caracteres */
	TOOLS_maxLength(String, 200);

	/* Mettre a jour la variable sToWho */
	if( Flag & ANNOUNCE_ALL )
		strcpy(sToWho, "ALL");
	else if( Flag & ANNOUNCE_LOCAL )
		strcpy(sToWho, "LOCAL");
	else if( Flag & ANNOUNCE_TOSYSOP )
		strcpy(sToWho, "SYSOP");
	else if( Flag & ANNOUNCE_TOCLUSTER )
		strcpy(sToWho, "CLUSTER");

	/* Verifier que l'annonce n'est pas deja loggee */
	if( ANNOUNCE_isDupe(FromNode, sToWho, FromUser, String, DateTime) )
		return LOG_PROT_DUPE;

	/* Creer le protocole PAVILLON */
	sprintf(sPavillon, "PC12^%s^%s^%1s^%c^%s^%c^", FromUser, ToNode, String,
		(Flag & ANNOUNCE_TOSYSOP ? '*' : ' '), FromNode, 
		(Flag & ANNOUNCE_WX ? '1' : '0'));

	/* Creer le protocol CluLink */
	iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(66));
	//Ajouter l'indicatif du cluster expditeur
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, FromNode, iCluLinkPos);
	//Ajouter l'indicatif de l'utilisateur expditeur
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, FromUser, iCluLinkPos);
	//Ajouter l'indicatif du node destinataire ou de la liste de distribution SI NECESSAIRE (ANNOUNCE_ALL est a 0)
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, ToNode, iCluLinkPos);
	//Ajouter la date
	iCluLinkPos = CLULINK_addLong(sCluLink, &DateTime, iCluLinkPos);
	//Ajouter le flag
	sCluLink[iCluLinkPos++] = (BYTE) Flag;
	//Ajouter le message
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, String, iCluLinkPos);

	/* Preparer le message */
	sprintf(sBuffer, "%s de %s: %s%c\n", sToWho, FromUser, String, BELL);

	/* A qui faut-il adresser le message ? */
	if( Flag & ANNOUNCE_ALL || Flag & ANNOUNCE_LOCAL )
	{
		/* Afficher le message aux utilisateurs */
		USERS_sendAll(sBuffer, USERS_ALL, PROTOCOL_ANNOUNCEMENT, nWAZ);
	}
	else if( Flag & ANNOUNCE_TOSYSOP )
	{
		/* Au sysops seulement */
		USERS_sendAll(sBuffer, USERS_SYSOP, PROTOCOL_ANNOUNCEMENT, nWAZ);
	}
	else if( Flag & ANNOUNCE_TOCLUSTER )
	{
		/* Est ce pour ici ? */
		if( ! strcmp(ToNode, NODE_getNodeCall(0, 0, sBuffer)) )
		{
			/* OUI : adresser le message aux utilisateurs connectes */
			USERS_sendAll(sBuffer, USERS_ALL, PROTOCOL_ANNOUNCEMENT,
				nWAZ);
		}
		else
		{
			/* Sur quel stream le cluster destinataire est-il connecte ? */
			if( NODE_isNodeConnected(ToNode, &iStreamOfNode, &iNodePos) )
				PROTOCOL_sendProt(StreamNum, FromNode, PC12, sPavillon, sCluLink, Hops, iCluLinkPos, iStreamOfNode, nWAZ);
		}/* End IF */
	}/* End IF */

	/* Envoyer les protocoles aux adjacents (sauf si c'est une annonce locale, ou adressee a un cluster en particulier) */
	if( ! (Flag & ANNOUNCE_LOCAL) && ! (Flag & ANNOUNCE_TOCLUSTER) )
		PROTOCOL_sendProt(StreamNum, FromNode, PC12, sPavillon, sCluLink, Hops, iCluLinkPos, PROTOCOL_ALL, nWAZ);

	/* Enregistrer l'annonce */
	ANNOUNCE_add(FromNode, sToWho, FromUser, Flag, String, DateTime);

	return LOG_PROT_OK;
}

/*-------------------------------------------------------------------------
  ------ Transmettre un protocole talk ------------------------------------
  -------------------------------------------------------------------------*/
int PROTOCOL_sendTalkProt(int StreamNum, char * szFromNode, char * szFromUser, char * szToNode, char * szToUser, char * szString, char Flag, unsigned long lDateTime, int nExternal, int nHops)
{
	char szPavillon[1024];
	char szCluLink[1024];
	int  nCluLinkPos;

	/* Creer le protocole PAVILLON */
	if( nExternal )
	{
		sprintf(szPavillon, "PC10^%s^%s^%1s^%c^%s^%s^",
			szFromUser,
			szToNode,
			szString,
			(Flag & PROTOCOL_TALK_BELL ? '*' : ' '),
			szToUser,
			szFromNode);
	}
	else
	{
		sprintf(szPavillon, "PC10^%s^%s^%1s^%c^ ^%s^",
			szFromUser,
			szToUser,
			szString, (
			Flag & PROTOCOL_TALK_BELL ? '*' : ' '),
			szFromNode);
	}

	/* Protocol CluLink */
	nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(67));

	/* Indicatif du cluster de depart */
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, szFromNode, nCluLinkPos);
	/* Indicatif de l'auteur */
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, szFromUser, nCluLinkPos);
	/* Indicatif du cluster destinataire */
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, szToNode,   nCluLinkPos);
	/* Indicatif du destinataire */
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, szToUser,   nCluLinkPos);
	/* Date et heure */
	nCluLinkPos = CLULINK_addLong(szCluLink, &lDateTime, nCluLinkPos);
	/* Flag */
	szCluLink[nCluLinkPos++] = Flag;
	/* Message */
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, szString, nCluLinkPos);

	/* Transmettre le protocole */
	PROTOCOL_sendProt(0, NULL, PC10, szPavillon, szCluLink, nHops, nCluLinkPos, StreamNum, -1);

	return LOG_PROT_OK;
}

/*-------------------------------------------------------------------------
  ------ Transmettre un talk ----------------------------------------------
  -------------------------------------------------------------------------
  Retourne TRUE si le talk a pu etre route
*/
int PROTOCOL_sendTalk(int StreamNum, char * FromNode, char * FromUser, char * ToNode, char * ToUser, char * String, char Flag, unsigned long DateTime, int Hops)
{
	char szToNode[16];			/* Cluster destinataire */
	char szToUser[16];			/* Utilisateur destinataire */
	char szToUser_nossid[16];	/* Idem mais sans ssid */
	int  nStream;
	int  nNodePos;
	int  nUserPos;
	int  nDone = FALSE;

	/* Cluster dest. */
	TOOLS_maxLength(ToNode, 9);
	strcpy(szToNode, ToNode);

	/* Utilisateur dest. */
	TOOLS_maxLength(ToUser, 9);
	strcpy(szToUser, ToUser);
	strcpy(szToUser_nossid, ToUser);
	TOOLS_removeSsid(szToUser_nossid);

	/* Limiter la longueur du message a 200 caracteres */
	TOOLS_maxLength(String, 200);

	/* Rechercher l'utilisateur destinataire - balayer toutes les
	   tables */
	for(nStream = 0; nStream <= LastStream; nStream++)
	{
		if( nStream == StreamNum && StreamNum != 0 )
			continue;	/* Pas de ping pong */

		for(nNodePos = 0; nNodePos < NODE_MAXANODE; nNodePos++)
		{
			char szNodeCall[16];

			/* Indicatif node */
			NODE_getNodeCall(nStream, nNodePos, szNodeCall);
			if( szNodeCall[0] == SNULL )
				break;	/* fin de table atteinte */

			if( ! strcmp(szToUser, szNodeCall) && nStream != 0 )
			{
				/* Talk adresse a un cluster */
				PROTOCOL_sendTalkProt(nStream, FromNode,
					FromUser, szNodeCall, szToUser,
					String, Flag, DateTime, FALSE, Hops);
				nDone = TRUE;
			}

			/* Parcourir la liste des utilisateurs */
			for(nUserPos = 0; nUserPos <= 65; nUserPos++)
			{
				char szUserCall[16];

				NODE_getUserCall(nStream, nNodePos, nUserPos, szUserCall);
				if( szUserCall[0] == SNULL )
					continue; /* Pas d'utilisateur ici */

				if( nStream == 0 ) /* Utilisateur local ? */
				{
					char cBellFlag = ' ';
					int  nUserStream;
					char szTime[16];

					TOOLS_removeSsid(szUserCall);

					if( strcmp(szUserCall, szToUser_nossid) )
						continue;

					/* Stream de l'utilisateur */
					nUserStream = nUserPos;// - ANODE_USEROFFSET;

					/* Bingo : adresser le message au destinataire */
					if( ! (USERS_getFlags(nUserStream) & USERS_NOTALKBEEP) )
						cBellFlag = BELL;

					BUFFERS_printBuff(nUserStream, OUT, "%s de %s: <%sZ> %s%c\n",
							  ToUser,
							  FromUser,
							  TOOLS_whatTime(szTime),
							  String,
							  cBellFlag);

					nDone = TRUE;
				}
				else	/* Recherche de l'utilisateur sur le reseau */
				{
					if( strcmp(szUserCall, szToUser) )
						continue;

					/* Router le protocole */
					if( nStream == StreamNum )
						continue;	/* loop */
					PROTOCOL_sendTalkProt(nStream, FromNode, FromUser, szNodeCall,
							      szToUser, String, Flag, DateTime, FALSE, Hops);

					nDone = TRUE;

				} /* End IF */
			} /*End FOR nUserPos */
		} /* End FOR nNodePos */
	} /* End FOR nStream */

	if( nDone == FALSE && szToNode[0] != SNULL )
	{
		/* External - verifier que l'adjacent existe */
		if( ! NODE_isNodeConnected(szToNode, &nStream, &nNodePos) )
			return FALSE;

		PROTOCOL_sendTalkProt(nStream, FromNode, FromUser, szToNode,
				      szToUser, String, Flag, DateTime, TRUE, Hops);
		return TRUE;
	}

	return nDone;
}

/*-------------------------------------------------------------------------
  ------ Transmettre une config utilisateur -------------------------------
  -------------------------------------------------------------------------
  Cette fonction met egalement a jour le flag en memoire
*/
int PROTOCOL_sendUserFlag(int StreamNum, char * pszFromPC, char * pszFromUser, int nType, int nIsEnable, int nHops)
{
	char	szPavillon[256];
	char	szCluLink[256];
	char    szNodeCall[16];
	char    szCallSign[16];
	int	nCluLinkPos;
	int	nPc = -1;
	int	nNodePos;
	int	nUserPos;
	int	nDone = 0;
	int	nMinPos = 0;
	int	nMaxPos = NODE_MAXANODE;
	unsigned char cFlag;
	unsigned char cCluLinkFlag;

	/* Un cluster a t-il ete specifie ? */
	if( pszFromPC && pszFromPC[0] )
	{
		if( StreamNum == 0 )
			nMinPos = 0;
		else
			nMinPos = NODE_searchNode(StreamNum, pszFromPC);

		nMaxPos = nMinPos + 1;

		if( nMinPos == -1 )
			return LOG_PROT_NODEUNKNOWN;	/* Pas Trouve */
	}

	/* Rechercher l'utilisateur/cluster */
	for(nNodePos = nMinPos; nNodePos < nMaxPos; nNodePos++)
	{
		/* Indicatif node */
		NODE_getNodeCall(StreamNum, nNodePos, szCallSign);
		if( szCallSign[0] == SNULL )
			break;	/* fin de table atteinte */

		strcpy(szNodeCall, szCallSign);

		/* Est-ce un cluster ? */
		if( ! strcmp(szCallSign, pszFromUser) )
		{
			nDone = 1;		/* cluster */
			break;
		}

		/* Est-ce un utilisateur ? */
		for(nUserPos = 0; nUserPos < 65; nUserPos++)
		{
			NODE_getUserCall(StreamNum, nNodePos, nUserPos,
				szCallSign);
			if( szCallSign[0] == SNULL )
				continue; /* Pas d'utilisateur ici */
			if( ! strcmp(szCallSign, pszFromUser) )
			{
				nDone = 2; 	/* utilisateur */
				break;
			}
		}
	}

	/* Mettre a jour le cFlag */
	switch( nDone )
	{
	case 1 :	/* cluster */
		cFlag = NODE_getNodeFlag(StreamNum, nNodePos);
		switch( nType )
		{
		case PROTOCOL_USER_HERE :
			if( nIsEnable )
				cFlag |= BIT6;
			else
				cFlag &= ~BIT6;
			break;

		case PROTOCOL_USER_CLUSTERCONF :
			if( nIsEnable )
				cFlag |= BIT7;
			else
				cFlag &= ~BIT7;
			break;
		}
		NODE_setNodeFlag(StreamNum, nNodePos, cFlag);

		/* Convertir pour le protocol clulink */
		cCluLinkFlag  = (cFlag & BIT6) ? PROTOCOL_USER_HERE : 0;
		cCluLinkFlag |= (cFlag & BIT7) ? PROTOCOL_USER_CLUSTERCONF : 0;
		break;

	case 2 :	/* utilisateur */
		cFlag = NODE_getUserFlag(szNodeCall, pszFromUser);
		switch( nType )
		{
		case PROTOCOL_USER_HERE :
			if( nIsEnable )
				cFlag |= PROTOCOL_USER_HERE;
			else
				cFlag &= ~PROTOCOL_USER_HERE;
			break;

		case PROTOCOL_USER_CLUSTERCONF :
			if( nIsEnable )
				cFlag |= PROTOCOL_USER_CLUSTERCONF;
			else
				cFlag &= ~PROTOCOL_USER_CLUSTERCONF;
			break;
		}
		NODE_setUserFlag(szNodeCall, pszFromUser, cFlag);

		/* Copier, pour le protocole CluLink */
		cCluLinkFlag = cFlag;
		break;

	default :
		return LOG_PROT_USERUNKNOWN;	/* Pas trouve */
	}

	/* Mettre a jour le cFlag et creer le protocole pavillon */
	switch( nType )
	{
	case PROTOCOL_USER_HERE :
	    sprintf(szPavillon, "PC24^%s^%c^", pszFromUser,
		(cCluLinkFlag & PROTOCOL_USER_HERE ? '1' : '0'));
	    nPc = PC24;
	    break;

	case PROTOCOL_USER_CLUSTERCONF :
		if( cCluLinkFlag & PROTOCOL_USER_CLUSTERCONF )
		{
			sprintf(szPavillon, "PC13^%s^", pszFromUser);
			nPc = 13;
		}
		else
		{
			sprintf(szPavillon, "PC14^%s^", pszFromUser);
			nPc = 14;
		}
		break;

	default :
		return LOG_PROT_UNEXPECTEDERROR;
	}

	/* Creer le protocole CluLink */
	nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(10));
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, szNodeCall,  nCluLinkPos);
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszFromUser, nCluLinkPos);
	szCluLink[nCluLinkPos++] = cCluLinkFlag;

	/* Envoyer au adjacents */
	PROTOCOL_sendProt(StreamNum, szNodeCall, nPc, szPavillon, szCluLink,
		nHops, nCluLinkPos, PROTOCOL_ALL, -1);

	return LOG_PROT_OK;
}

/*---------------------------------------------------------------------------
  ------ Gestion des PINGS --------------------------------------------------
  ---------------------------------------------------------------------------
*/
int PROTOCOL_ping(int StreamNum, char * FromNode, char * ToNode, int PingFlag, int Hops)
{
	char	sMyNodeCall[11];
	char  sPavillon[256];
	char	sCluLink[256];
	int	iStream;
	int	iNodePos;

	/* L'indicatif du serveur */
	NODE_getNodeCall(0, 0, sMyNodeCall);

	/* Le ping est-il pour moi ? */
	if( ! strcmp(ToNode, sMyNodeCall) )
	{

		/* Quelle direction ? */
		if( PingFlag == PROTOCOL_PING_ASK )
		{
			/* Repondre */
			/* Creer le protocole Pavillon */
			sprintf(sPavillon, "PC51^%s^%s^0^", FromNode, ToNode);

			/* Creer le protocole CluLink */
			iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(12));
			//Ajouter l'indicatif du cluster de depart (cad moi)
			iCluLinkPos = PROTOCOL_addPascalString(sCluLink, ToNode, iCluLinkPos);
			//Ajouter l'indicatif du cluster destinataire
			iCluLinkPos = PROTOCOL_addPascalString(sCluLink, FromNode, iCluLinkPos);
			//Ajouter le PingFlag
			sCluLink[iCluLinkPos++] = 0;
			//Transmettre le protocole
			PROTOCOL_sendProt(0, NULL, PC51, sPavillon, sCluLink, Hops, iCluLinkPos, StreamNum, -1);
		}
		else
		{
			/* Envoyer le calcul du temps aller-retour a l'utilisateur */
			PING_sendUser(StreamNum, FromNode);
		}
		
		return LOG_PROT_OK;
	}
	else
	{
		/* Le PING n'etait pas pour moi. Faire suivre ... */

		/* Le cluster destinataire est-il connecte ? */
		if( ! NODE_isNodeConnected(ToNode, &iStream, &iNodePos) )
			return LOG_PROT_NODEUNKNOWN;

		/* Creer le protocole Pavillon */
		sprintf(sPavillon, "PC51^%s^%s^%c^", ToNode, FromNode, (PingFlag == PROTOCOL_PING_ASK ? '1' : '0') );

		//------ Creer le protocole CluLink ------
		iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(12));
		//Ajouter l'indicatif du cluster de depart
		iCluLinkPos = PROTOCOL_addPascalString(sCluLink, FromNode, iCluLinkPos);
		//Ajouter l'indicatif du cluster destinataire
		iCluLinkPos = PROTOCOL_addPascalString(sCluLink, ToNode, iCluLinkPos);
		//Ajouter le PingFlag
		sCluLink[iCluLinkPos++] = (unsigned char) PingFlag;

		/* Transmettre le protocole */
		PROTOCOL_sendProt(StreamNum, NULL, PC51, sPavillon, sCluLink, Hops, iCluLinkPos, iStream, -1);

		return LOG_PROT_OK;
	}/*End IF*/
}

/*--------------------------------------------------------------------------
  ------ Envoyer un WWV ----------------------------------------------------
  --------------------------------------------------------------------------
*/
int PROTOCOL_sendWwv(int StreamNum, char * NodeCall, char * UserCall, int SFI, int A, int K, char * Date, char * Time, char * Forecast, int Hops)
{
	unsigned long lDateTime;
	unsigned long lDatas;
	char sPavillon[256];
	char sCluLink[256];
	char sBuffer[256];
	char sLogger[11];
	char szTime[8];
	int	 nWAZ;

	/* PacketCluster ne veut pas de champ vide */
	if( *Forecast == SNULL )
		strcpy(Forecast, " ");

	nWAZ = FILTER_searchWAZ(NodeCall);
	if( ! FILTER_isOK(StreamNum, FILTER_IN, nWAZ) )
		return LOG_PROT_WAZFILTER;		/* Filtre */

	/* Est-ce un double ? */
	if( WWV_isDupe(UserCall, Forecast, Date, Time, SFI, A, K) )
		return LOG_PROT_DUPE;

	if( ! WWV_isAllowed(Date, Time) )
		return LOG_PROT_WWVTWICEINWINDOW;

	/* Enregistrer le DX */
	WWV_add(NodeCall, UserCall, Forecast, Date, Time, SFI, A, K);

	/* Ne retransmettre le protocole que si ce n'est pas un MERGE */
	if( strcmp(NodeCall, "?") )
	{
		/* Creer le protocole CluLink */
		iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(65));
		iCluLinkPos = PROTOCOL_addPascalString(sCluLink, NodeCall, iCluLinkPos);
		iCluLinkPos = PROTOCOL_addPascalString(sCluLink, UserCall, iCluLinkPos);

		/* Ajouter SFI, K et A
	       Bits 0-8   : SFI (9 bits -> 512)
	       Bits 9-17  : A   (9 bits -> 512)
	       Bits 18-21 : K   (4 bits -> 16) */
		lDatas  = ((unsigned long) K) << 18;
		lDatas += ((unsigned long) A) << 9;
		lDatas +=  (unsigned long) SFI;
		iCluLinkPos = CLULINK_addLong(sCluLink, &lDatas, iCluLinkPos);

		lDateTime = TOOLS_dateTime_Str2Long(Date, Time);
		iCluLinkPos = CLULINK_addLong(sCluLink, &lDateTime, iCluLinkPos);

		iCluLinkPos = PROTOCOL_addPascalString(sCluLink, Forecast, iCluLinkPos);

		/* Creer le protocol Pavillon */
		if( Time[0] == '0' )
		{
			szTime[0] = Time[1];
			szTime[1] = SNULL;
		}
		else
		{
			szTime[0] = Time[0];
			szTime[1] = Time[1];
			szTime[2] = SNULL;
		}
		sprintf(sPavillon, "PC23^%s^%2s^%3d^%3d^%2d^%1s^%s^%s^", Date,
							   szTime,
						       SFI,
						       A,
						       K,
						       Forecast,
						       UserCall,
						       NodeCall);
		/* Envoyer le protocol */
		PROTOCOL_sendProt(StreamNum, NodeCall, PC23, sPavillon, sCluLink,
			Hops, iCluLinkPos, PROTOCOL_ALL, nWAZ);
	}

	/* Maintenant generer l'information a transmettre aux utilisateurs */
	strcpy(sLogger, UserCall);
	strcat(sLogger, ":");

	sprintf(sBuffer, "WWV de %-7s SFI=%d A=%d K=%d %-30s %4sZ%c%c\n", sLogger,
								    SFI,
								    A,
								    K,
								    Forecast,
								    Time,
								    BELL,
								    BELL);
	USERS_sendAll(sBuffer, USERS_ALL, PROTOCOL_WWV, nWAZ);
	return LOG_PROT_OK;
}

/*--------------------------------------------------------------------------
  ------ Transmettre un SendSubject ----------------------------------------
  --------------------------------------------------------------------------
  Streamnum indique LE NUMERO DU STREAM sur lequel doit etre forwarde le MAIL
*/
void PROTOCOL_sendSubject(int StreamNum, char * ToNode, char * FmNode, char * Recipient, char * Sender, char * Date, char * Time, int Private, char * Subject, int NumOfLines, char * StartNode, BYTE RetReceipt)
{
	unsigned long lDateTime;
	char sPavillon[256];
	char sCluLink[256];
	unsigned char cFlag;

	/* Initialiser */
	PROTOCOL_lFwdMesNum[StreamNum] = 0L;

	/* Pavillon */
	sprintf(sPavillon, "PC28^%1s^%1s^%1s^%1s^%1s^%sZ^%c^%1s^ ^%d^%d^ ^%1s^",
		     ToNode,
		     FmNode,
		     Recipient,
		     Sender,
		     Date,
		     Time,
		     (Private == TYPE_P ? '1' : '0'),
		     Subject,
		     NumOfLines,
		     RetReceipt,
		     StartNode);


	/* CluLink */
	iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(95));
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, FmNode, iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, Sender, iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, ToNode, iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, Recipient, iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, StartNode, iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, Subject, iCluLinkPos);
	lDateTime = TOOLS_dateTime_Str2Long(Date, Time);
	iCluLinkPos = CLULINK_addLong(sCluLink, &lDateTime, iCluLinkPos);

	/* Ajouter le Message Flag */
	if( NumOfLines > 31 )	/* Nombre de bits limites a 4 (0-4) */
		NumOfLines = 31;
	cFlag  = (unsigned char) NumOfLines;
	cFlag |= (Private == TYPE_P ? 128 : 0);	//perso
	cFlag |= (RetReceipt == TRUE ? 64 : 0);	//return receipt
	sCluLink[iCluLinkPos++] = cFlag;

	/* Envoyer le protocol */
	PROTOCOL_sendProt(0, NULL, PC28, sPavillon, sCluLink, 100, iCluLinkPos, StreamNum, -1);
}


/*--------------------------------------------------------------------------
  ------ Transmettre l'Ack-Subject (mail fwd) ------------------------------
  --------------------------------------------------------------------------
*/
void PROTOCOL_sendAckSubject(int StreamNum, char * ToNode, char * FmNode, unsigned long MesNum)
{
	char  sPavillon[256];
	char	sCluLink[256];

	/* Pavillon */
	sprintf(sPavillon, "PC30^%s^%s^%ld^", ToNode, FmNode, MesNum);

	/* CluLink */
	iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(96));
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, FmNode, iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, ToNode, iCluLinkPos);

	/* envoyer */
	PROTOCOL_sendProt(0, NULL, PC30, sPavillon, sCluLink, 100, iCluLinkPos, StreamNum, -1);
}

//--------------------------------------------------------------------------
//------ Transmettre du texte ----------------------------------------------
//--------------------------------------------------------------------------
void PROTOCOL_sendText(int StreamNum, char * ToNode, char * FmNode, unsigned long MesNum, char * Text)
{
	char  sPavillon[256];
	char	sCluLink[256];

	/* Creer le protocole Pavillon */
	sprintf(sPavillon, "PC29^%1s^%1s^%ld^%1s^", ToNode, FmNode, MesNum, Text);

	/* Creer le protocole CluLink */
	iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(97));
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, FmNode, iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, ToNode, iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, Text, iCluLinkPos);
  
	/* Envoyer le protocol */
	PROTOCOL_sendProt(0, NULL, PC29, sPavillon, sCluLink, 100, iCluLinkPos, 
		StreamNum, -1);
}

//--------------------------------------------------------------------------
//------ Transmettre l'Ack-Text (mail fwd) ---------------------------------
//--------------------------------------------------------------------------
void PROTOCOL_sendAckText(int StreamNum, char * ToNode, char * FmNode, unsigned long MesNum)
{
  char  sPavillon[256];
  char	sCluLink[256];

  //------ Creer le protocole Pavillon ------
  sprintf(sPavillon, "PC31^%s^%s^%ld^", ToNode, FmNode, MesNum);

  //------ Creer le protocole CluLink ------
  iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(98));

  //Ajouter l'indicatif du Cluster (le mien)
  iCluLinkPos = PROTOCOL_addPascalString(sCluLink, FmNode, iCluLinkPos);

  //Ajouter l'indicatif du cluster destinataire
  iCluLinkPos = PROTOCOL_addPascalString(sCluLink, ToNode, iCluLinkPos);

  //Envoyer le protocol
  PROTOCOL_sendProt(0, NULL, PC31, sPavillon, sCluLink, 100, iCluLinkPos, StreamNum, -1);
}

/*--------------------------------------------------------------------------
  ------ Transmettre CompleteText ------------------------------------------
  --------------------------------------------------------------------------*/
void PROTOCOL_sendCompleteText(int StreamNum, char * ToNode, char * FmNode, unsigned long MesNum)
{
	char sPavillon[256];
  	char sCluLink[256];

	/* Creer le protocole Pavillon */
  	sprintf(sPavillon, "PC32^%s^%s^%ld^", ToNode, FmNode, MesNum);

  	/* Creer le protocole CluLink */
  	iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(99));
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, FmNode, iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, ToNode, iCluLinkPos);

	/* Envoyer le protocol */
  	PROTOCOL_sendProt(0, NULL, PC32, sPavillon, sCluLink, 100, 
		iCluLinkPos, StreamNum, -1);
}


//--------------------------------------------------------------------------
//------ Transmettre l'Ack-CompleteText (mail fwd) -------------------------
//--------------------------------------------------------------------------
void PROTOCOL_sendAckCompleteText(int StreamNum, char * ToNode, char * FmNode, unsigned long MesNum)
{
  char  sPavillon[256];
  char	sCluLink[256];

  //------ Creer le protocole Pavillon ------
  sprintf(sPavillon, "PC33^%s^%s^%ld^", ToNode, FmNode, MesNum);

  //------ Creer le protocole CluLink ------
  iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(100));

  //Ajouter l'indicatif du Cluster (le mien)
  iCluLinkPos = PROTOCOL_addPascalString(sCluLink, FmNode, iCluLinkPos);

  //Ajouter l'indicatif du cluster destinataire
  iCluLinkPos = PROTOCOL_addPascalString(sCluLink, ToNode, iCluLinkPos);

  //Envoyer le protocol
  PROTOCOL_sendProt(0, NULL, PC33, sPavillon, sCluLink, 100, iCluLinkPos, StreamNum, -1);
}

//--------------------------------------------------------------------------
//------ Transmettre un Abort Forwarding -----------------------------------
//--------------------------------------------------------------------------
void PROTOCOL_abortForwarding(int StreamNum)
{
  char	sToNode[10];
  char	sMyNodeCall[10];
  char  sPavillon[256];
  char	sCluLink[256];

  //Rechercher l'indicatif de l'adjacent
  NODE_getNodeCall(StreamNum, 0, sToNode);
  NODE_getNodeCall(0,         0, sMyNodeCall);

  //Message sur la console
  BUFFERS_printBuff(BUFFER_SCREEN1, OUT, "*** Forwarding timeout with %s.\n", sToNode);

  //Ne pas envoyer de timeout si le numero de message est encore inconnu
  if( ! PROTOCOL_lFwdMesNum[StreamNum] )
    return;

  //------ Creer le protocole Pavillon ------
  sprintf(sPavillon, "PC42^%s^%s^%ld^", sToNode, sMyNodeCall, PROTOCOL_lFwdMesNum[StreamNum]);

  //------ Creer le protocole CluLink ------
  iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(101));

  //Ajouter l'indicatif du Cluster (le mien)
  iCluLinkPos = PROTOCOL_addPascalString(sCluLink, sMyNodeCall, iCluLinkPos);

  //Ajouter l'indicatif du cluster destinataire
  iCluLinkPos = PROTOCOL_addPascalString(sCluLink, sToNode, iCluLinkPos);

  //Envoyer le protocol
  PROTOCOL_sendProt(0, NULL, PC42, sPavillon, sCluLink, 100, iCluLinkPos, StreamNum, -1);
}

/*--------------------------------------------------------------------------
  ------ Transmettre le user count (PC50) ----------------------------------
  --------------------------------------------------------------------------
  iToAll indique si le protocole doit etre adresse a TOUS les adjacents (cas
  d'un protocole recu d'un autre cluster) ou seulement a un seul
  (cas ou c'est "moi" qui envoie le PC50)
*/
void PROTOCOL_userCount(int StreamNum, char * sFromNode, int iToAll, unsigned short shUserCount, int iHops)
{
	char sPavillon[256];
	char sCluLink[256];

	if( iToAll == FALSE )	//Requete locale, calculer le nombre de users a envoyer
	{
		int	iNodes,
		iLocalUsers,
		iTotalUsers,
		iMaxUsers;

		NODE_getConfig(iNodes, iLocalUsers, iTotalUsers, iMaxUsers);

		if( HOPS_isExternal(StreamNum) )
		{
			char szAdjacentCall[16];

			/* Link external, transmettre le nombre d'utilisateur total du
			   reseau moins (bien sur) le nombre d'utilisateurs connectes
			   au link adjacent */
			NODE_getNodeCall(StreamNum, 0, szAdjacentCall);
			iTotalUsers -= NODE_getUserCount(StreamNum, szAdjacentCall);

			shUserCount = (unsigned short) iTotalUsers;
		}
		else
		{
			/* Link normal, transmettre seulement les localusers */
			shUserCount = (unsigned short) iLocalUsers;
		}
	}
	else
	{
		NODE_setUserCount(StreamNum, sFromNode, (int) shUserCount);
	}

	/* Pavillon */
	sprintf(sPavillon, "PC50^%s^%d^", sFromNode, shUserCount);

	/* CluLink */
	iCluLinkPos = PROTOCOL_setCluLink(sCluLink, CL(13));
	iCluLinkPos = PROTOCOL_addPascalString(sCluLink, sFromNode, iCluLinkPos);
	iCluLinkPos = CLULINK_addShort(sCluLink, &shUserCount, iCluLinkPos);
	
	
	/* Envoyer le protocole */
	if( iToAll == TRUE )
	{
		extern int FirstStream;		/* switch.cpp */
		extern int LastStream;		/* switch.cpp */

		for(int index = FirstStream; index <= LastStream; index++)
		{
			if( ! (STREAMS_level[index] & LEVEL_cluster ) )
				continue; /* Ce n'est pas un cluster */

			if( HOPS_isExternal(index) )
				continue; /* Link external : ne pas distribuer */

			PROTOCOL_sendProt(StreamNum, sFromNode, PC50, sPavillon, sCluLink,
				iHops, iCluLinkPos, index, -1);
		}

		/* Mettre a jour le user count dans la table */
		HOPS_updateHops(sFromNode, iHops, PC50);
	}
	else
	{
		PROTOCOL_sendProt(0, sFromNode, PC50, sPavillon, sCluLink, iHops, iCluLinkPos, StreamNum, -1);
	}
}

/*--------------------------------------------------------------------------
  ------ Send/FWD a DB request (PC44) --------------------------------------
  --------------------------------------------------------------------------
  Return value : LOG_PROT_OK | LOG_PROT_UNKNOWN | LOG_PROT_PINGPONG
*/
int PROTOCOL_dbRequest(int StreamNum, char * szFromNode, char * szToNode, int nUserStream, char * szQualifier, char * szKey, char * szFromUser)
{
	char szPavillon[256];
	char szCluLink[256];
	int  nStream;	/* Numero du port sur lequel router */
	int  nDummy;	/* Necessaire pour l'appel d'une fonction */

	if( ! NODE_isNodeConnected(szToNode, &nStream, &nDummy) )
	{
		/*Impossible de trouver le node - prevenir celui qui a fait la demande*/
		if( StreamNum != 0 )
		{
			/* Ecrire les protocoles ICI */
		}
		return LOG_PROT_NODEUNKNOWN;
	}

	/* Pas de ping-pong !! */
	if( StreamNum == nStream )
		return LOG_PROT_PINGPONG;

	/* Protocole PAVILLON */
	sprintf(szPavillon, "PC44^%s^%s^%d^%s^%1s^%s^", szToNode, szFromNode,
		nUserStream, szQualifier, szKey, szFromUser);

	/* Protocole CLULINK */
	TOOLS_maxLength(szQualifier, 20);
	TOOLS_maxLength(szKey,       20);
	iCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(160));
	iCluLinkPos = PROTOCOL_addPascalString(szCluLink, szFromNode,  iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(szCluLink, szToNode,    iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(szCluLink, szFromUser,  iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(szCluLink, szQualifier, iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(szCluLink, szKey,       iCluLinkPos);
	szCluLink[iCluLinkPos++] = (char) nUserStream;

	/* Envoyer le protocole */
	PROTOCOL_sendProt(0, NULL, PC44, szPavillon, szCluLink, 100, iCluLinkPos, nStream, -1);

	return LOG_PROT_OK;
}

/*--------------------------------------------------------------------------
  ------ Transmettre un DB response (PC45) ---------------------------------
  --------------------------------------------------------------------------
*/
int PROTOCOL_dbResponse(int StreamNum, char * szFromNode, char * szToNode, int nUserStream, char * szInfo)
{
	char szPavillon[256];
	char szCluLink[256];
	int  nStream;	/*Numero du port sur lequel router*/
	int  nDummy;	/*Necessaire pour l'appel d'une fonction*/

	if( ! NODE_isNodeConnected(szToNode, &nStream, &nDummy) )
		return LOG_PROT_NODEUNKNOWN;	/* Impossible de trouver le node ! */

	/* Pas de ping-pong !! */
	if( StreamNum == nStream )
		return LOG_PROT_PINGPONG;

	TOOLS_maxLength(szInfo, 128);	/* 128 parce que je l'ai decide ! */

	/* Protocole PAVILLON */
	sprintf(szPavillon, "PC45^%s^%s^%d^%1s^", szToNode, szFromNode, nUserStream, szInfo);

	/* Protocole CLULINK */
	iCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(161));
	iCluLinkPos = PROTOCOL_addPascalString(szCluLink, szFromNode,  iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(szCluLink, szToNode,    iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(szCluLink, szInfo,      iCluLinkPos);
	szCluLink[iCluLinkPos++] = (char) nUserStream;

	/* Envoyer le protocole */
	PROTOCOL_sendProt(0, NULL, PC45, szPavillon, szCluLink, 100, iCluLinkPos, nStream, -1);

	return LOG_PROT_OK;
}

/*--------------------------------------------------------------------------
  ------ Transmettre un DB complete (PC46) ---------------------------------
  --------------------------------------------------------------------------
*/
#pragma argsused
int PROTOCOL_dbComplete(int StreamNum, char * szFromNode, char * szToNode, int nUserStream)
{
	char szPavillon[256];
	char szCluLink[256];
	int  nStream;	/* Numero du port sur lequel router */
	int  nDummy;	/* Necessaire pour l'appel d'une fonction */

	if( ! NODE_isNodeConnected(szToNode, &nStream, &nDummy) )
		return LOG_PROT_NODEUNKNOWN;	/*Impossible de trouver le node ! */

	/* Protocole PAVILLON */
	sprintf(szPavillon, "PC46^%s^%s^%d^", szToNode, szFromNode, nUserStream);

	/* Protocole CLULINK */
	iCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(162));
	iCluLinkPos = PROTOCOL_addPascalString(szCluLink, szFromNode,  iCluLinkPos);
	iCluLinkPos = PROTOCOL_addPascalString(szCluLink, szToNode,    iCluLinkPos);
	szCluLink[iCluLinkPos++] = (char) nUserStream;

	/* Envoyer le protocole */
	PROTOCOL_sendProt(0, NULL, PC46, szPavillon, szCluLink, 100, iCluLinkPos, nStream, -1);

	return LOG_PROT_OK;
}

/*--------------------------------------------------------------------------
  ------ Transmettre PC38 (Connected node list) ----------------------------
  -------------------------------------------------------------------------- */
void PROTOCOL_sendConnectedNodeList(int StreamNum)
{
	/* Ce protocol est transmit uniquement pour compatibilite avec
	   d'autre systemes - Dxnet ne l'utilise pas */

	int	nSize = 0;
	int	nCallSignLength;
	int	nNodeStream;
	int	nNodePos;
	char	szNodeCall[16];

	if( PROTOCOL_linkType[StreamNum] == CLU_LINK )
		return; 	/* Termine ! */

	for(nNodeStream = 0; nNodeStream <= 64; nNodeStream++)
	{
		/* Est-ce un cluster ou MYCALL ? */
		if( nNodeStream == 0 || ! (STREAMS_level[nNodeStream] & LEVEL_cluster) )
			continue; /* Non ! */

		/* Pas de ping-pong ... */
		if( nNodeStream == StreamNum )
			continue;

		/* Parcourir toutes les positions de ce stream */
		for( nNodePos = 0; nNodePos < NODE_MAXANODE; nNodePos++)
		{
			/* Indicatif du cluster */
			NODE_getNodeCall(nNodeStream, nNodePos, szNodeCall);
			nCallSignLength = strlen(szNodeCall);

			if( szNodeCall[0] == SNULL )
				continue;	/* Pas d'indicatif */

			/* Loop filter */
			if( HOPS_lFilterFix(StreamNum, szNodeCall, nNodeStream,
			    PC38, HOPS_OUT) == 0 )
			    break;

			/* Ne pas depasser 240 caracteres */
			if( (nSize + nCallSignLength) > 240 )
			{
				/* Fin de la trame */
				BUFFERS_printBuff(StreamNum, OUT, "^~\n");
				nSize = 0;
			}


			if( nSize == 0 )
				BUFFERS_printBuff(StreamNum, OUT, "PC38^");	/* Debut de la trame */
			else
				BUFFERS_printBuff(StreamNum, OUT, ",");		/* Separation entre champs */

			nSize += nCallSignLength + 6;

			BUFFERS_printBuff(StreamNum, OUT, "%s", szNodeCall);
		}
	}

	if( nSize != 0 )
		BUFFERS_printBuff(StreamNum, OUT, "^~\n");
}

/*------------------------------------------------------------------------
  ------ Transmettre un Remote CMD ---------------------------------------
  ------------------------------------------------------------------------
  Retourne : PROT_LOG_OK | LOG_PROT_NODEUNKNOWN | PROT_INTERNALERROR
*/
int PROTOCOL_rCmd(int StreamNum, char * pszFromPC, char * pszToPC, char * pszUser, char * pszCmd)
{
	char szMyNodeCall[16];
	int  nRet = LOG_PROT_OK;

	/* Indicatif du serveur */
	NODE_getNodeCall(0, 0, szMyNodeCall);

	/* Ce protocol est il pour moi ? */
	if( ! strcmp(pszToPC, szMyNodeCall) )
	{
		/* OUI : Traiter la commande */
		FILE * 	fPtr;
		char    szBuffer[256];
		char	szResponse[512];

		RCMD_setOriginCluster(pszFromPC);

		unlink(TEMP_RCMD_FILE);
		STREAMS_level[RCMD_VIRTSTREAM + StreamNum] = LEVEL_user | LEVEL_sysopD | LEVEL_sysopV;
		CMD_execute(RCMD_VIRTSTREAM + StreamNum, pszCmd);

		/* Renvoyer la reponse */
		fPtr = fopen(TEMP_RCMD_FILE, "rt");
		if( ! fPtr )
		{
			perror("fopen in PROTOCOL_rCmd");
			return LOG_INTERNALERROR;
		}

		while( fgets(szBuffer, 255, fPtr) )
		{
			TOOLS_removeNR(szBuffer);
			sprintf(szResponse, "%s: %s", szMyNodeCall, szBuffer);
			nRet = PROTOCOL_rCmdResponse(0, pszToPC, pszFromPC, pszUser, szResponse);
		}

		fclose(fPtr);
		return nRet;
	}
	else
	{
		/* NON : faire suivre le protocole */
		int	nStream;
		int	nNodePos;
		int	nCluLinkPos;
		char szPavillon[256];
		char szCluLink[256];
		
		/* Chercher le stream sur lequel router le protocole */
		if( ! NODE_isNodeConnected(pszToPC, &nStream, &nNodePos) )
			return LOG_PROT_NODEUNKNOWN;

		if( ! HOPS_isEnhanced(nStream) || pszUser == NULL || (pszUser && *pszUser == SNULL) )
		{
			/* L'utilisateur n'a pas ete specifie : PC34 */
			/* Creer le protocole Pavillon */
			sprintf(szPavillon, "PC34^%s^%s^%1s^", pszToPC,
							       pszFromPC,
							       pszCmd);
		}
		else
		{
			/* L'utilisateur a ete specifie : PC84 */
			sprintf(szPavillon, "PC84^%s^%s^%s^%1s^", pszToPC,
								  pszFromPC,
								  pszUser,
								  pszCmd);
		}

		/* Creer le protocol CluLink */
		nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(202));
		nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszFromPC, nCluLinkPos);
		nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszToPC,   nCluLinkPos);
		if( pszUser != NULL )
			nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszUser, nCluLinkPos);
		else
			nCluLinkPos = PROTOCOL_addPascalString(szCluLink, "",      nCluLinkPos);
		nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszCmd,    nCluLinkPos);

		PROTOCOL_sendProt(StreamNum, NULL, PC34, szPavillon,
				szCluLink, 100, nCluLinkPos, nStream, -1);

	} /* End IF */

	return LOG_PROT_OK;
}

/*------------------------------------------------------------------------
  ------ Transmettre une reponse a un Remote CMD -------------------------
  ------------------------------------------------------------------------
  Retourne : PROT_LOG_OK | LOG_PROT_NODEUNKNOWN
*/
int PROTOCOL_rCmdResponse(int StreamNum, char * pszFromPC, char * pszToPC, char * pszUser, char * pszResponse)
{
	char szMyNodeCall[16];

	/* Indicatif du serveur */
	NODE_getNodeCall(0, 0, szMyNodeCall);

	/* Limiter la longueur de la chaine a 200 octets afin d'eviter les
	   effet de bords */
	TOOLS_maxLength(pszResponse, 254);

	/* Ce protocol est il pour moi ? */
	if( ! strcmp(pszToPC, szMyNodeCall) )
	{
		int nUserStream = -1;

		/* OUI : Traiter la commande */
		char szBuffer[256];

		strcpy(szBuffer, pszResponse);
		strcat(szBuffer, "\n");

		/* Si l'utilisateur a ete specifie, rechercher sur quel
		   stream router la reponse */
		if( pszUser != NULL && *pszUser != SNULL )
		{
			char szNodeCall[256];
			nUserStream = NODE_searchUser(pszUser, TRUE, szNodeCall);
			if( *szNodeCall != SNULL )
				nUserStream = -1;

		}

		if( nUserStream >= 0 )
			BUFFERS_addBuff(nUserStream, szBuffer, OUT);
		else
		{
			/* Utilisateur non specifie, envoyer l'info a tous
			   les sysops */
			USERS_sendAll(szBuffer, USERS_SYSOP, PROTOCOL_RCMD,
				-1);
		}
	}
	else
	{
		/* NON : faire suivre le protocole */
		int	nStream;
		int	nNodePos;
		char	szPavillon[256];
		char	szCluLink[256];
		int	nCluLinkPos;

		/* Chercher le stream sur lequel router le protocole */
		if( ! NODE_isNodeConnected(pszToPC, &nStream, &nNodePos) )
			return LOG_PROT_NODEUNKNOWN;

		if( ! HOPS_isEnhanced(StreamNum) || pszUser == NULL || *pszUser == SNULL )
		{
			/* L'utilisateur n'a pas ete specifie : PC34 */
			/* Creer le protocole Pavillon */
			sprintf(szPavillon, "PC35^%s^%s^%s^", pszToPC,
							      pszFromPC,
							      pszResponse);
		}
		else
		{
			/* L'utilisateur a ete specifie : PC84 */
			sprintf(szPavillon, "PC85^%s^%s^%s^%s^", pszToPC,
								 pszFromPC,
								 pszUser,
								 pszResponse);
		}

		nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(203));
		nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszFromPC, nCluLinkPos);
		nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszToPC, nCluLinkPos);
		if( pszUser != NULL )
			nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszUser, nCluLinkPos);
		else
			nCluLinkPos = PROTOCOL_addPascalString(szCluLink, "", nCluLinkPos);
		nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszResponse, nCluLinkPos);

		/* Transmettre le protocole */
		PROTOCOL_sendProt(StreamNum, NULL, PC35, szPavillon, szCluLink, 100, nCluLinkPos, nStream, -1);
	}
	return LOG_PROT_OK;
}

/*------------------------------------------------------------------------
  ------ Transmettre un explicit disconnect ------------------------------
  ------------------------------------------------------------------------
*/
int PROTOCOL_sendExplicitDisconnect(int StreamNum, char * pszToPC, char * pszReason)
{
	char szMyNodeCall[16];
	int	nStream;
	int	nNodePos;
	char szPavillon[256];
	char szCluLink[256];
	int	nCluLinkPos;

	/* Chercher le stream sur lequel router le protocole */
	if( ! NODE_isNodeConnected(pszToPC, &nStream, &nNodePos) )
		return LOG_PROT_NODEUNKNOWN;

	if( nNodePos != 0 )
		return LOG_PROT_UNEXPECTEDERROR; 	/* erreur */

	/* Informer les adjacents */
	PROTOCOL_clusterStreamDisconnected(nStream, pszReason, -1);

	/* Prepaper et envoyer un PC39 */
	NODE_getNodeCall(0, 0, szMyNodeCall);

	/* Creer le protocole Pavillon */
	sprintf(szPavillon, "PC39^%s^%s^", szMyNodeCall, pszReason);

	/* Creer le protocole CluLink */
	nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(5));
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, szMyNodeCall, nCluLinkPos);
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszToPC,      nCluLinkPos);

	/* Transmettre le protocole */
	PROTOCOL_sendProt(StreamNum, NULL, PC39, szPavillon, szCluLink, 100, nCluLinkPos, nStream, -1);

	return LOG_PROT_OK;
}

/*------------------------------------------------------------------------
  ------ Traiter un un explicit disconnect recu --------------------------
  ------------------------------------------------------------------------
*/
int PROTOCOL_rcvExplicitDisconnect(int StreamNum, char * pszFromPC, char * pszReason, int nHops)
{
	extern char	STREAMS_callsign[MAX_STREAMS][10];
	int	nStream;
	int	nNodePos;

	/* Chercher le stream sur lequel router le protocole */
	if( ! NODE_isNodeConnected(pszFromPC, &nStream, &nNodePos) )
		return LOG_PROT_NODEUNKNOWN;

	/* Verifications */
	if( nStream != StreamNum || nNodePos != 0 )
	{
		/* Erreur : deconnection hard */
		extern unsigned long 	COMMANDS_statut[MAX_STREAMS];
		COMMANDS_statut[StreamNum] = COMMANDS_statutDisconnect;
		return LOG_PROT_UNEXPECTEDERROR;
	}

	/* Prevenir les adjacents */
	PROTOCOL_clusterStreamDisconnected(StreamNum, pszReason, nHops);

	/* Deconnecter ce cluster */
	STREAMS_level[nStream] = LEVEL_discByOp;
	STREAMS_disconnect(nStream);
	SWITCH_discSwitch (nStream);
	STREAMS_callsign[nStream][0] = SNULL;

	return LOG_PROT_OK;
}

/*------------------------------------------------------------------------
  ------ Informer les adjacents de la deconnexion qu'un stream cluster ---
  ------ et liberer la memoire que pour ce stream ------------------------
  ------------------------------------------------------------------------
  StreamNum : stream du cluster deconnecte
  nHops : Hops du PC21 a transmetre
  ------------------------------------------------------------------------
  La fonction retourne TRUE si OK et FALSE sinon */
int PROTOCOL_clusterStreamDisconnected(int StreamNum, char * pszReason, int nHops)
{
	char szNodeCall[16];
	int  hops;

	/* Verifier que le stream est bien celui d'un cluster */
	if( ! (STREAMS_level[StreamNum] & LEVEL_cluster) )
		return LOG_PROT_UNEXPECTEDERROR;

	for(int index = 0; index < NODE_MAXANODE; index++)
	{
		NODE_getNodeCall(StreamNum, index, szNodeCall);
		if( szNodeCall[0] == SNULL )
			continue;

		if( index != 0 )
		{
			/* On n'enleve pas le premier node tout de suite,
			   car il est indispensable pour les loop filters */
			NODE_deleteNode(StreamNum, szNodeCall);

			/* NODE_deleteNode decalant d'un cran les nodes,
			   decrementer l'index */
			index--;
		}

		BUFFERS_printBuff(BUFFER_SCREEN1, OUT,
				  "Node logged out : %s\n", szNodeCall);

		/* Informer les adjacent */
		if (nHops == -1 )
		{
			/* Comme c'est MOI qui demande la deconnexion, il
			   faut determiner quel hops je vais devoir
			   utiliser dans le PC21 pour ce cluster */
			int nPc16, nPc19, nPc50;
			HOPS_getHops(szNodeCall, 0, nPc16, nPc19, nPc50);
			hops = nPc19;
			hops = 100;
		}
		else
			hops = nHops;

		PROTOCOL_nodeDisconnect(StreamNum, szNodeCall, pszReason,
			1, hops);
	}

	/* Enlever maintenant le premier cluster (cf plus haut) */
	NODE_getNodeCall(StreamNum, 0, szNodeCall);
	NODE_deleteNode(StreamNum, szNodeCall);

	return LOG_PROT_OK;
}

/*------------------------------------------------------------------------
  ------ Transmettre une demande de DX/WWV Merge Request -----------------
  ------------------------------------------------------------------------
  StreamNum : numero du stream sur lequel a lieu la demande
  pszFromPC : indicatif du node demandeur (si NULL -> demande locale)
  pszToPC   : node destinataire
  nMRDX     : nombre de spots DX demandes
  nMRWWV    : nombre de spots WWV demandes
*/
int PROTOCOL_WWVDX_mergeRequest(int StreamNum, char * pszFromPC, char * pszToPC, int nMRdx, int nMRwwv)
{
	char szPavillon[256];
	char szCluLink[256];
	char szFromPC[16];
	char szMyPcCall[16];
	int  nCluLinkPos;
	int  nToPCStreamNum;
	int  nNodePos;

	/* Rechercher le stream sur lequel router le protocole */
	if( ! NODE_isNodeConnected(pszToPC, &nToPCStreamNum, &nNodePos) )
		return LOG_PROT_NODEUNKNOWN;	/* Pas trouve !! */

	if( nToPCStreamNum == StreamNum )
		return LOG_PROT_PINGPONG;	/* Ping pong !! */

	/* Est-ce pour moi ? */
	NODE_getNodeCall(0, 0, szMyPcCall);
	if( ! strcmp(pszToPC, szMyPcCall) )
	{
		int  	index;
		DXSPOT  DxSpot;
		WWVSPOT WwvSpot;
		int		nRet;

		/* Envoyer les merges demandes */
		for(index = nMRdx; index > 0; index--)
		{
			if( ! DX_get(index, &DxSpot) )
				continue;

			nRet = PROTOCOL_DXMergeInfo(nToPCStreamNum, NULL,
				pszFromPC, DxSpot.szLogger,
				DxSpot.lFrequency, DxSpot.szDate,
				DxSpot.szTime, DxSpot.szDxCall,
				DxSpot.szComments);
				
			if( nRet != LOG_PROT_OK )
				return nRet;
		}

		for(index = nMRwwv; index > 0; index--)
		{
			if( ! WWV_get(index, &WwvSpot) )
				continue;

			nRet = PROTOCOL_WWVMergeInfo(nToPCStreamNum, NULL,
				pszFromPC, WwvSpot.szLogger, WwvSpot.nSFI,
				WwvSpot.nA, WwvSpot.nK, WwvSpot.szDate,
				WwvSpot.szTime, WwvSpot.szForecast);

			if( nRet != LOG_PROT_OK )
				return nRet;
				
		}
		return LOG_PROT_OK;
	}

	/* FromPC */
	if( pszFromPC != NULL )
	{
		/* pszFromPC est precise */
		TOOLS_maxLength(pszFromPC, 15);	 /* Par securite */
		strcpy(szFromPC, pszFromPC);
	}
	else
	{
		/* pszFromPC n'est pas precise, utiliser mon indicatif */
		strcpy(szFromPC, szMyPcCall);
	}

	if( nMRwwv == 0 && nMRdx == 0 )
		return LOG_PROT_OK;	/* Inutile d'envoyer une demande nulle */

	/* Creer le protocole Pavillon */
	sprintf(szPavillon, "PC25^%s^%s^%d^%d^", pszToPC,
						 szFromPC,
						 nMRdx,
						 nMRwwv);

	/* Creer le protocole CluLink */
	nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(68));
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, szFromPC, nCluLinkPos);
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszToPC, nCluLinkPos);
	szCluLink[nCluLinkPos++] = (BYTE) nMRdx;
	szCluLink[nCluLinkPos++] = (BYTE) nMRwwv;

	/* Transmettre le protocole */
	PROTOCOL_sendProt(StreamNum, NULL, PC25, szPavillon, szCluLink, 100,
			  nCluLinkPos, nToPCStreamNum, -1);

	return LOG_PROT_OK;
}

/*------------------------------------------------------------------------
  ------ Transmettre une reponse de dx merge (dx merge info) -------------
  ------------------------------------------------------------------------
*/
int PROTOCOL_DXMergeInfo(int StreamNum, char * pszFromPC, char * pszToPC, char * pszLogger, unsigned long lFrequency, char * pszDate, char * pszTime, char * pszDxCall, char * pszComments)
{
	char szPavillon[256];
	char szCluLink[256];
	char szFromPC[16];
	char szMyPcCall[16];
	int  nCluLinkPos;
	int  nToPCStreamNum;
	int  nNodePos;
	unsigned long lDateTime;

	/* Est-ce pour moi ? */
	NODE_getNodeCall(0, 0, szMyPcCall);
	if( ! strcmp(pszToPC, szMyPcCall) )
	{
		int nHops = HOPS_fix(StreamNum, NULL, StreamNum, PC26, HOPS_IN, 100);

		if( *pszFromPC == SNULL )	/* Precaution */
			return LOG_INTERNALERROR;

		/* Traiter le protocole ...*/
		PROTOCOL_sendDx(StreamNum, "?", pszLogger,
				lFrequency, pszDate, pszTime, pszDxCall,
				pszComments, nHops);
		return LOG_PROT_OK;
	}

	/* FromPC */
	if( pszFromPC != NULL )
	{
		/* pszFromPC est precise */
		TOOLS_maxLength(pszFromPC, 15);	 /* Par securite */
		strcpy(szFromPC, pszFromPC);
	}
	else
	{
		/* pszFromPC n'est pas precise, utiliser mon indicatif */
		strcpy(szFromPC, szMyPcCall);
	}

	/* Rechercher le stream sur lequel router le protocole */
	if( ! NODE_isNodeConnected(pszToPC, &nToPCStreamNum, &nNodePos) )
		return LOG_PROT_NODEUNKNOWN;	/* Pas trouve !! */

	if( nToPCStreamNum == StreamNum )
		return LOG_PROT_PINGPONG;	/* Ping pong !! */

	/* Creer le protocole Pavillon */
	sprintf(szPavillon, "PC26^%ld.%ld^%s^%s^%sZ^%1s^%s^%s^ ^",
			    lFrequency/10L, lFrequency%10L,
			    pszDxCall,
			    pszDate,
			    pszTime,
			    pszComments,
			    pszLogger,
			    pszToPC);

	/* Creer le protocole CluLink */
	lDateTime   = TOOLS_dateTime_Str2Long(pszDate, pszTime);

	nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(69));
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, szFromPC, nCluLinkPos);
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszLogger, nCluLinkPos);
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszToPC, nCluLinkPos);
	nCluLinkPos = CLULINK_addLong(szCluLink, &lFrequency, nCluLinkPos);
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszDxCall, nCluLinkPos);
	nCluLinkPos = CLULINK_addLong(szCluLink, &lDateTime, nCluLinkPos);
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszComments, nCluLinkPos);

	/* Transmettre le protocole */
	PROTOCOL_sendProt(StreamNum, NULL, PC26, szPavillon, szCluLink, 100,
			  nCluLinkPos, nToPCStreamNum, -1);

	return LOG_PROT_OK;
}

/*------------------------------------------------------------------------
  ------ Transmettre une reponse wwv merge (wwv merge info) --------------
  ------------------------------------------------------------------------
  Retourne FALSE si probleme pour router le protocole                     */
int PROTOCOL_WWVMergeInfo(int StreamNum, char * pszFromPC, char * pszToPC, char * pszLogger, int nSFI, int nA, int nK, char * pszDate, char * pszTime, char * pszForecast)
{
	char szPavillon[256];
	char szCluLink[256];
	char szFromPC[16];
	char szMyPcCall[16];
	char szPavillonTime[8];
	int  nCluLinkPos;
	int  nToPCStreamNum;
	int  nNodePos;
	unsigned long lDateTime;
	unsigned long lData;
	int  nWAZ;

	/* Filtrage */
	nWAZ = FILTER_searchWAZ(pszFromPC);
	if( ! FILTER_isOK(StreamNum, FILTER_IN, nWAZ) )
		return LOG_PROT_WAZFILTER;		/* Filtre */

	/* Est-ce pour moi ? */
	NODE_getNodeCall(0, 0, szMyPcCall);
	if( ! strcmp(pszToPC, szMyPcCall) )
	{
		int nHops = HOPS_fix(StreamNum, NULL, StreamNum, PC27, HOPS_IN, 100);

		if( *pszFromPC == SNULL )	/* Precaution */
			return LOG_PROT_UNEXPECTEDERROR;

		/* Traiter le protocole ...*/
		PROTOCOL_sendWwv(StreamNum, "?", pszLogger, nSFI,
				 nA, nK, pszDate, pszTime, pszForecast,
				 nHops);
		return LOG_PROT_OK;
	}

	/* FromPC */
	if( pszFromPC != NULL )
	{
		/* pszFromPC est precise */
		TOOLS_maxLength(pszFromPC, 15);	 /* Par securite */
		strcpy(szFromPC, pszFromPC);
	}
	else
	{
		/* pszFromPC n'est pas precise, utiliser mon indicatif */
		strcpy(szFromPC, szMyPcCall);
	}

	/* Rechercher le stream sur lequel router le protocole */
	if( ! NODE_isNodeConnected(pszToPC, &nToPCStreamNum, &nNodePos) )
		return LOG_PROT_NODEUNKNOWN;	/* Pas trouve !! */

	if( nToPCStreamNum == nNodePos )
		return LOG_PROT_PINGPONG;	/* Ping pong !! */

	/* Creer le protocole Pavillon */
	if( pszTime[0] == '0' )
	{
		szPavillonTime[0] = pszTime[1];
		szPavillonTime[1] = SNULL;
	}
	else
	{
		szPavillonTime[0] = pszTime[0];
		szPavillonTime[1] = pszTime[1];
		szPavillonTime[2] = SNULL;
	}
	sprintf(szPavillon, "PC27^%s^%2s^%3d^%3d^%2d^%1s^%s^%s^ ^",
			    pszDate,
			    szPavillonTime,
			    nSFI, nA, nK,
			    pszForecast,
			    pszLogger,
			    pszToPC);


	/* Creer le protocole CluLink */
	lDateTime   = TOOLS_dateTime_Str2Long(pszDate, pszTime);
	/* SFI, K and A :
		Bits 0-8   : SFI (9 bits -> 512)
		Bits 9-17  : A   (9 bits -> 512)
		Bits 18-21 : K   (4 bits -> 16) */
	lData  = ((unsigned long) nK) << 18;
	lData += ((unsigned long) nA) << 9;
	lData +=  (unsigned long) nSFI;

	nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(70));
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, szFromPC, nCluLinkPos);
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszLogger, nCluLinkPos);
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszToPC, nCluLinkPos);
	nCluLinkPos = CLULINK_addLong(szCluLink, &lData, nCluLinkPos);
	nCluLinkPos = CLULINK_addLong(szCluLink, &lDateTime, nCluLinkPos);
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszForecast, nCluLinkPos);

	/* Transmettre le protocole */
	PROTOCOL_sendProt(StreamNum, NULL, PC26, szPavillon, szCluLink, 100,
			  nCluLinkPos, nToPCStreamNum, -1);

	return LOG_PROT_OK;
}

/*------------------------------------------------------------------------
  ------ Nouvel utilisateur dans la conference cluster -------------------
  ------------------------------------------------------------------------
  Si pszFromPC est inconnu, pszFromPC = "" (ne doit pas etre = NULL)
*/
int PROTOCOL_sendClusterConfLogin(int StreamNum, char * pszFromPC, char * pszFromUser, int nHops)
{
	/* Verifier que le stream est bien celui d'un cluster */
	if( StreamNum != 0 && ! (STREAMS_level[StreamNum] & LEVEL_cluster) )
		return LOG_INTERNALERROR;

	TOOLS_maxLength(pszFromPC, 9),
	TOOLS_maxLength(pszFromUser, 9);

	/* Updater en memoire et transmettre */
	return PROTOCOL_sendUserFlag(StreamNum, pszFromPC, pszFromUser, PROTOCOL_USER_CLUSTERCONF, TRUE, nHops);
}

/*------------------------------------------------------------------------
  ------ Sortie d'utilisateur de la conference cluster -------------------
  ------------------------------------------------------------------------
  Si pszFromPC est inconnu, pszFromPC = "" (ne doit pas etre = NULL)
*/
int PROTOCOL_sendClusterConfLogout(int StreamNum, char * pszFromPC, char * pszFromUser, int nHops)
{
	/* Verifier que le stream est bien celui d'un cluster */
	if( StreamNum != 0 && ! (STREAMS_level[StreamNum] & LEVEL_cluster) )
		return LOG_INTERNALERROR;

	TOOLS_maxLength(pszFromPC, 9),
	TOOLS_maxLength(pszFromUser, 9);

	/* Updater en memoire et transmettre */
	return PROTOCOL_sendUserFlag(StreamNum, pszFromPC, pszFromUser, PROTOCOL_USER_CLUSTERCONF, FALSE, nHops);
}

/*------------------------------------------------------------------------
  ------ Adresser un message a la conference cluster ---------------------
  ------------------------------------------------------------------------
  Si pszFromPC est inconnu, pszFromPC = "" (ne doit pas etre = NULL)
*/
int PROTOCOL_sendClusterConferenceMessage(int StreamNum, char * pszFromPC, char * pszFromUser, char * pszMessage, int nHops)
{
	char  szPavillon[256];
	char  szCluLink[256];
	char  szBuffer[256];
	int   nCluLinkPos;

	/* Verifier que le stream est bien celui d'un cluster */
	if( StreamNum != 0 && ! (STREAMS_level[StreamNum] & LEVEL_cluster) )
		return LOG_INTERNALERROR;

	TOOLS_maxLength(pszFromPC, 9),
	TOOLS_maxLength(pszFromUser, 9);
	TOOLS_maxLength(pszMessage, 128);

	/* protocole Pavillon */
	sprintf(szPavillon, "PC15^%s^%1s^", pszFromUser, pszMessage);

	/* protocole clulink */
	nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(142));
	if( pszFromPC && pszFromPC[0] )
	{
		/* On connait le cluster d'origine */
		nCluLinkPos = PROTOCOL_addPascalString(szCluLink,
			pszFromPC, nCluLinkPos);
	}
	else
	{
		/* On ne connait pas le cluster d'origine */
		nCluLinkPos = PROTOCOL_addPascalString(szCluLink,
			"?", nCluLinkPos);
	}
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszFromUser,
		nCluLinkPos);
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszMessage,
		nCluLinkPos);

	/* Transmettre le protocole */
	PROTOCOL_sendProt(StreamNum, pszFromPC, PC15, szPavillon, szCluLink,
		nHops, nCluLinkPos, PROTOCOL_ALL, -1);

	/* Adresser le message aux utilisateurs locaux */
	sprintf(szBuffer, "de %s: %s\n", pszFromUser, pszMessage);
	USERS_sendAll(szBuffer, USERS_CLUSTERCONF, PROTOCOL_CONFERENCE, -1);

	return LOG_PROT_OK;
}

/*------------------------------------------------------------------------
  ------ Envoyer un Forwarding abort -------------------------------------
  ------------------------------------------------------------------------ */
int PROTOCOL_sendForwardingAbort(int StreamNum, char * pszToPC, char * pszFromPC, unsigned long lMesNum)
{
	char  szPavillon[256];
	char  szCluLink[256];
	int   nCluLinkPos;

	/* Verifier que le stream est bien celui d'un cluster */
	if( StreamNum != 0 && ! (STREAMS_level[StreamNum] & LEVEL_cluster) )
		return LOG_INTERNALERROR;

	TOOLS_maxLength(pszFromPC, 9),
	TOOLS_maxLength(pszToPC, 9);

	/* protocole Pavillon */
	sprintf(szPavillon, "PC42^%s^%s^%ld^", pszToPC, pszFromPC, lMesNum);

	/* protocole clulink */
	nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(101));
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszFromPC, nCluLinkPos);
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszToPC,   nCluLinkPos);

	/* Transmettre le protocole */
	PROTOCOL_sendProt(0, NULL, PC42, szPavillon, szCluLink, 100,
		nCluLinkPos, StreamNum, -1);

	return LOG_PROT_OK;
}

/*--------------------------------------------------------------------------
  ------ Envoyer un WCY ----------------------------------------------------
  --------------------------------------------------------------------------
*/
int PROTOCOL_sendWcy(int StreamNum,char* pszDate, char* pszTime, int nSFI, int nA, int nK, int nExpK, int nR, char* pszSA, char* pszGMF, char* pszAurora, char* pszLogger, char* pszFromPC, int nHops)
{
	unsigned long  lDateTime;
	unsigned long  lData;
	unsigned short shData;
	char szPavillon[256];
	char szCluLink[256];
	char szBuffer[256];
	char szTime[16];
	char szLogger[16];
	int  nCluLinkPos;
	int  nWAZ;

	nWAZ = FILTER_searchWAZ(pszFromPC);
	if( ! FILTER_isOK(StreamNum, FILTER_IN, nWAZ) )
		return LOG_PROT_WAZFILTER;		/* Filtre */

	if( ! WCY_isAllowed(pszDate, pszTime) )
		return LOG_PROT_WWVTWICEINWINDOW;

	/* Est-ce un double ? */
	if( WCY_isDupe(pszFromPC, pszLogger, pszDate, pszTime) )
		return LOG_PROT_DUPE;

	/* Enregistrer le spot WCY */
	if( ! WCY_add(pszDate, pszTime, nSFI, nA, nK, nExpK, nR, pszSA, pszGMF,
		pszAurora, pszLogger, pszFromPC) )
		return LOG_INTERNALERROR;

	/* Creer le protocole CluLink */
	nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(71));
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszFromPC, nCluLinkPos);
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszLogger, nCluLinkPos);

	/* Date et heure */
	lDateTime   = TOOLS_dateTime_Str2Long(pszDate, pszTime);
	nCluLinkPos = CLULINK_addLong(szCluLink, &lDateTime, nCluLinkPos);

	/* Ajouter SFI, K et A
	   Bits 0-8   : SFI (9 bits -> 512)
	   Bits 9-17  : A   (9 bits -> 512)
	   Bits 18-21 : K   (4 bits -> 16) */
	lData  = ((unsigned long) nK) << 18;
	lData += ((unsigned long) nA) << 9;
	lData +=  (unsigned long) nSFI;
	nCluLinkPos = CLULINK_addLong(szCluLink, &lData, nCluLinkPos);

	/* Ajouter R et ExpK
	   Bits 0-8  : R    (9 bits -> 512)
	   Bits 9-12 : ExpK (4 bits -> 13) */
	shData  = ((unsigned int) nExpK) << 9;
	shData +=  (unsigned int) nR;
	nCluLinkPos = CLULINK_addShort(szCluLink, &shData, nCluLinkPos);

	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszSA,     nCluLinkPos);
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszGMF,    nCluLinkPos);
	nCluLinkPos = PROTOCOL_addPascalString(szCluLink, pszAurora, nCluLinkPos);

	/* Creer le protocol Pavillon */
	strcpy(szTime, pszTime);
	if( szTime[0] == '0' )
		szTime[0] = ' ';

	/* PC73^Date^Hour^SFI^A^K^Exp.K^R^SA^GMF^Aurora^Logger^FromPC^Hops^ */

	sprintf(szPavillon, "PC73^%s^%c%c^%3d^%3d^%d^%d^%3d^%1s^%1s^%1s^%s^%s^",
		pszDate,
		pszTime[0], pszTime[1],
		nSFI,
		nA,
		nK,
		nExpK,
		nR,
		pszSA,
		pszGMF,
		pszAurora,
		pszLogger,
		pszFromPC);

	/* Envoyer le protocol */
	PROTOCOL_sendProt(StreamNum, pszFromPC, PC73, szPavillon, szCluLink,
		nHops, nCluLinkPos, PROTOCOL_ALL, nWAZ);

	/* Maintenant generer l'information  transmettre aux utilisateurs */
	strcpy(szLogger, pszLogger);
	strcat(szLogger, ":");

	sprintf(szBuffer, "WCY de %-9s K=%d ExpK=%d A=%-3d R=%-3d SFI=%-3d SA=%-3s GMF=%-3s Au=%s%c%c\n",
		szLogger,
		nK,
		nExpK,
		nA,
		nR,
		nSFI,
		pszSA,
		pszGMF,
		pszAurora,
		BELL,
		BELL);

	USERS_sendAll(szBuffer, USERS_ALL, PROTOCOL_WCY, nWAZ);
	return LOG_PROT_OK;
}
