#include <alloc.h>
#include <stdio.h>
#include <string.h>
#include "define.h"
#include "tools.h"
#include "hops.h"
#include "rcmd.h"
#include "commands.h"

static char RCMD_szRemoteCallSign[16];

/*--------------------------------------------------------------------------
  ------ RCMD_isAllowed verifie si l'indicatif a le droit d'acceder a ------
  ------ la commande remote ------------------------------------------------
  --------------------------------------------------------------------------
  ATTENTION : LES SSIDs NE SONT PAS GERES
  Retour : TRUE si autorise et FALSE sinon
*/
int RCMD_isAllowed(int StreamNum, int nLevel)
{
	FILE* fPtr;
	char  szBuffer[256];
	int   nLine = 0;
	int   level = RCMD_NOTALLOWED;

	/* Si ce n'est pas sur un cannal remote, autoriser par defaut ! */
	if( StreamNum < RCMD_VIRTSTREAM )
		return TRUE;

	if( nLevel == RCMD_NOTALLOWED )
		return FALSE;

	/* Ouvrir le fichier rcmd.dat */
	fPtr = fopen(RCMD_FILE, "rt");
	if( fPtr == NULL )
	{
#ifdef LINUX
		perror("fopen in RCMD_isAllowed on ~/dxnet/system/rcmd.dat ");
#else
		perror("fopen in RCMD_isAllowed on ~\\system\\rcmd.dat ");
#endif
		return FALSE;
	}

	while( fgets(szBuffer, sizeof(szBuffer), fPtr) )
	{
		char szArg[2][256];
		int  nLength;
		int  nArg;

		nLine++;
		TOOLS_removeNR(szBuffer);
		nArg = sscanf(szBuffer, "%s %s", szArg[0], szArg[1]);

		if( *szArg[0] == '#' || nArg == 0 )
			continue;

		if( nArg != 2 )
		{
			HOPS_error2sysop(RCMD_FILE, szBuffer, nLine);
			continue;
		}

		strupr(szArg[0]);
		strupr(szArg[1]);
		nLength = strlen(szArg[0]);

		if( ! HOPS_isForCall(szArg[1], RCMD_szRemoteCallSign) )
			continue;

		if( COMMANDS_check(szArg[0], "USER", nLength, 1) )
		{
			level = RCMD_USER;
			break;
		}
		else if( COMMANDS_check(szArg[0], "SYSOP", nLength, 1) )
		{
			level = RCMD_SYSOP;
			break;
		}
		else if( COMMANDS_check(szArg[0], "DENY", nLength, 1) )
		{
			break;
		}
		else
		{
			HOPS_error2sysop(RCMD_FILE, szBuffer, nLine);
		}
	}

	fclose(fPtr);

	if( level == RCMD_SYSOP || nLevel == RCMD_USER )
		return TRUE;
	else
		return FALSE;
}

/*-------------------------------------------------------------------------
  ------ Definir l'indicatif du cluster originaire d'un remote commands ---
  -------------------------------------------------------------------------*/
void RCMD_setOriginCluster(char* pszClusterCall)
{
	TOOLS_maxLength(pszClusterCall, 15);
	strcpy(RCMD_szRemoteCallSign, pszClusterCall);
}