#include <alloc.h>
#include <string.h>
#include <stdio.h>
#include <dir.h>
#include <stdlib.h>
#include "script.h"
#include "define.h"
#include "switch.h"
#include "buffers.h"
#include "message.h"
#include "tools.h"
#include "hops.h"
#include "node.h"
#include "users.h"
#include "execute.h"
#include "log.h"
#include "fbbsrv.h"


extern	int 	FirstStream;	//Dfinis dans le module SWITCH
extern	int 	LastStream;	//idem
extern	char	STREAMS_callsign[MAX_STREAMS][10];
extern	int  	STREAMS_level[MAX_STREAMS];
extern  unsigned long MAIL_lFwdMsgNumber[MAX_STREAMS];


char	SCRIPT_continue[65][7];		//Limit  6 caractres (+NULL)
char	SCRIPT_abandon1[65][7];         //Limit  6 caractres (+NULL)
char	SCRIPT_abandon2[65][7];		//Limit  6 caractres (+NULL)
char	SCRIPT_currentLine[65];
int		SCRIPT_fromStream[MAX_STREAMS];	//Y compris la console (F2)
char	SCRIPT_fileName[65][9];		//Limit  8 caractres (+NULL), l'extension .FWD tant ajout chaque fois
int		SCRIPT_timer[65];

FILE   *fPtr;

extern tUserCfg * pUserCfg;

//--------------------------------------------------------------------------
//------ Ouvrir un stream aprs avoir effectu des vrifications -----------
//--------------------------------------------------------------------------
int SCRIPT_open(int & StreamNum, char * File)
{
  int 	index;
  int 	LookFor;
  char 	sFileName[MAXPATH];
  char 	sWhichCall[256];

  //------ Former le nom du fichier ------
  strcpy(sFileName, SCRIPT_PATH);
  strcat(sFileName, File);
  strcat(sFileName, ".fwd");
  #ifdef LINUX
  strlwr(sFileName);			//Compatibilite standard LINUX
  #endif

  //------ Chercher un stream disponible, en commencant par les derniers ---
  for(index = LastStream; index >= FirstStream; index--)
  {
    if( ! SWITCH_conStat( index ) )
      break;				//Il y a un stream de dispo
    SWITCH_ackStatut( index );
  }/*End FOR*/

  if( index < FirstStream )
    return SCRIPT_FULL;

  //------ Verifier qu'aucune init de connexion n'est deja en cours ------
  for(LookFor = FirstStream; LookFor <= LastStream; LookFor++)
  {
    if( ! strcmp(SCRIPT_fileName[LookFor], File) )
      break;
  }/*End FOR*/

  if( LookFor <= LastStream )	//c'est le cas
    return SCRIPT_TWICE;

  //------ Verifier que le fichier script existe bien ------
  fPtr = fopen(sFileName, "rt");
  if( ! fPtr )
    return SCRIPT_NOTFOUND;

  //Lire l'indicatif du cluster qu'on souhaite connecter
  if( ! fgets(sWhichCall, 255, fPtr) )
  {
    fclose (fPtr);
    return SCRIPT_NOTFOUND;
  }

  fclose( fPtr );

  //------ Verifier que le cluster n'est pas deja connecte ------
  TOOLS_removeNR(sWhichCall);
  if( NODE_isNodeConnected(sWhichCall) )
    return SCRIPT_ALREADYCONNECTED;

  //------ Connecter au switch et initialiser les variables SCRIPT ------
  if( ! SWITCH_isPcFlexNet() )
  {
    SWITCH_conSwitch( index );
    SWITCH_ackStatut( index );
  }/*End IF*/
  STREAMS_level[index]		= LEVEL_linkSetup;
  SCRIPT_continue[index][0]	= SNULL;
  SCRIPT_abandon1[index][0]	= SNULL;
  SCRIPT_abandon2[index][0]	= SNULL;
  SCRIPT_currentLine[index]	= 0;
  SCRIPT_fromStream[index]	= StreamNum;
  strcpy(SCRIPT_fileName[index], File);

  StreamNum = index;

  //Lancer le script
  SCRIPT_do(StreamNum, "");

  return SCRIPT_OK;
}

//--------------------------------------------------------------------------
//------ Initialiser les variables -----------------------------------------
//--------------------------------------------------------------------------
void SCRIPT_init(void)
{
  int index;

  for(index = 0; index < 65; index++)
  {
    SCRIPT_fileName[index][0]	= SNULL;
  }/*End FOR*/
}

//--------------------------------------------------------------------------
//------ Executer le script de connexion -----------------------------------
//--------------------------------------------------------------------------
void SCRIPT_do(int StreamNum, char * Frame)
{
	char sFileName[MAXPATH];
	char sAdjacent[10];
	char sLine[256];
	int  iLine = 1;
	int  iAbandon = FALSE;

	/* Former le nom du fichier */
	strcpy(sFileName, SCRIPT_PATH);
	strcat(sFileName, SCRIPT_fileName[StreamNum]);
	strcat(sFileName, ".fwd");
 #ifdef LINUX
	strlwr(sFileName);
#endif

	/* Etudier la reponse */

	/* Abandon de l'init de connexion ? */
	if( SCRIPT_abandon1[StreamNum][0] && strstr(Frame, SCRIPT_abandon1[StreamNum]) ||
        SCRIPT_abandon2[StreamNum][0] && strstr(Frame, SCRIPT_abandon2[StreamNum]) )
	{
		BUFFERS_printBuff(SCRIPT_fromStream[StreamNum], OUT, "*** Link failure with %s on stream %d.\n", SCRIPT_fileName[StreamNum], StreamNum);
		BUFFERS_printBuff(SCRIPT_fromStream[StreamNum], OUT, "Received : %s\n", Frame);
		goto Disconnect;
	}

	/* Nouvelle trame recue valide ?
	   Retourne a la fonction appelante s'il n'y a pas concordance, a moins que 
	   SCRIPT_continue soit vide (c'est peut-etre le premier appel de cette fonction) */
	if( SCRIPT_continue[StreamNum][0] && ! strstr(Frame, SCRIPT_continue[StreamNum]) )
		return;

	/* La chaine est arrivee (ou c'est le premier appel de cette fonction */

	fPtr = fopen(sFileName, "rt");
	if( ! fPtr )
	{
		BUFFERS_printBuff(SCRIPT_fromStream[StreamNum], OUT, 
			"*** Error : can't open %s.\n", sFileName);
		perror("fopen in SCRIPT_do");
		goto Disconnect;
	}

	/* Lire la premiere ligne (indicatif du destinataire) */
	if( ! fgets(sLine, 255, fPtr) )
	{
		/* Impossible de lire la premiere ligne */
		goto ScriptError;
	}
	else
	{
		/* Memoriser l'indicatif du cluster adjacent appele */
		TOOLS_removeNR(sLine);
		strncpy(sAdjacent, sLine, 9);
		sAdjacent[9] = SNULL;			/* Au cas ou ... */
		strupr( sAdjacent );
	}

	/* Se deplacer dans le fichier jusqu'a la ligne courante */
	for(iLine = 1; iLine < SCRIPT_currentLine[StreamNum]; iLine++)
	{
		if( ! fgets(sLine, 255, fPtr) )
		{
			/* Impossible de lire une ligne */
			goto ScriptError;
		}
	}

	/* Lire la ligne de connexion (.) */
	if( ! fgets(sLine, 255, fPtr) )
	{
		/* Si cette ligne n'exite pas, deux cas de figure :
		   - soit c'est que l'adjacent a ete atteint : FB !
		   - soit le fichier ne contient qu'une ligne : donc probleme - dans ce cas, 
		     SCRIPT_currentLine est egal 0 */
		if( SCRIPT_currentLine[StreamNum] )
		{
			extern int STREAMS_iDiddle[MAX_STREAMS];

			BUFFERS_printBuff(BUFFER_SCREEN1, OUT, 
				"Channel %d> %s joining the cluster.\n", StreamNum, sAdjacent);

			/* Indiquer au sysop */
			if( SCRIPT_fromStream[StreamNum] != BUFFER_SCREEN1 )
			{
				BUFFERS_printBuff(SCRIPT_fromStream[StreamNum], OUT,
					"Connection to %s established on stream %d.\n",
					sAdjacent, StreamNum);
			}

			/* Initialiser les variables ... */
			HOPS_readFile(StreamNum, sAdjacent);
			STREAMS_level[StreamNum] = LEVEL_cluster;
			strcpy(STREAMS_callsign[StreamNum], sAdjacent);
			MAIL_lFwdMsgNumber[StreamNum] = 0L;
			/* Pour n'envoyer le PC50 qu'au bout de 5 minutes */	
			STREAMS_iDiddle[StreamNum]    = 300;

			/* Date et heure de connexion */
			USERS_getRecord(StreamNum);
			pUserCfg->lConnectedDateTime = TOOLS_whatDateTime(); /* Heure et date de connexion */
			USERS_updateLocalConfig(StreamNum);					 /* Updater les modifs */

			LOG_message(StreamNum, LOG_IN, LOG_LOGIN, "CLUSTER");
#ifndef DOS
			FBBSRV_connectedList(StreamNum, FBBSRV_CONLIST_CONNECT, NULL);
#endif

			fclose (fPtr);

			/* Envoyer la ligne a nouveau dans le buffer pour qu'elle puisse etre traitee
			   par dxnet */
			BUFFERS_printBuff(StreamNum, IN, "%s\r", Frame);
			return;
		}
		else
		{
			iLine = 2;
			goto ScriptError;
		} /*End IF*/
	}/*End IF*/

	/* Envoyer au SWITCH le contenu de la ligne de connexion */
	if( sLine[0] != '.' )
	{
		BUFFERS_printBuff(SCRIPT_fromStream[StreamNum], OUT, 
			"*** Error in file %s : '.' needed in line %d.\n", sFileName, iLine);
		fclose( fPtr );
		goto Disconnect;
	}
	else
	{
		/* Cas particulier pour la premiere connexion. Si le SWITCH est un PcFlex,
		   il faut, pour la premiere commande du script executer une demande de
		   connexion plutut qu'envoyer ce qui suit le '.' dans le stream. */
		if( SCRIPT_currentLine[StreamNum] == 0 && SWITCH_isPcFlexNet() )
		{
			SWITCH_connectFlex(StreamNum, sLine + 3);
		}
		else
		{
			/* Supporter les \n, \r, etc ... */
#ifndef DOS
			parse_string(sLine);
#else
			EXECUTE_parse_string(sLine);
#endif

			BUFFERS_addBuff(StreamNum, sLine + 1, OUT);

		}/*End IF*/
	}/*End IF*/

	iLine++;

	/* Lire les conditions de connexions (#, +, ?) */
	/* Initialiser */
	strcpy(SCRIPT_continue[StreamNum], "to");
	strcpy(SCRIPT_abandon1[StreamNum], "ailur");
	strcpy(SCRIPT_abandon2[StreamNum], "usy");
	SCRIPT_timer[StreamNum]	= 60;				/* Valeur par defaut */

	for(;;)				
	{
		/* Lire la ligne suivante */
		if( ! fgets(sLine, 255, fPtr) || sLine[0] == '.')
			break;		/* C'est termine */

		TOOLS_removeNR(sLine);
		iLine++;

		if( sLine[0] == '#' )		/* Time Out */
		{
			SCRIPT_timer[StreamNum] = atoi( sLine + 1 );
		}
		else if( sLine[0] == '+' )
		{
			strncpy(SCRIPT_continue[StreamNum], sLine + 1, 6); /* On limite a 6 caracteres */
			SCRIPT_continue[StreamNum][6] = SNULL;			   /* Par securite */
		}
		else if( sLine[0] == '?' )
		{
			/* Deux cas possibles ... */
			if( iAbandon == FALSE )  /* C'est le premier '?' */
			{
				strncpy(SCRIPT_abandon1[StreamNum], sLine + 1, 6);
				SCRIPT_abandon1[StreamNum][6] = SNULL;
				iAbandon = TRUE;
			}
			else
			{
				strncpy(SCRIPT_abandon2[StreamNum], sLine + 1, 6);
				SCRIPT_abandon2[StreamNum][6] = SNULL;
			}/*End IF*/
		}/*End IF*/
	}/*End WHILE*/

	SCRIPT_currentLine[StreamNum] = iLine;

	fclose( fPtr );
	return;

	/* Indiquer qu'une erreur est survenue lors de la lecture du script */
ScriptError:
	BUFFERS_printBuff(SCRIPT_fromStream[StreamNum], OUT, "*** Error in file %s : can't read line %d.\n", SCRIPT_fileName[StreamNum], iLine);
	/* Transmettre le prompt a la station qui declanchee la connexion,
       et deconnecter le stream en cours d'initialisation */
	fclose( fPtr );

Disconnect:
	MSG_send(SCRIPT_fromStream[StreamNum], PROMPT);
	/* Deconnecter le stream */
	SWITCH_discSwitch(StreamNum);
	SCRIPT_fileName[StreamNum][0]	= SNULL;
	STREAMS_level[StreamNum]	= 0;
}

/*--------------------------------------------------------------------------
  ------ Retourne l'indicatif en cours de connection -----------------------
  --------------------------------------------------------------------------*/
void SCRIPT_getLinkSetupCall(int StreamNum, char * pszCallSign)
{
	char szFileName[MAXPATH];
	char szLine[256];
	FILE *fPtr;

	/* Former le nom du fichier */
	strcpy(szFileName, SCRIPT_PATH);
	strcat(szFileName, SCRIPT_fileName[StreamNum]);
	strcat(szFileName, ".fwd");
#ifdef LINUX
	strlwr(szFileName);	/* Compatibilite standard LINUX */
#endif

	*pszCallSign = SNULL;
  
	fPtr = fopen(szFileName, "rt");
	if( ! fPtr )
		return;  
  
	if( fgets(szLine, 255, fPtr) )
  		strcpy(pszCallSign, szLine);
	
	fclose(fPtr);
}
