#include <alloc.h>
#include <dos.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include "define.h"
#include "flexappl.h"
#include "switch.h"
#include "symbol.h"
#include "tools.h"

#include "buffers.h"

//---------------------------------------------------------------------------
//------ Variables globales -------------------------------------------------
//---------------------------------------------------------------------------
int PcFlex 	=	0;
int BpqVec      =	0x7F;
int FirstStream =       1;
int LastStream  =	64;
typedef struct
{
  unsigned int 	QsoNum;  	//Numro du QSO
  char 		CallSign[20];   //indicatif connect
  char 		WaitConnected;  //Utilis pour indiquer qu'une connexion sortante est en cours
} QSO;

QSO 	QsoTab_Flex[65]; 	//Rserver de la mmoire pour une table de 65 QSO (PcFlexNet)
char 	MyCall_Flex[10];        //Indicatif du node (pcflex)
//int     ApplMask = 1;		//Numro d'application par dfaut pour G8BPQ


//--------------------------------------------------------------------------
//------ Macros ------------------------------------------------------------
//--------------------------------------------------------------------------
#define Shr1(C)  ( (char) ((((int) C)&0xFF) >> 1) )
#define Shr5(C)  ( (char) ((((int) C)&0xFF) >> 5) )

//--------------------------------------------------------------------------
//------ Symboles ----------------------------------------------------------
//--------------------------------------------------------------------------
#define MAX_QSO 	64	//Au maximum, le serveur est capable de grer 64 QSOs
#define NORMALPACKET 	1
#define NETROM       	2

//---------------------------------------------------------------------------
//------ Dtecter le SWITCH packet ------------------------------------------
//---------------------------------------------------------------------------
//Retourne NONE si aucun switch n'a t trouv
int SWITCH_init(int _FirstStream, int _LastStream)
{
  //Vrifier la validit des first/last stream (utilis uniquement avec BPQ)
  if( _FirstStream < 1 )
    _FirstStream = 1;

  if( _LastStream > 64 )
    _LastStream = 64;

  if( _FirstStream >= _LastStream )
    _LastStream = _FirstStream + 1;

  FirstStream = _FirstStream;
  LastStream  = _LastStream;

  //------ Y a-t-il un switch d'installe ? ------
  if( ax_init() )  //PcFlex ?
  {
    //PcFlex a t trouv
    PcFlex = 1;
    return(PCFLEX);
  }
  else  //Sinon, peut-etre BPQ ?
  {
    char buffer[60];
    static char g8bpq[] = "G8BPQ";

    long vector = (long) getvect(BpqVec);
    movedata( FP_SEG(vector), FP_OFF(vector)-7, FP_SEG(buffer),
	      FP_OFF(buffer), strlen(g8bpq) );
    if( strncmp(buffer, g8bpq, strlen(g8bpq)) )
      return(NONE); //Bpqcode est absent

    PcFlex = 0; //Ce n'est pas PcFlex, puisque c'est G8BPQ !
    return(G8BPQ);
  }
}

//---------------------------------------------------------------------------
//------ Initialiser BPQ (si ncessaire) ------------------------------------
//---------------------------------------------------------------------------
void SWITCH_bpqSetup(int Mask, int Flag1, int Flag2)
{
  int index;

  if( ! PcFlex )
  {
    SWITCH_bpqSetAppl(FirstStream, Mask, Flag1);
    for(index = FirstStream + 1; index <= LastStream; index++)
      SWITCH_bpqSetAppl(index, Mask, Flag2);
  }
}

//---------------------------------------------------------------------------
//------ Initialise les masques et flags d'application ----------------------
//---------------------------------------------------------------------------
void SWITCH_bpqSetAppl(int StreamNum, int Mask, int Flag)
{
  if( ! PcFlex )
  {
    union REGS regs;

    regs.h.ah = 1;
    regs.h.dl = Mask;
    regs.h.cl = Flag;
    regs.h.al = StreamNum;

    int86(BpqVec, &regs, &regs);

  }
}

//--------------------------------------------------------------------------
//------ class g8bpq - get_statut ------------------------------------------
//--------------------------------------------------------------------------
//Retourne l'tat du canal : NONE pas de changement
//                           1 connection
//                           2 deconnection
//et initialise l'ack de test de statut (#5) pour G8BPQ
int SWITCH_getStatut(int StreamNum)
{
  if( PcFlex )
  {
    char State;
    unsigned int QsoNum;

    //------ Le stream est-il connecte ? ------
    if( QsoTab_Flex[StreamNum].QsoNum )
    {

      //------ Il est connecte ------
      State = l2_state( QsoTab_Flex[StreamNum].QsoNum );

      //------ Dtecte un eventuelle dconnexion ------
      if( (State & 0x1F) == 0 || (State & 0x1F) == 1 )
      {
	//Vide le buffer
	l2_clr_i(QsoTab_Flex[StreamNum].QsoNum);

	QsoTab_Flex[StreamNum].QsoNum = 0;

	return DISCONNECTED;
      }
    }
    else
    {
      //------ Il n'est pas connecte ------
      //------ Teste s'il y a une nouvelle connexion ------
      QsoNum = l2_get_sabm ( (unsigned char*) MyCall_Flex);
      if( QsoNum )
      {
	char CallSign[20];
	const FRAME * f = l2_get_f(QsoNum);

	strcall( (unsigned char *) CallSign, f->dest);

	//------ Recherche un eventuel link reset ------
	for(int index =0; index < MAX_QSO; index++)
	  if( QsoNum == QsoTab_Flex[index].QsoNum )
	    break;

	if( index >= MAX_QSO )
	{
	  QsoTab_Flex[StreamNum].QsoNum = QsoNum;
	  strcpy(QsoTab_Flex[StreamNum].CallSign, CallSign);

	  //------ Acknoledge la connexion ------
	  l2_sabmresp( QsoNum );

	  //------ Vide le buffer de rception ------
	  l2_clr_i( QsoNum );

	  QsoTab_Flex[StreamNum].WaitConnected = 0;

	  return CONNECTED;
	}
      }
    }

    //------ Pas de changement ------
    return NONE;
  }
  else //G8BPQ
  {
    union REGS regs;
    int stat;

    //------ Autoris  utiliser le port ? ------
    if( ! SWITCH_isAllowed(StreamNum) )
      return( 0 );

    regs.h.ah = 4;
    regs.h.al = StreamNum;

    int86(BpqVec, &regs, &regs);


    if( regs.x.dx )
    {
      if( regs.x.cx )
	stat = CONNECTED;
      else
	stat = DISCONNECTED;

      //------ int #5 maintenant
      regs.h.ah = 5;
      regs.h.al = StreamNum;

      int86(BpqVec, &regs, &regs);

    }
    else
      stat = NONE;

    return(stat);
  }
}

//--------------------------------------------------------------------------
//------ ack_statut - A appeler aprs chaque appel de int 5 ----------------
//--------------------------------------------------------------------------
//Cette fonction est utilise par SWITCH_getStat()
void SWITCH_ackStatut(int StreamNum)
{
  if( ! PcFlex )
  {
    union REGS regs;

    //------ Autoris  utiliser le port ? ------
    if( SWITCH_isAllowed(StreamNum) )
    {
      regs.h.ah = 5;
      regs.h.al = StreamNum;

      int86(BpqVec, &regs, &regs);
    }
  }
}

//--------------------------------------------------------------------------
//------ get_frame ---------------------------------------------------------
//--------------------------------------------------------------------------
//Lit et retourne dans buffer le contenu du cannal StreamNum
//La fonction retourne la longueur de la chaine
int SWITCH_getFrame(int StreamNum, char * buffer)
{
  if( PcFlex )
  {
    if( QsoTab_Flex[StreamNum].QsoNum )
    {
      char	*pPtr;
      int	iLength = 0;

      const INFO * info = l2_get_i( QsoTab_Flex[StreamNum].QsoNum );

      //------ Si une trame est arrive ------
      if( info )
      {
	l2_i_ack( QsoTab_Flex[StreamNum].QsoNum );

	pPtr = buffer;

	//------ Une connexion sortante vient de s'tablir ------
	if( QsoTab_Flex[StreamNum].WaitConnected )
	{
	  QsoTab_Flex[StreamNum].WaitConnected = 0;
	  sprintf(buffer, "Connected to %s\r", QsoTab_Flex[StreamNum].CallSign);
	  iLength = strlen( buffer );
	  pPtr = buffer + iLength;
	}
	memcpy(pPtr, info->text, info->len);
	iLength += info->len;

        //Retourner la longueur de la trame
	return iLength;
      }
    }
    return 0;
  }
  else
  {
    union REGS regs;
    struct SREGS sregs;

    //------ Autoris  utiliser le port ? ------
    if( ! SWITCH_isAllowed(StreamNum) )
      return( 0 );

    segread(&sregs);

    regs.x.di = FP_OFF(buffer);
    sregs.es  = FP_SEG(buffer);
    regs.h.ah = 0x03;
    regs.h.al = StreamNum;

    int86(BpqVec, &regs, &regs);

//    buffer[regs.x.cx] = '\0';

    return(regs.x.cx);
  }
}
//--------------------------------------------------------------------------
//------ send_frame --------------------------------------------------------
//--------------------------------------------------------------------------
//Transmet le contenu de buffer dans le cannal StreamNum
void SWITCH_sendFrame(int StreamNum, char * buffer, int Size)
{
  if( PcFlex )
  {
    //------ Alloue un buffer  ------
    if( l2_ialloc(QsoTab_Flex[StreamNum].QsoNum, Size) )
    {
//      l2_puts(QsoTab_Flex[StreamNum].QsoNum, buffer);
      for(int index = 0; index < Size; index++)
	l2_send_char(QsoTab_Flex[StreamNum].QsoNum, *buffer++);
      l2_pack(QsoTab_Flex[StreamNum].QsoNum);
    }
  }
  else
  {
    union 	REGS regs;
    struct 	SREGS sregs;
    char	string[340];

    //------ Autoris  utiliser le port ? ------
    if( SWITCH_isAllowed(StreamNum) )
    {
      segread(&sregs);

      memcpy(string, buffer, Size);

      regs.x.si = FP_OFF(string);
      sregs.es  = FP_SEG(string);
      regs.h.ah = 0x02;
      regs.h.al = StreamNum;
      regs.x.cx = Size;

      int86(BpqVec, &regs, &regs);
    }
  }
}

//--------------------------------------------------------------------------
//------ get_call ----------------------------------------------------------
//--------------------------------------------------------------------------
//Retourne dans call_sign l'indicatif connecte au cannal streamnul
void SWITCH_getCall(int StreamNum, char * call_sign)
{
  if( PcFlex )
  {
    strcpy(call_sign, QsoTab_Flex[StreamNum].CallSign);
  }
  else
  {
    union REGS regs;
    struct SREGS sregs;

    //------ Autoris  utiliser le port ? ------
    if( SWITCH_isAllowed(StreamNum) )
    {
      segread(&sregs);

      regs.x.di = FP_OFF(call_sign);
      sregs.es   = FP_SEG(call_sign);
      regs.h.ah = 0x08;
      regs.h.al = StreamNum;

      int86(BpqVec, &regs, &regs);

      for(int index = 0; index < 11; index++)
      {
	if( call_sign[index] == ' ' )
	  call_sign[index] = '\0';
      }
    }
  }
}

//--------------------------------------------------------------------------
//------ con_state - Le stream est-il connect ? ---------------------------
//--------------------------------------------------------------------------
//Retourne 1 si le stream est connect
int SWITCH_conStat(int StreamNum)
{
  if( PcFlex )
  {
    if( QsoTab_Flex[StreamNum].QsoNum && QsoTab_Flex[StreamNum].WaitConnected == 0 )
      return(1);
    else
      return(0);
  }
  else
  {
    union REGS regs;

    regs.h.ah = 4;
    regs.h.al = StreamNum;

    int86(BpqVec, &regs, &regs);

    if( regs.x.cx && SWITCH_isAllowed(StreamNum) )
      return(1);
    else
      return(0);
  }
}

//--------------------------------------------------------------------------
//------ con_switch - Connecte le stream au switch -------------------------
//--------------------------------------------------------------------------
void SWITCH_conSwitch(int StreamNum)
{
  if( ! PcFlex )
  {
    union REGS regs;

    //------ Autoris  utiliser le port ? ------
    if( SWITCH_isAllowed(StreamNum) )
    {
      regs.h.ah = 6;
      regs.h.al = StreamNum;
      regs.x.cx = 1;

      int86(BpqVec, &regs, &regs);
    }
  }
}

//--------------------------------------------------------------------------
//------ disc_switch - Dconnecte le stream du switch ----------------------
//--------------------------------------------------------------------------
void SWITCH_discSwitch(int StreamNum)
{
  if( PcFlex  )
  {
    //------ Vide les buffers et dconnecte ------
    l2_cancel_qso(QsoTab_Flex[StreamNum].QsoNum);
  }
  else
  {
    union REGS regs;

    //------ Autoris  utiliser le port ? ------
    if( SWITCH_isAllowed(StreamNum) )
    {
      regs.h.ah = 6;
      regs.h.al = StreamNum;
      regs.x.cx = 2;

      int86(BpqVec, &regs, &regs);
    }
  }
}

//--------------------------------------------------------------------------
//------ add_callsign ------------------------------------------------------
//--------------------------------------------------------------------------
void SWITCH_addCall(int start, char * buffer, char * string)
{
  if( ! PcFlex )
  {
    int index = 0;
    int len   = strlen(string);
    char S_Itoa[17];

    //Lecture de l'indicatif
    while(index < 6 && ( Shr1(buffer[start + index]) != 0x20) )
       string[len++] =Shr1(buffer[start + index++]);

    string[len] = '\0';

    //Lecture du SSID
    itoa( (int) ( (Shr1(buffer[start + 6]) & 0x0F) & 0xFF ), S_Itoa, 10);

    if( S_Itoa[0] != '0' )
    {
      string[len++] = '-';
      string[len]   = '\0';
      strcat(string, S_Itoa);
    }
  }
}

//---------------------------------------------------------------------------
//------ IsAllowed ----------------------------------------------------------
//---------------------------------------------------------------------------
int SWITCH_isAllowed(int StreamNum)
{
  if(StreamNum < FirstStream || StreamNum > LastStream)
    return( 0 );

  return( 1 );
}

//--------------------------------------------------------------------------
//------ Monitoring --------------------------------------------------------
//--------------------------------------------------------------------------
//Monitoring
int SWITCH_rawRx(int streamnum, char * pszBuffer)
{
  if( PcFlex )
  {
    if( ! l2_chk_monitor() )
    {
      TRACE tTrace;

      tTrace.ch_mask   = 32767;
      tTrace.typfilter = 0;
      tTrace.trxfilter = 3;
      tTrace.call[0]   = SNULL;

      l2_set_monitor( &tTrace );

      return 0;
    }
    else
    {
      const FRAME far * tFrame = l2_get_monitor();

      if( tFrame != NULL )
      {
	char	sCallSign[16];
	char 	sString[81];
	int	index;
	int	iLength;
	char   *pPtr1;
	char   *pPtr2;

	l2_ack_monitor();

	//Prparer l'affichage de la trame
	sprintf(pszBuffer, "%c%02d:fm ", (tFrame->tx ? 'T' : 'R'), tFrame->kanal);
	strcat(pszBuffer, (char *) strcall( (unsigned char *) sCallSign,
					 tFrame->source));
	strcat(pszBuffer, " to ");
	strcat(pszBuffer, (char *) strcall( (unsigned char *) sCallSign,
					 tFrame->dest));
	if( tFrame->digis > 0 )
	  strcat(pszBuffer, " via");
	for(index = 0; index < tFrame->digis; index++)
	{
	  strcat(pszBuffer, " ");
	  strcat(pszBuffer, (char *) strcall( (unsigned char *) sCallSign,
					   tFrame->digi[index]));
	}/*End FOR*/
	strcat(pszBuffer, " ctl ");
	switch( tFrame->typ )
	{
	  case I :
	    sprintf(sString, "I%d%d", tFrame->nr, tFrame->ns);
	    strcat(pszBuffer, sString);
	    break;

	  case RR :
	    sprintf(sString, "RR%d", tFrame->nr);
	    strcat(pszBuffer, sString);
	    break;

	  case RNR :
	    sprintf(sString, "RNR", tFrame->nr);
	    strcat(pszBuffer, sString);
	    break;

	  case REJ :
	    sprintf(sString, "REJ", tFrame->nr);
	    strcat(pszBuffer, sString);
	    break;

	  case SABM :
	    strcat(pszBuffer, "SABM");
	    break;

	  case DISC :
	    strcat(pszBuffer, "DISC");
	    break;

	  case DM :
	    strcat(pszBuffer, "DM");
	    break;

	  case UA :
	    strcat(pszBuffer, "UA");
	    break;

	  case FRMR :
	    strcat(pszBuffer, "FRMR");
	    break;

	  case UI :
	    strcat(pszBuffer, "UI");
	    break;
	}/*End SWITCH*/

	strcat(pszBuffer, "\n");

	iLength = strlen( pszBuffer );

	//Dtecter si c'est une trame BIN
	if( TOOLS_isBin( (char *) tFrame->text, tFrame->textlen) )
	{
	  char sStr[20];

	  //Oui, ne pas l'afficher
	  sprintf(sStr, "<BIN %d>\n", tFrame->textlen);
	  strcat(pszBuffer, sStr);
	  iLength += strlen( sStr );
	  return iLength;
	}

	//Copier le texte de la trame
	if( tFrame->textlen )
	{
	  pPtr1 = pszBuffer + iLength;
	  pPtr2 = (char *) tFrame->text;
	  for(index = 0; index < tFrame->textlen; index++)
	  {
	    if( *pPtr2 == CR )
	      *pPtr1++ = CCR;
	    else
	      *pPtr1++ = *pPtr2;

	    pPtr2++;
	  }/*End FOR*/

	  //Ajouter un CR  la fin, sauf s'il y en a dj un
	  if( *(pPtr1-1) != CCR )
	  {
	    *pPtr1++ = CCR;
	    iLength++;
	  }/*End IF*/
	  *pPtr1   = SNULL;
	  iLength += tFrame->textlen;
	}/*End IF*/

	//Retourner la longueur de la chaine
	return( iLength );
      }/*End IF*/
    }
    //Ne fait rien pour l'instant
    return( 0 );
  }
  else
  {
    union REGS regs;
    struct SREGS sregs;
    char OutStr[340];
    int J;
    char Port[100];
    char Super[10];
    int info = 0;
    int len  = 0;
    char S_Itoa[17];
    //    char buffer[1024];
    char* buffer = pszBuffer;

    OutStr[0] = '\0';

    segread(&sregs);

    regs.x.di = FP_OFF(buffer);
    sregs.es  = FP_SEG(buffer);
    regs.h.ah = 11;
    regs.h.al = streamnum;

    int86(BpqVec, &regs, &regs);

    buffer[regs.x.cx] = '\0';

    if( regs.x.cx )
    {
      //from callsign
      SWITCH_addCall(12, buffer, OutStr);
      strcat(OutStr, ">\0");

      //to callsign
      SWITCH_addCall(5,  buffer, OutStr);

      //Digis callsigns
      J = 18;
      while( (buffer[J] & 0x01) != 1 )
      {
	strcat(OutStr, ",\0");
	SWITCH_addCall(J + 1, buffer, OutStr);
	//Digi bit
	if( (buffer[J + 7] & 0x80) == 0x80 )
	  strcat(OutStr, "*\0");
	J += 7;
      }

      //Verification de l'indicatif
      if( ! isalnum (OutStr[0]) || ! isalnum (OutStr[1]) )
	return 0;	//Invalide !

      //Numro de port
      itoa( (int) ( (buffer[2] & 0x0F) & 0xFF ), S_Itoa, 10);

      sprintf(Port, "[%d] %s", ((buffer[2] & 0x0F) & 0xFF), OutStr);
      strcpy(OutStr, Port);

      //Type de trame
      //Information frame
      switch( (int) (buffer[J + 1] & 0x01) )
      {
	case 0 :

	  switch( (int) (buffer[J + 2] & 0xFF) )
	  {
	    case 0xCF :
	      strcat(OutStr, " [Net/Rom]");

	      //dcodage de la trame NETROM
	      strcat(OutStr, "\n[Netrom data] ");
	      SWITCH_addCall(J + 3, buffer, OutStr);
	      strcat(OutStr, " to ");
	      SWITCH_addCall(J + 10, buffer, OutStr);

	      switch( (int) (buffer[J + 22] & 0x0F) )
	      {
		case 1 :
		  strcat(OutStr, " <Conn Req>");
		break;

		case 2 :
		  strcat(OutStr, " <Conn Ack>");
		break;

		case 3 :
		  strcat(OutStr, " <Disc Req>");
		break;

		case 4 :
		  strcat(OutStr, " <Disc Ack>");
		break;

		case 5 : //Correct counter to show text
		  strcat(OutStr, " <Info>");
		  info = NETROM;
		  J += 20;
		break;

		case 6 :
		  strcat(OutStr, " <Info Ack>");
		break;

		default :
		  itoa( (buffer[J + 22] & 0x0F), S_Itoa, 10 );
		  strcat(OutStr, " Type ");
		  strcat(OutStr, S_Itoa);
		break;
	      }/*end switch*/

	    break;

	    case 0xF0 :
	      strcat(OutStr, ":"); //Packet normal
	      info = NORMALPACKET;
	    break;

	    default : //Toutes les autres PID
	      itoa( (int) ( (buffer[J + 2]) & 0xFF ), S_Itoa, 10);
	      strcat(OutStr, " PID ");
	      strcat(OutStr, S_Itoa);
	    break;
	  }
	  break;

	case 1:

	  //Est ce une trame de supervision
	  if( (buffer[J + 1] & 0x02) == 0 )
	  {
	    strcpy(Super, "");

	    switch( (int) (buffer[J + 1] & 0x0C) )
	    {
	      case 0x00 :
		strcpy(Super, "RR");
	      break;

	      case 0x04 :
		strcpy(Super, "RNR");
	      break;

	      case 0x08 :
		strcpy(Super, "REJ");
	      break;
	    }

	    strcat(OutStr, " <");
	    strcat(OutStr, Super);

	    //Extraire N(R)
	    itoa( (int) ( (Shr5(buffer[J + 1])) & 0xFF ), S_Itoa, 10);
	    sprintf(Port, " R%s>", S_Itoa); //Port est reutilis afin de faire de
					  //conomie de pays bigoudin
	    strcat(OutStr, Port);
	  }
	  else
	  {
	    switch( (int) (buffer[J + 1] & 0xEC) )
	    {
	      case 0x00 :
		strcat(OutStr, " <UI>");
		info = 1;
	      break;

	      case 0x0C :
		strcat(OutStr, " <DM>");
	      break;

	      case 0x2C :
		strcat(OutStr, " <SABM>");
	      break;

	      case 0x40 :
	       strcat(OutStr, " <DISC>");
	      break;

	      case 0x60 :
		strcat(OutStr, " <UA>");
	      break;

	      case 0x84 :
		strcat(OutStr, " <FRMR>");
	      break;
	    }/*end switch*/
	  }/*end if*/
      }/*end switch*/
    }/*end if*/

    if( info ) //NORMALPACKET ou NETROM
    {
	J += 3;
	strcat(OutStr, "\n"); //Aller a la ligne
	len = strlen(OutStr);

	if( TOOLS_isBin(buffer + J, regs.x.cx - J) )
	{
	  char sStr[20];

	  //Oui, ne pas l'afficher
	  sprintf(sStr, "<BIN %d>", regs.x.cx - J);
	  strcat(OutStr, sStr);
	}
	else
	{
	   while( J <= regs.x.cx )
	   {
	     OutStr[len++] = buffer[J++];
	     if( buffer[J] == '\r' )
	       buffer[J] = '\n';
	   }

	   if( OutStr[len - 2] == '\n' )
	     len -= 2;
	   OutStr[len] = '\0';
	 }
    }

    strcpy(pszBuffer, OutStr);
    strcat(pszBuffer, "\n");

/*    for(len = 0; len < strlen(buffer); len++)
    {
      if( buffer[len] == 0x07 ) //Ding dong
	buffer[len] = 14;       //Caractre double croche !
    }*/

    return( regs.x.cx );
  }
}

//---------------------------------------------------------------------------
//------ Is PcFlex ----------------------------------------------------------
//---------------------------------------------------------------------------
int SWITCH_isPcFlexNet(void)
{
  return PcFlex;
}

//---------------------------------------------------------------------------
//------ SetMyCall ----------------------------------------------------------
//---------------------------------------------------------------------------
void SWITCH_setMyCall(char * CallSign)
{
  strcpy(MyCall_Flex, CallSign);
}

//--------------------------------------------------------------------------
//------ Initialiser le SWITCH packet --------------------------------------
//--------------------------------------------------------------------------
//Retourne TRUE si un switch (BPQ ou PcFlex) a t trouv
//Retourne FALSE sinon
int SWITCH_initSwitch(int _FirstStream, int _LastStream, int ApplMask)
{
  //Dtecter et initialiser le switch
  if( ! SWITCH_init(_FirstStream, _LastStream) )
    return FALSE;

  SWITCH_bpqSetup(ApplMask, 0x82, 0x02);

  if( PcFlex )
    printf("Found PcFlexNet kernel.\n");
  else
    printf("Found G8BPQ switch.\nUse streams %d to %d on application %d.\n", FirstStream, LastStream, ApplMask);

  return TRUE;
}

//--------------------------------------------------------------------------
//------ Connecter un indicatif via PcFlexNet ------------------------------
//--------------------------------------------------------------------------
//Retourne TRUE si le switch est un PcFlexNet
int SWITCH_connectFlex(int streamnum, char * ToCall)
{
  unsigned int QsoNum;
  char *pPtr;

  if( ! PcFlex )
    return FALSE;

  QsoNum = l2_connect((byte*) MyCall_Flex, (byte*) ToCall);
  if( QsoNum )
  {
    QsoTab_Flex[streamnum].QsoNum = QsoNum;
    //Ne pas enregistrer les VIAs, et en tous cas limiter la chaines  11 octets
    pPtr = strchr(ToCall, ' ');
    if( pPtr )
      *pPtr = SNULL;
    TOOLS_maxLength(ToCall, 11);
    strcpy(QsoTab_Flex[streamnum].CallSign, ToCall);
    QsoTab_Flex[streamnum].WaitConnected = 1;
  }

  return TRUE;
}

//--------------------------------------------------------------------------
//------ Connecter un indicatif via PcFlexNet ------------------------------
//--------------------------------------------------------------------------
//Retourne TRUE si le switch est un PcFlexNet
int SWITCH_connectFlex(int streamnum, char * FromCall, char * ToCall)
{
  unsigned int QsoNum;
  char *pPtr;

  if( ! PcFlex )
    return FALSE;

  QsoNum = l2_connect((byte*) FromCall, (byte*) ToCall);
  if( QsoNum )
  {
    QsoTab_Flex[streamnum].QsoNum = QsoNum;
    //Ne pas enregistrer les VIAs, et en tous cas limiter la chaines  11 octets
    pPtr = strchr(ToCall, ' ');
    if( pPtr )
      *pPtr = SNULL;
    TOOLS_maxLength(ToCall, 11);
    strcpy(QsoTab_Flex[streamnum].CallSign, ToCall);
    QsoTab_Flex[streamnum].WaitConnected = 1;
  }

  return TRUE;
}

//--------------------------------------------------------------------------
//------ Retourne le nombre de trames qui n'ont pas encore t ACKed -------
//--------------------------------------------------------------------------
int SWITCH_getUnack(int streamnum)
{
  /* Le stream est il connecte ? */
  if( ! SWITCH_conStat(streamnum) )
	return 0;	/* Non -> ne pas aller plus loin ... */

  if( PcFlex )
  {
    /* Combine pour ne pas surcharger le buffer, renvoyer un unpack
       de 10 lorsque le buffer est plein ... */
    if( ! l2_ialloc(QsoTab_Flex[streamnum].QsoNum, 256) )
      return 10;

    return( l2_unack(QsoTab_Flex[streamnum].QsoNum) );
  }
  else
  {
    union REGS regs;

    regs.h.ah = 0x07;
    regs.h.al = streamnum;

    int86(BpqVec, &regs, &regs);

    return( regs.x.cx );
  }/*End IF*/
}

//--------------------------------------------------------------------------
//------ Retourne le nombre de buffer dispos dans le switch BPQ ------------
//--------------------------------------------------------------------------
int SWITCH_getBufferLeft()
{
  if( PcFlex )
  {
	return -1;	/* Pas utilise sous PC/Flex */
  }
  else
  {
    union REGS regs;

    regs.h.ah = 0x07;
    regs.h.al = 1;

    int86(BpqVec, &regs, &regs);

    return( regs.x.dx );
  }/*End IF*/
}

//--------------------------------------------------------------------------
//------ Quitter le kernel PcFlex ------------------------------------------
//--------------------------------------------------------------------------
void SWITCH_exitPcFlex(void)
{
  if( PcFlex )
    ax_exit();
}

/*--------------------------------------------------------------------------
  ------ Retourne le nom du port sur lequel est connecte la station --------
  --------------------------------------------------------------------------*/
char* SWITCH_getPortName(int StreamNum, char *buffer)
{
	if( PcFlex )
	{
		if( QsoTab_Flex[StreamNum].QsoNum )
		{
			const FRAME * f = l2_get_f(QsoTab_Flex[StreamNum].QsoNum);
			sprintf(buffer, "%d", f->kanal);
		}
		else
			strcpy(buffer, "-");
	}
	else
	{
		if( SWITCH_isAllowed(StreamNum) )
		{
			union  REGS regs;
			struct SREGS sregs;
			char   szCallSign[16];

			segread(&sregs);

			regs.x.di = FP_OFF(szCallSign);
			sregs.es  = FP_SEG(szCallSign);
			regs.h.ah = 0x08;
			regs.h.al = StreamNum;

			int86(BpqVec, &regs, &regs);

			sprintf(buffer, "%d", regs.h.al);
		}
		else
			strcpy(buffer, "-");
	}

        return buffer;
}


//--------------------------------------------------------------------------
//------ Fonctions utilises uniquement sous LINUX ---------------------------
//--------------------------------------------------------------------------
int SWITCH_wait(int)
{
  //Ne fait rien sous MS-DOS
  return 0;
}
void    SWITCH_addPort(char *)
{
  //Ne fait rien sous MS-DOS
}


