/* Gestion de la console 3 (terminal), sous DOS uniquement */

#include <alloc.h>
#include <string.h>
#include <stdio.h>
#include "display.h"
#include "term.h"
#include "switch.h"
#include "define.h"
#include "commands.h"
#include "users.h"
#include "tools.h"

static int  TERM_iStream = 0;	//0 indique qu'un stream n'est connecte
static char TERM_myCall[11];	//L'indicatif du terminal

extern int FirstStream;	//Dfinis dans le module SWITCH
extern int LastStream;	//idem
extern int STREAMS_level[MAX_STREAMS];

/*---------------------------------------------------------------------------
  ------ Initialisation -----------------------------------------------------
  ---------------------------------------------------------------------------*/
void TERM_init(void)
{
	strcpy(TERM_myCall, "NOCALL");
	DISP_PutsConsole(SCREEN3, "\nCmd>", COLOR_IN);
}

/*---------------------------------------------------------------------------
  ------ Retourne le stream sur lequel est effectue la connection ou 0 si ---
  ------ aucune -------------------------------------------------------------
  ---------------------------------------------------------------------------*/
int TERM_conStream(void)
{
#ifdef DOS
	return TERM_iStream;
#else
	return 0;
#endif
}

/*---------------------------------------------------------------------------
  ------ Pour se connecter --------------------------------------------------
  ---------------------------------------------------------------------------
  La fonction retourne TRUE si OK, et FALSE sinon
*/
int TERM_connect(char * ToCall)
{
	extern tUserCfg* pUserCfg;
	int index;

	if( TERM_iStream )
		return FALSE;	/* Deja connecte !... */

	/* Rechercher un stream de libre en commencant par les derniers */
	for(index = LastStream; index >= FirstStream; index--)
	{
		if( ! SWITCH_conStat( index ) )
			break;  /* Trouve ! */
		SWITCH_ackStatut( index );
	}/*End FOR*/

	/* Plus aucun stream de disponible ? */
	if( index < FirstStream )
		return FALSE;

	TERM_iStream = index;

	/* Connecter au switch et initialiser les variables SCRIPT */
	if( ! SWITCH_isPcFlexNet() )
	{
		/* G8BPQ */
		char sBuffer[256];

		SWITCH_conSwitch( TERM_iStream );
		SWITCH_ackStatut( TERM_iStream );

		/* Linked to (pour preciser l'indicatif */
		sprintf(sBuffer, "*** Linked to %s\r", TERM_myCall);
		SWITCH_sendFrame(TERM_iStream, sBuffer, strlen(sBuffer));

		/* Qui veut-on connecter ? */
		sprintf(sBuffer, "C %s\r", ToCall);
		SWITCH_sendFrame(TERM_iStream, sBuffer, strlen(sBuffer));
	}
	else
	{
		/* PC/FlexNet */
		SWITCH_connectFlex(TERM_iStream, TERM_myCall, ToCall);
	}/*End IF*/

	STREAMS_level[TERM_iStream] = LEVEL_term;
	USERS_getRecord(TERM_iStream);
	pUserCfg->lConnectedDateTime = TOOLS_whatDateTime();
	USERS_updateLocalConfig(TERM_iStream);
	return TRUE;
}

//--------------------------------------------------------------------------
//------ Deconnection ------------------------------------------------------
//--------------------------------------------------------------------------
void TERM_disconnect(void)
{
  TERM_iStream = 0;
  DISP_PutsConsole(SCREEN3, "*** Disconnected\nCmd>", COLOR_IN);
}

//--------------------------------------------------------------------------
//------ L'utilisateur vient d'entrer une nouvelle ligne -------------------
//--------------------------------------------------------------------------
void TERM_put(char * String)
{
  //Selon si le terminal est connecte ou pas
  if( TERM_iStream && *String != ':' )
  {
    char sBuffer[256];

    //Prepaper la ligne a envoyer au switch
    sprintf(sBuffer, "%s\r", String);
    SWITCH_sendFrame(TERM_iStream, sBuffer, strlen(sBuffer));

    //Afficher l'echo sur la console
    sprintf(sBuffer, "%s\n", String);
    DISP_PutsConsole(SCREEN3, sBuffer, COLOR_IN);
  }
  else
  {
    char * pCmd;
    char * pArg;

    //Si c'est une commande passee avec des ":"
    if( *String == ':' )
      String++;

    //Differencier commande et arguments (si possible)
    pCmd = String;	//Commande
    strlwr(pCmd);

    while( *String != SNULL && *String != ' ' )
      String++;

    if( *String != SNULL )
      *String++ = SNULL;//Placer un SNULL pour sparer CMD et ARG

    pArg = String;    	//Arguments (ou SNULL)

    //Est-ce qu'une connection est demandee ?
    if( COMMANDS_check(pCmd, "connect", strlen(pCmd), 1))
    {
      char sBuffer[256];

      //Un indicatif a t-il ete precise ?
      if( ! *pArg )
      {
	DISP_PutsConsole(SCREEN3, " *** No call given.\nCmd>", COLOR_IN);
      }
      else if( TERM_iStream )
      {
	DISP_PutsConsole(SCREEN3, " *** Channel already connected.\nCmd>", COLOR_IN);
      }
      else
      {
	//Connection demandee ...
	TERM_connect( strupr(pArg) );

	//Afficher un echo de la commande sur l'cran
	sprintf(sBuffer, " Trying to connect %s on stream %d\n", pArg, TERM_iStream);
	DISP_PutsConsole(SCREEN3, sBuffer, COLOR_IN);
      }/*End IF*/
    }
    //Definir l'indicatif de la console
    else if( COMMANDS_check(pCmd, "mycall", strlen(pCmd), 2) )
    {
      char sBuffer[256];

      if( * pArg )
      {
	//Quel indicatif a ete indique ?
	pArg[9] = SNULL;
	strupr(pArg);

	//Afficher sur la console
	sprintf(sBuffer, " MyCall : %s\n        Was : %s\nCmd>", pArg, TERM_myCall);
	DISP_PutsConsole(SCREEN3, sBuffer, COLOR_IN);

	strcpy(TERM_myCall, pArg);
      }
      else
      {
	//Simplement afficher MYCALL
	sprintf(sBuffer, " MyCall : %s\nCmd>", TERM_myCall);
	DISP_PutsConsole(SCREEN3, sBuffer, COLOR_IN);
      }/*End IF*/
    }
    //Est-ce qu'une connection est demandee ?
    else if( COMMANDS_check(pCmd, "disconnect", strlen(pCmd), 1) )
    {
      //Deconnecter le cannal
      SWITCH_discSwitch(TERM_iStream);
      TERM_disconnect();
    }
    else if( * pCmd == SNULL )
    {
      DISP_PutsConsole(SCREEN3, "\nCmd>", COLOR_IN);
    }
    else
    {
      //Erreur commande
      DISP_PutsConsole(SCREEN3, " Hug ?\nCmd>", COLOR_IN);
    }/*End IF*/
  }/*End IF*/
}

/*--------------------------------------------------------------------------
  ------ Set terminal callsign ---------------------------------------------
  --------------------------------------------------------------------------
  return the new terminal call
  if pszTermCall == NULL, the terminal callsign is not changed
*/
char* TERM_setCall(char* pszTermCall)
{
	if( pszTermCall )
	{
		TOOLS_maxLength(pszTermCall, 10);
		strcpy(TERM_myCall, pszTermCall);
	}

	return TERM_myCall;
}
