#ifndef TOOLS_H
#define TOOLS_H

#include <alloc.h>
#include <stdio.h>
#include <time.h>
#include <dir.h>
#include <stdarg.h>

char   *TOOLS_removeBell(char * String);
char   *TOOLS_removeN(char * String);
char   *TOOLS_removeR(char * String);
char   *TOOLS_removeNR(char * String);
int  	TOOLS_whatTime(void);
char   *TOOLS_whatDate(char * Date);
char   *TOOLS_whatTime(char * Time);
int 	TOOLS_whatSec(void);
int		TOOLS_whatDay(void);
int 	TOOLS_whatMonth(void);
int 	TOOLS_whatYear(void);
int		TOOLS_whatYear4(void);
time_t 	TOOLS_dateTime_Long2time_t(unsigned long lDateTime);
double 	TOOLS_diffDateTime(unsigned long lDateTime1, unsigned long lDateTime2);
long 	TOOLS_parseTime(const char * pszString);
char   *TOOLS_seconds2string(long lSeconds, char * pszBuffer);
char   *TOOLS_N2R(char * String);
char   *TOOLS_R2N(char * String);
char   *TOOLS_removeSsid(char * String);
//char   *TOOLS_versionStr2Int(char * VersionString, char * VersionInt);
//char   *TOOLS_versionInt2Str(char * VersionInt, char * VersionString);
void 	TOOLS_dateTime_Long2Str(char * Date, char * Time, unsigned long DateTime);
char   *TOOLS_maxLength(char * String, int Length);
int 	TOOLS_month2int(char * Month);
int 	TOOLS_isBin(char * Frame, int Length);
int 	TOOLS_isCall(const char * CallSign);
int 	TOOLS_whatSsid(char * CallSign);
char   *TOOLS_addSsid(char * CallSign, int Ssid);
int	TOOLS_makeBak(char * szFileName);
void 	TOOLS_diffTime(time_t first, time_t second, int * nDays, int * nHours, int * nMin);
char* 	TOOLS_removeNonAscii(const char * pszString, char * pszBuffer);


unsigned long TOOLS_whatDateTime(void);
unsigned long TOOLS_dateTime_Str2Long(char * Date, char * Time);
unsigned int  TOOLS_atoi(char * ptr);
int	      TOOLS_stricmp(char * ptr1, char * ptr2);	
unsigned long TOOLS_frequency2bits(char * pszFrequency);
char 	     *TOOLS_bits2strBand(unsigned long lBand, char * pszBuffer);
unsigned long TOOLS_mode2bits(float fFrequency);
char*  TOOLS_PCQuote2to1(char * pszBuffer);
char*  TOOLS_PCQuote1to2(char * pszBuffer);
time_t TOOLS_dateHMS(char * pszDate);
void   TOOLS_exitDxNet(int nErrNo, char* pszReason);
void   TOOLS_perror(char* ptr);
FILE*  TOOLS_fopen(const char *filename, const char *mode);
int    TOOLS_fclose(FILE* stream);
int    TOOLS_fcloseall(void);
char*  TOOLS_back2slash(char* string);
char*  TOOLS_slash2back(char* string);
long   TOOLS_flength(char *filename);
int    TOOLS_copyFile(char* src, char* dest);
int    TOOLS_vsnprintf(char *buffer, size_t count, const char *format, va_list argptr);

typedef struct _FILEIOLIST
{
	FILE* fPtr;
	char  szFileName[MAXPATH];
	_FILEIOLIST* next;
} FILEIOLIST;

#define atoi(ptr)				TOOLS_atoi(ptr)
#define perror(ptr)				TOOLS_perror(ptr)
#define fopen(filename,mode)	TOOLS_fopen(filename,mode)
#define fclose(fptr)			TOOLS_fclose(fptr)
//#define fcloseall()				TOOLS_fcloseall()

#ifdef LINUX
	#define stricmp(ptr1,ptr2)	TOOLS_stricmp(ptr1,ptr2)
	#define strcasecmp(ptr1,ptr2)	TOOLS_stricmp(ptr1,ptr2)
#endif

#endif