#include <alloc.h>
#include <string.h>
#include <stdio.h>
#include "tools.h"
#include "define.h"
#include "wwv.h"

/*------------------------------------------------------------------------
  ------ Ajouter un WWV dans le fichier WWV ------------------------------
  ------------------------------------------------------------------------*/
void WWV_add(char * pszFromPC, char * pszLogger, char * pszForecast, char * pszDate, char * pszTime, int nSFI, int nA, int nK)
{
	FILE * fPtr;
	WWVSPOT WwvSpot;

	/* Verifier la validite de certains champs */
	if( nSFI > 999 || nA > 999 || nK > 99 )
		return; 	/* Inutile d'aller plus loin */

	/* Limiter la longueur des champs */
	TOOLS_maxLength(pszFromPC, 9);
	TOOLS_removeSsid(pszLogger);
	TOOLS_maxLength(pszLogger, 6);
	TOOLS_maxLength(pszForecast, 80);
	TOOLS_maxLength(pszDate, 11);
	TOOLS_maxLength(pszTime, 4);

	/* Preparer tous les champs de l'enregistrement */
	memset(&WwvSpot, 0, sizeof(WwvSpot));	/* fichier plus clean ! */
	strcpy(WwvSpot.szFromPC,   pszFromPC);
	strcpy(WwvSpot.szLogger,   pszLogger);
	strcpy(WwvSpot.szForecast, pszForecast);
	strcpy(WwvSpot.szDate,	   pszDate);
	strcpy(WwvSpot.szTime,	   pszTime);
	WwvSpot.nSFI = nSFI;
	WwvSpot.nA   = nA;
	WwvSpot.nK   = nK;

	/* Ouvrir le fichier pour placer le nouveau WWV  la fin */
	fPtr = fopen(WWV_FILE, "a+b");

	if( ! fPtr )	/* Erreur d'ouverture du fichier */
	{
		perror("fopen in WWV_add");
		return;
	}

	/* Enregistrer le WWV  la fin du fichier */
	fwrite(&WwvSpot, sizeof(WwvSpot), 1, fPtr);
	fclose(fPtr);
}

/*------------------------------------------------------------------------
  ------ Lire un fichier dans WWV.BIN ------------------------------------
  ------------------------------------------------------------------------
  Retourne TRUE si un enregistrement a pu etre lu                         */
int WWV_get(int nPos, WWVSPOT * pWwvSpot)
{
	FILE *fPtr;
	long  lOffset;

	fPtr = fopen(WWV_FILE, "a+b");

	if( ! fPtr )	/* Erreur d'ouverture du fichier */
	{
		perror("fopen in WWV_get");
		return FALSE;
	}

	/* Se placer a la fin du fichier */
	fseek(fPtr, 0L, SEEK_END);

	/* Remonter de nPos enregistrements */
	lOffset =  (long) nPos * (long) sizeof(WWVSPOT);
	if( lOffset > ftell(fPtr) )
	{
		fclose(fPtr);
		return FALSE;
	}
	fseek(fPtr, -lOffset, SEEK_CUR);

	/* Extraire l'enregistrement */
	fread(pWwvSpot, sizeof(WWVSPOT), 1, fPtr);

	/* Fermer le fichier et retourner */
	fclose(fPtr);
	return TRUE;
}

/*---------------------------------------------------------------------------
  ------ Rechercher si un WWV a deja ete recu -------------------------------
  ---------------------------------------------------------------------------
  Retourne FALSE si un wwv a deja ete recu dans la derniere fenetre de 3
  heures */
int WWV_isAllowed(char * pszDate, char * pszTime)
{
	FILE   *fPtr;
	long	lOffset;
	WWVSPOT WwvSpot;
	unsigned long lCurrentDateTime;
	unsigned long lSpotDateTime;

	/* Quoi qu'il arrive, rejeter si le spot est plus vieux de 3 heures */
	lCurrentDateTime = TOOLS_whatDateTime();
	lSpotDateTime    = TOOLS_dateTime_Str2Long(pszDate, pszTime);
	if( TOOLS_diffDateTime(lCurrentDateTime, lSpotDateTime) >= 14400.0 )
		return FALSE;	/* Spot trop vieux */

	/* Ouvrir le fichier */
	fPtr = fopen(WWV_FILE, "rb");

	if( ! fPtr )	/* Impossible d'ouvrir */
	{
		perror("fopen in WWV_isDupe");
		return FALSE;
	}

	/* Placer le pointeur de fichier NLAST spots en arriere */
	fseek(fPtr, 0L, SEEK_END);			/* Fin du fichier */
	lOffset =  (long) sizeof(WWVSPOT);		/* Calcul offset */
	if( lOffset > ftell(fPtr) )
		fseek(fPtr, 0L, SEEK_SET);		/* Se placer en debut de fichier */
	else
		fseek(fPtr, -lOffset, SEEK_CUR);	/* Pointer sur le dernier enregistrement */

	/* Lecture enregistrement */
	if( ! fread(&WwvSpot, sizeof(WwvSpot), 1, fPtr) )
	{
		fclose(fPtr);
		return TRUE;	/* EOF */
	}

	fclose(fPtr);

	/* Tester */
	if( strcmp(pszDate, WwvSpot.szDate) )
		return TRUE;	/* Date differente : OK */

	if( (atoi(pszTime) / 300) == (atoi(WwvSpot.szTime) / 300) )
		return FALSE;	/* Meme fenetre horaire : rejeter */

	return TRUE;		/* Ok */
}

/*-------------------------------------------------------------------------
  ------ Rechercher si un WWV est un DUPE ---------------------------------
  -------------------------------------------------------------------------
  Retourne TRUE si c'est un DUPE                                           */
int WWV_isDupe(char * pszLogger, char * pszForecast, char * pszDate, char * pszTime, int nSFI, int nA, int nK)
{
	#define	NLAST	50L
	FILE   *fPtr;
	long	lOffset;
	long    lFileSize;
	int	index;
	char	szLogger[16];
	WWVSPOT WwvSpot;

	/* Recherche de DUPE a effectuer qqs le SSID du logger */
	strcpy(szLogger, pszLogger);
	TOOLS_removeSsid(szLogger);

	/* Ouvrir le fichier */
	fPtr = fopen(WWV_FILE, "rb");

	if( ! fPtr )	/* Impossible d'ouvrir */
	{
		perror("fopen in WWV_isDupe");
		return FALSE;
	}

	/* Taille du fichier */
	fseek(fPtr, 0L, SEEK_END);
	lFileSize = ftell(fPtr);

	/* Fichier vide ? */
	if( lFileSize == 0L )
	{
		fclose(fPtr);
		return FALSE;
	}

	/* Placer le pointeur de fichier NLAST spots en arriere */
	lOffset =  NLAST * (long) sizeof(WWVSPOT);	/* Calcul offset */	
	if( lFileSize < lOffset )
		lOffset = lFileSize;
	fseek(fPtr, -lOffset, SEEK_CUR);		/* Pointer sur le dernier */

	/* Tester chacun des spots */
	for(index = 0; index < NLAST; index++)
	{
		/* Lecture enregistrement */
		if( ! fread(&WwvSpot, sizeof(WwvSpot), 1, fPtr) )
			break;	/* EOF */

		/* Comparer ... */
		TOOLS_removeSsid(WwvSpot.szLogger);	/* Qqs le SSID du logger */

		if( nSFI == WwvSpot.nSFI &&
		    nA   == WwvSpot.nA   &&
		    nK   == WwvSpot.nK   &&
		    ! strcmp(szLogger,    WwvSpot.szLogger)   &&
		    ! strcmp(pszForecast, WwvSpot.szForecast) &&
		    ! strcmp(pszDate,     WwvSpot.szDate)     &&
		    ! strcmp(pszTime,     WwvSpot.szTime)  )
		{
			/* DUPE */
			fclose(fPtr);
			return TRUE;
		}
	}/* End FOR */

	/* Fermer le fichier et retourner */
	fclose( fPtr );
	return FALSE;
}

