#include <alloc.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "define.h"
#include "dxcc.h"
#include "message.h"
#include "buffers.h"
#include "locator.h"
#include "users.h"
#include "sun.h"

/*---------------------------------------------------------------------------
  ------ Chercher le prefixe dans le fichier --------------------------------
  -------------------------------------------------------------------------*/
/* Retoure -1 si l'info a ete trouve, sinon retourne le numero du message
   a afficher                                                              */
int DXCC_search(char * pszCallSign, char * pszFound)
{
	#define	MAX_PART 10
	char	szSearchedCall[40];
	char	szCallSign[40];
	char  * pszPart[MAX_PART];
	char  * ptr;
	int 	nMatch;
	int	index;
	int	nPart;
	int	nSmallerLength;
	int	nSmallerPart;

	/* Copie de l'indicatif (pszCallSign est const) */
	if( pszCallSign == NULL || *pszCallSign == SNULL )
		return FALSE;

	strncpy(szSearchedCall, pszCallSign, 39);
	szSearchedCall[39] = SNULL;
	strupr(szSearchedCall);
        strcpy(szCallSign, szSearchedCall);

	/* Effectuer la recherche pour l'indicatif en entier */
	if( (nMatch = DXCC_lookup(szSearchedCall, pszFound)) == -1 )
		return MSG32;

	if( nMatch == 99 )
		return -1;

	/* Decortiquer l'indicatif */
	ptr = szSearchedCall;
	for(nPart = 0; nPart < MAX_PART; nPart++)
	{
		pszPart[nPart] = ptr;

		/* Rechercher '/' */
		ptr = strchr(pszPart[nPart], '/');

		/* S'il n'y en a plus ... */
		if( ptr == NULL )
		{
			nPart++;
			break;
		}
		*ptr++ = SNULL;
	}

	/* Rechercher la plus petite partie de l'indicatif */
	nSmallerLength = 100;
	nSmallerPart   = 0;
	for(index = 0; index < nPart; index++)
	{
		int nLength = strlen(pszPart[index]);

		/* Ne pas considerer les /P, /M, /MM, /Q... */
		if( nLength < nSmallerLength && strcmp(pszPart[index], "P") &&
		    strcmp(pszPart[index], "M") &&
		    strcmp(pszPart[index], "MM") && *pszPart[index] != 'Q' )
		{
			nSmallerLength = nLength;
			nSmallerPart   = index;
		}
	}

	/* Cas particulier : le prefixe fait la meme longueur que
	   l'indicatif */
	if( nPart == 2 && strlen(pszPart[0]) == strlen(pszPart[1]) )
	{
		char	szFound1[256];
		char 	szFound2[256];
		int 	nMatch1;
		int	nMatch2;

		/* Recherche sur la premiere partie */
		nMatch1 = DXCC_lookup(pszPart[0], szFound1);
		nMatch2 = DXCC_lookup(pszPart[1], szFound2);

		/* Recherche sur la deuxieme partie */
		if( nMatch1 > nMatch2 )
		{
			strcpy(pszFound, szFound1);
			return -1;
		}
		else if( nMatch2 != 0 )
		{
			strcpy(pszFound, szFound2);
			return -1;
		}
		else
		{
			return MSG31;
		}
	}

	if( DXCC_lookup(pszPart[nSmallerPart], pszFound) )
		return -1;
	else
		return MSG31;
}

/*---------------------------------------------------------------------------
  ------ Rechercher dans le fichier database/cty.dat ------------------------
  ---------------------------------------------------------------------------
  pszKey   : partie de l'indicatif a rechercher
  pszFound : chaine de caractere contenant les datas au format cty.dat
*/
int DXCC_lookup(char * pszKey, char * pszFound)
{
	char	szCtyLine[256];
	char	szPrefixLine[256];
	char	szBuffer[256];
	char	szLookFor[80];
	int	nBestMatch = 0;
	FILE*	fPtr;

	/* Ouvrir le fichier */
	fPtr = fopen(DATABASE_PREFIX_FILE, "rt");

	if( ! fPtr )
	{
		perror("DXCC_search (database\\cty.dat)");
		return -1;
	}

	/* Parcourir l'ensemble du fichier */
	for(;;)
	{
		int	nNoBest;

		/* Lecture de la ligne d'infos */
		if( ! fgets(szCtyLine, 255, fPtr) )
			break;

		/* Parcourir la liste de prefixes */
		do
		{
			/* Ligne de prefixes */
			fgets(szPrefixLine, 255, fPtr);

			/* Ajouter une virgule en debut de champ */
			sscanf(szPrefixLine, "%s", szBuffer);
			sprintf(szPrefixLine, ",%s", szBuffer);

			nNoBest = FALSE;

			while( ! nNoBest && pszKey[nBestMatch] != SNULL )
			{
				char *	ptr1;
				char *	ptr2;
				char* pszPtr2PrefixLine = szPrefixLine;

				do
				{
					/* Partie a rechercher (de longueur nBestMatch) */
					sprintf(szLookFor, ",%s", pszKey);
					szLookFor[nBestMatch + 2] = SNULL;

					/* Rechercher le partiel dans la ligne */
					ptr1 = strstr(pszPtr2PrefixLine, szLookFor);
					if( ptr1++ )
					{
						int Done = TRUE;
						ptr2 = pszKey;

						/* Verifier l'exactitude jusqu'a la
						fin du prefixe */
						while( *ptr1 != ',' && *ptr1 != ';' &&
						       *ptr1 != '(' && *ptr1 != '[' &&
						       *ptr1 != '<' && *ptr1 != '{' )
						{
							if( *ptr1++ != *ptr2++ )
							{
								Done = FALSE;
								break;
							}
						}

						/* Ce prefixe correspond */
						if( Done )
						{
							/* Affiner la prochaine
							   recherche an ajoutant
							   un caractere */
							nBestMatch++;
							strcpy(pszFound, szCtyLine);

							/* Gerrer les cas particulier
							   de zones, continent, ... */
							DXCC_specialCase(ptr1, szCtyLine);
						}
						else
							pszPtr2PrefixLine = strchr(ptr1, ',');

					}
					else
						nNoBest = TRUE;

					if( pszPtr2PrefixLine == NULL )
						nNoBest = TRUE;

				}while( ! nNoBest && pszKey[nBestMatch] );
			}
		} while( szPrefixLine[strlen(szPrefixLine) - 1] != ';' &&
			 pszKey[nBestMatch] );

		/* Correspondance exacte trouve ? */
		if( pszKey[nBestMatch] == SNULL )
		{
			fclose(fPtr);
			return 99;
		}

	}

	fclose(fPtr);
	return nBestMatch;
}

/*---------------------------------------------------------------------------
  ------ Affiche le resultat de la recherche --------------------------------
  ------------------------------------------------------------------------ */
void DXCC_showResult(int StreamNum, char * szKey, char * pszCtyLine)
{
	LOCATOR_COORDINATES from;
	LOCATOR_COORDINATES to;
	char	szBuffer[256];
	int	nSepar = strlen(szKey);
	int	index;
	extern tUser   *pUser;


	/* CALLSIGN   - ou -   CALLSIGN (PREFIX) : */
	DXCC_getField(pszCtyLine, szBuffer, DXCC_PREFIX_P, DXCC_PREFIX_L);

	/* Selon que le prefixe est egale a la clef recherchee ou pas ... */
	if( ! strcmp(szKey, szBuffer) )
		BUFFERS_printBuff(StreamNum, OUT, "%s : ", szKey);
	else
	{
		BUFFERS_printBuff(StreamNum, OUT, "%s (%s) : ",
				  szKey, szBuffer);
		nSepar += strlen(szBuffer) + 3;
	}

	/* Contry */
	DXCC_getField(pszCtyLine, szBuffer, DXCC_CTYNAME_P, DXCC_CTYNAME_L);
	BUFFERS_printBuff(StreamNum, OUT, "%s ", szBuffer);

	nSepar += strlen(szBuffer) + 8;

	/* Continent */
	BUFFERS_printBuff(StreamNum, OUT, "(%s)\n",
			  DXCC_getField(pszCtyLine, szBuffer,
					DXCC_CONTINENT_P, DXCC_CONTINENT_L));

	/* Ne pas aller plus loin si le switch more n'a pas ete entre */

	/* Separateur */
	for(index = 0; index < nSepar; index++)
		szBuffer[index] = '-';
	szBuffer[index]     = SNULL;
	BUFFERS_printBuff(StreamNum, OUT, "%s\n", szBuffer);


	/* CQ Zone */
	BUFFERS_printBuff(StreamNum, OUT, "CQ Zone   : %s\n",
			  DXCC_getField(pszCtyLine, szBuffer,
					DXCC_CQZONE_P, DXCC_CQZONE_L));

	/* ITU Zone */
	BUFFERS_printBuff(StreamNum, OUT, "ITU Zone  : %s\n",
			  DXCC_getField(pszCtyLine, szBuffer,
					DXCC_ITUZONE_P, DXCC_ITUZONE_L));

	/* GMT */
	BUFFERS_printBuff(StreamNum, OUT, "GMT       : %s\n",
			  DXCC_getField(pszCtyLine, szBuffer,
					DXCC_TIMEOFFSET_P, DXCC_TIMEOFFSET_L));

	/* Latitude */
	BUFFERS_printBuff(StreamNum, OUT, "Latitude  : %s\n",
			  DXCC_getField(pszCtyLine, szBuffer,
			  DXCC_LATITUDE_P, DXCC_LATITUDE_L));
	to.doLat = atof(szBuffer); /* Pour le calcul dist/az */

	/* Longitude */
	BUFFERS_printBuff(StreamNum, OUT, "Longitude : %s\n",
			  DXCC_getField(pszCtyLine, szBuffer,
			  DXCC_LONGITUDE_P, DXCC_LONGITUDE_L));
	to.doLong = -atof(szBuffer);

	/* Recuperer le locator de l'utilisateur en memoire */
	USERS_getRecord(StreamNum); /* Pour le calcul dist/az */

	if( ! LOCATOR_isValidWW(pUser->sLocator) )
	{
		/* locator pas valide */
		return;
	}

	/* Initialiser les coordonnees de l'utilisateur */
	LOCATOR_locator2coordinates(pUser->sLocator, &from);

	/* Distance */
	BUFFERS_printBuff(StreamNum, OUT, "Distance  : %d km\n",
			  LOCATOR_distance(from, to));

	/* Azimut */
	BUFFERS_printBuff(StreamNum, OUT, "Azimut    : %d (short path)\n",
			  LOCATOR_azimut(from, to));

	BUFFERS_printBuff(StreamNum, OUT, "Sunrise   : %sZ\n",
		SUN_calculate(to.doLat, to.doLong, SUN_RISE, szBuffer));

	BUFFERS_printBuff(StreamNum, OUT, "Sunset    : %sZ\n",
		SUN_calculate(to.doLat, to.doLong, SUN_SET, szBuffer));


}

/* --------------------------------------------------------------------------
   ------ Traiter les cas particuliers de zones, continents, etc ... --------
   ----------------------------------------------------------------------- */
void DXCC_specialCase(char * ptr, char * pszCtyLine)
{
	int 	nValue;
	float 	fValue;
	char    szField[64];

    for(;;)
    {
	switch( *ptr )
	{
	case '(' : /* CQ zone */
		nValue = atoi(ptr + 1);
		sprintf(szField, "%02d", nValue);
		DXCC_setField(pszCtyLine, szField, DXCC_CQZONE_P, DXCC_CQZONE_L);
		ptr = strchr(ptr, ')');
		break;

	case '[' : /* ITU Zone */
		nValue = atoi(ptr + 1);
		sprintf(szField, "%02d", nValue);
		DXCC_setField(pszCtyLine, szField, DXCC_ITUZONE_P, DXCC_ITUZONE_L);
		ptr = strchr(ptr, ']');
		break;

	case '>' : 	/* Latitude / Longitude */
		fValue = (float) atof(ptr + 1);
		sprintf(szField, "%-2.2f", fValue);
		DXCC_setField(pszCtyLine, szField, DXCC_LONGITUDE_P, DXCC_LATITUDE_L);
		ptr = strchr(ptr, '/');
		fValue = (float) atof(ptr + 1);
		sprintf(szField, "%-3.2f", fValue);
		DXCC_setField(pszCtyLine, szField, DXCC_LONGITUDE_P, DXCC_LONGITUDE_L);
		ptr = strchr(ptr, '>');
		break;

	case '{' :	/* Continent */
		szField[0] = *++ptr;
		szField[1] = *++ptr;
		szField[2] = SNULL;
		DXCC_setField(pszCtyLine, szField, DXCC_CONTINENT_P, DXCC_CONTINENT_L);
		ptr = strchr(ptr, '}');
		break;

	default :
		return;
	}

	ptr++;
     }

}

void DXCC_setField(char * pszCtyLine, char * szField, int nPos, int nLength)
{
 /*	char	szBuffer[256];	*/
	int	index;

	for(index = 0; index < (int) strlen(szField); index++)
		pszCtyLine[index + nPos] = szField[index];

	pszCtyLine[index + nPos] = ':';

	for(index = strlen(szField) + 1; index < nLength; index++)
		pszCtyLine[index + nPos] = ' ';
}


char* DXCC_getField(char * pszCtyLine, char * pszBuffer, int nPos, int nLength)
{
	char * 		pszDest = pszBuffer;
	char *	pszOrg  = pszCtyLine + nPos;
	int		index;

	/* Ne pas copier les premieres caracteres s'ils sont 'blanc' */
	for(index = 0; index < nLength; index++)
	{
		if( *pszOrg != ' ' )
			break;
		else
			pszOrg++;
	}

	for(; index < nLength; index++)
	{
		/* Fin du champ */
		if( *pszOrg == ':' )
		{
			*pszDest = SNULL;
			break;
		}

		*pszDest++ = *pszOrg++;
	}

	return pszBuffer;
}
