////////////////////////////////////////////////////////////////////////////////////////////
// Portage windows (c) f5mzn   jan 2001
//
// Part of code (c) f6fbb
//

#include <winsock2.h>
#include <alloc.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "fbbsrv.h"
#include "switch.h"
#include "users.h"
#include "buffers.h"
#include "filter.h"
#include "streams.h"
#include "set.h"
#include "tools.h"
#include "password.h"
#include "commands.h"
#include "script.h"
#include "protocol.h"
#include "node.h"

#ifdef LINUX
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#endif

#define ORB_WAITINFO	0
#define ORB_WAITPASS	1
#define ORB_CONNECTED	2
#define ORB_DISCONNECT	3

#define ORB_DATA	0
#define ORB_REQUEST	0
#define ORB_MSGS	1
#define ORB_STATUS	2
#define ORB_NBCNX	4
#define ORB_LISTCNX	8
#define ORB_MONITOR	16
#define ORB_CONSOLE	32
#define ORB_CHANNEL	64
#define ORB_XFBBX	128

/* Services annexes */
#define SVC_LIST	0
#define SVC_DIR		1
#define SVC_RECV	2
#define SVC_SEND	3
#define SVC_DISC	5
#define SVC_END		-1

/* Services non utilises actuellement */
#define SVC_FWD		4
#define SVC_USER	6
#define SVC_MSG		7
#define SVC_MREQ	8

/* Liste des services annexes offert par DxNet */
static int FBBSRV_nServiceTable[] = {SVC_DIR, SVC_RECV, SVC_SEND, SVC_DISC, SVC_END};

#define W_CNST		5

#ifdef WIN32
	/* Portage WIN32 */
	#include <io.h>
	#include <fcntl.h>
	#define close(x)			closesocket(x)
	#define write(x, y, z)		send(x, y, z, 0)
	#define socklen_t			int 
	#define MyCall				SWITCH_szMyCall
	#define read(x, y, z)		recv(x, y, z, 0)
#else
	/* gestion des fichiers */
	#define _open		open
	#define _close		close
	#define _read		read
	#define _unlink		unlink
	#define _write		write
#endif

/* Variables globales */
static int IsConsoleConnected  = FALSE;
OrbClient * client_head = NULL;
int orb_fd = -1;

/* Variables externes */
extern char MyCall[20];
extern int  errno;

static void orb_send_data (char *buffer, int lg, int mask)
{
	OrbClient *sptr = client_head;

	while (sptr)
	{
		/* Ne transmettre que si le client supporte le service */
		if (sptr->mask & mask)
		{
			switch (mask)
			{
			case ORB_MONITOR:
			case ORB_CONSOLE:
			case ORB_CHANNEL:
				if (((mask == ORB_MONITOR) && (buffer[4] == (char) 0xff)) ||
					((mask == ORB_CONSOLE) && (buffer[4] == 0)))
				{
					write (sptr->fd, buffer, lg);
				}
				if ((mask == ORB_CHANNEL) && (buffer[4] > 0) && (buffer[4] < 0xff))
				{
					if ((sptr->channel == 0) || (sptr->channel == buffer[4]))
						write (sptr->fd, buffer, lg);
				}
				break;
			default:
				write (sptr->fd, buffer, lg);
				break;
			}
		}
		sptr = sptr->next;
	}
}

/*--------------------------------------------------------------------
  ------ Transmettre des donnees contenues dans un fichier -----------
  --------------------------------------------------------------------*/
static int send_data(int sock, char *datafile, char *datarequest, int len, int command)
{
	int fd;
	int nb;
	char buffer[1024];

	TOOLS_back2slash(datafile);
	TOOLS_back2slash(datarequest);
	
	buffer[0] = ORB_DATA;
	buffer[1] = command;

	buffer[2] = len % 256;
	buffer[3] = len >> 8;
	memcpy(buffer+4, datarequest, len);
	write(sock, buffer, len+4);
		
#ifdef WIN32
	TOOLS_slash2back(datafile);
#endif

	fd = _open(datafile, O_RDONLY);
	if (fd == -1)
	{
		buffer[2] = 0;
		buffer[3] = 0;
		write(sock, buffer, 4);
		return errno;
	}
		
	for (;;)
	{
		nb = _read(fd, buffer + 4, 1000);
		if (nb < 0)
			nb = 0;
		buffer[2] = nb % 256;
		buffer[3] = nb >> 8;
		write(sock, buffer, nb+4);
		printf("%d data sent\n", nb);
		if (nb == 0)
			break;
	}
	
	_close(fd);
	if( _unlink(datafile) == -1 )
		perror("unlink in send_data (FBBSRV) ");
		
	return 0;
}

/*--------------------------------------------------------------------
  ------ Transmettre les services annexes ----------------------------
  --------------------------------------------------------------------*/
static void orb_services(void)
{
	char buffer[260];
	int i = 0;

	while( FBBSRV_nServiceTable[i] != SVC_END )
		buffer[4 + i] = (char) FBBSRV_nServiceTable[i++];

	/* Header */
	buffer[0] = ORB_DATA;
	buffer[1] = SVC_LIST;
	buffer[2] = i;	/* Max 255 services */
	buffer[3] = 0;


	orb_send_data(buffer, 4 + i, 0xffff);
}


/*----------------------------------------------------------------------------
  ------ Ajouter un nouveau client a la liste chainee ------------------------
  ----------------------------------------------------------------------------
  Extrait de fbb_orb.c (f6fbb)                                                
  retour = pointeur sur la nouvelle structure OrbClient ou NULL si echec
*/   
static OrbClient *orb_add_client (void)
{
	OrbClient *sptr;

	sptr = (OrbClient*) calloc (1, sizeof (OrbClient));
	if (sptr == NULL)
		return (NULL);

	sptr->next = client_head;
	client_head = sptr;

	return (sptr);
}

/*----------------------------------------------------------------------------
  ------ Supprimer un client de la liste chainee -----------------------------
  ----------------------------------------------------------------------------
  Extrait de fbb_orb.c (f6fbb)                                                
*/   
static void orb_del_client (OrbClient * cptr)
{
	OrbClient *sptr;
	OrbClient *prev;

	prev = NULL;
	sptr = client_head;
	while (sptr)
	{
		if (sptr == cptr)
		{
			if (prev)
				prev->next = sptr->next;
			else
				client_head = sptr->next;
			free (sptr);
			break;
		}
		prev = sptr;
		sptr = sptr->next;
	}
}

/*----------------------------------------------------------------------------
  ------ Accepter une nouvelle connexion d'un client -------------------------
  ----------------------------------------------------------------------------
  Extrait de fbb_orb.c (f6fbb)                                                
  retour = 1 si OK
*/   
int FBBSRV_orb_new_connection (int fd)
{
	int addr_len;
	struct sockaddr_in sock_addr;
	OrbClient *sptr;

	sptr = orb_add_client ();

	addr_len = sizeof (sock_addr);

	sptr->fd = accept (fd, (struct sockaddr *) &sock_addr, 
		(socklen_t*) &addr_len);
	sptr->state = ORB_WAITINFO;

	return (sptr->fd);
}

/*---------------------------------------------------------------------------
 ------ Tente de connecter la console ---------------------------------------
 ----------------------------------------------------------------------------
 Retour : TRUE si OK
*/
static int console_connect (OrbClient * sptr)
{
	int nFlags;					
	
	if( IsConsoleConnected )
		return FALSE;
					
	IsConsoleConnected = TRUE;
									
	/* Charger la config utilisateur pour l'indicatif */
	USERS_openRecord(BUFFER_SCREEN2, sptr->callsign);

	/* Initialiser les filtres */
	nFlags = USERS_getFlags(BUFFER_SCREEN2);
	FILTER_setUser(BUFFER_SCREEN2, nFlags);
					
	/* Envoyer le CTEXT */
	STREAMS_ctext(BUFFER_SCREEN2);
	
	return TRUE;
}

/*---------------------------------------------------------------------------
 ------ Tente de deconnecter la console -------------------------------------
 ----------------------------------------------------------------------------
 Retour : TRUE si OK
*/
static void console_disconnect (void)
{
	int nFlags;					
	extern char STREAMS_callsign[MAX_STREAMS][10];

	IsConsoleConnected = FALSE;
				
	strcpy(STREAMS_callsign[BUFFER_SCREEN2], MyCall);
					
	/* Charger la config utilisateur pour l'indicatif */
	USERS_openRecord(BUFFER_SCREEN2, MyCall);

	/* Initialiser les filtres */
	nFlags = USERS_getFlags(BUFFER_SCREEN2);
	FILTER_setUser(BUFFER_SCREEN2, nFlags);
}

void FBBSRV_orb_process_data (OrbClient * sptr)
{
	extern char * PARAMS_sysop;
	int nb;
	static char buffer[1024];
	static int nbrcv = 0;
	static int rcv_state = 0;
	static int rcv_fd;
	char call[256];
	char pass[256];
	char *ptr;	
	int ok = FALSE;
	int lg;

	nb = read (sptr->fd, buffer + nbrcv, sizeof (buffer) - nbrcv);

	if (nb <= 0)	
	{
		/* Client is disconnected */
		if (sptr->mask & ORB_CONSOLE)
		{
			/* Disconnect from console */
			console_disconnect ();
		}

		close (sptr->fd);
		orb_del_client (sptr);
		nbrcv = 0;
		return;
	}

	nbrcv += nb;

again:
	lg = nbrcv;
	if ((nbrcv >= 3) && (buffer[0] == ORB_REQUEST ))
	{
		static char datafile[256];
		static char datarequest[1024];
		static char cmd[300];
		int mask;
		int ack;
		int len;
#ifdef WIN32
		struct _finddata_t file;
		long hFile;
#endif

		/*commande */
		switch (buffer[1])
		{
		case ORB_REQUEST:
			/* Changement de masque */
			mask = buffer[2] & 0xff;
			if ((mask & ORB_CONSOLE) != (sptr->mask & ORB_CONSOLE))
			{
				if (mask & ORB_CONSOLE)
				{
					/* Console connection */
					if( console_connect (sptr) == TRUE )
					{
						ack = 1;
					}
					else
					{
						ack = 2;
					}
				}
				else
				{
					/* Console deconnection */
					console_disconnect ();
					ack = 0;
				}
				buffer[0] = (char) ORB_XFBBX;
				buffer[1] = 0;
				buffer[2] = 1;
				buffer[3] = 0;
				buffer[4] = ack;
				write (sptr->fd, buffer, 5);
			}
			if ((mask & ORB_LISTCNX) != (sptr->mask & ORB_LISTCNX))
				FBBSRV_connectedList(0, FBBSRV_CONLIST_REFRESH, sptr);
			sptr->mask = mask;
			lg = 3;
			break;

		case SVC_DIR :	/* Retourne le directory */			
			if( nbrcv < 4 )
				return;
			len = ((unsigned int) buffer[3] << 8) + (unsigned int) buffer[2];
			if( nbrcv < len + 4 )
				return;
			if( sptr->state != ORB_CONNECTED )
				return;
			if( len < 256 )
			{
				int nb;

				buffer[nbrcv] = '\0';
				sprintf(datafile, "%sclientdata.txt", TEMP_PATH);
				/* Liste des fichiers dans le repertoire */
#ifdef LINUX
				nb = sprintf(datarequest, "%s%s", CONFDIR, buffer+4) + 1;
				sprintf(cmd, "ls -oA %s | awk '{ print substr($1,1,1),$4,$8,$5\"-\"$6\"-\"$7 }' > %s 2>&1", datarequest, datafile);
				system(cmd);
#else
				nb = sprintf(datarequest, "%s%s\\*.*", CONFDIR, buffer+4) + 1;
				if( (hFile = _findfirst(TOOLS_slash2back(datarequest), &file )) != -1L )
				{
					extern char sDateTable[12][4];
					FILE* fPtr;

					fPtr = fopen(datafile, "wt");
					if( ! fPtr )
					{
						perror("fopen in FBBSRV_orb_process_data ");
						return;
					}

					struct tm* ltime;
					do
					{
						if( ! strcmp(file.name, ".") || ! strcmp(file.name, "..") )
							continue;

						ltime = localtime(&(file.time_write));

						fprintf(fPtr, "%c %d %s %3s-%d-%02d:%02d\n", 
							file.attrib & _A_SUBDIR ? 'd' : '-',
							file.size, file.name,
							sDateTable[ltime->tm_mon], ltime->tm_mday, 
							ltime->tm_hour, ltime->tm_min);
					}
					while( _findnext(hFile, &file ) == 0 );
					_findclose(hFile);   
					fclose(fPtr);
				}
#endif
				nb += sprintf(datarequest + nb, "%ld", TOOLS_flength(datafile)) + 1;
				send_data(sptr->fd, datafile, datarequest, nb, SVC_DIR);
			}
			lg = len + 4;
			break;

		case SVC_RECV :		/* File request */
			if( nbrcv < 4 )
				return;
			len = ((unsigned int) (unsigned char) buffer[3] << 8) + (unsigned int) (unsigned char) buffer[2];
			if( nbrcv < len + 4 )
				return;
			if( sptr->state != ORB_CONNECTED )
				return;
			if (len < 256)
			{
				buffer[nbrcv] = '\0';
				sprintf(datafile, "%sclientdata.txt", TEMP_PATH);
				nb = sprintf(datarequest, "%s%s", CONFDIR, buffer + 4) + 1;
#ifdef LINUX
				TOOLS_copyFile(TOOLS_back2slash(datarequest), datafile);
#else
				TOOLS_copyFile(TOOLS_slash2back(datarequest), datafile);
#endif
				nb += sprintf(datarequest + nb, "%ld", TOOLS_flength(datafile)) + 1;
				send_data(sptr->fd, datafile, datarequest, nb, SVC_RECV);
			}
			lg = len + 4;
			break;

		case SVC_SEND:		/* File receive */
			if( nbrcv < 4 )
				return;
			len = ((unsigned int) (unsigned char) buffer[3] << 8) + (unsigned int) (unsigned char) buffer[2];
			if( nbrcv < len + 4 )
				return;
			if( sptr->state != ORB_CONNECTED )
				return;
				
			if( len <= 1000 )
			{
				switch (rcv_state)
				{
				case 0 :
					buffer[nbrcv] = '\0';
					sprintf(datafile, "%sclientdata.txt", TEMP_PATH);
					sprintf(datarequest, "%s%s", CONFDIR, buffer + 4);
#ifdef LINUX
					TOOLS_back2slash(datarequest);
#else
					TOOLS_slash2back(datarequest);
#endif
					rcv_fd = _open(datafile, O_CREAT|O_TRUNC|O_WRONLY, 0666);
					rcv_state = 1;
					break;
				case 1:				
					if (len == 0)
					{
						char header[4];
						
						/* End of file */
						if (rcv_fd > 0)
						{
							_close(rcv_fd);
							TOOLS_copyFile(datafile, datarequest);
							if( _unlink(datafile) == -1 )
								perror("unlink in FBBSRV_orb_process_data (SVC_SEND)");
						}
						header[0] = ORB_DATA;
						header[1] = SVC_SEND;
						header[2] = 0;
						header[3] = 0;
						write(sptr->fd, header, 4);
						rcv_state = 0;
						break;
					}
					if (rcv_fd > 0)
					{
						nb = _write(rcv_fd, buffer+4, len);
						if (nb <= 0)
						{
							_close(rcv_fd);
							rcv_fd = -1;
						}
					}
					break;
				}
			}
			lg = len + 4;
			break;

		case SVC_DISC :	/* Disconnect request */
			if (nbrcv < 4)
				return;
			len = ((unsigned int) buffer[3] << 8) + (unsigned int) buffer[2];
			if (nbrcv < len+4)
				return;
			if (sptr->state != ORB_CONNECTED)
				return;
			if (len < 256)
			{
				char callsign[80];
				int nChan;
				int bImm;
				int nb;

				buffer[nbrcv] = '\0';
				nb = sscanf(buffer+4, "%d %s %d", &nChan, callsign, &bImm);
				if (nb == 3 && nChan >= 1 && nChan <= 64 )
				{
					extern int	STREAMS_level[MAX_STREAMS];
					extern char	STREAMS_callsign[MAX_STREAMS][10];
					extern unsigned long COMMANDS_statut[MAX_STREAMS];

					if( bImm )
					{
						/* disconnected immediatly */
						BUFFERS_printBuff (BUFFER_SCREEN1, OUT,
							"Channel %d is being disconnected.\n", nChan);
						STREAMS_disconnect(nChan);
						SWITCH_discSwitch (nChan);
						STREAMS_callsign[nChan][0] = SNULL;
						STREAMS_level   [nChan]    = 0;
					}
					else
					{
						/* Is it a cluster ? */
						if( STREAMS_level[nChan] & LEVEL_cluster )
						{
							/* Transmettre un PC39 et informer les adjacents */
							char szBuffer[256];
							char szCall[256];

							NODE_getNodeCall(0, 0, szCall);
							sprintf(szBuffer, "Disconnected by operator at %s", szCall);
							PROTOCOL_sendExplicitDisconnect(BUFFER_SCREEN2, 
								STREAMS_callsign[nChan], szBuffer);
							NODE_deleteNode(nChan, STREAMS_callsign[nChan]);
							STREAMS_level   [nChan]    = LEVEL_discByOp;
							STREAMS_callsign[nChan][0] = SNULL;
						}
						else
						{
							BUFFERS_addBuff(nChan, "Disconnected by operator\n", OUT);
							COMMANDS_statut[nChan] = COMMANDS_statutDisconnect;
						}
					}
				}
			}
			lg = len+4;
			break;
		}		
	}
	else
	{
		char* endptr;

		/* Check if the whole line is received */
		buffer[nbrcv] = '\0';
		endptr = strchr (buffer, '\n');
		if( endptr == NULL )
			return;

		lg = 1 + endptr - buffer;

		switch (sptr->state)
		{
		case ORB_WAITINFO:

			/* Mask of services */
			sscanf (buffer, "%ld %d %s", &sptr->mask, &sptr->channel, call);
			call[11] = '\0';
			strupr(call);
			strcpy (sptr->callsign, call);
			sptr->cle = time (NULL);
			sprintf (call, "%010ld", sptr->cle);
			write (sptr->fd, call, strlen (call));
			sptr->state = ORB_WAITPASS;
			break;

		case ORB_WAITPASS:
		
			/* L'indicatif est-il declare sysop ?*/
  			strcpy(call, sptr->callsign);

  			/* Chercher d'abord pour un SSID donne*/
  			if( ! strchr(call, '-') )
    				strcat(call, "-0"); /* Ajouter le SSID -0 si besoin */
  			if( SET_check(PARAMS_sysop, call) )
    				ok = TRUE;

  			/* Chercher maintenant sans tenir compte du SSID */
  			TOOLS_removeSsid(call);
  			if( SET_check(PARAMS_sysop, call) )
    				ok = TRUE;

			/* Callsign sans SSID */
			strcpy (call, sptr->callsign);
			if ((ptr = strchr (call, '-')))
				*ptr = '\0';

			/* Password */
			sscanf (buffer, "%s", pass);

			if( ok && PASSWORD_isMDKeyOK(call, pass, sptr->cle) )
			{
				/* Transmettre les services annexes */
				orb_services();

				/* Transmettre la liste des stations connectees */
				FBBSRV_connectedList(0, FBBSRV_CONLIST_REFRESH, sptr);

				if (sptr->mask & ORB_CONSOLE)
				{
					if( console_connect (sptr) == FALSE )
					{
						char *txt = "Console already connected !\n\n";
						int len = strlen (txt) + 3;

						strcpy (buffer + 7, txt);

						/* Header */
						buffer[0] = ORB_CONSOLE;
						buffer[1] = 0;
						buffer[2] = (len) & 0xff;
						buffer[3] = (len) >> 8;

						buffer[4] = ORB_CONSOLE;
						buffer[5] = W_CNST;
						buffer[6] = 0;

						write (sptr->fd, buffer, len + 4);
						close (sptr->fd);
						orb_del_client (sptr);
					}
				}
				sptr->state = ORB_CONNECTED;
			}
			else
			{
				char *txt = "Callsign/Password error !\n\n";
				int len = strlen (txt) + 3;

				strcpy (buffer + 7, txt);

				/* Header */
				buffer[0] = ORB_CONSOLE;
				buffer[1] = 0;
				buffer[2] = (len) & 0xff;
				buffer[3] = (len) >> 8;

				buffer[4] = ORB_CONSOLE;
				buffer[5] = W_CNST;
				buffer[6] = 0;

				write (sptr->fd, buffer, len + 4);
				close (sptr->fd);
				orb_del_client (sptr);
			}
			break;

		case ORB_CONNECTED:

			if (sptr->mask & ORB_CONSOLE)
			{
				TOOLS_removeNR(buffer);
				CMD_execute(BUFFER_SCREEN2, buffer);
			}
			break;
		}
	}

	/* Au cas ou il resterait des datas */
	if( lg < nbrcv )
	{
		nbrcv -= lg;
		memmove(buffer, buffer + lg, nbrcv);
		goto again;
	}
	nbrcv = 0;
}

/*----------------------------------------------------------------------------
  ------ Initialisation du socket destine aux consoles -----------------------
  ----------------------------------------------------------------------------
  Extrait de fbb_orb.c (f6fbb)                                                 
  Retour : 1 si OK
*/
int FBBSRV_initOrb (int port)
{
	int val;
	int len;
	struct sockaddr_in sock_addr;

	if ((orb_fd = socket (AF_INET, SOCK_STREAM, 0)) < 0)
	{
		perror ("socket_r");
		return (0);
	}

	val = 1;
	len = sizeof (val);
	if (setsockopt (orb_fd, SOL_SOCKET, SO_REUSEADDR, (char *) &val, len) == -1)
	{
		perror ("opn_tcp : setsockopt SO_REUSEADDR");
	}

	sock_addr.sin_family = AF_INET;
	sock_addr.sin_addr.s_addr = 0;
	sock_addr.sin_port = htons (port);

	if (bind (orb_fd, (struct sockaddr *) &sock_addr, sizeof (sock_addr)) != 0)
	{
		perror ("opn_tcp : bind");
		close (orb_fd);
		return (0);
	}

	if (listen (orb_fd, SOMAXCONN) == -1)
	{
		perror ("listen");
		close (orb_fd);
		return (0);
	}
	
	printf("xfbbC/X/W server running on port %d ...\n", port);

	return (1);
}

/*----------------------------------------------------------------------------
  ------ Envoyer des datas a la console --------------------------------------
  ----------------------------------------------------------------------------
  Extrait de fbb_orb.c (f6fbb)                                                 
*/
void FBBSRV_orbWrite (int channel, char *data, int len, int color, int header)
{
	int i, j;
	char *buffer;

	buffer = (char*) malloc (len + 8);
	if (buffer == NULL)
		return;

	for (i = 0, j = 7; i < len; i++)
	{
		if (data[i] == '\n')
			continue;

		if (data[i] == '\r')
			buffer[j++] = '\n';
		else
			buffer[j++] = data[i];
	}

	if (channel == _CONSOLE)
	{
		/* Header */
		buffer[0] = ORB_CONSOLE;
		buffer[1] = 0;
		buffer[2] = (j - 4) & 0xff;
		buffer[3] = (j - 4) >> 8;

		/* Envoie les data de console au client */
		buffer[4] = _CONSOLE;
		buffer[5] = color;
		buffer[6] = header;
		orb_send_data (buffer, j, ORB_CONSOLE);
	}
	else if (channel == _MONITOR)
	{
		/* Header */
		buffer[0] = ORB_MONITOR;
		buffer[1] = 0;
		buffer[2] = (j - 4) & 0xff;
		buffer[3] = (j - 4) >> 8;

		/* Envoie les data de monitoring au client */
		buffer[4] = (char) 0xff;
		buffer[5] = color;
		buffer[6] = header;
		orb_send_data (buffer, j, ORB_MONITOR);
	}
	else
	{
		/* Header */
		buffer[0] = ORB_CHANNEL;
		buffer[1] = 2;
		buffer[2] = (j - 4) & 0xff;
		buffer[3] = (j - 4) >> 8;

		/* Envoie les data de monitoring au client */
		buffer[4] = channel - 1;
		buffer[5] = color;
		buffer[6] = header;
		orb_send_data (buffer, j, ORB_CHANNEL);
	}
	free (buffer);
}

/*---------------------------------------------------------------------------
  ------ SWITCH_isConsoleConnected - Indique si la console est connectee ----
  ------ via TCP/IP ---------------------------------------------------------
  ---------------------------------------------------------------------------*/
int FBBSRV_isConsoleConnected(void)
{
	return IsConsoleConnected;
}

#define LINEMAX STREAMS_level[StreamNum] & LEVEL_cluster ? 66 : 80

/*----------------------------------------------------------------------------
  ------ Transmet le monitoring aux clients fbb ------------------------------
  ----------------------------------------------------------------------------*/
void FBBSRV_monitor(int StreamNum, char * pszString, int nSize, int Direction)
{
	extern int  STREAMS_level[MAX_STREAMS];
	extern char STREAMS_callsign[MAX_STREAMS][10];
	extern char PROTOCOL_linkType[65];
	
	static int  nPutHeader          = TRUE;
	static int  nMonitorLineSize    = 0;
	static char szHeaderOld[32];	
	static char szBuffer[1024];
	static char szHeader[32];
	char*ptr;
	int  len;
	int  index;
	int  nLineMax;
	int  nLineSize = 0;
	int  nColour;

	/* Securite */
	if( nSize > 1023 )
		return;

	/* La couleur depend de la direction */
	if( Direction == 0 )
		nColour = 1;
	else
		nColour = 0;

	/* Tout envoyer a _ALLCHAN */
	memcpy(szBuffer, pszString, nSize);
	ptr = szBuffer;
	for(index = 0; index < nSize; index++)
	{
		if( *ptr == '\n' )
			*ptr = '\r';
		ptr++;
	}
	FBBSRV_orbWrite(_ALLCHAN + StreamNum - 1, szBuffer, nSize, nColour, 0);
	if( ! (STREAMS_level[StreamNum] & LEVEL_cluster) )
		return;		/* termine ! */
	
	/* Call du correspondant */
	if( STREAMS_callsign[StreamNum][0] == '\0' )
	{
		SCRIPT_getLinkSetupCall(StreamNum, szBuffer);
		if( szBuffer[0] == '\0' )
			strcpy(szBuffer, "NOCALL");
	}
	else
		strcpy(szBuffer, STREAMS_callsign[StreamNum]);
		
	if( Direction == 0 ) 
		sprintf(szHeader, "%s->", szBuffer);	/* IN */
	else 
		sprintf(szHeader, "%s<-", szBuffer);	/* OUT */
		
	len = strlen(szHeader);
	for(index = len; index < 11; index++)
		szHeader[index] = ' ';
	szHeader[index] = '\0';

	strcat(szHeader, ":");
	if( strcmp(szHeader, szHeaderOld) )
		nLineMax = 66 - nMonitorLineSize;
	else
		nLineMax = 66;
	nMonitorLineSize = 0;

	for(index = 0; index < nSize; index++)
	{
		if( nPutHeader == TRUE )
		{
			FBBSRV_orbWrite(_MONITOR, szHeader, strlen(szHeader), nColour, 0);
			nPutHeader = FALSE;
		}
		
		if( *pszString == '\n' )
			szBuffer[nLineSize++] = '\r';
		else
			szBuffer[nLineSize++] = *pszString;
					
		if( *pszString == '\r' || *pszString == '\n' )
		{
			FBBSRV_orbWrite(_MONITOR, szBuffer, nLineSize, nColour, 0);
			nLineSize = 0;
			nPutHeader = TRUE;
			nLineMax = LINEMAX;
		}
		else if( nLineSize >= nLineMax )
		{
			FBBSRV_orbWrite(_MONITOR, szBuffer, nLineSize, nColour, 0);
			FBBSRV_orbWrite(_MONITOR, "\r            ", 13, nColour, 0);
			nLineSize = 0;
			nLineMax = LINEMAX;
		}
		
		pszString++;
	}
	
	if( nLineSize != 0 )
	{
		FBBSRV_orbWrite(_MONITOR, szBuffer, nLineSize, nColour, 0);
		nMonitorLineSize = nLineSize;
	}
}

/*----------------------------------------------------------------------------
  ------ Send CONSOLE row in connectedList -----------------------------------
  ----------------------------------------------------------------------------*/
static void FBBSRV_consoleRowList(OrbClient* sptr)
{
	extern 	time_t	MAIN_timeStart;
	char szNodeCall[16];
	char szOrbString[256];
	char buffer[256];
	int  nConTime;	/* en minutes */
	int  nT1, nT2;
	char cSeparator;
	int  len;

	/* Cluster callsign */
	NODE_getNodeCall(0, 0, szNodeCall);

	/* Tps de connexion */
	nConTime = (int) (difftime(time(NULL), MAIN_timeStart) / 60L);
	if( nConTime < 1440 )		/* les than a day */
	{
		nT1 = nConTime / 60;			/* hours */
		nT2 = nConTime % 60;			/* minutes */
		cSeparator = ':';
	}
	else if( nConTime < 10080 )	/* less than one week */
	{
		nT1 =  nConTime / 1440;			/* days */
		nT2 = (nConTime % 1440) / 60;	/* hours */
		cSeparator = 'd';
	}
	else
	{
		nT1 =  nConTime / 10080;			/* weeks */
		nT2 = (nConTime % 10080) / 1440;	/* days */
		cSeparator = 'w';
	}

	sprintf(buffer, "%c%02d %-9s - %02d%c%02d %2d %3d   console",
		' ',						/* fwd_char */
		99,
		szNodeCall,
		nT1,
		cSeparator,
		nT2,
		0,							/* svoie[i]->sta.ret */
		0							/* svoie[i]->sta.ack */
		);

	len = strlen(buffer);

	/* Header */
	szOrbString[0] = ORB_LISTCNX;
	szOrbString[1] = 0;
	szOrbString[2] = (len) & 0xff;
	szOrbString[3] = (len) >> 8;

	/* Envoie la ligne de connection du stream */
	strcpy(szOrbString + 4, buffer);
	if( sptr == NULL )
		orb_send_data(szOrbString, 4 + len, ORB_LISTCNX);	/* A tous les clients */
	else if( sptr->mask & ORB_LISTCNX )
		write(sptr->fd, szOrbString, len + 4);				/* Uniquement a ce client */
}

/*----------------------------------------------------------------------------
  ------ Transmet la liste des stations connectees ---------------------------
  ----------------------------------------------------------------------------
  StreamNum : numero du stream (inutilise si nAction == FBBSRV_REFRESH )
  nAction   : FBBSRV_CONLIST_CONNECT	= une nouvelle station vient de se 
									      connecter
			  FBBSRV_CONLIST_DISCONNECT = deconnexion d'une station			
			  FBBSRV_CONLIST_REFRESH    = reactualiser la liste complete 
  OrbClient : sptr du client vers lequel adresser la liste - si sptr est NULL
              la fonction adresse la liste a tous les clients                  */
void FBBSRV_connectedList(int StreamNum, int nAction, OrbClient* sptr)
{
	extern char	STREAMS_callsign[MAX_STREAMS][10];
	extern int	STREAMS_level[MAX_STREAMS + RCMD_VIRTSTREAM];
	extern  tUserCfg * pUserCfg;
	char szOrbString[256];
	char buffer[256];
	char szDate[16];
	char szTime[16];
	int  nHour;
	int  nMin;
	int  nConTime;	/* en minutes */
	int  nT1, nT2;
	char cSeparator;
	int  stream;
	int  len;
	int  first, last;
	char* pszConType;

	/* Suivant l'action a realiser */
	if( nAction == FBBSRV_CONLIST_REFRESH )
	{
		first = 1;
		last  = NBSTREAMS;
	}
	else
		first = last = StreamNum;

	/* Envoyer les infos ... */
	for(stream = first; stream <= last; stream++)
	{
		if( nAction == FBBSRV_CONLIST_DISCONNECT )
		{
			/* Deconnexion */
			sprintf(buffer, " %02d", StreamNum);
		}
		else
		{
			/* Y a t-il une station connectee ? */
			if( STREAMS_callsign[stream][0] == SNULL )
				continue;

			/* heure de connexion */
			USERS_getRecord(stream);
			TOOLS_dateTime_Long2Str(szDate, szTime, pUserCfg->lConnectedDateTime);
			nMin  = atoi(szTime + 2);
			szTime[2] = SNULL;
			nHour = atoi(szTime);

			/* Tps de connexion */
			nConTime = (int) (difftime(time(NULL), 
				TOOLS_dateTime_Long2time_t(pUserCfg->lConnectedDateTime)) / 60L);
			if( nConTime < 1440 )		/* les than a day */
			{
				nT1 = nConTime / 60;			/* hours */
				nT2 = nConTime % 60;			/* minutes */
				cSeparator = ':';
			}
			else if( nConTime < 10080 )	/* less than one week */
			{
				nT1 =  nConTime / 1440;			/* days */
				nT2 = (nConTime % 1440) / 60;	/* hours */
				cSeparator = 'd';
			}
			else
			{
				nT1 =  nConTime / 10080;			/* weeks */
				nT2 = (nConTime % 10080) / 1440;	/* days */
				cSeparator = 'w';
			}

			/* Type de connexion */
			if( STREAMS_level[stream] & LEVEL_user )
				pszConType = "user";
			else if( STREAMS_level[stream] & LEVEL_cluster )
				pszConType = "cluster";
			else if( STREAMS_level[stream] & LEVEL_bbs )
				pszConType = "bbs";
			else if( STREAMS_level[stream] & LEVEL_hiddenUser )
				pszConType = "hidden";
			else
				pszConType = "-";
				
			sprintf(buffer, "%c%02d %-9s %02d:%02d %02d%c%02d %2d %3d %c%c%s",
				 ' ',						/* fwd_char */
				 stream,
				 STREAMS_callsign[stream],
				 nHour,
				 nMin,
				 nT1,
				 cSeparator,
				 nT2,
				 0,							/* svoie[i]->sta.ret */
				 0,							/* svoie[i]->sta.ack */
				 ' ',						/* (choix < 2) ? ' ' : '0' + choix */
				 ' ',						/* (choix < 2) ? ' ' : '/' */
				 pszConType					/* bbs */
				 );
		}

		len = strlen(buffer);

		/* Header */
		szOrbString[0] = ORB_LISTCNX;
		szOrbString[1] = 0;
		szOrbString[2] = (len) & 0xff;
		szOrbString[3] = (len) >> 8;

		/* Envoie la ligne de connection du stream */
		strcpy(szOrbString + 4, buffer);
		if( sptr == NULL )
			orb_send_data(szOrbString, 4 + len, ORB_LISTCNX);	/* A tous les clients */
		else if( sptr->mask & ORB_LISTCNX )
			write(sptr->fd, szOrbString, len + 4);				/* Uniquement a ce client */
	}
	if( nAction == FBBSRV_CONLIST_REFRESH )
		FBBSRV_consoleRowList(sptr);
}
