#include <alloc.h>
#include <string.h>
#include <dir.h>
#include <stdio.h>
#ifdef LINUX
#include <sys/stat.h>
#else
#include <sys\stat.h>
#endif
#include "tools.h"
#include "macro.h"
#include "define.h"
#include "message.h"
#include "buffers.h"

/* Executer une macro si elle existe */
/* Retourne -1 si aucune macro n'existe, sinon retourne le nombre de lignes
   lues dans le fichier macro */
#pragma argsused
int MACRO_command(int StreamNum, char * szCmd, char * Args, char * szPath)
{
	struct stat bufstat;
	char szMacro[256];
	char szBuffer[1024];
	char szFileName[MAXPATH];
	FILE *fPtr;
	int  nCount = 0;
#ifdef DOS
	char *ptr;
	
#endif


	/* Quitter si szCmd commence par un '*' ou un '?' */
	if( *szCmd == '?' || *szCmd == '*' )
		return -1;

	/* Preparer le nom du fichier */
	strncpy(szMacro, szCmd, 255);
	szMacro[255] = SNULL;
	TOOLS_removeNR(szMacro);

	sprintf(szFileName, "%s%s.mac", szPath, szMacro);

#ifdef DOS
	/* Transformer les '/' par des '\' */
	ptr = szFileName;
	while( *ptr )
	{
		if( *ptr == '/' )
			*ptr = '\\';
		ptr++;
	}
#endif


	/* Cette macro existe t-elle ? */
	if( (stat(szFileName, &bufstat) == -1) )
		return -1;	/* Non */

	/* OUvrir le fichier et executer la macro */
	fPtr = fopen(szFileName, "rt");
	if( ! fPtr )
	{
		perror("fopen in MACRO_command");
		return -1;
	}

	while( fgets(szBuffer, 255, fPtr) )
	{
		MSG_insertVar(StreamNum, szBuffer);
		TOOLS_removeNR(szBuffer);
		if( strlen(szBuffer) == 0 )
			continue;
		BUFFERS_printBuff(StreamNum, IN, "%c%s\r", 127, szBuffer);
		nCount++;
	}

	fclose(fPtr);

	return nCount;
}
