#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "purgdate.h"
#include "purgdx.h"

/* This program is intended to purge SYSTEM\BIN\DX.BIN */

/* PURGEDX [p=DxPath] [d=#n_days] [v]

   where : - [p=DxPath] specifies the directory in where dx.bin file
	     is located.
	     The default directory is ..\SYSTEM\BIN.

	   - [d=#n_days] sets the number of day (#n_days) after which a
	     dx spot will be deleted.
	     By default, this value is set to 30.

	   - [v] prints the version number.

   Example : PURGDX p=C:\DXNET\SYSTEM\BIN d=7
	or : PURGDX d=15

*/

/*---------------------------------------------------------------------------
  ------ main function ------------------------------------------------------
  -------------------------------------------------------------------------*/
int main(int Argc, char * Argv[])
{
	int	index;
	long	lSpotNum    = 0;
	long	lDelSpotNum = 0;
	int     nDelDays   = 30;
	char	szBinPath[1024];
	char	szBin[256];
	char	szOld[256];
	FILE *	fBinFile;
	FILE *	fOldFile;
	struct DxSpotStruct tDxSpot;

#ifdef LINUX
	strcpy (szBinPath,  "system/bin/");
#else
	strcpy (szBinPath,  "system\\bin\\");
#endif

	/* Get the arguments */
	for(index = 1; index < Argc; index++)
	{
		switch( Argv[index][0] )
		{
			case 'd' :
			case 'D' :
				if( Argv[index][1] == '=' )
				nDelDays = atoi (Argv[index] + 2);
				break;

			case 'p' :
			case 'P' :
				if( Argv[index][1] == '=' )
				strcpy (szBinPath, Argv[index] + 2);
				break;

			case 'v' :
			case 'V' :
				printf("PURGDX v 1.3\n");
				break;
		}/* End SWITCH */
	}/* End FOR */

	/* Check arguments */
	if( nDelDays <= 0 )
		nDelDays = 1;

	/* Prepare the file name */
#ifdef LINUX
	if( szBin[strlen (szBin)] == '/' )
		sprintf (szBin, "%s%s", szBinPath, "dx.bin");
	else
		sprintf (szBin, "%s%s", szBinPath, "/dx.bin");
#else
	if( szBin[strlen (szBin)] == '\\' )
		sprintf (szBin, "%s%s", szBinPath, "dx.bin");
	else
		sprintf (szBin, "%s%s", szBinPath, "\\dx.bin");
#endif
	strcpy (szOld, szBin);
	strcpy (szOld + strlen (szOld) - 4, ".old");

	/* Create a bak file */
	/* Open the files */
	fBinFile = fopen (szBin, "rb");
	if( ! fBinFile )	/* Error opening the file */
	{
		perror ("PURGDX -> fopen in MAIN (fBinFile 1)");
		return (1);
	}

	fOldFile = fopen (szOld, "w+b");
	if( ! fOldFile )	/* Error opening the file */
	{
		perror ("PURGDX -> fopen in MAIN (fOldFile 1)");
		return (2);
	}

	/* Copy dx.bin -> dx.old */
	printf ("Creating dx.old\n");
	for (;;)
	{
		if( ! fread (&tDxSpot, sizeof (tDxSpot), 1, fBinFile) )
			break;	/* EOF */
		fwrite (&tDxSpot, sizeof (tDxSpot), 1, fOldFile);
	}/* End FOR */

	fclose (fBinFile);
	fclose (fOldFile);

	fBinFile = fopen (szBin, "wb");
	if( ! fBinFile )	/* Error opening the file */
	{
		perror ("PURGDX -> fopen in MAIN (fBinOld 2)");
		return (3);
	}

	fOldFile = fopen (szOld, "rb");
	if( ! fOldFile )	/* Error opening the file */
	{
		perror ("PURGDX -> fopen in MAIN (fOldFile 2)");
		return (2);
	}

	for (;;)
	{
		time_t SpotTime;

		if( ! fread (&tDxSpot, sizeof (tDxSpot), 1, fOldFile) )
			break;	/* EOF */

		/* Is this spot to be killed ? */
		SpotTime = DATE_hms (tDxSpot.Date);
		if( difftime (time (NULL), SpotTime) < (86400L * (double) nDelDays) )
		{
		  /* No, copy it */
		  fwrite(&tDxSpot, sizeof (tDxSpot), 1, fBinFile);
		  lSpotNum++;
		}
		else
		{
		  /* Yes, do not copy it */
		  lDelSpotNum++;
		} /* End IF */
	} /* End FOR  */

	fclose (fOldFile);
	fclose (fBinFile);

	printf ("PURGDX completed : %ld spots left, %ld deleted.\n",
		lSpotNum, lDelSpotNum);

	return (0);
}

