#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#ifdef LINUX
#include <unistd.h>
#endif
#include "purgmail.h"
#include "purgdate.h"

/* This program is intended to purge both the DirMes.bin file and the
   messages files */

/* PURGEMAIL [d=DirMesPath] [m=MailPath] [b=#n_days] [p=#n_days] [v]

   where : - [d=DirMes path] specifies the directory in where dirmes.bin file
	     is located.
	     The default directory is SYSTEM\BIN.

	   - [m=MailPath] specifies the mail directory.
	     By default, this directory is set to MAIL

	   - [b=#n_days] sets the number of day (#n_days) after which a
	     bulletin will be deleted.
	     By default, this value is set to 30.

	   - [p=#n_days] sets the number of day (#n_days) after which a
	     private mail will be deleted.
	     By default, this value is set to 30.

	   - [v] gets the version number.

   Example : PURGMAIL p=C:\DXNET\SYSTEM\BIN m=C:\DXNET\MAIL p=10 b=15
	or : PURGMAIL p=20

*/


/*---------------------------------------------------------------------------
  ------ main function ------------------------------------------------------
  -------------------------------------------------------------------------*/
int main(int Argc, char * Argv[])
{
	int	index;
	char	szBinPath[1024];
	char	szMailPath[256];
	char	szBin[256];
	char	szOld[256];
	char	szMsg[256];
	FILE *	fDirMes;
	FILE *	fDirOld;
	BYTE	byDeleteMsg;
	int	nBullDelete = 30;
	int	nPrivDelete = 30;
	struct	DirMesStruct	tDirMes;

#ifdef LINUX
	strcpy (szBinPath,  "system/bin/");
	strcpy (szMailPath, "mail/");
#else
	strcpy (szBinPath,  "system\\bin\\");
	strcpy (szMailPath, "mail\\");
#endif

  /* Get the arguments */
	for(index = 1; index < Argc; index++)
	{

		switch( Argv[index][0] )
		{
			case 'p' :
			case 'P' :
				if( Argv[index][1] == '=' )
					nPrivDelete = atoi (Argv[index] + 2);
				break;

			case 'b' :
			case 'B' :
				if( Argv[index][1] == '=' )
					nBullDelete = atoi (Argv[index] + 2);
				break;

			case 'd' :
			case 'D' :
				if( Argv[index][1] == '=' )
					strcpy (szBinPath, Argv[index] + 2);
				break;

			case 'm' :
			case 'M' :
				if( Argv[index][1] == '=' )
					strcpy (szMailPath, Argv[index] + 2);
				break;

			case 'v' :
			case 'V' :
				printf("PURGMAIL v 1.4\n");
				break;
		}/* End SWITCH */
	}/* End FOR */

	/* Check arguments */
	if( nBullDelete <= 0 )
		nBullDelete = 1;
	if( nPrivDelete <= 0 )
		nPrivDelete = 1;

  /* Open DirMes.bin and DirMes.old */
#ifdef LINUX
	if( szBinPath[strlen (szBinPath)] == '/' )
		sprintf (szBin, "%s%s", szBinPath, "dirmes.bin");
	else
		sprintf (szBin, "%s/%s", szBinPath, "dirmes.bin");
#else
	if( szBinPath[strlen (szBinPath)] == '\\' )
		sprintf (szBin, "%s%s", szBinPath, "dirmes.bin");
	else
		sprintf (szBin, "%s\\%s", szBinPath, "dirmes.bin");
#endif
	strcpy (szOld, szBin);
	strcpy (szOld + strlen (szOld) - 4, ".old");

	fDirMes = fopen (szBin, "rb");
	if( ! fDirMes )	/* Error opening the file */
	{
		perror ("PURGMAIL -> fopen in MAIN (fDirMes 1)");
		return (1);
	}

	fDirOld = fopen (szOld, "w+b");
	if( ! fDirOld )	/* Error opening the file */
	{
		perror ("PURGMAIL -> fopen in MAIN (fDirOld)");
		return (2);
	}

	/* Copy dirmes.bin in dirmes.old */
	printf ("Creating dirmes.old\n");
	for (;;)
	{
		if( ! fread(&tDirMes, sizeof (tDirMes), 1, fDirMes) )
			break;	/* EOF */

		fwrite(&tDirMes, sizeof(tDirMes), 1, fDirOld);
	}

	fclose (fDirMes);
	fDirMes = fopen (szBin, "wb");
	if( ! fDirMes )	/* Error opening the file */
	{
		perror ("PURGMAIL -> fopen in MAIN (fDirMes 2)");
		return (3);
	}


	fseek (fDirOld, 0L, SEEK_SET);

	for (;;)
	{
		byDeleteMsg = FALSE;	/* Reset the flag */

		if( ! fread (&tDirMes, sizeof (tDirMes), 1, fDirOld) )
			break;	/* EOF */

		/* Is the mail killed ? */
		if( tDirMes.cStatus == STATUS_K )
		{
			/* Delete the message file */
			byDeleteMsg = TRUE;
		}
		else
		{
			time_t	tMsgTime;

			tMsgTime = DATE_hms (tDirMes.szDate);

			/* Is the message to be deleted ? */
			if( tDirMes.cType == 'P' )
			{
				if( difftime(time (NULL), tMsgTime) > (86400 * nPrivDelete) )
				byDeleteMsg = TRUE;
			}
			else
			{
				if( difftime(time (NULL), tMsgTime) > (86400 * nBullDelete) )
				byDeleteMsg = TRUE;
			}/* End IF */
		}/* End IF */

		if( byDeleteMsg && ! tDirMes.byNoAutoDelete)
		{
			/* Delete the mail */
			printf ("Deleting message #%ld ...\n", tDirMes.dwNumber);
			sprintf (szMsg, "%sm%07ld.msg", szMailPath, tDirMes.dwNumber);
			unlink (szMsg);
		}
		else
		{
			/* Copy the header */
			fwrite (&tDirMes, sizeof (tDirMes), 1, fDirMes);
		}/*End IF*/
	}/*End FOR*/

	fclose (fDirOld);
	fclose (fDirMes);

	printf("PURGMAIL completed.\n");

	return (0);
}

